/* variables used for course-specific text */
/* DEV NOTE indicates that the variable should be updated for the course */

$( document ).ready(function() {

	/* DEV NOTE: string for course title */
	document.courseTitle = "Procédures de gestion du risque d’évaluation boursière";

	/* DEV NOTE: strings for topic titles which are used in the pre-test results */
	document.topicTitles = {
		titles:[
			{title:"Bienvenue"},
			{title:"Méthodes d’évaluation"},
			{title:"Exceptions d’enregistrement des transactions"},
			{title:"Modèle Produit/Marché"},
			{title:"Documents sur le risque d’évaluation"},
			{title:"Contrôles des prix inchangés"},
			{title:"Évaluations de garanties et de clients"},
			{title:"Gouvernance et rapports"},
			{title:"Principaux points à retenir"},
			{title:"Évaluation"}
		]
	}	
		
	/* DEV NOTE: string for the intro text on the pre-test message that appears asking the learner if they want to take the pre-test; if there is no pre-test make this an empty string */
	document.pretestIntro = "<p>Connaissez-vous déjà la <strong>Gestion du risque lié au capital humain ?</strong></p><p>Si tel est le cas, cette formation vous permet de démontrer vos connaissances en effectuant un test de validation. La réussite du test vous permettra de suivre un parcours de formation accéléré tout en passant le contenu de la formation pour valider les crédits du cours.</p><p>Pour poursuivre vers le test de validation, cliquez sur le bouton Passer le test de validation.</p><p>Si vous préférez sauter le test de validation et passer directement au contenu, cliquez sur le bouton Commencer le cours.</p>";
	
	/* DEV NOTE: strings for text that is used on the pre-test and post-test intro pages; if there is no pre-test make the pre-test strings empty strings; if there is no post-test make the post-test strings empty strings */
	test_intro_dat = {
		pre_test:[{
			generic_msg:'<p>Bienvenue dans le test de validation.</p><p>Pour réussir cette évaluation, vous devrez répondre aux 10 questions suivantes et obtenir un score d’au moins 80 %.</p><p>Si vous n’obtenez pas ce score minimal, vous devrez revoir l’intégralité du contenu du cours et passer l’évaluation à la fin du cours.</p><ul><li>Vous disposez <b>d’un essai par question</b>.</li><li>	Vous devez passer le test de validation en une seule fois. Si vous quittez le test de validation avant la fin, vous ne pourrez pas le reprendre là où vous vous étiez arrêté et vous devrez revoir le contenu du cours.</li></ul>',
			/* DEV NOTE: string below can be used instead when there is a pre-test and there are no topics associated with test questions; otherwise delete */
			/*
			generic_msg:'<p>Bienvenue dans le test de validation.</p><p>Si vous répondez correctement à chacune des 5 questions suivantes, vous aurez la possibilité soit d’aller à la page d’achèvement du cours, soit de consulter l’intégralité du cours pour consolider vos connaissances sans avoir à passer l’évaluation de fin.</p><p>Si vous ne répondez pas correctement à toutes les questions, vous devrez suivre le cours en intégralité et réussir une évaluation finale pour prouver votre compréhension de la formation sur la <strong>Gestion du risque lié au capital humain</strong>.</p><ul><li>Vous disposez <strong>d’un essai par question</strong>.</li><li>Vous devez réussir le test de validation dès le premier essai. Si vous quittez le test de validation avant de l’avoir terminé, vous ne pourrez pas reprendre là où vous vous étiez arrêté.</li><li>Vous devez répondre correctement à toutes les questions du test de validation pour recevoir un crédit.</li></ul>',
			*/
			title:'Test de validation',
			subtitle:'Consignes pour le test de validation'
			
		}],
		post_test:[{
			generic_msg:'<p>Bienvenue dans l’évaluation finale. Les 10 questions suivantes vous permettent d’évaluer votre compréhension de cette formation.</p><p>Pour réussir l’évaluation et valider ce cours, vous devrez obtenir un score d’au moins 80 %.</p><p>Une fois l’évaluation commencée, vous devez répondre à toutes les questions pour enregistrer un score. Si vous quittez l’évaluation avant d’avoir répondu à toutes les questions, vous devrez recommencer l’évaluation depuis le début. </p>',
			title:'Évaluation',
			subtitle:'Consignes pour l’évaluation',			
			test_complete_title:'Formation terminée',
			test_complete_msg:'<p>Vous avez déjà reçu un certificat pour cette formation. L’évaluation finale n’est donc pas nécessaire et ne vous sera pas proposée. Merci !</p><p>Pour quitter le cours, fermez la fenêtre ou l’onglet dans lequel il a été ouvert.</p>'
		}],
		pre_test_nav:[{
			home_only:'Cliquez sur le bouton Revoir le contenu pour revoir les points de la formation.'
		}]
	}
	
	/* DEV NOTE: strings for text that is used on the pre-test and post-test results page before the score and for the pass and fail messages; if there is no pre-test make the pre-test strings empty strings; if there is no post-test make the post-test strings empty strings; when there is no limit to the post-test tries, make fail_max_msg an empty string for the post-test section; when there is a pre-test and there are no topics associated with test questions make all strings excluding pass_msg, fail_msg_3 and result_title empty strings for the pre-test section; when there is no requirement to review incorrect questions for a passed post-test, make pass_review_msg, result_review_msg_1, result_review_msg_2 and result_review_msg_3 empty strings for the post_test section. */
	test_results_dat = {
		pre_test:[{
			pass_msg:'<p>Félicitations !</p><p>Vous avez démontré une parfaite compréhension de la Gestion du risque lié au capital humain et avez rempli les conditions requises pour recevoir tout le crédit de validation de la formation.</p><p>Vous pouvez maintenant quitter le cours en fermant la fenêtre ou l’onglet dans lequel il s’est ouvert ou, si vous le souhaitez, revoir le contenu du cours en cliquant sur le bouton Revoir le contenu.</p>',
			pass_msg_2:'Félicitations ! Vous avez réussi le test de validation ! Vous avez validé le ou les sujets suivants :',
			pass_msg_3:'<p>Vous pouvez sauter le ou les sujets marqués comme validés, mais vous devez suivre la formation sur les autres sujets. Pour commencer, cliquez sur le bouton Revoir le contenu.</p><p>Une fois que vous aurez terminé, vous aurez achevé le cours. Félicitations !</p>',	
			pass_msg_4:'Le cours est marqué comme achevé, mais vous pouvez revoir les sujets qui n’ont pas été validés. Pour commencer, cliquez sur le bouton Revoir le contenu.',	
			fail_msg_1:'Malheureusement, vous n’avez pas obtenu le score minimal nécessaire pour réussir le test de validation et valider ce cours. Vous devez maintenant revoir le contenu du cours et passer l’évaluation à la fin du cours.',
			fail_msg_2:'<p>Malheureusement, vous n’avez pas obtenu le score minimal nécessaire pour réussir le test de validation et valider ce cours. Vous devez maintenant revoir le contenu du cours et passer l’évaluation à la fin du cours.</p>',
			fail_msg_3:'Malheureusement, vous n’avez pas obtenu le score minimal nécessaire pour réussir le test de validation et valider ce cours. Vous devez maintenant revoir le contenu du cours et passer l’évaluation à la fin du cours.',
			/* DEV NOTE: string below can be used instead when there is a pre-test and there are no topics associated with test questions; otherwise delete */
			/*
			fail_msg_3:'<p>Ce n’est pas tout à fait exact !</p><p>Vous n’avez pas obtenu le score minimal requis pour réussir le test et recevoir le crédit de validation du cours. Vous allez maintenant être redirigé vers le contenu complet du cours.</p><p>Pour commencer, cliquez sur le bouton Revoir le contenu.</p>',
			*/
			result_title:'Résultats du test de validation'
		}],
		post_test:[{
			generic_msg:'Vous avez obtenu : ',
			pass_msg:'<p>Félicitations !</p><p>Vous avez réussi l’évaluation et terminé le cours sur les Procédures de gestion du risque d’évaluation boursière.</p><p>Pour quitter le cours, fermez la fenêtre ou l’onglet dans lequel il a été ouvert.</p><p>Si vous voulez revoir le contenu du cours, cliquez sur le bouton Revoir le contenu.</p>',			
			pass_review_msg:'Vous pouvez faire défiler vers le bas pour voir les bonnes réponses aux questions auxquelles vous avez mal répondu.',
			fail_msg:'<p>Malheureusement, vous n’avez pas obtenu le score minimal nécessaire pour réussir l’évaluation. </p><p>Notez que vous avez la possibilité de revoir le contenu du cours en cliquant sur le bouton <b>Revoir le contenu</b> avant de repasser l’évaluation.</p>',
            fail_max_msg:'<p>Malheureusement, vous avez échoué trois fois au test.</p><p>Vous devez revoir les points de la formation.</p><p>Cliquez sur Reprendre la formation pour continuer.</p>',
			result_title:'Résultats de l’évaluation !',
			result_review_msg_1:'Question :',
			result_review_msg_2:'Options :',
			result_review_msg_3:'Commentaire :'
		}]
	}
	
	/* DEV NOTE: strings for text that is used on the attestation page before and after the attesting; if there is no attestation make these empty strings */
	attestation_dat = {		
		attestation:[{
			pre_attesting_msg:'<p>Veuillez certifier :</p><p>Je confirme par la présente avoir lu et pleinement compris le Processus de signalement du CID suisse, et m’engage à le respecter rigoureusement en toutes circonstances.</p>',
			attested_msg:'<p>Merci pour votre confirmation.</p><p>Félicitations ! Vous avez validé cette formation. Vous pouvez désormais quitter le cours. Merci de votre participation !</p>'
		}]
	}
	
	/* DEV NOTE: strings for the transcript titles and content separated by section id; if there are no transcripts make this variable an empty array */
	transcript_dat = {
		sec_3:[{
				title:'Transcription - Vidéo 1',			
				transcript:'<p></p>'
		}]
	}
	
	/* DEV NOTE: strings for the hotword titles and content separated by hotword id; if there are no hotwords make this variable an empty array */
	hotword_dat = {
		
		hw_1:[{
				title:'Exemple de mot-clé',				
				text:'<div class="align_left"><p>La définition d’Opération couverte dans la partie 23A comprend à la fois un prêt ou une extension de crédit par une banque à une société affiliée, ainsi que l’achat de titres par la banque ou son investissement dans des titres émis par une société affiliée.</p></div>'
		}]
	}
	
	/* DEV NOTE: strings for the link URLs separated by link id; if there are no links make this variable an empty array */
	link_dat = {
		lnk_1:[{
				url:'mailto:citi@citi.com'
		}],
		lnk_2:[{
				url:'https://policydirectory.citi.net/cpd/_layouts/15/DocIdRedir.aspx?ID=CPDPROD-13-10690'
		}],
		// lnk_3:[{
		// 		url:'images/Sample_PDF.pdf'
		// }]
		lnk_3:[{
				url:'https://policydirectory.citi.net/cpd/_layouts/15/DocIdRedir.aspx?ID=CPDPROD-13-11294&#x0026;PgId=srch'
		}],
		lnk_4:[{
				url:'https://icgshare.nam.citi.net/sites/ValRisk/_layouts/15/WopiFrame.aspx?sourcedoc=/sites/ValRisk/Valuation%20Uncertainty%20Document/Valuation%20Methodology%20and%20Uncertainty.pdf&action=default'
		}],
		lnk_5:[{
				url:'https://policydirectory.citi.net/cpd/_layouts/15/DocIdRedir.aspx?ID=CPDPROD-13-12536&PgId=srch'
		}],
		lnk_6:[{
				url:'https://icgshare.nam.citi.net/sites/ValRisk/CVA%20XVA%20Methodology/CVA%20Methodology.pdf?Web=1'
		}],
		lnk_7:[{
				url:'https://policydirectory.citi.net/cpd/_layouts/15/DocIdRedir.aspx?ID=CPDPROD-13-8157'
		}],
		lnk_8:[{
				url:'https://policydirectory.citi.net/cpd/_layouts/15/DocIdRedir.aspx?ID=CPDPROD-13-11722'
		}],
		lnk_9:[{
				url:'mailto:dl.markets.global.pmm@imceu.eu.ssmb.com'
		}],
		lnk_10:[{
				url:'https://citiriskcontrols.citigroup.net/mrms-vrt-ui/'
		}],
		lnk_11:[{
				url:'mailto:dl.mkts.global.vrd.users@imceu.eu.ssmb.com'
		}],
		lnk_12:[{
				url:'mailto:nacitivaluationsDL@imcnam.ssmb.com'
		}],
		lnk_13:[{
				url:'mailto:emea.valuationsDL@imceu.eu.ssmb.com'
		}],
		lnk_14:[{
				url:'https://policydirectory.citi.net/cpd/_layouts/15/DocIdRedir.aspx?ID=CPDPROD-13-11036&PgId=srch'
		}],
		lnk_15:[{
				url:'mailto:dl.mkts.global.valuation.risk@imcnam.ssmb.com'
		}],
		lnk_16:[{
				url:'https://policydirectory.citi.net/cpd/_layouts/15/DocIdRedir.aspx?ID=CPDPROD-13-8157'
		}],

	}
	
	/* DEV NOTE: strings for the resource popup title and content */
	resource_dat = {
		resources:[{
				title:'Ressources',				
				text:'<div class="align_left box-overflow"><p><a data-lnk-id="lnk_3" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Unchanged Pricing Procedures</a></p> <p><a data-lnk-id="lnk_4" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Valuation Uncertainty Document</a></p> <p><a data-lnk-id="lnk_5" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">XVA Methodology Document</a></p> <p><a data-lnk-id="lnk_6" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">CVA Methodology Document</a></p> <p><a data-lnk-id="lnk_7" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Pricing and Price Verification Policy</a></p> <p><a data-lnk-id="lnk_8" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Markets Valuation Risk Procedures</a></p> <p><a data-lnk-id="lnk_9" href="mailto:dl.markets.global.pmm@imceu.eu.ssmb.com" class="popup_neutral blue_color">*MKTS GLOBAL PMM</a></p> <p><a data-lnk-id="lnk_10" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Valuation Risk Document Tool (VRDT)</a></p> <p><a data-lnk-id="lnk_11" href="mailto:dl.mkts.global.vrd.users@imceu.eu.ssmb.com" class="popup_neutral blue_color">*MKTS GLOBAL VRD Users</a></p> <p><a data-lnk-id="lnk_12" href="mailto:nacitivaluationsDL@imcnam.ssmb.com" class="popup_neutral blue_color">*CIB US NA Citi Valuations</a></p> <p><a data-lnk-id="lnk_13" href="mailto:emea.valuationsDL@imceu.eu.ssmb.com" class="popup_neutral blue_color">*CIB UK EMEA Valuations</a></p> <p><a data-lnk-id="lnk_14" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Global Collateral, Client Valuation, and Fair Value Disclosures Standard</a></p> <p><a data-lnk-id="lnk_15" href="mailto:dl.mkts.global.valuation.risk@imcnam.ssmb.com" class="popup_neutral blue_color">*MKTS GLOBAL Valuation Risk</a></p></div>'
		}]
	}

	/* DEV NOTE: strings for LMS errors */
	lms_error_dat = {
		lms_error_1:[{
				text1:'L’IPA est introuvable.',
				text2:'La communication a été perdue. Veuillez fermer cette formation et la reprendre ultérieurement.<br>Ne poursuivez pas, car votre progression ou votre achèvement du cours ne seront pas enregistrés.<br>Vous pourrez reprendre là où vous avez effectué la dernière sauvegarde.'
        }]		
	}
});