/* variables used for course-specific text */
/* DEV NOTE indicates that the variable should be updated for the course */

$( document ).ready(function() {

	/* DEV NOTE: string for course title */
	document.courseTitle = "Procedimientos de Riesgo en las Valuaciones de Mercados";

	/* DEV NOTE: strings for topic titles which are used in the pre-test results */
	document.topicTitles = {
		titles:[
			{title:"Bienvenida"},
			{title:"Metodologías de valuación"},
			{title:"Excepciones en el registro de operaciones"},
			{title:"Modelo de Mercado del Producto"},
			{title:"Documentos de riesgo en las valuaciones"},
			{title:"Controles de precios sin variaciones"},
			{title:"Valuaciones del colateral y clientes"},
			{title:"Gobierno e informes"},
			{title:"Conclusiones principales"},
			{title:"Evaluación"}
		]
	}	
		
	/* DEV NOTE: string for the intro text on the pre-test message that appears asking the learner if they want to take the pre-test; if there is no pre-test make this an empty string */
	document.pretestIntro = "<p>¿Ya está familiarizado con la <strong>gestión del riesgo del capital humano?</strong></p><p>Si es así, esta capacitación le brinda una oportunidad para que demuestre sus conocimientos mediante la realización de una prueba. La terminación exitosa de la prueba le permitirá tomar un camino acelerado de la capacitación en el que se omitirán los contenidos y, directamente, recibirá crédito por el curso.</p><p>Para continuar con la prueba, seleccione el botón Realizar la prueba.</p><p>Si prefiere saltarse la prueba e ir directamente al contenido, seleccione el botón Iniciar el curso.</p>";
	
	/* DEV NOTE: strings for text that is used on the pre-test and post-test intro pages; if there is no pre-test make the pre-test strings empty strings; if there is no post-test make the post-test strings empty strings */
	test_intro_dat = {
		pre_test:[{
			generic_msg:'<p>Bienvenido a la prueba.</p><p>Para aprobar la evaluación, debe responder las 10 preguntas a continuación y obtener un puntaje del 80 % o más.</p><p>Si no logra una calificación de aprobación, deberá revisar el contenido completo del curso y realizar la evaluación al finalizar el curso.</p><ul><li>Dispone de <b>un intento por pregunta</b>.</li><li>	Debe completar la prueba en un solo intento; si sale de la prueba antes de terminarla, no podrá continuar donde quedó y deberá revisar el contenido del curso nuevamente.</li></ul>',
			/* DEV NOTE: string below can be used instead when there is a pre-test and there are no topics associated with test questions; otherwise delete */
			/*
			generic_msg:'<p>Bienvenido a la prueba.</p><p>Si responde correctamente a cada una de las siguientes 5 preguntas, tendrá la opción de navegar hasta la página de terminación del curso o revisar el contenido completo del curso para reforzar su comprensión sin necesidad de realizar la evaluación al final.</p><p>Si no puede responder correctamente a todas las preguntas, se le pedirá que realice el curso completo y complete con éxito una evaluación final para demostrar su comprensión de la capacitación sobre los <strong>Fundamentos del Riesgo de Crédito de Terceros</strong>.</p><ul><li>Dispone de <strong>un intento por pregunta</strong>.</li><li>Debe completar la prueba en un solo intento. Si sale de la prueba antes de terminarla, no podrá continuar donde quedó.</li><li>Debe responder correctamente a todas las preguntas de la prueba para recibir crédito.</li></ul>',
			*/
			title:'Realizar prueba',
			subtitle:'Instrucciones para realizar la prueba'
			
		}],
		post_test:[{
			generic_msg:'<p>Bienvenido a la evaluación final. Las siguientes 10 preguntas le brindan la oportunidad de demostrar qué tan bien comprende lo que ha aprendido.</p><p>Para aprobar la evaluación y recibir créditos por el curso, debe obtener un puntaje mínimo del 80 %.</p><p>Una vez que comience la evaluación, debe completar todas las preguntas para registrar una puntuación. Si sale antes de contestar todas las preguntas de la evaluación deberá volver a iniciar la evaluación. </p>',
			title:'Evaluación',
			subtitle:'Instrucciones para la evaluación',			
			test_complete_title:'Capacitación completa',
			test_complete_msg:'<p>Dado que ya ha recibido una terminación por esta capacitación, la evaluación final no es necesaria y no se presentará. ¡Gracias!</p><p>Para cerrar el curso cierre la ventana o pestaña en la que está abierto.</p>'
		}],
		pre_test_nav:[{
			home_only:'Seleccione el botón Revisar contenido para revisarlo.'
		}]
	}
	
	/* DEV NOTE: strings for text that is used on the pre-test and post-test results page before the score and for the pass and fail messages; if there is no pre-test make the pre-test strings empty strings; if there is no post-test make the post-test strings empty strings; when there is no limit to the post-test tries, make fail_max_msg an empty string for the post-test section; when there is a pre-test and there are no topics associated with test questions make all strings excluding pass_msg, fail_msg_3 and result_title empty strings for the pre-test section; when there is no requirement to review incorrect questions for a passed post-test, make pass_review_msg, result_review_msg_1, result_review_msg_2 and result_review_msg_3 empty strings for the post_test section. */
	test_results_dat = {
		pre_test:[{
			pass_msg:'<p>¡Felicitaciones!</p><p>Usted ha demostrado una sólida comprensión de los Fundamentos del Riesgo de Crédito de Terceros y ha completado los requisitos para recibir el crédito completo por la capacitación.</p><p>Ya puede salir del curso; para hacerlo cierre la ventana o pestaña en la que está abierto, o bien, si lo desea, revise el contenido del curso seleccionando el botón Revisar contenido.</p>',
			pass_msg_2:'¡Felicitaciones, ha completado con éxito la prueba! Ha realizado las pruebas del/de los siguiente(s) tema(s):',
			pass_msg_3:'<p>Puede omitir el/los tema(s) marcado(s) como aprobado(s), pero debe realizar la capacitación sobre los temas restantes. Seleccione el botón Inicio para comenzar.</p><p>Una vez hecho esto, habrá completado el curso. ¡Bien hecho!</p>',	
			pass_msg_4:'El curso está marcado como completo, pero quizás desee revisar los temas que no se marcaron como aprobados. Seleccione el botón Inicio para comenzar.',	
			fail_msg_1:'Lamentablemente, no alcanzó la puntuación mínima necesaria para aprobar la prueba y recibir créditos por el curso. Ahora debe revisar el contenido del curso y completar la evaluación al final.',
			fail_msg_2:'<p>Lamentablemente, no alcanzó la puntuación mínima necesaria para aprobar la prueba y recibir créditos por el curso. Ahora debe revisar el contenido del curso y completar la evaluación al final.</p>',
			fail_msg_3:'Lamentablemente, no alcanzó la puntuación mínima necesaria para aprobar la prueba y recibir créditos por el curso. Ahora debe revisar el contenido del curso y completar la evaluación al final.',
			/* DEV NOTE: string below can be used instead when there is a pre-test and there are no topics associated with test questions; otherwise delete */
			/*
			fail_msg_3:'<p>No exactamente.</p><p>No alcanzó la puntuación mínima necesaria para completar con éxito la prueba y recibir créditos por el curso. Ahora será dirigido al contenido completo del curso.</p><p>Seleccione el botón Inicio para comenzar.</p>',
			*/
			result_title:'Resultados de la prueba'
		}],
		post_test:[{
			generic_msg:'Su puntaje fue el siguiente: ',
			pass_msg:'<p>¡Felicitaciones!</p><p>Aprobó con éxito la evaluación y completó el curso Procedimientos de Riesgo en las Valuaciones de Mercados.</p><p>Para cerrar el curso cierre la ventana o pestaña en la que está abierto.</p><p>Si desea revisar el contenido del curso, seleccione el botón Revisar contenido.</p>',			
			pass_review_msg:'Puede desplazarse hacia abajo para ver la respuesta correcta de cualquier pregunta que contestó mal.',
			fail_msg:'<p>Lamentablemente, no alcanzó la puntuación mínima necesaria para aprobar la evaluación. </p><p>Tenga en cuenta que tiene la opción de revisar el contenido nuevamente seleccionando el botón <b>Revisar contenido</b> antes de volver a realizar la evaluación.</p>',
            fail_max_msg:'<p>Desafortunadamente, no aprobó tres veces.</p><p>Parece que debe volver a revisar el contenido del curso.</p><p>Seleccione Volver a realizar curso para continuar.</p>',
			result_title:'¡Resultados de la evaluación!',
			result_review_msg_1:'Pregunta:',
			result_review_msg_2:'Opciones:',
			result_review_msg_3:'Retroalimentación:'
		}]
	}
	
	/* DEV NOTE: strings for text that is used on the attestation page before and after the attesting; if there is no attestation make these empty strings */
	attestation_dat = {		
		attestation:[{
			pre_attesting_msg:'<p>Por favor, certifique:</p><p>Por la presente, confirmo que he leído y entendido completamente el proceso de escalamiento de CID suizo y que lo cumpliré estrictamente en todo momento.</p>',
			attested_msg:'<p>Gracias por su confirmación.</p><p>¡Felicitaciones! Ha completado correctamente esta capacitación. Ahora ya puede salir. ¡Gracias por participar!</p>'
		}]
	}
	
	/* DEV NOTE: strings for the transcript titles and content separated by section id; if there are no transcripts make this variable an empty array */
	transcript_dat = {
		sec_3:[{
				title:'Transcripción: Video 1',			
				transcript:'<p></p>'
		}]
	}
	
	/* DEV NOTE: strings for the hotword titles and content separated by hotword id; if there are no hotwords make this variable an empty array */
	hotword_dat = {
		
		hw_1:[{
				title:'Ejemplo de palabra clave',				
				text:'<div class="align_left"><p>La definición de Transacción Cubierta en la Sección 23A incluye un préstamo o una extensión de crédito por parte de un banco a un afiliado y la compra o inversión por parte de un banco de acciones emitidas por un afiliado.</p></div>'
		}]
	}
	
	/* DEV NOTE: strings for the link URLs separated by link id; if there are no links make this variable an empty array */
	link_dat = {
		lnk_1:[{
				url:'mailto:citi@citi.com'
		}],
		lnk_2:[{
				url:'https://policydirectory.citi.net/cpd/_layouts/15/DocIdRedir.aspx?ID=CPDPROD-13-10690'
		}],
		// lnk_3:[{
		// 		url:'images/Sample_PDF.pdf'
		// }]
		lnk_3:[{
				url:'https://policydirectory.citi.net/cpd/_layouts/15/DocIdRedir.aspx?ID=CPDPROD-13-11294&#x0026;PgId=srch'
		}],
		lnk_4:[{
				url:'https://icgshare.nam.citi.net/sites/ValRisk/_layouts/15/WopiFrame.aspx?sourcedoc=/sites/ValRisk/Valuation%20Uncertainty%20Document/Valuation%20Methodology%20and%20Uncertainty.pdf&action=default'
		}],
		lnk_5:[{
				url:'https://policydirectory.citi.net/cpd/_layouts/15/DocIdRedir.aspx?ID=CPDPROD-13-12536&PgId=srch'
		}],
		lnk_6:[{
				url:'https://icgshare.nam.citi.net/sites/ValRisk/CVA%20XVA%20Methodology/CVA%20Methodology.pdf?Web=1'
		}],
		lnk_7:[{
				url:'https://policydirectory.citi.net/cpd/_layouts/15/DocIdRedir.aspx?ID=CPDPROD-13-8157'
		}],
		lnk_8:[{
				url:'https://policydirectory.citi.net/cpd/_layouts/15/DocIdRedir.aspx?ID=CPDPROD-13-11722'
		}],
		lnk_9:[{
				url:'mailto:dl.markets.global.pmm@imceu.eu.ssmb.com'
		}],
		lnk_10:[{
				url:'https://citiriskcontrols.citigroup.net/mrms-vrt-ui/'
		}],
		lnk_11:[{
				url:'mailto:dl.mkts.global.vrd.users@imceu.eu.ssmb.com'
		}],
		lnk_12:[{
				url:'mailto:nacitivaluationsDL@imcnam.ssmb.com'
		}],
		lnk_13:[{
				url:'mailto:emea.valuationsDL@imceu.eu.ssmb.com'
		}],
		lnk_14:[{
				url:'https://policydirectory.citi.net/cpd/_layouts/15/DocIdRedir.aspx?ID=CPDPROD-13-11036&PgId=srch'
		}],
		lnk_15:[{
				url:'mailto:dl.mkts.global.valuation.risk@imcnam.ssmb.com'
		}],
		lnk_16:[{
				url:'https://policydirectory.citi.net/cpd/_layouts/15/DocIdRedir.aspx?ID=CPDPROD-13-8157'
		}],

	}
	
	/* DEV NOTE: strings for the resource popup title and content */
	resource_dat = {
		resources:[{
				title:'Recursos',				
				text:'<div class="align_left box-overflow"><p><a data-lnk-id="lnk_3" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Unchanged Pricing Procedures</a></p> <p><a data-lnk-id="lnk_4" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Valuation Uncertainty Document</a></p> <p><a data-lnk-id="lnk_5" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">XVA Methodology Document</a></p> <p><a data-lnk-id="lnk_6" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">CVA Methodology Document</a></p> <p><a data-lnk-id="lnk_7" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Pricing and Price Verification Policy</a></p> <p><a data-lnk-id="lnk_8" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Markets Valuation Risk Procedures</a></p> <p><a data-lnk-id="lnk_9" href="mailto:dl.markets.global.pmm@imceu.eu.ssmb.com" class="popup_neutral blue_color">*MKTS GLOBAL PMM</a></p> <p><a data-lnk-id="lnk_10" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Valuation Risk Document Tool (VRDT)</a></p> <p><a data-lnk-id="lnk_11" href="mailto:dl.mkts.global.vrd.users@imceu.eu.ssmb.com" class="popup_neutral blue_color">*MKTS GLOBAL VRD Users</a></p> <p><a data-lnk-id="lnk_12" href="mailto:nacitivaluationsDL@imcnam.ssmb.com" class="popup_neutral blue_color">*CIB US NA Citi Valuations</a></p> <p><a data-lnk-id="lnk_13" href="mailto:emea.valuationsDL@imceu.eu.ssmb.com" class="popup_neutral blue_color">*CIB UK EMEA Valuations Reino Unido EMEA</a></p> <p><a data-lnk-id="lnk_14" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Global Collateral, Client Valuation, and Fair Value Disclosures Standard</a></p> <p><a data-lnk-id="lnk_15" href="mailto:dl.mkts.global.valuation.risk@imcnam.ssmb.com" class="popup_neutral blue_color">*MKTS GLOBAL Valuation Risk</a></p></div>'
		}]
	}

	/* DEV NOTE: strings for LMS errors */
	lms_error_dat = {
		lms_error_1:[{
				text1:'No se puede encontrar la API.',
				text2:'Se ha perdido la comunicación. Cierre este curso de capacitación y reinícielo más tarde.<br>No continúe, ya que no se realizará un seguimiento de su progreso o finalización.<br>Podrá reiniciar desde el último punto de guardado exitoso.'
        }]		
	}
});