﻿document.contentLaunched = true; //describes if an actual sco_content file has been launched. Need this so we know if we have to call commit/finish on the LMS.
document.path = '';

document.wrapperInit = false;

document.switchLang = false; /* 20221130 Update to language selection and bookmark functionality */

document.inCourse = false; /* 20230127 Fixed issue with course completing when closing on lang screen (SCORM Cloud) */ 

var snifferPagePreferences = {
	"closePanels": false,
	"snifferBookmark" : false,
	"langPreference" : "en",
	"userTypePreference" : "",
	"htmlOrFlashVersionChosen" : "h", /* can be "h" or "f" */
	"startTime" : new Date() /*not a preference - but a convenient place to store this for the purposes of time tracking*/	
}



var findAPITries = 0;

function findAPI(win)
{
   // Check to see if the window (win) contains the API
   // if the window (win) does not contain the API and
   // the window (win) has a parent window and the parent window  
   // is not the same as the window (win)
   while ( (win.API == null) && 
           (win.parent != null) && 
           (win.parent != win) )
   {	
      // increment the number of findAPITries
      findAPITries++;

      // Note: 7 is an arbitrary number, but should be more than sufficient
      if (findAPITries > 7) 
      {
         alert("Can't find API");
         return null;
      }
      
      // set the variable that represents the window being 
      // being searched to be the parent of the current window
      // then search for the API again
      win = win.parent;
   }
   return win.API;
}

//  
// Function: getAPI()
// Parameters: none 
// Returns: null if API could not be located, 
//		a handle to API adapter is returned if the API was located.
//
// Description: Locate the SCORM API Adaptor
//
function getAPI()
{
   // start by looking for the API in the current window
   var theAPI = findAPI(window);

   // if the API is null (could not be found in the current window)
   // and the current window has an opener window
   if ( (theAPI == null) && 
        (window.opener != null) && 
        (typeof(window.opener) != "undefined") )
   {
      // try to find the API in the current window's opener
      theAPI = findAPI(window.opener);
   }

   // if the API is null (could not be found in the current window,
   // or the current windows opener) see if the opener of the topmost
   // window contains the api
   // and the current window has an opener window
   if ( (theAPI == null) && 
        (window.top.opener != null) && 
        (typeof(window.top.opener) != "undefined") )
   {
      // try to find the API in the current window's opener
      theAPI = findAPI(window.top.opener);
   }

   // if the API has not been found
   if (theAPI == null)
   {
      // Alert the user that the API Adapter could not be found
      //Remove below as this is now taken care of by versioning pages - IR 1816
      //alert("Unable to find an API adapter");
   }
   return theAPI;
}
//get a handle on the LMS' API. 
document.scormAPI = getAPI();
if(document.scormAPI != null){
	document.scormAPI.LMSInitialize('');
	document.wrapperInit = true;
}

/**
 * called by the main window onload
 */
//function init(){
    //window.onunload = function () { end(); };
window.onbeforeunload = function(){end();} /* 20230127 Fixed issue with course completing when closing on lang screen (SCORM Cloud) */ 
//}

function beforeEnd(){
	end();
}

function end(){
    //tg 13/06/07 - coping with before unload.
    //alert('end 1');
	if(document.ended){
		return;
	}else{
		document.ended = true;
	}
	
	//tg 10/01/07 - only call these if the actual content has not been launched and we have only visited the sniffer page.
	if(document.contentLaunched == true){
	    if (document.scormAPI) {
			//reach inside the content and call its scorm commit code.
			//finishSCO();
		}
	}
	//finish up with the LMS.
	
	
	if(document.scormAPI){
		if(!parent.document.inCourse){ /* 20230127 Fixed issue with course completing when closing on lang screen (SCORM Cloud) */ 
			document.scormAPI.LMSCommit('')
			document.scormAPI.LMSFinish('');
		}
	}
	
}


