/* variables used for course-specific text */
/* DEV NOTE indicates that the variable should be updated for the course */

$( document ).ready(function() {

	/* DEV NOTE: string for course title */
	document.courseTitle = "Lessons Learned: Lifecycle, Events & Challenge (ERMTP – Basic)";

	/* DEV NOTE: strings for topic titles which are used in the pre-test results */
	document.topicTitles = {
		titles:[
			{title:"Welcome"},
			{title:"Lessons Learned Lifecycle"},
			{title:"Event Identification & Event Assignment"},
			{title:"Event Analysis, Report Development & Independent Challenge"},
			{title:"Publication & Sharing"},
			{title:"Summary"},
			{title:"Assessment"}
		]
	}	
		
	/* DEV NOTE: string for the intro text on the pre-test message that appears asking the learner if they want to take the pre-test; if there is no pre-test make this an empty string */
	document.pretestIntro = "<p>Are you already familiar with <strong>Human Capital Risk Management?</strong></p><p>If so, this training includes an opportunity for you to demonstrate your knowledge by completing a test out. Successful completion of the test out will allow you to take an accelerated path through the training by skipping the training content to receive credit for the course.</p><p>To continue to the test out, select the Take the Test Out button.</p><p>If you prefer to skip the test out and go straight to the content, select the Start the Course button.</p>";
	
	/* DEV NOTE: strings for text that is used on the pre-test and post-test intro pages; if there is no pre-test make the pre-test strings empty strings; if there is no post-test make the post-test strings empty strings */
	test_intro_dat = {
		pre_test:[{			
			generic_msg:'<p>Welcome to the Test Out.</p><p>If you answer the following 5 questions and achieve a minimum score of 80%, you’ll have the option to navigate to the course completion page or review the full course content to reinforce your understanding without needing to take the assessment at the end.</p><p>If you’re unable to achieve a minimum score of 80%, you’ll be required to take the full course and successfully complete a final assessment to demonstrate your comprehension of the <strong>Lessons Learned: Lifecycle, Events & Challenge (ERMTP – Basic)</strong> training.</p><ul><li>You have <strong>one attempt per question</strong>.</li><li>You must complete the Test Out in a single attempt. If you exit the Test Out before completion, you will not be able to resume where you left off.</li><li>You must answer all test-out questions with a minimum score of 80% to receive credit.</li></ul>',
			title:'Test Out',
			subtitle:'Test Out Instructions'
			
		}],
		post_test:[{
			generic_msg:'<p>The following <span class="bold_txt">5 questions </span>give you the opportunity to demonstrate how well you understand what you’ve learned.</p><p>To pass the assessment, you must achieve a minimum score of <span class="bold_txt">80%</span>.</p><p>Once you begin the assessment, you need to complete all the questions to register a score. This will appear on the results page following the final question.</p>',
			title:'Assessment',
			subtitle:'Assessment Instructions',
			test_complete_title:'Training Completed',
			test_complete_msg:'<p>Since you have already received a completion for this training, the final assessment is not required and will not be presented. Thank you!</p><p>To exit the training, close the window or tab in which it opened.</p>'
		}],
		pre_test_nav:[{
			home_only:'Select the Review Content button to review the content.'
		}]
	}
	
	/* DEV NOTE: strings for text that is used on the pre-test and post-test results page before the score and for the pass and fail messages; if there is no pre-test make the pre-test strings empty strings; if there is no post-test make the post-test strings empty strings; when there is no limit to the post-test tries, make fail_max_msg an empty string for the post-test section; when there is a pre-test and there are no topics associated with test questions make all strings excluding pass_msg, fail_msg_3 and result_title empty strings for the pre-test section; when there is no requirement to review incorrect questions for a passed post-test, make pass_review_msg, result_review_msg_1, result_review_msg_2 and result_review_msg_3 empty strings for the post_test section. */
	test_results_dat = {
		pre_test:[{			
			pass_msg:'<p>Congratulations!</p><p>You have demonstrated a strong understanding of the Lessons Learned Lifecycle and have completed the requirements to receive full credit for the training.</p><p>All training content is now unlocked. If you would like to review the unlocked content, select the Review Content button.</p><p>To receive credit for this training, close the window or tab in which it opened.</p>',
			pass_msg_2:'',
			pass_msg_3:'',	
			pass_msg_4:'',	
			fail_msg_1:'',
			fail_msg_2:'',			
			fail_msg_3:'<p>Not quite.</p><p>You did not achieve the minimum score required to successfully complete the test out and receive credit for the course. You will now be taken to the full course content.</p><p>Please select the Review Content button to get started.</p>',			
			result_title:'Test Out Results'
		}],
		post_test:[{
			generic_msg:'You scored: ',
			pass_msg:'<p>Congratulations!</p><p>You have successfully passed the assessment. To receive credit for this training, close the window or tab in which it opened.</p><p>Select the Review Content button if you would like to review the course content.</p>',			
			pass_review_msg:'You can scroll down to see the correct answer for any question you got incorrect.',
			fail_msg:'<p>Unfortunately, you have not passed the assessment.</p><p>Select the Retake Assessment button to try again or select the Review Content button to review the content before retaking the assessment.</p>',
            fail_max_msg:'<p>Unfortunately, you have failed the test three times.</p><p>Looks like you need to review the course content again.</p><p>Select Retake Course to continue.</p>',
			result_title:'Assessment Results!',			
			result_review_msg_1:'Question:',
			result_review_msg_2:'Options:',
			result_review_msg_3:'Feedback:'
		}]
	}
	
	/* DEV NOTE: strings for text that is used on the attestation page before and after the attesting; if there is no attestation make these empty strings */
	attestation_dat = {		
		attestation:[{
			pre_attesting_msg:'<p>Please certify:</p><p>I hereby confirm that I have read and fully understood the Swiss CID Escalation Process and that I will strictly adhere to it at all times.</p>',
			attested_msg:'<p>Thank you for your confirmation.</p><p>Congratulations! You have successfully completed this training. You are now free to exit. Thank you for participating!</p>'
		}]
	}
	
	/* DEV NOTE: strings for the transcript titles and content separated by section id; if there are no transcripts make this variable an empty array */
	transcript_dat = {
		sec_3:[{
				title:'Transcript - Video 1',			
				transcript:'<p></p>'
		}]
	}
	
	/* DEV NOTE: strings for the hotword titles and content separated by hotword id; if there are no hotwords make this variable an empty array */
	hotword_dat = {
		
		hw_1:[{
				title:'Sample Hotword',				
				text:'<div class="align_left"><p>The definition of Covered Transaction in Section 23A includes both a loan or extension of credit by a bank to an affiliate and a bank\'s purchase of, or investment in, securities issued by an affiliate.</p></div>'
		}]
	}
	
	/* DEV NOTE: strings for the link URLs separated by link id; if there are no links make this variable an empty array */
	link_dat = {
		lnk_1:[{
			/* Enterprise Risk Management Framework */
			   url: 'https://citi.hostedconnectedrisk.com/CitiCPD/autologin?&L=2&SuccessHref=BASE64_cGFnZX4zRH4xT34ySW5zdGFuY2VOb34xNjQzNTE3fjJIdG1GaWxlfjFpbnN0YW5jZVBvbGljeVVzZXJfVmlldy5odG1+MkNJRH4xc2lkMjk3NTE4NDMyfjJYfjExLjcyNjA4NzAxMzg0N0UxMg==&anycookie=1'
			}],
		lnk_2:[{
			/* Lessons Learned Central Procedures */
			   url:'https://citi.hostedconnectedrisk.com/CitiCPD/autologin?&L=2&SuccessHref=BASE64_cGFnZX4zRH4xT34ySW5zdGFuY2VOb34xNjQzMTE0fjJIdG1GaWxlfjFpbnN0YW5jZVBvbGljeVVzZXJfVmlldy5odG1+MkNJRH4xc2lkMjU0NDk0MzcxfjJYfjExLjcyODA1OTA0NDQzMkUxMg==&anycookie=1'
		}],
		lnk_3:[{
			/* Lessons Learned Policy */
			   url:'https://citi.hostedconnectedrisk.com/CitiCPD/autologin?&L=2&SuccessHref=BASE64_cGFnZX4zRH4xT34ySW5zdGFuY2VOb34xNjQzMDU5fjJIdG1GaWxlfjFpbnN0YW5jZVBvbGljeVVzZXJfVmlldy5odG1+MkNJRH4xc2lkMjU0NDk0MzcxfjJYfjExLjcyODA1OTA1Mzk1MUUxMg==&anycookie=1'
		}],
		lnk_4:[{
			/* Operational Risk Management Communication and Training */
			url:'https://citi.sharepoint.com/sites/operational-risk-management/SitePages/orm-speaker-series.aspx'
		}],
		lnk_5:[{
			/* Operational Risk Management Communication and Training */
			url:'https://policydirectory.citi.net/cpd/_layouts/15/DocIdRedir.aspx?ID=CPDPROD-13-11070&PgId=srch'
		}],
		lnk_6:[{
			/* Escalation Policy */
			url:'https://citi.hostedconnectedrisk.com/CitiCPD/autologin?&L=2&SuccessHref=BASE64_cGFnZX4zRH4xT34ySW5zdGFuY2VOb34xNjQyNjc5fjJIdG1GaWxlfjFpbnN0YW5jZVBvbGljeVVzZXJfVmlldy5odG1+MkNJRH4xc2lkNjk0ODk0MjF+Mlh+MTEuNzI5NjEwMTA5NDY0RTEy&anycookie=1'
		}]
		
	}
	
	/* DEV NOTE: strings for the resource popup title and content */
	resource_dat = {
		resources:[{
				title:'Resources',				
				text:'<div class="align_left"><p><a data-lnk-id="lnk_3" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Citi Global Lessons Learned Policy</a></p><p><a data-lnk-id="lnk_2" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Citi Global Lessons Learned Central Procedure</a></p><p><a data-lnk-id="lnk_4" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Operational Risk Management Communication and Training</a></p><p><a data-lnk-id="lnk_1" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Enterprise Risk Management Framework</a></p><p><a data-lnk-id="lnk_6" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Escalation Policy</a></p></div>'
		}]
	}

	/* DEV NOTE: strings for LMS errors */
	lms_error_dat = {
		lms_error_1:[{
				text1:'API cannot be found.',
				text2:'Communication has been lost. Please close this training course and restart it at a later time.<br>Do not continue as your progress or completion will not be tracked.<br>You will be able to restart from the last successful save point.'
        }]		
	}
});