/* functions to control display of dialogue boxes used for bookmark, hotwords, transcript and error messages */

$('.dialogue_pop').on('click', function() {
	whatPop(this)
});

/* keyboard functionality */
$('.dialogue_pop').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {
		
		$(this).trigger('click');
	}		
});

$('.hotspot_reveal').on('click', 'a', function() {
	whatPop(this)	
})

/* keyboard functionality */
$('.hotspot_reveal').on('keypress', 'a', function() {
	$(this).trigger('click');
})

$('.hotspot_reveal').on('keypress', '.popup_pop', function() {
	$(this).trigger('click');	
})

var butReturnFocus;

function whatPop(selector){
	
	butReturnFocus = selector;
	
	if($(selector).hasClass('transcript_btn')){
		var section = $(selector).closest('.section').attr('id');
		var pop_type = 'transcript';
		boxPop(section, pop_type);
		document.intComplete = true; // Unlock video when transcript opened
		isPageComplete(Number(section.split("_")[1])); // Unlock video when transcript opened
	}else if($(selector).hasClass('hotword')){			
		var hotword_sec = '#'+$(selector).closest('.section').attr('id');
		//var secNum = hotword_sec.split('_')[1];
		//findHotWordNum(secNum)

		//var word = $(selector).text();
		var word = $(selector).attr('data-hw-id');
		var pop_type = 'hot_word';
		boxPop(word, pop_type);			
		isHotWordDone(hotword_sec);			
		if($(selector).hasClass('hotword_neutral') && !($(selector).hasClass('hotword_neutral_visited'))){
			$(selector).addClass('hotword_neutral_visited');
		}
	}else if($(selector).hasClass('page')){			
		var word = $(selector).text();
		var pop_type = 'resources';
		boxPop('resources', pop_type);
		$(selector).addClass('page_visited');
	}else if($(selector).hasClass('popup_pop')){		
		var lnkURL = link_dat[$(selector).attr('data-lnk-id')][0].url;
		var winName = 'name_' + $(selector).attr('data-lnk-id');
		var lnkWin = window.open(lnkURL,winName,'resizable=1,scrollbars=1,width=815,height=800');
		lnkWin.focus();
	}	
}

$('.popup_pop').click(function() {
	if($(this).hasClass('popup_neutral') && !($(this).hasClass('popup_neutral_visited'))){
		$(this).addClass('popup_neutral_visited');
	}
});

/* keyboard functionality */
$('.popup_pop').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {
		$(this).trigger('click');
	}		
});

$('.box_closer').click(function() {
	closeErrorPopupOrCourse();
});

/* keyboard functionality */
$('.box_closer').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {
		
		$(this).trigger('click');
	}		
});

/* 20221019 ensure popup window is focused on and cannot be tabbed out of */
/* 20240130 accessibility 2024 */
$('.box_closer').on('keydown', function(e) {
	if ((e.which == 9) && (!e.shiftKey)) {
		e.preventDefault();
		$('.box_title').focus();
	}
});

/* 20221019 ensure popup window is focused on and cannot be tabbed out of */
/* 20240130 accessibility 2024 */
$('.box_closer').on('keydown', function(e) {
	if ((e.which == 9) && (e.shiftKey)) {
		e.preventDefault();
		$('.box_title').focus();
	}
});

$( window ).resize(function() {
	 $('.box_holder:visible').not('.bookmark').css({
        'position' : 'absolute',
        'top' : '50%',
        'margin-top' : -$('.box_holder:visible').outerHeight()/2
    });
	if($('.box_nav_holder:visible').height() > $(window.parent).height()){
		$('.dialogue_box').not('.bookmark').addClass('box_overflow');
		$('.box_holder').not('.bookmark').addClass('box_static');
	    $('.box_holder:visible').css({'margin-top' : 0})
	}else{
		$('.dialogue_box').not('.bookmark').removeClass('box_overflow');
		$('.box_holder').not('.bookmark').removeClass('box_static');
	}
});

function boxPop(section, pop_type, error_title, error_mess){
	
	/* 20180501 Accessibility remove tab funcitonality */
	popupKeyDown = true; 
	removeMenuTabIndex();
	removeTabIndex();
	/* 20180501 Accessibility remove tab funcitonality */
    
    $('.dialogue_box').removeClass("preTestBG");
    $('.box_holder').removeClass("putBottom");
	
	/* hide the section containing the bookmark buttons */
	$('.box_holder .box_bottom').hide();
	/* only show the error popup if an error is currently being processed */	
	if ((!document.errorMessagePresent && !document.errorNotifyPresent) || (pop_type == 'error'))
	{
		if(isWeb){
			//$("html, body").disableScroll(); /* disable scroll bar */
			$('html, body').css('overflow-y','hidden');
		}else{
			$('html, body').css('overflow-y','hidden');
		}
		$('.box_closer').show(); /* show close button */


		if(pop_type == 'transcript'){
			$('.box_holder .box_title').html(transcript_dat[section][0].title);
			$('.box_holder .box_message').html(transcript_dat[section][0].transcript);

			/* 20240130 accessibility 2024 */
			$('.box_top_btn').attr('aria-hidden', false);

			/* 20180501 Accessibility Apply tab functionality to popup */
			if(popupKeyDown){
				var tabCnt = 0;
				/* 20240130 accessibility 2024 */
				tabCnt++;
				$('.box_closer').attr('tabindex', tabCnt);
				$('.box_closer').attr('aria-hidden', false);
				tabCnt++;
				$('.box_title').attr('tabindex', tabCnt);
				$('.box_title').attr('aria-hidden', false);
				tabCnt++;
				$('.box_message').attr('tabindex', tabCnt);
				$('.box_message').attr('aria-hidden', false);
				$('.box_middle').find('a').each(function(index, element) {	
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					$(this).attr('aria-hidden', false);
					$(this).on('keypress', function() {
						$(this).trigger('click');
					})
				});
				/* 20221019 ensure popup window is focused on and cannot be tabbed out of */
				$('.box_title').on('keydown', function(e) {
					if ((e.which == 9) && (e.shiftKey)) {
						e.preventDefault();
						$('.box_closer').focus();
					}
				});
				if ($('.box_middle').find('a').length > 0) {
					$('.box_middle').find('a').eq($('.box_middle').find('a').length-1).on('keydown', function(e) {
						if ((e.which == 9) && (!e.shiftKey)) {
							e.preventDefault();
							$('.box_closer').focus();
						}
					});
					$('.box_closer').on('keydown', function(e) {
						if ((e.which == 9) && (e.shiftKey)) {
							e.preventDefault();							
							$('.box_middle').find('a').eq($('.box_middle').find('a').length-1).focus();
						}
					});
				}
				else {
					$('.box_message').on('keydown', function(e) {
						if ((e.which == 9) && (!e.shiftKey)) {
							e.preventDefault();
							$('.box_closer').focus();
						}
					});
					$('.box_closer').on('keydown', function(e) {
						if ((e.which == 9) && (e.shiftKey)) {
							e.preventDefault();							
							$('.box_message').focus();
						}
					});
				}
			}
			/* 20180501 Accessibility Apply tab functionality to popup */
		}else if(pop_type == 'hot_word'){		
			$('.box_holder .box_title').html(hotword_dat[section][0].title);
			$('.box_holder .box_message').html(hotword_dat[section][0].text);

			/* 20240130 accessibility 2024 */
			$('.box_top_btn').attr('aria-hidden', false);

			/* 20180501 Accessibility Apply tab functionality to popup */
			if(popupKeyDown){
				var tabCnt = 0;
				/* 20240130 accessibility 2024 */
				tabCnt++;
				$('.box_closer').attr('tabindex', tabCnt);
				$('.box_closer').attr('aria-hidden', false);
				tabCnt++;
				$('.box_title').attr('tabindex', tabCnt);
				$('.box_title').attr('aria-hidden', false);
				tabCnt++;
				$('.box_message').attr('tabindex', tabCnt);
				$('.box_message').attr('aria-hidden', false);
				$('.box_middle').find('a').each(function(index, element) {	
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					$(this).attr('aria-hidden', false);
					$(this).on('keypress', function() {
						$(this).trigger('click');
					});
				});
				/* 20221019 ensure popup window is focused on and cannot be tabbed out of */
				$('.box_title').on('keydown', function(e) {
					if ((e.which == 9) && (e.shiftKey)) {
						e.preventDefault();
						$('.box_closer').focus();
					}
				});
				if ($('.box_middle').find('a').length > 0) {
					$('.box_middle').find('a').eq($('.box_middle').find('a').length-1).on('keydown', function(e) {
						if ((e.which == 9) && (!e.shiftKey)) {
							e.preventDefault();
							$('.box_closer').focus();
						}
					});
					$('.box_closer').on('keydown', function(e) {
						if ((e.which == 9) && (e.shiftKey)) {
							e.preventDefault();
							$('.box_middle').find('a').eq($('.box_middle').find('a').length-1).focus();
						}
					});
				}
				else {
					$('.box_message').on('keydown', function(e) {
						if ((e.which == 9) && (!e.shiftKey)) {
							e.preventDefault();
							$('.box_closer').focus();
						}
					});
					$('.box_closer').on('keydown', function(e) {
						if ((e.which == 9) && (e.shiftKey)) {
							e.preventDefault();
							$('.box_message').focus();
						}
					});
				}
			}
			/* 20180501 Accessibility Apply tab functionality to popup */
		}else if(pop_type == 'resources'){
			$('.box_holder .box_title').html(resource_dat[section][0].title);
			$('.box_holder .box_message').html(resource_dat[section][0].text);

			/* 20240130 accessibility 2024 */
			$('.box_top_btn').attr('aria-hidden', false);

			/* 20180501 Accessibility Apply tab functionality to popup */
			
			
			if(popupKeyDown){
				var tabCnt = 0;
				/* 20240130 accessibility 2024 */
				tabCnt++;
				$('.box_closer').attr('tabindex', tabCnt);
				$('.box_closer').attr('aria-hidden', false);
				tabCnt++;
				$('.box_title').attr('tabindex', tabCnt);
				$('.box_title').attr('aria-hidden', false);
				tabCnt++;
				$('.box_message').attr('tabindex', tabCnt);
				$('.box_message').attr('aria-hidden', false);
				$('.box_middle').find('a').each(function(index, element) {	
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					$(this).attr('aria-hidden', false);
					$(this).on('keypress', function() {
						$(this).trigger('click');
					});
				});
				/* 20221019 ensure popup window is focused on and cannot be tabbed out of */
				$('.box_title').on('keydown', function(e) {
					if ((e.which == 9) && (e.shiftKey)) {
						e.preventDefault();
						$('.box_closer').focus();
					}
				});
				if ($('.box_middle').find('a').length > 0) {
					$('.box_middle').find('a').eq($('.box_middle').find('a').length-1).on('keydown', function(e) {
						if ((e.which == 9) && (!e.shiftKey)) {
							e.preventDefault();
							$('.box_closer').focus();
						}
					});
					$('.box_closer').on('keydown', function(e) {
						if ((e.which == 9) && (e.shiftKey)) {
							e.preventDefault();
							$('.box_middle').find('a').eq($('.box_middle').find('a').length-1).focus();
						}
					});
				}
				else {
					$('.box_message').on('keydown', function(e) {
						if ((e.which == 9) && (!e.shiftKey)) {
							e.preventDefault();
							$('.box_closer').focus();
						}
					});
					$('.box_closer').on('keydown', function(e) {
						if ((e.which == 9) && (e.shiftKey)) {
							e.preventDefault();
							$('.box_message').focus();
						}
					});
				}
			}
			/* 20180501 Accessibility Apply tab functionality to popup */
			
			//20190508 Added for collapsable resources
			$('.resource_header').click(function(){
				
				if($(this).parent().parent().next().css('display') == 'block'){
					$(this).parent().parent().next().css('display','none');
				}else{
					$('.resource_links').css('display','none');
					$(this).parent().parent().next().css('display','block');
				}
				
				$('.box_elements').css('overflow-y','visible');
				reposResources();
			});
			
			$('.resource_header').keypress(function (e) {
				if (e.keyCode == 13 || e.keyCode == 32) {
					$(this).trigger('click');
				}
			});
			
			
			
			//20190508 Added for collapsable resources
			
		}
		else if(pop_type == 'error'){		
			$('.box_holder .box_title').html(error_title);
			$('.box_holder .box_message').html(error_mess);
			/* 011623 show LMS error message */
			/*if (isiPad || isAndroidTablet || isAndroidPhone || isiPhone) {
				$('.box_closer').hide();
			}*/
			
			$('.box_closer').hide();

			/* 20240130 accessibility 2024 */
			$('.box_top_btn').attr('aria-hidden', true);
		}
		else if(pop_type == 'bookmark'){			
			var bookmarkTitle = "";
			var bookmarkText = "";
			var bookmarkNavStart = "";
			var bookmarkNavResume = "";
			/* 20231019 switch language button on pre-test selection screen */
			var bookmarkNavSwitchLang = "";
			/* test out: if there is a pre-test in the course */
			if (document.pretestPresent == 1)
			{
				/* 20240319 pre-test that appears after first topic */
				if (!document.preTestAfterFirstTopic)
				{
					/* test out: show the pre-test bookmark popup if pre-test has not yet been attempted */
					if (document.pretestAttempted == 0) {
						bookmarkTitle = localiseString('pretest_title');
						/* 20240130 accessibility 2024 */
						bookmarkText = "<p>" + document.pretestIntro + "</p><p>" + localiseString('pretest_text') + "</p>";
						bookmarkNavStart = localiseString('pretest_nav_cancel');
						bookmarkNavResume = localiseString('pretest_nav_start');
						/* 20240118 switch language button on pre-test selection screen update */
						if (document.isMultiSco)
						{
							/* 20231019 switch language button on pre-test selection screen */
							bookmarkNavSwitchLang = localiseString('lang_btn');
						}	
					}
					else {
						bookmarkTitle = localiseString('bookmark_title');
						bookmarkText = localiseString('bookmark_text');
						bookmarkNavStart = localiseString('bookmark_nav_start');
						bookmarkNavResume = localiseString('bookmark_nav_resume');
					}
				}
				else {
					bookmarkTitle = localiseString('bookmark_title');
					bookmarkText = localiseString('bookmark_text');
					bookmarkNavStart = localiseString('bookmark_nav_start');
					bookmarkNavResume = localiseString('bookmark_nav_resume');
				}	
			}
			else {
				bookmarkTitle = localiseString('bookmark_title');
				bookmarkText = localiseString('bookmark_text');
				bookmarkNavStart = localiseString('bookmark_nav_start');
				bookmarkNavResume = localiseString('bookmark_nav_resume');
			}	
            
            
            $('.dialogue_box').addClass("preTestBG");
            //$('.box_holder').addClass("putBottom");
            
			$('.box_holder .box_title').html(bookmarkTitle);
			$('.box_holder .box_message').html(bookmarkText);
			/* 20240130 accessibility 2024 */
			$('.box_title').attr('tabindex',1); /* 20180501 Accessibility */
			$('.box_title').attr('aria-hidden', false);
			$('.box_message').attr('tabindex',2); /* 20180501 Accessibility */
			$('.box_message').attr('aria-hidden', false);

			/* 20240130 accessibility 2024 */
			$('.box_top_btn').attr('aria-hidden', true);
			
			//20221027 fix for outline on bookmark popup
			$('.box_middle').css('outline-color', 'white');
					
			if (document.pretestPresent == 1)
			{
				/* 20240319 pre-test that appears after first topic */
				if (!document.preTestAfterFirstTopic)
				{
					if (document.pretestAttempted == 0) {
					
						if(document.forcePretest){
							/* 20240118 switch language button on pre-test selection screen update */
							if (bookmarkNavSwitchLang != '')
							{
								/* 20231019 switch language button on pre-test selection screen */
								$('.box_holder .box_bottom').html('<div class=\'button_holder\'><div class=\'button_container\'><div class=\'bookmark_nav_resume\' tabindex=\'3\'>'+bookmarkNavResume+'</div></div></div><div class=\'button_holder_single\'><div class=\'button_container\'><div class=\'bookmark_nav_switchlang\' tabindex=\'4\'>'+bookmarkNavSwitchLang+'</div></div></div>');
							}
							else
							{
								/* 20231019 switch language button on pre-test selection screen */
								$('.box_holder .box_bottom').html('<div class=\'button_holder\'><div class=\'button_container\'><div class=\'bookmark_nav_resume\' tabindex=\'3\'>'+bookmarkNavResume+'</div></div></div>');
							}	
						}else{
							/* 20240118 switch language button on pre-test selection screen update */
							if (bookmarkNavSwitchLang != '')
							{
								/* 20231019 switch language button on pre-test selection screen */
								$('.box_holder .box_bottom').html('<div class=\'button_holder\'><div class=\'button_container\'><div class=\'bookmark_nav_start\' tabindex=\'3\'>'+bookmarkNavStart+'</div><div class=\'bookmark_nav_resume\' tabindex=\'4\'>'+bookmarkNavResume+'</div></div></div><div class=\'button_holder_single\'><div class=\'button_container\'><div class=\'bookmark_nav_switchlang\' tabindex=\'5\'>'+bookmarkNavSwitchLang+'</div></div></div>'); //20221027 fix for outline on bookmark popup
							}
							else
							{
								/* 20231019 switch language button on pre-test selection screen */
								$('.box_holder .box_bottom').html('<div class=\'button_holder\'><div class=\'button_container\'><div class=\'bookmark_nav_start\' tabindex=\'3\'>'+bookmarkNavStart+'</div><div class=\'bookmark_nav_resume\' tabindex=\'4\'>'+bookmarkNavResume+'</div></div></div>'); //20221027 fix for outline on bookmark popup
							}	
						}
					}else{
						/* pre-test no topics associated with questions support kgs 03/18/22 */
						$('.box_holder .box_bottom').html('<div class=\'button_holder\'><div class=\'button_container\'><div class=\'bookmark_nav_start bookmark_nav_start_sm_width\' tabindex=\'3\'>'+bookmarkNavStart+'</div><div class=\'bookmark_nav_resume bookmark_nav_start_sm_width\' tabindex=\'4\'>'+bookmarkNavResume+'</div></div></div>'); //20221027 fix for outline on bookmark popup
					}
				}else{
					/* pre-test no topics associated with questions support kgs 03/18/22 */
					$('.box_holder .box_bottom').html('<div class=\'button_holder\'><div class=\'button_container\'><div class=\'bookmark_nav_start bookmark_nav_start_sm_width\' tabindex=\'3\'>'+bookmarkNavStart+'</div><div class=\'bookmark_nav_resume bookmark_nav_start_sm_width\' tabindex=\'4\'>'+bookmarkNavResume+'</div></div></div>'); //20221027 fix for outline on bookmark popup
				}
			}else{
				/* pre-test no topics associated with questions support kgs 03/18/22 */
				$('.box_holder .box_bottom').html('<div class=\'button_holder\'><div class=\'button_container\'><div class=\'bookmark_nav_start bookmark_nav_start_sm_width\' tabindex=\'3\'>'+bookmarkNavStart+'</div><div class=\'bookmark_nav_resume bookmark_nav_start_sm_width\' tabindex=\'4\'>'+bookmarkNavResume+'</div></div></div>'); //20221027 fix for outline on bookmark popup
			}
			
			
			$('.box_holder .box_bottom').show();
			$('.box_closer').hide();
			/* 20231019 switch language button on pre-test selection screen */
			if (bookmarkNavSwitchLang != '')
			{
				/* 20221019 ensure popup window is focused on and cannot be tabbed out of */
				/* 20240130 accessibility 2024 */
				$('.box_title').on('keydown', function(e) {
					if ((e.which == 9) && (e.shiftKey)) {
						e.preventDefault();
						$('.bookmark_nav_switchlang').focus();
					}
				});
				/* 20221019 ensure popup window is focused on and cannot be tabbed out of */
				$('.bookmark_nav_switchlang').on('keydown', function(e) {
					if ((e.which == 9) && (!e.shiftKey)) {
						e.preventDefault();
						/* 20240130 accessibility 2024 */
						$('.box_title').focus();
					}
				});
			}
			else
			{
				/* 20221019 ensure popup window is focused on and cannot be tabbed out of */
				/* 20240130 accessibility 2024 */
				$('.box_title').on('keydown', function(e) {
					if ((e.which == 9) && (e.shiftKey)) {
						e.preventDefault();
						$('.bookmark_nav_resume').focus();
					}
				});
				/* 20221019 ensure popup window is focused on and cannot be tabbed out of */
				$('.bookmark_nav_resume').on('keydown', function(e) {
					if ((e.which == 9) && (!e.shiftKey)) {
						e.preventDefault();
						/* 20240130 accessibility 2024 */
						$('.box_title').focus();
					}
				});
			}
		}
		$('.box_nav_holder').height();
		if(isWeb){
			$('.dialogue_box').fadeIn('fast');
			/* 20221019 ensure popup window is focused on and cannot be tabbed out of */
			/* 20231019 switch language button on pre-test selection screen */
			/* 20240130 accessibility 2024 */
			$('.box_title').focus();
		}else{
			$('.dialogue_box').show();
		}
        
        if(pop_type == 'bookmark'){
        
            /*$('.box_holder:visible').css({
                'position' : 'absolute',
                'bottom' : 0
            });*/
			
			$('.box_holder:visible').css({
                'position' : 'absolute',
                'top' : $(window.parent).height()/2,
                'margin-top' : -$('.box_holder:visible').outerHeight()/2
            });
			
			
			
        }else{
			
            $('.box_holder:visible').css({
                'position' : 'absolute',
                'top' : $(window.parent).height()/2,
                'margin-top' : -$('.box_holder:visible').outerHeight()/2
            });
        }
		if($('.box_nav_holder:visible').height() > $(window.parent).height()){
			$('.dialogue_box').not('.bookmark').addClass('box_overflow');
			$('.box_holder').not('.bookmark').addClass('box_static');
			$('.box_holder:visible').css({'margin-top' : 0})
		}else{
			if(isiPhone){ /* fix for iPhone added */
				document.ontouchmove = function(e){ e.preventDefault(); }
			}
		}
		if(document.textDirection == "rtl"){

			$(".align_left").addClass("align_left_RTL");
		}
	}	
}

//20190508 Added for collapsable resources

function reposResources(){
	/*$('.box_holder:visible').css({
		'position' : 'absolute',
		'top' : $(window.parent).height()/2,
		'margin-top' : -$('.box_holder:visible').outerHeight()/2
	});

	if($('.box_nav_holder:visible').height() > $(window.parent).height()){
		$('.dialogue_box').not('.bookmark').addClass('box_overflow');
		$('.box_holder').not('.bookmark').addClass('box_static');
		$('.box_holder:visible').css({'margin-top' : 0})
	}
	if(isiPad || isiPhone){ 
		$('.sec_rest_wrapper, .topic_index').css({'margin-top': -windowTop, 'position':'fixed'})

		$('.sec_rest_wrapper').css({'margin-top': -64+'px'}) // LJ Added to postion content under transparent banner //
	}*/
	
	$('.box_holder:visible').not('.bookmark').css({
        'position' : 'absolute',
        'top' : '50%',
        'margin-top' : -$('.box_holder:visible').outerHeight()/2
    });
	if($('.box_nav_holder:visible').height() > $(window.parent).height()){
		$('.dialogue_box').not('.bookmark').addClass('box_overflow');
		$('.box_holder').not('.bookmark').addClass('box_static');
	    $('.box_holder:visible').css({'margin-top' : 0})
	}else{
		$('.dialogue_box').not('.bookmark').removeClass('box_overflow');
		$('.box_holder').not('.bookmark').removeClass('box_static');
	}
}

function boxClose(){	
	if(isiPad || isiPhone){
		var top = Math.abs(parseInt($('.sec_rest_wrapper, .topic_index').css('margin-top')))
		$('.sec_rest_wrapper, .topic_index').css({'margin-top': 0, 'position':'absolute'})
        
        //$('.sec_rest_wrapper').css({'margin-top': -64+'px'}) // LJ Added to postion content under transparent banner //
	}	
	if(isWeb){
		//$("html, body").enableScroll(); /* enable scroll bar */
		$('html, body').css('overflow-y','visible');
	}else{
		$('html, body').css('overflow-y','visible');
	}	
	if(isWeb){
		$('.dialogue_box').fadeOut('fast');
	}else{
		$('.dialogue_box').hide();
	}
	$('.dialogue_box').removeClass('box_overflow');
	$('.box_holder').addClass('box_reposition');
	$('.box_holder').removeClass('box_static');
	if(isiPad || isiPhone){
		$(parent.parent.document).scrollTop(top)
		$('.bar_robot').css('top',($(parent.parent.document).scrollTop())-1+'px'); /* fix for iPhone added */
		$('.bar_robot').removeClass('displayNone').addClass('displayBlock'); /* fix for iPhone added */
	}
	$('.box_holder .box_bottom').hide();
	/* 20180501 Accessibility Reapply tab funcitonality to content */
	/* 20240130 accessibility 2024 */
	$('.box_closer').attr('tabindex', -1);
	$('.box_closer').attr('aria-hidden', true);
	$('.box_title').attr('tabindex', -1);
	$('.box_title').attr('aria-hidden', true);
	$('.box_message').attr('tabindex', -1);
	$('.box_message').attr('aria-hidden', true);
	if(index === true){
		setMenuTabIndex();
	}else{
		$('.bar_robot').find('.home').each(function(index, element) {
			$(this).attr('tabindex', 1);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', false);
		});
		$('.bar_robot').find('.switchLang').each(function(index, element) { // 20221018 QA fix for tabbing to buttons when resource/hotword popup visible
			$(this).attr('tabindex', 2);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', false);
		});
		$('.bar_robot').find('.page').each(function(index, element) {
			$(this).attr('tabindex', 3);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', false);
		});
        $('.bar_robot').find('.bar_close').each(function(index, element) {
			$(this).attr('tabindex', 4);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', false);
		});
		
		setTabIndex();  // 20221018 QA fix for tabbing to buttons when resource/hotword popup visible
		
		setNavTab();
		
	}
	
	$('.resource_header').unbind();
	$('.resource_links').css('display','none');
	
	

	popupKeyDown = false;
	
	$(butReturnFocus).focus(); // Return focus to button or hotword
	
	/* 20180501 Accessibility Reapply tab funcitonality to content */
	if(isiPad || isiPhone){
		document.ontouchmove = function(e){ return true; } // 20201706 enable scroll on devices
	}
}

/* disable/enable scroll bar */
$.fn.disableScroll = function() {
    window.oldScrollPos = $(window).scrollTop();
	$(window).bind('mousewheel',function(){ return false; });
    /*$(window).on('scroll.scrolldisabler',function ( event ) {
       $(window).scrollTop( window.oldScrollPos );
       event.preventDefault();
    });*/
};

$.fn.enableScroll = function() {
    //$(window).off('scroll.scrolldisabler');
	$(window).unbind('mousewheel');
};

/* 20240130 accessibility 2024 */
$('.box_top_btn').click(function(e){
	$('.box_closer').focus();
});

/* 20240130 accessibility 2024 */
$('.box_top_btn').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {
		$(this).trigger('click');
	}
});	