/* functions to initiate the course */

$(document).ready(function() {

	BrowserDetect.init();
	/*resizeWindow();*/
	
	if((typeof console)=="undefined"){
		console = new Object();	
		console.log = function(arg){ 
		}
	}
	
	/* 20221130 Update to language selection and bookmark functionality */
	//LMSAPI = parent.document.scormAPI; //actionsGetAPI();
	
	courseInit();
	lockNav();
	setupClickableOptions();  
	interfaceStrings();
	setMenuTabIndex();
	setTabIndex(); /* set up the tab index for course */
	
	//setUpAudio(); /* setup audio functionality */	
	//setUpVids();
	
	$(".section").attr('data-clicked',0); 
	$(".section").attr('data-animated',0);
	
	
	$(".slider_container").attr('data-height',0); 
	//$(".section").attr('data-links',0); 
	//$(".section").attr('data-hotwords',0);	
	document.randomizeAssessment();	
	
	//if(document.topicPreTest){
		
	document.randomizePreQuestions();
	//}
	
	
	/*if(isiPhone || isAndroidPhone || isAndroidTablet){
		var elementsToShow = document.querySelectorAll('.animation-element');
		elementsToShow.forEach(function (element) {
			element.classList.add('in-view');
		});
	}*/
	
	if(os == "iOS" || os == "Android"){
		var elementsToShow = document.querySelectorAll('.animation-element');
		elementsToShow.forEach(function (element) {
			element.classList.add('in-view');
		});
		
		$('.video_poster').css('display','none');
		
	}
	/* 111623 remove video poster on Firefox */
	if(isMac || isFF){
		$('.video_poster').css('display','none');
	}
	
	//rePosHotSpots();
	
	setRTL();

	/* GET from LMS */
	document.studentName = actionsLMSGetStudentName();
	document.studentId = actionsLMSGetStudentId();

	/* 20240326 accessibility 2024 */
	$('.topic_select').each(function(index, element) {
		if ($(this).find('.progress_text').html() == localiseString('topic_locked_label'))
		{
			$(this).attr('alt', localiseString('topic_locked'));
			$(this).attr('title', localiseString('topic_locked'));
		}		
	});
});	

/* setTabIndex function to assign reset and assign tab index for each section */

var navTabCnt; /* 20180501 Accessibility Update */
var tempNavCnt;
function removeMenuTabIndex(){ // remove menu tab funcitonality
	
	/* reskin v4.0 2025 */
	$('.topic_index').find('.index_course_title').each(function(index, element) {
		$(this).attr('tabindex', -1);		
		$(this).attr('aria-hidden', true);
	});
	
	/* topic groups in menu v4.0 2025 */
	if (document.topicGroupsPresent)
	{
		$('.topic_index').find('.menu_topic_group_btn').each(function(index, element) {
			$(this).attr('tabindex', -1);
			/* 2022 Accessibility Update */
			$(this).attr('aria-hidden', true);
			$(this).parent().find('.menu_btns_holder').eq(index).find('.topic_select').each(function(index, element) {
				$(this).attr('tabindex', -1);
				/* 2022 Accessibility Update */
				$(this).attr('aria-hidden', true);
			});
		});
	}
	else {
		$('.topic_index').find('.topic_select').each(function(index, element) {
			$(this).attr('tabindex', -1);
			/* 2022 Accessibility Update */
			$(this).attr('aria-hidden', true);
		});
		/* branch menu 2025 */
		$('.topic_index').find('.branch_select').each(function(index, element) {
			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
		});
	}
	
	/* splash video v4.0 2025*/
	$('.topic_index').find('.return_vid_btn').each(function(index, element) {
		$(this).attr('tabindex', -1);
		$(this).attr('aria-hidden', true);
	});
	
	/* splash video v4.0 2025 */
	$('.topic_index').find('.continue_vid_btn').each(function(index, element) {
		$(this).attr('tabindex', -1);
		$(this).attr('aria-hidden', true);
	});
	
	/* branch menu 2025 */
	$('.topic_index').find('.return_branch_menu_btn').each(function(index, element) {
		$(this).attr('tabindex', -1);
		$(this).attr('aria-hidden', true);
	});

	/* splash video v4.0 2025 */
	$('.topic_index').find('.transcript_btn').each(function(index, element) {
		$(this).attr('tabindex', -1);
		$(this).attr('aria-hidden', true);
	});
	
	/* splash video v4.0 2025 */	
	$('.topic_index').find('.transcript_text').each(function(index, element) {
		$(this).attr('tabindex', -1);
		$(this).attr('aria-hidden', true);
	});
	
	/* splash video v4.0 2025 */
	$('.topic_index').find('.video_player').each(function(index, element) {
		$(this).attr('tabindex', -1);
		$(this).attr('aria-hidden', true);
	});

	$('.topic_index').find('.content_text').each(function(index, element) {
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
    	// 202210 QA Tabbing fix
    	$(this).find('a').each(function(index, element) {
  			$(this).attr('tabindex', -1);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', true);
  		});
   
    
    });
	
	$('.topic_index').find('.home').each(function(index, element) {
     
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
    });
	
	// 20221018 QA fix for tabbing to buttons when resource/hotword popup visible
	$('.topic_index').find('.switchLang').each(function(index, element) {
     
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
    });
	
	$('.topic_index').find('.page').each(function(index, element) {
     
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
    });
    
    $('.topic_index').find('.bar_close').each(function(index, element) {
     
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
    });
	/* Progress Indicator 2023 -- */
	$(".index_progress").attr('tabindex', -1);
	$(".index_progress").attr('aria-hidden', true);
	/* -- Progress Indicator 2023 */
    
    tempNavCnt = 0;
	
	/* reskin v4.0 2025 */
	$('.bar_robot').find('.menu_course_title').each(function(index, element) {
		$(this).attr('tabindex', 1);
		$(this).attr('aria-hidden', false);
		$(this).css('visibility','visible');
	});
	
	$('.bar_robot').find('.home').each(function(index, element) {
     
        //tempNavCnt++;
		$(this).attr('tabindex', 2); /* reskin v4.0 2025 */
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		$(this).css('visibility','visible'); /* reskin v4.0 2025 */
		
    });
	
	$('.bar_robot').find('.switchLang').each(function(index, element) {
     
        //tempNavCnt++;
		$(this).attr('tabindex', 3); /* reskin v4.0 2025 */
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
    
	$('.bar_robot').find('.page').each(function(index, element) {
     
        //tempNavCnt++;
		$(this).attr('tabindex', 4); /* reskin v4.0 2025 */
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
    $('.bar_robot').find('.bar_close').each(function(index, element) {
     
        //tempNavCnt++;
		$(this).attr('tabindex', 5); /* reskin v4.0 2025 */
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
    
	/* Progress Indicator 2023 -- */
    $(".course_progress").attr('tabindex', 6); /* reskin v4.0 2025 */
	$(".course_progress").attr('aria-hidden', false);
	$(".index_progress").attr('tabindex', -1);
	$(".index_progress").attr('aria-hidden', true);
	/* -- Progress Indicator 2023 */
	
	/* 20240326 accessibility 2024 */
	$('.courseTitle').attr('tabindex', -1);
	$('.courseTitle').attr('aria-hidden', true);
}


/* 20180501 Accessibility Update */
function setMenuTabIndex(){
	
	var tabCnt = 0;

	/* reskin v4.0 2025 */
	$('.bar_robot').find('.menu_course_title').each(function(index, element) {
		$(this).attr('tabindex', -1);		
		$(this).attr('aria-hidden', true);
	});
	
	$('.bar_robot').find('.home').each(function(index, element) {
     
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
		/*$(this).css('visibility','hidden');*/ /* reskin v4.0 2025 */ /* uncomment if resources button is to be hidden */
		$(this).css('visibility','hidden'); /* accessibility updates 2025 */
    });
	
	$('.bar_robot').find('.switchLang').each(function(index, element) {
     
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
    });
    
	/* 20221021 ensure burger menu window is focused on and cannot be tabbed out of */
	$('.burger_index').find('.burger_scroll').attr('tabindex', -1);
    $('.burger_index').find('.burger_scroll').attr('aria-hidden', true);
	
	/* 120723 arrow up/down issue: using these keys will pick up on the divider line on Win 10 Chrome */
	$('.burger_index').find('.burger_line').attr('tabindex', -1);
    $('.burger_index').find('.burger_line').attr('aria-hidden', true);
	
	$('.burger_index').find('.burger_home').attr('tabindex', -1);
    $('.burger_index').find('.burger_home').attr('aria-hidden', true);
	
    $('.burger_index').find('.burger_select').each(function(index, element) {             
		$(this).attr('tabindex', -1);
		$(this).attr('aria-hidden', true);
    });
	
	$('.burger_index').find('.burger_close').attr('tabindex', -1);
	$('.burger_index').find('.burger_close').attr('aria-hidden', true);
    
	$('.bar_robot').find('.page').each(function(index, element) {
     
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
    });
    
    $('.bar_robot').find('.bar_close').each(function(index, element) {
     
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
    });
	/* Progress Indicator 2023 -- */
	$(".course_progress").attr('tabindex', -1);
	$(".course_progress").attr('aria-hidden', true);
	/* -- Progress Indicator 2023 */
	
	/* reskin v4.0 2025 */
	$('.topic_index').find('.index_course_title').each(function(index, element) {
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		$(this).attr('aria-hidden', false);
	});
	
	$('.topic_index').find('.home').each(function(index, element) {
     
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
	$('.topic_index').find('.switchLang').each(function(index, element) {
     
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
	
	$('.topic_index').find('.page').each(function(index, element) {
     
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
    
    $('.topic_index').find('.bar_close').each(function(index, element) {
     
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
	/* Progress Indicator 2023 -- */
	tabCnt++;
	$(".index_progress").attr('tabindex', tabCnt);
	$(".index_progress").attr('aria-hidden', false);
	/* -- Progress Indicator 2023 */
	
	/* 20240326 accessibility 2024 */
	tabCnt++;
	$('.courseTitle').attr('tabindex', tabCnt++);
	$('.courseTitle').attr('aria-hidden', false);
	
	$('.topic_index').find('.content_text').each(function(index, element) {
      
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		// 202210 QA Tabbing fix
  		$(this).find('a').each(function(index, element) {
  			tabCnt++;
  			$(this).attr('tabindex', tabCnt);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', false);
  		});
		
    });
	
	/* splash video v4.0 2025 */
	$('.topic_index').find('.video_player').each(function(index, element) {
		tabCnt++;
		$(this).attr('data-tab', tabCnt);
		if ($(".menu_container").css("display") == "none")
		{
			$(this).attr('tabindex', tabCnt);
		}
		else
		{
			$(this).attr('tabindex', -1);
		}
		$(this).attr('aria-hidden', false);
	});
	
	/* splash video v4.0 2025 */
	$('.topic_index').find('.transcript_btn').each(function(index, element) {
		$(this).attr('role','button');
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		$(this).attr('aria-hidden', false);
	});

	/* splash video v4.0 2025 */
	$('.topic_index').find('.transcript_text').each(function(index, element) {
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		$(this).attr('aria-hidden', false);
	});
	
	/* branch menu 2025 */
	$('.topic_index').find('.return_branch_menu_btn').each(function(index, element) {
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		$(this).attr('aria-hidden', false);
	});

	/* splash video v4.0 2025 */
	$('.topic_index').find('.continue_vid_btn').each(function(index, element) {
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		$(this).attr('aria-hidden', false);
	});

	/* splash video v4.0 2025 */
	$('.topic_index').find('.return_vid_btn').each(function(index, element) {
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		$(this).attr('aria-hidden', false);
	});	
	
	/* topic groups in menu v4.0 2025 */
	if (document.topicGroupsPresent)
	{
		$('.topic_index').find('.menu_topic_group_btn').each(function(index, element) {      
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 2022 Accessibility Update */
			$(this).attr('aria-hidden', false);
			$(this).parent().find('.menu_btns_holder').eq(index).find('.topic_select').each(function(index, element) {      
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				/* 2022 Accessibility Update */
				$(this).attr('aria-hidden', false);
			});
		});
	}
	else {
		/* branch menu 2025 */
		$('.topic_index').find('.branch_select').each(function(index, element) {
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			$(this).attr('aria-hidden', false);
		});
		$('.topic_index').find('.topic_select').each(function(index, element) {
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 2022 Accessibility Update */
			$(this).attr('aria-hidden', false);
		});
	}
}

function setBurgerTabIndex(){
    
	// 20221018 QA fix for tabbing to buttons when resource/hotword popup visible
	if($(".topic_index").is(":visible")){
		removeMenuTabIndex();
		
		/* reskin v4.0 2025 */
		$('.topic_index').find('.index_course_title').each(function(index, element) {
			$(this).attr('tabindex', -1);			
			$(this).attr('aria-hidden', true);
		});
	
		$('.topic_index').find('.home').each(function(index, element) {
     
			$(this).attr('tabindex', -1);
			/* 2022 Accessibility Update */
			$(this).attr('aria-hidden', true);

		});

		// 20221018 QA fix for tabbing to buttons when resource/hotword popup visible
		$('.topic_index').find('.switchLang').each(function(index, element) {

			$(this).attr('tabindex', -1);
			/* 2022 Accessibility Update */
			$(this).attr('aria-hidden', true);

		});

		$('.topic_index').find('.page').each(function(index, element) {

			$(this).attr('tabindex', -1);
			/* 2022 Accessibility Update */
			$(this).attr('aria-hidden', true);

		});

		$('.topic_index').find('.bar_close').each(function(index, element) {

			$(this).attr('tabindex', -1);
			/* 2022 Accessibility Update */
			$(this).attr('aria-hidden', true);

		});
		
		/* reskin v4.0 2025 */
		$('.bar_robot').find('.menu_course_title').each(function(index, element) {
			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);			
			/*$(this).css('visibility','hidden');*/ /* reskin v4.0 2025 */ /* uncomment if resources button is to be hidden */
		});
		$('.bar_robot').find('.home').each(function(index, element) {

			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);			
			/*$(this).css('visibility','hidden');*/ /* reskin v4.0 2025 */ /* uncomment if resources button is to be hidden */
		});
		$('.bar_robot').find('.switchLang').each(function(index, element) {

			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
		});
		$('.bar_robot').find('.page').each(function(index, element) {

			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
		});
		$('.bar_robot').find('.bar_close').each(function(index, element) {

			$(this).attr('tabindex', -1);	
			$(this).attr('aria-hidden', true);
		});
		/* Progress Indicator 2023 -- */
		$(".course_progress").attr('tabindex', -1);
		$(".course_progress").attr('aria-hidden', true);
		/* -- Progress Indicator 2023 */
		
	}else{
	
		/* reskin v4.0 2025 */
		$('.bar_robot').find('.menu_course_title').each(function(index, element) {
			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);			
			/*$(this).css('visibility','hidden');*/ /* reskin v4.0 2025 */ /* uncomment if resources button is to be hidden */
		});
		$('.bar_robot').find('.home').each(function(index, element) {

			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
			/*$(this).css('visibility','hidden');*/ /* reskin v4.0 2025 */ /* uncomment if resources button is to be hidden */
		});
		$('.bar_robot').find('.switchLang').each(function(index, element) {

			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
		});
		$('.bar_robot').find('.page').each(function(index, element) {

			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
		});
		$('.bar_robot').find('.bar_close').each(function(index, element) {

			$(this).attr('tabindex', -1);	
			$(this).attr('aria-hidden', true);
		});
		
		/* Progress Indicator 2023 -- */
		$(".course_progress").attr('tabindex', -1);
		$(".course_progress").attr('aria-hidden', true);
		/* -- Progress Indicator 2023 */	
	}
	// 20221018 QA fix for tabbing to buttons when resource/hotword popup visible

    tempNavCnt = 0;
	
	/*$('.bar_robot').find('.home').each(function(index, element) {
     
        tempNavCnt++;
		$(this).attr('tabindex', tempNavCnt);
		// 2022 Accessibility Update 
		$(this).attr('aria-hidden', false);
		
    });*/
	
	/* 20221021 ensure burger menu window is focused on and cannot be tabbed out of */
    tempNavCnt++;
    $('.burger_index').find('.burger_scroll').attr('tabindex', tempNavCnt);
    $('.burger_index').find('.burger_scroll').attr('aria-hidden', false);
	
	tempNavCnt++;
    $('.burger_index').find('.burger_home').attr('tabindex', tempNavCnt);
    $('.burger_index').find('.burger_home').attr('aria-hidden', false);

    $('.burger_index').find('.burger_select').each(function(index, element) {
        tempNavCnt++;
		$(this).attr('tabindex', tempNavCnt);
		$(this).attr('aria-hidden', false);
    });

	tempNavCnt++;
	$('.burger_index').find('.burger_close').attr('tabindex', tempNavCnt);
	$('.burger_index').find('.burger_close').attr('aria-hidden', false);
	
	/*$('.bar_robot').find('.page').each(function(index, element) {
     
        tempNavCnt++;
		$(this).attr('tabindex', tempNavCnt);
		
    });
    $('.bar_robot').find('.bar_close').each(function(index, element) {
     
        tempNavCnt++;
		$(this).attr('tabindex', tempNavCnt);
		
    });*/
    
}

function removerBurgerTabIndex(){
    
    /* 20221021 ensure burger menu window is focused on and cannot be tabbed out of */
	$('.burger_index').find('.burger_scroll').attr('tabindex', -1);
    $('.burger_index').find('.burger_scroll').attr('aria-hidden', true);
	
	$('.burger_index').find('.burger_home').attr('tabindex', -1);
    $('.burger_index').find('.burger_home').attr('aria-hidden', true);
	
    $('.burger_index').find('.burger_select').each(function(index, element) {             
		$(this).attr('tabindex', -1);
		$(this).attr('aria-hidden', true);
    });
	
	$('.burger_index').find('.burger_close').attr('tabindex', -1);
	$('.burger_index').find('.burger_close').attr('aria-hidden', true);  

	/* reskin v4.0 2025 */
	$('.bar_robot').find('.menu_course_title').each(function(index, element) {
		$(this).attr('tabindex', 1);
		$(this).attr('aria-hidden', false);
		$(this).css('visibility','visible');
	});
		
    $('.bar_robot').find('.home').each(function(index, element) {        
		
		$(this).attr('tabindex', 2); /* reskin v4.0 2025 */
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		$(this).css('visibility','visible'); /* reskin v4.0 2025 */
    });
    $('.bar_robot').find('.switchLang').each(function(index, element) {
     
		$(this).attr('tabindex', 3); /* reskin v4.0 2025 */
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
    $('.bar_robot').find('.page').each(function(index, element) {
     
		$(this).attr('tabindex', 4); /* reskin v4.0 2025 */
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
    $('.bar_robot').find('.bar_close').each(function(index, element) {

		$(this).attr('tabindex', 5); /* reskin v4.0 2025 */
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });

	/* Progress Indicator 2023 -- */
	$(".course_progress").attr('tabindex', 6); /* reskin v4.0 2025 */
	$(".course_progress").attr('aria-hidden', false);
	/* -- Progress Indicator 2023 */

    setTabIndex();
}


/* 20180501 Accessibility Update */
function setTabIndex(sec){	
		
	$('.home').attr('role','button');
	$('.switchLang').attr('role','button');
	$('.page').attr('role','button');
	$('.bar_close').attr('role','button');
		  
	$('.topic_nav').attr('role','button');
	
	$('.box_closer').attr('role', 'button');
	
	/* 20221021 ensure burger menu window is focused on and cannot be tabbed out of */
	$('.burger_close').attr('role', 'button');
	
	/* apply tabindex */
	/* Progress Indicator 2023 */
	var tabCnt = 5;		// 20221018 QA fix for tabbing to buttons when resource/hotword popup visible
	

	
	$('.sec_rest_wrapper').find('.section').each(function(index, element) {
		
	
		
		$(this).find('.h2_inner').each(function(index, element) { /* 20180501 Accessibility Update */
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', false);
		});
		
		/* 20240326 accessibility 2024 */
		$(this).find('.text_image_left_image img').each(function(index, element) {
			if ($(this).attr('alt') != ''){
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				/* 20240326 accessibility 2024 */
				$(this).attr('aria-hidden', false);
			}
		});
		
		$(this).find('.content_text').each(function(index, element) { /* 20180501 Accessibility Update */
			/* 20221020 ensure tab order of text content after activity is following activity */
			if (!$(this).hasClass('content_text_after_activity'))
			{
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				/* 20240326 accessibility 2024 */
				$(this).attr('aria-hidden', false);
				/* 20221021 ensure links within main content are tabbed to after the content */
				$(this).find('a').each(function(index, element) {
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					/* 20240326 accessibility 2024 */
					$(this).attr('aria-hidden', false);
				});
				
				/* 20221107 Accessibility fix to apply tab order if image only has alt text */
				$(this).find('img').each(function(index, element) {
					if ($(this).attr('alt') != ''){
						tabCnt++;
						$(this).attr('tabindex', tabCnt);
						/* 20240326 accessibility 2024 */
						$(this).attr('aria-hidden', false);
					}
					if ($(this).parent().hasClass('adaptive_image'))
					{
//						$(this).parent().parent().attr('tabindex', -1);
						//20221213 fix for adpative image to be table and div containg image content read out
						tabCnt++;
						$(this).parent().parent().attr('tabindex', tabCnt);
						/* 20240326 accessibility 2024 */
						$(this).parent().parent().attr('aria-hidden', false);
					}
				});
			}
		});

		/* 20221107 Accessibility fix to apply tab order if image only has alt text */
		$(this).find('img').each(function(index, element) {
			/* 20240326 accessibility 2024 */
			if (!$(this).parent().hasClass('adaptive_image') && !$(this).parent().hasClass('text_image_left_image'))
			{
				if ($(this).attr('alt') != ''){
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					/* 20240326 accessibility 2024 */
					$(this).attr('aria-hidden', false);
				}
			}
		});

		/* 20231016 Likert accessibility */

		/* 20180501 Accessibility Update */
		$(this).find('.expando_btn').each(function(index, element) {
			$(this).attr('role','button'); /* 20180501 Accessibility Update */
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', false);
			
			$(this).next('.expando_reveal').each(function(index, element){
			 
									 
				
				$(this).find('.expando_reveal_heading').each(function(index, element) {
					$(this).attr('role','button'); /* 20180501 Accessibility Update */
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					/* 20240326 accessibility 2024 */
					$(this).attr('aria-hidden', false);
				});
				
				$(this).find('.expando_reveal_content').each(function(index, element) {	
					
					/* 20240326 accessibility 2024 */
					tabCnt++;
					$(this).find('.exp_start').attr('tabindex', tabCnt);
					$(this).find('.exp_start').attr('aria-hidden', false);
					
					/* 20240326 accessibility 2024 */
					tabCnt++;
					$(this).find('.exp_rest').attr('tabindex', tabCnt);
					$(this).find('.exp_rest').attr('aria-hidden', false);

					$(this).find('a').each(function(index, element) {
						tabCnt++;
						$(this).attr('tabindex', tabCnt);
						/* 20240326 accessibility 2024 */
						$(this).attr('aria-hidden', false);
					});
					
					/* 20220630 Accessibility fix to apply tan order if image only has atl text */
					$(this).find('img').each(function(index, element) {
						if ($(this).attr('alt') != ''){
							tabCnt++;
							$(this).attr('tabindex', tabCnt);
							/* 20240326 accessibility 2024 */
							$(this).attr('aria-hidden', false);
						}
					});

				});

				
			});
			
			
		});	
			
		
		/* apply tabindex to video */
		
		$(this).find('.video_poster').each(function(index, element) {	
			$(this).attr('role','button');
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', false);
		});	
			
		$(this).find('.video_player').each(function(index, element) {	
			tabCnt++;
			/* 20231026 video accessibility */
			$(this).attr('data-tab', tabCnt);
			$(this).attr('tabindex', tabCnt);
			$(this).attr('aria-hidden', false);
		});

		/* 20240326 accessibility 2024 */
		$(this).find('.audio_player').each(function(index, element) {
			tabCnt++;
			/* 20240326 accessibility 2024 */
			$(this).attr('data-tab', tabCnt);
			$(this).attr('tabindex', tabCnt);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', false);
		});
		
		$(this).find('.transcript_text').each(function(index, element) {	
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', false);
		});
		
		/* 20240326 accessibility 2024 */
		$(this).find('.transcript_btn').each(function(index, element) {	
			tabCnt++;
			$(this).attr('role', 'button');
			$(this).attr('tabindex', tabCnt);
			$(this).attr('aria-hidden', false);
		});
		
		/* apply tabindex to questions */	
        $(this).find('.qItemFirst').each(function(index, element) {
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			$(this).attr("aria-hidden", false);
			/* 20220628 JAWS fix to stop item being read when course launches */
		});
        
		$(this).find('.squaredBox').each(function(index, element) {
			
			
			var labelTxt;
			
			$(this).find('.labelTxt').each(function(index, element) {
				
				labelTxt = $(this).html();
				
			});
			
			$(this).attr('title', labelTxt)
			
		});
				
		$(this).find('.mc_btn').each(function(index, element) {
            $(this).attr('tabindex', -1);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', true);
        });
		
		$(this).find('.dropDown').each(function(index, element) {
			$(this).find('label').each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				/* 20240326 accessibility 2024 */
				$(this).attr('aria-hidden', false);
			});
			$(this).find('select').each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				/* 20240326 accessibility 2024 */
				$(this).attr('aria-hidden', false);
			});
        });
		
		
		
		$(this).find('.submit_btn').each(function(index, element) {
			/* 20230912 Fixes for client review of prototype */
			if (!$(this).hasClass('submit_likert_btn'))
			{
				$(this).attr('role','button'); /* 20180501 Accessibility Update */
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				/* 20240326 accessibility 2024 */
				$(this).attr('aria-hidden', false);
			}
		});
		
		/* 20240326 accessibility 2024 */
		$(this).find('.feedback_start').each(function(index, element) {
			if (!$(this).hasClass('feedback_likert_text'))
			{
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				$(this).attr('aria-hidden', false);
				
				$(this).find('a').each(function(index, element) {
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					$(this).attr('aria-hidden', false);
				});
			}	
		});

		/* 20240326 accessibility 2024 */
		$(this).find('.feedback_rest').each(function(index, element) {
			if (!$(this).hasClass('feedback_likert_text'))
			{
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				$(this).attr('aria-hidden', false);
				
				$(this).find('a').each(function(index, element) {
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					$(this).attr('aria-hidden', false);
				});
			}	
		});
		
		// 20221013 JAWS fix
		$(this).find('.results_review_text').each(function(index, element) {
			
			//20221025 JAWS fix to stop duplicate read out when assess results review is not present
			if(document.showAssessResultsReview){
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				/* 20240326 accessibility 2024 */
				$(this).attr('aria-hidden', false);
			}
		});
		
		$(this).find('.retake_assess_btn').each(function(index, element) {	
			tabCnt++;
			/* 20240326 accessibility 2024 */
			$(this).attr('role', 'button');
			$(this).attr('tabindex', tabCnt);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', false);
		});

		/* retake course button 2025 */
		$(this).find('.retake_course_btn').each(function(index, element) {	
			tabCnt++;
			/* 20240326 accessibility 2024 */
			$(this).attr('role', 'button');
			$(this).attr('tabindex', tabCnt);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', false);
		});

		/* 20240326 accessibility 2024 */
		$(this).find('.confirm_attest_btn').each(function(index, element) {	
			tabCnt++;			
			$(this).attr('role', 'button');
			$(this).attr('tabindex', tabCnt);
			$(this).attr('aria-hidden', false);
		});

		/* 20231016 Likert accessibility */
		$(this).find('.survey_text').each(function(index, element) {
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', false);
		});
		
		/* 20231016 Likert accessibility */
		$(this).find(".survey_btn_holder_div").each(function(index, element) {
			$(this).find(".survey_opt_in_btn_div").each(function(index, element) {
				$(this).find('a').each(function(index, element) {
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					/* 20240326 accessibility 2024 */
					$(this).attr('aria-hidden', false);
				});
			});
			$(this).find(".survey_opt_out_btn_div").each(function(index, element) {
				$(this).find('a').each(function(index, element) {
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					/* 20240326 accessibility 2024 */
					$(this).attr('aria-hidden', false);
				});
			});
		});
		
		/* 20231016 Likert accessibility */
		/* 20230912 Fixes for client review of prototype */
		/* 20230608 Likert functionality */		
		$(this).find(".likert_row").each(function(index, element) {
			$(this).find(".statement").each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				/* 20240326 accessibility 2024 */
				$(this).attr('aria-hidden', false);
			});	
			$(this).find(".likert_rb").each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				/* 20240326 accessibility 2024 */
				$(this).attr('aria-hidden', false);
			});
		});
		/* 20231016 Likert accessibility */
		/* 20230912 Fixes for client review of prototype */
		$(this).find('.submit_likert_btn').each(function(index, element) {	
			$(this).attr('role','button'); /* 20180501 Accessibility Update */
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', false);			
		});
		/* 20231012 Likert accessibility */
		$(this).find('.feedback_likert_text').each(function(index, element) {	
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', false);
			
			$(this).find('a').each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				/* 20240326 accessibility 2024 */
				$(this).attr('aria-hidden', false);
			});
		});
		
		/* apply tabindex to slider */
		$(this).find('.slider_txt').each(function(index, element) {	
			/* ensure first display is tabbed to first */
			//if (index == 0)
			//{

			/* 20240326 accessibility 2024 */
			/* 20220630 Accessibility fix to apply tan order if image only has atl text */
			$(this).find('img').each(function(index, element) {
				if ($(this).attr('alt') != ''){
					tabCnt++;
					$(this).attr('data-tab', tabCnt); // 20221025 JAWs Slider Fix
					$(this).attr('tabindex', tabCnt);
					/* 20240326 accessibility 2024 */
					$(this).attr('aria-hidden', false);
				}
			});
			
			/* 20240326 accessibility 2024 */
			$(this).find('.slider_col_left').each(function(index, element) {
				/* 20240326 accessibility 2024 */
				tabCnt++;
				$(this).find('.slider_start').attr('tabindex', tabCnt);
				$(this).find('.slider_start').attr('data-tab', tabCnt);
				$(this).find('.slider_start').attr('aria-hidden', false);

				/* 20240326 accessibility 2024 */
				tabCnt++;
				$(this).find('.slider_rest').attr('tabindex', tabCnt);
				$(this).find('.slider_rest').attr('data-tab', tabCnt);
				$(this).find('.slider_rest').attr('aria-hidden', false);
			});	
			
			/* slider full width slide accessibility 2025 */
			$(this).find('.slider_col_full').each(function(index, element) {				
				tabCnt++;
				$(this).find('.slider_start').attr('tabindex', tabCnt);
				$(this).find('.slider_start').attr('data-tab', tabCnt);
				$(this).find('.slider_start').attr('aria-hidden', false);
				tabCnt++;
				$(this).find('.slider_rest').attr('tabindex', tabCnt);
				$(this).find('.slider_rest').attr('data-tab', tabCnt);
				$(this).find('.slider_rest').attr('aria-hidden', false);
			});	
			
			$(this).find('a').each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				$(this).attr('data-tab', tabCnt);
				/* 20240326 accessibility 2024 */
				$(this).attr('aria-hidden', false);
			});	
			
			/* 20240326 accessibility 2024 */
			$(this).find('.slide_end').attr('aria-hidden', true);
			
			//}			
		});
		
		/* 20240326 accessibility 2024 */
		$(this).find('.slide_left').each(function(index, element) {	
			
			$(this).attr('role','button'); /* 20180501 Accessibility Update */
			
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', false);
		});
		
		/* 20240326 accessibility 2024 */
		$(this).find('.slide_right').each(function(index, element) {	
			
			$(this).attr('role','button'); /* 20180501 Accessibility Update */
			
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', false);
		});		
			
		/* apply tabindex to hotspot */
		/* 20180501 Accessibility Update */
		
		$(this).find('.hotspot_btn').each(function(index, element) {	
			
			$(this).attr('role','button'); /* 20180501 Accessibility Update */
			
			var hotTxt = $(this).next('.hotspot_btn_label').text();
						
			$(this).attr('title',hotTxt);
			
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', false);
			
			$(this).parent().next('.hotspot_reveal_inner').find('.hotspot_reveal').each(function(index, element) {	
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				/* 20240326 accessibility 2024 */
				$(this).attr('aria-hidden', false);
				
				$(this).find('a').each(function(index, element) {
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					/* 20240326 accessibility 2024 */
					$(this).attr('aria-hidden', false);
				});
                // 20190206 hotspot close functionality
                $(this).find('.hotspot_close').each(function(index, element) {
                    $(this).attr('role','button');
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					/* 20240326 accessibility 2024 */
					$(this).attr('aria-hidden', false);
				});
			});
		});	
		
		$(this).find('.hotspot_btn_close').each(function(index, element) {	
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', false);
		});
		
		
		$(this).find('.image_btn').each(function(index, element) {
			$(this).attr('role','button'); 
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', false);
			
			/* 20240326 accessibility 2024 */
			tabCnt++;
			$(this).parent().parent().parent().find('.image_start').eq(index).attr('tabindex', tabCnt);
			$(this).parent().parent().parent().find('.image_start').eq(index).attr('aria-hidden', false);
			/* accessibility updates 2025 */
			$(this).parent().parent().parent().find('.image_reveal').eq(index).find('.image_rest').each(function(index, element) {
				/* 20240326 accessibility 2024 */
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				$(this).attr('aria-hidden', false);			
				/* 20240326 accessibility 2024 */
			});
			tabCnt++;
			$(this).parent().parent().parent().find('.popup_close').eq(index).attr('role','button');
			$(this).parent().parent().parent().find('.popup_close').eq(index).attr('tabindex', tabCnt);
			$(this).parent().parent().parent().find('.popup_close').eq(index).attr('aria-hidden', false);
			
			// 20221026 Fix for links not accessible
			$(this).parent().parent().parent().find('.image_reveal').eq(index).find('a').each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				/* 20240326 accessibility 2024 */
				$(this).attr('aria-hidden', false);
			});

		});	
		
		// 202210 QA Tabbing fix
		/* 20240326 accessibility 2024 */
		$(this).find('.icon_element').each(function(index, element) {
			$(this).find('.icon_btn').each(function(index, element) {
				$(this).attr('role','button'); 
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				$(this).attr('aria-hidden', false);

				/* 20240326 accessibility 2024 */
				tabCnt++;
				$(this).parent().find('.icon_start').attr('tabindex', tabCnt);
				$(this).parent().find('.icon_start').attr('aria-hidden', false);

				/* 20240326 accessibility 2024 */
				tabCnt++;
				$(this).parent().find('.icon_rest').attr('tabindex', tabCnt);
				$(this).parent().find('.icon_rest').attr('aria-hidden', false);
			
				/* 20240326 accessibility 2024 */
				$(this).parent().find('.icon_content').find('a').each(function(index, element) {
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					$(this).attr('aria-hidden', false);
				});
			});	
		});
		
			
		$(this).find('.image_hsp_holder').each(function(index, element) {
			
			$(this).find('.image_hsp').each(function(index, element) {
				$(this).attr('role','button'); 
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				/* 20240326 accessibility 2024 */
				$(this).attr('aria-hidden', false);

				/* 20240326 accessibility 2024 */
				tabCnt++;
				$(this).parent().parent().find('.image_hotspot_start').eq(index).attr('tabindex', tabCnt);
				$(this).parent().parent().find('.image_hotspot_start').eq(index).attr('aria-hidden', false);
				
				/* 20240326 accessibility 2024 */
				tabCnt++;
				$(this).parent().parent().find('.image_hotspot_rest').eq(index).attr('tabindex', tabCnt);
				$(this).parent().parent().find('.image_hotspot_rest').eq(index).attr('aria-hidden', false);

				/* 20240326 accessibility 2024 */
				tabCnt++;
				$(this).parent().parent().find('.popup_close').eq(index).attr('role','button');
				$(this).parent().parent().find('.popup_close').eq(index).attr('tabindex', tabCnt);
				$(this).parent().parent().find('.popup_close').eq(index).attr('aria-hidden', false);
				
				// 20221026 Fix for links not accessible
				/* 20240326 accessibility 2024 */
				$(this).parent().parent().find('.image_hotspot_reveal').eq(index).find('a').each(function(index, element) {
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					$(this).attr('aria-hidden', false);
				});
			});	
			
		});
		
		
		$(this).find('.v1hspimg_btn_holder').each(function(index, element) {
			
			$(this).find('.v1hspimg_btn').each(function(index, element) {
				$(this).attr('role','button'); 
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				/* 20240326 accessibility 2024 */
				$(this).attr('aria-hidden', false);

				tabCnt++;
				
				$(this).parent().prev().find('.v1hspimg_reveal').eq(index).attr('tabindex', tabCnt);
				/* 20240326 accessibility 2024 */
				$(this).parent().prev().find('.v1hspimg_reveal').eq(index).attr('aria-hidden', false);

			});	
			
		});
		
		
		
		$(this).find('.four_image_btn').each(function(index, element) {			
			$(this).attr('role','button'); 
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', false);
			
			/* 20220630 Accessibility fix to apply tan order if image only has atl text */
			/* 20240326 accessibility 2024 */
			/* four image button accessibility 2025 */
			$(this).parent().parent().find(".four_image_reveal_content").eq(index).find('img').each(function(index, element) {
				if ($(this).attr('alt') != ''){
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					$(this).attr('aria-hidden', false);
				}
			});
			
			/* 20240326 accessibility 2024 */
			tabCnt++;
			/* four image button accessibility 2025 */
			$(this).parent().parent().find(".four_image_start").eq(index).attr('tabindex', tabCnt);
			$(this).parent().parent().find(".four_image_start").eq(index).attr('aria-hidden', false);
			
			/* 20240326 accessibility 2024 */
			tabCnt++;
			/* four image button accessibility 2025 */
			$(this).parent().parent().find(".four_image_rest").eq(index).attr('tabindex', tabCnt);
			$(this).parent().parent().find(".four_image_rest").eq(index).attr('aria-hidden', false);			
			
			/* 20240326 accessibility 2024 */
			/* four image button accessibility 2025 */
			$(this).parent().parent().find(".four_image_reveal_content").eq(index).find('a').each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				$(this).attr('aria-hidden', false);
			});			
			
			/* 20240326 accessibility 2024 */			
			/* four image button accessibility 2025 */
			$(this).parent().parent().find(".four_image_reveal").eq(index).find('.popup_close').each(function(index, element) {
				tabCnt++;
				$(this).attr('role','button');
				$(this).attr('tabindex', tabCnt);
				$(this).attr('aria-hidden', false);
			});
			
		});	
		
		// 202210 QA Tabbing fix
		$(this).find('.tab_btn').each(function(index, element) {
			$(this).attr('role','button'); 
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', false);
			
			/* 20240326 accessibility 2024 */
			tabCnt++;
			$(this).parent().parent().find(".tab_start").eq(index).attr('tabindex', tabCnt);
			$(this).parent().parent().find(".tab_start").eq(index).attr('aria-hidden', false);
			
			/* 20240326 accessibility 2024 */
			tabCnt++;
			$(this).parent().parent().find(".tab_rest").eq(index).attr('tabindex', tabCnt);
			$(this).parent().parent().find(".tab_rest").eq(index).attr('aria-hidden', false);
			
			/* 20221019 include links in the tab order in a tabbed reveal */
			$(this).parent().parent().find(".tab_reveal").eq(index).find('a').each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				/* 20240326 accessibility 2024 */
				$(this).attr('aria-hidden', false);
			});
				
			/* 20220630 Accessibility fix to apply tan order if image only has atl text */
			$(this).parent().parent().find(".tab_reveal").eq(index).find('img').each(function(index, element) {					
				if ($(this).attr('alt') != ''){
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					/* 20240326 accessibility 2024 */
					$(this).attr('aria-hidden', false);
				}
			});
			
		});	
		
		/* flip card 2022 */
		$(this).find('.flip_card').each(function(index, element) {			
			
			$(this).find('.flip_card_front').each(function(index, element) {
				$(this).attr('role','button'); 
			});
		  	$(this).find('.flip_card_back').each(function(index, element) {
				if(document.allowFlipBack){ // 20221025 Flipcard link fix
					$(this).attr('role','button');				
				}
			});
			tabCnt++;			
			$(this).find('.flip_card_inner').each(function(index, element) {
				if ($(this).hasClass('flipped'))
				{
					$(this).find('.flip_card_front').each(function(index, element) {
						$(this).attr('tabindex', -1);
						/* 20240326 accessibility 2024 */
						$(this).attr('aria-hidden', true);
					});
					$(this).find('.flip_card_back').each(function(index, element) {
						$(this).attr('tabindex', tabCnt);
						/* 20240326 accessibility 2024 */
						$(this).attr('aria-hidden', false);
						/* Flip Card Scroll Accessibility Fix 2023 -- */
						/* 20240326 accessibility 2024 */
						$(this).find('.flip_start').each(function(index, element) {
							tabCnt++;
							$(this).attr('tabindex', tabCnt);
							$(this).attr('aria-hidden', false);
						});
						/* 20240326 accessibility 2024 */
						$(this).find('.flip_rest').each(function(index, element) {
							tabCnt++;
							$(this).attr('tabindex', tabCnt);
							$(this).attr('aria-hidden', false);
						});
						/* -- Flip Card Scroll Accessibility Fix 2023 */
						// 20221025 Flipcard link fix
						$(this).find('a').each(function(index, element) {
							tabCnt++;
							$(this).attr('tabindex', tabCnt);
							/* 20240326 accessibility 2024 */
							$(this).attr('aria-hidden', false);
						});
					});
				}
				else
				{
					$(this).find('.flip_card_front').each(function(index, element) {
						$(this).attr('tabindex', tabCnt);
						$(this).attr('data-tab', tabCnt); /* Flip Card Scroll Accessibility Fix 2023 */
						/* 20240326 accessibility 2024 */
						$(this).attr('aria-hidden', false);
					});
					$(this).find('.flip_card_back').each(function(index, element) {
						$(this).attr('tabindex', -1);
						/* 20240326 accessibility 2024 */
						$(this).attr('aria-hidden', true);
						// 20221025 Flipcard link fix
						/* Flip Card Scroll Accessibility Fix 2023 -- */
						/* 20240326 accessibility 2024 */
						$(this).find('.flip_start').each(function(index, element) {
							$(this).attr('tabindex', -1);
							tabCnt++;
							$(this).attr('data-tab', tabCnt);
							$(this).attr("aria-hidden", true);
						});
						/* 20240326 accessibility 2024 */
						$(this).find('.flip_rest').each(function(index, element) {
							$(this).attr('tabindex', -1);
							tabCnt++;
							$(this).attr('data-tab', tabCnt);
							$(this).attr("aria-hidden", true);
						});
						/* -- Flip Card Scroll Accessibility Fix 2023 */

						$(this).find('a').each(function(index, element) {
							tabCnt++;
							$(this).attr('data-tab', tabCnt);
							$(this).attr("aria-hidden", true);
						});
					});
				}
			});				
			/* flip card question v4.0 2025 */
			/* 20240326 accessibility 2024 */
			tabCnt++;
			$(this).parent().parent().parent().find('.flip_question_reveal_start').eq(index).attr('tabindex', tabCnt);
			$(this).parent().parent().parent().find('.flip_question_reveal_start').eq(index).attr('aria-hidden', false);
			/* 20240326 accessibility 2024 */
			tabCnt++;
			$(this).parent().parent().parent().find('.flip_question_reveal_rest').eq(index).attr('tabindex', tabCnt);
			$(this).parent().parent().parent().find('.flip_question_reveal_rest').eq(index).attr('aria-hidden', false);			
			/* 20240326 accessibility 2024 */
			tabCnt++;
			$(this).parent().parent().parent().find('.popup_close').eq(index).attr('role','button');
			$(this).parent().parent().parent().find('.popup_close').eq(index).attr('tabindex', tabCnt);
			$(this).parent().parent().parent().find('.popup_close').eq(index).attr('aria-hidden', false);
			
			// 20221026 Fix for links not accessible
			$(this).parent().parent().parent().find('.flip_question_reveal').eq(index).find('a').each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				/* 20240326 accessibility 2024 */
				$(this).attr('aria-hidden', false);
			});
		});

		/* Timeline/Sequence Accessibility Fix 2023 -- */
		$(this).find('.timeline_container').each(function(index, element) {

			$(this).find('.timeline_item').each(function(index, element) {

				$(this).find('.timeline_item_right').each(function(index, element) {
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					/* 20240326 accessibility 2024 */
					$(this).attr('aria-hidden', false);
				});

				$(this).find('.timeline_item_left_content').each(function(index, element) {
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					/* 20240326 accessibility 2024 */
					$(this).attr('aria-hidden', false);
				});

			});
		});
		/* -- Timeline/Sequence Accessibility Fix 2023 */
		
		/* 20221020 ensure tab order of text content after activity is following activity */
		$(this).find('.content_text_after_activity').each(function(index, element) {
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20221101 ensure links within text content after activity are tabbed to after the content */
			$(this).find('a').each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
			});
		});
        
        $(this).find('.complete_arrow').each(function(index, element) { /* 20180501 Accessibility Update */
            $(this).attr('role','button');
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', false);
		});
		
		/* 20240326 accessibility 2024 */
		$(this).find('.tab_next_btn').each(function(index, element) {				
			$(this).attr('aria-hidden', false);
		});	
		$(this).find('.image_next_btn').each(function(index, element) {				
			$(this).attr('aria-hidden', false);
		});
		$(this).find('.image_this_btn').each(function(index, element) {				
			$(this).attr('aria-hidden', false);
		});
		/* flip card question v4.0 2025 */
		$(this).find('.flip_question_reveal_next_btn').each(function(index, element) {				
			$(this).attr('aria-hidden', false);
		});
		$(this).find('.flip_question_reveal_this_btn').each(function(index, element) {				
			$(this).attr('aria-hidden', false);
		});
		
		/* 20240326 accessibility 2024 */
		$(".topic_nav_bar .branding_holder .branding .copyright").attr('aria-hidden', true);
		
    });
	
	$(":input").attr("aria-hidden", false); /* 20220628 JAWS fix to stop item being read when course launches */
	
	navTabCnt = tabCnt; /* 20180501 Accessibility Update */

	document.onmousedown = hideFocusOutline;

    function hideFocusOutline() {
	    $('[tabindex]').focus(function()
		{
			$(this).css('outline', 'none');
		});
		$('[tabindex]').focusout(function()
		{
			$(this).css('outline', 'none');
		});
		$('[tabindex]').keyup(function (event)
		{
			if(event.keyCode == 9)
			{
				$(this).css('outline', '');
			}
		});
    }	
	
}

/* 20180501 Accessibility Update */
function setNavTab(){
	
	var tabCnt = navTabCnt;
	tabCnt++
	$(".nav_instruction .instruction").attr('tabindex', tabCnt); // 202210 QA Tabbing fix
	$(".nav_instruction .instruction").attr('aria-hidden', false); // accessibility fixes 2025
	tabCnt++
	$('#left_nav').attr('tabindex', tabCnt);
	tabCnt++;
	$('#home_nav').attr('tabindex', tabCnt);
	tabCnt++;
	$('#right_nav').attr('tabindex', tabCnt);
	tabCnt++;
	$('.copyright').attr('tabindex', tabCnt);
		
	/* 20220628 JAWS fix to stop item being read when course launches */
	$('#left_nav').attr("aria-hidden", false);
	$('#home_nav').attr("aria-hidden", false);
	$('#right_nav').attr("aria-hidden", false);
	/* 20240326 accessibility 2024 */
	$('.copyright').attr("aria-hidden", false);
	/* 20220628 JAWS fix to stop item being read when course launches */
}
/* 20180501 Accessibility Update */

/* 20180501 Accessibility Update Remove tab functionality from content */
function removeTabIndex(){	

	/* 20240326 accessibility 2024 */
	$('.loader_percent').attr('aria-hidden', true);
	
	/* reskin v4.0 2025 */
	$('.bar_robot').find('.menu_course_title').each(function(index, element) {
		$(this).attr('tabindex', -1);
		$(this).attr('aria-hidden', true);
		/*$(this).css('visibility','hidden');*/ /* reskin v4.0 2025 */ /* uncomment if resources button is to be hidden */
	});		
	// 20221018 QA fix for tabbing to buttons when resource/hotword popup visible
	$('.bar_robot').find('.home').each(function(index, element) { 
		$(this).attr('tabindex', -1);
		/* 20240326 accessibility 2024 */
		$(this).attr('aria-hidden', true);
		/*$(this).css('visibility','hidden');*/ /* reskin v4.0 2025 */ /* uncomment if resources button is to be hidden */
	});
	// 20221018 QA fix for tabbing to buttons when resource/hotword popup visible
	$('.bar_robot').find('.switchLang').each(function(index, element) { 
		$(this).attr('tabindex', -1);
		/* 20240326 accessibility 2024 */
		$(this).attr('aria-hidden', true);
	});
	
	$('.bar_robot').find('.bar_close').each(function(index, element) {
		$(this).attr('tabindex', -1);
		/* 20240326 accessibility 2024 */
		$(this).attr('aria-hidden', true);
	});
	$('.bar_robot').find('.page').each(function(index, element) {
		$(this).attr('tabindex', -1);
		/* 20240326 accessibility 2024 */
		$(this).attr('aria-hidden', true);
	});

	/* Progress Indicator 2023 -- */
	$(".course_progress").attr('tabindex', -1);
	$(".course_progress").attr('aria-hidden', true);
	/* -- Progress Indicator 2023 */
	
	$('.sec_rest_wrapper').find('.section').each(function(index, element) {
		
		$(this).find('.h2_inner').each(function(index, element) {
			$(this).attr('tabindex', -1);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', true);
		});
		
		$(this).find('.content_text').each(function(index, element) {
			$(this).attr('tabindex', -1);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', true);
			/* 20221021 ensure links within main content are tabbed to after the content */
			$(this).find('a').each(function(index, element) {
				$(this).attr('tabindex', -1);
				/* 20240326 accessibility 2024 */
				$(this).attr('aria-hidden', true);
			});
		});
				
		/* 20221107 Accessibility fix to apply tab order if image only has alt text */
		$(this).find('img').each(function(index, element) {
			$(this).attr('tabindex', -1);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', true);
		});
		
		$(this).find('.expando_btn').each(function(index, element) {
			$(this).attr('tabindex', -1);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', true);
			
			$(this).next('.expando_reveal').each(function(index, element){
				$(this).find('.expando_reveal_content').each(function(index, element) {	
					/* 20240326 accessibility 2024 */
					$(this).find('.exp_start').attr('tabindex', -1);
					$(this).find('.exp_start').attr('aria-hidden', true);
					
					$(this).find('.exp_rest').attr('tabindex', -1);
					$(this).find('.exp_rest').attr('aria-hidden', true);

					$(this).find('a').each(function(index, element) {
						$(this).attr('tabindex', -1);
						/* 20240326 accessibility 2024 */
						$(this).attr('aria-hidden', true);
					});
					
					/* 20221107 Accessibility fix to apply tab order if image only has alt text */
					$(this).find('img').each(function(index, element) {
						$(this).attr('tabindex', -1);
						/* 20240326 accessibility 2024 */
						$(this).attr('aria-hidden', true);
					});

				});

				$(this).find('.expando_reveal_heading').each(function(index, element) {
					$(this).attr('tabindex', -1);
					/* 20240326 accessibility 2024 */
					$(this).attr('aria-hidden', true);
				});
			});
						
		});
		
		/* 20240326 accessibility 2024 */
		$(this).find('.video_poster').each(function(index, element) {
			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
		});	
		
		/* 20240326 accessibility 2024 */
		/* remove tabindex to video */
		$(this).find('.video_player').each(function(index, element) {
			$(this).attr('tabindex', -1);
			/* 20231026 video accessibility */
			$(this).attr('aria-hidden', true);
		});	
		/* remove tabindex to audio */
		$(this).find('.audio_player').each(function(index, element) {
			$(this).attr('tabindex', -1);
			/* 20231026 video accessibility */
			$(this).attr('aria-hidden', true);
		});		
		$(this).find('.transcript_text').each(function(index, element) {	
			$(this).attr('tabindex', -1);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', true);
		});
		/* 20240326 accessibility 2024 */
		$(this).find('.transcript_btn').each(function(index, element) {	
			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
		});
		/* remove tabindex to questions */	
        $(this).find('.qItemFirst').each(function(index, element) {
			$(this).attr('tabindex', -1);
			$(this).attr("aria-hidden", true);
			/* 20220628 JAWS fix to stop item being read when course launches */
		});
		$(this).find('.squaredBox').each(function(index, element) {
			$(this).attr('tabindex', -1);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', true);
		});
				
		$(this).find('.mc_btn').each(function(index, element) {
            $(this).attr('tabindex', -1);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', true);
        });
		$(this).find('.submit_btn').each(function(index, element) {	
			$(this).attr('tabindex', -1);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', true);
		});	
		
		/* 20240326 accessibility 2024 */
		$(this).find('.feedback_rest').each(function(index, element) {
			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
			
			$(this).find('a').each(function(index, element) {
				$(this).attr('tabindex', -1);
				$(this).attr('aria-hidden', true);
			});
		});
		
		/* 20240326 accessibility 2024 */
		$(this).find('.feedback_start').each(function(index, element) {	
			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
			
			$(this).find('a').each(function(index, element) {
				$(this).attr('tabindex', -1);
				$(this).attr('aria-hidden', true);
			});
		});
		
		$(this).find('.retake_assess_btn').each(function(index, element) {	
			$(this).attr('tabindex', -1);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', true);
		});

		/* retake course button 2025 */
		$(this).find('.retake_course_btn').each(function(index, element) {	
			$(this).attr('tabindex', -1);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', true);
		});

		/* 20240326 accessibility 2024 */
		$(this).find('.confirm_attest_btn').each(function(index, element) {
			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
		});
		
		/* 20231016 Likert accessibility */
		// 20221013 JAWS fix
		$(this).find('.results_review_text').each(function(index, element) {
			$(this).attr('tabindex', -1);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', true);
		});
		
		/* 20231016 Likert accessibility */
		/* 20230912 Fixes for client review of prototype */
		$(this).find(".likert_row").each(function(index, element) {
			$(this).find(".statement").each(function(index, element) {
				$(this).attr('tabindex', -1);
				/* 20240326 accessibility 2024 */
				$(this).attr('aria-hidden', true);
			});
			$(this).find(".likert_rb").each(function(index, element) {
				$(this).attr('tabindex', -1);
				/* 20240326 accessibility 2024 */
				$(this).attr('aria-hidden', true);
			});
		});

		/* remove tabindex to slider */		
		$(this).find('.slider_txt').each(function(index, element) {		
			/* 20240326 accessibility 2024 */
			$(this).find('.slider_col_left').each(function(index, element) {
				/* 20240326 accessibility 2024 */
				$(this).find('.slider_start').attr('tabindex', -1);
				$(this).find('.slider_start').attr('aria-hidden', true);
				
				/* 20240326 accessibility 2024 */
				$(this).find('.slider_rest').attr('tabindex', -1);
				$(this).find('.slider_rest').attr('aria-hidden', true);
			});	
			
			$(this).find('a').each(function(index, element) {
				$(this).attr('tabindex', -1);
				/* 20240326 accessibility 2024 */
				$(this).attr('aria-hidden', true);
			});
			
		});
		/* 20240326 accessibility 2024 */
		$(this).find('.slide_left').each(function(index, element) {	
			$(this).attr('tabindex', -1);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', true);
		});
		/* 20240326 accessibility 2024 */
		$(this).find('.slide_right').each(function(index, element) {	
			$(this).attr('tabindex', -1);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', true);
		});
		/* remove tabindex to hotspot */
		$(this).find('.hotspot_btn').each(function(index, element) {	
			$(this).attr('tabindex', -1);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', true);
		});	
		$(this).find('.hotspot_reveal').each(function(index, element) {	
			$(this).attr('tabindex', -1);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', true);
		});	
		
		$(this).find('.hotspot_reveal').each(function(index, element) {	
			
			$(this).find('a').each(function(index, element) {
				$(this).attr('tabindex', -1);
				/* 20240326 accessibility 2024 */
				$(this).attr('aria-hidden', true);
			});
            
            $(this).find('.hotspot_close').each(function(index, element) {
                $(this).attr('tabindex', -1);
				/* 20240326 accessibility 2024 */
				$(this).attr('aria-hidden', true);
            });
			
		});	
		
		$(this).find('.hotspot_btn_close').each(function(index, element) {	
			$(this).attr('tabindex', -1);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', true);
		});
		
		
		
		$(this).find('.image_btn').each(function(index, element) {
	
			$(this).attr('tabindex', -1);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', true);
			/* 20240326 accessibility 2024 */
			$(this).parent().parent().parent().find('.image_start').eq(index).attr('tabindex', -1);
			$(this).parent().parent().parent().find('.image_start').eq(index).attr('aria-hidden', true);
			/* 20240326 accessibility 2024 */
			$(this).parent().parent().parent().find('.image_rest').eq(index).attr('tabindex', -1);
			$(this).parent().parent().parent().find('.image_rest').eq(index).attr('aria-hidden', true);
			/* 20240326 accessibility 2024 */
			$(this).parent().parent().parent().find('.popup_close').eq(index).attr('tabindex', -1);
			$(this).parent().parent().parent().find('.popup_close').eq(index).attr('aria-hidden', true);
			
			// 20221026 Fix for links not accessible
			/* 20240326 accessibility 2024 */
			$(this).parent().parent().parent().find('.image_reveal').eq(index).find('a').each(function(index, element) {
				$(this).attr('tabindex', -1);
				$(this).attr('aria-hidden', true);
			});
						
		});	
		
		$(this).find('.icon_element').each(function(index, element) {
			$(this).find('.icon_btn').each(function(index, element) {

				$(this).attr('tabindex', -1);
				/* 20240326 accessibility 2024 */
				$(this).attr('aria-hidden', true);
				
				/* 20240326 accessibility 2024 */
				$(this).parent().find('.icon_start').eq(index).attr('tabindex', -1);
				$(this).parent().find('.icon_start').eq(index).attr('aria-hidden', true);
			
				/* 20240326 accessibility 2024 */
				$(this).parent().find('.icon_rest').eq(index).attr('tabindex', -1);
				$(this).parent().find('.icon_rest').eq(index).attr('aria-hidden', true);
				
				/* 20240326 accessibility 2024 */
				$(this).parent().find('.icon_content').eq(index).find('a').each(function(index, element) {
					$(this).attr('tabindex', -1);
					$(this).attr('aria-hidden', true);
				});
			});	
		});
		
		$(this).find('.image_hsp_holder').each(function(index, element) {
			
			$(this).find('.image_hsp').each(function(index, element) {
				$(this).attr('tabindex', -1);
				/* 20240326 accessibility 2024 */
				$(this).attr('aria-hidden', true);
				
				/* 20240326 accessibility 2024 */
				$(this).parent().parent().find('.image_hotspot_start').eq(index).attr('tabindex', -1);
				$(this).parent().parent().find('.image_hotspot_rest').eq(index).attr('aria-hidden', true);
				
				/* 20240326 accessibility 2024 */
				$(this).parent().parent().find('.image_hotspot_rest').eq(index).attr('tabindex', -1);
				$(this).parent().parent().find('.image_hotspot_start').eq(index).attr('aria-hidden', true);
				
				/* 20240326 accessibility 2024 */
				$(this).parent().parent().find('.popup_close').eq(index).attr('tabindex', -1);
				$(this).parent().parent().find('.popup_close').eq(index).attr('aria-hidden', true);

				// 20221026 Fix for links not accessible
				/* 20240326 accessibility 2024 */
				$(this).parent().parent().find('.image_hotspot_reveal').eq(index).find('a').each(function(index, element) {					
					$(this).attr('tabindex', -1);
					$(this).attr('aria-hidden', true);
				});
			});
			
		});
		
		$(this).find('.v1hspimg_btn_holder').each(function(index, element) {
			
			$(this).find('.v1hspimg_btn').each(function(index, element) {
				$(this).attr('tabindex', -1);
				/* 20240326 accessibility 2024 */
				$(this).attr('aria-hidden', true);
				$(this).parent().prev().find('.v1hspimg_reveal').eq(index).attr('tabindex', -1);
				/* 20240326 accessibility 2024 */
				$(this).parent().prev().find('.v1hspimg_reveal').eq(index).attr('aria-hidden', true);

			});
			
		});
		
		$(this).find('.four_image_btn').each(function(index, element) {
			$(this).attr('tabindex', -1);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', true);
			
			/* 20240326 accessibility 2024 */
			$(this).parent().parent().find('.four_image_reveal_content').eq(index).find('img').each(function(index, element) {
				$(this).attr('tabindex', -1);
				$(this).attr('aria-hidden', true);
			});
			
			/* 20240326 accessibility 2024 */
			$(this).parent().parent().find('.four_image_start').eq(index).attr('tabindex', -1);
			$(this).parent().parent().find('.four_image_start').eq(index).attr('aria-hidden', true);
			
			/* 20240326 accessibility 2024 */
			$(this).parent().parent().find('.four_image_rest').eq(index).attr('tabindex', -1);
			$(this).parent().parent().find('.four_image_rest').eq(index).attr('aria-hidden', true);
			
			/* 20240326 accessibility 2024 */
			$(this).parent().parent().find('.four_image_reveal_content').eq(index).find('a').each(function(index, element) {
				$(this).attr('tabindex', -1);
				$(this).attr('aria-hidden', true);
			});	

			
			/* 20240326 accessibility 2024 */			
			$(this).parent().parent().parent().find('.four_image_reveal').eq(index).find('.popup_close').each(function(index, element) {				
				$(this).attr('tabindex', -1);
				$(this).attr('aria-hidden', true);
			});
			
		});	
		
		$(this).find('.tab_btn').each(function(index, element) {
			
			$(this).attr('tabindex', -1);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', true);
			
			/* 20240326 accessibility 2024 */
			$(".tab_start").eq(index).attr('tabindex', -1);
			$(".tab_start").eq(index).attr('aria-hidden', true);
			
			/* 20240326 accessibility 2024 */
			$(".tab_rest").eq(index).attr('tabindex', -1);
			$(".tab_rest").eq(index).attr('aria-hidden', true);
			
			/* 20221019 include links in the tab order in a tabbed reveal */
			$(".tab_reveal").eq(index).find('a').each(function(index, element) {	
				$(this).attr('tabindex', -1);
				/* 20240326 accessibility 2024 */
				$(this).attr('aria-hidden', true);
			});

			/* 20220630 Accessibility fix to apply tan order if image only has atl text */
			/* 20240326 accessibility 2024 */
			$(".tab_reveal").eq(index).find('img').each(function(index, element) {
				$(this).attr('tabindex', -1);
				$(this).attr('aria-hidden', true);
			});
			
		});	
		
		$(this).find('.flip_card').each(function(index, element) {
			
			
			$(this).find('.flip_card_front').each(function(index, element) {
			
				$(this).attr('tabindex', -1);
				/* 20240326 accessibility 2024 */
				$(this).attr('aria-hidden', true);
				
			})
												  
		  	$(this).find('.flip_card_back').each(function(index, element) {
		
				$(this).attr('tabindex', -1);
				/* 20240326 accessibility 2024 */
				$(this).attr('aria-hidden', true);
				/* Flip Card Scroll Accessibility Fix 2023 -- */
				// 20230403 Flipcard tab fix
				/* 20240326 accessibility 2024 */
				$(this).find('.flip_start').each(function(index, element) {
					$(this).attr('tabindex', -1);
					$(this).attr('aria-hidden', true);
				});
				/* 20240326 accessibility 2024 */
				$(this).find('.flip_rest').each(function(index, element) {
					$(this).attr('tabindex', -1);
					$(this).attr('aria-hidden', true);
				});
				/* -- Flip Card Scroll Accessibility Fix 2023 */
				// 20221025 Flipcard link fix
				$(this).find('a').each(function(index, element) {
					$(this).attr('tabindex', -1);
					/* 20240326 accessibility 2024 */
					$(this).attr('aria-hidden', true);
				});
			})
			
			/* flip card question v4.0 2025 */
			/* 20240326 accessibility 2024 */
			$(this).parent().parent().parent().find('.flip_question_reveal_start').eq(index).attr('tabindex', -1);
			$(this).parent().parent().parent().find('.flip_question_reveal_start').eq(index).attr('aria-hidden', true);
			/* 20240326 accessibility 2024 */
			$(this).parent().parent().parent().find('.flip_question_reveal_rest').eq(index).attr('tabindex', -1);
			$(this).parent().parent().parent().find('.flip_question_reveal_rest').eq(index).attr('aria-hidden', true);
			/* 20240326 accessibility 2024 */
			$(this).parent().parent().parent().find('.popup_close').eq(index).attr('tabindex', -1);
			$(this).parent().parent().parent().find('.popup_close').eq(index).attr('aria-hidden', true);
			
			// 20221026 Fix for links not accessible
			/* 20240326 accessibility 2024 */
			$(this).parent().parent().parent().find('.flip_question_reveal').eq(index).find('a').each(function(index, element) {
				$(this).attr('tabindex', -1);
				$(this).attr('aria-hidden', true);
			});
			
		});	

		/* 20240326 accessibility 2024 */
		$(this).find('.tab_next_btn').each(function(index, element) {				
			$(this).attr('aria-hidden', true);
		});	
		$(this).find('.image_next_btn').each(function(index, element) {				
			$(this).attr('aria-hidden', true);
		});
		$(this).find('.image_this_btn').each(function(index, element) {
			$(this).attr('aria-hidden', true);
		});
		/* flip card question v4.0 2025 */
		$(this).find('.flip_question_reveal_next_btn').each(function(index, element) {
			$(this).attr('aria-hidden', true);
		});
		$(this).find('.flip_question_reveal_this_btn').each(function(index, element) {
			$(this).attr('aria-hidden', true);
		});
		
		/* Timeline/Sequence Accessibility Fix 2023 -- */
		$(this).find('.timeline_content').each(function(index, element) {

			$(this).find('.timeline_item').each(function(index, element) {

				$(this).find('.timeline_item_right').each(function(index, element) {
					$(this).attr('tabindex', -1);
					/* 20240326 accessibility 2024 */
					$(this).attr('aria-hidden', true);
				});

				$(this).find('.timeline_item_left_content').each(function(index, element) {
					$(this).attr('tabindex', -1);
					/* 20240326 accessibility 2024 */
					$(this).attr('aria-hidden', true);
				});
			});
		});
		/* -- Timeline/Sequence Accessibility Fix 2023 */

        
        $(this).find('.complete_arrow').each(function(index, element) { /* 20180501 Accessibility Update */
			$(this).attr('tabindex', -1);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', true);
		});
		
    });
	
	$(".nav_instruction .instruction").attr('tabindex', -1); // 202210 QA Tabbing fix
	/* 20240326 accessibility 2024 */
	$(".nav_instruction .instruction").attr('aria-hidden', true);
	$('#left_nav').attr('tabindex', -1);
	$('#home_nav').attr('tabindex', -1);
	$('#right_nav').attr('tabindex', -1);
	$('.copyright').attr('tabindex', -1);
	
	/* 20220628 JAWS fix to stop item being read when course launches */
	$('#left_nav').attr("aria-hidden", true);
	$('#home_nav').attr("aria-hidden", true);
	$('#right_nav').attr("aria-hidden", true);
	/* 20240326 accessibility 2024 */
	$('.copyright').attr("aria-hidden", true);
	/* 20220628 JAWS fix to stop item being read when course launches */
	
	$(":input").attr("aria-hidden", true); /* 20220628 JAWS fix to stop item being read when course launches */

}
/* 20180501 Accessibility Update Remove tab functionality from content */

/* close button is always hidden */
/*if(!isWeb){
	$('.topic_index .bar_close').css('display','none');
}else{
	$('.topic_index .bar_close').css('display','block');
}*/

/* apply button text and title attribute to interface buttons */
function interfaceStrings(){
	
	$('.index_banner_logo').attr('title', localiseString('course_logo'));
	$('.index_banner_logo').attr('alt', localiseString('course_logo'));
	
	$('.transcript_btn').html(localiseString('transcript_btn'));
	$('.transcript_btn').attr('title',localiseString('transcript_btn'));
	$('.transcript_btn').attr('alt',localiseString('transcript_btn'));

	/* splash video v4.0 2025 */
	$('.continue_vid_btn').html(localiseString('continue_vid_btn'));
	$('.continue_vid_btn').attr('title',localiseString('continue_vid_btn'));
	$('.continue_vid_btn').attr('alt',localiseString('continue_vid_btn'));
	
	/* splash video v4.0 2025 */
	$('.return_vid_btn').html(localiseString('return_vid_btn'));
	$('.return_vid_btn').attr('title',localiseString('return_vid_btn'));
	$('.return_vid_btn').attr('alt',localiseString('return_vid_btn'));
	
	/* branch menu 2025 */
	$('.return_branch_menu_btn').html(localiseString('return_branch_menu_btn'));
	$('.return_branch_menu_btn').attr('title',localiseString('return_branch_menu_btn'));
	$('.return_branch_menu_btn').attr('alt',localiseString('return_branch_menu_btn'));

	$('.submit_btn').html(localiseString('submit_btn'));
	$('.submit_btn').attr('title',localiseString('submit_btn_locked'));
	$('.submit_btn').attr('alt',localiseString('submit_btn_locked'));
	
	$('.conf_btn').html(localiseString('conf_btn'));
	$('.conf_btn').attr('title',localiseString('conf_btn'));
	$('.conf_btn').attr('alt',localiseString('conf_btn'));
	
	$('.notconf_btn').html(localiseString('notconf_btn'));
	$('.notconf_btn').attr('title',localiseString('notconf_btn'));
	$('.notconf_btn').attr('alt',localiseString('notconf_btn'));
	
	$('.tryagain_btn').html(localiseString('tryagain_btn'));
	$('.tryagain_btn').attr('title',localiseString('tryagain_btn'));
	$('.tryagain_btn').attr('alt',localiseString('tryagain_btn'));
	
	$('.home').attr('title', localiseString('menu_nav'));
	$('.home').html(localiseString('home_nav'));
	$('.switchLang').attr('title', localiseString('lang_btn'));
	$('.switchLang').html(localiseString('lang_btn'));
	//$('.home').attr('alt', localiseString('menu_nav'));
	$('#home_nav').attr('title', localiseString('home_nav'));
	//$('#home_nav').attr('alt', localiseString('home_nav'));
	/* test out: if there is a pre-test and it has been attempted and at least one topic has been tested out of hide the left and right nav buttons */
	if ((document.pretestPresent == 1) && (document.pretestAttempted == 1) && (document.topicsPretestedOut.indexOf("1") != -1))
	{
		//$('#left_nav').hide();
		//$('#right_nav').hide();
		//$('#home_nav').addClass("pretest");
	}
	else {
		//$('#right_nav').attr('title', localiseString('right_nav'));
		//$('#right_nav').attr('alt', localiseString('right_nav'));
		//$('#left_nav').attr('title', localiseString('left_nav'));
		//$('#left_nav').attr('alt', localiseString('left_nav'));
	}
	$('.page').attr('title', localiseString('resource_btn'));
	$('.page').html(localiseString('resource_btn'));
	//$('.page').attr('alt', localiseString('resource_btn'));
	$('.bar_close').attr('title', localiseString('exit_nav'));
	$('.bar_close').html(localiseString('exit_nav'));
	//$('.bar_close').attr('alt', localiseString('exit_nav'));
	
	$('.box_closer').attr('title', localiseString('close_btn'));
	//$('.box_closer').attr('alt', localiseString('close_btn'));
	
	$('.bookmark_nav_start').html(localiseString('bookmark_nav_start'));
	$('.bookmark_nav_start').attr('title', localiseString('bookmark_nav_start'));
	$('.bookmark_nav_start').attr('alt', localiseString('bookmark_nav_start'));
	$('.bookmark_nav_resume').html(localiseString('bookmark_nav_resume'));
	$('.bookmark_nav_resume').attr('title', localiseString('bookmark_nav_resume'));
	$('.bookmark_nav_resume').attr('alt', localiseString('bookmark_nav_resume'));
	$('#bm_title').html(localiseString('bookmark_title'));
	$('#bm_text').html(localiseString('bookmark_text'));
	
	/* role selection 2023 */
	$('.role_selection_1').attr('title', localiseString('role_selection_1_title'));
	$('.role_selection_1').attr('alt', localiseString('role_selection_1_title'));
	$('.role_selection_2').attr('title', localiseString('role_selection_2_title'));
	$('.role_selection_2').attr('alt', localiseString('role_selection_2_title'));
	$('.role_selection_3').attr('title', localiseString('role_selection_3_title'));
	$('.role_selection_3').attr('alt', localiseString('role_selection_3_title'));
	$('.role_selection_4').attr('title', localiseString('role_selection_4_title'));
	$('.role_selection_4').attr('alt', localiseString('role_selection_4_title'));
	$('.role_selection_5').attr('title', localiseString('role_selection_5_title'));
	$('.role_selection_5').attr('alt', localiseString('role_selection_5_title'));
	$('.role_selection_6').attr('title', localiseString('role_selection_6_title'));
	$('.role_selection_6').attr('alt', localiseString('role_selection_6_title'));
	$('.role_selection_7').attr('title', localiseString('role_selection_7_title'));
	$('.role_selection_7').attr('alt', localiseString('role_selection_7_title'));
	$('.role_selection_8').attr('title', localiseString('role_selection_8_title'));
	$('.role_selection_8').attr('alt', localiseString('role_selection_8_title'));
	
	$('.slide_right').attr('title', localiseString('slide_right'));
	$('.slide_right').attr('alt', localiseString('slide_right'));
	$('.slide_left').attr('title', localiseString('slide_left'));
	$('.slide_left').attr('alt', localiseString('slide_left'));
	/* 20221102 ensure leftmost slide button has unavailable title and alt text initially if linear sliders */
	if (document.sliderLinear)
	{	
		$('.slide_left').attr('title', localiseString('left_nav_locked'));
		$('.slide_left').attr('alt', localiseString('left_nav_locked'));
	}
	$('.temp_slide_nums').attr('title', localiseString('slide_progress'));
	$('.temp_slide_nums').attr('alt', localiseString('slide_progress'));
	
	$('.complete_arrow').attr('title', localiseString('complete_arrow'));
	$('.complete_arrow').attr('alt', localiseString('complete_arrow'));
	//$('.complete_arrow').html(localiseString('complete_arrow'));
	
	/* 20240216 customized homepage menu */
	$('.topic_select').find('.progress').each(function(index, element) {
		if ($(this).hasClass('progress_locked')) {
			$(this).parent().find('.progress_text').eq(0).html(localiseString('topic_locked_label'));
			/* 20240326 accessibility 2024 */
			$(this).parent().find('.progress').eq(0).html(localiseString('topic_locked'));
		}
		else {
			$(this).parent().find('.progress_text').eq(0).html(localiseString('topic_start_label'));
			/* 20240326 accessibility 2024 */
			$(this).parent().find('.progress').eq(0).html(localiseString('topic_start'));
		}
	});
	$('.topic_select').attr('alt', localiseString('topic_start'));
	$('.topic_select').attr('title', localiseString('topic_start'));
    
	/* 103023 handling of src possibly returning full url from some browsers in LMS */
    $('.burger_select').find('.start_img').each(function(index, element) {
	   if($(this).attr('src').indexOf('images/interface/burger_locked.png') == -1) {
		   $(this).attr('alt', localiseString('topic_start'));
		   $(this).attr('title', localiseString('topic_start'));		   
	   }else{		   
		   $(this).attr('alt', localiseString('topic_locked'));
		   $(this).attr('title', localiseString('topic_locked'));
	   }
    });
	
	/* 120723 arrow up/down issue: make the states of the topic buttons more consistent on Win 10 Chrome */
	/*$('.progress').attr('alt', localiseString('topic_incomplete'));
	$('.progress').attr('title', localiseString('topic_incomplete'));*/
	
	//$(".menu_grid h1").html(document.courseTitle);
	//$(".home_title h1").html(document.courseTitle);
	//$(".home_title").css("display","block");

	$(".retake_assess_btn").html(localiseString('retake_test_button'));
	$(".retake_course_btn").html(localiseString('retake_course_button'));
	/* pre-test no topics associated with questions support kgs 03/18/22 */
	if (document.noTopicsAssociatedPretest)
	{
		$(".home_assess_btn").html(localiseString('home_assess_button'));
	}
	
	/* 20231016 Likert accessibility */
	$(".survey_opt_in_btn_div .survey_btn").html(localiseString('survey_opt_in_button'));
	$(".survey_opt_in_btn_div .survey_btn").attr('alt', localiseString('survey_opt_in_button'));
	$(".survey_opt_in_btn_div .survey_btn").attr('title', localiseString('survey_opt_in_button'));
	$(".survey_opt_out_btn_div .survey_btn").html(localiseString('survey_opt_out_button'));
	$(".survey_opt_out_btn_div .survey_btn").attr('alt', localiseString('survey_opt_out_button'));
	$(".survey_opt_out_btn_div .survey_btn").attr('title', localiseString('survey_opt_out_button'));
	
	$(".confirm_attest_btn").html(localiseString('confirm_attest_button'));
    
    $(".hotspot_close").attr('title',localiseString('hotspot_close'));
    
    if(!document.showFooterNav){
        $(".topic_nav_button").css("display","none");
        $(".topic_nav_bar_holder").css("height","100px");
        $(".topic_nav_bar_holder .branding").css("top","50px");
    }
    
    if(!document.showResourcesButton){
		/* when there is no resource button and no multi-sco reduce the width of the banner mjb/kgs 03/17/22 */
		$('.bar_robot .page').attr('style', 'display: none !important');
		$('.index_banner .page').attr('style', 'display: none !important');
		$('.bar_robot .page').css('visibility','hidden');
		$('.index_banner .page').css('visibility','hidden');
		if (!document.isMultiSco)
		{
			$(".index_banner").css("width", "220px");
			$(".menu_flex").css("width", "220px");
		}	
    }
	
	/* 20240214 allow burger menu to go to homepage menu */
	if (document.burgerGoHomepage)
	{
		$('.index_banner .home').css('visibility','hidden');
		$('.index_banner .home').attr('aria-hidden',true); /* reskin v4.0 2025 */
	}	
	
	$(".burger_select_title").each(function(index, element) {	
		
		var txt = $(this).html();		
		$(this).attr('title', txt);
	});	
    
	$('.popup_close').attr('title', localiseString('close_btn'));
	$('.popup_close').attr('alt', localiseString('close_btn'));
	
	$('.retake_assess_btn').attr('title', localiseString('retake_test_button'));
	$('.retake_assess_btn').attr('alt', localiseString('retake_test_button'));

	$('.retake_course_btn').attr('title', localiseString('retake_course_button'));
	$('.retake_course_btn').attr('alt', localiseString('retake_course_button'));
	
	$('.confirm_attest_btn').attr('title', localiseString('confirm_attest_button'));
	$('.confirm_attest_btn').attr('alt', localiseString('confirm_attest_button'));

	/* branch menu 2025 */
	$('.branch_select').each(function(index, element) {
		$(this).parent().find('.progress_text').eq(index).html(localiseString('topic_start_label'));
		$(this).parent().find('.progress').eq(index).html(localiseString('topic_start'));
		$(this).attr('alt', $(this).parent().find('.select_title h3').eq(index).html());
		$(this).attr('title', $(this).parent().find('.select_title h3').eq(index).html());
	});
}


/* 20220628 JAWS fix to stop item being read when course launches */
$(":input").attr("aria-hidden", true);
$('#left_nav').attr("aria-hidden", true);
$('#home_nav').attr("aria-hidden", true);
$('#right_nav').attr("aria-hidden", true);
$('.qItemFirst').attr("aria-hidden", true);
/* 20220628 JAWS fix to stop item being read when course launches */



/* updated to select via specific language */
function localiseString(identifier){
	if(eval("document.langStrings_" + document.selectedLang).hasOwnProperty(identifier)){
		return eval("document.langStrings_" + document.selectedLang)[identifier];
	}else{
		return "Lang string unknown";
	}
}


/*var courseTimer = setTimeout(function(){
	
	alert("close course")
	window.top.close();
	
},10000)*/


function setRTL(){
	
	if(document.textDirection == "rtl"){
	
	
		$(".menu_flex").addClass("menu_flex_RTL");

		$(".index_banner").addClass("menu_flex_RTL");
		
		$(".menu_header_content").addClass("menu_header_content_RTL");
		
		$(".menu_header_image").addClass("menu_header_image_RTL");
		
		$(".menu_btn_title").addClass("menu_btn_title_RTL");
		$(".menu_container").addClass("menu_container_RTL");
		$(".menu_btns_holder").addClass("menu_btns_holder_RTL");		
		
		$(".topic_select").addClass("topic_select_RTL");
		/* branch menu 2025 */
		$(".branch_select").addClass("topic_select_RTL");
		
		$(".progress").addClass("progress_RTL");
		
		$("ul li").css("background-image", "none")
		
		$("ul li").css("list-style", "square")
		
		
		$(".burger_progress").addClass("burger_progress_RTL");
		$(".burger_start_img").addClass("burger_start_img_RTL");
		$(".burger_close").addClass("burger_close_RTL");
		$(".burger_sec").addClass("burger_sec_RTL");
		$(".burger_select_title").addClass("burger_select_title_RTL");
		$(".burger_bg").addClass("burger_bg_RTL");
		

		$(".icon_leadin").addClass("icon_leadin_RTL");
		$(".icon_holder").addClass("icon_holder_RTL");
		
		$(".icon_content").css("text-align", "right");
		
		
		$(".text_image_text").addClass("text_image_text_RTL");
		
		$(".text_image_left").addClass("text_image_left_RTL");
		
		$(".text_image_right").addClass("text_image_right_RTL");
		
		
		$(".question_container").addClass("question_container_RTL");
		$(".qItemFirst").addClass("qItemFirst_RTL");
		
		$(".optionHolder").addClass("optionHolder_RTL");
		
		$(".question_leadin_text").addClass("question_leadin_text_RTL");
		$(".submit_holder").addClass("submit_holder_RTL");
		$(".feedback_text").addClass("feedback_text_RTL");
		$(".mc_btn").addClass("mc_btn_RTL");
		
		
		$(".expando_btn").addClass("expando_btn_RTL");
		$(".expando_reveal_heading").addClass("expando_reveal_heading_RTL");
		
		$(".slide_left").addClass("slide_left_RTL");
		$(".slide_right").addClass("slide_right_RTL");
		$(".slider_container").addClass("slider_container_RTL");
						
		$(".image_leadin").addClass("image_leadin_RTL");
		$(".image_ind").addClass("image_ind_RTL");
		
		
		$(".timeline_item_left_content").addClass("timeline_item_left_content_RTL");
		$(".timeline_item_right").addClass("timeline_item_right_RTL");
		$(".timeline_item_vertical").addClass("timeline_item_vertical_RTL");
		$(".timeline_item_vertical_single").addClass("timeline_item_vertical_single_RTL");
		$(".timeline_item_horizontal").addClass("timeline_item_horizontal_RTL");
		$(".timeline_item").addClass("timeline_item_RTL");
		
		$(".image_hotspot_reveal_holder").addClass("image_hotspot_reveal_holder_RTL");
		$(".image_hotspot_leadin").addClass("image_hotspot_leadin_RTL");
		$(".hsp_img").addClass("hsp_img_RTL");
		
		$(".hotspot_image").addClass("hotspot_image_RTL");
		
		$('.pageMenu .active:after').css(
			{
				'border-top-width': '22px',
				'border-left-width': '22px',
				'border-right-width': '22px'
			}
		)
		
		$(".four_image_btn").addClass("four_image_btn_RTL");
		$(".popup_close").addClass("popup_close_RTL");
		$(".four_image_reveal_text").addClass("four_image_reveal_text_RTL");
		
		
		$(".flip_card_back").addClass("flip_card_back_RTL");
		
		$(".flip_card").addClass("flip_card_RTL");
		$(".flip_card_inner").addClass("flip_card_inner_RTL");
		
		$('#right_nav').addClass('locked');
		
		$(".box_closer").addClass("box_closer_RTL")
		
		$(".tab_reveal_img").addClass("tab_reveal_img_RTL");
		
		$(".topic_nav_button").addClass("topic_nav_button_RTL")
		
		
		
		$(".text_only_content").addClass("text_only_content_RTL");
		
		$(".timeline_item_left").addClass("timeline_item_left_RTL");
		
		$(".align_left").addClass("align_left_RTL");
		
		$(".video_content").addClass("video_content_RTL");
		
		$(".diff_fb").addClass("diff_fb_RTL");
		
		$(".flip_card_int_holder").addClass("flip_card_int_holder_RTL");
		
		$(".slider_bg").addClass("slider_bg_RTL");
		
		$(".select_bottom").addClass("select_bottom_RTL");
		
		
		$(".submit_btn").addClass("submit_btn_RTL");
		
		$(".tab_int").addClass("tab_int_RTL");
		$(".tab_btn").addClass("tab_btn_RTL");
		
		
		$(".content_text_holder_rt_img").addClass("content_text_holder_rt_img_RTL");
		$(".topic_intro_content").addClass("topic_intro_content_RTL");
		
		$(".topic_intro_hero").addClass("topic_intro_hero_RTL");
		
		/* Progress Indicator 2023 -- */
		$(".progress_holder").addClass("progress_holder_RTL");
		$(".course_progress").addClass("course_progress_RTL");
		/* -- Progress Indicator 2023 */
		

		$(".courseTitle").addClass("courseTitle_rtl");

		$(".likert").addClass("likert_rtl");

		$(".role_selection_btn_txt").addClass("role_selection_btn_txt_rtl");

	}
	
	if(!document.isMultiSco){
		$(".switchLang").css("display","none");
	}
	
	/* custom branching: common topic, a branching topic with branching screentype, two branches, no assessement 2023 */
	/* hide home page menu if no branch was selected in a session */
	if(document.hasBranches){
		if(document.userBranch == 0){
			$(".menu_grid").css("display","none");
		}
	}
	/* custom branching */
	/*if(document.hasBranches){
		
		if(document.userBranch == 0){
		
			$(".menu_grid").css("display","none");
			$(".branch_grid").css("display","none");
			$(".recap_grid").css("display","block");
		}else{
			$(".branch_grid").css("display","none");
			$(".recap_grid").css("display","none");
		}
	}else{
		/*$(".menu_grid").css("display","block");*/
		/*$(".branch_grid").css("display","none");
		$(".recap_grid").css("display","none");
	}*/
}

/* 20221021 ensure burger menu window is focused on and cannot be tabbed out of */
$('.burger_index').find('.burger_close').on('keydown', function(e) {
	if ((e.which == 9) && (!e.shiftKey)) {
		e.preventDefault();
		$('.burger_index').find('.burger_scroll').focus();
	}
});

/* 20221021 ensure burger menu window is focused on and cannot be tabbed out of */
$('.burger_index').find('.burger_close').on('keydown', function(e) {
	if ((e.which == 9) && (e.shiftKey)) {
		e.preventDefault();
		$('.burger_index').find('.burger_scroll').focus();
	}
});

/* 20221021 ensure burger menu window is focused on and cannot be tabbed out of */
$('.burger_index').find('.burger_scroll').on('keydown', function(e) {
	if ((e.which == 9) && (e.shiftKey)) {
		e.preventDefault();
		$('.burger_index').find('.burger_close').focus();
	}	
});