/* variables used for course-specific text */
/* DEV NOTE indicates that the variable should be updated for the course */

$( document ).ready(function() {

	/* DEV NOTE: string for course title */
	document.courseTitle = "FCC Anti-Money Laundering (AML) and Government Sanctions 2025";

	/* DEV NOTE: strings for topic titles which are used in the pre-test results */
	document.topicTitles = {
		titles:[
			{title:"Introduction"},
			{title:"Know Your Customer (KYC) Basics"},
			{title:"Other Financial Crime Related Risks"},
			{title:"Business and Country-specific Requirements"},
			{title:"Sanctions"},
			{title:"The Sum of It"},
			{title:"Test Yourself"},
			{title:"Attestation"}			
		]
	}
	
	/* DEV NOTE: strings for text that is used for the intro pre-test message that appears asking the learner if they want to take the pre-test and for the pre-test and post-test intro pages; if there is no pre-test make the pre-test strings empty strings; if there is no post-test make the post-test strings empty strings */
	test_intro_dat = {
		pre_test:[{
			intro_title: "",
			intro_msg: "",
			generic_msg:'',			
			title:'',
			subtitle:''
			
		}],
		post_test:[{
			generic_msg:'<p>Are you ready to take the test on AML and Government Sanctions?</p><p>You have three attempts to answer 6 out of 7 questions correctly. </p><p>If you do not achieve a passing score after the third attempt, you will be asked to review the course again.</p>',			
			title:'Assessment',
			subtitle:'Assessment Instructions',
			test_complete_title:'Training Completed',
			test_complete_msg:'<p>Since you have already received a completion for this training, the final assessment is not required and will not be presented. Thank you!</p><p>Select the X in the top right of the screen to exit.</p>'
		}],
		pre_test_nav:[{
			home_only:'Select the Home button to return to the home page.'
		}]
	}
	
	/* DEV NOTE: strings for text that is used on the pre-test and post-test results page before the score and for the pass and fail messages; if there is no pre-test make the pre-test strings empty strings; if there is no post-test make the post-test strings empty strings; when there is no limit to the post-test tries, make fail_max_msg an empty string for the post-test section; when there is a pre-test and there are no topics associated with test questions make all strings excluding pass_msg, fail_msg_3 and result_title empty strings for the pre-test section; when there is no requirement to review incorrect questions for a passed post-test, make pass_review_msg, result_review_msg_1, result_review_msg_2 and result_review_msg_3 empty strings for the post_test section. */
	test_results_dat = {
		pre_test:[{
			pass_msg:'',
			pass_msg_2:'',
			pass_msg_3:'',	
			pass_msg_4:'',	
			fail_msg_1:'',
			fail_msg_2:'',
			fail_msg_3:'',			
			result_title:''
		}],
		post_test:[{
			generic_msg:'You scored: ',
			pass_msg:'<p>Congratulations!</p><p>You have passed the test for this course.</p><p>In order to receive credit for this course, move on to submit your attestation.</p>',
			pass_msg_1:'To complete this course, please participate in the following survey or choose to opt out.',
			pass_msg_2:'You have completed this course.',			
			pass_review_msg:'You can scroll down to see the correct answer for any question you got incorrect.',
			fail_msg:'<p>Unfortunately, you have not passed the test.</p><p>Select the Retake Test button to try again.</p>',
            fail_max_msg:'<p>Unfortunately, you didn’t pass the test. As this was your third attempt, you are required to retake the course.</p>To retake the course, select the Retake Course button.',
			prev_passed_msg: '<p>Please note you already passed the assessment in a previous session.<br>You are not required to retake the assessment.</p>',
			result_title:'Assessment Results',
			result_review_msg_1:'Question:',
			result_review_msg_2:'Options:',
			result_review_msg_3:'Feedback:'
		}]
	}
	
	/* DEV NOTE: strings for text that is used on the attestation page before and after the attesting; if there is no attestation make these empty strings */
	attestation_dat = {		
		attestation:[{
			title:'Attestation',
			pre_attesting_msg:'<p>Thank you for completing Compliance Learning: Financial Crime Compliance – Anti-Money Laundering and Government Sanctions.</p><p>If you do not understand any part of this training, please refer to the relevant policies, and if you are still unsure, you must exit the training now and contact your local Compliance officer.</p><p>Before you leave, please attest to the following statement by selecting Submit.</p><p><b>I certify that I have read and understood the contents of this course, Compliance Learning: Financial Crime Compliance – Anti-Money Laundering and Government Sanctions.</b></p><p><b>I certify that I have read and understood the Goldman Sachs business and office location specific content included in the AML topic, as applicable to me.</b></p>',
			attested_msg:'<p>Thank you for your attestation.</p><p>Congratulations!</p><p>You have successfully completed this training. You can now select “Exit Course” at the top right of the screen to exit the course.</p>'
		}]
	}
	
	/* DEV NOTE: strings for the transcript titles and content separated by section id; if there are no transcripts make this variable an empty array */
	transcript_dat = {}
	
	/* DEV NOTE: strings for the hotword titles and content separated by hotword id; if there are no hotwords make this variable an empty array */
	hotword_dat = {}
	
	/* DEV NOTE: strings for the link URLs separated by link id; if there are no links make this variable an empty array */
	link_dat = {
		lnk_1:[{
				url:'https://gsdocs.site.gs.com/document/65d8b4a8c8afd87723f45d6d'
		}],
		lnk_2:[{
				url:'https://www.legislation.gov.uk/ukpga/2023/56/contents'
		}],
		lnk_3:[{
				url:'https://www.goldmansachs.com/investor-relations/corporate-governance/sustainability-reporting/state-on-modern-slavery-and-human-trafficking.html'
		}],
		lnk_4:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596961'
		}],
		lnk_5:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596962'
		}],
		lnk_6:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596963'
		}],
		lnk_7:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596964'
		}],
		lnk_8:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596965'
		}],
		lnk_9:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596966'
		}],
		lnk_10:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596967'
		}],
		lnk_11:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596968'
		}],
		lnk_12:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596969'
		}],
		lnk_13:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596970'
		}],
		lnk_14:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596971'
		}],
		lnk_15:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596972'
		}],
		lnk_16:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596985'
		}],
		lnk_17:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596986'
		}],
		lnk_18:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596987'
		}],
		lnk_19:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596988'
		}],
		lnk_20:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596973'
		}],
		lnk_21:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596974'
		}],
		lnk_22:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596975'
		}],
		lnk_23:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596976'
		}],
		lnk_24:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596977'
		}],
		lnk_25:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596978'
		}],
		lnk_26:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596979'
		}],
		lnk_27:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596980'
		}],
		lnk_28:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596981'
		}],
		lnk_29:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596982'
		}],
		lnk_30:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596983'
		}],
		lnk_31:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596984'
		}],
		lnk_32:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596989'
		}],
		lnk_33:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596990'
		}],
		lnk_34:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596991'
		}],
		lnk_35:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/596992'
		}],
		lnk_36:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/513308'
		}],
		lnk_37:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/489358'
		}],
		lnk_38:[{
				url:'https://gsdocs.site.gs.com/document/5e136982718a0111dd1c5ba1'
		}],
		lnk_39:[{
				url:'https://www.goldmansachs.com/investor-relations/corporate-governance/sustainability-reporting/state-on-modern-slavery-and-human-trafficking.html'
		}],
		lnk_40:[{
				url:'https://assets.gsweb.site.gs.com/mosaic/v1/files/489358'
		}],
		lnk_41:[{
				url:'https://gsdocs.site.gs.com/document/5e136982718a0111dd1c5ba1'
		}],
		lnk_42:[{
				url:'images/gs071_m2_t04_p02.pdf'
		}],
		/* Code of Business Conduct and Ethics */		
		lnk_43:[{
				url:'https://www.goldmansachs.com/investor-relations/corporate-governance/corporate-governance-documents/code-of-business-conduct-and-ethics.pdf'
		}]	
	}
	
	/* DEV NOTE: strings for the resource popup title and content */
	resource_dat = {
		resources:[{
				title:'Resources',				
				text:'<div class="align_left"><p><a data-lnk-id="lnk_38" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Firmwide Country Lists</a></p><p><a data-lnk-id="lnk_36" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Firmwide Guidance on Russia</a></p><p><a data-lnk-id="lnk_1" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Firmwide Policy on US MRB Transactions and Relationships</a></p><p><a data-lnk-id="lnk_2" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">UK Economic Crime and Transparency Act</a></p><p><a data-lnk-id="lnk_39" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Statements on MSHT</a></p><p><a data-lnk-id="lnk_40" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">CMIC entity</a></p></div>'
		}]
	}

	/* DEV NOTE: strings for LMS errors */
	lms_error_dat = {
		lms_error_1:[{
				text1:'API cannot be found.',
				text2:'Communication has been lost. Please close this training course and restart it at a later time.<br>Do not continue as your progress or completion will not be tracked.<br>You will be able to restart from the last successful save point.'
        }]		
	}
});