/* functions to control display of dialogue boxes used for bookmark, hotwords, transcript and error messages */

$('.dialogue_pop').on('click', function() {
	whatPop(this)
});

/* keyboard functionality */
$('.dialogue_pop').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {
		
		$(this).trigger('click');
	}		
});

/* splash video v4.0 2025 */
$('.continue_vid_btn').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {

		$(this).trigger('click');
	}
});

/* splash video v4.0 2025 */
$('.return_vid_btn').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {

		$(this).trigger('click');
	}
});

/* branch menu 2025 */
$('.return_branch_menu_btn').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {

		$(this).trigger('click');
	}
});

$('.hotspot_reveal').on('click', 'a', function() {
	whatPop(this)	
})

/* keyboard functionality */
$('.hotspot_reveal').on('keypress', 'a', function() {
	$(this).trigger('click');
})

$('.hotspot_reveal').on('keypress', '.popup_pop', function() {
	$(this).trigger('click');	
})

var butReturnFocus;

function whatPop(selector){
	
	butReturnFocus = selector;
	
	if($(selector).hasClass('transcript_btn')){
		var section = $(selector).closest('.section').attr('id');
		/* splash video v4.0 2025 */
		//var secNum = section.split('_')[1];
		//var pop_type = 'transcript';
		//boxPop(section, pop_type);
		
		/* splash video v4.0 2025 */
		var secNum = $(selector).attr("id").split('btn_')[1];
		if(secNum == 1){
			section = "sec_1"
		}

		$("#transcript_" + secNum + " .transcript_text").html(transcript_dat[section][0].transcript);
		if ($("#transcript_btn_" + secNum).html() == localiseString('transcript_btn'))
		{						
			$("#transcript_" + secNum).show();
			$("#transcript_btn_" + secNum).html(localiseString('transcript_close_btn'));
			$("#transcript_btn_" + secNum).addClass("transcript_opened");
			/* 2021 Accessibility Update */
			$("#transcript_btn_" + secNum).attr('title',localiseString('transcript_close_btn'));
			$("#transcript_btn_" + secNum).attr('alt',localiseString('transcript_close_btn'));
			/* 2021 Accessibility Update */					
			var btnTabIndex = $(selector).attr('tabindex');
			var txtTabIndex = $("#transcript_" + secNum + " .transcript_text").attr('tabindex');			
			$(selector).attr('tabindex', txtTabIndex);
			/* 20240326 accessibility 2024 */
			$("#transcript_" + secNum).find('.transcript_top_btn').attr('aria-hidden', false);
			$("#transcript_" + secNum + " .transcript_text").attr('tabindex', btnTabIndex);
			$("#transcript_" + secNum + " .transcript_text").focus();
		}
		else
		{
			$("#transcript_" + secNum).hide();
			$("#transcript_btn_" + secNum).html(localiseString('transcript_btn'));
			$("#transcript_btn_" + secNum).removeClass("transcript_opened");
			/* 2021 Accessibility Update */
			$("#transcript_btn_" + secNum).attr('title',localiseString('transcript_btn'));
			$("#transcript_btn_" + secNum).attr('alt',localiseString('transcript_btn'));	
			/* 2021 Accessibility Update */					
			var btnTabIndex = $(selector).attr('tabindex');
			var txtTabIndex = $("#transcript_" + secNum + " .transcript_text").attr('tabindex');			
			$(selector).attr('tabindex', txtTabIndex);
			/* 20240326 accessibility 2024 */
			$("#transcript_" + secNum).find('.transcript_top_btn').attr('aria-hidden', true);
			$("#transcript_" + secNum + " .transcript_text").attr('tabindex', btnTabIndex);			
		}
		
		/* splash video v4.0 2025 */
		if(secNum != 1){
			document.intComplete = true; // Unlock video when transcript opened
			isPageComplete(Number(section.split("_")[1])); // Unlock video when transcript opened
		}else{
			showSplashBtn();
		}
		
	}else if($(selector).hasClass('hotword')){			
		var hotword_sec = '#'+$(selector).closest('.section').attr('id');
		//var secNum = hotword_sec.split('_')[1];
		//findHotWordNum(secNum)

		//var word = $(selector).text();
		var word = $(selector).attr('data-hw-id');
		var pop_type = 'hot_word';
		boxPop(word, pop_type);			
		isHotWordDone(hotword_sec);			
		if($(selector).hasClass('hotword_neutral') && !($(selector).hasClass('hotword_neutral_visited'))){
			$(selector).addClass('hotword_neutral_visited');
		}
	}else if($(selector).hasClass('page')){			
		var word = $(selector).text();
		var pop_type = 'resources';
		boxPop('resources', pop_type);
		$(selector).addClass('page_visited');
	}else if($(selector).hasClass('popup_pop')){		
		var lnkURL = link_dat[$(selector).attr('data-lnk-id')][0].url;
		var winName = 'name_' + $(selector).attr('data-lnk-id');
		var lnkWin = window.open(lnkURL,winName,'resizable=1,scrollbars=1,width=815,height=800');
		lnkWin.focus();
	}	
}

$('.popup_pop').click(function() {
	if($(this).hasClass('popup_neutral') && !($(this).hasClass('popup_neutral_visited'))){
		$(this).addClass('popup_neutral_visited');
	}
});

/* keyboard functionality */
$('.popup_pop').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {
		$(this).trigger('click');
	}		
});

$('.box_closer').click(function() {
	closeErrorPopupOrCourse();
});

/* keyboard functionality */
$('.box_closer').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {
		
		$(this).trigger('click');
	}		
});

/* 20221019 ensure popup window is focused on and cannot be tabbed out of */
/* 20240326 accessibility 2024 */
$('.box_closer').on('keydown', function(e) {
	if ((e.which == 9) && (!e.shiftKey)) {
		e.preventDefault();
		$('.box_title').focus();
	}
});

/* 20221019 ensure popup window is focused on and cannot be tabbed out of */
/* 20240326 accessibility 2024 */
$('.box_closer').on('keydown', function(e) {
	if ((e.which == 9) && (e.shiftKey)) {
		e.preventDefault();
		$('.box_title').focus();
	}
});

$( window ).resize(function() {
	 $('.box_holder:visible').not('.bookmark').css({
        'position' : 'absolute',
        'top' : '50%',
        'margin-top' : -$('.box_holder:visible').outerHeight()/2
    });
	if($('.box_nav_holder:visible').height() > $(window.parent).height()){
		$('.dialogue_box').not('.bookmark').addClass('box_overflow');
		$('.box_holder').not('.bookmark').addClass('box_static');
	    $('.box_holder:visible').css({'margin-top' : 0})
	}else{
		$('.dialogue_box').not('.bookmark').removeClass('box_overflow');
		$('.box_holder').not('.bookmark').removeClass('box_static');
	}
});

function boxPop(section, pop_type, error_title, error_mess){
	
	/* 20180501 Accessibility remove tab funcitonality */
	popupKeyDown = true; 
	removeMenuTabIndex();
	removeTabIndex();
	/* 20180501 Accessibility remove tab funcitonality */
    
    $('.dialogue_box').removeClass("preTestBG");
    $('.box_holder').removeClass("putBottom");
	
	/* hide the section containing the bookmark buttons */
	$('.box_holder .box_bottom').hide();
	/* only show the error popup if an error is currently being processed */	
	if ((!document.errorMessagePresent && !document.errorNotifyPresent) || (pop_type == 'error'))
	{
		if(isWeb){
			//$("html, body").disableScroll(); /* disable scroll bar */
			$('html, body').css('overflow-y','hidden');
		}else{
			$('html, body').css('overflow-y','hidden');
		}
		$('.box_closer').show(); /* show close button */
		if(pop_type == 'transcript'){
			$('.box_holder .box_title').html(transcript_dat[section][0].title);
			$('.box_holder .box_message').html(transcript_dat[section][0].transcript);
			/* 20180501 Accessibility Apply tab functionality to popup */
			if(popupKeyDown){
				var tabCnt = 0;
				$('.box_middle').focus();
				tabCnt++;
				$('.box_middle').attr('tabindex', tabCnt);
				$('.box_middle').find('a').each(function(index, element) {	
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					$(this).on('keypress', function() {
						$(this).trigger('click');
					})
				});
				tabCnt++;
				$('.box_closer').attr('tabindex', tabCnt);
				/* 20221019 ensure popup window is focused on and cannot be tabbed out of */
				$('.box_middle').on('keydown', function(e) {
					if ((e.which == 9) && (e.shiftKey)) {
						e.preventDefault();
						$('.box_closer').focus();
					}
				});
			}
			/* 20180501 Accessibility Apply tab functionality to popup */
		}else if(pop_type == 'hot_word'){		
			$('.box_holder .box_title').html(hotword_dat[section][0].title);
			$('.box_holder .box_message').html(hotword_dat[section][0].text);
			
			/* 20240326 accessibility 2024 */
			$('.box_top_btn').attr('aria-hidden', false);

			/* 20180501 Accessibility Apply tab functionality to popup */
			/* 20240326 accessibility 2024 */
			if(popupKeyDown){
				var tabCnt = 0;
				tabCnt++;
				$('.box_closer').attr('tabindex', tabCnt);
				$('.box_closer').attr('aria-hidden', false);
				tabCnt++;
				$('.box_title').attr('tabindex', tabCnt);
				$('.box_title').attr('aria-hidden', false);
				tabCnt++;
				$('.box_message').attr('tabindex', tabCnt);
				$('.box_message').attr('aria-hidden', false);
				$('.box_middle').find('a').each(function(index, element) {	
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					$(this).attr('aria-hidden', false);
					$(this).on('keypress', function() {
						$(this).trigger('click');
					});
				});
				/* ensure popup window is focused on and cannot be tabbed out of */
				$('.box_title').on('keydown', function(e) {
					if ((e.which == 9) && (e.shiftKey)) {
						e.preventDefault();
						$('.box_closer').focus();
					}
				});
				if ($('.box_middle').find('a').length > 0) {
					$('.box_middle').find('a').eq($('.box_middle').find('a').length-1).on('keydown', function(e) {
						if ((e.which == 9) && (!e.shiftKey)) {
							e.preventDefault();
							$('.box_closer').focus();
						}
					});
					$('.box_closer').on('keydown', function(e) {
						if ((e.which == 9) && (e.shiftKey)) {
							e.preventDefault();
							$('.box_middle').find('a').eq($('.box_middle').find('a').length-1).focus();
						}
					});
				}
				else {
					$('.box_message').on('keydown', function(e) {
						if ((e.which == 9) && (!e.shiftKey)) {
							e.preventDefault();
							$('.box_closer').focus();
						}
					});
					$('.box_closer').on('keydown', function(e) {
						if ((e.which == 9) && (e.shiftKey)) {
							e.preventDefault();
							$('.box_message').focus();
						}
					});
				}
			}
			/* 20180501 Accessibility Apply tab functionality to popup */
		}else if(pop_type == 'resources'){
			$('.box_holder .box_title').html(resource_dat[section][0].title);
			$('.box_holder .box_message').html(resource_dat[section][0].text);
			
			/* 20240326 accessibility 2024 */
			$('.box_top_btn').attr('aria-hidden', false);
			
			/* 20180501 Accessibility Apply tab functionality to popup */
			/* 20240326 accessibility 2024 */
			if(popupKeyDown){
				var tabCnt = 0;
				tabCnt++;
				$('.box_closer').attr('tabindex', tabCnt);
				$('.box_closer').attr('aria-hidden', false);
				tabCnt++;
				$('.box_title').attr('tabindex', tabCnt);
				$('.box_title').attr('aria-hidden', false);
				tabCnt++;
				$('.box_message').attr('tabindex', tabCnt);
				$('.box_message').attr('aria-hidden', false);
				$('.box_middle').find('a').each(function(index, element) {	
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					$(this).attr('aria-hidden', false);
					$(this).on('keypress', function() {
						$(this).trigger('click');
					});
				});
				/* ensure popup window is focused on and cannot be tabbed out of */
				$('.box_title').on('keydown', function(e) {
					if ((e.which == 9) && (e.shiftKey)) {
						e.preventDefault();
						$('.box_closer').focus();
					}
				});
				if ($('.box_middle').find('a').length > 0) {
					$('.box_middle').find('a').eq($('.box_middle').find('a').length-1).on('keydown', function(e) {
						if ((e.which == 9) && (!e.shiftKey)) {
							e.preventDefault();
							$('.box_closer').focus();
						}
					});
					$('.box_closer').on('keydown', function(e) {
						if ((e.which == 9) && (e.shiftKey)) {
							e.preventDefault();
							$('.box_middle').find('a').eq($('.box_middle').find('a').length-1).focus();
						}
					});
				}
				else {
					$('.box_message').on('keydown', function(e) {
						if ((e.which == 9) && (!e.shiftKey)) {
							e.preventDefault();
							$('.box_closer').focus();
						}
					});
					$('.box_closer').on('keydown', function(e) {
						if ((e.which == 9) && (e.shiftKey)) {
							e.preventDefault();
							$('.box_message').focus();
						}
					});
				}
			}
			/* 20180501 Accessibility Apply tab functionality to popup */
			
			//20190508 Added for collapsable resources
			$('.resource_header').click(function(){
				
				if($(this).parent().parent().next().css('display') == 'block'){
					$(this).parent().parent().next().css('display','none');
				}else{
					$('.resource_links').css('display','none');
					$(this).parent().parent().next().css('display','block');
				}
				
				$('.box_elements').css('overflow-y','visible');
				reposResources();
			});
			
			$('.resource_header').keypress(function (e) {
				if (e.keyCode == 13 || e.keyCode == 32) {
					$(this).trigger('click');
				}
			});
			
			
			
			//20190508 Added for collapsable resources
			
		}
		else if(pop_type == 'error'){		
			$('.box_holder .box_title').html(error_title);
			$('.box_holder .box_message').html(error_mess);
			/* 011623 show LMS error message */
			/*if (isiPad || isAndroidTablet || isAndroidPhone || isiPhone) {
				$('.box_closer').hide();
			}*/
			$('.box_closer').hide();
			/* 20240326 accessibility 2024 */
			$('.box_top_btn').attr('aria-hidden', true);
		}
		/* role selection 2023 */
		else if(pop_type == 'role'){
			$(".dialogue_box").addClass("role_select_bg");
			$(".box_container").addClass("role_box_container");
			$(".box_nav_holder").addClass("role_box_nav_holder");
			$(".box_elements").addClass("role_box_elements");

			$(".dialogue_box").prepend("<div class='role_header'></div>");

			var roleTitle = "";			
			roleTitle = localiseString('role_selection_title');
			$('.box_section').addClass('box_section_btns');
			$('.box_holder .box_title').html('<h3>'+roleTitle+'</h3>');
			$('.box_holder .box_bottom').html('<div class=\'button_holder\'><div class=\'button_container bookmark_button_container role_button_bg\'><div class=\'role_selection_1\' role=\'button\'><div class=\'role_selection_btn_txt\'>'+localiseString('role_selection_btn')+'</div></div><div class=\'role_selection_2\' role=\'button\'><div class=\'role_selection_btn_txt\'>'+localiseString('role_selection_btn')+'</div></div><div class=\'role_selection_3\' role=\'button\'><div class=\'role_selection_btn_txt\'>'+localiseString('role_selection_btn')+'</div></div><div class=\'role_selection_4\' role=\'button\'><div class=\'role_selection_btn_txt\'>'+localiseString('role_selection_btn')+'</div></div><div class=\'role_selection_5\' role=\'button\'><div class=\'role_selection_btn_txt\'>'+localiseString('role_selection_btn')+'</div></div><div class=\'role_selection_6\' role=\'button\'><div class=\'role_selection_btn_txt\'>'+localiseString('role_selection_btn')+'</div></div><div class=\'role_selection_7\' role=\'button\'><div class=\'role_selection_btn_txt\'>'+localiseString('role_selection_btn')+'</div></div><div class=\'role_selection_8\' role=\'button\'><div class=\'role_selection_btn_txt\'>'+localiseString('role_selection_btn')+'</div></div></div></div>');			
			$('.box_holder .box_bottom').show();
			$('.box_message').hide();
			$('.box_closer').hide();
			$(".role_selection_1").bind("click", function() {
				selectRole(1)
			});
			$(".role_selection_2").bind("click", function() {
				selectRole(2)
			});
			$(".role_selection_3").bind("click", function() {
				selectRole(3)
			});
			$(".role_selection_4").bind("click", function() {
				selectRole(4)
			});
			$(".role_selection_5").bind("click", function() {
				selectRole(5)
			});
			$(".role_selection_6").bind("click", function() {
				selectRole(6)
			});
			$(".role_selection_7").bind("click", function() {
				selectRole(7)
			});
			$(".role_selection_8").bind("click", function() {
				selectRole(8)
			});
			$('.role_selection_1').keypress(function (e) {
				if (e.keyCode == 13 || e.keyCode == 32) {
					
					$(this).trigger('click');
				}
			});	
			$('.role_selection_2').keypress(function (e) {
				if (e.keyCode == 13 || e.keyCode == 32) {
					
					$(this).trigger('click');
				}
			});
			$('.role_selection_3').keypress(function (e) {
				if (e.keyCode == 13 || e.keyCode == 32) {
					
					$(this).trigger('click');
				}
			});
			$('.role_selection_4').keypress(function (e) {
				if (e.keyCode == 13 || e.keyCode == 32) {
					
					$(this).trigger('click');
				}
			});
			$('.role_selection_5').keypress(function (e) {
				if (e.keyCode == 13 || e.keyCode == 32) {
					
					$(this).trigger('click');
				}
			});	
			$('.role_selection_6').keypress(function (e) {
				if (e.keyCode == 13 || e.keyCode == 32) {
					
					$(this).trigger('click');
				}
			});
			$('.role_selection_7').keypress(function (e) {
				if (e.keyCode == 13 || e.keyCode == 32) {
					
					$(this).trigger('click');
				}
			});
			$('.role_selection_8').keypress(function (e) {
				if (e.keyCode == 13 || e.keyCode == 32) {
					
					$(this).trigger('click');
				}
			});
			$('.role_selection_1').attr('title', localiseString('role_selection_1_title'));
			$('.role_selection_1').attr('alt', localiseString('role_selection_1_title'));
			$('.role_selection_2').attr('title', localiseString('role_selection_2_title'));
			$('.role_selection_2').attr('alt', localiseString('role_selection_2_title'));
			$('.role_selection_3').attr('title', localiseString('role_selection_3_title'));
			$('.role_selection_3').attr('alt', localiseString('role_selection_3_title'));
			$('.role_selection_4').attr('title', localiseString('role_selection_4_title'));
			$('.role_selection_4').attr('alt', localiseString('role_selection_4_title'));
			$('.role_selection_5').attr('title', localiseString('role_selection_5_title'));
			$('.role_selection_5').attr('alt', localiseString('role_selection_5_title'));
			$('.role_selection_6').attr('title', localiseString('role_selection_6_title'));
			$('.role_selection_6').attr('alt', localiseString('role_selection_6_title'));
			$('.role_selection_7').attr('title', localiseString('role_selection_7_title'));
			$('.role_selection_7').attr('alt', localiseString('role_selection_7_title'));
			$('.role_selection_8').attr('title', localiseString('role_selection_8_title'));
			$('.role_selection_8').attr('alt', localiseString('role_selection_8_title'));
			/* 2021 Accessibility Update */
			if(popupKeyDown){
				var tabCnt = 0;
				tabCnt++;				
				$('.box_title').attr('tabindex', tabCnt);
				tabCnt++;				
				$('.role_selection_1').attr('tabindex', tabCnt);
				tabCnt++;
				$('.role_selection_2').attr('tabindex', tabCnt);
				tabCnt++;
				$('.role_selection_3').attr('tabindex', tabCnt);
				tabCnt++;
				$('.role_selection_4').attr('tabindex', tabCnt);
				tabCnt++;
				$('.role_selection_5').attr('tabindex', tabCnt);
				tabCnt++;
				$('.role_selection_6').attr('tabindex', tabCnt);
				tabCnt++;
				$('.role_selection_7').attr('tabindex', tabCnt);
				tabCnt++;
				$('.role_selection_8').attr('tabindex', tabCnt);
				$('.role_selection_8').on('keydown', function(e) {
					if ((e.which == 9) && (!e.shiftKey)) {
						e.preventDefault();
						$('.box_title').focus();
					}
				});
			}			
			$('.box_title').on('keydown', function(e) {
				if ((e.which == 9) && (e.shiftKey)) {
					e.preventDefault();
					$('.role_selection_8').focus();
				}	
			});
			if(document.textDirection == "rtl"){
				$(".role_selection_btn_txt").addClass("role_selection_btn_txt_rtl");
			}
		}
		else if(pop_type == 'bookmark'){			
			var bookmarkTitle = "";
			var bookmarkText = "";
			var bookmarkNavStart = "";
			var bookmarkNavResume = "";		
			/* test out: if there is a pre-test in the course */
			if (document.pretestPresent == 1)
			{
				/* test out: show the pre-test bookmark popup if pre-test has not yet been attempted */
				if (document.pretestAttempted == 0) {
					bookmarkTitle = test_intro_dat['pre_test'][0].intro_title;
					bookmarkText = test_intro_dat['pre_test'][0].intro_msg;
					bookmarkNavStart = localiseString('pretest_nav_cancel');
					bookmarkNavResume = localiseString('pretest_nav_start');
				}
				else {
					bookmarkTitle = localiseString('bookmark_title');
					bookmarkText = localiseString('bookmark_text');
					bookmarkNavStart = localiseString('bookmark_nav_start');
					bookmarkNavResume = localiseString('bookmark_nav_resume');
				}	
			}
			else {
				bookmarkTitle = localiseString('bookmark_title');
				bookmarkText = localiseString('bookmark_text');
				bookmarkNavStart = localiseString('bookmark_nav_start');
				bookmarkNavResume = localiseString('bookmark_nav_resume');
			}	
            
            
            $('.dialogue_box').addClass("preTestBG");
            //$('.box_holder').addClass("putBottom");
            
			$('.box_holder .box_title').html(bookmarkTitle);
			$('.box_holder .box_message').html(bookmarkText);
			/* 20240326 accessibility 2024 */
			$('.box_title').attr('tabindex',1);
			$('.box_title').attr('aria-hidden', false);
			$('.box_message').attr('tabindex',2);
			$('.box_message').attr('aria-hidden', false);
			
			/* 20240326 accessibility 2024 */
			$('.box_top_btn').attr('aria-hidden', true);
			
			//20221027 fix for outline on bookmark popup
			$('.box_middle').css('outline-color', 'white');
					
			if (document.pretestPresent == 1)
			{
				if (document.pretestAttempted == 0) {
					
					if(document.forcePretest){
						$('.box_holder .box_bottom').html('<div class=\'button_holder\'><div class=\'button_container\'><div class=\'bookmark_nav_resume\' tabindex=\'2\'>'+bookmarkNavResume+'</div></div></div>');
					}else{
						$('.box_holder .box_bottom').html('<div class=\'button_holder\'><div class=\'button_container\'><div class=\'bookmark_nav_start\' tabindex=\'2\'>'+bookmarkNavStart+'</div><div class=\'bookmark_nav_resume\' tabindex=\'3\'>'+bookmarkNavResume+'</div></div></div>'); //20221027 fix for outline on bookmark popup
					}
				}else{
					/* pre-test no topics associated with questions support kgs 03/18/22 */
					$('.box_holder .box_bottom').html('<div class=\'button_holder\'><div class=\'button_container\'><div class=\'bookmark_nav_start bookmark_nav_start_sm_width\' tabindex=\'2\'>'+bookmarkNavStart+'</div><div class=\'bookmark_nav_resume bookmark_nav_start_sm_width\' tabindex=\'3\'>'+bookmarkNavResume+'</div></div></div>'); //20221027 fix for outline on bookmark popup
				}
			}else{
				/* pre-test no topics associated with questions support kgs 03/18/22 */
				$('.box_holder .box_bottom').html('<div class=\'button_holder\'><div class=\'button_container\'><div class=\'bookmark_nav_start bookmark_nav_start_sm_width\' tabindex=\'2\'>'+bookmarkNavStart+'</div><div class=\'bookmark_nav_resume bookmark_nav_start_sm_width\' tabindex=\'3\'>'+bookmarkNavResume+'</div></div></div>'); //20221027 fix for outline on bookmark popup
			}
			
			/* 20240326 accessibility 2024 */
			$('.bookmark_nav_start').attr('role', 'button');
			$('.bookmark_nav_resume').attr('role', 'button');
	
			$('.box_holder .box_bottom').show();
			$('.box_closer').hide();
			/* 20221019 ensure popup window is focused on and cannot be tabbed out of */			
			/* 20240326 accessibility 2024 */
			$('.box_title').on('keydown', function(e) {
				if ((e.which == 9) && (e.shiftKey)) {
					e.preventDefault();
					$('.bookmark_nav_resume').focus();
				}
			});
			/* 20221019 ensure popup window is focused on and cannot be tabbed out of */
			$('.bookmark_nav_resume').on('keydown', function(e) {
				if ((e.which == 9) && (!e.shiftKey)) {
					e.preventDefault();
					/* 20240326 accessibility 2024 */
					$('.box_title').focus();
				}
			});
		}
		$('.box_nav_holder').height();
		if(isWeb){
			$('.dialogue_box').fadeIn('fast');
			/* 20221019 ensure popup window is focused on and cannot be tabbed out of */
			/* 20240326 accessibility 2024 */
			$('.box_title').focus();
		}else{
			$('.dialogue_box').show();
		}
        
        if(pop_type == 'bookmark'){
        
            /*$('.box_holder:visible').css({
                'position' : 'absolute',
                'bottom' : 0
            });*/
			
			$('.box_holder:visible').css({
                'position' : 'absolute',
                'top' : $(window.parent).height()/2,
                'margin-top' : -$('.box_holder:visible').outerHeight()/2
            });
			
			
			
        }else{
			
            $('.box_holder:visible').css({
                'position' : 'absolute',
                'top' : $(window.parent).height()/2,
                'margin-top' : -$('.box_holder:visible').outerHeight()/2
            });
        }
		if($('.box_nav_holder:visible').height() > $(window.parent).height()){
			$('.dialogue_box').not('.bookmark').addClass('box_overflow');
			$('.box_holder').not('.bookmark').addClass('box_static');
			$('.box_holder:visible').css({'margin-top' : 0})
		}else{
			if(isiPhone){ /* fix for iPhone added */
				document.ontouchmove = function(e){ e.preventDefault(); }
			}
		}
		if(document.textDirection == "rtl"){

			$(".align_left").addClass("align_left_RTL");
		}
	}	
}

/* role selection 2023 */
function selectRole(roleNum)
{
	$(".role_footer").remove();
	$(".dialogue_box").removeClass("role_select_bg");
	$(".box_container").removeClass("role_box_container");
	$(".box_nav_holder").removeClass("role_box_nav_holder");
	$(".box_elements").removeClass("role_box_elements");
	$(".role_header").hide();
	document.userRole = roleNum;
	recordPercentComplete(1, document.subsectionCount, false);
	checkBookmarkNavReady();
	$('.box_message').show();

	recordRoleInt();
}

//20190508 Added for collapsable resources

function reposResources(){
	/*$('.box_holder:visible').css({
		'position' : 'absolute',
		'top' : $(window.parent).height()/2,
		'margin-top' : -$('.box_holder:visible').outerHeight()/2
	});

	if($('.box_nav_holder:visible').height() > $(window.parent).height()){
		$('.dialogue_box').not('.bookmark').addClass('box_overflow');
		$('.box_holder').not('.bookmark').addClass('box_static');
		$('.box_holder:visible').css({'margin-top' : 0})
	}
	if(isiPad || isiPhone){ 
		$('.sec_rest_wrapper, .topic_index').css({'margin-top': -windowTop, 'position':'fixed'})

		$('.sec_rest_wrapper').css({'margin-top': -64+'px'}) // LJ Added to postion content under transparent banner //
	}*/
	
	$('.box_holder:visible').not('.bookmark').css({
        'position' : 'absolute',
        'top' : '50%',
        'margin-top' : -$('.box_holder:visible').outerHeight()/2
    });
	if($('.box_nav_holder:visible').height() > $(window.parent).height()){
		$('.dialogue_box').not('.bookmark').addClass('box_overflow');
		$('.box_holder').not('.bookmark').addClass('box_static');
	    $('.box_holder:visible').css({'margin-top' : 0})
	}else{
		$('.dialogue_box').not('.bookmark').removeClass('box_overflow');
		$('.box_holder').not('.bookmark').removeClass('box_static');
	}
}

function boxClose(){	
	if(isiPad || isiPhone){
		var top = Math.abs(parseInt($('.sec_rest_wrapper, .topic_index').css('margin-top')))
		$('.sec_rest_wrapper, .topic_index').css({'margin-top': 0, 'position':'absolute'})
        
        //$('.sec_rest_wrapper').css({'margin-top': -64+'px'}) // LJ Added to postion content under transparent banner //
	}	
	if(isWeb){
		//$("html, body").enableScroll(); /* enable scroll bar */
		$('html, body').css('overflow-y','visible');
	}else{
		$('html, body').css('overflow-y','visible');
	}	
	if(isWeb){
		$('.dialogue_box').fadeOut('fast');
	}else{
		$('.dialogue_box').hide();
	}
	$('.dialogue_box').removeClass('box_overflow');
	$('.box_holder').addClass('box_reposition');
	$('.box_holder').removeClass('box_static');
	if(isiPad || isiPhone){
		$(parent.parent.document).scrollTop(top)
		$('.bar_robot').css('top',($(parent.parent.document).scrollTop())-1+'px'); /* fix for iPhone added */
		$('.bar_robot').removeClass('displayNone').addClass('displayBlock'); /* fix for iPhone added */
	}
	$('.box_holder .box_bottom').hide();
	/* 20180501 Accessibility Reapply tab funcitonality to content */
	/* 20240326 accessibility 2024 */
	$('.box_closer').attr('tabindex', -1);
	$('.box_closer').attr('aria-hidden', true);
	$('.box_title').attr('tabindex', -1);
	$('.box_title').attr('aria-hidden', true);
	$('.box_message').attr('tabindex', -1);
	$('.box_message').attr('aria-hidden', true);
	if(index === true){
		setMenuTabIndex();
	}else{
		$('.bar_robot').find('.home').each(function(index, element) {
			$(this).attr('role', 'button');
			$(this).attr('tabindex', 1);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', false);
		});
		$('.bar_robot').find('.switchLang').each(function(index, element) { // 20221018 QA fix for tabbing to buttons when resource/hotword popup visible
			$(this).attr('role', 'button');
			$(this).attr('tabindex', 2);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', false);
		});
		$('.bar_robot').find('.page').each(function(index, element) {
			$(this).attr('role', 'button');
			$(this).attr('tabindex', 3);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', false);
		});
        $('.bar_robot').find('.bar_close').each(function(index, element) {
			$(this).attr('role', 'button');
			$(this).attr('tabindex', 4);
			/* 20240326 accessibility 2024 */
			$(this).attr('aria-hidden', false);
		});
		
		setTabIndex();  // 20221018 QA fix for tabbing to buttons when resource/hotword popup visible
		
		setNavTab();
		
	}
	
	$('.resource_header').unbind();
	$('.resource_links').css('display','none');
	
	

	popupKeyDown = false;
	
	$(butReturnFocus).focus(); // Return focus to button or hotword
	
	/* 20180501 Accessibility Reapply tab funcitonality to content */
	if(isiPad || isiPhone){
		document.ontouchmove = function(e){ return true; } // 20201706 enable scroll on devices
	}
}

/* disable/enable scroll bar */
$.fn.disableScroll = function() {
    window.oldScrollPos = $(window).scrollTop();
	$(window).bind('mousewheel',function(){ return false; });
    /*$(window).on('scroll.scrolldisabler',function ( event ) {
       $(window).scrollTop( window.oldScrollPos );
       event.preventDefault();
    });*/
};

$.fn.enableScroll = function() {
    //$(window).off('scroll.scrolldisabler');
	$(window).unbind('mousewheel');
};

/* 20240326 accessibility 2024 */
$('.box_top_btn').click(function(e){
	$('.box_closer').focus();
});

/* 20240326 accessibility 2024 */
$('.box_top_btn').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {
		$(this).trigger('click');
	}
});

/* 20240326 accessibility 2024 */
$('.transcript_top_btn').click(function(e){
	$(this).parent().parent().find('.transcript_btn').focus();
});

/* 20240326 accessibility 2024 */
$('.transcript_top_btn').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {
		$(this).trigger('click');
	}
});