/* functions for inline and assessment multiple choice single answer and multiple choice multiple answer questions and the overall assessment */

/* set up the functionality of the clickable options */
var inputChkDone = false;
function setupClickableOptions () 
{	
	$(".qItems .qItem").each(function() {
		$(this).bind( "click", function() { 
			toggleOptionChoice($(this));
		});		
				
		$(this).bind("keypress", function(e){
			if (e.keyCode == 13 || e.keyCode == 32) {
				toggleOptionChoice($(this));
			}			
		});
		/* stop checkbox from bubbling up to parent action and calling twice */
		$(this).find(".squaredBox").bind( "click", function(event) { 
			event.stopPropagation();
		});		
		/*$(this).find(".squaredBox").bind("keypress", function(e){
			if (e.keyCode == 13 || e.keyCode == 32) {
				event.stopPropagation();
			}
		});*/		
  	});	
	/* ensures that the edge of the checkbox is clickable */
	$(".squaredBox").bind( "click", function() {
		toggleOptionChoice($(this).parent().parent());
	});	
	
	/*$(".squaredBox").bind("keypress", function(e){
		if (e.keyCode == 13 || e.keyCode == 32) {
			toggleOptionChoice($(this).parent().parent());
		}		
	});*/
	
	/* assign click action to change of checkbox only once */
	$('input[type=checkbox]').change( function(){
		toggleOptionChoice($(this).parent().parent().parent());		
		inputChkDone = true;
	});
	/* set submit button to disabled when page loads */
	$('.submit_btn').addClass('disabled');
	/* 20220704 Accessibility Update */
	$('.submit_btn').attr('title', localiseString('submit_btn_locked'));
	$('.submit_btn').attr('alt', localiseString('submit_btn_locked'));

	/* set focus to feedback */
	$( ".submit_btn" ).keypress(function(e) {
		if (e.keyCode == 13 || e.keyCode == 32) {
            // 20190610 fix to stop question screens jumping on iPad and Android
            if(isWeb){ 
				if(document.takingPretest){
					/* 20230427 Focus fix for pre-test question as no feedback is shown */
					//$('#sec_' + document.currentSection + ' .complete_arrow').focus();
					/* 20240130 accessibility 2024 */
					/* client testing requirements 2024: */
					/* show immediate feedback for course-level (no topics associated) pre-test */	
					/*if ($('.testResults').css('display') == 'none')
					{
						$('#sec_' + document.currentSection).next(".section").find(".question_leadin").focus();
					}
					else
					{
						$('.testResults').find('.page_start').focus();
					}*/
				}
			}
		}
	});	
	
	/* 20180501 Accessibility Added to set feedback focus when using a screen reader, JAWs doesn't use keypress */
	$( ".submit_btn" ).click(function(e) {
		// 20190610 fix to stop question screens jumping on iPad and Android
		if(isWeb){
	  		if(document.takingPretest){
				/* 20230427 Focus fix for pre-test question as no feedback is shown */
				//$('#sec_' + document.currentSection + ' .complete_arrow').focus();
				/* 20240130 accessibility 2024 */
				/* client testing requirements 2024: */
				/* show immediate feedback for course-level (no topics associated) pre-test */	
				/*if ($('.testResults').css('display') == 'none')
				{
					$('#sec_' + document.currentSection).next(".section").find(".question_leadin").focus();
				}
				else
				{
					$('.testResults').find('.page_start').focus();
				}*/
            }
		}
	});
	/* 20180501 Accessibility Added to set feedback focus when using a screen reader, JAWs doesn't use keypress */
}

function reSetupClickableOptionsInlineQues(secId)
{	
	$("#" + secId + " .qItem").each(function() {
		$(this).unbind("click");
		$(this).bind( "click", function() { 
			toggleOptionChoice($(this));
		});
		
		// 20170830 Keyboard functionality
		$(this).bind("keypress", function(e){
			if (e.keyCode == 13 || e.keyCode == 32) {
				toggleOptionChoice($(this));
			}			
		});
		// 20170830 Keyboard functionality

		$(this).find(".squaredBox").unbind("click");
		/* ensures that the edge of the checkbox is clickable */
		/* stop checkbox from bubbling up to parent action and calling twice */
		$(this).find(".squaredBox").bind( "click", function(event) { 
			toggleOptionChoice($(this).parent().parent());
			event.stopPropagation();
		});
		/* assign click action to change of checkbox */
		$(this).find(".inputTest input[type=checkbox]").change( function(){
			toggleOptionChoice($(this).parent().parent().parent());
		});
  	});
	setTabIndex(); // 20170830 Keyboard functionality
}

function reSetupClickableOptionsTest (gotoPlaceSec) 
{	
	$(".qItems .qItemTest").each(function() {
		$(this).unbind("click");
		$(this).bind( "click", function() { 
			toggleOptionChoice($(this));
		});
		
		// 20170830 Keyboard functionality
		$(this).bind("keypress", function(e){
			if (e.keyCode == 13 || e.keyCode == 32) {
				toggleOptionChoice($(this));
			}			
		});
		// 20170830 Keyboard functionality

		$(this).find(".squaredBoxTest").unbind("click");
		/* ensures that the edge of the checkbox is clickable */
		/* stop checkbox from bubbling up to parent action and calling twice */
		$(this).find(".squaredBoxTest").bind( "click", function(event) {
			toggleOptionChoice($(this).parent().parent());		
			event.stopPropagation();
		});
  	});	
	
	/* assign click action to change of checkbox only once */
	if (!inputChkDone) {
		$('.inputTest input[type=checkbox]').change( function(){
			toggleOptionChoice($(this).parent().parent().parent());		
			inputChkDone = true;
		}); 
	}
	/* set submit button to disabled when page loads */
	$('.submit_btn').addClass('disabled');
	
	/* 2021 Accessibility Update */
	$('.submit_btn').attr('title', localiseString('submit_btn_locked'));
	$('.submit_btn').attr('alt', localiseString('submit_btn_locked'));
	
	$('.testQues .submit_btn').css('display','block');
	
	/* separate correct feedback for each option on mcsa questions 20220629 */
	/* 030424 inline question and assessment condensed spacing */
	$('.testQues .diff_fb').css('display','none');

	setTabIndex(); // 20170830 Keyboard functionality	
	
	/* 20220630 Accessibility Update */		
	$(gotoPlaceSec + ' .page_start').focus();
}

/* toggle the selected option on/off and update the user selected array */
function toggleOptionChoice (o) 
{		
	document.optionsArr = [];
	var optId = $(o).attr('id');	
	var secNum = optId.split("_")[1];
	var secId = "sec_" + secNum;
	var optNum1 = optId.split("_")[2];
	var optNum2 = optId.split("_")[3];
	var optTest = optId.split("_")[4];
	var optQType = optId.split("_")[5];	
	var numOfOptions = $("#" + secId + " .qItems .qItem").length / 2;
	var userAnsArray = "";
	if (optTest == "t") {
		userAnsArray = jQuery.makeArray(post_test_ques_dat[secId][0].user_ans.split(","));
	}
	else if (optTest == "tt") { // section topic test-out
		userAnsArray = jQuery.makeArray(topic_pre_ques_dat[secId][0].user_ans.split(","));
	}
	else {
		userAnsArray = jQuery.makeArray(inline_ques_dat[secId][0].user_ans.split(","));
	}
	if (optQType == "mcsa") {
		for (var i = 0; i < numOfOptions; i++)
		{
			userAnsArray[i] = 0;
			$('#rb_'+ secNum + "_" + (i + 1)).prop('checked', false);
            $("#opt_" + secNum + "_" + (i + 1) + "_0_" + optTest + "_mcsa").attr("aria-checked", false);
				
			document.optionsArr.push($.trim($("#opt_" + secNum + "_" + (i + 1) + "_0_" + optTest + "_mcsa .labelTxt").text())); //  option text for reporting of interactions
		}	
		userAnsArray[optNum1-1] = 1;
		$('#rb_'+ secNum + "_" + optNum1).prop('checked', true);
        $("#opt_" + secNum + "_" + optNum1 + "_0_" + optTest + "_mcsa").attr("aria-checked", true);
		
	}
	else if (optQType == "mcma") {
		if (userAnsArray[optNum1-1] != 1) {		
			userAnsArray[optNum1-1] = 1;
			$('#rb_'+ secNum + "_" + optNum1).prop('checked', true);
            $("#opt_" + secNum + "_" + optNum1 + "_0_" + optTest + "_mcma").attr("aria-checked", true);
		}
		else {
			userAnsArray[optNum1-1] = 0;
			$('#rb_'+ secNum + "_" + optNum1).prop('checked', false);
            $("#opt_" + secNum + "_" + optNum1 + "_0_" + optTest + "_mcma").attr("aria-checked", false);
		}	
		
		for (var i = 0; i < numOfOptions; i++){
			document.optionsArr.push($.trim($("#opt_" + secNum + "_" + (i + 1) + "_0_" + optTest + "_mcma .labelTxt").text())); //  option text for reporting of interactions
		}
		
	}
	/* change submit button state to enabled as long as at least one option selected */
	
	if(optTest == "tt"){ // section topic test-out
		if (userAnsArray.toString().indexOf(1) >= 0) {
			$('#submit_btn_' + secNum).removeClass('disabled');
			/* 20220704 Accessibility Update */
			$('#submit_btn_' + secNum).attr('title', localiseString('submit_btn'));
			$('#submit_btn_' + secNum).attr('alt', localiseString('submit_btn'));
		}
		else {
			$('#submit_btn_' + secNum).addClass('disabled');
			/* 20220704 Accessibility Update */
			$('#submit_btn_' + secNum).attr('title', localiseString('submit_btn_locked'));
			$('#submit_btn_' + secNum).attr('alt', localiseString('submit_btn_locked'));
		}
	}
	else{
		if (userAnsArray.toString().indexOf(1) >= 0) {
			$('#submit_btn_' + secNum).removeClass('disabled');
			/* 20220704 Accessibility Update */
			$('#submit_btn_' + secNum).attr('title', localiseString('submit_btn'));
			$('#submit_btn_' + secNum).attr('alt', localiseString('submit_btn'));
		}
		else {
			$('#submit_btn_' + secNum).addClass('disabled');
			/* 20220704 Accessibility Update */
			$('#submit_btn_' + secNum).attr('title', localiseString('submit_btn_locked'));
			$('#submit_btn_' + secNum).attr('alt', localiseString('submit_btn_locked'));
		}
	}
	if (optTest == "t") {
		post_test_ques_dat[secId][0].user_ans = userAnsArray.join(",");		
	}else if (optTest == "tt"){ // section topic test-out
		topic_pre_ques_dat[secId][0].user_ans = userAnsArray.join(",");	
	}
	else {
		inline_ques_dat[secId][0].user_ans = userAnsArray.join(",");
	}
}

/* process the submitted answer */
function calcAns(secNum, secTest, secQType, tNum, cNum) {	
	
	var secId = "sec_" + secNum;
	var numOfOptions = $("#" + secId + " .qItems .qItem").length / 2;	
	var inlineCorrect = true;
	var correctAnsArray = "";
	var userAnsArray = "";
	var runningTotal = 0;
	var score = 0;
	var partialScoring = false;
	var results_content = "";
	var results_review_content = ""; /* post-test review incorrect questions for passed post-test support 061422 */
	var score_content = ";"
	var testScore = actionsLMSGetScore();
	
	document.answeredCorrect = false; // section topic test-out
	

	var confidence = cNum;
	
	/* separate correct feedback for each option on mcsa questions 20220629 */
	var diffFB = false;
	if($("#sec_"+secNum).hasClass("diff_feedback")){
		diffFB = true;
	}
	
	/* pre-test no topics associated with questions support kgs 03/18/22 */
	document.pretestAnsIncorrect = false;
	
	document.questStem = $.trim($("#"+secId + " .questionStem").text()); // section topic test-out question stem for reporting interactions	
	if (secTest == "t") {
		post_test_ques_dat[secId][0].answered = '1';
	}
	
	testScore = testScore == "" ? 0 : Number(testScore);
	$("#submit_btn_" + secNum).blur();
	if ($("#submit_btn_" + secNum).html() == localiseString('tryagain_btn'))
	{
		document.inlineNumOfAttempts++;
		resetInlineQues(secNum,tNum);		
		$("#submit_btn_" + secNum).addClass("disabled");
		$('#submit_btn_' + secNum).attr('title', localiseString('submit_btn'));
		$('#submit_btn_' + secNum).attr('alt', localiseString('submit_btn'));
	}
	else
	{
		if (secTest == "t") {
			document.test_score = Number(jQuery.makeArray(post_test_ques_dat['test_dat'][0].user_score));		
			correctAnsArray = jQuery.makeArray(post_test_ques_dat[secId][0].ans.split(","));		
			userAnsArray = jQuery.makeArray(post_test_ques_dat[secId][0].user_ans.split(","));		
			document.currentAssessQues++;
			secTest = "_t";		
		}
		else if (secTest == "tt"){ // section topic test-out
			document.test_score = Number(jQuery.makeArray(topic_pre_ques_dat['test_dat'][0].user_score));		
			correctAnsArray = jQuery.makeArray(topic_pre_ques_dat[secId][0].ans.split(","));		
			userAnsArray = jQuery.makeArray(topic_pre_ques_dat[secId][0].user_ans.split(","));
			secTest = "_tt";
			if(userAnsArray.toString() != correctAnsArray.toString()){		
				inlineCorrect = false;
			}
		 }
		 else {
			 
			 if(document.inlineQuesMaxAttempts > 0){
				if(document.inlineNumOfAttempts == document.inlineQuesMaxAttempts - 1){
					document.inlineQuesTryAgain = false;
					
				}
			}
			 
			correctAnsArray = jQuery.makeArray(inline_ques_dat[secId][0].ans.split(","));
			userAnsArray = jQuery.makeArray(inline_ques_dat[secId][0].user_ans.split(","));
			secTest = "_i";		
			if(userAnsArray.toString() != correctAnsArray.toString()){		
				inlineCorrect = false;
			}
			/* 25/03/2024 testing out of sections of content */			
			hideTestedOutContent(secNum,inlineCorrect);
		}
		if((secQType == "mcma") && (((secTest == "_t") && document.partial_scoring_assess) || ((secTest == "_i") && document.partial_feedback_inline)))
		{
			partialScoring = true;
		}
		/* check to see if any options are selected, as long as one option is selected process question */
		if (eval(userAnsArray.join('+')) > 0) {
			for (var x=1; x < (numOfOptions + 1); x++) {			
				/* test out: if there is a pre-test in the course and it is being taken */
				if ((document.pretestPresent == 1) && document.takingPretest)
				{
					/* test out: apply background style to options for pre-test questions */
					//$("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).addClass("mcma_hl_pretest");			
					//$("#opt_"+ secNum + "_" + x + "_1" + secTest + "_" + secQType).addClass("mcma_hl_pretest");
				}
				else {
					/* if inline question try again is enabled and the question is not correct */
					if (document.inlineQuesTryAgain && !inlineCorrect)
					{
						/* do nothing */
					}
					else 
					{
						/* change the background of all items to the incorrect highlight */
                        if(userAnsArray[x - 1] == 1){
						  //$("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).addClass("mcma_hl_incorr");			
						  //$("#opt_"+ secNum + "_" + x + "_1" + secTest + "_" + secQType).addClass("mcma_hl_incorr");
                          //$("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).find(".squaredBox label").addClass("mc_btn_incorrect"); // LJ Tick Cross Functionality
							//$("#opt_"+ secNum + "_" + x + "_1" + secTest + "_" + secQType).addClass("mc_btn_incorrect");
							
						  //$("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).find(".squaredBox label")
                        }else{
                            //$("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).addClass("mcma_hl_pretest");			
					        //$("#opt_"+ secNum + "_" + x + "_1" + secTest + "_" + secQType).addClass("mcma_hl_pretest");
                        }
					}	
				}			
				if (userAnsArray[x - 1] == 1) {
					/* if inline question try again is enabled and the question is not correct */
					if (document.inlineQuesTryAgain && !inlineCorrect)
					{
						/* do nothing */
					}
					else 
					{
						$('#rb_'+ secNum + "_" + x).prop('checked', false);
					}
					/* test out: if there is a pre-test in the course and it is being taken */
					if ((document.pretestPresent == 1) && document.takingPretest)
					{						
						/* test out: apply background style to options for pre-test questions */
						$("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).find(".squaredBox label").addClass("mcma_hl_pretest");
					}
					else {
						/* if inline question try again is enabled and the question is not correct */
						if (document.inlineQuesTryAgain && !inlineCorrect)
						{
							/* do nothing */
						}
						else 
						{
							/* change all selected checkbox items to the incorrect highlight */
                            if(userAnsArray[x - 1] == 1){
                                
							     $("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).find(".squaredBox label").addClass("mcma_hl_incorr");
                                 //$("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).find(".squaredBox label").addClass("mc_btn_incorrect"); // LJ Tick Cross Functionality
								//$("#opt_"+ secNum + "_" + x + "_1" + secTest + "_" + secQType).addClass("mc_btn_incorrect");
                            }else{
                                $("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).find(".squaredBox label").addClass("mcma_hl_pretest");
                            }
						}	
					}	
					if (correctAnsArray[x - 1] == 1) {
						/* if inline question try again is enabled and the question is not correct */
						if (document.inlineQuesTryAgain && !inlineCorrect)
						{
							/* do nothing */
						}
						else {
							$('#rb_'+ secNum + "_" + x).prop('checked', false);
						}	
						/* test out: if there is a pre-test in the course and it is being taken */
						if ((document.pretestPresent == 1) && document.takingPretest)
						{
							/* test out: apply background style to options for pre-test questions */
							//$("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).addClass("mcma_hl_pretest");
							//$("#opt_"+ secNum + "_" + x + "_1" + secTest + "_" + secQType).addClass("mcma_hl_pretest");					
							$("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).find(".squaredBox label").addClass("mcma_hl_pretest");
						}
						else {
							/* if inline question try again is enabled and the question is not correct */
							if (document.inlineQuesTryAgain && !inlineCorrect)
							{
								/* do nothing */
							}
							else
							{
								/* allow showing of ticks and/or feedback in post-test to be configurable 060722 */
								if ((secTest == "_i") || ((secTest == "_t") && document.showAssessTicks))
								{
									/* change all selected checkbox items to the correct highlight */				
									//$("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).addClass("mcma_hl_corr");
									//$("#opt_"+ secNum + "_" + x + "_1" + secTest + "_" + secQType).addClass("mcma_hl_corr");					
									$("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).find(".squaredBox label").addClass("mcma_hl_corr");
								   // $("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).find(".squaredBox label").removeClass("mc_btn_incorrect").addClass("mc_btn_correct"); // LJ Tick Cross Functionality
									$("#opt_"+ secNum + "_" + x + "_1" + secTest + "_" + secQType).removeClass("mc_btn_incorrect").addClass("mc_btn_correct");
								}	
							}	
						}	
						if(partialScoring)
						{
							/* for each correct answer selected, give 1pt */
							runningTotal++;
						}
					}
					else
					{
						if (correctAnsArray[x - 1] == 0) 
						{
							if(partialScoring)
							{
								/* for each incorrect answer selected, take 1pt */
								runningTotal--;
							}	
						}
					}
				}
				else
				{				
					if (correctAnsArray[x - 1] == 1) 
					{
						/* test out: if there is a pre-test in the course and it is being taken */
						if ((document.pretestPresent == 1) && document.takingPretest)
						{
							//$("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).addClass("mcma_hl_pretest");
							//$("#opt_"+ secNum + "_" + x + "_1" + secTest + "_" + secQType).addClass("mcma_hl_pretest");
						}	
						else {
							/* if inline question try again is enabled and the question is not correct */
							if (document.inlineQuesTryAgain && !inlineCorrect)
							{
								/* do nothing */
							}
							else
							{
                                if(secTest == "_i"){
								    //$("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).addClass("mcma_hl_corr");
								    //$("#opt_"+ secNum + "_" + x + "_1" + secTest + "_" + secQType).addClass("mcma_hl_corr");
                                    //$("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).find(".squaredBox label").removeClass("mc_btn_incorrect").addClass("mc_btn_correct"); // LJ Tick Cross Functionality
									$("#opt_"+ secNum + "_" + x + "_1" + secTest + "_" + secQType).removeClass("mc_btn_incorrect").addClass("mc_btn_correct");
                                }else{
                                   // $("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).addClass("mcma_hl_pretest");
							       // $("#opt_"+ secNum + "_" + x + "_1" + secTest + "_" + secQType).addClass("mcma_hl_pretest");
                                }
							}	
						}	
						if(partialScoring)
						{
							/* for each correct answer not selected, take 1pt */
							runningTotal--;
						}	
					}
					else
					{
						if(partialScoring)
						{
							/* for each incorrect answer not selected, give 1pt */
							runningTotal++;
						}	
					}	
				}
				$("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).unbind("click");			
				$("#opt_"+ secNum + "_" + x + "_1" + secTest + "_" + secQType).unbind("click");
				$("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).unbind("keypress");	// 20170830	keyboard functionality	
				$("#opt_"+ secNum + "_" + x + "_1" + secTest + "_" + secQType).unbind("keypress");  // 20170830 keyboard functionality
				$("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).css("cursor","default");
				$("#opt_"+ secNum + "_" + x + "_1" + secTest + "_" + secQType + " .button").css("cursor","default");
			}
			/* show feedback */
			if(partialScoring)
			{
				/* set score per calculation rules */
				if (runningTotal > 0) {
					score = 0.5;
				}
				else if (runningTotal <= 0) {
					score = 0;
				}
			}
			if(userAnsArray.toString() == correctAnsArray.toString()){
				
				document.answeredCorrect = true; // Topic PreTest
				
				if (secTest == "_t")
				{
					/* if completely answered correctly, give full pt */
					document.test_score++;
					/* post-test review incorrect questions for passed post-test support 061422 */
					if (!document.takingPretest && document.showAssessResultsReview)
					{
						post_test_ques_dat[secId][0].correct = '1';
					}
					/* test out: if there is a pre-test in the course */
					if (document.pretestPresent == 1)
					{
						var topicNum = Number(post_test_ques_dat[secId][0].topic_num);
						/* test out: if the pre-test is being taken then add one to the number of questions answered correctly for this topic */
						if (document.takingPretest) {
							document.topicsPretestQuesCorArr[topicNum - 1] = document.topicsPretestQuesCorArr[topicNum - 1] + 1;
						}
					}				
				} 
				
				if(secTest == "_tt"){
					
					document.topic_test_score++; // section topic test-out
					//console.log("here document.topic_test_score = " + document.topic_test_score)
				}
				
				/* test out: if there is a pre-test in the course */
				if (document.pretestPresent == 1)
				{
					/* test out: do not show feedback for pre-test questions */
					/* pre-test no topics associated with questions support kgs 03/18/22 */
					/* 20240319 pre-test that appears after first topic */
					if ((secTest == "_i") || ((secTest == "_t") && (!document.takingPretest)) || ((secTest == "_t") && (document.noTopicsAssociatedPretest) && (!document.takingPretest))) {										
						/* if inline question try again is enabled and the question is not correct */
						if (document.inlineQuesTryAgain && !inlineCorrect)
						{
							/* do nothing */
						}
						else
						{
							/* allow showing of ticks and/or feedback in post-test to be configurable 060722 */
							if ((secTest == "_i") || ((secTest == "_t") && document.showAssessFeedback))
							{
								if(document.useTransitions){
									/* transitions: fade in question feedback */
									$("#feedback_corr_" + secNum).fadeIn();
									/* 20240130 accessibility 2024 */
									$("#feedback_corr_" + secNum).find('.feedback_start').focus();
								}else{
									$("#feedback_corr_" + secNum).show();
									/* 20240130 accessibility 2024 */
									$("#feedback_corr_" + secNum).find('.feedback_start').focus();
								}
							}
							/* allow showing of immediate feedback in post-test to be configurable 071922 */
							if ((secTest == "_t") && document.showImmediateAssessFeedback)
							{
								if(document.useTransitions){
									/* transitions: fade in question feedback */
									$("#feedback_immediate_corr_" + secNum).fadeIn();
									/* 20240130 accessibility 2024 */
									$("#feedback_immediate_corr_" + secNum).find('.feedback_start').focus();
								}else{
									$("#feedback_immediate_corr_" + secNum).show();
									/* 20240130 accessibility 2024 */
									$("#feedback_immediate_corr_" + secNum).find('.feedback_start').focus();
								}
							}
						}	
					}
					/* client testing requirements 2024: */
					/* show immediate feedback for course-level (no topics associated) pre-test */
					else if ((secTest == "_t") && document.takingPretest && document.showImmediateAssessFeedback)
					{
						if(document.useTransitions){
							/* transitions: fade in question feedback */
							$("#feedback_immediate_corr_" + secNum).fadeIn();
							/* 20240130 accessibility 2024 */
							$("#feedback_immediate_corr_" + secNum).find('.feedback_start').focus();
						}else{
							$("#feedback_immediate_corr_" + secNum).show();
							/* 20240130 accessibility 2024 */
							$("#feedback_immediate_corr_" + secNum).find('.feedback_start').focus();
						}
					}
				}
				else
				{
					/* if inline question try again is enabled and the question is not correct */
					if (document.inlineQuesTryAgain && !inlineCorrect)
					{
						/* do nothing */
					}
					else
					{						
						/* allow showing of ticks and/or feedback in post-test to be configurable 060722 */
						if ((secTest == "_i") || ((secTest == "_t") && document.showAssessFeedback))
						{						
							if(document.useTransitions){
								/* transitions: fade in question feedback */
								$("#feedback_corr_" + secNum).fadeIn();
								/* 20240130 accessibility 2024 */
								$("#feedback_corr_" + secNum).find('.feedback_start').focus();
							}else{
								$("#feedback_corr_" + secNum).show();
								/* 20240130 accessibility 2024 */
								$("#feedback_corr_" + secNum).find('.feedback_start').focus();
							}
						}
						/* allow showing of immediate feedback in post-test to be configurable 071922 */
						if ((secTest == "_t") && document.showImmediateAssessFeedback)
						{
							if(document.useTransitions){
								/* transitions: fade in question feedback */
								$("#feedback_immediate_corr_" + secNum).fadeIn();
								/* 20240130 accessibility 2024 */
								$("#feedback_immediate_corr_" + secNum).find('.feedback_start').focus();
							}else{
								$("#feedback_immediate_corr_" + secNum).show();
								/* 20240130 accessibility 2024 */
								$("#feedback_immediate_corr_" + secNum).find('.feedback_start').focus();
							}
						}
					}	
				}	
			}
			else
			{		
				if (score > 0)
				{
					if (secTest == "_t")
					{
						document.test_score+=score;
						/* test out: if there is a pre-test in the course */
						if (document.pretestPresent == 1)
						{
							/* test out: do not show feedback for pre-test questions */
							if (!document.takingPretest) {
								/* allow showing of ticks and/or feedback in post-test to be configurable 060722 */
								if (document.showAssessFeedback)
								{
									if(document.useTransitions){
										/* transitions: fade in question feedback */
										$("#feedback_partial_" + secNum).fadeIn();
										/* 20240130 accessibility 2024 */
										$("#feedback_partial_" + secNum).find('.feedback_start').focus();
									}else{
										$("#feedback_partial_" + secNum).show();
										/* 20240130 accessibility 2024 */
										$("#feedback_partial_" + secNum).find('.feedback_start').focus();
									}
								}
								/* allow showing of immediate feedback in post-test to be configurable 071922 */
								if (document.showImmediateAssessFeedback)
								{
									if(document.useTransitions){
										/* transitions: fade in question feedback */
										$("#feedback_immediate_partial_" + secNum).fadeIn();
										/* 20240130 accessibility 2024 */
										$("#feedback_immediate_partial_" + secNum).find('.feedback_start').focus();
									}else{
										$("#feedback_immediate_partial_" + secNum).show();
										/* 20240130 accessibility 2024 */
										$("#feedback_immediate_partial_" + secNum).find('.feedback_start').focus();
									}
								}
							}	
						}
						else
						{
							/* allow showing of ticks and/or feedback in post-test to be configurable 060722 */
							if (document.showAssessFeedback)
							{
								if(document.useTransitions){
									/* transitions: fade in question feedback */
									$("#feedback_partial_" + secNum).fadeIn();
									/* 20240130 accessibility 2024 */
									$("#feedback_partial_" + secNum).find('.feedback_start').focus();
								}else{
									$("#feedback_partial_" + secNum).show();
									/* 20240130 accessibility 2024 */
									$("#feedback_partial_" + secNum).find('.feedback_start').focus();
								}
							}
							/* allow showing of immediate feedback in post-test to be configurable 071922 */
							if (document.showImmediateAssessFeedback)
							{
								if(document.useTransitions){
									/* transitions: fade in question feedback */
									$("#feedback_immediate_partial_" + secNum).fadeIn();
									/* 20240130 accessibility 2024 */
									$("#feedback_immediate_partial_" + secNum).find('.feedback_start').focus();
								}else{
									$("#feedback_immediate_partial_" + secNum).show();
									/* 20240130 accessibility 2024 */
									$("#feedback_immediate_partial_" + secNum).find('.feedback_start').focus();
								}
							}
						}					
					}
					else
					{
						/* if inline question try again is enabled and the question is not correct */
						if (document.inlineQuesTryAgain && !inlineCorrect)
						{			
							var numOfOptions = $("#" + secId + " .qItems .qItem").length / 2;
							for (var x=1; x < (numOfOptions + 1); x++) {
								//$("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).addClass("mcma_hl_pretest");
								//$("#opt_"+ secNum + "_" + x + "_1" + secTest + "_" + secQType).addClass("mcma_hl_pretest");
								if (secQType == "mcsa")
								{
									$("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).find(".squaredBox").removeClass().addClass("squaredBoxMCSA").addClass("squaredBox").addClass("alignCheckBox");
								}
								else if (secQType == "mcma")
								{
									$("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).find(".squaredBox").removeClass().addClass("squaredBox").addClass("alignCheckBox");
								}
								if (userAnsArray[x - 1] == 1)
								{							
									$("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).find(".squaredBox label").addClass("mcma_hl_pretest");
								}
							}
							if(document.useTransitions){
								/* transitions: fade in question feedback */
								$("#feedback_tryagain_" + secNum).fadeIn();
								/* 20240130 accessibility 2024 */
								$("#feedback_tryagain_" + secNum).find('.feedback_start').focus();
							}else{
								$("#feedback_tryagain_" + secNum).show();
								/* 20240130 accessibility 2024 */
								$("#feedback_tryagain_" + secNum).find('.feedback_start').focus();
							}
						}
						else
						{
							if(document.partial_feedback_inline)
							{								
								if(document.useTransitions){
									/* transitions: fade in question feedback */
									$("#feedback_partial_" + secNum).fadeIn();
									/* 20240130 accessibility 2024 */
									$("#feedback_partial_" + secNum).find('.feedback_start').focus();
								}else{
									$("#feedback_partial_" + secNum).show();
									/* 20240130 accessibility 2024 */
									$("#feedback_partial_" + secNum).find('.feedback_start').focus();
								}								
							}
							else
							{
								/* allow showing of ticks and/or feedback in post-test to be configurable 060722 */
								if ((secTest == "_i") || ((secTest == "_t") && document.showAssessFeedback))
								{
									if(document.useTransitions){
										/* transitions: fade in question feedback */
										$("#feedback_incorr_" + secNum).fadeIn();
										/* 20240130 accessibility 2024 */
										$("#feedback_incorr_" + secNum).find('.feedback_start').focus();
									}else{
										$("#feedback_incorr_" + secNum).show();
										/* 20240130 accessibility 2024 */
										$("#feedback_incorr_" + secNum).find('.feedback_start').focus();
									}
								}
								/* allow showing of immediate feedback in post-test to be configurable 071922 */
								if ((secTest == "_t") && document.showImmediateAssessFeedback)
								{
									if(document.useTransitions){
										/* transitions: fade in question feedback */
										$("#feedback_immediate_incorr_" + secNum).fadeIn();
										/* 20240130 accessibility 2024 */
										$("#feedback_immediate_incorr_" + secNum).find('.feedback_start').focus();
									}else{
										$("#feedback_immediate_incorr_" + secNum).show();
										/* 20240130 accessibility 2024 */
										$("#feedback_immediate_incorr_" + secNum).find('.feedback_start').focus();
									}
								}
							}	
						}	
					}
				}
				else {
					/* test out: if there is a pre-test in the course */
					if (document.pretestPresent == 1)
					{
						/* pre-test no topics associated with questions support kgs 03/18/22 */
						if (document.noTopicsAssociatedPretest && document.takingPretest)
						{
							document.pretestAnsIncorrect = true;
							/* client testing requirements 2024: */
							/* if enough questions are answered incorrectly that the learner can no longer pass the pre-test then show the pre-test results */
							document.pretestAnsIncorrectTotal++;
						}	
						/* test out: do not show feedback for pre-test questions */
						if ((secTest == "_i") || ((secTest == "_t") && (!document.takingPretest))) {
							/* if inline question try again is enabled and the question is not correct */
							if ((secTest == "_i") && document.inlineQuesTryAgain && !inlineCorrect)
							{				
								var numOfOptions = $("#" + secId + " .qItems .qItem").length / 2;
								for (var x=1; x < (numOfOptions + 1); x++) {
									//$("#opt_"+ secNum + "_" + x + "_1" + secTest + "_" + secQType).addClass("mcma_hl_pretest");
									//$("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).addClass("mcma_hl_pretest");
									if (secQType == "mcsa")
									{
										$("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).find(".squaredBox").removeClass().addClass("squaredBoxMCSA").addClass("squaredBox").addClass("alignCheckBox");
									}
									else if (secQType == "mcma")
									{
										$("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).find(".squaredBox").removeClass().addClass("squaredBox").addClass("alignCheckBox");
									}
									if (userAnsArray[x - 1] == 1)
									{
										$("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).find(".squaredBox label").addClass("mcma_hl_pretest");
									}
								}								
								if(document.useTransitions){
									/* transitions: fade in question feedback */
									$("#feedback_tryagain_" + secNum).fadeIn();
									/* 20240130 accessibility 2024 */
									$("#feedback_tryagain_" + secNum).find('.feedback_start').focus();
								}else{
									$("#feedback_tryagain_" + secNum).show();
									/* 20240130 accessibility 2024 */
									$("#feedback_tryagain_" + secNum).find('.feedback_start').focus();
								}
							}
							else
							{
								/* allow showing of ticks and/or feedback in post-test to be configurable 060722 */
								if ((secTest == "_i") || ((secTest == "_t") && document.showAssessFeedback))
								{
									if(document.useTransitions){
										/* transitions: fade in question feedback */
										$("#feedback_incorr_" + secNum).fadeIn();
										/* 20240130 accessibility 2024 */
										$("#feedback_incorr_" + secNum).find('.feedback_start').focus();
									}else{
										$("#feedback_incorr_" + secNum).show();
										/* 20240130 accessibility 2024 */
										$("#feedback_incorr_" + secNum).find('.feedback_start').focus();
									}
								}
								/* allow showing of immediate feedback in post-test to be configurable 071922 */
								if ((secTest == "_t") && document.showImmediateAssessFeedback)
								{
									if(document.useTransitions){
										/* transitions: fade in question feedback */
										$("#feedback_immediate_incorr_" + secNum).fadeIn();
										/* 20240130 accessibility 2024 */
										$("#feedback_immediate_incorr_" + secNum).find('.feedback_start').focus();
									}else{
										$("#feedback_immediate_incorr_" + secNum).show();
										/* 20240130 accessibility 2024 */
										$("#feedback_immediate_incorr_" + secNum).find('.feedback_start').focus();
									}
								}								
							}	
						}
						/* client testing requirements 2024: */
						/* show immediate feedback for course-level (no topics associated) pre-test */					
						else if ((secTest == "_t") && document.takingPretest && document.showImmediateAssessFeedback)
						{
							if(document.useTransitions){
								/* transitions: fade in question feedback */
								$("#feedback_immediate_incorr_" + secNum).fadeIn();
								/* 20240130 accessibility 2024 */
								$("#feedback_immediate_incorr_" + secNum).find('.feedback_start').focus();
							}else{
								$("#feedback_immediate_incorr_" + secNum).show();
								/* 20240130 accessibility 2024 */
								$("#feedback_immediate_incorr_" + secNum).find('.feedback_start').focus();
							}
						}
					}
					else 
					{
						/* if inline question try again is enabled and the question is not correct */
						if ((secTest == "_i") && document.inlineQuesTryAgain && !inlineCorrect)
						{					
							var numOfOptions = $("#" + secId + " .qItems .qItem").length / 2;
							for (var x=1; x < (numOfOptions + 1); x++) {
								//$("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).addClass("mcma_hl_pretest");
								//$("#opt_"+ secNum + "_" + x + "_1" + secTest + "_" + secQType).addClass("mcma_hl_pretest");
								if (secQType == "mcsa")
								{
									$("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).find(".squaredBox").removeClass().addClass("squaredBoxMCSA").addClass("squaredBox").addClass("alignCheckBox");
								}
								else if (secQType == "mcma")
								{
									$("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).find(".squaredBox").removeClass().addClass("squaredBox").addClass("alignCheckBox");
								}
								if (userAnsArray[x - 1] == 1)
								{							
									$("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).find(".squaredBox label").addClass("mcma_hl_pretest");
								}
							}
							if(document.useTransitions){
								/* transitions: fade in question feedback */
								$("#feedback_tryagain_" + secNum).fadeIn();
								/* 20240130 accessibility 2024 */
								$("#feedback_tryagain_" + secNum).find('.feedback_start').focus();
							}else{
								$("#feedback_tryagain_" + secNum).show();
								/* 20240130 accessibility 2024 */
								$("#feedback_tryagain_" + secNum).find('.feedback_start').focus();
							}
						}
						else
						{	
							/* allow showing of ticks and/or feedback in post-test to be configurable 060722 */
							if ((secTest == "_i") || ((secTest == "_t") && document.showAssessFeedback))
							{					
								if(document.useTransitions){
									/* transitions: fade in question feedback */
									$("#feedback_incorr_" + secNum).fadeIn();
									/* 20240130 accessibility 2024 */
									$("#feedback_incorr_" + secNum).find('.feedback_start').focus();
								}else{
									$("#feedback_incorr_" + secNum).show();
									/* 20240130 accessibility 2024 */
									$("#feedback_incorr_" + secNum).find('.feedback_start').focus();
								}
							}
							/* allow showing of immediate feedback in post-test to be configurable 071922 */
							if ((secTest == "_t") && document.showImmediateAssessFeedback)
							{
								if(document.useTransitions){
									/* transitions: fade in question feedback */
									$("#feedback_immediate_incorr_" + secNum).fadeIn();
									/* 20240130 accessibility 2024 */
									$("#feedback_immediate_incorr_" + secNum).find('.feedback_start').focus();
								}else{
									$("#feedback_immediate_incorr_" + secNum).show();
									/* 20240130 accessibility 2024 */
									$("#feedback_immediate_incorr_" + secNum).find('.feedback_start').focus();
								}
							}							
						}	
					}
				}	
			}	
			if (secTest == "_t")
			{
				post_test_ques_dat['test_dat'][0].user_score = document.test_score;
			}
			
			if(secTest == "_tt"){
				
				topic_pre_ques_dat['test_dat'][0].user_score = document.test_score;
			}
			
			/* disable options */
			$("#" + secId + ' input[type=checkbox]').attr('disabled', true);
			$("#" + secId + " .squaredBox").unbind( "click" );
			$("#" + secId + " .squaredBox").unbind("keypress");  // 20170830 keyboard functionality
			$("#" + secId + " .squaredBox label").css("cursor","default");
			$("#" + secId + " .qItem").unbind( "click");
			$("#" + secId + " .qItem").unbind("keypress");  // 20170830 keyboard functionality
			$("#" + secId + " .qItem").css("cursor","default");
			
			
			//$("#rb_"+ secId +"_2").css("opacity",1);
			//$(".squaredBox_bg_2 label::after").css("background-color", "#53565A");
			
			for (var x=1; x < (numOfOptions + 1); x++) {
				if (userAnsArray[x - 1] == 1){
					$("#opt_"+ secNum + "_" + x + "_0" + secTest + "_" + secQType).find(".squaredBox label").addClass("qSelected");
				}
			}
			
			if (document.inlineQuesTryAgain && !inlineCorrect)
			{
				$("#submit_btn_" + secNum).html(localiseString('tryagain_btn'));
				$("#submit_btn_" + secNum).attr('title',localiseString('tryagain_btn'));
				$("#submit_btn_" + secNum).attr('alt',localiseString('tryagain_btn'));
			}
			else
			{
				/* hide submit */
				$("#submit_btn_" + secNum).hide();
				
				//$("#submit_btn_" + secNum + "_1").hide();
				//$("#submit_btn_" + secNum + "_2").hide();
				
				if(secTest == "_tt"){
					$("#submit_btn_" + secNum + "_1").hide();
					$("#submit_btn_" + secNum + "_2").hide();
				}
			}	
			if (secTest == "_t")
			{	
				document.assessAttempted = true;
				/* pre-test no topics associated with questions support kgs 03/18/22 */
				/* client testing requirements 2024: */
				/* must answer all questions in course-level (no topics associated) pre-test */
				/* client testing requirements 2024: */
				/* if enough questions are answered incorrectly that the learner can no longer pass the pre-test then show the pre-test results */
				// if ((document.currentAssessQues + 1) == document.assessRandomQuesArr.length)
				if (((document.currentAssessQues + 1) == document.assessRandomQuesArr.length) || document.pretestAnsIncorrect)
				{
					/* test out: if there is a pre-test in the course */
					if (document.pretestPresent == 1)
					{
						var percentage_score = 0;
						var totalQues = 0;
						for (var i = 0; i < document.topicsCount; i++)
						{
							totalQues += Number(document.assessSelectQuesArr[i]);	
						}
						
						/* 20230427 different pre/post test banks */
						if (document.diffPrePostTest)
						{
							totalQues = document.assessTotalQues;
							console.log("totalQues = " + totalQues);
						}
						
						/* test out: if taking the pre-test */
						if (document.takingPretest) {
							/* test out: obtain the status of what topics have been tested out of */
							var tempTPretestOutArr = document.topicsPretestedOut.split('');
							/* stores 1s for topics with question banks that are tested out of as well as 1s for topics without question banks that are not required to be viewed */
							var tempTPretestOutArr2 = document.topicsPretestedOut.split('');
							var totalTCanBePretestedOut = 0;
							var totalTPretestedOut = 0;
                           //alert('document.topicsPretestQuesCorArr = ' + document.topicsPretestQuesCorArr)
							for (var y = 0; y < document.topicsCount; y++)
							{
								/* test out: if the number of questions answered correctly for this topic matches those required and it is not the summary topic or the test topic */
								if ((document.topicsPretestQuesCorArr[y] == document.assessSelectQuesArr[y]) && (y != (document.topicsCount - 1)))								
								{							
									/* if there is no question bank for this topic and the topic is not required to be viewed then mark this topic as tested out only in the second array */ 
									if (document.assessTopicHasQBank[y] == "0")
									{	
										tempTPretestOutArr2[y] = 1;
									}
									/* if there is a question bank for this topic then mark this topic as tested out in both arrays */
									else if (document.assessTopicHasQBank[y] == "1")
									{
										tempTPretestOutArr[y] = 1;
										tempTPretestOutArr2[y] = 1;
										/* increment the counter for possible tested out topics */
										totalTCanBePretestedOut++;
										/* increment the counter for tested out topics */
										totalTPretestedOut++;
									}
								}
								else
								{
									/* if there is a question bank for this topic */
									if (document.assessTopicHasQBank[y] == "1")
									{
										/* increment the counter for possible tested out topics */
										totalTCanBePretestedOut++;
									}
								}
							}
							/* if all topics with question banks have been tested out */
							if (totalTPretestedOut == totalTCanBePretestedOut)
							{							
								for (var yy = 0; yy < document.topicsCount; yy++)
								{
									/* if there is no question bank for this topic and the topic is required to be viewed but not if the learner has pre-tested out then mark this topic as tested out only in the second array */ 
									if (document.assessTopicHasQBank[yy] == "3")
									{
										tempTPretestOutArr2[yy] = 1;
									}
								}
							}
							/* test out: if all topics with question banks have been tested out of then mark the test topic as tested out of */
							if (totalTPretestedOut == (document.topicsCount - 1))
							{
								tempTPretestOutArr[document.topicsCount - 1] = 1;
								tempTPretestOutArr2[document.topicsCount - 1] = 1;
							}
							/* test out: assign the status of what topics have been tested out of */
							/* if there are no topics with question banks that are tested out of then use first array so that the full course must be taken */
							if (tempTPretestOutArr.toString().indexOf('1') == -1)
							{
								document.topicsPretestedOut = tempTPretestOutArr.join('');
							}
							/* if there is at least one topic with a question bank that is tested out of but not all then use second array so that only the topics with question banks not tested out of and the topics without question banks which are required to be viewed must be taken, or not taken if the learner has pre-tested out */
							else
							{
								document.topicsPretestedOut = tempTPretestOutArr2.join('');
							}					
							recordPercentComplete(1, document.subsectionCount, false);						
							percentage_score = Math.round((document.test_score / totalQues)*100);
						}				
						else {									
							/* test out: if there is a pre-test in the course and the test has not yet been passed in a previous session */
							if (testScore < document.assessPassmark)
							{								
								/* test out: obtain the status of what topics have been tested out of */
								var tempTPretestOutArr = document.topicsPretestedOut.split('');				
								for (var i = 0; i < document.topicsCount; i++)
								{
									if ((document.assessTopicHasQBank[i] == "1") && (tempTPretestOutArr[i] == "1"))
									{
										document.test_score = document.test_score + Number(document.assessSelectQuesArr[i]);
									}
								}						
								percentage_score = Math.round((document.test_score / totalQues)*100);
								if (percentage_score > 100)
								{
									percentage_score = 100;
								}
							}
							/* test out: if the test has been passed in a previous session */
							else if (testScore >= document.assessPassmark)
							{
								percentage_score = testScore;
							}
						}	
					}
					else
					{
						percentage_score = Math.round((document.test_score / Number(document.assessRandomQuesArr.length - 1))*100);
					}
					document.assessPercentageScore = percentage_score;				
					var assessResultsSec = document.assessRandomQuesArr[document.assessRandomQuesArr.length - 1];
					/* test out: if there is a pre-test in the course and it is being taken */
					if ((document.pretestPresent == 1) && document.takingPretest)
					{	
						/* completed test message and test lock-out 2023 */
						document.pretestThisSession = true;
						$('#sec_' + assessResultsSec + ' .assessTitle').html(test_results_dat['pre_test'][0].result_title);
						/* if all topics that have a question bank have been tested out of and there are no topics (besides summary) that do not have a question bank and are required to be viewed */
						if((percentage_score>=document.preTestPassmark) && (document.assessTopicHasQBank.toString().indexOf("2") == -1))
						{
							results_content += '<p class="lgTitleSubText">' + test_results_dat['pre_test'][0].pass_msg + '</p>';
							/* completed test message and test lock-out 2023 */
							if (document.noTopicsAssociatedPretest)
							{
								document.topicsPretestedOut = "";
								for (var z = 0; z < document.topicsCount; z++)
								{
									document.topicsPretestedOut += "1";
								}
							}
							else
							{
								/* test out: ensure the test results is marked as viewed */
								/* 20230427 different pre/post test banks */
								if(document.diffPrePostTest){
									/* 20240319 pre-test that appears after first topic */
									if (document.preTestAfterFirstTopic)
									{
										document.topicsPretestedOut = document.topicsPretestedOut.substring(0,document.topicsCount-1) + "1";
									}
									else {
										document.topicsPretestedOut = document.topicsPretestedOut.substring(0,document.topicsCount-1) + "0";
									}	
								}else{
									document.topicsPretestedOut = document.topicsPretestedOut.substring(0,document.topicsCount-1) + "1";
								}
							}
							/* client testing requirements 2024: */
							/* 80% pass for course-level (no topics associated) pre-test */
							if (document.takingPretest) {
								$('#right_nav').hide();
								$('#left_nav').hide();
								$('#right_nav').removeClass('locked');
								$('#home_nav').addClass("pretest");
							}
							
							/* client testing requirements 2024: */
							/* 80% pass for course-level (no topics associated) pre-test */
							if((document.preTestPassmark < 80) && !document.noTopicsAssociatedPretest) {
								topicsTestedOut = "";
								topicsTestedOut += '<p class="lgTitleSubText">'+test_results_dat['pre_test'][0].pass_msg_4+'</p><br>';
							   for (var j = 0; j < (tempTPretestOutArr.length - 1); j++)
								{
									if (j == 0)
									{
										//topicsTestedOut += "<br>";
									}
									
									
									/* if a topic has a question bank and is not tested out of or a topic does not have a question bank but is required to be viewed or is the summary */
									if (((tempTPretestOutArr[j] == 0) && ((document.assessTopicHasQBank[j] != "0"))) || (j == (tempTPretestOutArr.length - 1)))
									{
										/* if all topics that have a question bank have been tested out of and this topic does not have a question bank but is required to be viewed */
										if((percentage_score>=document.preTestPassmark) && (document.assessTopicHasQBank[j] == "3"))
										{
											/* include a tick beside the topic in the list in the results */
											topicsTestedOut += '<div class=\'pretest_topic_passed\'>' + document.topicTitles['titles'][j].title + '</div><br>';
										}
										else {									
											/* do not include a tick beside the topic in list in the results */
											topicsTestedOut += '<div class=\'pretest_topic_passed pretest_topic_blank\'>' + document.topicTitles['titles'][j].title + '</div><br>';
										}	
									}							
									/* if a topic has a question bank and is tested out of or a topic does not have a question bank and is not required to be viewed and is not the summary */
									else if ((tempTPretestOutArr[j] == 1) || ((document.assessTopicHasQBank[j] == "0") && (j != (tempTPretestOutArr.length - 1))))
									{
										/* 20240319 pre-test that appears after first topic */
										if (document.preTestAfterFirstTopic) {
											/* do not include the first topic in the list of tested out topics */
											if (j > 0)
											{
												/* include a tick beside the topic in the list in the results */
												topicsTestedOut += '<div class=\'pretest_topic_passed\'>' + document.topicTitles['titles'][j].title + '</div><br>';
											}
										}
										else {
											/* include a tick beside the topic in the list in the results */
											topicsTestedOut += '<div class=\'pretest_topic_passed\'>' + document.topicTitles['titles'][j].title + '</div><br>';
										}										
									}
								}
								results_content += topicsTestedOut;
						    }
							else
							{
								/* completed test message and test lock-out 2023 */
								if (document.showAssessCompleteMsg)
								{
									document.trackingArr[document.trackingArr.length-1] = '1';
								}
							}
                            
						}
						else {
							/* pre-test no topics associated with questions support kgs 03/18/22 */
							if (document.pretestAnsIncorrect)
							{	
								/* client testing requirements 2024: */
								/* must answer all questions in course-level (no topics associated) pre-test */
								/* Review Content button at the end of the passed and failed course-level (no topics assoicated) pre-test and post-test that will take the learner to the Home page menu */
								//$('#home_assess_btn_div_' + assessResultsSec).show();
								/* 20240130 accessibility 2024 */
								//$('.results_review_text').hide();
								/* client testing requirements 2024: */
								/* if enough questions are answered incorrectly that the learner can no longer pass the pre-test then show the pre-test results */
								// document.pretestAnsIncorrect = false;
							}
							/* show resources and switch language when fail pre-test 100824 */
							else {
								if (document.showResourcesButton && !document.hideResourcesButtonDisclaimer) {
									$('.bar_robot .page').css('visibility','visible');
									$('.bar_robot .page').css('display','block');
								}
								if(document.isMultiSco){
									$('.bar_robot .switchLang').css('visibility','visible');
									$('.bar_robot .switchLang').css('display','block');
								}
							}
							var topicsTestedOut = "";
							for (var j = 0; j < (tempTPretestOutArr.length - 1); j++)
							{
								if (j == 0)
								{
									topicsTestedOut += "<br>";
								}
								/* if a topic has a question bank and is not tested out of or a topic does not have a question bank but is required to be viewed or is the summary */
								if (((tempTPretestOutArr[j] == 0) && ((document.assessTopicHasQBank[j] != "0"))) || (j == (tempTPretestOutArr.length - 1)))
								{
									/* if all topics that have a question bank have been tested out of and this topic does not have a question bank but is required to be viewed */
									if((percentage_score>=document.preTestPassmark) && (document.assessTopicHasQBank[j] == "3"))
									{
										/* include a tick beside the topic in the list in the results */
										topicsTestedOut += '<div class=\'pretest_topic_passed\'>' + document.topicTitles['titles'][j].title + '</div><br>';
									}
									else {									
										/* do not include a tick beside the topic in list in the results */
										topicsTestedOut += '<div class=\'pretest_topic_passed pretest_topic_blank\'>' + document.topicTitles['titles'][j].title + '</div><br>';
									}	
								}							
								/* if a topic has a question bank and is tested out of or a topic does not have a question bank and is not required to be viewed and is not the summary */
								else if ((tempTPretestOutArr[j] == 1) || ((document.assessTopicHasQBank[j] == "0") && (j != (tempTPretestOutArr.length - 1))))
								{
									/* 20240319 pre-test that appears after first topic */
									if (document.preTestAfterFirstTopic) {
										/* do not include the first topic in the list of tested out topics */
										if (j > 0)
										{
											/* include a tick beside the topic in the list in the results */
											topicsTestedOut += '<div class=\'pretest_topic_passed\'>' + document.topicTitles['titles'][j].title + '</div><br>';
										}
									}
									else {
										/* include a tick beside the topic in the list in the results */
										topicsTestedOut += '<div class=\'pretest_topic_passed\'>' + document.topicTitles['titles'][j].title + '</div><br>';
									}
								}
							}
							/* if all topics that have a question bank have been tested out of and there are topics (besides summary) that do not have a question bank and are required to be viewed then the learner must complete those topics and the summary but not the post-test to complete the course */
							if ((percentage_score>=document.preTestPassmark) && (document.assessTopicHasQBank.toString().indexOf("2") != -1))
							{
								/* test out: ensure the test results are not marked as viewed */
								/* 20230427 different pre/post test banks */
								if(document.diffPrePostTest){
									document.topicsPretestedOut = document.topicsPretestedOut.substring(0,document.topicsCount-1) + "0";
								}else{
									document.topicsPretestedOut = document.topicsPretestedOut.substring(0,document.topicsCount-1) + "1";								
								}
								results_content += '<p class="lgTitleSubText">' + test_results_dat['pre_test'][0].pass_msg_2 + '</p>' + topicsTestedOut + '<p class="lgTitleSubText">' + test_results_dat['pre_test'][0].pass_msg_3 + '</p>';
							}
							/* if there are no topics with question banks that are tested out of then the learner must take the full course to complete the course */
							else if (tempTPretestOutArr.toString().indexOf("1") == -1)
							{
								/* test out: ensure the test results are not marked as viewed */
								document.topicsPretestedOut = document.topicsPretestedOut.substring(0,document.topicsCount-1) + "0";								
								results_content += '<p class="lgTitleSubText">' + test_results_dat['pre_test'][0].fail_msg_3 + '</p>';
							}
							/* if there is at least one topic with a question bank that is tested out then the learner must take the topics not tested out of, topics that do not have a question bank and are required to be viewed, the summary and if not all topics are tested out of then the post-test to complete the course */
							else
							{
								/* test out: ensure the test results are not marked as viewed */
								document.topicsPretestedOut = document.topicsPretestedOut.substring(0,document.topicsCount-1) + "0";
								results_content += '<p class="lgTitleSubText">' + test_results_dat['pre_test'][0].fail_msg_1 + '</p>' + topicsTestedOut + '<p class="lgTitleSubText">' + test_results_dat['pre_test'][0].fail_msg_2 + '</p>';
							}
							/* client testing requirements 2024: */
							/* 80% pass for course-level (no topics associated) pre-test */							
							if (document.takingPretest) {
								$('#right_nav').hide();
								$('#left_nav').hide();
								$('#home_nav').addClass("pretest");
							}
						}					
						$('#retake_assess_btn_div_' + assessResultsSec).hide();	
						/* pre-test no topics associated with questions support kgs 03/18/22 */
						/* client testing requirements 2024: */
						/* 80% pass for course-level (no topics associated) pre-test */
						/* if (document.noTopicsAssociatedPretest)
						{ */
							/* show resources and switch language when fail pre-test 100824 */
							/*if (document.showResourcesButton && !document.hideResourcesButtonDisclaimer) {
								$('.bar_robot .page').css('visibility','visible');
								$('.bar_robot .page').css('display','block');
							}
							if(document.isMultiSco){
								$('.bar_robot .switchLang').css('visibility','visible');
								$('.bar_robot .switchLang').css('display','block');
							}*/	
						/* } */
					}
					else {
						if(typeof(LMSAPI)!="undefined"){
							if(useAICCRules!=true && commitTimer!=true){
								actionsLMSCommit();
							}
							checkCourseCompletion();	
						}
						var percentSymbol = '%';
						/* space before percentage for specific languages fix 2019 */
						if ((document.selectedLang == 'fr') || (document.selectedLang == 'de'))
						{
							percentSymbol = '&nbsp;' + percentSymbol;
						}
						$('#sec_' + assessResultsSec + ' .assessTitle').html(test_results_dat['post_test'][0].result_title);
						results_content = '<p>' + test_results_dat['post_test'][0].generic_msg + '</p><p class="user_score">' + percentage_score + '<span class="percent_sym">' +percentSymbol + '</span></p>';
						if(percentage_score>=document.assessPassmark)
						{
							results_content += '<p class="lgTitleSubText">' + test_results_dat['post_test'][0].pass_msg + '</p>';
							$('#retake_assess_btn_div_' + assessResultsSec).hide();
                            $('#retake_course_btn_div_' + assessResultsSec).hide();
							/* remove home button on passed post-test results 2023 */
							/* client testing requirements 2024: */
							/* Review Content button at the end of the passed and failed course-level (no topics assoicated) pre-test and post-test that will take the learner to the Home page menu */
							/* $('#home_assess_btn_div_' + assessResultsSec).hide(); */
							/* post-test review incorrect questions for passed post-test support 061422 */
							if (document.showAssessResultsReview)
							{
								for(i in post_test_ques_dat) {

									if (post_test_ques_dat[i][0].correct == '0')
									{
										if (post_test_ques_dat[i][0].answered == '1'){	
											var quesStem = $('#' + i + ' .testQuesStem').html();
											var quesFeedback = $('#feedback_corr_' + i.split('_')[1] + ' .feedback_text').html();									
											var quesType = '';
											var quesOptions = '';
											var tempArr = [];
											if (post_test_ques_dat[i][0].type == 'mcsa') { quesType = 'squaredBox squaredBoxMCSA'; }
											else if (post_test_ques_dat[i][0].type == 'mcma') { quesType = 'squaredBox'; }	
											$("#" + i + " .mc_btn").each(function() {
												var optNum = $(this).parent().attr('id').split('_')[2] - 1;
												var answerIcon = '';
												if (post_test_ques_dat[i][0].type == 'mcsa')
												{
													/* 20240130 accessibility 2024 */
													if (post_test_ques_dat[i][0].ans.split(',')[optNum] == '1') { answerIcon = "<img src='images/general_int/answer_correct.png' alt='" + localiseString('test_correct_option') + "'>";}
													/* 20240130 accessibility 2024 */
													else if (post_test_ques_dat[i][0].user_ans.split(',')[optNum] == '1') { answerIcon = "<img src='images/general_int/answer_incorrect.png' alt='" + localiseString('test_incorrect_option') + "'>";}
												}
												else if (post_test_ques_dat[i][0].type == 'mcma')
												{
													/* 20240130 accessibility 2024 */
													if (post_test_ques_dat[i][0].ans.split(',')[optNum] == '1') { answerIcon = "<img src='images/general_int/answer_correct.png' alt='" + localiseString('test_correct_option') + "'>";}
													/* 20240130 accessibility 2024 */
													else { answerIcon = "<img src='images/general_int/answer_incorrect.png' alt='" + localiseString('test_incorrect_option') + "'>";}
												}
												
												//console.log("optNum = " + optNum)
												
												//tempArr.push("<tr><td><div class='" + quesType + " results_review_ques_type'>&nbsp;</div></td><td class='results_review_ques_opt'>" + $(this).html() + "</td><td>" + answerIcon + "</td></tr>");
												quesOptions += "<tr><td><div class='" + quesType + " results_review_ques_type'>&nbsp;</div></td><td class='results_review_ques_opt'>" + $(this).html() + "</td><td>" + answerIcon + "</td></tr>";
											});
											
											
											
											
											results_review_content += "<div class='results_review_ques_break'>&nbsp;</div><p><strong>" + test_results_dat['post_test'][0].result_review_msg_1 + "</strong></p><p>" + quesStem + "</p><p><strong>" + test_results_dat['post_test'][0].result_review_msg_2 + "</strong><br><table>" + quesOptions + "</table><p><strong>" + test_results_dat['post_test'][0].result_review_msg_3 + "</strong><br>" + quesFeedback + "</p>";
										}
									}								
								}
								if (results_review_content != "")
								{
									results_content += '<p class="lgTitleSubText">' + test_results_dat['post_test'][0].pass_review_msg + '</p>';
								}
							}	
						}
						else
						{
                            /* 20190102 Increment post-test attempts */
                            document.assessAttempts++
                            if(document.assessAttempts != document.maxAssessAttempts){
                                results_content += '<p class="lgTitleSubText">' + test_results_dat['post_test'][0].fail_msg + '</p>';
                                $('#retake_assess_btn_div_' + assessResultsSec).show();
                                $('#retake_course_btn_div_' + assessResultsSec).hide();
								/* pre-test no topics associated with questions support kgs 03/18/22 */
								if (document.noTopicsAssociatedPretest)
								{
									$('#home_assess_btn_div_' + assessResultsSec).hide();
								}	
                            }else{
                                /* 20190102 Failed post-test the max number of times so show re-start button and text */
                                results_content += '<p class="lgTitleSubText">' + test_results_dat['post_test'][0].fail_max_msg + '</p>';
                                $('#retake_course_btn_div_' + assessResultsSec).show();
                                $('#retake_assess_btn_div_' + assessResultsSec).hide();
								/* pre-test no topics associated with questions support kgs 03/18/22 */
								if (document.noTopicsAssociatedPretest)
								{
									$('#home_assess_btn_div_' + assessResultsSec).hide();
								}	
                                $('.topic_nav_button').css('visibility','hidden');
                                
                                //resetCourse(); // 20190205 moved to lock.js
 
                            }
						}
					}				
					$('#sec_' + assessResultsSec + ' .result_left .content_text').html(results_content);
					/* show burger menu button on post-test results 101124 */
					if (!document.takingPretest)
					{
						$('.bar_robot .home').css('visibility','visible');
						$('.bar_robot .home').css('display','block');
					}
					/* client testing requirements 2024: */
					/* Review Content button at the end of the passed and failed course-level (no topics assoicated) pre-test and post-test that will take the learner to the Home page menu */					
					if(document.takingPretest || (document.assessAttempts != document.maxAssessAttempts) || (document.maxAssessAttempts == 0))
					{
						$('#home_assess_btn_div_' + assessResultsSec).show();
					}	
					if ($('.results_review_text').html() == '')
					{
						$('.results_review_text').hide();
					}	
					//$('#sec_' + assessResultsSec + ' .result_right .content_text').html(score_content);
					/* post-test review incorrect questions for passed post-test support 061422 */
					if (!document.takingPretest && document.showAssessResultsReview)
					{
						/* 20221020 ensure assessment results review content is hidden so it is not part of tab order when empty */
						if (results_review_content != "")
						{	
							$('#sec_' + assessResultsSec + ' .result_left .results_review_text').html(results_review_content);
							$('#sec_' + assessResultsSec + ' .result_left .results_review_text').css('display','block');
							/* 20240130 accessibility 2024 */
							$('#sec_' + assessResultsSec + ' .result_left .results_review_text .results_review_ques_break').attr('aria-hidden', true);
							$('#sec_' + assessResultsSec + ' .result_left .results_review_text .results_review_ques_type').attr('aria-hidden', true);
						}
						else
						{
							$('#sec_' + assessResultsSec + ' .result_left .results_review_text').css('display','none');
						}	
					}				
				}
			}
			
			/* 20240319 pre-test that appears after first topic */
			/* test out: if there is a pre-test in the course and it is being taken */
			if ((document.pretestPresent == 1) && document.takingPretest)
			{	
				/* client testing requirements 2024: */
				/* show immediate feedback for course-level (no topics associated) pre-test */
				/* separate correct feedback for each option on mcsa questions 20220629 */
				if(diffFB){
					
					if(secQType == "mcsa"){
					
						$("#feedback_corr_" + secNum).hide();
						$("#feedback_incorr_" + secNum).hide();
						$("#feedback_tryagain_" + secNum).hide();
						$("#feedback_partial" + secNum).hide();
						
						/* client testing requirements 2024: */
						/* show immediate feedback for course-level (no topics associated) pre-test */	
						$("#feedback_immediate_corr_" + secNum).hide();
						$("#feedback_immediate_incorr_" + secNum).hide();
						$("#feedback_immediate_partial_" + secNum).hide();

						for(var i = 0; i!= userAnsArray.length; i++){
							if(Number(userAnsArray[i]) == 1){
								//$("#feedback_corr_" + secNum).show(); // 20221128 fix for different option feedback with assessment review 
								if(document.useTransitions){
									/* transitions: fade in question feedback */
									$("#fb_"+secNum+"_" + (i+1)).fadeIn();
									/* 20240130 accessibility 2024 */
									$("#fb_"+secNum+"_" + (i+1)).find('.feedback_start').focus();
								}else{
									$("#fb_"+secNum+"_" + (i+1)).show();
									/* 20240130 accessibility 2024 */
									$("#fb_"+secNum+"_" + (i+1)).find('.feedback_start').focus();
								}
							}

						}
					}
				}
			}
			else {
				/* separate correct feedback for each option on mcsa questions 20220629 */
				if(diffFB){
					
					if(secQType == "mcsa"){
					
						$("#feedback_corr_" + secNum).hide();
						$("#feedback_incorr_" + secNum).hide();
						$("#feedback_tryagain_" + secNum).hide();
						$("#feedback_partial" + secNum).hide();
						
						/* client testing requirements 2024: */
						/* show immediate feedback for course-level (no topics associated) pre-test */	
						$("#feedback_immediate_corr_" + secNum).hide();
						$("#feedback_immediate_incorr_" + secNum).hide();
						$("#feedback_immediate_partial_" + secNum).hide();

						for(var i = 0; i!= userAnsArray.length; i++){
							if(Number(userAnsArray[i]) == 1){
								//$("#feedback_corr_" + secNum).show(); // 20221128 fix for different option feedback with assessment review 
								if(document.useTransitions){
									/* transitions: fade in question feedback */
									$("#fb_"+secNum+"_" + (i+1)).fadeIn();
									/* 20240130 accessibility 2024 */
									$("#fb_"+secNum+"_" + (i+1)).find('.feedback_start').focus();
								}else{
									$("#fb_"+secNum+"_" + (i+1)).show();
									/* 20240130 accessibility 2024 */
									$("#fb_"+secNum+"_" + (i+1)).find('.feedback_start').focus();
								}
							}

						}
					}
				}
			}			
			
			if (document.inlineQuesTryAgain && !inlineCorrect)
			{
				/* do nothing */
			}
			else
			{
				var secNum = secNum
				var questionDone = 0;
				var clicked = 0;
					if(Number($('#sec_'+secNum+' .submit_btn').attr('data')) == 0){ 
						$('#sec_'+secNum+' .submit_btn').attr('data',1);
					}
					var data = Number($('#sec_'+secNum+' .submit_btn').attr('data'));
					if(data === Number(1)){
						questionDone++;
						clicked = Number($('#sec_'+secNum).attr('data-clicked'));
						clicked +=1;
						$('#sec_'+secNum).attr('data-clicked',clicked);	
						$('#sec_'+secNum+' .submit_btn').attr('data','2');
					}
				
				
				prepareInteractions(secNum, userAnsArray, document.answeredCorrect, cNum); // section topic test-out collate the question data for reporting of interactions
				
				/* allow showing of ticks and/or feedback in post-test to be configurable 060722 */
				if ((secTest == "_i") || ((secTest == "_t") && document.showAssessTicks))
				{
					if(document.textDirection == "rtl"){
						$(".mc_btn_correct").addClass("mc_btn_correct_RTL");
						$(".mc_btn_incorrect").addClass("mc_btn_incorrect_RTL");
					}
				}	
					
				/* mark question as complete */
				var totalClicked = Number($('#sec_'+secNum).attr('data-clicked'))// + Number($('#sec_'+secNum).attr('data-links')) + Number($('#sec_'+secNum).attr('data-hotwords'));
				var totalClicks = Number(document.clickArr[Number(secNum) - 1])// + Number(document.linkArr[Number(secNum) - 1]) + Number(document.hotArr[Number(secNum) - 1])
				if(totalClicked == totalClicks){			
					if(isAndroidTablet|| isAndroidPhone){
						document.intComplete = true;
						//20190917 desktop portrait fix
            			document.audioComplete = true;
						
							isPageComplete(secNum);
							var nextSec = parseInt(secNum)+1;
							if (secTest == "_t")
							{
								var tCurrQues = $("#sec_" + secNum + " .testQuesLabel").html().split(" ")[1];
								nextSec = document.assessRandomQuesArr[tCurrQues];	
							}
							if(($('#sec_'+nextSec).is(':visible') || !$('#right_nav').hasClass('locked')) && document.courseLockedDown == true){
								clearInterval(document.lockinterval)
							} 
					}else{
						//20190917 desktop portrait fix
            			document.audioComplete = true;
						document.intComplete = true;
						//20190917 desktop portrait fix
            
						isPageComplete(secNum);
					}
					
					if(document.inlineQuesMaxAttempts > 0){
						document.inlineQuesTryAgain = true;
						document.inlineNumOfAttempts = 0;
					}
				}

				if(isAndroidTablet || isAndroidPhone || isMacChrome){
					$('html,body').scrollTop(windowTop -1)			
				}
			}	
		}
	}	
}

/* reset an inline question for try again */
function resetInlineQues(secNum,tNum) {
	var secId = "sec_" + secNum;
	var numOfOptions = $("#" + secId + " .qItems .qItem").length / 2;
	var secTest = "_i";
	var secQType1 = "_mcsa";
	var secQType2 = "_mcma";	
	for (var x=1; x < (numOfOptions + 1); x++) {
		/* change the background of all items to have no highlight */		
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType1).find(".squaredBox").removeClass().addClass("squaredBox").addClass("squaredBoxMCSA").addClass("squaredBox_bg_" + tNum).addClass("alignCheckBox");
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType1).removeClass("mcma_hl_pretest");			
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType1).removeClass("mcma_hl_pretest");
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType1).find(".squaredBox label").removeClass("mcma_hl_pretest");			
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType1).find(".squaredBox label").removeClass("mcma_hl_pretest");
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType2).find(".squaredBox").removeClass().addClass("squaredBox").addClass("squaredBox_bg_" + tNum).addClass("alignCheckBox");
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType2).removeClass("mcma_hl_pretest");			
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType2).removeClass("mcma_hl_pretest");
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType2).find(".squaredBox label").removeClass("mcma_hl_pretest");			
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType2).find(".squaredBox label").removeClass("mcma_hl_pretest");
        
        //LJ Tick Cross Funcitonality
        /*$("#opt_"+ secNum + "_" + x + "_1_" + secTest + "_" + secQType1 + " .mc_btn").removeClass("mc_btn_incorrect");
        $("#opt_"+ secNum + "_" + x + "_1_" + secTest + "_" + secQType1 + " .mc_btn").removeClass("mc_btn_correct");
        $("#opt_"+ secNum + "_" + x + "_1_" + secTest + "_" + secQType2 + " .mc_btn").removeClass("mc_btn_incorrect");
        $("#opt_"+ secNum + "_" + x + "_1_" + secTest + "_" + secQType2 + " .mc_btn").removeClass("mc_btn_correct");*/
		
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + "_" + secQType1).removeClass("mc_btn_incorrect");
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + "_" + secQType2).removeClass("mc_btn_incorrect");
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + "_" + secQType1).removeClass("mc_btn_correct");
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + "_" + secQType2).removeClass("mc_btn_correct");
        
        /*$("#opt_"+ secNum + "_" + x + "_1_" + secTest + "_" + secQType1 + " .mc_btn").css("background-image","");
        $("#opt_"+ secNum + "_" + x + "_1_" + secTest + "_" + secQType2 + " .mc_btn").css("background-image","");*/
        
        //LJ Tick Cross Funcitonality
        
		/* enable options */
		$('#rb_'+ secNum + "_" + x).prop('checked', false);
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType1).css("cursor","pointer");
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType2).css("cursor","pointer");
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType1 + " .button").css("cursor","pointer");
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType2 + " .button").css("cursor","pointer");
		
		/* 2022 Accessibility Update */
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType1).attr("aria-checked", false);
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType2).attr("aria-checked", false);
		
		$("#feedback_tryagain_" + secNum).hide();		
		$("#" + secId + ' input[type=checkbox]').attr('disabled', false);
		$("#" + secId + " .squaredBox label").css("cursor","pointer");
		$("#" + secId + " .qItem").css("cursor","pointer");
		/* show submit */
		$("#submit_btn_" + secNum).html(localiseString('submit_btn'));
		$("#submit_btn_" + secNum).attr('title',localiseString('submit_btn_locked'));
		$("#submit_btn_" + secNum).attr('alt',localiseString('submit_btn_locked'));
		/* clear user answer */
		var userAns = inline_ques_dat[secId][0].user_ans;
		userAns = userAns.replace('1','0');
		inline_ques_dat[secId][0].user_ans = userAns;
	}
	reSetupClickableOptionsInlineQues(secId);
}

// reset inline questions after failing assessment 3 times
function resetInQues(secNum,tNum) {
	var secId = "sec_" + secNum;
	var numOfOptions = $("#" + secId + " .qItems .qItem").length / 2;
	var secTest = "_i";
	var secQType1 = "_mcsa";
	var secQType2 = "_mcma";	
	for (var x=1; x < (numOfOptions + 1); x++) {
		/* change the background of all items to have no highlight */		
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType1).find(".squaredBox").removeClass().addClass("squaredBox").addClass("squaredBoxMCSA").addClass("squaredBox_bg_" + tNum).addClass("alignCheckBox");
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType1).removeClass("mcma_hl_pretest");			
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType1).removeClass("mcma_hl_pretest");
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType1).find(".squaredBox label").removeClass("mcma_hl_pretest");			
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType1).find(".squaredBox label").removeClass("mcma_hl_pretest");
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType1).removeClass("mcma_hl_corr");			
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType1).removeClass("mcma_hl_corr");
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType1).find(".squaredBox label").removeClass("mcma_hl_corr");			
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType1).find(".squaredBox label").removeClass("mcma_hl_corr");
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType1).removeClass("mcma_hl_incorr");			
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType1).removeClass("mcma_hl_incorr");
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType1).find(".squaredBox label").removeClass("mcma_hl_incorr");			
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType1).find(".squaredBox label").removeClass("mcma_hl_incorr");
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType2).find(".squaredBox").removeClass().addClass("squaredBox").addClass("squaredBox_bg_" + tNum).addClass("alignCheckBox");
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType2).removeClass("mcma_hl_pretest");			
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType2).removeClass("mcma_hl_pretest");
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType2).find(".squaredBox label").removeClass("mcma_hl_pretest");			
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType2).find(".squaredBox label").removeClass("mcma_hl_pretest");
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType2).removeClass("mcma_hl_corr");			
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType2).removeClass("mcma_hl_corr");
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType2).find(".squaredBox label").removeClass("mcma_hl_corr");			
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType2).find(".squaredBox label").removeClass("mcma_hl_corr");
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType2).removeClass("mcma_hl_incorr");			
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType2).removeClass("mcma_hl_incorr");
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType2).find(".squaredBox label").removeClass("mcma_hl_incorr");			
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType2).find(".squaredBox label").removeClass("mcma_hl_incorr");
        
		/* enable options */
		$('#rb_'+ secNum + "_" + x).prop('checked', false);
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType1).css("cursor","pointer");
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType2).css("cursor","pointer");
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType1 + " .button").css("cursor","pointer");
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType2 + " .button").css("cursor","pointer");
		
		/* 2022 Accessibility Update */
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType1).attr("aria-checked", false);
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType2).attr("aria-checked", false);
		
		$("#feedback_tryagain_" + secNum).hide();		
		$("#" + secId + ' input[type=checkbox]').attr('disabled', false);
		$("#" + secId + " .squaredBox label").css("cursor","pointer");
		$("#" + secId + " .qItem").css("cursor","pointer");
		/* show submit */
		$("#submit_btn_" + secNum).html(localiseString('submit_btn'));
		$("#submit_btn_" + secNum).attr('title',localiseString('submit_btn_locked'));
		$("#submit_btn_" + secNum).attr('alt',localiseString('submit_btn_locked'));
		$("#submit_btn_" + secNum).css('display','block');
        $("#submit_btn_" + secNum).css('width','168px');
		
		$("#feedback_corr_" + secNum).css('display','none');
		$("#feedback_partial_" + secNum).css('display','none');
		$("#feedback_incorr_" + secNum).css('display','none');
		
		
		
		
		/* clear user answer */
		var userAns = inline_ques_dat[secId][0].user_ans;
		userAns = userAns.replace('1','0');
		inline_ques_dat[secId][0].user_ans = userAns;
        
        //LJ Tick Cross Funcitonality
        //$("#opt_"+ secNum + "_" + x + "_1_" + secTest + "_" + secQType1).find(".mc_btn").removeClass("mc_btn_incorrect");			
        //$("#opt_"+ secNum + "_" + x + "_1_" + secTest + "_" + secQType2).find(".mc_btn").removeClass("mc_btn_correct");
        /*$(".mc_btn").removeClass("mc_btn_correct");
        $(".mc_btn").removeClass("mc_btn_incorrect");*/
        //LJ Tick Cross Funcitonality
        
	}
	reSetupClickableOptionsInlineQues(secId);
}





/* reset a test question */
function resetTestQues(secNum) {
	var secId = "sec_" + secNum;
	var numOfOptions = $("#" + secId + " .qItems .qItem").length / 2;
	var secTest = "_t";
	var secQType1 = "_mcsa";
	var secQType2 = "_mcma";
	for (var x=1; x < (numOfOptions + 1); x++) {
		/* change the background of all items to have no highlight */		
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType1).removeClass("mcma_hl_incorr");
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType1).removeClass("mcma_hl_corr");
        $("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType1).removeClass("mcma_hl_pretest");
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType1).removeClass("mcma_hl_incorr");
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType1).removeClass("mcma_hl_corr");
        $("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType1).removeClass("mcma_hl_pretest");
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType1).find(".squaredBox label").removeClass("mcma_hl_incorr");
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType1).find(".squaredBox label").removeClass("mcma_hl_corr");
        $("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType1).find(".squaredBox label").removeClass("mcma_hl_pretest");
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType1).find(".squaredBox label").removeClass("mcma_hl_incorr");
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType1).find(".squaredBox label").removeClass("mcma_hl_corr");
        $("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType1).find(".squaredBox label").removeClass("mcma_hl_pretest");
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType2).removeClass("mcma_hl_incorr");
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType2).removeClass("mcma_hl_corr");
        $("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType2).removeClass("mcma_hl_pretest");
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType2).removeClass("mcma_hl_incorr");
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType2).removeClass("mcma_hl_corr");
        $("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType2).removeClass("mcma_hl_pretest");
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType2).find(".squaredBox label").removeClass("mcma_hl_incorr");
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType2).find(".squaredBox label").removeClass("mcma_hl_corr");
        $("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType2).find(".squaredBox label").removeClass("mcma_hl_pretest");
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType2).find(".squaredBox label").removeClass("mcma_hl_incorr");
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType2).find(".squaredBox label").removeClass("mcma_hl_corr");
        $("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType2).find(".squaredBox label").removeClass("mcma_hl_pretest");
		/* test out: if there is a pre-test in the course */
		if (document.pretestPresent == 1)
		{
			$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType1).removeClass("mcma_hl_pretest");			
			$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType1).removeClass("mcma_hl_pretest");
			$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType1).find(".squaredBox label").removeClass("mcma_hl_pretest");			
			$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType1).find(".squaredBox label").removeClass("mcma_hl_pretest");
			$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType2).removeClass("mcma_hl_pretest");			
			$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType2).removeClass("mcma_hl_pretest");
			$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType2).find(".squaredBox label").removeClass("mcma_hl_pretest");			
			$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType2).find(".squaredBox label").removeClass("mcma_hl_pretest");
		}	
                
		/* enable options */
		$('#rb_'+ secNum + "_" + x).prop('checked', false);
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType1).css("cursor","pointer");
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType2).css("cursor","pointer");
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType1 + " .button").css("cursor","pointer");
		$("#opt_"+ secNum + "_" + x + "_1" + secTest + secQType2 + " .button").css("cursor","pointer");
		
		/* 2022 Accessibility Update */
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType1).attr("aria-checked", false);
		$("#opt_"+ secNum + "_" + x + "_0" + secTest + secQType2).attr("aria-checked", false);
		
		$("#feedback_corr_" + secNum).hide();
		$("#feedback_incorr_" + secNum).hide();
		$("#feedback_partial_" + secNum).hide();
		$("#feedback_immediate_corr_" + secNum).hide(); // 20220720
		$("#feedback_immediate_incorr_" + secNum).hide(); // 20220720
		$("#feedback_immediate_partial_" + secNum).hide(); // 20220720
		$("#" + secId + ' input[type=checkbox]').attr('disabled', false);
		$("#" + secId + " .squaredBox label").css("cursor","pointer");
		$("#" + secId + " .qItem").css("cursor","pointer");
		/* show submit */
		$("#submit_btn_" + secNum).show();
		/* 20220704 Accessibility Update */
		$("#submit_btn_" + secNum).attr('title',localiseString('submit_btn_locked'));
		$("#submit_btn_" + secNum).attr('alt',localiseString('submit_btn_locked'));
		/* clear user answer */
		var userAns = post_test_ques_dat[secId][0].user_ans;
		userAns = userAns.replace('1','0');
		post_test_ques_dat[secId][0].user_ans = userAns;
		/* post-test review incorrect questions for passed post-test support 061422 */
		if (document.showAssessResultsReview)
		{
			post_test_ques_dat[secId][0].correct = '0';
		}        
		post_test_ques_dat[secId][0].answered = '0'
        //LJ Tick Cross Funcitonality
        /*$("#opt_"+ secNum + "_" + x + "_1_" + secTest + "_" + secQType1).find(".mc_btn").removeClass("mc_btn_incorrect");			
        $("#opt_"+ secNum + "_" + x + "_1_" + secTest + "_" + secQType2).find(".mc_btn").removeClass("mc_btn_correct");*/
        /*$(".mc_btn").removeClass("mc_btn_correct");
        $(".mc_btn").removeClass("mc_btn_incorrect");*/
		$(".qItem").removeClass("mc_btn_incorrect");
		$(".qItem").removeClass("mc_btn_correct");
        //LJ Tick Cross Funcitonality
	}
}

function getCheckHeights(){
	if($('#checkHeight').length < 1){
	var clone = $('.mc_btn').eq(0).closest('.row').clone().attr('id', 'checkHeight');
	$('body').append(clone);
	
	$('#checkHeight .mc_btn').html('The');
	
	$('#checkHeight .mc_btn').addClass('centreQtext');
	
	/* 20240130 accessibility 2024 */
	$('#checkHeight .qItems .qItem').each(function(index, element) {
		$(this).attr('id',('opt_ch_' + index));
		$(this).find('input').attr('id','rb_ch_1');
		$(this).find('label').attr('for','rb_ch_1');
  	});
	$('#rb_ch_1').attr('aria-hidden', true);

	}
	checkboxText = $('#checkHeight .mc_btn').height();
	$('#checkHeight').css('opacity','0');
	checkBoxHeight = $('#checkHeight').height();
}
var parentHeight;
var breakheight;
function windowWidth(){
	var windowWidth = $(window).width();
		parentHeight = checkBoxHeight;
		breakheight = checkboxText * 2;
	if(windowWidth < 480){
		var newCheck = checkBoxHeight;
		parentHeight = newCheck;
		breakheight = checkboxText * 2;
	}
	resizeCheckBox();
}



function alignCheckBox(){
	$('.mc_btn').each(function() {
	$(this).closest('.section').show();
	if($(this).height() > checkboxText){
		$(this).parent().parent().find('.squaredBox').addClass('alignCheckBox');
	}else{
		$(this).parent().parent().find('.squaredBox').addClass('alignCheckBox');
		$(this).parent().parent().find('.mc_btn').addClass('centreQtext')
	}
	$(this).closest('.section').hide();
	});
}

function checkBoxInView(next){
	$('#sec_'+next+' .mc_btn').each(function(index) {
	var parent = $('#sec_'+next+' .mc_btn').eq(index).parent().parent();
			if(parent.height() > parentHeight){
				if(parent.find('.mc_btn').hasClass('centreQtext')){	
					parent.find('.mc_btn').removeClass('centreQtext');
				}
			}else if($('#sec_'+next+' .mc_btn').eq(index) < breakheight){
				if(!parent.find('.mc_btn').hasClass('centreQtext')){
					parent.find('.mc_btn').addClass('centreQtext');
				}
			}
	});
}

$(window).resize(function(){
	getCheckHeights()
	windowWidth()
	
})		
	
function resizeCheckBox(){
	
	if($('.screen_loader').css('display') == 'none'){
		$('.mc_btn').each(function(index) {
			var parent = $('.mc_btn').eq(index).parent().parent()
			if(parent.height() > parentHeight){
				if($('.mc_btn').eq(index).hasClass('centreQtext')){	
					$('.mc_btn').eq(index).removeClass('centreQtext');
				}
			}else if($('.mc_btn').eq(index).height() < breakheight){
			
					$('.mc_btn').eq(index).addClass('centreQtext');
				
			}
		})
	}
}
getCheckHeights()
windowWidth()
alignCheckBox()

/* show burger menu button on post-test results 101124 */
function retakeAssessmentBtn() {	
	$('.bar_robot .home').css('visibility','hidden');
	retakeAssessment();
}

/* retake assessment */
function retakeAssessment() {
    
    //document.assessAttempts++;
    
	//$('.testStartSec h1').html(test_intro_dat['post_test'][0].title);
	
	/* completed test message and test lock-out 2023 */
	var passScoreObtained = false;	
	if (document.pretestThisSession)
	{
		if (document.assessPercentageScore >= document.preTestPassmark)
		{
			passScoreObtained = true;
		}
	}
	else
	{
		if (document.assessPercentageScore >= document.assessPassmark)
		{
			passScoreObtained = true;
		}
	}
	if (passScoreObtained && document.showAssessCompleteMsg)
	{
		$('.testStartSec h2').html(test_intro_dat['post_test'][0].title);
		$('.testStart h2').html(test_intro_dat['post_test'][0].test_complete_title);
		$('.testStart .content_text').html(test_intro_dat['post_test'][0].test_complete_msg);
		$('.testQues:eq(0)').hide();
		/* show burger menu button on post-test results 101124 */
		$('.bar_robot .home').css('visibility','visible');
		$('.bar_robot .home').css('display','block');
	}
	else
	{
		$('.testStartSec h2').html(test_intro_dat['post_test'][0].title);
		$('.testStart h2').html(test_intro_dat['post_test'][0].subtitle);
		$('.testStart .content_text').html(test_intro_dat['post_test'][0].generic_msg);
	}
	/* clear assessment score */
	document.assessAttempted = false;
	document.test_score = 0;
	post_test_ques_dat['test_dat'][0].user_score = 0;
	/* clear current assessment question index */
	document.currentAssessQues = 0;
	/* go to the assessment intro */
	gotoPlace = '#sec_' + document.testIntroSubsection;
	/* test out: if there is a pre-test in the course */
	if (document.pretestPresent == 1)
	{	
		/* test out: if currently taking the pre-test mark the pre-test as no longer being taken else show the post-test */
		if (document.takingPretest) {
			document.takingPretest = false;
		}
		else {
			/* added condition for iPad iPhone scroll issue when in frameset */
			if(isiPad || isiPhone){  
				if(window.top !== window.self) {
					$(parent.parent.document).scrollTop($(gotoPlace).offset().top);
					$('.bar_robot').css('top',($(parent.parent.document).scrollTop())-1+'px');
				}else{
					$('html, body').scrollTop($(gotoPlace).offset().top);
				}
			}else{
				$('html, body').scrollTop($(gotoPlace).offset().top);
			}
		}
	}
	else {
		/* added condition for iPad iPhone scroll issue when in frameset */
		if(isiPad || isiPhone){  
			if(window.top !== window.self) {
				$(parent.parent.document).scrollTop($(gotoPlace).offset().top);
				$('.bar_robot').css('top',($(parent.parent.document).scrollTop())-1+'px');
			}else{
				$('html, body').scrollTop($(gotoPlace).offset().top);
			}
		}else{
			$('html, body').scrollTop($(gotoPlace).offset().top);
		}
	}
	/* hide and reset the questions */
	$('.testQues').not('.testQues:eq(0)').hide();
	$('.testResults').hide();	
	for (var i = document.testIntroSubsection; i < document.testResultsSubsection; i++) {
		resetTestQues(i);
		//alert('i = ' + i);		
		document.trackingArr[i-1] = 0; /* reset question tracking so it doesn't unlock on retake */
	}	
	$('.topic_nav_bar').hide();
	//$('.testStart').nextAll().find('.complete_arrow').removeClass('unlocked').show();
	var tempTestQuesDivs = "";
	for (var m = 1; m < (document.assessRandomQuesArr.length + 1); m++)
	{
		tempTestQuesDivs = tempTestQuesDivs + "<div id='testQues" + m + "'></div>";
	}	
	$("#sec_" + document.assessRandomQuesArr[0]).before(tempTestQuesDivs);
	document.randomizeAssessment();	
	var color1 = "bgColor1";
	var color2 = "bgColor2"
	if($('.testStart .background_stretch .background_stretch_bg').hasClass('bgColor1')){
		color1 = "bgColor1";
		color2 = "bgColor2"
	}else{
		color1 = "bgColor2";
		color2 = "bgColor1"
	}
	for (var j = 0; j < document.assessRandomQuesArr.length; j++) 
	{
		var secNum = document.assessRandomQuesArr[j];
		$("#testQues" + (j + 1)).replaceWith($("#sec_" + secNum));
		$("#sec_" + secNum + " .background_stretch .background_stretch_bg").removeClass("bgColor1");
		$("#sec_" + secNum + " .background_stretch .background_stretch_bg").removeClass("bgColor2");
		if ((j + 1)%2 == 0)
		{
			$("#sec_" + secNum + " .background_stretch .background_stretch_bg").addClass(color1);
		}
		else
		{
			$("#sec_" + secNum + " .background_stretch .background_stretch_bg").addClass(color2);
		}			
		$("#sec_" + secNum + " .testQuesLabel").html(localiseString('test_question') + " " + (j + 1) + " " + localiseString('test_of') + " " + document.assessTotalQues);
	}
	var assessRandQuesStr = document.assessRandomQuesArr.join(",");
	/* randomise assessment question options */
	if(document.assessOptRandomize){		
		$(".testQues .grid .container .optionHolder").not('.optionsNoRand').shuffleOptions('.qOption');
		
		setTabIndex(); // 20221710 Updated tab order when options are randomised
	}
	for (var k = (document.testIntroSubsection + 1); k <= document.testResultsSubsection; k++) 
	{
		$("#sec_"+k).css("display","none");		
	}	
	reSetupClickableOptionsTest(gotoPlace);
    
    
    /*if(document.assessAttempts == document.maxAssessAttempts){
        alert('3 attempts')
    }*/
}
$('.submit_btn').attr('data',0);

/* randomise assessment question options */
function randomizeOpts(){
	
	$('.sec_rest_wrapper').find('.testQues').each(function(index, element) {
		
		$(this).find('.grid').find('.container').find('.row').each(function(index, element) {
			
			$(this).find('.qItem').each(function(index, element) {
				$(this).parent().parent().parent().attr('class','row qOption');
            });			
        });
	});
	
	// Randomise options for section topic test-out
	$('.sec_rest_wrapper').find('.preTopicQues').each(function(index, element) {
		
		$(this).find('.grid').find('.container').find('.row').each(function(index, element) {
			
			$(this).find('.qItem').each(function(index, element) {
				$(this).parent().parent().parent().attr('class','row qOption');
            });			
        });
	});
	
	$(".testQues .grid .container .optionHolder").not('.optionsNoRand').shuffleOptions('.qOption');
	
	$(".preTopicQues .grid .container .optionHolder").not('.optionsNoRand').shuffleOptions('.qOption');
}

$.fn.shuffleOptions = function(childElem) {
	function shuffle(o) {
		for(var j, x, i = o.length; i; j = Math.floor(Math.random() * i), x = o[--i], o[i] = o[j], o[j] = x);
		return o;
	};
	return this.each(function() {
		var $this = $(this);
		var elems = $this.children(childElem);

		shuffle(elems);

		$this.detach(childElem);  

		for(var i=0; i < elems.length; i++) {
			$this.append(elems[i]);      
		}
	});    
}

if(document.assessOptRandomize){	
	randomizeOpts();
}

/* submit attestation */
function submitAttestation() {
	$('.attestation_btn_div .retake_assess_btn').hide();
	$('.attestation .content_text').html('<p class="lgTitleSubText">' + attestation_dat['attestation'][0].attested_msg + '</p>');
	$('.attestation .content_text').focus(); /* 20221125 accessibility update */
	document.attestationAttempted = true;
	markSectionComplete(document.subsectionCount);
	pageCompleted = document.subsectionCount;
	checkCourseCompletion();
}