/* variables used for course-specific text */
/* DEV NOTE indicates that the variable should be updated for the course */

$( document ).ready(function() {

	/* DEV NOTE: string for course title */
	document.courseTitle = "Markets Valuation Risk Procedures";

	/* DEV NOTE: strings for topic titles which are used in the pre-test results */
	document.topicTitles = {
		titles:[
			{title:"Welcome"},
			{title:"Valuation Methodologies"},
			{title:"Trade Booking Exceptions"},
			{title:"Product Market Model"},
			{title:"Valuation Risk Documents"},
			{title:"Unchanged Pricing Controls"},
			{title:"Collateral and Client Valuations"},
			{title:"Governance and Reporting"},
			{title:"Key Takeaways"},
			{title:"Assessment"}
		]
	}	
		
	/* DEV NOTE: string for the intro text on the pre-test message that appears asking the learner if they want to take the pre-test; if there is no pre-test make this an empty string */
	document.pretestIntro = "<p>Are you already familiar with <strong>Human Capital Risk Management?</strong></p><p>If so, this training includes an opportunity for you to demonstrate your knowledge by completing a test out. Successful completion of the test out will allow you to take an accelerated path through the training by skipping the training content to receive credit for the course.</p><p>To continue to the test out, select the Take the Test-Out button.</p><p>If you prefer to skip the test out and go straight to the content, select the Start the Course button.</p>";
	
	/* DEV NOTE: strings for text that is used on the pre-test and post-test intro pages; if there is no pre-test make the pre-test strings empty strings; if there is no post-test make the post-test strings empty strings */
	test_intro_dat = {
		pre_test:[{
			generic_msg:'<p>Welcome to the Test-Out.</p><p>To pass this assessment you will need to answer the following 10 questions and achieve a score of 80% or higher.</p><p>If you’re unable to achieve a passing score you’ll be required to review the full course content and take the assessment at the end of the course.</p><ul><li>You have <b>one attempt per question</b>.</li><li>	You must complete the Test-Out in a single attempt, if you exit the Test-Out before completion, you will not be able to resume where you left off and you will be required to review the course content.</li></ul>',
			/* DEV NOTE: string below can be used instead when there is a pre-test and there are no topics associated with test questions; otherwise delete */
			/*
			generic_msg:'<p>Welcome to the Test-Out.</p><p>If you answer each of the following 5 questions correctly, you’ll have the option to navigate to the course completion page or review the full course content to reinforce your understanding without needing to take the assessment at the end.</p><p>If you’re unable to answer all the questions correctly, you’ll be required to take the full course and successfully complete a final assessment to demonstrate your comprehension of the <strong>Human Capital Risk Management</strong> Training.</p><ul><li>You have <strong>one attempt per question</strong>.</li><li>You must complete the Test Out in a single attempt. If you exit the Test Out before completion, you will not be able to resume where you left off.</li><li>You must answer all test out questions correctly to receive credit.</li></ul>',
			*/
			title:'Test-Out',
			subtitle:'Test-Out Instructions'
			
		}],
		post_test:[{
			generic_msg:'<p>Welcome to the Final Assessment. The following 10 questions give you the opportunity to demonstrate how well you understand what you have learned.</p><p>To pass the assessment and receive credit for this course, you must achieve a minimum of 80%.</p><p>Once you begin the assessment, you must complete all questions to register a score. If you exit before completing all assessment questions, you will need to restart the assessment. </p>',
			title:'Assessment',
			subtitle:'Assessment Instructions',			
			test_complete_title:'Training Completed',
			test_complete_msg:'<p>Since you have already received a completion for this training, the final assessment is not required and will not be presented. Thank you!</p><p>To exit the course, close the window or tab in which it opened.</p>'
		}],
		pre_test_nav:[{
			home_only:'Select the Review Content button to review the content.'
		}]
	}
	
	/* DEV NOTE: strings for text that is used on the pre-test and post-test results page before the score and for the pass and fail messages; if there is no pre-test make the pre-test strings empty strings; if there is no post-test make the post-test strings empty strings; when there is no limit to the post-test tries, make fail_max_msg an empty string for the post-test section; when there is a pre-test and there are no topics associated with test questions make all strings excluding pass_msg, fail_msg_3 and result_title empty strings for the pre-test section; when there is no requirement to review incorrect questions for a passed post-test, make pass_review_msg, result_review_msg_1, result_review_msg_2 and result_review_msg_3 empty strings for the post_test section. */
	test_results_dat = {
		pre_test:[{
			pass_msg:'<p>Congratulations!</p><p>You have demonstrated a strong understanding of Human Capital Risk Management and have completed the requirements to receive full credit for the training.</p><p>You can now exit the course by closing the window or tab in which it opened or, if desired, review the course content using the Review Content button.</p>',
			pass_msg_2:'Congratulations, you have successfully completed the Test-Out! You have tested out of the following topic(s):',
			pass_msg_3:'<p>You may skip the topic(s) marked passed, but you must undergo training on the remaining topics. Please select the Review Content button to get started.</p><p>Once done, you will have completed the course. Well done!</p>',	
			pass_msg_4:'The course is marked as complete, but you may want to the review the topics not marked as passed. Please select the Review Content button to get started.',	
			fail_msg_1:'Unfortunately, you did not meet the minimum score required to pass the Test-Out and receive credit for this course. You are now required to view the course content and complete the assessment at the end of the course.',
			fail_msg_2:'<p>Unfortunately, you did not meet the minimum score required to pass the Test-Out and receive credit for this course. You are now required to view the course content and complete the assessment at the end of the course.</p>',
			fail_msg_3:'Unfortunately, you did not meet the minimum score required to pass the Test-Out and receive credit for this course. You are now required to view the course content and complete the assessment at the end of the course.',
			/* DEV NOTE: string below can be used instead when there is a pre-test and there are no topics associated with test questions; otherwise delete */
			/*
			fail_msg_3:'<p>Not quite.</p><p>You did not achieve the minimum score required to successfully complete the test out and receive credit for the course. You will now be taken to the full course content.</p><p>Please select the Review Content button to get started.</p>',
			*/
			result_title:'Test-Out Results'
		}],
		post_test:[{
			generic_msg:'You scored: ',
			pass_msg:'<p>Congratulations!</p><p>You have successfully passed the assessment and completed the Markets Valuation Risk Procedures course.</p><p>To exit the course, close the window or tab in which it opened.</p><p>Select the Review Content button if you would like to review the course content.</p>',			
			pass_review_msg:'You can scroll down to see the correct answer for questions answered incorrectly.',
			fail_msg:'<p>Unfortunately, you did not meet the minimum score required to pass the assessment. </p><p>Please note, you have the option to review the content again using the <b>Review Content</b> button before retaking the assessment.</p>',
            fail_max_msg:'<p>Unfortunately, you have failed the test three times.</p><p>Looks like you need to review the course content again.</p><p>Select Retake Course to continue.</p>',
			result_title:'Assessment Results!',
			result_review_msg_1:'Question:',
			result_review_msg_2:'Options:',
			result_review_msg_3:'Feedback:'
		}]
	}
	
	/* DEV NOTE: strings for text that is used on the attestation page before and after the attesting; if there is no attestation make these empty strings */
	attestation_dat = {		
		attestation:[{
			pre_attesting_msg:'<p>Please certify:</p><p>I hereby confirm that I have read and fully understood the Swiss CID Escalation Process and that I will strictly adhere to it at all times.</p>',
			attested_msg:'<p>Thank you for your confirmation.</p><p>Congratulations! You have successfully completed this training. You are now free to exit. Thank you for participating!</p>'
		}]
	}
	
	/* DEV NOTE: strings for the transcript titles and content separated by section id; if there are no transcripts make this variable an empty array */
	transcript_dat = {
		sec_3:[{
				title:'Transcript - Video 1',			
				transcript:'<p></p>'
		}]
	}
	
	/* DEV NOTE: strings for the hotword titles and content separated by hotword id; if there are no hotwords make this variable an empty array */
	hotword_dat = {
		
		hw_1:[{
				title:'Sample Hotword',				
				text:'<div class="align_left"><p>The definition of Covered Transaction in Section 23A includes both a loan or extension of credit by a bank to an affiliate and a bank\'s purchase of, or investment in, securities issued by an affiliate.</p></div>'
		}]
	}
	
	/* DEV NOTE: strings for the link URLs separated by link id; if there are no links make this variable an empty array */
	link_dat = {
		lnk_1:[{
				url:'mailto:citi@citi.com'
		}],
		lnk_2:[{
				url:'https://policydirectory.citi.net/cpd/_layouts/15/DocIdRedir.aspx?ID=CPDPROD-13-10690'
		}],
		// lnk_3:[{
		// 		url:'images/Sample_PDF.pdf'
		// }]
		lnk_3:[{
				url:'https://policydirectory.citi.net/cpd/_layouts/15/DocIdRedir.aspx?ID=CPDPROD-13-11294&#x0026;PgId=srch'
		}],
		lnk_4:[{
				url:'https://icgshare.nam.citi.net/sites/ValRisk/_layouts/15/WopiFrame.aspx?sourcedoc=/sites/ValRisk/Valuation%20Uncertainty%20Document/Valuation%20Methodology%20and%20Uncertainty.pdf&action=default'
		}],
		lnk_5:[{
				url:'https://policydirectory.citi.net/cpd/_layouts/15/DocIdRedir.aspx?ID=CPDPROD-13-12536&PgId=srch'
		}],
		lnk_6:[{
				url:'https://icgshare.nam.citi.net/sites/ValRisk/CVA%20XVA%20Methodology/CVA%20Methodology.pdf?Web=1'
		}],
		lnk_7:[{
				url:'https://policydirectory.citi.net/cpd/_layouts/15/DocIdRedir.aspx?ID=CPDPROD-13-8157'
		}],
		lnk_8:[{
				url:'https://policydirectory.citi.net/cpd/_layouts/15/DocIdRedir.aspx?ID=CPDPROD-13-11722'
		}],
		lnk_9:[{
				url:'mailto:dl.markets.global.pmm@imceu.eu.ssmb.com'
		}],
		lnk_10:[{
				url:'https://citiriskcontrols.citigroup.net/mrms-vrt-ui/'
		}],
		lnk_11:[{
				url:'mailto:dl.mkts.global.vrd.users@imceu.eu.ssmb.com'
		}],
		lnk_12:[{
				url:'mailto:nacitivaluationsDL@imcnam.ssmb.com'
		}],
		lnk_13:[{
				url:'mailto:emea.valuationsDL@imceu.eu.ssmb.com'
		}],
		lnk_14:[{
				url:'https://policydirectory.citi.net/cpd/_layouts/15/DocIdRedir.aspx?ID=CPDPROD-13-11036&PgId=srch'
		}],
		lnk_15:[{
				url:'mailto:dl.mkts.global.valuation.risk@imcnam.ssmb.com'
		}],
		lnk_16:[{
				url:'https://policydirectory.citi.net/cpd/_layouts/15/DocIdRedir.aspx?ID=CPDPROD-13-8157'
		}],

	}
	
	/* DEV NOTE: strings for the resource popup title and content */
	resource_dat = {
		resources:[{
				title:'Resources',				
				text:'<div class="align_left box-overflow"><p><a data-lnk-id="lnk_3" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Unchanged Pricing Procedures</a></p> <p><a data-lnk-id="lnk_4" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Valuation Uncertainty Document</a></p> <p><a data-lnk-id="lnk_5" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">XVA Methodology Document</a></p> <p><a data-lnk-id="lnk_6" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">CVA Methodology Document</a></p> <p><a data-lnk-id="lnk_7" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Pricing and Price Verification Policy</a></p> <p><a data-lnk-id="lnk_8" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Markets Valuation Risk Procedures</a></p> <p><a data-lnk-id="lnk_9" href="mailto:dl.markets.global.pmm@imceu.eu.ssmb.com" class="popup_neutral blue_color">*MKTS GLOBAL PMM</a></p> <p><a data-lnk-id="lnk_10" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Valuation Risk Document Tool (VRDT)</a></p> <p><a data-lnk-id="lnk_11" href="mailto:dl.mkts.global.vrd.users@imceu.eu.ssmb.com" class="popup_neutral blue_color">*MKTS GLOBAL VRD Users</a></p> <p><a data-lnk-id="lnk_12" href="mailto:nacitivaluationsDL@imcnam.ssmb.com" class="popup_neutral blue_color">*CIB US NA Citi Valuations</a></p> <p><a data-lnk-id="lnk_13" href="mailto:emea.valuationsDL@imceu.eu.ssmb.com" class="popup_neutral blue_color">*CIB UK EMEA Valuations</a></p> <p><a data-lnk-id="lnk_14" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Global Collateral, Client Valuation, and Fair Value Disclosures Standard</a></p> <p><a data-lnk-id="lnk_15" href="mailto:dl.mkts.global.valuation.risk@imcnam.ssmb.com" class="popup_neutral blue_color">*MKTS GLOBAL Valuation Risk</a></p></div>'
		}]
	}

	/* DEV NOTE: strings for LMS errors */
	lms_error_dat = {
		lms_error_1:[{
				text1:'API cannot be found.',
				text2:'Communication has been lost. Please close this training course and restart it at a later time.<br>Do not continue as your progress or completion will not be tracked.<br>You will be able to restart from the last successful save point.'
        }]		
	}
});