/* communication settings for CS WBT Communication Standards v1.3 04-July-2012 */
/* 
* Communication Interface 
* Description: the Interface between LMS and WBT 
* Values: NONE = without communication (Standalone)
* SCORM = SCORM 1.2 with communication for LMS 
*/ 
var COMMUNICATION_INTERFACE = "SCORM"; 

/* 
* Communication Debug 
* Description: enables the WBT debug mode (communication debug window) 
* Values: false = disabled (default)
* true = enabled 
*/ 
var COMMUNICATION_DEBUG = false; 

/* 
* Communication Timeout 
* Description: after [n] seconds the communication between LMS and WBT will be interrupted 
* Values: [n] = seconds (Default:  15)
*/ 
var COMMUNICATION_TIMEOUT = 3; 

/* 
* Communication NumOfAttempt 
* Description: number of attempts for the communication connection 
* Values: [n] = number of attempts (Default : 2)
*/ 
var COMMUNICATION_NUMOFATTEMPT = 2; 

/* 
* Communication SaveData Interval 
* Description: after [n] pages * -> the WBT saves data to the LMS 
* Values: 0 = disabled 
* [n] = number of pages (Default : 10)
*/ 
var COMMUNICATION_SAVEDATA_INTERVAL = 3; 

/*
* Communication ErrorMessage 
* Description: when the LMS sends an error (only the function: LMSGetValue) * -> the WBT shows an error message 
* Values: false = disabled
* true = enabled (Default)
*/ 
var COMMUNICATION_ERRORMESSAGE = true; 

/* 
* Communication Status MasteryScoreFailed 
* Description: if the WBT has a masteryscore (Testmodule only) and test has been failed * -> choose the value which will be sent to the LMS 
* Values: failed = failed 
* incomplete = incomplete 
*/ 
var COMMUNICATION_STATUS_MASTERYSCOREFAILED = "incomplete"; 

/* 
* Communication Status MasteryScorePassed 
* Description: if the WBT has a masteryscore (Testmodule only) and test has been passed * -> choose the value which will be sent to the LMS 
* Values: passed = passed
* completed = completed 
*/ 
var COMMUNICATION_STATUS_MASTERYSCOREPASSED = "completed";