/* variables used for course-specific text */
/* DEV NOTE indicates that the variable should be updated for the course */

$( document ).ready(function() {

	/* DEV NOTE: strings for course title; courseTitleMenu appears on Menu page and courseTitle appears everywhere else it is used */
	document.courseTitle = "Identificação e Reporte de potenciais fraudes";
	document.courseTitleMenu = "Identificação e Reporte de potenciais fraudes";

	/* DEV NOTE: strings for topic titles which are used in the pre-test results */
	document.topicTitles = {
		titles:[
			{title:'Introdução'},
			{title:'Reporte de situações ou incidentes incomuns'},
			{title:'Fraude interna'},
			{title:'Fraude externa'},
			{title:'Fraude em análise'}
		]
	}	
		
	/* DEV NOTE: string for the intro text on the pre-test message that appears asking the learner if they want to take the pre-test; if there is no pre-test make this an empty string */
	document.pretestIntro = ""
	
	/* DEV NOTE: strings for text that is used on the pre-test and post-test intro pages; if there is no pre-test make the pre-test string an empty string; if there is no post-test make the post-test string an empty string */
	test_intro_dat = {
		pre_test:[{
			generic_msg:''
		}],
		post_test:[{
			generic_msg:''
		}]
	}
	
	/* DEV NOTE: strings for text that is used on the pre-test and post-test results page before the score and for the pass and fail messages; if there is no pre-test make the pre-test strings empty strings; if there is no post-test make the post-test strings empty strings */
	test_results_dat = {
		pre_test:[{
			pass_msg:'',			
			pass_msg_2:'',
			pass_msg_3:'',			
			fail_msg_1:'',
			fail_msg_2:'',
			fail_msg_3:''
		}],
		post_test:[{
			generic_msg:'',
			pass_msg:'',
			fail_msg:''
		}]
	}
	
	/* DEV NOTE: strings for text that is used on the attestation page before and after the attesting; if there is no attestation make these empty strings */
	attestation_dat = {		
		attestation:[{
			pre_attesting_msg:'',
			attested_msg:''
		}]
	}
	
	/* DEV NOTE: strings for the transcript titles and content separated by section id; if there are no transcripts make this variable an empty array */
	transcript_dat = {}
	
	/* DEV NOTE: strings for the hotword titles and content separated by hotword id; if there are no hotwords make this variable an empty array */
	hotword_dat = {
		hw_1:[{
				title:'Possíveis violações à Política US Cross Border (P-00025) e/ou a Política da FATCA (GP-00085)',
				text:'<p><strong>Violações </strong>à <a data-lnk-id="lnk_4" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Política transfronteiriça dos EUA (P-00025)</a><strong></strong> DEVEM ser informadas diretamente à equipe L&C dos EUA (para a Suíça) ou ao responsável local pelo Programa L&C dos EUA (para outras localidades).</p><p><strong>Deficiências em controles FATCA (incluindo quaisquer suspeitas de violação da </strong><a data-lnk-id="lnk_5" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Política da FATCA (GP-00085)</a><strong>)</strong> DEVEM ser reportadas imediatamente à observação do ponto de contato da FATCA, por meio do MICOS.</p>'
		}],
		hw_2:[{
				title:'Quando é inadequado reportar ao gerente direto',				
				text:'<p>Caso seu gerente direto esteja envolvido no incidente ou não tenha lidado adequadamente com o ocorrido, ou se você não estiver à vontade para tratar a questão diretamente com ele/ela, você poderá reportá-lo a outra pessoa (por exemplo, a outro gerente adequado, aos departamentos de Conformidade, Recursos Humanos ou Jurídico, ou à <strong>Linha direta de integridade (telefone),</strong> ou à <strong>Integrity Line (internet)</strong>). Em tais situações, você não deve reportar situações ou incidentes incomuns a pessoas que estejam subordinadas, de forma direta ou indireta, ao seu gerente direto, ou quando houver algum conflito de interesses.</p>'
		}],
		hw_3:[{
				title:'Linha direta de integridade (telefone)',
				text:'<p>A <strong>Linha direta de integridade (telefone)</strong> está disponível globalmente 24 horas por dia, 7 dias por semana, e possui equipe treinada a atender ligações em inglês, alemão, francês e italiano.</p><p>Os incidentes reportados por meio da <strong>Linha direta de integridade</strong> são processados de forma imediata e discreta.</p>'
		}],
		hw_4:[{
				title:'Integrity Line (internet)',
				text:'<p>A <strong>Integrity Line (internet)</strong> é hospedada externamente e está disponível 24 horas por dia.</p><p>Permite que você informe situações ou incidentes incomuns a partir de seu computador, smartphone ou tablet.</p><p>Os incidentes reportados por meio da <strong>Integrity Line</strong> são processados de forma imediata e discreta.</p>'
		}],		
		hw_7:[{
				title:'Sinais de alerta comportamentais exibidos pelos autores das fraudes',
				text:'<ul><li>Discrição excessiva ou nervosismo</li><li>Estilo de vida além da própria realidade</li><li>Problemas de controle, relutância em compartilhar funções</li><li>Vontade de sobreposição de controles, geralmente para “facilitar as coisas”</li><li>Recusa de tirar férias ou licença médica</li><li>Ter acesso às instalações e/ou sistemas do Banco durante um período de licença obrigatória</li><li>Associação próxima incomum com um fornecedor, cliente</li><li>Pedido para postergar auditorias internas ou inspeções para “se preparar adequadamente”</li><li>Antecedentes de violações de políticas ou atitudes semelhantes a violações</li><li>Dificuldades financeiras</li></ul>'
		}],
		hw_8:[{
				title:'Atividade não autorizada',
				text:'<p>Funcionários que realizam atividade não autorizada podem exibir os seguintes comportamentos:</p><ul><li>Ter fontes de riqueza não explicadas</li><li>Estar muito envolvidos em investimentos especulativos</li><li>Ter vício no jogo</li><li>Estar passando por dificuldades financeiras</li><li>Ter interesses externos concorrentes ou não informados</li><li>Sobreposição dos controles internos</li><li>Recusar-se a tirar férias e licença médica, e ter acesso às instalações e/ou sistemas do Banco durante o período de licença obrigatória</li><li>Apresentar problemas de controle excessivo e incapacidade de compartilhar as tarefas</li><li>Antecedentes de violações de políticas ou atitudes semelhantes a violações</li><li>Horário de expediente incomum</li></ul>'
		}],
		hw_10:[{
				title:'Principais pontos de aprendizado',
				text:'<p>Na maioria dos casos, a fraude interna é cometida por alguém que age sozinho dentro do Banco e pode ser identificado por <strong>comportamentos suspeitos</strong>, mas ela pode ocorrer por meio de conluio entre funcionários do Banco. Comportamentos suspeitos incluem:</p><ul><li>Discrição excessiva ou nervosismo</li><li>Falta de vontade de compartilhar funções</li><li>Vontade de sobreposição de controles, geralmente para “facilitar as coisas”</li><li>Recusa de tirar férias ou licença médica</li><li>Ter acesso às instalações e/ou sistemas do Banco durante um período de licença obrigatória</li><li>Pedido para postergar auditorias internas ou inspeções para “se preparar adequadamente”</li><li>Antecedentes de violações de políticas ou atitudes semelhantes a violações</li><li>Horário de expediente incomum</li></ul><p><strong>São exemplos de fraude interna:</strong></p><ul><li><strong>A transação não autorizada</strong> ocorre quando os funcionários realizam operações para ocultar lucros ou perdas</li><li><strong>A atividade não autorizada</strong> ocorre quando os funcionários transferem de forma fraudulenta dinheiro ou títulos de uma diferença de pagamento em conta suspensa, nostro ou de custódia, ou quando alteram declarações de contas</li><li><strong>As transferências não autorizadas de fundos e ativos</strong> ocorrem quando os funcionários realizam transferências de fundos ou ativos das contas de um cliente sem que tenham sido instruídos para tanto</li><li><strong>A fraude no reembolso de despesas</strong> pode ser praticada para descaracterizar, superfaturar ou falsificar despesas</li></ul></p><p><strong>Os controles do Credit Suisse para impedir fraude interna incluem:</strong></p><p><strong>Segregação de funções:</strong> Isto requer autorização ou aprovação adicional para uma transação ou processo. O objetivo é impedir um domínio sobre os controles, sobreposição manual dos mesmos ou conluio entre funcionários do Banco. É essencial que haja a adequada segregação de tarefas envolvendo custódia, autorização e controle dos documentos e registros de origem.</p><p><strong>Retorno de chamada para fins de confirmação:</strong> A verificação de autoridade, por exemplo, por meio de retorno de chamada ou assinatura de transação, é usada para verificar a transferência de fundos/ativos (ou seja, pagamentos, títulos) ou solicitações de alterações nos dados estáticos do cliente ou fornecedor. Para tais solicitações, é necessária uma verificação de identidade da parte instrutora; uma verificação de autoridade, ou seja, o direito de mover fundos/ativos ou de fazer alterações nos dados estáticos do cliente/fornecedor e verificações de autenticidade devem ser realizadas para determinar a legitimidade dos detalhes da instrução. Para informações adicionais, consulte os <a data-lnk-id="lnk_12" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">AFGMS</a>.</p>'
		}],
		hw_11:[{
				title:'Principais pontos de aprendizado',
				text:'<p>Na maioria dos casos, a fraude interna é cometida por alguém que age sozinho dentro do Banco e pode ser identificado por <strong>comportamentos suspeitos</strong>, mas ela pode ocorrer por meio de conluio entre funcionários do Banco. Comportamentos suspeitos incluem:</p><ul><li>Discrição excessiva ou nervosismo</li><li>Falta de vontade de compartilhar funções</li><li>Vontade de sobreposição de controles, geralmente para “facilitar as coisas”</li><li>Recusa a gozar férias, licença obrigatória ou licença por doença</li><li>Ter acesso às instalações e/ou sistemas do Banco durante um período de licença obrigatória</li><li>Pedido para postergar auditorias internas ou inspeções para “se preparar adequadamente”</li><li>Antecedentes de violações de políticas ou atitudes semelhantes a violações</li><li>Horário de expediente incomum</li></ul><p><strong>São exemplos de fraude interna:</strong></p><ul><li><strong>A transação não autorizada</strong> ocorre quando os funcionários realizam operações para ocultar lucros ou perdas</li><li><strong>A atividade não autorizada</strong> ocorre quando os funcionários transferem de forma fraudulenta dinheiro ou títulos de uma diferença de pagamento em conta suspensa, nostro ou de custódia, ou quando alteram declarações de contas</li><li><strong>As transferências não autorizadas de fundos e ativos</strong> ocorrem quando os funcionários realizam transferências de fundos ou ativos das contas de um cliente sem que tenham sido instruídos para tanto</li><li><strong>A fraude no reembolso de despesas</strong> pode ser praticada para descaracterizar, superfaturar ou falsificar despesas</li></ul><p><strong>Controles do Credit Suisse para impedir fraudes internas, que incluem:</strong></p><p><strong>Período de Licença obrigatória:</strong> Para mitigar possível risco de fraude interna, os funcionários em funções confidenciais designados sob a <a data-lnk-id="lnk_8" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Política global sobre o período de licença obrigatória (GP-00387)</a> devem tirar um período de licença de 10 dias úteis consecutivos dentro de um ano civil e, ao fazê-lo, os funcionários não devem exercer atividades relacionadas à respectiva função, acessar quaisquer instalações do Banco para fins comerciais ou utilizar os sistemas do Banco.</p>'
		}],
		hw_12:[{
				title:'Principais pontos de aprendizado',
				text:'<p>O Banco e todos os funcionários são vulneráveis a riscos de fraude externa. <strong>As principais ameaças de fraude externa</strong> com que você pode se deparar incluem:</p><p><strong>Fraude em pagamento</strong><br>A fraude em pagamento é o resultado de um ato deliberado para convencer o pagador autorizado a realizar um pagamento sem a autorização do cliente. A fraude cibernética em pagamento utiliza diversas formas de fraude cibernética como meio de acesso aos fundos.</p><p><strong>Fraude cibernética</strong><br>Os casos de fraude cibernética se referem a qualquer tipo de engano deliberado para vantagem injusta ou ilícita que ocorre online, tendo como alvo clientes e funcionários. As fraudes cibernéticas costumam ser usadas para efetuar desembolsos fraudulentos de fundos, títulos e dados ou materiais confidenciais.</p><p><strong>Roubo de identidade</strong><br>Roubo de identidade é um tipo de fraude cometido pelo uso de informações pessoais não públicas de outra pessoa, sem sua autorização, com o intuito de cometer fraude. O roubo de identidade traz uma ameaça à reputação do Credit Suisse de due diligence, de saber com que faz negócios e de proteger as informações existentes dos clientes. O roubo de identidade é considerado crime nos Estados Unidos, mas pode ser tratado de forma diferente em outras jurisdições.</p>'
		}],
		hw_13:[{
				title:'Principais pontos de aprendizado',
				text:'<p>O Banco e todos os funcionários são vulneráveis a riscos de fraude externa. <strong>As principais ameaças de fraude externa</strong> com que você pode se deparar incluem:</p><p><strong>Fraude de demonstrações financeiras</strong><br>Casos de fraude de demonstrações financeiras acontecem quando um cliente apresenta uma documentação com informações falsas sobre seu patrimônio e/ou receitas para obter produtos e serviços do Banco. Os exemplos de esquemas de fraude de demonstrações financeiras incluem o registro de despesa fictícia ou em períodos indevidos, declarações indevidas ou ocultação de passivos.</p><p><strong>Fraude em investimento</strong><br>Os esquemas mais comuns de fraude em investimentos são caracterizados por ofertas de investimentos de baixo ou nenhum risco, retornos garantidos, retornos excessivamente consistentes, estratégias complexas ou títulos não registrados. Os exemplos de fraude em investimento podem incluir esquemas Ponzi e de pirâmide e uma solicitação de pagamento de taxa de processamento para investir. </p><p><strong>Uso indevido da marca do Credit Suisse</strong><br>O uso indevido da marca Credit Suisse se refere a um esquema de fraude o qual pode envolver documentos falsificados, sites na web e contas de e-mail falsos contendo marcas ou logotipos do Credit Suisse indevidamente. A intenção é fazer com que os documentos pareçam um investimento ou produto financeiro legítimo aos olhos de possíveis investidores, bancos ou consumidores, para que eles invistam no esquema fraudulento. </p>'
		}],
		hw_14:[{
				title:'Principais pontos de aprendizado',
				text:'<p>O Banco e todos os funcionários são vulneráveis a riscos de fraude externa. <strong>As principais ameaças de fraude externa</strong> com que você pode se deparar incluem:</p><p><strong>Fraude em pagamento</strong><br>A fraude em pagamento é o resultado de um ato deliberado para convencer o pagador autorizado a realizar um pagamento sem a autorização do cliente. A fraude cibernética em pagamento utiliza diversas formas de fraude cibernética como meio de acesso aos fundos.</p><p><strong>Fraude cibernética</strong><br>Os casos de fraude cibernética se referem a qualquer tipo de engano deliberado para vantagem injusta ou ilícita que ocorre online, tendo como alvo clientes e funcionários. As fraudes cibernéticas costumam ser usadas para efetuar desembolsos fraudulentos de fundos, títulos e dados ou materiais confidenciais.</p><p><strong>Roubo de identidade</strong><br>Roubo de identidade é um tipo de fraude cometido pelo uso de informações pessoais não públicas de outra pessoa, sem sua autorização, com o intuito de cometer fraude. O roubo de identidade traz uma ameaça à reputação do Credit Suisse de due diligence, de saber com que faz negócios e de proteger as informações existentes dos clientes. O roubo de identidade é considerado crime nos Estados Unidos, mas pode ser tratado de forma diferente em outras jurisdições.</p>'
		}],
		hw_15:[{
				title:'Principais pontos de aprendizado',
				text:'<p>O Banco e todos os funcionários são vulneráveis a riscos de fraude externa. As principais ameaças de fraude externa com que você pode se deparar incluem:</p><p><strong>Fraude em pagamento</strong><br>A fraude em pagamento é o resultado de um ato deliberado para convencer o pagador autorizado a realizar um pagamento sem a autorização do cliente. A fraude cibernética em pagamento utiliza diversas formas de fraude cibernética como meio de acesso aos fundos.</p><p><strong>Fraude cibernética</strong><br>Os casos de fraude cibernética se referem a qualquer tipo de engano deliberado para vantagem injusta ou ilícita que ocorre online, tendo como alvo clientes e funcionários. As fraudes cibernéticas costumam ser usadas para efetuar desembolsos fraudulentos de fundos, títulos e dados ou materiais confidenciais.</p><p><strong>Roubo de identidade</strong><br>Roubo de identidade é um tipo de fraude cometido pelo uso de informações pessoais não públicas de outra pessoa, sem sua autorização, com o intuito de cometer fraude. O roubo de identidade traz uma ameaça à reputação do Credit Suisse de due diligence, de saber com que faz negócios e de proteger as informações existentes dos clientes. O roubo de identidade é considerado crime nos Estados Unidos, mas pode ser tratado de forma diferente em outras jurisdições.</p>'
		}]
	}
	
	/* DEV NOTE: strings for the link URLs separated by link id; if there are no links make this variable an empty array */
	link_dat = {
		lnk_1:[{
				/* cultural values */
				url:'http://csintra.net/about/en/purpose_values/values.html'
		}],
		lnk_2:[{
				/* Incident Collation Policy (GP-00260) */
				url:'http://my.csintra.net/mypolicies/GP-00260-15009'
		}],
		lnk_3:[{
				/* Disciplinary Policy (GP-01058) */
				url:'http://my.csintra.net/mypolicies/GP-01058-333069'
		}],
		lnk_4:[{
				/* US Cross Border Policy (P-00025) */
				url:'http://my.csintra.net/mypolicies/P-00025-43014'
		}],
		lnk_5:[{
				/* FATCA Policy (GP-00085) */
				url:'http://my.csintra.net/mypolicies/GP-00085-340480'
		}],
		lnk_6:[{
				/* Escalation Policy (GP-00012) */
				url:'http://my.csintra.net/mypolicies/GP-00012-27349'
		}],
		lnk_7:[{
				/* Credit Suisse Integrity Lines (phone and web) */
				url:'https://home.csintra.net/content/divisions-and-functions/en/cco/rc/investigations/integrity-lines.html'
		}],
		lnk_8:[{
				/* Global Block Leave Policy (GP-00387) */
				url:'http://my.csintra.net/mypolicies/GP-00387-27433'
		}],
		lnk_9:[{
				/* Escalation and Identifying Potential Fraud Course Summary */
				url:'images/CS120_course_summary.pdf'
		}],
		lnk_10:[{
				/* Anti-Fraud Policy */
				url:'https://mypolicies.csintra.net/#/overviewComponent/24765/305675/GP-00298/false'
		}],
		lnk_11:[{
				/* Identity Theft Red Flags Supplement (GP-00298 S-03) */
				url:'http://my.csintra.net/mypolicies/GP-00298-S03-367057'
		}],
		lnk_12:[{
				/* Anti-Fraud Global Minimum Standards (AFGMS) */
				url:'https://home.csintra.net/content/dam/assets/divisions-and-functions/documents/crco/dcco/core-compliance/global-anti-fraud-conduct-monitoring/anti-fraud-global-minimum-standards.pdf'					 
		}],
		lnk_13:[{
				/* Change Initiatives */
				url:'https://odyssey.rowini.net/confluence/display/WTE/Anti-Fraud+Global+Minimum+Standards+%28AFGMS%29+to+be+considered+in+Change+Initiatives+in+Wealth+Management'
		}]
	}
	
	/* DEV NOTE: strings for the resource popup title and content */
	resource_dat = {
		resources:[{
				title:'Recursos',				
				text:'<p><strong>Os links da intranet podem não estar disponíveis no Saba Mobile App.</strong></p><p><a data-lnk-id="lnk_9" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Resumo do curso Identificação e reporte de potenciais fraudes</a></p><p><a data-lnk-id="lnk_6" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Política Escalation (GP-00012)</a></p><p><a data-lnk-id="lnk_10" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Política Antifraude</a></p><p><a data-lnk-id="lnk_2" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Política Incident Collation (GP-00260)</a></p><p><a data-lnk-id="lnk_4" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Política US Xcross-Border (P-00025)</a></p><p><a data-lnk-id="lnk_5" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Política FATCA (GP-00085)</a></p><p><a data-lnk-id="lnk_3" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Política Disciplinary (GP-01058)</a></p><p><a data-lnk-id="lnk_8" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Política global sobre o período de licença obrigatória (GP-00387)</a></p><p><a data-lnk-id="lnk_11" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Complemento Identity Theft red Flags (GP-00298 S-03)</a></p><p><a data-lnk-id="lnk_7" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Linhas diretas de integridade do Credit Suisse (telefone e internet)</a></p><p><a data-lnk-id="lnk_12" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Padrões mínimos globais de combate à fraude</a></p>'
		}]
	}

	/* DEV NOTE: strings for LMS errors */
	lms_error_dat = {
		lms_error_1:[{
				text1:'API cannot be found.',
				text2:'The course may not have been launched from an LMS.'
		}]		
	}
});