/* variables used for course-specific text */
/* DEV NOTE indicates that the variable should be updated for the course */

$( document ).ready(function() {

	/* DEV NOTE: strings for course title; courseTitleMenu appears on Menu page and courseTitle appears everywhere else it is used */
	document.courseTitle = "Escalation e individuazione di potenziali frodi";
	document.courseTitleMenu = "Escalation e individuazione di potenziali frodi";

	/* DEV NOTE: strings for topic titles which are used in the pre-test results */
	document.topicTitles = {
		titles:[
			{title:'Introduzione'},
			{title:'Escalation di eventi insoliti o di sospetti'},
			{title:'Frodi interne'},
			{title:'Frodi esterne'},
			{title:'Frodi durante l’analisi'}
		]
	}	
		
	/* DEV NOTE: string for the intro text on the pre-test message that appears asking the learner if they want to take the pre-test; if there is no pre-test make this an empty string */
	document.pretestIntro = ""
	
	/* DEV NOTE: strings for text that is used on the pre-test and post-test intro pages; if there is no pre-test make the pre-test string an empty string; if there is no post-test make the post-test string an empty string */
	test_intro_dat = {
		pre_test:[{
			generic_msg:''
		}],
		post_test:[{
			generic_msg:''
		}]
	}
	
	/* DEV NOTE: strings for text that is used on the pre-test and post-test results page before the score and for the pass and fail messages; if there is no pre-test make the pre-test strings empty strings; if there is no post-test make the post-test strings empty strings */
	test_results_dat = {
		pre_test:[{
			pass_msg:'',			
			pass_msg_2:'',
			pass_msg_3:'',			
			fail_msg_1:'',
			fail_msg_2:'',
			fail_msg_3:''
		}],
		post_test:[{
			generic_msg:'',
			pass_msg:'',
			fail_msg:''
		}]
	}
	
	/* DEV NOTE: strings for text that is used on the attestation page before and after the attesting; if there is no attestation make these empty strings */
	attestation_dat = {		
		attestation:[{
			pre_attesting_msg:'',
			attested_msg:''
		}]
	}
	
	/* DEV NOTE: strings for the transcript titles and content separated by section id; if there are no transcripts make this variable an empty array */
	transcript_dat = {}
	
	/* DEV NOTE: strings for the hotword titles and content separated by hotword id; if there are no hotwords make this variable an empty array */
	hotword_dat = {
		hw_1:[{
				title:'Sospette violazioni della direttiva per le attività di private banking transfrontaliere con gli Stati Uniti (P-00025) e/o della direttiva FATCA (GP-00085)',
				text:'<p>Le <strong>violazioni</strong> della <a data-lnk-id="lnk_4" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">direttiva per le attività di Private Banking transfrontaliere con gli Stati Uniti (P-00025)</a> DEVONO essere notificate direttamente al team U.S. L&C (per la Svizzera) o al Program Officer U.S. L&C responsabile locale (per le altre sedi).</p><p><strong>Eventuali carenze a livello di controllo FATCA (inclusi eventuali casi sospetti di violazione della </strong><a data-lnk-id="lnk_5" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">direttiva FATCA (GP-00085)</a><strong>)</strong> DEVONO essere segnalati immediatamente al momento dell’osservazione al FATCA Desk mediante MICOS.</p>'
		}],
		hw_2:[{
				title:'Quando è inopportuno',				
				text:'<p>Se il vostro responsabile di linea è coinvolto nell’incidente o ha omesso di affrontare l’evento in maniera appropriata, o se sollevare la questione direttamente vi mette a disagio, dovete effettuare l’escalation a un’altra parte (p. es. un altro responsabile competente, Compliance, Human Resources, General Counsel, o la <strong>Integrity Hotline (linea telefonica)</strong> o la <strong>Integrity Line (pagina web)</strong>). In tali situazioni, non dovete effettuare la segnalazione a persone subordinate, direttamente o indirettamente, al vostro responsabile di linea o nel caso in cui ci sia altrimenti un conflitto di interessi.</p>'
		}],
		hw_3:[{
				title:'Integrity Hotline (linea telefonica)',
				text:'<p>La <strong>Integrity Hotline (linea telefonica)</strong> è disponibile a livello globale, 24 ore su 24, sette giorni su sette, e i suoi collaboratori appositamente formati sono in grado di ricevere chiamate in inglese, tedesco, francese e italiano.</p><p>Gli eventi segnalati tramite la <strong>Integrity Hotline</strong> vengono gestiti in modo tempestivo e discreto.</p>'
		}],
		hw_4:[{
				title:'Integrity Line (pagina web)',
				text:'<p>La <strong>Integrity Line (pagina web)</strong> è esternalizzata ed è disponibile 24 ore su 24.</p><p>Essa vi consente di segnalare eventi insoliti o sospetti tramite il vostro PC nonché attraverso il vostro smartphone o tablet privato.</p><p>Gli eventi segnalati tramite la <strong>Integrity Line</strong> vengono gestiti in modo tempestivo e discreto.</p>'
		}],		
		hw_7:[{
				title:'Comportamenti sospetti mostrati dai truffatori',
				text:'<ul><li>Circospezione o nervosismo</li><li>Vivere al di sopra dei propri mezzi</li><li>Problematiche di controllo, riluttanza a condividere compiti</li><li>Tendenza a ignorare i controlli, spesso per “semplificare le cose”</li><li>Rifiuto di prendere vacanze o congedi per malattia</li><li>Accesso ai locali e/o sistemi della banca durante periodi di congedo obbligatorio ininterrotto</li><li>Legame insolitamente stretto con un fornitore o un cliente</li><li>Richiesta di rinvio delle ispezioni o degli audit interni per “prepararsi adeguatamente”</li><li>Precedenti di violazioni o di tentativi di violazione delle direttive</li><li>Difficoltà finanziarie</li></ul>'
		}],
		hw_8:[{
				title:'Attività non autorizzate',
				text:'<p>Il personale coinvolto in attività non autorizzate può evidenziare i seguenti comportamenti:</p><ul><li>fonti patrimoniali inspiegabili;</li><li>ampio coinvolgimento in investimenti speculativi;</li><li>dipendenza dal gioco d’azzardo;</li><li>difficoltà finanziarie;</li><li>interessi economici esterni in concorrenza o non dichiarati;</li><li>ignora i controlli interni;</li><li>rifiuta di prendere ferie o congedi per malattia e accede ai locali e/o ai sistemi della banca durante il congedo obbligatorio ininterrotto;</li><li>mostra problematiche di controllo eccessivo ed è riluttante a condividere i compiti;</li><li>precedenti di violazioni o di tentativi di violazione delle direttive;</li><li>orari di lavoro insoliti.</li></ul>'
		}],
		hw_10:[{
				title:'Punti d’apprendimento chiave',
				text:'<p>Nella maggior parte dei casi la frode interna è commessa da un dipendente che agisce isolatamente all’interno della banca e può essere identificata da <strong>comportamenti sospetti</strong>, ma può avvenire in collusione tra il personale della banca. Tra i comportamenti sospetti figurano:</p><ul><li>Circospezione o nervosismo</li><li>Riluttanza a condividere compiti</li><li>Tendenza a ignorare i controlli, spesso per “semplificare le cose”</li><li>Rifiuto di prendere vacanze o congedi per malattia</li><li>Accesso ai locali e/o sistemi della banca durante periodi di congedo obbligatorio ininterrotto</li><li>Richiesta di rinvio delle ispezioni o degli audit interni per “prepararsi adeguatamente”</li><li>Precedenti di violazioni o di tentativi di violazione delle direttive</li><li>Orari di lavoro insoliti</li></ul><p><strong>Esempi di frode interna:</strong></p><ul><li><strong>Trading non autorizzato:</strong> si verifica quando il personale esegue operazioni per occultare utili e perdite</li><li><strong>Attività non autorizzate:</strong> si verificano quando il personale trasferisce contanti o titoli da un conto sospeso, nostro o depo break, o modifica estratti conto</li><li><strong>Trasferimenti non autorizzati di fondi e valori patrimoniali:</strong> si verificano quando il personale effettua trasferimenti di fondi o di valori patrimoniali dai conti dei clienti senza aver ricevuto istruzioni dagli stessi</li><li><strong>Truffe con i rimborsi spese:</strong> possono essere costituite da spese definite in modo errato, sovrastimate o fittizie</li></ul></p><p><strong>Tra i controlli messi in atto da Credit Suisse per scoraggiare le frodi interne figurano:</strong></p><p><strong>Separazione dei ruoli:</strong> richiede ulteriore approvazione o autorizzazione per una transazione o un processo. L’obiettivo è quello di impedire il dominio di un singolo sui controlli, il superamento manuale dei controlli o la collusione tra il personale della banca. È necessario che vi sia un’adeguata separazione dei ruoli nelle attività che comportano la custodia, l’autorizzazione e il controllo di documenti e registrazioni originali.</p><p><strong>Chiamate di verifica:</strong> la verifica della legittimazione, p. es. mediante chiamata o firma della transazione, consente di verificare il trasferimento di fondi/valori patrimoniali (p. es. pagamenti, titoli) o richieste di modifiche ai dati statici di un cliente o di un fornitore. Per tali richieste è necessario condurre una verifica dell’identità del richiedente, una verifica della legittimazione, p. es. facoltà di trasferire fondi/valori patrimoniali o di apportare modifiche ai dati statici del cliente/fornitore, nonché controlli dell’autenticità al fine di stabilire la legittimità delle istruzioni. Per maggiori informazioni si prega di fare riferimento agli standard minimi globali antifrode <a data-lnk-id="lnk_12" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">AFGMS</a>.</p>'
		}],
		hw_11:[{
				title:'Punti d’apprendimento chiave',
				text:'<p>Nella maggior parte dei casi la frode interna è commessa da un dipendente che agisce isolatamente all’interno della banca e può essere identificata da <strong>comportamenti sospetti</strong>, ma può avvenire in collusione tra il personale della banca. Tra i comportamenti sospetti figurano:</p><ul><li>Circospezione o nervosismo</li><li>Riluttanza a condividere compiti</li><li>Tendenza a ignorare i controlli, spesso per “semplificare le cose”</li><li>Rifiuto di prendere vacanze, congedi obbligatori ininterrotti o congedi malattia</li><li>Accesso ai locali e/o sistemi della banca durante periodi di congedo obbligatorio ininterrotto</li><li>Richiesta di rinvio delle ispezioni o degli audit interni per “prepararsi adeguatamente”</li><li>Precedenti di violazioni o di tentativi di violazione delle direttive</li><li>Orari di lavoro insoliti</li></ul><p><strong>Esempi di frode interna:</strong></p><ul><li><strong>Trading non autorizzato:</strong> si verifica quando il personale esegue operazioni per occultare utili e perdite</li><li><strong>Attività non autorizzate:</strong> si verificano quando il personale trasferisce contanti o titoli da un conto sospeso, nostro o depo break, o modifica estratti conto</li><li><strong>Trasferimenti non autorizzati di fondi e valori patrimoniali:</strong> si verificano quando il personale effettua trasferimenti di fondi o di valori patrimoniali dai conti dei clienti senza aver ricevuto istruzioni dagli stessi</li><li><strong>Truffe con i rimborsi spese:</strong> possono essere costituite da spese definite in modo errato, sovrastimate o fittizie</li></ul><p><strong>Tra i controlli messi in atto da Credit Suisse per scoraggiare le frodi interne figurano:</strong></p><p><strong>Congedo obbligatorio ininterrotto:</strong> per mitigare il rischio potenziale di frode interna, il personale sensibile designato ai sensi della <a data-lnk-id="lnk_8" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">direttiva Congedo obbligatorio ininterrotto (GP-00387)</a> deve usufruire di 10 giorni lavorativi consecutivi di congedo per ogni anno solare durante i quali non è consentito svolgere compiti connessi al proprio ruolo, accedere ai locali della banca per scopi aziendali, oppure utilizzarne i sistemi.</p>'
		}],
		hw_12:[{
				title:'Punti d’apprendimento chiave',
				text:'<p>La banca e il suo personale sono esposti a rischi di frode esterna. <strong>Le principali minacce di frode esterna</strong> a cui potete essere esposti sono:</p><p><strong>Frodi nei pagamenti</strong><br>Le frodi nei pagamenti sono il risultato di un deliberato inganno volto a convincere il pagatore autorizzato a eseguire un pagamento senza l’autorizzazione del cliente. Le frodi nei pagamenti di tipo informatico utilizzano varie forme di frode informatica come veicolo per accedere ai fondi.</p><p><strong>Frodi informatiche</strong><br>Per frode informatica si intende qualsiasi atto di inganno intenzionale teso a procurare un guadagno sleale o illecito che si verifica online a danno di clienti e collaboratori. Spesso, la frode informatica è impiegata per effettuare erogazioni fraudolente di fondi, titoli e materiale o dati confidenziali.</p><p><strong>Furto di identità</strong><br>Il furto di identità è un tipo di frode commessa mediante l’uso di informazioni personali non pubbliche di un altro soggetto senza la sua autorizzazione con il potenziale fine di commettere frodi. Il furto di identità rappresenta una minaccia per la reputazione di Credit Suisse, per il processo di due diligence e per la conoscenza dei soggetti con cui sceglie di svolgere l’attività nonché per la protezione dei dati dei clienti attuali. È considerato un reato negli Stati Uniti, ma può subire un trattamento diverso in altre giurisdizioni.</p>'
		}],
		hw_13:[{
				title:'Punti d’apprendimento chiave',
				text:'<p>La banca e il suo personale sono esposti a rischi di frode esterna. <strong>Le principali minacce di frode esterna</strong> a cui potete essere esposti sono:</p><p><strong>Frodi di bilancio</strong><br>Le frodi di bilancio si verificano quando un cliente fornisce una documentazione falsificata per presentare in maniera non veritiera patrimoni e/o ricavi al fine di ottenere prodotti e servizi della banca. Esempi di frodi di bilancio comprendono la registrazione di ricavi fittizi o in periodi contabili non corretti, informazioni non corrette od occultamento di passività.</p><p><strong>Frodi d’investimento</strong><br>Le tipiche frodi d’investimento sono caratterizzate da offerte di investimenti a rischio basso o nullo, rendimenti garantiti, rendimenti eccessivamente costanti, strategie complesse o titoli non nominativi. Esempi di frode d’investimento possono includere schemi di Ponzi, sistemi a piramide e richieste di pagamento di commissioni di gestione per procedere all’investimento. </p><p><strong>Uso improprio del marchio Credit Suisse</strong><br>Per uso improprio del marchio Credit Suisse si intende uno schema di frode che può comportare la falsificazione di documenti, siti web e account e-mail fraudolenti con uso indebito del marchio o del logo di Credit Suisse. L’obiettivo è quello di far apparire i documenti come un investimento o un prodotto finanziario lecito a potenziali investitori, banche o consumatori in modo da indurli a investire nel sistema fraudolento. </p>'
		}],
		hw_14:[{
				title:'Punti d’apprendimento chiave',
				text:'<p>La banca e il suo personale sono esposti a rischi di frode esterna. <strong>Le principali minacce di frode esterna</strong> a cui potete essere esposti sono:</p><p><strong>Frodi nei pagamenti</strong><br>Le frodi nei pagamenti sono il risultato di un deliberato inganno volto a convincere il pagatore autorizzato a eseguire un pagamento senza l’autorizzazione del cliente. Le frodi nei pagamenti di tipo informatico utilizzano varie forme di frode informatica come veicolo per accedere ai fondi.</p><p><strong>Frodi informatiche</strong><br>Per frode informatica si intende qualsiasi atto di inganno intenzionale teso a procurare un guadagno sleale o illecito che si verifica online a danno di clienti e collaboratori. Spesso, la frode informatica è impiegata per effettuare erogazioni fraudolente di fondi, titoli e materiale o dati confidenziali.</p><p><strong>Furto di identità</strong><br>Il furto di identità è un tipo di frode commessa mediante l’uso di informazioni personali non pubbliche di un altro soggetto senza la sua autorizzazione con il potenziale fine di commettere frodi. Il furto di identità rappresenta una minaccia per la reputazione di Credit Suisse, per il processo di due diligence e per la conoscenza dei soggetti con cui sceglie di svolgere l’attività nonché per la protezione dei dati dei clienti attuali. È considerato un reato negli Stati Uniti, ma può subire un trattamento diverso in altre giurisdizioni.</p>'
		}],
		hw_15:[{
				title:'Punti d’apprendimento chiave',
				text:'<p>La banca e il suo personale sono esposti a rischi di frode esterna. <strong>Le principali minacce di frode esterna</strong> a cui potete essere esposti sono:</p><p><strong>Frodi nei pagamenti</strong><br>Le frodi nei pagamenti sono il risultato di un deliberato inganno volto a convincere il pagatore autorizzato a eseguire un pagamento senza l’autorizzazione del cliente. Le frodi nei pagamenti di tipo informatico utilizzano varie forme di frode informatica come veicolo per accedere ai fondi.</p><p><strong>Frodi informatiche</strong><br>Per frode informatica si intende qualsiasi atto di inganno intenzionale teso a procurare un guadagno sleale o illecito che si verifica online a danno di clienti e collaboratori. Spesso, la frode informatica è impiegata per effettuare erogazioni fraudolente di fondi, titoli e materiale o dati confidenziali.</p><p><strong>Furto di identità</strong><br>Il furto di identità è un tipo di frode commessa mediante l’uso di informazioni personali non pubbliche di un altro soggetto senza la sua autorizzazione con il potenziale fine di commettere frodi. Il furto di identità rappresenta una minaccia per la reputazione di Credit Suisse, per il processo di due diligence e per la conoscenza dei soggetti con cui sceglie di svolgere l’attività nonché per la protezione dei dati dei clienti attuali. È considerato un reato negli Stati Uniti, ma può subire un trattamento diverso in altre giurisdizioni.</p>'
		}]
	}
	
	/* DEV NOTE: strings for the link URLs separated by link id; if there are no links make this variable an empty array */
	link_dat = {
		lnk_1:[{
				/* cultural values */
				url:'http://csintra.net/about/en/purpose_values/values.html'
		}],
		lnk_2:[{
				/* Incident Collation Policy (GP-00260) */
				url:'http://my.csintra.net/mypolicies/GP-00260-15009'
		}],
		lnk_3:[{
				/* Disciplinary Policy (GP-01058) */
				url:'http://my.csintra.net/mypolicies/GP-01058-333069'
		}],
		lnk_4:[{
				/* US Cross Border Policy (P-00025) */
				url:'http://my.csintra.net/mypolicies/P-00025-43014'
		}],
		lnk_5:[{
				/* FATCA Policy (GP-00085) */
				url:'http://my.csintra.net/mypolicies/GP-00085-340480'
		}],
		lnk_6:[{
				/* Escalation Policy (GP-00012) */
				url:'http://my.csintra.net/mypolicies/GP-00012-27349'
		}],
		lnk_7:[{
				/* Credit Suisse Integrity Lines (phone and web) */
				url:'https://home.csintra.net/content/divisions-and-functions/en/cco/rc/investigations/integrity-lines.html'
		}],
		lnk_8:[{
				/* Global Block Leave Policy (GP-00387) */
				url:'http://my.csintra.net/mypolicies/GP-00387-27433'
		}],
		lnk_9:[{
				/* Escalation and Identifying Potential Fraud Course Summary */
				url:'images/CS120_course_summary.pdf'
		}],
		lnk_10:[{
				/* Anti-Fraud Policy */
				url:'https://mypolicies.csintra.net/#/overviewComponent/24765/305675/GP-00298/false'
		}],
		lnk_11:[{
				/* Supplemento di segnali d’allarme sul furto di identità (GP-00298 S-03) */
				url:'http://my.csintra.net/mypolicies/GP-00298-S03-367057'
		}],
		lnk_12:[{
				/* Anti-Fraud Global Minimum Standards (AFGMS) */
				url:'https://home.csintra.net/content/dam/assets/divisions-and-functions/documents/crco/dcco/core-compliance/global-anti-fraud-conduct-monitoring/anti-fraud-global-minimum-standards.pdf'					 
		}],
		lnk_13:[{
				/* Change Initiatives */
				url:'https://odyssey.rowini.net/confluence/display/WTE/Anti-Fraud+Global+Minimum+Standards+%28AFGMS%29+to+be+considered+in+Change+Initiatives+in+Wealth+Management'
		}]
	}
	
	/* DEV NOTE: strings for the resource popup title and content */
	resource_dat = {
		resources:[{
				title:'Risorse',				
				text:'<p><strong>I link Intranet potrebbero non essere disponibili tramite l’app Saba Mobile.</strong></p><p><a data-lnk-id="lnk_9" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Sintesi del corso Escalation e individuazione di potenziali frodi</a></p><p><a data-lnk-id="lnk_6" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Direttiva Escalation (GP-00012)</a></p><p><a data-lnk-id="lnk_10" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Direttiva Prevenzione di frodi</a></p><p><a data-lnk-id="lnk_2" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Direttiva di raccolta degli incidenti (GP-00260)</a></p><p><a data-lnk-id="lnk_4" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Direttiva per le attività di Private Banking transfrontaliere con gli Stati Uniti (P-00025)</a></p><p><a data-lnk-id="lnk_5" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Direttiva FATCA (GP-00085)</a></p><p><a data-lnk-id="lnk_3" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Direttiva Azioni disciplinari (GP-01058)</a></p><p><a data-lnk-id="lnk_8" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Direttiva Congedo obbligatorio ininterrotto (GP-00387)</a></p><p><a data-lnk-id="lnk_11" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Supplemento di segnali d’allarme sul furto di identità (GP-00298 S-03)</a></p><p><a data-lnk-id="lnk_7" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Integrity Line di Credit Suisse (linea telefonica e pagina web)</a></p><p><a data-lnk-id="lnk_12" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Standard minimi globali antifrode</a></p>'
		}]
	}

	/* DEV NOTE: strings for LMS errors */
	lms_error_dat = {
		lms_error_1:[{
				text1:'API cannot be found.',
				text2:'The course may not have been launched from an LMS.'
		}]		
	}
});