/* variables used for course-specific text */
/* DEV NOTE indicates that the variable should be updated for the course */

$( document ).ready(function() {

	/* DEV NOTE: strings for course title; courseTitleMenu appears on Menu page and courseTitle appears everywhere else it is used */
	document.courseTitle = "Procédure de transmission par la voie hiérarchique et identification d’une éventuelle fraude";
	document.courseTitleMenu = "Procédure de transmission par la voie hiérarchique et identification d’une éventuelle fraude";

	/* DEV NOTE: strings for topic titles which are used in the pre-test results */
	document.topicTitles = {
		titles:[
			{title:'Introduction'},
			{title:'Transmission à la hiérarchie d’événements sortant de l’ordinaire ou de préoccupations'},
			{title:'Fraude interne'},
			{title:'Fraude externe'},
			{title:'Fraude pendant une analyse'}
		]
	}	
		
	/* DEV NOTE: string for the intro text on the pre-test message that appears asking the learner if they want to take the pre-test; if there is no pre-test make this an empty string */
	document.pretestIntro = ""
	
	/* DEV NOTE: strings for text that is used on the pre-test and post-test intro pages; if there is no pre-test make the pre-test string an empty string; if there is no post-test make the post-test string an empty string */
	test_intro_dat = {
		pre_test:[{
			generic_msg:''
		}],
		post_test:[{
			generic_msg:''
		}]
	}
	
	/* DEV NOTE: strings for text that is used on the pre-test and post-test results page before the score and for the pass and fail messages; if there is no pre-test make the pre-test strings empty strings; if there is no post-test make the post-test strings empty strings */
	test_results_dat = {
		pre_test:[{
			pass_msg:'',			
			pass_msg_2:'',
			pass_msg_3:'',			
			fail_msg_1:'',
			fail_msg_2:'',
			fail_msg_3:''
		}],
		post_test:[{
			generic_msg:'',
			pass_msg:'',
			fail_msg:''
		}]
	}
	
	/* DEV NOTE: strings for text that is used on the attestation page before and after the attesting; if there is no attestation make these empty strings */
	attestation_dat = {		
		attestation:[{
			pre_attesting_msg:'',
			attested_msg:''
		}]
	}
	
	/* DEV NOTE: strings for the transcript titles and content separated by section id; if there are no transcripts make this variable an empty array */
	transcript_dat = {}
	
	/* DEV NOTE: strings for the hotword titles and content separated by hotword id; if there are no hotwords make this variable an empty array */
	hotword_dat = {
		hw_1:[{
				title:'Soupçons de violation de l’Instruction Dispositions US transfrontières (P&#8209;00025) et/ou l’Instruction FATCA (GP&#8209;00085)',
				text:'<p>Les <strong>violations</strong> de l’<a data-lnk-id="lnk_4" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Instruction Dispositions US transfrontières (P-00025)</a> DOIVENT être signalées directement à l’équipe U.S. L&C (pour la Suisse) ou au Program Officer de l’U.S. L&C (responsable local) (pour les autres sites).</p><p>Les <strong>défaillances de contrôle FATCA (y compris les soupçons de violation de</strong> l’<a data-lnk-id="lnk_5" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Instruction FATCA (GP-00085)</a><strong>)</strong> DOIVENT être signalées au FATCA Desk via MICOS dès qu’elles sont identifiées.</p>'
		}],
		hw_2:[{
				title:'Lorsque c’est inapproprié',				
				text:'<p>Si votre supérieur hiérarchique est impliqué dans l’incident ou n’a pas traité l’incident de manière adéquate, ou si vous vous sentez mal à l’aise à l’idée de soulever le problème directement avec ce dernier, vous devez le transmettre à une autre partie (p. ex., autres membres compétents de la direction, Compliance, Human Resources, General Counsel, l’<strong>Integrity Hotline (téléphone)</strong> ou l’<strong>Integrity Line (Web)</strong>). Dans ce cas, vous ne devez pas effectuer de transmission aux personnes qui sont sous la responsabilité de votre supérieur hiérarchique, de manière directe ou indirecte, ou lorsqu’un conflit d’intérêts existe d’une autre façon.</p>'
		}],
		hw_3:[{
				title:'Integrity Hotline (téléphone)',
				text:'<p>L’<strong>Integrity Hotline (téléphone)</strong> est disponible dans le monde entier sept jours sur sept et 24 heures sur 24. Son personnel est formé pour recevoir des appels en anglais, allemand, français ou italien.</p><p>Les événements transmis par l’<strong>Integrity Hotline</strong> sont traités rapidement et en toute discrétion.</p>'
		}],
		hw_4:[{
				title:'Integrity Line (Web)',
				text:'<p>L’<strong>Integrity Line (Web)</strong> est hébergée en externe et disponible 24 heures sur 24.</p><p>Elle vous permet de signaler les événements sortant de l’ordinaire ou les préoccupations via votre ordinateur ou en utilisant votre smartphone ou votre tablette privés.</p><p>Les événements transmis par l’<strong>Integrity Line</strong> sont traités rapidement et en toute discrétion.</p>'
		}],		
		hw_7:[{
				title:'Signaux comportementaux affichés par les perpétrateurs de fraude',
				text:'<ul><li>Agir de façon énigmatique ou nerveusement</li><li>Vivre au-dessus de ses moyens</li><li>Besoin excessif de contrôler, réticence à partager les tâches</li><li>Volonté d’outrepasser les contrôles, souvent pour «simplifier les choses»</li><li>Refus de prendre des vacances ou des arrêts maladie</li><li>Accéder aux locaux et/ou systèmes de la Banque pendant le Block Leave</li><li>Lien inhabituellement proche avec un fournisseur ou un client</li><li>Demander le report des audits ou inspections internes afin de se «préparer de façon adéquate»</li><li>Antécédents d’infractions ou de quasi-infractions aux Instructions</li><li>Difficultés financières</li></ul>'
		}],
		hw_8:[{
				title:'Activité non autorisée',
				text:'<p>Les collaborateurs qui se livrent à des activités non autorisées peuvent afficher les comportements suivants:</p><ul><li>Ont des sources de richesse inexpliquées</li><li>Sont largement impliqués dans des placements spéculatifs</li><li>Ont une addiction au jeu</li><li>Sont en proie à des difficultés financières</li><li>Ont des intérêts commerciaux externes concurrents ou non déclarés</li><li>Outrepassent les contrôles internes</li><li>Refusent de prendre des vacances ou des arrêts maladie et accèdent aux locaux et/ou systèmes de la Banque durant la période de Block Leave</li><li>Affichent des problèmes de contrôle excessifs et ne sont pas disposés à partager les tâches</li><li>Antécédents d’infractions ou de quasi-infractions aux Instructions</li><li>Heures de travail inhabituelles</li></ul>'
		}],
		hw_10:[{
				title:'Principaux points à retenir',
				text:'<p>Dans la plupart des cas, une fraude interne est commise par une personne agissant seule au sein de la Banque et peut être identifiée par des <strong>comportements suspects</strong>, mais il peut s’agir d’une collusion entre des collaborateurs de la Banque. Les comportements suspects incluent:</p><ul><li>Agir de façon énigmatique ou nerveusement</li><li>Réticence à partager les tâches</li><li>Volonté d’outrepasser les contrôles, souvent pour «simplifier les choses»</li><li>Refus de prendre des vacances ou des arrêts maladie</li><li>Accéder aux locaux et/ou systèmes de la Banque pendant une période de Block Leave</li><li>Demander le report des audits ou inspections internes afin de se «préparer de façon adéquate»</li><li>Antécédents d’infractions ou de quasi-infractions aux Instructions</li><li>Heures de travail inhabituelles</li></ul><p><strong>Les exemples de fraude interne incluent:</strong></p><ul><li><strong>Trading non autorisé</strong>, lorsque des collaborateurs exécutent des transactions visant à dissimuler des profits et des pertes</li><li><strong>Activité non autorisée</strong>, lorsque des collaborateurs transfèrent des espèces ou des titres depuis un compte en suspens ou un compte nostro, dans le cadre d’un depot break, ou modifient des relevés de compte</li><li><strong>Transferts de fonds et d’actifs non autorisés</strong>, lorsque des collaborateurs exécutent des transferts de fonds ou d’actifs depuis des comptes clients sans les instructions du client</li><li><strong>Fraude liée au remboursement des notes de frais</strong>, peut comprendre des dépenses erronées, exagérées ou fictives</li></ul></p><p><strong>Les contrôles du Credit Suisse visant à prévenir la fraude interne incluent:</strong></p><p><strong>Séparation des tâches:</strong> Ce contrôle exige qu’une transaction ou un processus obtienne une approbation ou une autorisation supplémentaire. L’objectif est d’éviter la concentration des contrôles, le contournement manuel des contrôles ainsi que la collusion entre collaborateurs de la Banque. Il est impératif qu’il y ait une séparation appropriée des tâches impliquant le dépôt, l’autorisation et le contrôle des documents sources et des enregistrements.</p><p><strong>Vérification par téléphone:</strong> La vérification de l’autorisation, par exemple par téléphone ou avec la signature de transaction, est utilisée pour vérifier les transferts de fonds/actifs (paiements, valeurs mobilières, etc.) ou les demandes de modification de données statiques d’un client ou d’un fournisseur. Pour ce type de demande, il convient de vérifier l’identité du donneur d’ordre ainsi que l’autorisation de transférer les fonds/actifs ou de modifier les données statiques du client/fournisseur, et de réaliser des vérifications d’authenticité afin de déterminer la légitimité de la requête. Veuillez consulter les <a data-lnk-id="lnk_12" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">AFGMS</a> pour en savoir plus.</p>'
		}],
		hw_11:[{
				title:'Principaux points à retenir',
				text:'<p>Dans la plupart des cas, une fraude interne est commise par une personne agissant seule au sein de la Banque et peut être identifiée par des <strong>comportements suspects</strong>, mais il peut s’agir d’une collusion entre des collaborateurs de la Banque. Les comportements suspects incluent:</p><ul><li>Agir de façon énigmatique ou nerveusement</li><li>Réticence à partager les tâches</li><li>Volonté d’outrepasser les contrôles, souvent pour «simplifier les choses»</li><li>Refuser de prendre des vacances, un Block Leave ou des congés maladie</li><li>Accéder aux locaux et/ou systèmes de la Banque pendant une période de Block Leave</li><li>Demander le report des audits ou inspections internes afin de se «préparer de façon adéquate»</li><li>Antécédents d’infractions ou de quasi-infractions aux Instructions</li><li>Heures de travail inhabituelles</li></ul><p><strong>Les exemples de fraude interne incluent:</strong></p><ul><li><strong>Trading non autorisé</strong>, lorsque des collaborateurs exécutent des transactions visant à dissimuler des profits et des pertes</li><li><strong>Activité non autorisée</strong>, lorsque des collaborateurs transfèrent des espèces ou des titres depuis un compte en suspens ou un compte nostro, dans le cadre d’un depot break, ou modifient des relevés de compte</li><li><strong>Transferts de fonds et d’actifs non autorisés</strong>, lorsque des collaborateurs exécutent des transferts de fonds ou d’actifs depuis des comptes clients sans les instructions du client</li><li><strong>Fraude liée au remboursement des notes de frais</strong>, peut comprendre des dépenses erronées, exagérées ou fictives</li></ul><p><strong>Les contrôles de Credit Suisse visant à prévenir la fraude interne incluent:</strong></p><p><strong>Congés pris en une seule fois (Block Leave):</strong> Afin de limiter le risque potentiel de fraude interne, les collaborateurs qui exercent une fonction considérée comme sensible au sens de l’<a data-lnk-id="lnk_8" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Instruction Block Leave (GP-00387)</a> sont tenus de prendre une période de congé de dix jours ouvrables consécutifs au cours d’une année civile. Pendant cette période, les collaborateurs ne doivent pas réaliser de tâches liées à leur fonction, accéder aux locaux de la Banque pour des raisons professionnelles ou utiliser les systèmes de la Banque.</p>'
		}],
		hw_12:[{
				title:'Principaux points à retenir',
				text:'<p>La Banque et ses collaborateurs sont vulnérables face aux risques de fraude externe. Les <strong>principales menaces</strong> que vous pouvez rencontrer <strong>en termes de fraude externe</strong> sont les suivantes:</p><p><strong>Fraude aux moyens de paiement</strong><br>La fraude aux moyens de paiement est le résultat d’une tromperie délibérée visant à convaincre le payeur autorisé d’exécuter un paiement sans l’autorisation du client. La fraude aux moyens de paiement sur Internet utilise différentes formes de cybercriminalité comme moyen d’accéder aux fonds.</p><p><strong>Cybercriminalité</strong><br>La cybercriminalité fait référence à tout type de tromperie délibérée en vue d’obtenir un gain déloyal ou illégal, qui se produit en ligne, et cible les clients et les collaborateurs. Souvent, la cybercriminalité est utilisée pour exécuter des distributions de fonds, de titres et d’informations ou de documents confidentiels de façon frauduleuse.</p><p><strong>Usurpation d’identité</strong><br>L’usurpation d’identité est un type de fraude commise en utilisant les informations personnelles non publiques d’une autre personne sans son autorisation dans le but potentiel de commettre une fraude. L’usurpation d’identité constitue une menace pour la réputation du Credit Suisse en termes de due diligence, de connaissance des personnes avec qui la banque choisit de travailler et de protection des informations des clients existants. L’usurpation d’identité est considérée comme un acte criminel aux États-Unis, mais elle peut faire l’objet d’un traitement différent dans d’autres juridictions.</p>'
		}],
		hw_13:[{
				title:'Principaux points à retenir',
				text:'<p>La Banque et ses collaborateurs sont vulnérables face aux risques de fraude externe. Les <strong>principales menaces</strong> que vous pouvez rencontrer <strong>en termes de fraude externe</strong> sont les suivantes:</p><p><strong>Fraude relative aux déclarations financières</strong><br>La fraude relative aux déclarations financières se produit lorsqu’un client fournit des documents falsifiés afin de donner une représentation erronée de ses actifs et/ou revenus dans le but d’obtenir des produits et services de façon frauduleuse de la part de la Banque. Les exemples de fraude relative aux déclarations financières incluent l’enregistrement de revenus fictifs ou dans des périodes comptables inappropriées, des divulgations inappropriées ou la dissimulation de passifs.</p><p><strong>Fraude en matière de placement</strong><br>Les schémas classiques de fraude en matière de placement se caractérisent par des offres de placement sans risque ou à faible risque, des rendements garantis, des rendements trop constants, des stratégies complexes ou des titres non enregistrés. Parmi les exemples de fraude en matière de placement, citons les systèmes de Ponzi, les systèmes pyramidaux et toute demande de payer des frais de transaction à des fins de placement. </p><p><strong>Utilisation abusive de la marque Credit Suisse</strong><br>L’utilisation abusive de la marque Credit Suisse fait référence à un système de fraude pouvant impliquer des documents falsifiés, des sites Web et des comptes de messagerie frauduleux utilisant abusivement la marque ou le logo Credit Suisse. Le but recherché est de faire en sorte que les documents apparaissent comme un placement ou un produit financier légitime aux yeux des investisseurs potentiels, des banques ou des consommateurs afin qu’ils investissent dans le système de fraude. </p>'
		}],
		hw_14:[{
				title:'Principaux points à retenir',
				text:'<p>La Banque et ses collaborateurs sont vulnérables face aux risques de fraude externe. Les <strong>principales menaces</strong> que vous pouvez rencontrer <strong>en termes de fraude externe</strong> sont les suivantes:</p><p><strong>Fraude aux moyens de paiement</strong><br>La fraude aux moyens de paiement est le résultat d’une tromperie délibérée visant à convaincre le payeur autorisé d’exécuter un paiement sans l’autorisation du client. La fraude aux moyens de paiement sur Internet utilise différentes formes de cybercriminalité comme moyen d’accéder aux fonds.</p><p><strong>Cybercriminalité</strong><br>La cybercriminalité fait référence à tout type de tromperie délibérée en vue d’obtenir un gain déloyal ou illégal, qui se produit en ligne, et cible les clients et les collaborateurs. Souvent, la cybercriminalité est utilisée pour exécuter des distributions de fonds, de titres et d’informations ou de documents confidentiels de façon frauduleuse.</p><p><strong>Usurpation d’identité</strong><br>L’usurpation d’identité est un type de fraude commise en utilisant les informations personnelles non publiques d’une autre personne sans son autorisation dans le but potentiel de commettre une fraude. L’usurpation d’identité constitue une menace pour la réputation du Credit Suisse en termes de due diligence, de connaissance des personnes avec qui la banque choisit de travailler et de protection des informations des clients existants. L’usurpation d’identité est considérée comme un acte criminel aux États-Unis, mais elle peut faire l’objet d’un traitement différent dans d’autres juridictions.</p>'
		}],
		hw_15:[{
				title:'Principaux points à retenir',
				text:'<p>La Banque et ses collaborateurs sont vulnérables face aux risques de fraude externe. Les <strong>principales menaces</strong> que vous pouvez rencontrer <strong>en termes de fraude externe</strong> sont les suivantes:</p><p><strong>Fraude aux moyens de paiement</strong><br>La fraude aux moyens de paiement est le résultat d’une tromperie délibérée visant à convaincre le payeur autorisé d’exécuter un paiement sans l’autorisation du client. La fraude aux moyens de paiement sur Internet utilise différentes formes de cybercriminalité comme moyen d’accéder aux fonds.</p><p><strong>Cybercriminalité</strong><br>La cybercriminalité fait référence à tout type de tromperie délibérée en vue d’obtenir un gain déloyal ou illégal, qui se produit en ligne, et cible les clients et les collaborateurs. Souvent, la cybercriminalité est utilisée pour exécuter des distributions de fonds, de titres et d’informations ou de documents confidentiels de façon frauduleuse.</p><p><strong>Usurpation d’identité</strong><br>L’usurpation d’identité est un type de fraude commise en utilisant les informations personnelles non publiques d’une autre personne sans son autorisation dans le but potentiel de commettre une fraude. L’usurpation d’identité constitue une menace pour la réputation du Credit Suisse en termes de due diligence, de connaissance des personnes avec qui la banque choisit de travailler et de protection des informations des clients existants. L’usurpation d’identité est considérée comme un acte criminel aux États-Unis, mais elle peut faire l’objet d’un traitement différent dans d’autres juridictions.</p>'
		}]
	}
	
	/* DEV NOTE: strings for the link URLs separated by link id; if there are no links make this variable an empty array */
	link_dat = {
		lnk_1:[{
				/* cultural values */
				url:'http://csintra.net/about/en/purpose_values/values.html'
		}],
		lnk_2:[{
				/* Incident Collation Policy (GP-00260) */
				url:'http://my.csintra.net/mypolicies/GP-00260-15009'
		}],
		lnk_3:[{
				/* Disciplinary Policy (GP-01058) */
				url:'http://my.csintra.net/mypolicies/GP-01058-333069'
		}],
		lnk_4:[{
				/* US Cross Border Policy (P-00025) */
				url:'http://my.csintra.net/mypolicies/P-00025-43014'
		}],
		lnk_5:[{
				/* FATCA Policy (GP-00085) */
				url:'http://my.csintra.net/mypolicies/GP-00085-340480'
		}],
		lnk_6:[{
				/* Escalation Policy (GP-00012) */
				url:'http://my.csintra.net/mypolicies/GP-00012-27349'
		}],
		lnk_7:[{
				/* Credit Suisse Integrity Lines (phone and web) */
				url:'https://home.csintra.net/content/divisions-and-functions/en/cco/rc/investigations/integrity-lines.html'
		}],
		lnk_8:[{
				/* Global Block Leave Policy (GP-00387) */
				url:'http://my.csintra.net/mypolicies/GP-00387-27433'
		}],
		lnk_9:[{
				/* Escalation and Identifying Potential Fraud Course Summary */
				url:'images/CS120_course_summary.pdf'
		}],
		lnk_10:[{
				/* Anti-Fraud Policy */
				url:'https://mypolicies.csintra.net/#/overviewComponent/24765/305675/GP-00298/false'
		}],
		lnk_11:[{
				/* Identity Theft Red Flags Supplement (GP-00298 S-03) */
				url:'http://my.csintra.net/mypolicies/GP-00298-S03-367057'
		}],
		lnk_12:[{
				/* Anti-Fraud Global Minimum Standards (AFGMS) */
				url:'https://home.csintra.net/content/dam/assets/divisions-and-functions/documents/crco/dcco/core-compliance/global-anti-fraud-conduct-monitoring/anti-fraud-global-minimum-standards.pdf'					 
		}],
		lnk_13:[{
				/* Change Initiatives */
				url:'https://odyssey.rowini.net/confluence/display/WTE/Anti-Fraud+Global+Minimum+Standards+%28AFGMS%29+to+be+considered+in+Change+Initiatives+in+Wealth+Management'
		}]
	}
	
	/* DEV NOTE: strings for the resource popup title and content */
	resource_dat = {
		resources:[{
				title:'Ressources',				
				text:'<p><strong>Les liens Intranet peuvent ne pas être disponibles sur l’application mobile Saba.</strong></p><p><a data-lnk-id="lnk_9" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Résumé de la formation sur la procédure de transmission par la voie hiérarchique et l’identification d’une éventuelle fraude</a></p><p><a data-lnk-id="lnk_6" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Instruction «Escalation» (GP-00012)</a></p><p><a data-lnk-id="lnk_10" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Instruction Lutte contre la fraude </a></p><p><a data-lnk-id="lnk_2" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Instruction Recensement des événements (GP-00260) </a></p><p><a data-lnk-id="lnk_4" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Instruction Dispositions US transfrontières (P-00025)</a></p><p><a data-lnk-id="lnk_5" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Instruction FATCA (GP-00085)</a></p><p><a data-lnk-id="lnk_3" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Instruction Risque de conduite (GP-01058)</a></p><p><a data-lnk-id="lnk_8" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Instruction Block Leave (GP-00387)</a></p><p><a data-lnk-id="lnk_11" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Supplément Identity Theft Red Flags (GP-00298 S-03)</a></p><p><a data-lnk-id="lnk_7" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Integrity Lines du Credit Suisse (téléphone et Web)</a></p><p><a data-lnk-id="lnk_12" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Normes minimales mondiales Anti-Fraude (Anti-Fraud Global Minimum Standards)</a></p>'
		}]
	}

	/* DEV NOTE: strings for LMS errors */
	lms_error_dat = {
		lms_error_1:[{
				text1:'API cannot be found.',
				text2:'The course may not have been launched from an LMS.'
		}]		
	}
});