/* variables used for configuration and storing of course data */
/* DEV NOTE indicates that the variable should be updated for the course */

var isiPad;
var isiPhone;
var isWeb;
var isIE;
var isAndroidTablet;
var isAndroidPhone;
var androidApp = false;
var iOSApp = false;
var isIE8 = false;
var	isMob = false;
var orient;
var desktop_testing;
var video_location;
var video_data;
var index = true;
var bookmarkInterval = "";

var useAICCRules = false; /* AICC rules - no reference to window.top for cross platform compatibility; no interface close button as it uses window.top.close; minimal commits to LMS */
var startTime = 0; /* integer for the time when the timer was started and if set to 0 means not currently tracking time */
var sessionTime = 0; /* string for the cumulative session time in seconds i.e. the time the course is open. */
var commitTimer = true; /* boolean used for interval set at the beginning of lock.js */

document.lesson_location_retrieved = false; /* boolean has the lesson_location been retrieved */
document.bookmarkNavDone = false; /* boolean has the check for bookmark completed */
document.intComplete = false; /* boolean have the interactions been completed */
document.audioComplete = false; /* boolean has the audio completed */
document.trackingArr = []; /* array to be populated with suspend data from LMS */
document.currentSection; /* integer for current section the user is viewing */
document.attestationAttempted = false; /* boolean for if the attestation has been attempted */
document.pretestAttempted = 0; /* integer where the pre-test has been attempted = 1, the pre-test not attempted = 0 */
document.takingPretest = false; /* boolean for if currently in the pre-test */
document.pretestDone = true; /* boolean for if we are done with the pre-test used to ensure it does not bookmark upon leaving it */
document.test_score = 0; /* integer for the score obtained in the pre-test/post-test in points */
document.assessPercentageScore = 0;  /* integer for the score obtained in the pre-test/post-test in percentage */
document.assessAttempted = false; /* boolean has the post-test been attempted */
document.assessRandomQuesArr = []; /* array of section id numbers for the questions in the pre-test/post-test from the first question to the results page */
document.assessStartQuesArr = []; /* array of section id numbers for the first question available for the pre-test/post-test in each bank */
document.assessEndQuesArr = [];	/* array of section id numbers for the last question available for the pre-test/post-test in each bank */
document.assessSelectQuesArr = []; /* array of number of questions to select for the pre-test/post-test from each bank */
document.assessTopicHasQBank = []; /* array of indicators if if a topic has a question bank where topic has a bank = 1, topic does not have a bank = 0 */
document.assessTotalQues = 0; /* integer for the total questions required in the pre-test/post-test */
document.assessQuesDownArrowClicked = []; /* array of indicators if pre-test/post-test trickle button has been clicked */
document.currentAssessQues = 0;	/* integer for the current question in the pre-test/post-test */
document.inlineNumOfAttempts = 0; /* integer which is incremented when trying question again */

/* DEV NOTE: integer where there is an attestation in the course = 1, there is no attestation = 0 */
document.attestationPresent = 0;

/* DEV NOTE: integer where there is a pre-test in the course = 1, there is no pre-test = 0; set to 0 if there is no post-test or attestation */
document.pretestPresent = 0;

/* DEV NOTE: integer for total number of topics in the course including pre-test/post-test topic at the end */
document.topicsCount = 5;

/* DEV NOTE: integer for total number of screens from the first Topic Intro to the pre-test/post-test Test Results or last section id of the course inclusive */
document.subsectionCount = 38;

/* DEV NOTE: integer for section id number of the pre-test/post-test Test Intro screen; set to null if there is no post-test */
document.testIntroSubsection = null;

/* DEV NOTE: section id number of the pre-test/post-test Test Results screen; set to null if there is no post-test */
document.testResultsSubsection = null;

/* DEV NOTE: string where a topic has been tested out of = 1, a topic has not been tested out of = 0, initially all 0s; set this even if there is no pre-test */
document.topicsPretestedOut = "00000";

/* DEV NOTE: array of count of how many questions were answered correctly for a topic during the pre-test, initially all comma-separated 0s; set this even if there is no pre-test */
document.topicsPretestQuesCorArr = [0,0,0,0,0];

/* DEV NOTE: boolean where content pages are locked down = true, content pages are unlocked = false */
document.courseLockedDown = true;

/* DEV NOTE: boolean where the menu is locked down = true, menu is unlocked = false; if there is a pre-test then this must be set to true */
document.menuLockedDown = true;

/* DEV NOTE: boolean where slider is locked on first and last slides, slider locked = true, slider can loop = false */
document.sliderLinear = true;

/* DEV NOTE: boolean where audio locked down = true, audio unlocked = false */
document.audioLocked = true;

/* DEV NOTE: boolean where video locked down = true, video unlocked = false */
document.videoLocked = false;

/* DEV NOTE: boolean to enable or disable transitions within the course, these should not be enabled if the course is to support tablet and/or phone as this support has not yet been tested */
/* Current transitions:
Topics fade in one at a time
Question display text fades in when question is submitted
Expando display grows down on click of expando item
Expando display grows up on click of another expando item
Topic images scale up/down on rollover/out
Hotspot images scale up/down on rollover/out
*/
document.useTransitions = true;

/* DEV NOTE: boolean to check all pages are viewed as part of the course completion criteria, check pages viewed = true, do not check pages viewed = false, if there is an attestation or pre-test, or when there is no attestation, no pre-test and no post-test this must be set to true */
document.trackPagesViewed = true;

/* DEV NOTE: array where screen locked = 1, screen unlocked = 0, screen shows trickle button regardless of locked/unlocked but will not show for the last page in a topic = 2; the Menu counts as the first screen */
document.lockedArr = [0,
					  0,1,0,0,0, /* T1 */
					  0,0,0,0,0, /* T2 */
					  0,1,0,1,1,0,1,0,1,0, /* T3 */
					  0,0,1,1,0,1,1,0,1,0, /* T4 */
					  0,0,0,1,1,1,0]; /* T5 */

/* DEV NOTE: array where screen contains a video, slider, hotspots, hotwords, expando or question = 1, screen is static = 0; the Menu counts as the first screen */
document.intArr = [0,
				   0,1,0,0,0, /* T1 */
				   0,0,0,0,0, /* T2 */
				   0,1,0,1,1,0,1,0,1,0, /* T3 */
				   0,0,1,1,0,1,1,0,1,0, /* T4 */
				   0,0,0,1,1,1,0]; /* T5 */

/* DEV NOTE: array for number of clickable items in page including hotwords and links for page completion. Slider screens use string "number of click, number of hotwords, number of links" */
document.clickArr = [0,
					 0,"5,0,0",0,0,0, /* T1 */
					 0,0,0,0,0, /* T2 */
					 0,"3,0,0",0,3,"3,0,0",0,1,0,1,0, /* T3 */
					 0,0,7,2,0,1,1,0,1,0, /* T4 */
					 0,0,0,1,"6,0,0",6,0]; /* T5 */

/* DEV NOTE: array for audio file to play on this screen excluding .mp3 */
document.audioSrcArr = ['','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',''];

/* DEV NOTE: array where screen contains audio = 1, screen does not contain audio = 0; the Menu counts as the first screen */
document.audioArr = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];

/* DEV NOTE: array for number of reflection screens in each topic */
document.reflectionsArr = [0,1,0,0,1];

/* DEV NOTE: array to indicate which topics have wide menu tiles on the home screen where wide tile = 1, no wide title = 0; only the first topic is supported at this time */
document.wideTileArr = [0,0,0,0,0];

/* DEV NOTE: boolean for if inline questions should be answered correctly before unlocking the page, i.e. try again is enabled */
document.inlineQuesTryAgain = true;

/* DEV NOTE: boolean for showing 1st incorrect feedback on first incorrect attempt and 2nd incorrect feedback for all subequent incorrect attempts; document.inlineQuesTryAgain must be set to true */
document.inlineQuesTryAgainTwoFB = true;

/* DEV NOTE: integer for maximum number of attempts a user has to answer an inline question before page is unlocked; document.inlineQuesTryAgain must be set to true; also works with document.inlineQuesTryAgainTwoFB to show two levels of feedback */
document.inlineQuesMaxAttempts = 0;

/* DEV NOTE: integer for post-test passing mark required only i.e. 80; pre-test always uses 100 and this is not defined in config.js; set to 0 if there is no post-test */
document.assessPassmark = 0;

/* DEV NOTE: randomize the pre-test/post-test questions = true and do not randomize them = false; if a selection of questions from bank(s) is to be made then this must be true; set to false if there is no post-test */
document.assessRandomize = true;

/* DEV NOTE: randomize the pre-test/post-test question options = true and do not randomize them = false; set to false if there is no post-test */
document.assessOptRandomize = false;

/* DEV NOTE: show partially correct for inline questions = true and do not show it = false */
document.partial_feedback_inline = false;

/* DEV NOTE: show partially correct for post-test questions = true and do not show it = false; this cannot be used when there is a pre-test and must then be set to false; set to false if there is no post-test */
document.partial_scoring_assess = false;

/* DEV NOTE: boolean as to whether the course has a splash video on the menu screen */
document.hasSplashVideo = false;

/* DEV NOTE: boolean for should the badges be track in the LMS */
document.trackBadges = false;

/* DEV NOTE: string used to track badges for each inline question to LMS; a 0 for each inline question to track separated by | i.e. 0|0 */
document.badgeData = "";

/* inline question data */
inline_ques_dat = {
	sec_18:[{ 					/* DEV NOTE: section id for the screen containing the inline question */
			type:'mcsa', 		/* DEV NOTE: string for type of inline question, either mcsa or mcma */
			ans:'0,0,1,0', 		/* DEV NOTE: string where option is correct = 1, option is not correct = 0 */
			user_ans:'0,0,0,0', 	/* DEV NOTE: string always of 0s to match the length of the ans */
			ans_once:'0', 		/* DEV NOTE: string of always 0 to store if the question was answered already in this session for use with the try again feature */
			topic_num:'3' 		/* DEV NOTE: string for topic containing this inline question */			
	}],	
	sec_20:[{
			type:'mcma',
			ans:'0,1,0,1',
			user_ans:'0,0,0,0',
			ans_once:'0',
			topic_num:'3'
	}],
	sec_27:[{
			type:'mcsa',
			ans:'1,0,0,0',
			user_ans:'0,0,0,0',
			ans_once:'0',
			topic_num:'4'
	}],
	sec_28:[{
			type:'mcma',
			ans:'0,1,0,1',
			user_ans:'0,0,0,0',
			ans_once:'0',
			topic_num:'4'
	}],
	sec_30:[{
			type:'mcsa',
			ans:'0,1,0,1',
			user_ans:'0,0,0,0',
			ans_once:'0',
			topic_num:'4'
	}],	
	sec_35:[{
			type:'mcsa',
			ans:'0,0,0,1',
			user_ans:'0,0,0,0',
			ans_once:'0',
			topic_num:'5'
	}]
}

/* pre-test/post-test question data */
post_test_ques_dat = {
	/* DEV NOTE: pre-test/post-test questions MUST be in order of banks, i.e. topic_num 1 questions first, then topic_num 2 questions, etc. */
	
}

/* javascript files to be loaded for the course */
defaultFileArray = new Array(
	['js/screen_detection.js','true']
);
requiredFileArray = new Array(
	['js/jquery.mobile.custom.js','!isWeb'],
	['js/jquery-ui.js','true'],
	['js/lock.js','true'],
	['js/course_strings.js','true'],
	['js/lang_strings.js','true'],
	['js/index_vid_full.js','true'],
	['js/mobile.js','true'],
	['js/video.js','true'],
	['js/audio.js','true'],
	['js/topic_nav.js','true'],
	['js/scroll_activity.js','true'],
	['js/sliders.js','true'],
	['js/hotspot.js','true'],
	['js/box.js','true'],
	['js/hotword.js','true'],
	['js/expando.js','true'],
	['js/question.js','true'],
	['js/imported.js','true'],
	['js/tracking_settings.js','true'],
	['js/tracking.js','true'],
	['js/lms_cs/course_settings.js','true'],
	['js/lms_cs/error_strings.js','true'],
	['js/lms_cs/scorm_1_2.js','true'],				
	['js/transitions.js','true'],
	['js/start.js','true']
);
