/* variables used for course-specific text */
/* DEV NOTE indicates that the variable should be updated for the course */

$( document ).ready(function() {

	/* DEV NOTE: strings for course title; courseTitleMenu appears on Menu page and courseTitle appears everywhere else it is used */
	document.courseTitle = "Escalation and Identifying Potential Fraud";
	document.courseTitleMenu = "Escalation and Identifying Potential Fraud";

	/* DEV NOTE: strings for topic titles which are used in the pre-test results */
	document.topicTitles = {
		titles:[
			{title:'Introduction'},
			{title:'Escalation of unusual incidents or concerns'},
			{title:'Internal fraud'},
			{title:'External fraud'},
			{title:'Fraud in review'}
		]
	}	
		
	/* DEV NOTE: string for the intro text on the pre-test message that appears asking the learner if they want to take the pre-test; if there is no pre-test make this an empty string */
	document.pretestIntro = ""
	
	/* DEV NOTE: strings for text that is used on the pre-test and post-test intro pages; if there is no pre-test make the pre-test string an empty string; if there is no post-test make the post-test string an empty string */
	test_intro_dat = {
		pre_test:[{
			generic_msg:''
		}],
		post_test:[{
			generic_msg:''
		}]
	}
	
	/* DEV NOTE: strings for text that is used on the pre-test and post-test results page before the score and for the pass and fail messages; if there is no pre-test make the pre-test strings empty strings; if there is no post-test make the post-test strings empty strings */
	test_results_dat = {
		pre_test:[{
			pass_msg:'',			
			pass_msg_2:'',
			pass_msg_3:'',			
			fail_msg_1:'',
			fail_msg_2:'',
			fail_msg_3:''
		}],
		post_test:[{
			generic_msg:'',
			pass_msg:'',
			fail_msg:''
		}]
	}
	
	/* DEV NOTE: strings for text that is used on the attestation page before and after the attesting; if there is no attestation make these empty strings */
	attestation_dat = {		
		attestation:[{
			pre_attesting_msg:'',
			attested_msg:''
		}]
	}
	
	/* DEV NOTE: strings for the transcript titles and content separated by section id; if there are no transcripts make this variable an empty array */
	transcript_dat = {}
	
	/* DEV NOTE: strings for the hotword titles and content separated by hotword id; if there are no hotwords make this variable an empty array */
	hotword_dat = {
		hw_1:[{
				title:'Suspected violations of US Cross Border Policy (P-00025) and/or FATCA Policy (GP-00085)',
				text:'<p><a data-lnk-id="lnk_4" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">US Cross Border Policy (P-00025)</a> <strong>violations</strong> MUST be reported directly to the U.S. L&C team (for Switzerland) or to the local responsible U.S. L&C Program Officer (for other locations).</p><p><strong>FATCA control deficiencies (including any suspected violations of</strong> <a data-lnk-id="lnk_5" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">FATCA Policy (GP-00085)</a><strong>)</strong> MUST be reported immediately upon observation to the FATCA Desk through MICOS.</p>'
		}],
		hw_2:[{
				title:'When it is inappropriate',				
				text:'<p>If your line manager is involved in the incident or has failed to address the incident appropriately, or you are uncomfortable raising the matter directly, you must escalate to another party (e.g., other appropriate management, Compliance, Human Resources, General Counsel, or the <strong>Integrity Hotline (phone)</strong> or <strong>Integrity Line (web)</strong>). In such situations, you must not escalate to individuals who report to your line manager, directly or indirectly, or where there is otherwise a conflict of interest.</p>'
		}],
		hw_3:[{
				title:'Integrity Hotline (phone)',
				text:'<p>The <strong>Integrity Hotline (phone)</strong> is available globally 24 hours a day, 7 days a week, and is staffed by trained personnel who can take calls in English, German, French, or Italian.</p><p>Incidents escalated via the <strong>Integrity Hotline</strong> are dealt with promptly and discreetly.</p>'
		}],
		hw_4:[{
				title:'Integrity Line (web)',
				text:'<p>The <strong>Integrity Line (web)</strong> is externally hosted and available around the clock.</p><p>It allows you to report unusual incidents or concerns via your personal computer as well as by using your private smartphone or tablet.</p><p>Incidents escalated via the <strong>Integrity Line</strong> are dealt with promptly and discreetly.</p>'
		}],		
		hw_7:[{
				title:'Behavioral red flags displayed by fraudsters',
				text:'<ul><li>Being secretive or nervous</li><li>Living beyond means</li><li>Control issues, unwillingness to share duties</li><li>Willingness to override controls, often to “make things easier”</li><li>Refusal to take vacation, or sick leave</li><li>Accessing the Bank’s premises and/or systems during block leave</li><li>Unusually close association with a vendor, client</li><li>Requesting to defer internal audits or inspections to “properly prepare”</li><li>Previous history of policy breaches or near-breaches</li><li>Financial difficulties</li></ul>'
		}],
		hw_8:[{
				title:'Unauthorized activity',
				text:'<p>Personnel engaged in unauthorized activity may display the following behaviors:</p><ul><li>Have unexplained sources of wealth</li><li>Are extensively involved in speculative investments</li><li>Have a gambling addiction</li><li>Are experiencing financial difficulties</li><li>Have competing or undeclared external business interests</li><li>Override internal controls</li><li>Refuse to take vacation, sick leave, and who access the Bank’s premises and/or systems during block leave period</li><li>Display excessive control issues and are unwilling to share duties</li><li>Previous history of policy breaches or near-breaches</li><li>Unusual work hours</li></ul>'
		}],
		hw_10:[{
				title:'Key learning points',
				text:'<p>In most cases, internal fraud is committed by one person acting alone within the Bank and can be identified through <strong>suspicious behaviors</strong>, but it can occur through the collusion between Bank personnel. Suspicious behaviors include:</p><ul><li>Being secretive or nervous</li><li>Unwillingness to share duties</li><li>Willingness to override controls, often to “make things easier”</li><li>Refusal to take vacation, or sick leave</li><li>Accessing the Bank’s premises and/or systems during a block leave period</li><li>Requesting to defer internal audits or inspections to “properly prepare”</li><li>Previous history of policy breaches or near-breaches</li><li>Unusual work hours</li></ul><p><strong>Examples of internal fraud include:</strong></p><ul><li><strong>Unauthorized trading</strong> occurs when personnel execute trades to hide profits and losses</li><li><strong>Unauthorized activity</strong> occurs when personnel transfer cash or securities from a suspense or nostro account, or depot break, or amends account statements</li><li><strong>Unauthorized funds and assets transfers</strong> occur when personnel execute funds or assets transfers from client accounts without client instructions</li><li><strong>Expense reimbursement fraud</strong> can be made up of mischaracterized, overstated, or fictitious expenses</li></ul></p><p><strong>Credit Suisse controls to deter internal fraud include:</strong></p><p><strong>Segregation of duties:</strong> This requires additional  approval or authorization for a transaction or process. The aim is to prevent domination of controls, manual override of controls, or collusion between Bank personnel. It is imperative that there are adequate segregation of duties involving custody, authorization, and control of source documents and records.</p><p><strong>Call-back verification:</strong> The verification of authority for e.g., via call-back or transaction signing is used to verify transfer of funds/assets (i.e., payments, securities) or requests for changes to client or vendor static data. For such requests, an identity check of the instructing party; an authority check i.e., the right to move funds/assets or changes to client/vendor static data and authenticity checks must be performed to determine legitimacy of the instruction details. For further information please refer to the <a data-lnk-id="lnk_12" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">AFGMS</a>.</p>'
		}],
		hw_11:[{
				title:'Key learning points',
				text:'<p>In most cases, internal fraud is committed by one person acting alone within the Bank and can be identified through <strong>suspicious behaviors</strong>, but it  can occur through the collusion between Bank personnel. Suspicious behaviors include:</p><ul><li>Being secretive or nervous</li><li>Unwillingness to share duties</li><li>Willingness to override controls, often to “make things easier”</li><li>Refusal to take vacation, block leave, or sick leave</li><li>Accessing the Bank’s premises and/or systems during a block leave period</li><li>Requesting to defer internal audits or inspections to “properly prepare”</li><li>Previous history of policy breaches or near-breaches</li><li>Unusual work hours</li></ul><p><strong>Examples of internal fraud include:</strong></p><ul><li><strong>Unauthorized trading</strong> occurs when personnel execute trades to hide profits and losses</li><li><strong>Unauthorized activity</strong> occurs when personnel transfer cash or securities from a suspense or nostro account, or depot break, or amends account statements</li><li><strong>Unauthorized funds and assets transfers</strong> occur when personnel execute funds or assets transfers from client accounts without client instructions</li><li><strong>Expense reimbursement fraud</strong> can be made up of mischaracterized, overstated, or fictitious expenses</li></ul><p><strong>Credit Suisse controls to deter internal fraud which include:</strong></p><p><strong>Block Leave:</strong> To mitigate the potential risk of internal fraud, designated sensitive employees under the <a data-lnk-id="lnk_8" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Global Block Leave Policy (GP-00387)</a> must take a leave period of 10 consecutive business days within a calendar year and in doing so, employees must not perform duties relating to their role, access any Bank premises for business purposes, or use Bank systems.</p>'
		}],
		hw_12:[{
				title:'Key learning points',
				text:'<p>The Bank and its personnel are vulnerable to external fraud risks. <strong>Key external fraud threats</strong> you may encounter include:</p><p><strong>Payment fraud</strong><br>Payment fraud is a result of a deliberate deception to convince the authorized payer to execute a payment without client authorization. Cyber-enabled payment fraud uses various forms of cyber fraud as a vehicle to access the funds.</p><p><strong>Cyber fraud</strong><br>Cyber fraud refers to any type of deliberate deception for unfair or unlawful gain that occurs online, targeting clients and personnel. Oftentimes, cyber fraud is used to execute fraudulent disbursements of funds, securities, and confidential data or material.</p><p><strong>Identity theft</strong><br>Identity theft is a type of fraud committed using the personal non-public information of another individual without their authorization with the potential purpose of committing fraud. Identity theft poses a threat to Credit Suisse’s reputation for its due diligence and knowing whom it chooses to conduct business and for safeguarding existing client information. Identity theft is considered a crime in the United States but may be treated differently in other jurisdictions.</p>'
		}],
		hw_13:[{
				title:'Key learning points',
				text:'<p>The Bank and its personnel are vulnerable to external fraud risks. <strong>Key external fraud threats</strong> you may encounter include:</p><p><strong>Financial statement fraud</strong><br>Financial statement fraud occurs where a client provides falsified documentation to misrepresent his or her assets and/or revenues to obtain products and services from the Bank. Examples of financial statement fraud schemes include recording of fictitious revenue or in improper account periods, improper disclosures, or concealment of liabilities.</p><p><strong>Investment fraud</strong><br>The typical investment fraud schemes are characterized by offers of low- or no-risk investments, guaranteed returns, overly consistent returns, complex strategies, or unregistered securities. Examples of investment fraud may include Ponzi schemes, pyramid schemes and a request to pay a processing fee in order to invest. </p><p><strong>Credit Suisse brand misuse</strong><br>Credit Suisse brand misuse refers to a fraud scheme which may involve falsified documents, fraudulent websites and e-mail accounts misusing the Credit Suisse brand or logo. The intention is to make the documents appear as a legitimate investment or financial product to potential investors, banks, or consumers so they invest in the fraud scheme. </p>'
		}],
		hw_14:[{
				title:'Key learning points',
				text:'<p>The Bank and its personnel are vulnerable to external fraud risks. <strong>Key external fraud threats</strong> you may encounter include:</p><p><strong>Payment fraud</strong><br>Payment fraud is a result of a deliberate deception to convince the authorized payer to execute a payment without client authorization. Cyber-enabled payment fraud uses various forms of cyber fraud as a vehicle to access the funds.</p><p><strong>Cyber fraud</strong><br>Cyber fraud refers to any type of deliberate deception for unfair or unlawful gain that occurs online, targeting clients and personnel. Oftentimes, cyber fraud is used to execute fraudulent disbursements of funds, securities, and confidential data or material.</p><p><strong>Identity theft</strong><br>Identity theft is a type of fraud committed using the personal non-public information of another individual without their authorization with the potential purpose of committing fraud. Identity theft poses a threat to Credit Suisse’s reputation for its due diligence and knowing whom it chooses to conduct business and for safeguarding existing client information. Identity theft is considered a crime in the United States but may be treated differently in other jurisdictions.</p>'
		}],
		hw_15:[{
				title:'Key learning points',
				text:'<p>The Bank and its personnel are vulnerable to external fraud risks. Key external fraud threats you may encounter include:</p><p><strong>Payment fraud</strong><br>Payment fraud is a result of a deliberate deception to convince the authorized payer to execute a payment without client authorization. Cyber-enabled payment fraud uses various forms of cyber fraud as a vehicle to access the funds.</p><p><strong>Cyber fraud</strong><br>Cyber fraud refers to any type of deliberate deception for unfair or unlawful gain that occurs online, targeting clients and personnel. Oftentimes, cyber fraud is used to execute fraudulent disbursements of funds, securities, and confidential data or material.</p><p><strong>Identity theft</strong><br>Identity theft is a type of fraud committed using the personal non-public information of another individual without their authorization with the potential purpose of committing fraud. Identity theft poses a threat to Credit Suisse’s reputation for its due diligence and knowing whom it chooses to conduct business and for safeguarding existing client information. Identity theft is considered a crime in the United States but may be treated differently in other jurisdictions.</p>'
		}]
	}
	
	/* DEV NOTE: strings for the link URLs separated by link id; if there are no links make this variable an empty array */
	link_dat = {
		lnk_1:[{
				/* cultural values */
				url:'http://csintra.net/about/en/purpose_values/values.html'
		}],
		lnk_2:[{
				/* Incident Collation Policy (GP-00260) */
				url:'http://my.csintra.net/mypolicies/GP-00260-15009'
		}],
		lnk_3:[{
				/* Disciplinary Policy (GP-01058) */
				url:'http://my.csintra.net/mypolicies/GP-01058-333069'
		}],
		lnk_4:[{
				/* US Cross Border Policy (P-00025) */
				url:'http://my.csintra.net/mypolicies/P-00025-43014'
		}],
		lnk_5:[{
				/* FATCA Policy (GP-00085) */
				url:'http://my.csintra.net/mypolicies/GP-00085-340480'
		}],
		lnk_6:[{
				/* Escalation Policy (GP-00012) */
				url:'http://my.csintra.net/mypolicies/GP-00012-27349'
		}],
		lnk_7:[{
				/* Credit Suisse Integrity Lines (phone and web) */
				url:'https://home.csintra.net/content/divisions-and-functions/en/cco/rc/investigations/integrity-lines.html'
		}],
		lnk_8:[{
				/* Global Block Leave Policy (GP-00387) */
				url:'http://my.csintra.net/mypolicies/GP-00387-27433'
		}],
		lnk_9:[{
				/* Escalation and Identifying Potential Fraud Course Summary */
				url:'images/CS120_course_summary.pdf'
		}],
		lnk_10:[{
				/* Anti-Fraud Policy */
				url:'https://mypolicies.csintra.net/#/overviewComponent/24765/305675/GP-00298/false'
		}],
		lnk_11:[{
				/* Identity Theft Red Flags Supplement (GP-00298 S-03) */
				url:'http://my.csintra.net/mypolicies/GP-00298-S03-367057'
		}],
		lnk_12:[{
				/* Anti-Fraud Global Minimum Standards (AFGMS) */
				url:'https://home.csintra.net/content/dam/assets/divisions-and-functions/documents/crco/dcco/core-compliance/global-anti-fraud-conduct-monitoring/anti-fraud-global-minimum-standards.pdf'					 
		}],
		lnk_13:[{
				/* Change Initiatives */
				url:'https://odyssey.rowini.net/confluence/display/WTE/Anti-Fraud+Global+Minimum+Standards+%28AFGMS%29+to+be+considered+in+Change+Initiatives+in+Wealth+Management'
		}]
	}
	
	/* DEV NOTE: strings for the resource popup title and content */
	resource_dat = {
		resources:[{
				title:'Resources',				
				text:'<p><strong>Intranet links might not be available over the Saba Mobile App.</strong></p><p><a data-lnk-id="lnk_9" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Escalation and Identifying Potential Fraud Course Summary</a></p><p><a data-lnk-id="lnk_6" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Escalation Policy (GP-00012)</a></p><p><a data-lnk-id="lnk_10" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Anti-Fraud Policy</a></p><p><a data-lnk-id="lnk_2" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Incident Collation Policy (GP-00260)</a></p><p><a data-lnk-id="lnk_4" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">US Cross Border Policy (P-00025)</a></p><p><a data-lnk-id="lnk_5" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">FATCA Policy (GP-00085)</a></p><p><a data-lnk-id="lnk_3" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Disciplinary Policy (GP-01058)</a></p><p><a data-lnk-id="lnk_8" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Global Block Leave Policy (GP-00387)</a></p><p><a data-lnk-id="lnk_11" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Identity Theft Red Flags Supplement (GP-00298 S-03)</a></p><p><a data-lnk-id="lnk_7" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Credit Suisse Integrity Lines (phone and web)</a></p><p><a data-lnk-id="lnk_12" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Anti-Fraud Global Minimum Standards</a></p>'
		}]
	}

	/* DEV NOTE: strings for LMS errors */
	lms_error_dat = {
		lms_error_1:[{
				text1:'API cannot be found.',
				text2:'The course may not have been launched from an LMS.'
		}]		
	}
});