/* variables used for course-specific text */
/* DEV NOTE indicates that the variable should be updated for the course */

$( document ).ready(function() {

	/* DEV NOTE: strings for course title; courseTitleMenu appears on Menu page and courseTitle appears everywhere else it is used */
	document.courseTitle = "Eskalation und Identifizierung von potenziellem Betrug";
	document.courseTitleMenu = "Eskalation und Identifizierung von potenziellem Betrug";

	/* DEV NOTE: strings for topic titles which are used in the pre-test results */
	document.topicTitles = {
		titles:[
			{title:'Einleitung'},
			{title:'Eskalation von ungewöhnlichen Ereignissen oder Bedenken'},
			{title:'Interner Betrug'},
			{title:'Externer Betrug'},
			{title:'Betrug im Überblick'}
		]
	}	
		
	/* DEV NOTE: string for the intro text on the pre-test message that appears asking the learner if they want to take the pre-test; if there is no pre-test make this an empty string */
	document.pretestIntro = ""
	
	/* DEV NOTE: strings for text that is used on the pre-test and post-test intro pages; if there is no pre-test make the pre-test string an empty string; if there is no post-test make the post-test string an empty string */
	test_intro_dat = {
		pre_test:[{
			generic_msg:''
		}],
		post_test:[{
			generic_msg:''
		}]
	}
	
	/* DEV NOTE: strings for text that is used on the pre-test and post-test results page before the score and for the pass and fail messages; if there is no pre-test make the pre-test strings empty strings; if there is no post-test make the post-test strings empty strings */
	test_results_dat = {
		pre_test:[{
			pass_msg:'',			
			pass_msg_2:'',
			pass_msg_3:'',			
			fail_msg_1:'',
			fail_msg_2:'',
			fail_msg_3:''
		}],
		post_test:[{
			generic_msg:'',
			pass_msg:'',
			fail_msg:''
		}]
	}
	
	/* DEV NOTE: strings for text that is used on the attestation page before and after the attesting; if there is no attestation make these empty strings */
	attestation_dat = {		
		attestation:[{
			pre_attesting_msg:'',
			attested_msg:''
		}]
	}
	
	/* DEV NOTE: strings for the transcript titles and content separated by section id; if there are no transcripts make this variable an empty array */
	transcript_dat = {}
	
	/* DEV NOTE: strings for the hotword titles and content separated by hotword id; if there are no hotwords make this variable an empty array */
	hotword_dat = {
		hw_1:[{
				title:'Vermuteten Verletzungen der Weisung zu grenzüberschreitenden US-Geschäftsaktivitäten (P-00025) und/oder der FATCA-Weisung (GP-00085)',
				text:'<p><strong>Verletzungen</strong> der <a data-lnk-id="lnk_4" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Weisung zu grenzüberschreitenden US-Geschäftsaktivitäten für das Private-Banking-Geschäft (P-00025)</a> MÜSSEN direkt an das US L&C Team (für die Schweiz) oder an den lokalen US L&C Program Officer/Programmbeauftragte(r) (für andere Standorte) gemeldet werden.</p><p><strong>FATCA-Kontrollmängel (einschliesslich aller mutmasslichen Verletzungen der </strong><a data-lnk-id="lnk_5" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">FATCA-Weisungund des AIA-Steuer-Reporting-Regimes (GP-00085)</a><strong>)</strong> MÜSSEN nach der Entdeckung unverzüglich über MICOS an den FATCA Desk gemeldet werden.</p>'
		}],
		hw_2:[{
				title:'Wann ist es unzweckmässig',				
				text:'<p>Wenn Ihre Linienvorgesetzte bzw. Ihr Linienvorgesetzter in das Ereignis verwickelt ist bzw. das Ereignis nicht angemessen gehandhabt hat oder wenn Sie ein ungewöhnliches Ereignis nicht direkt melden möchten, müssen Sie es an eine andere Stelle eskalieren (z.B. andere geeignete übergeordnete Stellen, Compliance, Human Resources, General Counsel oder die <strong>Integrity Hotline (telefonisch)</strong> oder <strong>Integrity Line (online)</strong>). In solchen Fällen dürfen Sie das Ereignis nicht an Personen eskalieren, die direkt oder indirekt an Ihre Linienvorgesetzte/Ihren Linienvorgesetzten berichten oder bei denen ein anderer Interessenkonflikt besteht.</p>'
		}],
		hw_3:[{
				title:'Integrity Hotline (telefonisch)',
				text:'<p>Die <strong>Integrity Hotline (telefonisch)</strong> ist weltweit rund um die Uhr erreichbar und von geschulten Mitarbeitenden besetzt, die Anrufe auf Englisch, Deutsch, Französisch und Italienisch entgegennehmen.</p><p>Über die <strong>Integrity Hotline </strong>eskalierte Ereignisse werden umgehend und diskret bearbeitet.</p>'
		}],
		hw_4:[{
				title:'Integrity Line (online)',
				text:'<p>Die <strong>Integrity Line (online)</strong> wird extern gehostet und steht rund um die Uhr zur Verfügung.</p><p>Sie ermöglicht Ihnen die Meldung von ungewöhnlichen Ereignissen oder Bedenken über Ihren persönlichen Computer und Ihr privates Smartphone oder Tablet.</p><p>Über die <strong>Integrity Line </strong>eskalierte Ereignisse werden umgehend und diskret bearbeitet.</p>'
		}],		
		hw_7:[{
				title:'Verdächtige Verhaltensweisen (Red Flags) von Betrügenden',
				text:'<ul><li>Verschlossenes oder nervöses Verhalten</li><li>Über die Verhältnisse leben</li><li>Kontrollprobleme, mangelnde Bereitschaft zur Aufgabenteilung</li><li>Bereitschaft zum Übergehen von Kontrollen, oft um «die Sache einfacher zu machen»</li><li>Ablehnung von Ferientagen oder Krankheitsfehltagen</li><li>Zutritt zu den Räumlichkeiten und/oder Zugang zu Systemen der Bank während des Urlaubs am Stück (Block Leave)</li><li>Aussergewöhnlich enge Beziehung mit einem Dienstleister, Kunden</li><li>Anträge auf Verschiebung von internen Prüfungen oder Inspektionen zur «ordentlichen Vorbereitung»</li><li>Vorgeschichte von Weisungsverstössen oder Beinahe-Verstössen</li><li>Finanzielle Schwierigkeiten</li></ul>'
		}],
		hw_8:[{
				title:'Unbefugte Handlungen und Tätigkeiten',
				text:'<p>An unbefugten Tätigkeiten beteiligtes Personal zeigt gegebenenfalls die folgenden Verhaltensweisen:</p><ul><li>Verfügen über unerklärliche Einkommensquellen</li><li>Beteiligen sich umfassend an spekulativen Anlagen</li><li>Sind spielsüchtig</li><li>Sind in finanziellen Schwierigkeiten</li><li>Weisen konkurrierende oder nicht deklarierte externe Geschäftsinteressen auf</li><li>Übergehen interner Kontrollen</li><li>Die sich weigern, Ferien- und/oder Krankheitsfehltage zu nehmen und die während des Block Leaves die Räumlichkeiten der Bank betreten und/oder auf Systeme der Bank zugreifen während des Urlaubs</li><li>Zeigen übermässige Kontrollprobleme und sind nicht bereit, Aufgaben zu teilen</li><li>Vorgeschichte von Weisungsverstössen oder Beinahe-Verstössen</li><li>Unübliche Arbeitszeiten</li></ul>'
		}],
		hw_10:[{
				title:'Wichtige Lerninhalte',
				text:'<p>In vielen Fällen wird interner Betrug von einer Person begangen, die innerhalb der Bank alleine handelt, und kann anhand von <strong>verdächtigem Verhalten</strong> ermittelt werden. Interner Betrug kann jedoch auch durch Absprachen zwischen Bankmitarbeitenden auftreten. Verdächtige Verhaltensweisen umfassen:</p><ul><li>Verschlossenes oder nervöses Verhalten</li><li>Mangelnde Bereitschaft zur Aufgabenteilung</li><li>Bereitschaft zum Übergehen von Kontrollen, oft um «die Sache einfacher zu machen»</li><li>Ablehnung von Ferientagen oder Krankheitsfehltagen</li><li>Zutritt zu den Räumlichkeiten und/oder Zugang zu Systemen der Bank während des Urlaubs am Stück (Block Leave)</li><li>Anträge auf Verschiebung von internen Prüfungen oder Inspektionen zur «ordentlichen Vorbereitung»</li><li>Vorgeschichte von Weisungsverstössen oder Beinahe-Verstössen</li><li>Unübliche Arbeitszeiten</li></ul><p><strong>Beispiele für internen Betrug sind unter anderem:</strong></p><ul><li><strong>Unbefugter Handel</strong>, d. h., das Personal führt Transaktionen zum Verbergen von Gewinnen und Verlusten aus</li><li><strong>Unbefugte Tätigkeit</strong>, d. h., das Personal tätigt in betrügerischer Absicht Geld- oder Wertschriftentransfers von einem Pendenzen-, Nostro- oder Depotkonto oder ändert Kontoauszüge</li><li><strong>Unbefugte Überweisungen und Vermögensübertragungen</strong>, d. h., das Personal führt Überweisungen oder Vermögensübertragungen von Kundenkonten ohne Anweisung der Kundin bzw. des Kunden durch</li><li><strong>Betrug bei Spesenerstattung</strong>, beispielsweise falsch dargestellte, zu hoch angegebene oder fiktive Spesen</li></ul></p><p><strong>Kontrollen der Credit Suisse zur Verhinderung von internem Betrug umfassen:</strong></p><p><strong>Aufgabentrennung:</strong> Dies verlangt eine zusätzliche Genehmigung oder Autorisierung für eine Transaktion oder einen Prozess. Ziel ist es, eine einseitige Kontrollbeherrschung, ein manuelles Übergehen von Kontrollen oder Absprachen zwischen Bankmitarbeitenden zu verhindern. Eine geeignete Aufgabentrennung bei Verwahrung, Autorisierung und Kontrolle von Quelldokumenten und Aufzeichnungen ist unerlässlich.</p><p><strong>Rückrufprüfung:</strong> Die Überprüfung der Vollmacht, z.B. über Rückrufe oder Transaktionssignierungen, wird zur Verifizierung von Vermögensübertragungen (d. h. Zahlungen, Wertpapiere) oder Anfragen für Änderungen an statischen Kunden- oder Dienstleisterdaten verwendet. Bei derartigen Anfragen müssen eine Identitätsprüfung des Anweisenden, eine Vollmachtsprüfung, d. h. die Berechtigung zur Übertragung von Vermögen oder zur Vornahme von Änderungen an Kunden-/ Dienstleisterdaten, und Echtheitsprüfungen durchgeführt werden, um die Rechtmässigkeit der Anweisungsdetails festzustellen. Für weitere Informationen verweisen wir auf die <a data-lnk-id="lnk_12" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">AFGMS</a>.</p>'
		}],
		hw_11:[{
				title:'Wichtige Lerninhalte',
				text:'<p>In vielen Fällen wird interner Betrug von einer Person begangen, die innerhalb der Bank alleine handelt, und kann anhand von <strong>verdächtigem Verhalten</strong> ermittelt werden. Interner Betrug kann jedoch auch durch Absprachen zwischen Bankmitarbeitenden auftreten. Verdächtige Verhaltensweisen umfassen:</p><ul><li>Verschlossenes oder nervöses Verhalten</li><li>Mangelnde Bereitschaft zur Aufgabenteilung</li><li>Bereitschaft zum Übergehen von Kontrollen, oft um «die Sache einfacher zu machen»</li><li>Ablehnung von Ferientagen, Urlaub am Stück (Block Leave), Krankheitsfehltagen</li><li>Zutritt zu den Räumlichkeiten und/oder Zugang zu Systemen der Bank während des Urlaubs am Stück (Block Leave)</li><li>Anträge auf Verschiebung von internen Prüfungen oder Inspektionen zur «ordentlichen Vorbereitung»</li><li>Vorgeschichte von Weisungsverstössen oder Beinahe-Verstössen</li><li>Unübliche Arbeitszeiten</li></ul><p><strong>Beispiele für internen Betrug sind unter anderem:</strong></p><ul><li><strong>Unbefugter Handel</strong>, d. h., das Personal führt Transaktionen zum Verbergen von Gewinnen und Verlusten aus</li><li><strong>Unbefugte Tätigkeit</strong>, d. h., das Personal tätigt in betrügerischer Absicht Geld- oder Wertschriftentransfers von einem Pendenzen-, Nostro- oder Depotkonto oder ändert Kontoauszüge</li><li><strong>Unbefugte Überweisungen und Vermögensübertragungen</strong>, d. h., das Personal führt Überweisungen oder Vermögensübertragungen von Kundenkonten ohne Anweisung der Kundin bzw. des Kunden durch</li><li><strong>Betrug bei Spesenerstattung</strong>, beispielsweise falsch dargestellte, zu hoch angegebene oder fiktive Spesen</li></ul><p><strong>Kontrollen der Credit Suisse zur Verhinderung von internem Betrug umfassen:</strong></p><p><strong>Urlaub am Stück (Block Leave):</strong> Gemäss der <a data-lnk-id="lnk_8" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">globalen Weisung Block Leave (GP-00387)</a> müssen Mitarbeitende, die sensiblen Informationen ausgestellt sind, zur Minderung des potenziellen Risikos des internen Betrugs pro Kalenderjahr zehn aufeinanderfolgende Tage Urlaub nehmen und dürfen dabei keine Aufgaben im Zusammenhang mit ihrer Position durchführen, keine Bankgebäude für geschäftliche Zwecke betreten und keine Banksysteme benutzen.</p>'
		}],
		hw_12:[{
				title:'Wichtige Lerninhalte',
				text:'<p>Die Bank und ihre Mitarbeitenden sind anfällig für externe Betrugsrisiken. <strong>Wichtige externe Betrugsrisiken</strong>, denen Sie begegnen könnten, sind unter anderem:</p><p><strong>Zahlungsverkehrsbetrug</strong><br>Zahlungsverkehrsbetrug ist das Ergebnis eines vorsätzlichen Täuschungsmanövers zur Überzeugung der befugten Zahlerin/des befugten Zahlers, eine Zahlung ohne Ermächtigung der Kundin/des Kunden auszuführen. Cyber-Zahlungsverkehrsbetrug nutzt verschiedene Formen von Cyber-Betrug als Vehikel für den Zugriff auf die Mittel.</p><p><strong>Cyber-Betrug</strong><br>Cyber-Betrug ist jede Art eines vorsätzlichen, online durchgeführten Täuschungsmanövers mit dem Zweck, missbräuchlich oder rechtswidrig Gewinne zu erzielen. Ziel sind Kundinnen und Kunden sowie Mitarbeitende. Oft wird Cyber-Betrug eingesetzt, um auf betrügerische Weise an Auszahlungen, Wertpapiere und vertrauliche Daten oder Unterlagen zu gelangen.</p><p><strong>Identitätsdiebstahl</strong><br>Identitätsdiebstahl ist eine Art von Betrug, bei dem personenbezogene, nicht öffentliche Informationen einer anderen Person ohne deren Ermächtigung für potenzielle betrügerische Handlungen verwendet werden. Identitätsdiebstahl stellt eine Bedrohung für die Reputation der Credit Suisse dar, die für ihre Sorgfalt und informierte Auswahl, mit wem sie Geschäfte tätigt, und den Schutz der Informationen von Bestandskunden bekannt ist. Identitätsdiebstahl gilt als Verbrechen in den Vereinigten Staaten, kann aber in anderen Rechtsordnungen unterschiedlich behandelt werden.</p>'
		}],
		hw_13:[{
				title:'Wichtige Lerninhalte',
				text:'<p>Die Bank und ihre Mitarbeitenden sind anfällig für externe Betrugsrisiken. <strong>Wichtige externe Betrugsrisiken</strong>, denen Sie begegnen könnten, sind unter anderem:</p><p><strong>Betrug durch Einreichung gefälschter Dokumente («Financial Statement Fraud»)</strong><br>Financial Statement Fraud kommt vor, wenn eine Kundin bzw. ein Kunde gefälschte Unterlagen vorlegt, um ihr bzw. sein Vermögen und/oder Einkommen falsch darzustellen und Produkte und Dienstleistungen von der Bank zu erhalten. Beispiele für Financial Statement Fraud sind unter anderem Erfassung von fiktiven Erträgen oder Erträgen in falschen Abrechnungsperioden sowie unzulässige Offenlegungen oder Verschweigen von Schulden.</p><p><strong>Anlagebetrug</strong><br>Der typische Anlagebetrug zeichnet sich durch das Angebot von Anlagen mit geringem oder keinem Risiko, garantierten und übermässig beständigen Renditen, komplexen Strategien oder nicht registrierten Wertschriften aus.  Beispiele für Anlagebetrug sind Schneeballsysteme, Pyramidensysteme und eine Aufforderung zur Bezahlung einer Bearbeitungsgebühr für Anlagen. </p><p><strong>Missbrauch der Marke Credit Suisse</strong><br>Der Missbrauch der Marke Credit Suisse bezieht sich auf ein Betrugssystem, in dessen Rahmen gefälschte Dokumente, Websites und E-Mail-Konten verwendet werden, bei denen die Marke oder das Logo der Credit Suisse missbraucht werden. Absicht ist, die Dokumente als rechtmässige Anlage- oder Finanzprodukte für potenzielle Anleger, Banken oder Verbraucher erscheinen zu lassen, sodass sie in das Betrugssystem anlegen. </p>'
		}],
		hw_14:[{
				title:'Wichtige Lerninhalte',
				text:'<p>Die Bank und ihre Mitarbeitenden sind anfällig für externe Betrugsrisiken. <strong>Wichtige externe Betrugsrisiken</strong>, denen Sie begegnen könnten, sind unter anderem:</p><p><strong>Zahlungsverkehrsbetrug</strong><br>Zahlungsverkehrsbetrug ist das Ergebnis eines vorsätzlichen Täuschungsmanövers zur Überzeugung der befugten Zahlerin/des befugten Zahlers, eine Zahlung ohne Ermächtigung der Kundin/des Kunden auszuführen. Cyber-Zahlungsverkehrsbetrug nutzt verschiedene Formen von Cyber-Betrug als Vehikel für den Zugriff auf die Mittel.</p><p><strong>Cyber-Betrug</strong><br>Cyber-Betrug ist jede Art eines vorsätzlichen, online durchgeführten Täuschungsmanövers mit dem Zweck, missbräuchlich oder rechtswidrig Gewinne zu erzielen. Ziel sind Kundinnen und Kunden sowie Mitarbeitende. Oft wird Cyber-Betrug eingesetzt, um auf betrügerische Weise an Auszahlungen, Wertpapiere und vertrauliche Daten oder Unterlagen zu gelangen.</p><p><strong>Identitätsdiebstahl</strong><br>Identitätsdiebstahl ist eine Art von Betrug, bei dem personenbezogene, nicht öffentliche Informationen einer anderen Person ohne deren Ermächtigung für potenzielle betrügerische Handlungen verwendet werden. Identitätsdiebstahl stellt eine Bedrohung für die Reputation der Credit Suisse dar, die für ihre Sorgfalt und informierte Auswahl, mit wem sie Geschäfte tätigt, und den Schutz der Informationen von Bestandskunden bekannt ist. Identitätsdiebstahl gilt als Verbrechen in den Vereinigten Staaten, kann aber in anderen Rechtsordnungen unterschiedlich behandelt werden.</p>'
		}],
		hw_15:[{
				title:'Wichtige Lerninhalte',
				text:'<p>Die Bank und ihre Mitarbeitenden sind anfällig für externe Betrugsrisiken. Wichtige externe Betrugsrisiken, denen Sie begegnen könnten, sind unter anderem:</p><p><strong>Zahlungsverkehrsbetrug</strong><br>Zahlungsverkehrsbetrug ist das Ergebnis eines vorsätzlichen Täuschungsmanövers zur Überzeugung der befugten Zahlerin/des befugten Zahlers, eine Zahlung ohne Ermächtigung der Kundin/des Kunden auszuführen. Cyber-Zahlungsverkehrsbetrug nutzt verschiedene Formen von Cyber-Betrug als Vehikel für den Zugriff auf die Mittel.</p><p><strong>Cyber-Betrug</strong><br>Cyber-Betrug ist jede Art eines vorsätzlichen, online durchgeführten Täuschungsmanövers mit dem Zweck, missbräuchlich oder rechtswidrig Gewinne zu erzielen. Ziel sind Kundinnen und Kunden sowie Mitarbeitende. Oft wird Cyber-Betrug eingesetzt, um auf betrügerische Weise an Auszahlungen, Wertpapiere und vertrauliche Daten oder Unterlagen zu gelangen.</p><p><strong>Identitätsdiebstahl</strong><br>Identitätsdiebstahl ist eine Art von Betrug, bei dem personenbezogene, nicht öffentliche Informationen einer anderen Person ohne deren Ermächtigung für potenzielle betrügerische Handlungen verwendet werden. Identitätsdiebstahl stellt eine Bedrohung für die Reputation der Credit Suisse dar, die für ihre Sorgfalt und informierte Auswahl, mit wem sie Geschäfte tätigt, und den Schutz der Informationen von Bestandskunden bekannt ist. Identitätsdiebstahl gilt als Verbrechen in den Vereinigten Staaten, kann aber in anderen Rechtsordnungen unterschiedlich behandelt werden.</p>'
		}]
	}
	
	/* DEV NOTE: strings for the link URLs separated by link id; if there are no links make this variable an empty array */
	link_dat = {
		lnk_1:[{
				/* cultural values */
				url:'http://csintra.net/about/en/purpose_values/values.html'
		}],
		lnk_2:[{
				/* Incident Collation Policy (GP-00260) */
				url:'http://my.csintra.net/mypolicies/GP-00260-15009'
		}],
		lnk_3:[{
				/* Disciplinary Policy (GP-01058) */
				url:'http://my.csintra.net/mypolicies/GP-01058-333069'
		}],
		lnk_4:[{
				/* US Cross Border Policy (P-00025) */
				url:'http://my.csintra.net/mypolicies/P-00025-43014'
		}],
		lnk_5:[{
				/* FATCA Policy (GP-00085) */
				url:'http://my.csintra.net/mypolicies/GP-00085-340480'
		}],
		lnk_6:[{
				/* Escalation Policy (GP-00012) */
				url:'http://my.csintra.net/mypolicies/GP-00012-27349'
		}],
		lnk_7:[{
				/* Credit Suisse Integrity Lines (phone and web) */
				url:'https://home.csintra.net/content/divisions-and-functions/en/cco/rc/investigations/integrity-lines.html'
		}],
		lnk_8:[{
				/* Global Block Leave Policy (GP-00387) */
				url:'http://my.csintra.net/mypolicies/GP-00387-27433'
		}],
		lnk_9:[{
				/* Escalation and Identifying Potential Fraud Course Summary */
				url:'images/CS120_course_summary.pdf'
		}],
		lnk_10:[{
				/* Anti-Fraud Policy */
				url:'https://mypolicies.csintra.net/#/overviewComponent/24765/305675/GP-00298/false'
		}],
		lnk_11:[{
				/* Identity Theft Red Flags Supplement (GP-00298 S-03) */
				url:'http://my.csintra.net/mypolicies/GP-00298-S03-367057'
		}],
		lnk_12:[{
				/* Anti-Fraud Global Minimum Standards (AFGMS) */
				url:'https://home.csintra.net/content/dam/assets/divisions-and-functions/documents/crco/dcco/core-compliance/global-anti-fraud-conduct-monitoring/anti-fraud-global-minimum-standards.pdf'					 
		}],
		lnk_13:[{
				/* Change Initiatives */
				url:'https://odyssey.rowini.net/confluence/display/WTE/Anti-Fraud+Global+Minimum+Standards+%28AFGMS%29+to+be+considered+in+Change+Initiatives+in+Wealth+Management'
		}]
	}
	
	/* DEV NOTE: strings for the resource popup title and content */
	resource_dat = {
		resources:[{
				title:'Ressourcen',				
				text:'<p><strong>Intranet-Links sind unter Umständen nicht über die Saba Mobile App abrufbar.</strong></p><p><a data-lnk-id="lnk_9" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Schulungszusammenfassung zu Eskalation und Identifizierung von potenziellem Betrug</a></p><p><a data-lnk-id="lnk_6" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Weisung «Escalation» (GP-00012)</a></p><p><a data-lnk-id="lnk_10" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Weisung zur Bekämpfung von Betrug</a></p><p><a data-lnk-id="lnk_2" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Weisung «Erfassung von Ereignissen» (GP-00260)</a></p><p><a data-lnk-id="lnk_4" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Weisung zu grenzüberschreitenden US-Geschäftsaktivitäten (P-00025)</a></p><p><a data-lnk-id="lnk_5" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">FATCA-Weisung (GP-00085)</a></p><p><a data-lnk-id="lnk_3" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Weisung «Disziplinarwesen» (GP-01058)</a></p><p><a data-lnk-id="lnk_8" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Weisung «Block Leave» (GP-00387)</a></p><p><a data-lnk-id="lnk_11" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Identity Theft Red Flags Supplement (GP-00298 S-03)</a></p><p><a data-lnk-id="lnk_7" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Credit Suisse Integrity Lines (telefonisch und online)</a></p><p><a data-lnk-id="lnk_12" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Globale Mindeststandards zur Betrugsbekämpfung</a></p>'
		}]
	}

	/* DEV NOTE: strings for LMS errors */
	lms_error_dat = {
		lms_error_1:[{
				text1:'API cannot be found.',
				text2:'The course may not have been launched from an LMS.'
		}]		
	}
});