/* functions to initiate the course */

$(document).ready(function() {

	BrowserDetect.init();
	/*resizeWindow();*/
	
	if((typeof console)=="undefined"){
		console = new Object();	
		console.log = function(arg){ 
		}
	}
	
	/* 20221130 Update to language selection and bookmark functionality */
	//LMSAPI = parent.document.scormAPI; //actionsGetAPI();
	
	courseInit();
	lockNav();
	setupClickableOptions();  
	interfaceStrings();
	setMenuTabIndex();
	setTabIndex(); /* set up the tab index for course */
	
	//setUpAudio(); /* setup audio functionality */	
	//setUpVids();
	
	$(".section").attr('data-clicked',0); 
	$(".section").attr('data-animated',0);
	
	
	$(".slider_container").attr('data-height',0); 
	//$(".section").attr('data-links',0); 
	//$(".section").attr('data-hotwords',0);	
	document.randomizeAssessment();	
	
	//if(document.topicPreTest){
		
	document.randomizePreQuestions();
	//}
	
	
	/*if(isiPhone || isAndroidPhone || isAndroidTablet){
		var elementsToShow = document.querySelectorAll('.animation-element');
		elementsToShow.forEach(function (element) {
			element.classList.add('in-view');
		});
	}*/
	
	if(os == "iOS" || os == "Android"){
		var elementsToShow = document.querySelectorAll('.animation-element');
		elementsToShow.forEach(function (element) {
			element.classList.add('in-view');
		});
		
		$('.video_poster').css('display','none');
		
		$(".section").removeClass("decal_left");
	}
	if(isMac){
		$('.video_poster').css('display','none');
	}
	
	//rePosHotSpots();
	
	setRTL();
})

/* setTabIndex function to assign reset and assign tab index for each section */

var navTabCnt; /* 20180501 Accessibility Update */
var tempNavCnt;
function removeMenuTabIndex(){ // remove menu tab funcitonality
	
	$('.topic_index').find('.topic_select').each(function(index, element) {
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
    });
	
	$('.topic_index').find('.content_text').each(function(index, element) {
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
    	// 202210 QA Tabbing fix
    	$(this).find('a').each(function(index, element) {
  			$(this).attr('tabindex', -1);
  		});
   
    
    });
	
	$('.topic_index').find('.h1_inner').each(function(index, element) {
     
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
    });
	
	$('.topic_index').find('.home').each(function(index, element) {
     
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
    });
	
	// 20221018 QA fix for tabbing to buttons when resource/hotword popup visible
	$('.topic_index').find('.switchLang').each(function(index, element) {
     
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
    });
	
	$('.topic_index').find('.page').each(function(index, element) {
     
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
    });
    
    $('.topic_index').find('.bar_close').each(function(index, element) {
     
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
    });
    
    tempNavCnt = 0;
	
	$('.bar_robot').find('.home').each(function(index, element) {
     
        //tempNavCnt++;
		$(this).attr('tabindex', 1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
	
	$('.bar_robot').find('.switchLang').each(function(index, element) {
     
        //tempNavCnt++;
		$(this).attr('tabindex', 2);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
    
	$('.bar_robot').find('.page').each(function(index, element) {
     
        //tempNavCnt++;
		$(this).attr('tabindex', 3);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
    $('.bar_robot').find('.bar_close').each(function(index, element) {
     
        //tempNavCnt++;
		$(this).attr('tabindex', 4);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
    
    
}


/* 20180501 Accessibility Update */
function setMenuTabIndex(){
	
	var tabCnt = 0;

	
	$('.bar_robot').find('.home').each(function(index, element) {
     
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
    });
	
	$('.bar_robot').find('.switchLang').each(function(index, element) {
     
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
    });
    
	/* 20221021 ensure burger menu window is focused on and cannot be tabbed out of */
	$('.burger_index').find('.burger_scroll').attr('tabindex', -1);
    $('.burger_index').find('.burger_scroll').attr('aria-hidden', true);
	
	$('.burger_index').find('.burger_home').attr('tabindex', -1);
    $('.burger_index').find('.burger_home').attr('aria-hidden', true);
	
    $('.burger_index').find('.burger_select').each(function(index, element) {             
		$(this).attr('tabindex', -1);
		$(this).attr('aria-hidden', true);
    });
	
	$('.burger_index').find('.burger_close').attr('tabindex', -1);
	$('.burger_index').find('.burger_close').attr('aria-hidden', true);
    
	$('.bar_robot').find('.page').each(function(index, element) {
     
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
    });
    
    $('.bar_robot').find('.bar_close').each(function(index, element) {
     
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
    });
	
	
	$('.topic_index').find('.home').each(function(index, element) {
     
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
	$('.topic_index').find('.switchLang').each(function(index, element) {
     
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
	
	$('.topic_index').find('.page').each(function(index, element) {
     
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
    
    $('.topic_index').find('.bar_close').each(function(index, element) {
     
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
	
	$('.topic_index').find('.h1_inner').each(function(index, element) {
      
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
	
	
	
	$('.topic_index').find('.content_text').each(function(index, element) {
      
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		// 202210 QA Tabbing fix
  		$(this).find('a').each(function(index, element) {
  			tabCnt++;
  			$(this).attr('tabindex', tabCnt);
  		});
		
    });
	

	$('.topic_index').find('.home-copyright').find('.content_text').each(function(index, element) {
      
		$(this).attr('tabindex', -1);
		
    });
	
	$('.topic_index').find('.topic_select').each(function(index, element) {
      
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
}

function setBurgerTabIndex(){
    
	// 20221018 QA fix for tabbing to buttons when resource/hotword popup visible
	if($(".topic_index").is(":visible")){
		removeMenuTabIndex();
		$('.topic_index').find('.home').each(function(index, element) {
     
			$(this).attr('tabindex', -1);
			/* 2022 Accessibility Update */
			$(this).attr('aria-hidden', true);

		});

		// 20221018 QA fix for tabbing to buttons when resource/hotword popup visible
		$('.topic_index').find('.switchLang').each(function(index, element) {

			$(this).attr('tabindex', -1);
			/* 2022 Accessibility Update */
			$(this).attr('aria-hidden', true);

		});

		$('.topic_index').find('.page').each(function(index, element) {

			$(this).attr('tabindex', -1);
			/* 2022 Accessibility Update */
			$(this).attr('aria-hidden', true);

		});

		$('.topic_index').find('.bar_close').each(function(index, element) {

			$(this).attr('tabindex', -1);
			/* 2022 Accessibility Update */
			$(this).attr('aria-hidden', true);

		});
		
		$('.bar_robot').find('.home').each(function(index, element) {

			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
		});
		$('.bar_robot').find('.switchLang').each(function(index, element) {

			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
		});
		$('.bar_robot').find('.page').each(function(index, element) {

			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
		});
		$('.bar_robot').find('.bar_close').each(function(index, element) {

			$(this).attr('tabindex', -1);	
			$(this).attr('aria-hidden', true);
		});
		
	}else{
	
		$('.bar_robot').find('.home').each(function(index, element) {

			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
		});
		$('.bar_robot').find('.switchLang').each(function(index, element) {

			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
		});
		$('.bar_robot').find('.page').each(function(index, element) {

			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
		});
		$('.bar_robot').find('.bar_close').each(function(index, element) {

			$(this).attr('tabindex', -1);	
			$(this).attr('aria-hidden', true);
		});
	}
	// 20221018 QA fix for tabbing to buttons when resource/hotword popup visible

    tempNavCnt = 0;
	
	/*$('.bar_robot').find('.home').each(function(index, element) {
     
        tempNavCnt++;
		$(this).attr('tabindex', tempNavCnt);
		// 2022 Accessibility Update 
		$(this).attr('aria-hidden', false);
		
    });*/
	
	/* 20221021 ensure burger menu window is focused on and cannot be tabbed out of */
    tempNavCnt++;
    $('.burger_index').find('.burger_scroll').attr('tabindex', tempNavCnt);
    $('.burger_index').find('.burger_scroll').attr('aria-hidden', false);
	
	tempNavCnt++;
    $('.burger_index').find('.burger_home').attr('tabindex', tempNavCnt);
    $('.burger_index').find('.burger_home').attr('aria-hidden', false);

    $('.burger_index').find('.burger_select').each(function(index, element) {
        tempNavCnt++;
		$(this).attr('tabindex', tempNavCnt);
		$(this).attr('aria-hidden', false);
    });

	tempNavCnt++;
	$('.burger_index').find('.burger_close').attr('tabindex', tempNavCnt);
	$('.burger_index').find('.burger_close').attr('aria-hidden', false);
	
	/*$('.bar_robot').find('.page').each(function(index, element) {
     
        tempNavCnt++;
		$(this).attr('tabindex', tempNavCnt);
		
    });
    $('.bar_robot').find('.bar_close').each(function(index, element) {
     
        tempNavCnt++;
		$(this).attr('tabindex', tempNavCnt);
		
    });*/
    
}

function removerBurgerTabIndex(){
    
    /* 20221021 ensure burger menu window is focused on and cannot be tabbed out of */
	$('.burger_index').find('.burger_scroll').attr('tabindex', -1);
    $('.burger_index').find('.burger_scroll').attr('aria-hidden', true);
	
	$('.burger_index').find('.burger_home').attr('tabindex', -1);
    $('.burger_index').find('.burger_home').attr('aria-hidden', true);
	
    $('.burger_index').find('.burger_select').each(function(index, element) {             
		$(this).attr('tabindex', -1);
		$(this).attr('aria-hidden', true);
    });
	
	$('.burger_index').find('.burger_close').attr('tabindex', -1);
	$('.burger_index').find('.burger_close').attr('aria-hidden', true);  

    $('.bar_robot').find('.home').each(function(index, element) {
        
		$(this).attr('tabindex', 1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
    });
    $('.bar_robot').find('.switchLang').each(function(index, element) {
     
		$(this).attr('tabindex', 2);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
    $('.bar_robot').find('.page').each(function(index, element) {
     
		$(this).attr('tabindex', 3);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
    $('.bar_robot').find('.bar_close').each(function(index, element) {

		$(this).attr('tabindex', 4);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
    
    setTabIndex();
}


/* 20180501 Accessibility Update */
function setTabIndex(sec){	
		
	$('.home').attr('role','button');
	$('.switchLang').attr('role','button');
	$('.page').attr('role','button');
	$('.bar_close').attr('role','button');
		  
	$('.topic_nav').attr('role','button');
	
	$('.box_closer').attr('role', 'button');
	
	/* 20221021 ensure burger menu window is focused on and cannot be tabbed out of */
	$('.burger_close').attr('role', 'button');
	
	/* apply tabindex */
	var tabCnt = 4;		// 20221018 QA fix for tabbing to buttons when resource/hotword popup visible
	

	
	$('.sec_rest_wrapper').find('.section').each(function(index, element) {
		
	
		
		$(this).find('.h2_inner').each(function(index, element) { /* 20180501 Accessibility Update */
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
		});
		
		$(this).find('.content_text').each(function(index, element) { /* 20180501 Accessibility Update */
			/* 20221020 ensure tab order of text content after activity is following activity */
			if (!$(this).hasClass('content_text_after_activity'))
			{
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				/* 20221021 ensure links within main content are tabbed to after the content */
				$(this).find('a').each(function(index, element) {
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
				});
				
				/* 20221107 Accessibility fix to apply tab order if image only has alt text */
				$(this).find('img').each(function(index, element) {
					if ($(this).attr('alt') != ''){
						tabCnt++;
						$(this).attr('tabindex', tabCnt);
					}
					if ($(this).parent().hasClass('adaptive_img'))
					{
						//$(this).parent().parent().attr('tabindex', -1);
						//20221213 fix for adpative image to be table and div containg image content read out
						tabCnt++;
						$(this).parent().parent().attr('tabindex', tabCnt);
					}
				});
			}
		});

		/* 20221107 Accessibility fix to apply tab order if image only has alt text */
		$(this).find('img').each(function(index, element) {
			if (!$(this).parent().hasClass('adaptive_img'))
			{
				if ($(this).attr('alt') != ''){
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
				}
			}
		});

		/* 20180501 Accessibility Update */
		$(this).find('.expando_btn').each(function(index, element) {
			$(this).attr('role','button'); /* 20180501 Accessibility Update */
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			
			$(this).next('.expando_reveal').each(function(index, element){
			 
									 
				
				$(this).find('.expando_reveal_heading').each(function(index, element) {
					$(this).attr('role','button'); /* 20180501 Accessibility Update */
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
				});
				
				$(this).find('.expando_reveal_content').each(function(index, element) {	
					
					tabCnt++;
					$(this).attr('tabindex', tabCnt);

					$(this).find('a').each(function(index, element) {
						tabCnt++;
						$(this).attr('tabindex', tabCnt);
					});
					
					/* 20220630 Accessibility fix to apply tan order if image only has atl text */
					$(this).find('img').each(function(index, element) {
						if ($(this).attr('alt') != ''){
							tabCnt++;
							$(this).attr('tabindex', tabCnt);
						}
					});

				});

				
			});
			
			
		});	
			
		
		/* apply tabindex to video */
		
		$(this).find('.video_poster').each(function(index, element) {	
			$(this).attr('role','button');
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
		});	
			
		$(this).find('.video_player').each(function(index, element) {	
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
		});	
		$(this).find('.transcript_btn').each(function(index, element) {	
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
		});	
		/* apply tabindex to questions */	
        $(this).find('.qItemFirst').each(function(index, element) {
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			$(this).attr("aria-hidden", false);
			/* 20220628 JAWS fix to stop item being read when course launches */
		});
        
		$(this).find('.squaredBox').each(function(index, element) {
			
			
			var labelTxt;
			
			$(this).find('.labelTxt').each(function(index, element) {
				
				labelTxt = $(this).html();
				
			});
			
			$(this).attr('title', labelTxt)
			
		});
				
		$(this).find('.mc_btn').each(function(index, element) {
            $(this).attr('tabindex', -1);
        });
		
		$(this).find('.dropDown').each(function(index, element) {
			$(this).find('label').each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
			});
			$(this).find('select').each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
			});
        });
		
		
		
		$(this).find('.submit_btn').each(function(index, element) {	
			$(this).attr('role','button'); /* 20180501 Accessibility Update */
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
		});	
		
		$(this).find('.feedback_text').each(function(index, element) {	
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			
			$(this).find('a').each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
			});
		});	
		
		// 20221013 JAWS fix
		$(this).find('.results_review_text').each(function(index, element) {
			
			//20221025 JAWS fix to stop duplicate read out when assess results review is not present
			if(document.showAssessResultsReview){
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
			}
		});
		
		$(this).find('.retake_assess_btn').each(function(index, element) {	
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
		});	
		
		/* apply tabindex to slider */
		$(this).find('.slider_txt').each(function(index, element) {	
			/* ensure first display is tabbed to first */
			//if (index == 0)
			//{	
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			
			$(this).attr('data-tab', tabCnt); // 20221018 JAWs Slider Fix

			$(this).find('a').each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
			});
			
			/* 20220630 Accessibility fix to apply tan order if image only has atl text */
			$(this).find('img').each(function(index, element) {
				if ($(this).attr('alt') != ''){
					tabCnt++;
					$(this).attr('data-tab', tabCnt); // 20221025 JAWs Slider Fix
					$(this).attr('tabindex', tabCnt);
				}
			});
			
			
			//}			
		});
		$(this).find('.slide_right').each(function(index, element) {	
			
			$(this).attr('role','button'); /* 20180501 Accessibility Update */
			
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
		});
		
		/*$(this).find('.slider_txt').each(function(index, element) {	
			if (index != 0)
			{	
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
			
				$(this).find('a').each(function(index, element) {
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
				});
			}			
		});*/
		$(this).find('.slide_left').each(function(index, element) {	
			
			$(this).attr('role','button'); /* 20180501 Accessibility Update */
			
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
		});	
		/* apply tabindex to hotspot */
		/* 20180501 Accessibility Update */
		
		$(this).find('.hotspot_btn').each(function(index, element) {	
			
			$(this).attr('role','button'); /* 20180501 Accessibility Update */
			
			var hotTxt = $(this).next('.hotspot_btn_label').text();
						
			$(this).attr('title',hotTxt);
			
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			
			$(this).parent().next('.hotspot_reveal_inner').find('.hotspot_reveal').each(function(index, element) {	
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				
				$(this).find('a').each(function(index, element) {
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
				});
                // 20190206 hotspot close functionality
                $(this).find('.hotspot_close').each(function(index, element) {
                    $(this).attr('role','button');
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
				});
			});
		});	
		
		$(this).find('.hotspot_btn_close').each(function(index, element) {	
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
		});
		
		
		$(this).find('.image_btn').each(function(index, element) {
			$(this).attr('role','button'); 
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			
			tabCnt++;
			/* 20221020 ensure tabbing works properly in image click and displays */
			$(this).parent().parent().find('.image_reveal').eq(index).attr('tabindex', tabCnt);
			
			// 20221026 Fix for links not accessible
			$(this).parent().parent().find('.image_reveal').eq(index).find('a').each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
			});
			
		});	
		
		// 202210 QA Tabbing fix
		$(this).find('.icon_element').each(function(index, element) {
			$(this).find('.icon_btn').each(function(index, element) {
				$(this).attr('role','button'); 
				tabCnt++;
				$(this).attr('tabindex', tabCnt);

				//tabCnt++;
				//$('.icon_content').eq(index).attr('tabindex', tabCnt);

			});	
			
			$(this).find('.icon_content').each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				
				/* 20221107 ensure can tab to links in icon interaction reveal */
				$(this).find('a').each(function(index, element) {
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
				});

				//tabCnt++;
				//$('.icon_content').eq(index).attr('tabindex', tabCnt);

			});
		});
		
			
		$(this).find('.image_hotspot_holder').each(function(index, element) {
			
			$(this).find('.image_hsp').each(function(index, element) {
				$(this).attr('role','button'); 
				tabCnt++;
				$(this).attr('tabindex', tabCnt);

				tabCnt++;
				
				$(this).parent().parent().prev().find('.image_hotspot_reveal').eq(index).attr('tabindex', tabCnt);

			});	
			
		});
		
		
		$(this).find('.v1hspimg_btn_holder').each(function(index, element) {
			
			$(this).find('.v1hspimg_btn').each(function(index, element) {
				$(this).attr('role','button'); 
				tabCnt++;
				$(this).attr('tabindex', tabCnt);

				tabCnt++;
				
				$(this).parent().prev().find('.v1hspimg_reveal').eq(index).attr('tabindex', tabCnt);

			});	
			
		});
		
		
		
		$(this).find('.four_image_btn').each(function(index, element) {
			$(this).attr('role','button'); 
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			
			tabCnt++;
			$('.four_image_reveal_content').eq(index).attr('tabindex', tabCnt);
			
			/* 20220630 Accessibility fix to apply tan order if image only has atl text */
			$('.four_image_reveal_content').eq(index).find('img').each(function(index, element) {
				if ($(this).attr('alt') != ''){
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
				}
			});
			
			tabCnt++;
			$('.popup_close').eq(index).attr('role','button');
			$('.popup_close').eq(index).attr('tabindex', tabCnt);
			
		});	
		
		// 202210 QA Tabbing fix
		$(this).find('.tab_btn').each(function(index, element) {
			$(this).attr('role','button'); 
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			
			tabCnt++;
			//$('.tab_reveal').index(index).attr('tabindex', tabCnt);
			
			/*$(this).parent().next().find(".tab_reveal").each(function(i,ele){
				tabCnt++;
				$('.tab_reveal').eq(index).attr('tabindex', tabCnt);
			});*/
			
			$(this).parent().next().find(".tab_reveal").eq(index).attr('tabindex', tabCnt);
			
			/* 20221019 include links in the tab order in a tabbed reveal */
			$(this).parent().next().find(".tab_reveal").eq(index).find('a').each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
			});
				
			/* 20220630 Accessibility fix to apply tan order if image only has atl text */
			$(this).parent().next().find(".tab_reveal").eq(index).find('img').each(function(index, element) {					
				if ($(this).attr('alt') != ''){
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
				}
			});
			
		});	
		
		/* flip card 2022 */
		$(this).find('.flip_card').each(function(index, element) {			
			
			$(this).find('.flip_card_front').each(function(index, element) {
				$(this).attr('role','button'); 
			});
		  	$(this).find('.flip_card_back').each(function(index, element) {
				if(document.allowFlipBack){ // 20221025 Flipcard link fix
					$(this).attr('role','button');				
				}
			});
			tabCnt++;			
			$(this).find('.flip_card_inner').each(function(index, element) {
				if ($(this).hasClass('flipped'))
				{
					$(this).find('.flip_card_front').each(function(index, element) {
						$(this).attr('tabindex', -1);
					});
					$(this).find('.flip_card_back').each(function(index, element) {
						$(this).attr('tabindex', tabCnt);
						// 20221025 Flipcard link fix
						$(this).find('a').each(function(index, element) {
							tabCnt++;
							$(this).attr('tabindex', tabCnt);
						});
					});
				}
				else
				{
					$(this).find('.flip_card_front').each(function(index, element) {
						$(this).attr('tabindex', tabCnt);
					});
					$(this).find('.flip_card_back').each(function(index, element) {
						$(this).attr('tabindex', -1);
						// 20221025 Flipcard link fix
						$(this).find('a').each(function(index, element) {
							tabCnt++;
							$(this).attr('data-tab', tabCnt);
							$(this).attr("aria-hidden", true);
						});
					});
				}
			});				
		});
		
		/* 20221020 ensure tab order of text content after activity is following activity */
		$(this).find('.content_text_after_activity').each(function(index, element) {
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20221101 ensure links within text content after activity are tabbed to after the content */
			$(this).find('a').each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
			});
		});
        
        $(this).find('.complete_arrow').each(function(index, element) { /* 20180501 Accessibility Update */
            $(this).attr('role','button');
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
		});
		
		
    });
	
	$(":input").attr("aria-hidden", false); /* 20220628 JAWS fix to stop item being read when course launches */
	
	navTabCnt = tabCnt; /* 20180501 Accessibility Update */

	document.onmousedown = hideFocusOutline;

    function hideFocusOutline() {
	    $('[tabindex]').focus(function()
		{
			$(this).css('outline', 'none');
		});
		$('[tabindex]').focusout(function()
		{
			$(this).css('outline', 'none');
		});
		$('[tabindex]').keyup(function (event)
		{
			if(event.keyCode == 9)
			{
				$(this).css('outline', '');
			}
		});
    }	
	
}

/* 20180501 Accessibility Update */
function setNavTab(){
	
	var tabCnt = navTabCnt;
	tabCnt++
	$(".nav_instruction .instruction").attr('tabindex', tabCnt); // 202210 QA Tabbing fix
	tabCnt++
	$('#left_nav').attr('tabindex', tabCnt);
	tabCnt++;
	$('#home_nav').attr('tabindex', tabCnt);
	tabCnt++;
	$('#right_nav').attr('tabindex', tabCnt);
	
	/* 20220628 JAWS fix to stop item being read when course launches */
	$('#left_nav').attr("aria-hidden", false);
	$('#home_nav').attr("aria-hidden", false);
	$('#right_nav').attr("aria-hidden", false);
	/* 20220628 JAWS fix to stop item being read when course launches */
}
/* 20180501 Accessibility Update */

/* 20180501 Accessibility Update Remove tab functionality from content */
function removeTabIndex(){	
	// 20221018 QA fix for tabbing to buttons when resource/hotword popup visible
	$('.bar_robot').find('.home').each(function(index, element) { 
		$(this).attr('tabindex', -1);
	});
	// 20221018 QA fix for tabbing to buttons when resource/hotword popup visible
	$('.bar_robot').find('.switchLang').each(function(index, element) { 
		$(this).attr('tabindex', -1);
	});
	
	$('.bar_robot').find('.bar_close').each(function(index, element) {
		$(this).attr('tabindex', -1);
	});
	$('.bar_robot').find('.page').each(function(index, element) {
		$(this).attr('tabindex', -1);
	});
	
	$('.sec_rest_wrapper').find('.section').each(function(index, element) {
		
		$(this).find('.h2_inner').each(function(index, element) {
			$(this).attr('tabindex', -1);
		});
		
		$(this).find('.content_text').each(function(index, element) {
			$(this).attr('tabindex', -1);
			/* 20221021 ensure links within main content are tabbed to after the content */
			$(this).find('a').each(function(index, element) {
				$(this).attr('tabindex', -1);
			});
		});
				
		/* 20221107 Accessibility fix to apply tab order if image only has alt text */
		$(this).find('img').each(function(index, element) {
			$(this).attr('tabindex', -1);
		});
		
		$(this).find('.expando_btn').each(function(index, element) {
			$(this).attr('tabindex', -1);
			
			$(this).next('.expando_reveal').each(function(index, element){
				$(this).find('.expando_reveal_content').each(function(index, element) {	
					$(this).attr('tabindex', -1);

					$(this).find('a').each(function(index, element) {
						$(this).attr('tabindex', -1);
					});
					
					/* 20221107 Accessibility fix to apply tab order if image only has alt text */
					$(this).find('img').each(function(index, element) {
						$(this).attr('tabindex', -1);
					});

				});

				$(this).find('.expando_reveal_heading').each(function(index, element) {
					$(this).attr('tabindex', -1);
				});
			});
						
		});	
		/* remove tabindex to video */
		$(this).find('.video_player').each(function(index, element) {
			$(this).attr('tabindex', -1);
		});	
		$(this).find('.transcript_btn').each(function(index, element) {	
			$(this).attr('tabindex', -1);
		});	
		/* remove tabindex to questions */	
        $(this).find('.qItemFirst').each(function(index, element) {
			$(this).attr('tabindex', -1);
			$(this).attr("aria-hidden", true);
			/* 20220628 JAWS fix to stop item being read when course launches */
		});
		$(this).find('.squaredBox').each(function(index, element) {
			$(this).attr('tabindex', -1);
		});
				
		$(this).find('.mc_btn').each(function(index, element) {
            $(this).attr('tabindex', -1);
        });
		$(this).find('.submit_btn').each(function(index, element) {	
			$(this).attr('tabindex', -1);
		});	
		
		$(this).find('.feedback_text').each(function(index, element) {	
			$(this).attr('tabindex', -1);
			
			$(this).find('a').each(function(index, element) {
				$(this).attr('tabindex', -1);
			});
		});	
		
		$(this).find('.retake_assess_btn').each(function(index, element) {	
			$(this).attr('tabindex', -1);
		});	
		
		// 20221013 JAWS fix
		$(this).find('.results_review_text').each(function(index, element) {
			$(this).attr('tabindex', -1);
		});	
		
		/* remove tabindex to slider */		
		$(this).find('.slider_txt').each(function(index, element) {	
			$(this).attr('tabindex', -1);
			
			$(this).find('a').each(function(index, element) {
				$(this).attr('tabindex', -1);
			});
			
		});	
		$(this).find('.slide_right').each(function(index, element) {	
			$(this).attr('tabindex', -1);
		});
		$(this).find('.slide_left').each(function(index, element) {	
			$(this).attr('tabindex', -1);
		});
		/* remove tabindex to hotspot */
		$(this).find('.hotspot_btn').each(function(index, element) {	
			$(this).attr('tabindex', -1);
		});	
		$(this).find('.hotspot_reveal').each(function(index, element) {	
			$(this).attr('tabindex', -1);
		});	
		
		$(this).find('.hotspot_reveal').each(function(index, element) {	
			
			$(this).find('a').each(function(index, element) {
				$(this).attr('tabindex', -1);
			});
            
            $(this).find('.hotspot_close').each(function(index, element) {
                $(this).attr('tabindex', -1);
            });
			
		});	
		
		$(this).find('.hotspot_btn_close').each(function(index, element) {	
			$(this).attr('tabindex', -1);
		});
		
		
		
		$(this).find('.image_btn').each(function(index, element) {
	
			$(this).attr('tabindex', -1);
			$('.image_reveal').eq(index).attr('tabindex', -1);
			
			$(this).parent().parent().find('.image_reveal').eq(index).attr('tabindex', -1);
			
			// 20221026 Fix for links not accessible
			
			$(this).parent().parent().find('.image_reveal').eq(index).find('a').each(function(index, element) {
				$(this).attr('tabindex', -1);
			});
			
		});	
		
		$(this).find('.icon_element').each(function(index, element) {
			$(this).find('.icon_btn').each(function(index, element) {

				$(this).attr('tabindex', -1);


			});	
			
			$(this).find('.icon_content').each(function(index, element) {
				$(this).attr('tabindex', -1);

			});	
		});
		
		$(this).find('.image_hotspot_holder').each(function(index, element) {
			
			$(this).find('.image_hsp').each(function(index, element) {
				$(this).attr('tabindex', -1);
				$(this).parent().parent().prev().find('.image_hotspot_reveal').eq(index).attr('tabindex', -1);

			});	
			
		});
		
		$(this).find('.v1hspimg_btn_holder').each(function(index, element) {
			
			$(this).find('.v1hspimg_btn').each(function(index, element) {
				$(this).attr('tabindex', -1);				
				$(this).parent().prev().find('.v1hspimg_reveal').eq(index).attr('tabindex', -1);

			});	
			
		});
		
		$(this).find('.four_image_btn').each(function(index, element) {
			$(this).attr('tabindex', -1);
			
			$('.four_image_reveal_content').eq(index).attr('tabindex', -1);
			
			$('.four_image_reveal_content').eq(index).find('img').each(function(index, element) {
				if ($(this).attr('alt') != ''){
					$(this).attr('tabindex', -1);
				}
			});
			
			$('.popup_close').eq(index).attr('tabindex', -1);
			
		});	
		
		$(this).find('.tab_btn').each(function(index, element) {
			
			$(this).attr('tabindex', -1);

			//$('.tab_reveal').eq(index).attr('tabindex', -1);
			
			$(this).parent().next().find(".tab_reveal").eq(index).attr('tabindex', -1);
			
			/* 20221019 include links in the tab order in a tabbed reveal */
			$(this).parent().next().find(".tab_reveal").eq(index).find('a').each(function(index, element) {	
				$(this).attr('tabindex', -1);
			});
				
			$(this).parent().next().find(".tab_reveal").eq(index).find('img').each(function(index, element) {
				if ($(this).attr('alt') != ''){
					$(this).attr('tabindex', -1);
				}
			});
			
		});	
		
		$(this).find('.flip_card').each(function(index, element) {
			
			
			$(this).find('.flip_card_front').each(function(index, element) {
			
				$(this).attr('tabindex', -1);
				
			})
												  
		  	$(this).find('.flip_card_back').each(function(index, element) {
		
				$(this).attr('tabindex', -1);
				// 20221025 Flipcard link fix
				$(this).find('a').each(function(index, element) {
					$(this).attr('tabindex', -1);
				});
			})
			
		});	
		
        
        $(this).find('.complete_arrow').each(function(index, element) { /* 20180501 Accessibility Update */
			$(this).attr('tabindex', -1);
		});
		
    });
	
	$(".nav_instruction .instruction").attr('tabindex', -1); // 202210 QA Tabbing fix
	$('#left_nav').attr('tabindex', -1);
	$('#home_nav').attr('tabindex', -1);
	$('#right_nav').attr('tabindex', -1);
	
	/* 20220628 JAWS fix to stop item being read when course launches */
	$('#left_nav').attr("aria-hidden", true);
	$('#home_nav').attr("aria-hidden", true);
	$('#right_nav').attr("aria-hidden", true);
	/* 20220628 JAWS fix to stop item being read when course launches */
	
	$(":input").attr("aria-hidden", true); /* 20220628 JAWS fix to stop item being read when course launches */

}
/* 20180501 Accessibility Update Remove tab functionality from content */

/* close button is always hidden */
/*if(!isWeb){
	$('.topic_index .bar_close').css('display','none');
}else{
	$('.topic_index .bar_close').css('display','block');
}*/

/* apply button text and title attribute to interface buttons */
function interfaceStrings(){
	
	$('.index_banner_logo').attr('title', localiseString('course_logo'));
	$('.index_banner_logo').attr('alt', localiseString('course_logo'));
	
	$('.transcript_btn').html(localiseString('transcript_btn'));
	$('.transcript_btn').attr('title',localiseString('transcript_btn'));
	$('.transcript_btn').attr('alt',localiseString('transcript_btn'));
	
	$('.submit_btn').html(localiseString('submit_btn'));
	$('.submit_btn').attr('title',localiseString('submit_btn_locked'));
	$('.submit_btn').attr('alt',localiseString('submit_btn_locked'));
	
	$('.conf_btn').html(localiseString('conf_btn'));
	$('.conf_btn').attr('title',localiseString('conf_btn'));
	$('.conf_btn').attr('alt',localiseString('conf_btn'));
	
	$('.notconf_btn').html(localiseString('notconf_btn'));
	$('.notconf_btn').attr('title',localiseString('notconf_btn'));
	$('.notconf_btn').attr('alt',localiseString('notconf_btn'));
	
	$('.tryagain_btn').html(localiseString('tryagain_btn'));
	$('.tryagain_btn').attr('title',localiseString('tryagain_btn'));
	$('.tryagain_btn').attr('alt',localiseString('tryagain_btn'));
	
	$('.home').attr('title', localiseString('menu_nav'));
	$('.switchLang').attr('title', localiseString('lang_btn'));
	//$('.home').attr('alt', localiseString('menu_nav'));
	$('#home_nav').attr('title', localiseString('home_nav'));
	//$('#home_nav').attr('alt', localiseString('home_nav'));
	/* test out: if there is a pre-test and it has been attempted and at least one topic has been tested out of hide the left and right nav buttons */
	if ((document.pretestPresent == 1) && (document.pretestAttempted == 1) && (document.topicsPretestedOut.indexOf("1") != -1))
	{
		//$('#left_nav').hide();
		//$('#right_nav').hide();
		//$('#home_nav').addClass("pretest");
	}
	else {
		//$('#right_nav').attr('title', localiseString('right_nav'));
		//$('#right_nav').attr('alt', localiseString('right_nav'));
		//$('#left_nav').attr('title', localiseString('left_nav'));
		//$('#left_nav').attr('alt', localiseString('left_nav'));
	}
	$('.page').attr('title', localiseString('resource_btn'));
	//$('.page').attr('alt', localiseString('resource_btn'));
	$('.bar_close').attr('title', localiseString('exit_nav'));
	//$('.bar_close').attr('alt', localiseString('exit_nav'));
	
	$('.box_closer').attr('title', localiseString('close_btn'));
	//$('.box_closer').attr('alt', localiseString('close_btn'));
	
	$('.bookmark_nav_start').html(localiseString('bookmark_nav_start'));
	$('.bookmark_nav_start').attr('title', localiseString('bookmark_nav_start'));
	$('.bookmark_nav_start').attr('alt', localiseString('bookmark_nav_start'));
	$('.bookmark_nav_resume').html(localiseString('bookmark_nav_resume'));
	$('.bookmark_nav_resume').attr('title', localiseString('bookmark_nav_resume'));
	$('.bookmark_nav_resume').attr('alt', localiseString('bookmark_nav_resume'));
	$('#bm_title').html(localiseString('bookmark_title'));
	$('#bm_text').html(localiseString('bookmark_text'));
	
	$('.slide_right').attr('title', localiseString('slide_right'));
	$('.slide_right').attr('alt', localiseString('slide_right'));
	$('.slide_left').attr('title', localiseString('slide_left'));
	$('.slide_left').attr('alt', localiseString('slide_left'));
	/* 20221102 ensure leftmost slide button has unavailable title and alt text initially if linear sliders */
	if (document.sliderLinear)
	{	
		$('.slide_left').attr('title', localiseString('left_nav_locked'));
		$('.slide_left').attr('alt', localiseString('left_nav_locked'));
	}
	$('.temp_slide_nums').attr('title', localiseString('slide_progress'));
	$('.temp_slide_nums').attr('alt', localiseString('slide_progress'));
	
	$('.complete_arrow').attr('title', localiseString('complete_arrow'));
	$('.complete_arrow').attr('alt', localiseString('complete_arrow'));
	//$('.complete_arrow').html(localiseString('complete_arrow'));
		
	$('.start_img').attr('title', localiseString('topic_start'));
	$('.start_img').attr('alt', localiseString('topic_start'));
	
	$('.overlay').attr('title', localiseString('topic_locked'));
	$('.overlay').attr('alt', localiseString('topic_locked'));
	
	$('.select_bottom').find('.start_img').each(function(index, element) {
       if($(this).attr('src') != 'images/general_int/topic_locked.png'){
		   $(this).attr('alt', localiseString('topic_start'));
		   $(this).attr('title', localiseString('topic_start'));		   
	   }else{		   
		   $(this).attr('alt', localiseString('topic_locked'));
		   $(this).attr('title', localiseString('topic_locked'));
	   }
    });
    
    $('.burger_select').find('.start_img').each(function(index, element) {
       if($(this).attr('src') != 'images/custom_int/burger_locked.png'){
		   $(this).attr('alt', localiseString('topic_start'));
		   $(this).attr('title', localiseString('topic_start'));		   
	   }else{		   
		   $(this).attr('alt', localiseString('topic_locked'));
		   $(this).attr('title', localiseString('topic_locked'));
	   }
    });
	
	$('.progress').attr('alt', localiseString('topic_not_started'));
	$('.progress').attr('title', localiseString('topic_not_started'));
	
	$(".menu_grid h1").html(document.courseTitle);
	//$(".home_title h1").html(document.courseTitle);
	//$(".home_title").css("display","block");

	$(".retake_assess_btn").html(localiseString('retake_test_button'));
	/* pre-test no topics associated with questions support kgs 03/18/22 */
	if (document.noTopicsAssociatedPretest)
	{
		$(".home_assess_btn").html(localiseString('home_assess_button'));
	}	
	$(".confirm_attest_btn").html(localiseString('confirm_attest_button'));
    
    $(".hotspot_close").attr('title',localiseString('hotspot_close'));
    
    if(!document.showFooterNav){
        $(".topic_nav_button").css("display","none");
        $(".topic_nav_bar").css("height","100px");
        $(".topic_nav_bar .branding").css("top","50px");
    }
    
    if(!document.showResourcesButton){
		/* when there is no resource button and no multi-sco reduce the width of the banner mjb/kgs 03/17/22 */
		$('.bar_robot .page').attr('style', 'display: none !important');
		$('.index_banner .page').attr('style', 'display: none !important');
		$('.bar_robot .page').css('visibility','hidden');
		$('.index_banner .page').css('visibility','hidden');
		if (!document.isMultiSco)
		{
			$(".index_banner").css("width", "220px");
			$(".menu_flex").css("width", "220px");
		}	
    }
    
}


/* 20220628 JAWS fix to stop item being read when course launches */
$(":input").attr("aria-hidden", true);
$('#left_nav').attr("aria-hidden", true);
$('#home_nav').attr("aria-hidden", true);
$('#right_nav').attr("aria-hidden", true);
$('.qItemFirst').attr("aria-hidden", true);
/* 20220628 JAWS fix to stop item being read when course launches */



/* updated to select via specific language */
function localiseString(identifier){
	if(eval("document.langStrings_" + document.selectedLang).hasOwnProperty(identifier)){
		return eval("document.langStrings_" + document.selectedLang)[identifier];
	}else{
		return "Lang string unknown";
	}
}


/*var courseTimer = setTimeout(function(){
	
	alert("close course")
	window.top.close();
	
},10000)*/


function setRTL(){
	
	if(document.textDirection == "rtl"){
	
	
		$(".menu_flex").addClass("menu_flex_RTL");

		$(".index_banner").addClass("menu_flex_RTL");
		
		$(".menu_header_content").addClass("menu_header_content_RTL");
		
		$(".menu_header_image").addClass("menu_header_image_RTL");
		
		$(".menu_btn_title").addClass("menu_btn_title_RTL");
		$(".menu_container").addClass("menu_container_RTL");
		$(".menu_btns_holder").addClass("menu_btns_holder_RTL");
		$(".menu_header_dec").addClass("menu_header_dec_RTL");
		
		$(".topic_select").addClass("topic_select_RTL");
		
		$("ul li").css("background-image", "none")
		
		$("ul li").css("list-style", "square")
		
		
		$(".burger_progress").addClass("burger_progress_RTL");
		$(".burger_start_img").addClass("burger_start_img_RTL");
		$(".burger_close").addClass("burger_close_RTL");
		$(".burger_sec").addClass("burger_sec_RTL");
		$(".burger_select_title").addClass("burger_select_title_RTL");
		$(".burger_bg").addClass("burger_bg_RTL");
		
		
		
		$(".section_title").addClass("section_title_RTL");
		
		$(".icon_leadin").addClass("icon_leadin_RTL");
		$(".icon_holder").addClass("icon_holder_RTL");
		
		$(".icon_content").css("text-align", "right");
		
		
		$(".text_image_text").addClass("text_image_text_RTL");
		
		$(".text_image_left").addClass("text_image_left_RTL");
		
		$(".text_image_right").addClass("text_image_right_RTL");
		
		
		$(".question_container").addClass("question_container_RTL");
		$(".qItemFirst").addClass("qItemFirst_RTL");
		
		$(".optionHolder").addClass("optionHolder_RTL");
		
		$(".question_leadin").addClass("question_leadin_RTL");
		$(".submit_holder").addClass("submit_holder_RTL");
		$(".feedback_text").addClass("feedback_text_RTL");
		$(".mc_btn").addClass("mc_btn_RTL");
		
		
		$(".expando_btn").addClass("expando_btn_RTL");
		$(".expando_reveal_heading").addClass("expando_reveal_heading_RTL");
		$(".expando_decal").addClass("expando_decal_RTL");
		
		$(".slide_left").addClass("slide_left_RTL");
		$(".slide_right").addClass("slide_right_RTL");
		$(".slider_container").addClass("slider_container_RTL");
		
		$(".decal_left").addClass("decal_left_RTL");
		
		$(".image_leadin").addClass("image_leadin_RTL");
		$(".image_ind").addClass("image_ind_RTL");
		
		
		$(".tItem_left_content").addClass("tItem_left_content_RTL");
		$(".tItem_right").addClass("tItem_right_RTL");
		$(".tLineVert").addClass("tLineVert_RTL");
		$(".tLineVertSingle").addClass("tLineVertSingle_RTL");
		$(".tLineHoriz").addClass("tLineHoriz_RTL");
		$(".timeline_item").addClass("timeline_item_RTL");
		
		$(".image_hotspot_reveal_holder").addClass("image_hotspot_reveal_holder_RTL");
		$(".image_hotspot_leadin").addClass("image_hotspot_leadin_RTL");
		$(".hsp_img").addClass("hsp_img_RTL");
		
		$(".hotspot_image").addClass("hotspot_image_RTL");
		
		$('.pageMenu .active:after').css(
			{
				'border-top-width': '22px',
				'border-left-width': '22px',
				'border-right-width': '22px'
			}
		)
		
		$(".four_image_btn").addClass("four_image_btn_RTL");
		$(".popup_close").addClass("popup_close_RTL");
		$(".four_image_reveal_text").addClass("four_image_reveal_text_RTL");
		
		
		$(".flip_card_back").addClass("flip_card_back_RTL");
		
		$(".flip_card").addClass("flip_card_RTL");
		$(".flip_card_inner").addClass("flip_card_inner_RTL");
		
		$('#right_nav').addClass('locked');
		
		$(".box_closer").addClass("box_closer_RTL")
		
		//$(".topic_nav_bar .branding .logo_img").addClass("logo_img_RTL")
		
		$('.topic_nav_bar .branding .logo_img').css(
			{
				'float': 'none',
				'float': 'left'
			}
		)
		
		
		$(".tab_reveal_img").addClass("tab_reveal_img_RTL");
		
		$(".topic_nav_button").addClass("topic_nav_button_RTL")
		
	}else{
		$(".index_banner").css("right", "0");
		$(".menu_flex").css("right", "0");
	}
	
	if(!document.isMultiSco){
		$(".switchLang").css("display","none");
	}
	
	if(document.hasBranches){
		
		if(document.userBranch == 0){
		
			$(".menu_grid").css("display","none");
			$(".branch_grid").css("display","none");
			$(".recap_grid").css("display","block");
		}else{
			$(".branch_grid").css("display","none");
			$(".recap_grid").css("display","none");
		}
	}else{
		/*$(".menu_grid").css("display","block");*/
		$(".branch_grid").css("display","none");
		$(".recap_grid").css("display","none");
	}
}

/* 20221021 ensure burger menu window is focused on and cannot be tabbed out of */
$('.burger_index').find('.burger_close').on('keydown', function(e) {
	if ((e.which == 9) && (!e.shiftKey)) {
		e.preventDefault();
		$('.burger_index').find('.burger_scroll').focus();
	}
});

/* 20221021 ensure burger menu window is focused on and cannot be tabbed out of */
$('.burger_index').find('.burger_close').on('keydown', function(e) {
	if ((e.which == 9) && (e.shiftKey)) {
		e.preventDefault();
		$('.burger_index').find('.burger_scroll').focus();
	}
});

/* 20221021 ensure burger menu window is focused on and cannot be tabbed out of */
$('.burger_index').find('.burger_scroll').on('keydown', function(e) {
	if ((e.which == 9) && (e.shiftKey)) {
		e.preventDefault();
		$('.burger_index').find('.burger_close').focus();
	}	
});