/* functions to handle preliminary content tasks such as assigning responsive background images and setting up the assessment */
$( document ).ready(function() {
	/* write the media queries for background images of topic intros and reflection screens to the header tag */
	document.buildBgImgCSS = function ()
	{
		var topicCount = document.reflectionsArr.length + 1;
		var titlesCSS = "";
		for (var i = 1; i < topicCount; i++)
		{			
			titlesCSS += ".topic_intro_grid_" + i + " { background-image:url('images/topic_title_" + i + ".png'); } ";
			
			for (var ia = 1; ia < (document.bgImageArr[i - 1] + 1); ia++){
				titlesCSS += ".text_image_bg_" + i + "_" + ia + " { background-image:url('images/image_bg_" + i + "_" + ia + ".png'); } ";
			}
			
			for (var ib = 1; ib < (document.sliderBGArr[i - 1] + 1); ib++){
				titlesCSS += ".slider_bg_" + i + "_" + ib + " { background-image:url('images/slider_" + i + "_" + ib + "_1.png'); } ";
			}
			
		}
		
		$("<style>")
			.prop("type", "text/css")
			.html(titlesCSS)
			.appendTo("head");	
	};
	/* randomize the assessment questions */
	document.randomizeAssessment = function ()
	{		
		document.assessRandomQuesArr = [];		
		document.currentAssessQues = 0;		
		document.assessStartQuesArr = post_test_ques_dat['test_dat'][0].start_section_num.split(',');
		document.assessEndQuesArr = post_test_ques_dat['test_dat'][0].end_section_num.split(',');
		document.assessSelectQuesArr = post_test_ques_dat['test_dat'][0].select_ques.split(',');
		document.assessTotalQues = 0;
		var testQuesTempArr = [];
		
		//20190508 Added for un randomised with no pre-test
		document.assessTopicHasQBank = post_test_ques_dat['test_dat'][0].topic_has_qbank.split(',');
		
		/* test out: if there is a pre-test in the course */
		if (document.pretestPresent == 1)
		{
			document.assessTopicHasQBank = post_test_ques_dat['test_dat'][0].topic_has_qbank.split(',');
			var testScore = actionsLMSGetScore();
			testScore = testScore == "" ? 0 : Number(testScore);
			/* test out: obtain the status of what topics have been tested out of */			
			var tempTPretestOutArr = document.topicsPretestedOut.split('');		
			/* test out: if all topics have been tested out of or the test was passed then reset the tested out topics but only locally */
			if ((document.topicsPretestedOut.substring(0,document.topicsCount - 2).indexOf('0') == -1) || (testScore >= document.assessPassmark))
			{
				for (var n = 0; n < document.assessSelectQuesArr.length; n++)
				{
					tempTPretestOutArr[n] = 0;
				}
			}
			for (var i = 0; i < document.assessSelectQuesArr.length; i++)
			{
				/* test out: if this topic was not tested out of then add its questions to the overall count */
				if (tempTPretestOutArr[i] == 0)
				{
					document.assessTotalQues = document.assessTotalQues + Number(document.assessSelectQuesArr[i]);				
				}
			}
		}
		else
		{
			for (var i = 0; i < document.assessSelectQuesArr.length; i++)
			{
				document.assessTotalQues = document.assessTotalQues + Number(document.assessSelectQuesArr[i]);
			}
		}	
		if (document.assessRandomize) {
			for (var j = 0; j < document.assessSelectQuesArr.length; j++)
			{
				/* test out: if there is a pre-test in the course */
				if (document.pretestPresent == 1)
				{				
					/* test out: if this topic has a question bank and the topic has not been tested out of then include this topics questions in the test */
					if ((document.assessTopicHasQBank[j] != "0") && (tempTPretestOutArr[j] == 0))
					{				
						while (testQuesTempArr.length != Number(document.assessSelectQuesArr[j])) {
							testQuesExists = false;
							randomTestQues = Math.floor(Math.random() * (Number(document.assessEndQuesArr[j]) - Number(document.assessStartQuesArr[j]) + 1)) + Number(document.assessStartQuesArr[j]);
							for (var k = 0; k < Number(document.assessSelectQuesArr[j]); k++) {						
								if (typeof testQuesTempArr[k] != 'undefined') {						
									if (testQuesTempArr[k] == randomTestQues) {							
										testQuesExists = true;
									}
								}						
							}
							if (!testQuesExists) {
								testQuesTempArr.push(randomTestQues)
								document.assessRandomQuesArr.push(randomTestQues);
							}
						}
						testQuesTempArr = [];
					}	
				}
				else
				{
					while (testQuesTempArr.length != Number(document.assessSelectQuesArr[j])) {
						testQuesExists = false;
						randomTestQues = Math.floor(Math.random() * (Number(document.assessEndQuesArr[j]) - Number(document.assessStartQuesArr[j]) + 1)) + Number(document.assessStartQuesArr[j]);
						for (var k = 0; k < Number(document.assessSelectQuesArr[j]); k++) {						
							if (typeof testQuesTempArr[k] != 'undefined') {						
								if (testQuesTempArr[k] == randomTestQues) {							
									testQuesExists = true;
								}
							}						
						}
						if (!testQuesExists) {
							testQuesTempArr.push(randomTestQues)
							document.assessRandomQuesArr.push(randomTestQues);
						}
					}
					testQuesTempArr = [];
				}
			}
		}
		else {
			for (var m = 0; m < document.assessSelectQuesArr.length; m++)
			{
				/* test out: if there is a pre-test in the course */
				if (document.pretestPresent == 1)
				{			
					if ((document.assessTopicHasQBank[m] != "0") && (tempTPretestOutArr[m] == 0))
					{
						for (var n = Number(document.assessStartQuesArr[m]); n < (Number(document.assessEndQuesArr[m]) + 1); n++) {
							document.assessRandomQuesArr.push(n);
						}
					}
				}
				else
				{
					if (document.assessTopicHasQBank[m] != "0" || document.assessTopicHasQBank[m] != 'undefined'){
						for (var n = Number(document.assessStartQuesArr[m]); n < (Number(document.assessEndQuesArr[m]) + 1); n++) {
							if(n != 0 || n!= '0'){
								document.assessRandomQuesArr.push(n);
							}
						}
					}
				}
			}
		}
		if (document.assessRandomize) {
			document.assessRandomQuesArr = fisherYates(document.assessRandomQuesArr);
		}
		document.assessRandomQuesArr.push(document.testResultsSubsection);		
	}
	
	
	document.randomizePreQuestions = function (){
		
		
		document.preQuesArr = [];		
		document.currentPreQues = 0;		
		document.preStartQuesArr = topic_pre_ques_dat['test_dat'][0].pre_start_sec_num.split(',');
		document.preEndQuesArr = topic_pre_ques_dat['test_dat'][0].pre_end_sec_num.split(',');
		document.preSelectQuesArr = topic_pre_ques_dat['test_dat'][0].pre_sel_ques.split(',');
		document.preTotalQues = 0;
		var testQuesTempArr = [];
		
		
		document.preTopicHasQBank = topic_pre_ques_dat['test_dat'][0].topic_pre_qbank.split(',');
		
		var start = 0;
		var end = 0;
		
		
		for(var i = 0; i!= document.topicsCount; i++){
			
			var tempArr = []
			
			start = Number(document.preStartQuesArr[i]);
			end = Number(document.preEndQuesArr[i]);
			
			for(var j = start; j <= end; j++){
				
				tempArr.push(j);
	
			}
			
			if(document.randomizeTopicPreTest){
				
				tempArr = fisherYates(tempArr);
			}
			
			//console.log("tempArr = " + tempArr)
			document.preQuesArr.push(tempArr);
		}
		
		//console.log("document.preQuesArr = " + document.preQuesArr)
		
		
	}
	
	
	/* function to randomize an array based on Fisher Yates algorithm */
	function fisherYates(myArray) {
		var i = myArray.length;
        if (i == 0) return false;
        while (--i) {
            var j = Math.floor(Math.random() * (i + 1));
            var tempi = myArray[i];
            var tempj = myArray[j];
            myArray[i] = tempj;
            myArray[j] = tempi;
        }
		return myArray;
    }
	
	document.buildBgImgCSS();
});