/* variables used for course-specific text */
/* DEV NOTE indicates that the variable should be updated for the course */

$( document ).ready(function() {

	/* DEV NOTE: string for course title */
	document.courseTitle = "Beszállítói hitelkockázattal kapcsolatos alapvető ismeretek";

	/* DEV NOTE: strings for topic titles which are used in the pre-test results */
	document.topicTitles = {
		titles:[
			{title:"Üdvözöljük!"},
			{title:"Beszállítói hitelkockázati csoport"},
			{title:"Harmadik felek kezelése program"},
			{title:"Érdekelt felek szerep- és felelősségi körei"},
			{title:"A Beszállítói hitelkockázati csoport (TPCRG) működés közben"},
			{title:"Befejezés"},
			{title:"Értékelés"}
		]
	}	
		
	/* DEV NOTE: string for the intro text on the pre-test message that appears asking the learner if they want to take the pre-test; if there is no pre-test make this an empty string */
	document.pretestIntro = "Már elsajátította a <strong>Beszállítói hitelkockázattal kapcsolatos alapvető ismereteket?</strong>"
	
	/* DEV NOTE: strings for text that is used on the pre-test and post-test intro pages; if there is no pre-test make the pre-test string an empty string */
	test_intro_dat = {
		pre_test:[{
			generic_msg:'Üdvözöljük az előzetes tesztelési részben!<br><br>Minden kérdés esetében egy próbálkozásra van lehetősége, és a tesztet megszakítás nélkül kell kitöltenie. Ha helytelenül válaszol valamelyik kérdésre, akkor a tanfolyam tartalmához irányítjuk, és nem tudja kitölteni a tesztet. Ha időközben megszakítja a kitöltést, nem fogja tudni ott folytatni, ahol abbahagyta, és nem tudja kitölteni a tesztet.<br><br>Ha minden témakörben maximális pontszámot ér el, akkor ezzel teljesíti is a tanfolyamot.<br><br>Ha nem végzi el az \'előzetes tesztelési\' részt, akkor az adott tanfolyami tartalmat a szokásos módon kell elvégeznie. A végső tesztelés során minden témakörre vonatkozóan fog kérdéseket kapni.<br><br>A folytatáshoz görgessen lefelé.',
			title:'Üdvözöljük!',
			subtitle:'Tesztelési utasítások'
			
		}],
		post_test:[{
			generic_msg:'<p>A következő öt kérdés lehetőséget ad Önnek, hogy bemutassa, mennyire jól értette meg a tanultakat.</p><p>Az értékelés sikeres teljesítéséhez legalább 80%-os eredményt kell elérnie.</p><p>Ha megkezdi az értékelés kitöltését, a vonatkozó pontszám megszerzéséhez valamennyi kérdést meg kell válaszolnia. Ez az utolsó kérdés után jelenik meg az eredményoldalon.</p><p class="instruction">A folytatáshoz görgessen lefelé.</p>',
			title:'Értékelés',
			subtitle:'Értékelési utasítások',
			test_complete_title:'Tanfolyam teljesítve',
			test_complete_msg:'<p>Mivel Ön már megkapta a képzés teljesítéséről szóló igazolást, nincs szükség végső értékelésre, ezért ezt a részt Ön nem is fogja látni. Köszönjük!</p><p>A kilépéshez válassza az X-et a képernyő jobb felső sarkában.</p>'
			
		}]
	}
	
	/* DEV NOTE: strings for text that is used on the pre-test and post-test results page before the score and for the pass and fail messages; if there is no pre-test make the pre-test strings empty strings */
	test_results_dat = {
		pre_test:[{
			pass_msg:'Nagyszerű! Gratulálunk! Ön sikeresen teljesítette az előzetes tesztelést! Úgy tűnik, hogy Ön már alapos tudással rendelkezik a beszállítói hitelkockázattal kapcsolatos alapvető ismeretekről!<br><br>Ön helyes válaszokat adott a tanfolyam elvégzése előtti értékelő kérdésekre, ezért automatikusan átlépheti a képzést.<br><br>Ha szeretné áttekinteni a tartalmat, válassza a Kezdőlap gombot. A kilépéshez kattintson az X-re a képernyő jobb felső sarkában, hogy rögzítse a képzés befejezését, majd kilépjen a tanfolyamból.<br><br>A hasznos linkek listája bármikor elérhető az Ismeretforrások gombra kattintva. Ha a tanfolyamot egy személyes eszközről közvetlenül az interneten keresztül (a Citi hálózatán kívülről) éri el, előfordulhat, hogy egyes hivatkozások nem működnek, amennyiben a Citi hálózatán belüli tartalomra mutatnak. Ez nem befolyásolja a tanfolyam elvégzését.',
			pass_msg_2:'Gratulálunk, Ön sikeresen teljesített az előzetes tesztelést! Az alábbi témakör(ök)ben sikeresen teljesítette az előzetes tesztelés követelményeit:',
			pass_msg_3:'Átugorhatja a „megfelelt” jelöléssel ellátott témakör(öke)t, de a többi témakörre vonatkozóan el kell végeznie a képzést. A kezdéshez nyomja meg a Kezdőlap gombot.<br><br>Ha elkészült, akkor teljesítette a tanfolyamot. Nagyszerű!',	
			pass_msg_4:'A tanfolyam teljesítettként van jelölve, de érdemes lehet átnéznie azokat a témaköröket, amelyek nincsenek teljesítettként megjelölve.',	
			fail_msg_1:'Köszönjük, hogy elvégezte az előzetes tesztelést! Az alábbi megjelölt témakör(ök)ben sikeresen teljesítette az előzetes tesztelés követelményeit:',
			fail_msg_2:'Kérjük, válassza a Kezdőlap gombot a Beszállítói hitelkockázati alapvető ismeretek áttekintéséhez. Átugorhatja a megjelölt témakört, viszont teljesítenie kell a meg nem jelölt témakör(öke)t.<br><br>Ha elkészült, a tanfolyam befejezéséhez ki kell töltenie egy tesztet, amely a meg nem jelölt témakör(ök)ből származó kérdéseket tartalmazza.',
			fail_msg_3:'Köszönjük, hogy megpróbálta elvégezni az előzetes tesztelést! Sajnáljuk, de nem teljesítette a tesztkövetelményeket. Nem érte el a minimálisan szükséges pontszámot ahhoz, hogy sikeresen teljesítse az értékelést és kreditet kapjon a tanfolyamért.<br><br>A kezdéshez nyomja meg a Kezdőlap gombot.',
			result_title:'A tesztelés eredményei'
		}],
		post_test:[{
			generic_msg:'Az Ön pontszáma: ',
			pass_msg:'Gratulálunk!<br><br>Ön sikeresen teljesítette az értékelést.<br><br>Kattintson az X-re a képernyő jobb felső sarkában, hogy rögzítse a képzés befejezését, és hogy kilépjen a tanfolyamból.',
			/* DEV NOTE: string below can be used instead when there is a pre-test and there are no topics associated with test questions; otherwise delete */
			/*
			pass_msg:'Gratulálunk!<br><br>Ön sikeresen teljesítette az értékelést.<br><br>Kattintson az X-re a képernyő jobb felső sarkában, hogy rögzítse a képzés befejezését, és hogy kilépjen ebből a tanfolyamból.',
			*/
			pass_review_msg:'Lefelé görgetve láthatja, hogy mi a helyes válasz a hibásan megválaszolt kérdésre.',
			fail_msg:'Sajnos nem sikerült eleget tennie az értékelés teljesítéséhez szükséges követelményeknek.<br><br>Válassza az Értékelés megismétlése gombot az újbóli próbálkozáshoz, vagy válassza a Kezdőlap gombot a tartalom áttekintéséhez az értékelés megismétlése előtt.',
            fail_max_msg:'Sajnáljuk, de három alkalommal próbálkozott sikertelenül.<br><br>Úgy tűnik, újra át kell néznie a tanfolyam anyagát.<br><br>A folytatáshoz kattintson a Tanfolyam megismétlése lehetőségre.',
			result_title:'Az értékelés eredményei!',
			/* DEV NOTE: string below can be used instead when there is a pre-test and there are no topics associated with test questions; otherwise delete */
			/*
			result_title:'Teszteredmények'
			*/
			result_review_msg_1:'Kérdés:',
			result_review_msg_2:'Opciók:',
			result_review_msg_3:'Visszajelzés:'
		}]
	}
	
	/* DEV NOTE: strings for text that is used on the attestation page before and after the attesting */
	attestation_dat = {		
		attestation:[{
			pre_attesting_msg:'Kérjük, igazolja a következőt:<br><br>Ezennel megerősítem, hogy elolvastam és teljes mértékben megértettem a svájci CID eszkalációs eljárást, és hogy annak szabályait mindenkor szigorúan betartom.',
			attested_msg:'Köszönjük, hogy megerősítette.<br><br>Gratulálunk! Sikeresen elvégezte ezt a képzést. Most már kiléphet a tanfolyamból. Köszönjük részvételét!'
		}]
	}
	
	/* DEV NOTE: strings for the transcript titles and content separated by section id */
	transcript_dat = {
		sec_3:[{
				title:'Átirat – 1. videó',			
				transcript:'<p></p>'
		}]
	}
	
	/* DEV NOTE: strings for the hotword titles and content separated by hotword id */
	hotword_dat = {
		
		hw_1:[{
				title:'Pénzügyi kockázati besorolások',				
				text:'<p>A Pénzügyi kockázati besorolást belső használatra szánják, ezért <strong>nem</strong> osztható meg a beszállítókkal.</p>'
		}]
	}
	
	/* DEV NOTE: strings for the link URLs separated by link id; if there are no links make this variable an empty array */
	link_dat = {
		lnk_1:[{
				url:'https://share.nam.nsroot.net/sites/cc-third-party-management-office-tpmo/External%20L3%20Procedures/L3%20-%20Assess%20Financial%20Risk.pdf'
		}],
		lnk_2:[{
				url:'https://www.citi.net/EN/Pages/riskmanagement/News/third-party-credit-risk-group-tpcrg-introduces-new-escalation-guidelines.aspx'
		}]
	}
	
	/* DEV NOTE: strings for the resource popup title and content */
	resource_dat = {
		resources:[{
				title:'Források',				
				text:'<p><a data-lnk-id="lnk_1" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Pénzügyi kockázat értékelése L3-as eljárás</a></p>'
		}]
	}

	/* DEV NOTE: strings for LMS errors */
	lms_error_dat = {
		lms_error_1:[{
				text1:'Az API nem található.',
				text2:'Megszakadt a kommunikáció. Kérjük, zárja be a tanfolyamot, és indítsa újra egy későbbi időpontban. Ne folytassa, mivel előrehaladása vagy a teszt teljesítése nem lesz nyomon követhető. Az utolsó sikeres mentési pontról újra tudja indítani a tanfolyamot.'
        }]		
	}
});