/* functions to allow navigation between topics */

var currentSec = 0
var nav = false

document.topic_complete=[]
	if(document.topic_intro === "no"){
		$('.sec_1_wrapper').hide()
		$('.sec_rest_wrapper').css('margin-top','0')
	}else{
		$('.bar_robot').hide()
		$('.sec_1_wrapper').show()
		$('.sec_1_wrapper #topic_intro').show()
	}
	
/* hide previous topic and show next */
function gotoTopic(target){
	var op;
	var sec_saver = currentSec;
	if(target === 'right_nav' && currentSec < ($('.breaker').length-1)){
		if($("#sec_"+document.currentSection).hasClass("custom_nav")){
			
			var nextArr = $("#sec_"+document.currentSection).attr("data-gonext").split("_");
			
			if(nextArr.length == 1){
				currentSec = Number(nextArr[0])-1;
			}else{
								
				currentSec = Number(nextArr[document.userBranch-1])-1;
			}
			
		}else{
			currentSec++
		}
		startedTopic(currentSec)
		op = 'left'
		nav = true
		cloneOne(target, sec_saver, nav, op)
	}else if(target === 'left_nav'  && currentSec >=1){
		if($("#sec_"+document.currentSection).hasClass("custom_nav")){
			
			var backArr = $("#sec_"+document.currentSection).attr("data-goback").split("_");
			
			if(backArr.length == 1){
				currentSec = Number(backArr[0])-1;
			}else{
				
				currentSec = Number(backArr[document.userBranch-1])-1;
			}
			
		}else{
			currentSec--
		}
		startedTopic(currentSec)
		op= 'right'		
		nav = true
		cloneOne(target, sec_saver, nav, op)
	}else if(target === 'topic_select'){
		indexTopic(currentSec)
		isCourseLocked()
	}
	topicTitle()
	nav = false
	
	getSliderHeight(); // Slider height fix
	pauseAllVideos(); // Pause all videos
}

/* what screens to unlock */
function isCourseLocked(){ 
	var currentbreaker = $('.breaker').eq(currentSec)
	var nextbreaker = $('.breaker').eq(currentSec + 1)
	var introSec = '#'+$('.breaker').eq(currentSec).attr('id');	
	$('.sec_rest_wrapper').eq(0).children().css('display', 'none')
	$('.breaker').eq(currentSec).css('display','block');
	if(document.courseLockedDown == false && !currentbreaker.hasClass('testStartSec')){
		currentbreaker.nextUntil(nextbreaker).css('display','block')
	}else{
		oraginiseLocking()
		unlockPages()
	}
	downButton()
	lockNav()
	progress()
	resizeCheckBox()
	if(!isWeb){
		rePosBanner(); /* reposition banner when navigating menu */
	}
	setTimeout(function(){
		setTopicIntro(introSec);
	},750)
}

/* set up topic transition */
function cloneOne(direction, sec_saver, nav, op){
	if($(window).scrollTop() == 0 || isiPad || isAndroidTablet|| isiPhone || isAndroidPhone){ /* saba cloud app and Mobile Devices */
		$("#topic_loader").show()
		$('.sec_rest_wrapper').css('display', 'none')
		isCourseLocked()
		loading(nav, op, margin)
	}else{	/* Desktop Animation */
		var margin;
		if(currentSec > sec_saver){
			margin = '100%'
			}else{
			margin = '-100%'
		}
		if(document.topic_intro === "yes"){
			$('.sec_1_wrapper').clone().addClass('clone_wrapper').appendTo('body').wrap('<div class="clone"></div>')
			$('.clone_wrapper').css({'position':'fixed'})
			$('.clone_wrapper').find(".bg_video").remove()
			$('.clone_wrapper #topic_intro').css({'left':margn})
			$('.clone_wrapper #topic_intro .menu_bar.bar_bot').css({'top':'auto'})
		}
		if(document.topic_intro === "no"){
			$("#topic_loader").after($('.sec_rest_wrapper .breaker:eq('+currentSec+')').clone().addClass('clone_breaker'));
			$('.clone_breaker').wrap('<div class="clone_wrapper sec_rest_wrapper" style="opacity:1; position:fixed; margin-top:0px"></div>');
			/*$('.clone_wrapper.sec_rest_wrapper').children().hide();*/
			$('.clone_wrapper.sec_rest_wrapper div.breaker:eq(0)').css('display', 'block');
			/*$('.clone_wrapper.sec_rest_wrapper div.breaker:eq('+currentSec+')').next().css('display', 'block');*/
			if(isWeb){
				$('.clone_wrapper.sec_rest_wrapper').css({'transform':'translate('+margin+', 0)'});
			}else{
				$('.clone_wrapper.sec_rest_wrapper').css({'transform':'translate('+margin+', 0)','position':'fixed'});
			}
		}
		
			loading(nav, op, margin);
			
		if(!isWeb){
			rePosBanner(); /* reposition banner when navigating menu */
		}
		
	}	
	
}

/* load intro image */
function loading(nav, op, margin){
	var topicImage = currentSec+1
	if($('.topic_intro_grid_'+topicImage+'').length > 0){
	var bg = $('.topic_intro_grid_'+topicImage+'').css('background-image')
	bg = bg.replace('url(','').replace(')','').replace(/\"/gi, "");
	$('<img/>').attr('src', bg).load(function() {
		if(typeof margin != 'undefined'){
			$(this).remove();
			if($('.clone_wrapper.sec_rest_wrapper').css('transform') !== 'translate(0, 0)'){
			videoorimage(nav, op)
			}
		}else{
			$("#topic_loader").delay(750).fadeOut(0)
			setTimeout(function(){
				$('.sec_rest_wrapper').css('display', 'block')
				//20210318 desktop portrait fix
				portraitTestFix();
				
			},750)
		}
	});
	}else{
		if($('.clone_wrapper.sec_rest_wrapper').css('transform') !== 'translate(0, 0)'){
			videoorimage(nav, op)
		}
	}
}

/* into video or image */
function videoorimage(nav, op){
	if(nav === true){
		if(document.topic_intro === "yes"){	
			if(document.intro_back[currentSec].type === "video"){
				video_src = document.intro_back[currentSec].mp4
				loadVideo(video_src)
				$("#topic_intro .background_stretch").hide()
				$(".bg_video video")[0].onloadeddata = function() {
					topicAnim(nav, op);
					$(".bg_video video")[0].onloadeddata = false}
			}else{
				if(document.intro_back[currentSec].type === "color"){
					$("#topic_intro .background_stretch").css("background-color", document.intro_back[currentSec].color);
				}else{
					$("#topic_intro .background_stretch").css("background-image", document.intro_back[currentSec].path);
				}
			}	
		}
		if(op!==null){
			topicAnim(nav, op)
		}
	}
}

/* start animation */
function topicAnim(nav, op){
	var anim_length = 1000
	if(document.topic_intro === "yes"){	
		$('.sec_rest_wrapper, .clone_wrapper #topic_intro').stop().animate({ 'left' : op}, anim_length, function(){
			$("html, body").animate({scrollTop:0}, 0)
			$('.sec_rest_wrapper').css({ 'left': '0'})
			$('.topic_nav_bar').css('display','none')
		})
	}
	if(document.topic_intro === "no"){
		$('body').css({'overflow-y': 'scroll'})
		$(".sec_rest_wrapper:eq(1)").addClass('loading_timer clone_move_'+op)
		$(".sec_rest_wrapper:eq(0)").addClass('loading_timer body_move_'+op)
			if(isWeb){
				setTimeout(function(){
				$(".sec_rest_wrapper:eq(0), .sec_rest_wrapper:eq(1)").removeClass('loading_timer body_move_'+op+' clone_move_'+op+'')
				isCourseLocked()
				$("html, body").animate({scrollTop:0}, 0)
				$('.topic_nav_bar').css('display','none')
				$('body').find(".clone_wrapper").remove()
				$('.sec_rest_wrapper').css({ 'left': '0'})
				$('body').css({'overflow-y': 'visible'})
					//20210318 desktop portrait fix
					portraitTestFix();
					
					/* 20231018 video and audio accessibility */
					/*$("#sec_" + (document.currentSection+1) + " .page_start").focus();*/
					
				},950)
			}else{ /* mobile devices */
				$(".sec_rest_wrapper:eq(0)").removeClass('loading_timer body_move_'+op+'')
				isCourseLocked()
				$("html, body").animate({scrollTop:0}, 0)
				$('.topic_nav_bar').css('display','none')
				$('.sec_rest_wrapper').css({ 'left': '0'})
				setTimeout(function(){
					$('body').find(".clone").remove()
					//20210318 desktop portrait fix
					portraitTestFix();
				},200)
			}
		
	}
}

function indexTopic(currentSec){
	if(index===true){
		if(document.topic_intro === "yes"){
			if(document.intro_back[currentSec].type === "video"){
				loadVideo()
				$(".bg_video video")[0].onloadeddata = function(){
					topic_closer()
				}
			}else{
				if(document.intro_back[currentSec].type === "color"){
					$("#topic_intro .background_stretch").css("background-color", document.intro_back[currentSec].color);
				}else{
					$("#topic_intro .background_stretch").css("background-image", document.intro_back[currentSec].path);
				}	
				$("html, body").animate({scrollTop:0}, 0)
				topic_closer()
			}
		}else{
			topic_closer()
		}
	}
}

/* event handlers */
$('#right_nav, #left_nav').click(function(e){
	//* 2022 Accessibility Update */
	if(!$(this).hasClass('locked')){
		/* test out: if there is a pre-test in the course and it is being taken */
		if ((document.pretestPresent == 1) && document.takingPretest)
		{
			if($(this).attr('id') == 'right_nav') {
				/* test out: update the Menu icons and reset for the post-test */
				exitPretest();
				/* test out: do not bookmark the pre-test upon leaving it */
				document.pretestDone = true;
				/* test out: go to the Summary topic */
				gotoTopic('left_nav');
			}
		}	
		else {
			/* 2021 Accessibility Update */
			gotoTopic(e.target.id);
			if($(this).attr('id') == 'right_nav') {
				lockTopics(true);
			}
			else {
				lockTopics(false);
			}
		}
		/* 2021 Accessibility Update */
		removeMenuTabIndex(); // remove menu tab functionality
		setNavTab();
		$('.home').focus();
		
		/* 20230913 tracking fixes: ensure confidence has been chosen before trying to disable a confidence question, disable likert/survey questions when answered, remove first likert/survey question when return to topic after answered, do not send cmi.interactions if inline/kc question does not have track_quest class */
		$('.likert_scale_first').each(function(index, element) {
			var indexNum = $(this).index(".section");
			if (document.allTimeAssessAttempts > document.maxAssessAttempts)
			{
				document.lockedArr[indexNum] = 0;
			}
			if((document.trackingArr[indexNum] == 1) || (document.lockedArr[indexNum] == 0))		
			{
				$('#sec_'+ (indexNum + 1)).css('background-image','none');
				$('#sec_'+ (indexNum + 2)).css('background-image','url("images/gs049_201008_bg.jpg');
				$('#sec_'+ (indexNum + 1)).css('height','1px');
				$('#sec_'+ (indexNum + 1)).find('.container').html('');
				$('#sec_'+ (indexNum + 1)).find('.container').css('height','1px');
			}
		});
	}
});

/* keyboard functionality */
$('#right_nav, #left_nav').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {
		/* 2022 Accessibility Update */
		$(this).trigger('click');
	}		
});

/* 2021 Accessibility Update */
$('#right_nav').on('keydown', function(e) {
	if ((e.which == 9) && (!e.shiftKey))
	{	
		/* 2022 Accessibility Update */
		if (($('.testResults').css('display') != "block") || ($('#home_nav').hasClass('pretest')))
		{			
			e.preventDefault();
			$(this).focus();
		}	
	}
});

$('.topic_select').click(function(e){
	/* test out: if there is a pre-test in the course */
	if (document.pretestPresent == 1)
	{
		/* test out: do not bookmark the pre-test upon leaving it */
		document.pretestDone = true;
	}	
	if(!isWeb){
		deviceAudio();
	}
	document.topic_complete=[]
	if($(this).children('.overlay').css('display')==='none'){
		//currentSec = $('.topic_select').index(this);
		currentSec = Number($(this).attr("data-gotopic"))
		
		if(currentSec == 0){
			
			showSplashVideo()
			
			if(document.hasBranches){
				showBranches();
			}
			
		}else{
			currentSec = currentSec-1;
			startedTopic(currentSec)
			gotoTopic('topic_select')
			$('.topic_nav_bar').css('display','none')
			$('.topic_closer').css('display','block')
			removeMenuTabIndex(); // remove menu tab functionality

			setNavTab(); /* 20180501 Accessibility Added tab functionality to Navigation Bar */
			
			/* 2021 Accessibility Update */
			$('.home').focus();
			
		}
	}
})

/* keyboard functionality */
$('.topic_select').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {
		
		$(this).trigger('click');
	}		
});

/* 2021 Accessibility Update */
$('.branding_menu .copyright').on('keydown', function(e) {
	if ((e.which == 9) && (!e.shiftKey))
	{
		e.preventDefault();
		$(this).focus();
	}
});

/* 2021 Accessibility Update */
$('.branding .copyright').on('keydown', function(e) {
	if ((e.which == 9) && (!e.shiftKey))
	{
		e.preventDefault();
		$(this).focus();
	}
});


$('.home, #home_nav').click(function(){
	if(index===false){
		/* test out: if there is a pre-test in the course */
		if (document.pretestPresent == 1)
		{
			/* test out: if currently taking the pre-test update the Menu icons and reset for the post-test */
			if (document.takingPretest) {			
				exitPretest();
			}
		}		
		if(isWeb && !isMacChrome){ /* potential fix for android freezing */
			$('#topic_nav_bar_menu').hide();
			$('.topic_index').css({'transition-duration': '1000ms', '-webkit-transition-duration':'1000ms'})
			$(".topic_index").removeClass("index_book")
			$(".topic_index_overlay").css({"display":"block"})
			$(".topic_index").css({"top":"0px"})
			setTimeout(function(){ 
			$(".topic_index").css('position','absolute')
			$( "html, body" ).scrollTop( 0 )
			$(".topic_index_overlay").css({"display":"none"})
			$(".sec_rest_wrapper").css('display', 'none')			
			$(window).css('overflow','visible');
			$(window.top).css('overflow','visible');
			$(parent.parent.document).css('overflow','visible');
			$("html, body" ).css('overflow','visible');
			//$('#topic_nav_bar_menu').show();	// 20230605 - Hide menu footer	
			}, 1200);
			$('.topic_index').removeClass('loading');
			$('.topic_index').addClass('loading_timer');
			$(window).css('overflow','visible');
			$(window.top).css('overflow','visible');
			$(parent.parent.document).css('overflow','visible');
			$("html, body" ).css('overflow','visible');
		}
		if(isiPad || isiPhone || isAndroidTablet || isAndroidPhone || isMacChrome){ /* to make menu button work on phone */
			$("#topic_loader").show()
			$('.sec_rest_wrapper').hide()
			$( "html, body" ).scrollTop( 0 )
			$(".bar_robot").removeClass('displayBlock').addClass('displayNone');
			setTimeout(function(){
				$('.topic_index').css('display', 'block')
				topic_height()
				//$('#topic_nav_bar_menu').show(); // 20230605 - Hide menu footer
				$("#topic_loader").hide()				
			},2000)
		}
		$('.bar_robot').css('display','none');
		$('.bar_bot').css('display','none');
		$(".bar_bot").removeClass('displayBlock').addClass('displayNone');
		$(".bar_robot").removeClass('displayBlock').addClass('displayNone');
		setMenuTabIndex();	// set menu tab functionality
		index = true
		
		pauseAllVideos(); // Pause all videos
		/* 2021 Accessibility Update */		
		$('.index_banner .page').focus();
		/* ensure post-test is reset when post-test is failed maximum times and course is reset 062122 */
		if ($('#retake_course_btn_div_' + document.testResultsSubsection).css('display') == 'block')
		{
			retakeAssessment();
		}
		
		/* 20230913 tracking fixes: ensure confidence has been chosen before trying to disable a confidence question, disable likert/survey questions when answered, remove first likert/survey question when return to topic after answered, do not send cmi.interactions if inline/kc question does not have track_quest class */
		$('.likert_scale_first').each(function(index, element) {
			var indexNum = $(this).index(".section");
			if (document.allTimeAssessAttempts > document.maxAssessAttempts)
			{
				document.lockedArr[indexNum] = 0;
			}
			if((document.trackingArr[indexNum] == 1) || (document.lockedArr[indexNum] == 0))		
			{
				$('#sec_'+ (indexNum + 1)).css('background-image','none');
				$('#sec_'+ (indexNum + 2)).css('background-image','url("images/gs049_201008_bg.jpg');
				$('#sec_'+ (indexNum + 1)).css('height','1px');
				$('#sec_'+ (indexNum + 1)).find('.container').html('');
				$('#sec_'+ (indexNum + 1)).find('.container').css('height','1px');
			}
		});
	}
})

/* keyboard functionality */
$('.home, #home_nav').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {
		
		$(this).trigger('click');
	}		
});

/* 2021 Accessibility Update */
$('.menu_title').on('keydown', function(e) {
    if ((e.which == 9) && (e.shiftKey)) {
		if (document.takingPretest)
		{
			e.preventDefault();
			$(this).focus();
		}	
    }
});

/* 2021 Accessibility Update */
$('.home').on('keydown', function(e) {
    if ((e.which == 9) && (e.shiftKey)) {		
        e.preventDefault();
		$(this).focus();
    }
});

/* 2021 Accessibility Update */
$('#home_nav').on('keydown', function(e) {
    if ((e.which == 9) && (!e.shiftKey)) {
		/* 2022 Accessibility Update */		
		if (($('#right_nav').css('display') == "none") && ($('.branding').eq(1).css('display') == 'none'))
		{
			e.preventDefault();
			$(this).focus();
		}
    }
});

/* 2021 Accessibility Update */
$('.index_banner .page').on('keydown', function(e) {
    if ((e.which == 9) && (e.shiftKey)) {		
        e.preventDefault();
		$(this).focus();
    }
});

$('.complete_arrow').click(function(e){
	if($(this).hasClass('unlocked')){
		/* trickle button functionality 2020 */
		/* mark the page as completed when the trickle button is clicked */
		var secNum = $(this).parent().attr('id').split('_')[1];
		markSectionComplete(secNum);
		pageCompleted = secNum;
		if ((secNum > document.testIntroSubsection) && (secNum < (document.testResultsSubsection + 1)))
		{
			for (var i = 0; i < document.assessRandomQuesArr.length; i++)
			{
				if (document.assessRandomQuesArr[i] == secNum)
				{
					/* mark the trickle button as clicked in this session for the test question */
					document.assessQuesDownArrowClicked[i] = 1;
				}
			}
		}
		if(isiPad || isiPhone){
			if(window.top !== window.self) {
				if(iOSVersion < 13){ // iOS13 Fix to enable down arrow 
					$(parent.parent.document).scrollTop(Number($('#'+$(this).parent().next('.section').attr('id')).position().top) - 60);
					$('.bar_robot').css('top',($(parent.parent.document).scrollTop())-1+'px');
				}else{
					
					if(iOSApp){ // iOS13 Fix to enable down arrow 
						//$(parent.parent.document).scrollTop(Number($('#'+$(this).parent().next('.section').attr('id')).position().top) - 60);
						//$('.bar_robot').css('top',($(parent.parent.document).scrollTop())-1+'px');
						$("body, html").animate({
							scrollTop: $('#'+$(this).parent().next('.section').attr('id')).position().top - 60
						},750);
					}else{
					
						$("body, html").animate({
							scrollTop: $('#'+$(this).parent().next('.section').attr('id')).position().top - 60
						},750);
					}
				}
				
			}else{
				$("body, html").animate({
					scrollTop: $('#'+$(this).parent().next('.section').attr('id')).position().top - 60
				},750);
			}
		}else{
			
			if(iOSApp){ // iOS13 Fix to enable down arrow 
				$(parent.parent.document).scrollTop(Number($('#'+$(this).parent().next('.section').attr('id')).position().top) - 60);
				$('.bar_robot').css('top',($(parent.parent.document).scrollTop())-1+'px');
			}
			
			$("body, html").animate({
				scrollTop: $('#'+$(this).parent().next('.section').attr('id')).position().top - 60
			},750);
		}
		/* trickle button functionality 2020 */
		/* hide the trickle button when clicked */
		$(this).hide();
		/* 2021 Accessibility Update */	
		$(this).parent().next('.section').find('.page_start').focus();
	}
});

/* keyboard functionality */
$('.complete_arrow').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {
		
		$(this).trigger('click');
	}		
});

/* 2021 Accessibility Update */
$('.complete_arrow').on('keydown', function(e) {
    if ((e.which == 9) && (!e.shiftKey)) {
        e.preventDefault();
		$(this).focus();
    }
});

function topic_closer(newtime){
	var vtop = $('.topic_index').offset().top - $(window).scrollTop();
	var st = $(window).scrollTop();
	var dh = $(document).height();
	var wh = $(window).height();
	var tempDiff = dh - wh;
	if (tempDiff <= 0) { dh = wh + 1; }
	var scrollPercent = (st) / (dh - wh);
	var newtime = Math.round((1000 * scrollPercent) + 1000)
	if(index===true){
		if(isWeb && !isMacChrome){ /* potential fix for android freezing */
			$('.topic_index').css({'transition-duration': '0ms', '-webkit-transition-duration':'0ms'})
			$('.topic_index').removeClass('loading_timer');
			$(".bar_robot").removeClass('displayNone').addClass('displayBlock');
			setTimeout(function(){ 
				$(".topic_index").css({"position":"fixed","top": vtop+"px"})
				$('html, body').scrollTop(0)
				$(".sec_rest_wrapper").css({'margin-top':'0px','display':'block'})
				resizeCheckBox()
			},10)
			setTimeout(function() {
				if($('.topic_index').hasClass('loading')){
					$('.topic_index').removeClass('loading'); 
				}else{
					$('.topic_index').addClass('loading');
					$('.topic_index').css({'transition-duration': newtime+'ms', '-webkit-transition-duration':newtime+'ms'})
				} 
				/* potential freeze fix */
				$(window).css('overflow','visible');
				$(window.top).css('overflow','visible');
				$(parent.parent.document).css('overflow','visible');
				$("html, body" ).css('overflow','visible');	
				//20210318 desktop portrait fix
				portraitTestFix();
			}, 70);
			/* potential freeze fix */
			$(window).css('overflow','visible');
			$(window.top).css('overflow','visible');
			$(parent.parent.document).css('overflow','visible');
			$("html, body" ).css('overflow','visible');			
		}
		if(isiPad || isiPhone || isAndroidTablet || isAndroidPhone || isMacChrome){ /* added iPhone and Android phone  */
		$("#topic_loader").show()
		$(".sec_rest_wrapper").removeClass('displayBlock')
		$(".sec_rest_wrapper").css('display', 'none')
		$('.topic_index').removeClass('displayBlock')
		$(".topic_index").css('display', 'none')
		setTimeout(function(){
				$('.topic_index').hide()
			},2000)
			setTimeout(function(){
				$( "html, body" ).scrollTop( 0 )
				$(".bar_robot").removeClass('displayNone').addClass('displayBlock');
			},2250)
			setTimeout(function(){
				$(".sec_rest_wrapper").css('display', 'block')
				//20210318 desktop portrait fix
				portraitTestFix();
				
				$("#topic_loader").hide()
				resizeCheckBox()
			},2500)
		}
	}
	index = false
}

$('.bar_close').click(function(){
	window.top.close()
})

/* progress bar */
function progress(n){
	var lesson_status = int_tracking.int_lesson_status;
	/* If error tracking is enabled use their function calls else use standard sco.js */
	var score = actionsLMSGetScore();
	score = score == "" ? 0 : Number(score);
		
	for(i=0; i<=$('.breaker').length; i++){
		var currentbreaker = document.trackingArr[$('.breaker').eq(i).index('.section')]
		var nextbreaker = (($('.breaker').eq(i)).nextAll('.breaker').prev('.section')).index('.section')
		if(nextbreaker == -1){
			nextbreaker = document.subsectionCount-1
		}
		var lastsection = document.trackingArr[nextbreaker]
		/* if there is a splash video or branching 062122 */
		if(document.hasSplashVideo || document.hasBranches){
			/* if the last page of this topic is viewed 062122 */
			if(lastsection ==1){
				if ((i == ($('.breaker').length - 1)) && ((lesson_status != lms_pass_status1) && (lesson_status != lms_pass_status2))) {	
					/* if it is the post-test, and course is not yet completed, show topic PROGRESS as INCOMPLETE 062122 */
					$('.topic_select .progress').eq(i+1).addClass('progress_started')
					$('.topic_select .progress').eq(i+1).attr('title',localiseString('topic_incomplete'));
					$('.topic_select .progress').eq(i+1).attr('alt',localiseString('topic_incomplete'));
				}
				else {
					/* for content topics, show topic DURATION and PROGRESS as COMPLETE 062122 */
					/* 101223 custom menu complete button status */
					$('.topic_select .select_status').eq(i+1).show();
					$('.topic_select .topic_duration').eq(i+1).addClass('topic_duration_complete');
					$('.topic_select .topic_duration').eq(i+1).html(localiseString('topic_complete'));
					$('.topic_select .progress').eq(i+1).removeClass('progress_started').addClass('progress_complete')
					$('.topic_select .progress').eq(i+1).attr('title',localiseString('topic_complete'));
					$('.topic_select .progress').eq(i+1).attr('alt',localiseString('topic_complete'));
															
					/* for the branching topic, show topic LAUNCH BUTTON, DURATION and PROGRESS as COMPLETE 062122 */
					$('.select_bottom:eq(0) img').attr('src', 'images/custom_int/topic_launch_complete.png');
					$('.select_bottom:eq(0) img').hover(function(){
						$(this).attr('src' ,'images/custom_int/topic_launch_complete_rollover.png');
					});
					$('.select_bottom:eq(0) img').mouseout(function(){
						$(this).attr('src' ,'images/custom_int/topic_launch_complete.png');
					});
				
					/* 101223 custom menu complete button status */
					$('.topic_select .select_status').eq(0).show();
					$('.topic_select .topic_duration').eq(0).addClass('topic_duration_complete');
					$('.topic_select .topic_duration').eq(0).html(localiseString('topic_complete'));
					$('.topic_select .progress').eq(0).removeClass('progress_started').addClass('progress_complete')
					$('.topic_select .progress').eq(0).attr('title',localiseString('topic_complete'));
					$('.topic_select .progress').eq(0).attr('alt',localiseString('topic_complete'));
				}	
			}
			/* if the first page of the topic is viewed, but not the last 062122 */
			else if(currentbreaker ==1){
				/* for content topics, show topic PROGRESS as INCOMPLETE 062122 */
				$('.topic_select .progress').eq(i+1).addClass('progress_started')
				$('.topic_select .progress').eq(i+1).attr('title',localiseString('topic_incomplete'));
				$('.topic_select .progress').eq(i+1).attr('alt',localiseString('topic_incomplete'));
				
				/* for the branching topic, show topic LAUNCH BUTTON, DURATION and PROGRESS as COMPLETE 062122 */
				$('.select_bottom:eq(0) img').attr('src', 'images/custom_int/topic_launch_complete.png');
				$('.select_bottom:eq(0) img').hover(function(){
					$(this).attr('src' ,'images/custom_int/topic_launch_complete_rollover.png');
				});
				$('.select_bottom:eq(0) img').mouseout(function(){
					$(this).attr('src' ,'images/custom_int/topic_launch_complete.png');
				});
			
				/* 101223 custom menu complete button status */
				$('.topic_select .select_status').eq(0).show();
				$('.topic_select .topic_duration').eq(0).addClass('topic_duration_complete');
				$('.topic_select .topic_duration').eq(0).html(localiseString('topic_complete'));
				$('.topic_select .progress').eq(0).removeClass('progress_started').addClass('progress_complete')
				$('.topic_select .progress').eq(0).attr('title',localiseString('topic_complete'));
				$('.topic_select .progress').eq(0).attr('alt',localiseString('topic_complete'));
								
						
				/* for the first content topic, show topic LAUNCH BUTTON as UNLOCKED if not already COMPLETE 062122 */
				if ($('.select_bottom:eq(1) img').attr('src') != 'images/custom_int/topic_launch_complete.png')
				{
					$('.select_bottom:eq(1) img').attr('src', 'images/custom_int/topic_launch.png');
					$('.topic_select .overlay').eq(1).css('display', 'none');					
				}
			}
		}else{
		
			if(lastsection ==1){			
				if ((i == ($('.breaker').length - 1)) && ((lesson_status != lms_pass_status1) && (lesson_status != lms_pass_status2))) {			
					$('.topic_select .progress').eq(i).addClass('progress_started')
					$('.topic_select .progress').eq(i).attr('title',localiseString('topic_incomplete'));
					$('.topic_select .progress').eq(i).attr('alt',localiseString('topic_incomplete'));
				}
				else {
					/* 101223 custom menu complete button status */
					$('.topic_select .select_status').eq(i).show();
					$('.topic_select .topic_duration').eq(i).addClass('topic_duration_complete');
					$('.topic_select .topic_duration').eq(i).html(localiseString('topic_complete'));
					$('.topic_select .progress').eq(i).removeClass('progress_started').addClass('progress_complete')
					$('.topic_select .progress').eq(i).attr('title',localiseString('topic_complete'));
					$('.topic_select .progress').eq(i).attr('alt',localiseString('topic_complete'));
				}	
			}
			else if(currentbreaker ==1){
					$('.topic_select .progress').eq(i).addClass('progress_started')
					$('.topic_select .progress').eq(i).attr('title',localiseString('topic_incomplete'));
					$('.topic_select .progress').eq(i).attr('alt',localiseString('topic_incomplete'));
			}
		}
	}
	/* if the post-test has been passed, and the last page of the course is viewed, show the post-test topic PROGRESS as COMPLETE 062122 */
	if ((score >= document.assessPassmark) && (document.trackingArr[document.trackingArr.length-1] == '1'))
	{
		$('.topic_select .progress').eq($('.breaker').length).removeClass('progress_started').addClass('progress_complete')
		$('.topic_select .progress').eq($('.breaker').length).attr('title',localiseString('topic_complete'));
		$('.topic_select .progress').eq($('.breaker').length).attr('alt',localiseString('topic_complete'));
	}
}

/* menu visited state functionality 2018 */
function markTopicsVisited(){
	var lesson_status = int_tracking.int_lesson_status;
	/* If error tracking is enabled use their function calls else use standard sco.js */
	var score = actionsLMSGetScore();
	score = score == "" ? 0 : Number(score);
	var tempTPretestOutArr = document.topicsPretestedOut.split('');
	for(i=0; i<=$('.breaker').length; i++){
		var currentbreaker = document.trackingArr[$('.breaker').eq(i).index('.section')]
		var nextbreaker = (($('.breaker').eq(i)).nextAll('.breaker').prev('.section')).index('.section')
		if(nextbreaker == -1){
			nextbreaker = document.subsectionCount-1
		}
		var lastsection = document.trackingArr[nextbreaker]
		/* if the last page of this topic is viewed 062122 */
		if(lastsection ==1){
			if ((i == ($('.breaker').length - 1)) && ((lesson_status != lms_pass_status1) && (lesson_status != lms_pass_status2))) {			 
				/* if it is the post-test, and course is not yet completed 062122 */
				/* do nothing */
			}
			else {
				if ((document.pretestPresent == 1) && (tempTPretestOutArr[i] == 1))
				{
					$('.select_bottom:eq('+i+') img').attr('src', 'images/general_int/topic_testout_launch_complete.png');
					$('.select_bottom:eq('+i+') img').mouseout(function(){
						$(this).attr('src' ,'images/general_int/topic_testout_launch_complete.png');
					});
				}
				else
				{
					/* if there is a splash video or branching 062122 */
					if(document.hasSplashVideo || document.hasBranches){
						endSharedContent();
						/* for the branching topic, show topic LAUNCH BUTTON, DURATION and PROGRESS as COMPLETE 062122 */
						$('.select_bottom:eq(0) img').attr('src', 'images/custom_int/topic_launch_complete.png');
						$('.select_bottom:eq(0) img').hover(function(){
							$(this).attr('src' ,'images/custom_int/topic_launch_complete_rollover.png');
						});
						$('.select_bottom:eq(0) img').mouseout(function(){
							$(this).attr('src' ,'images/custom_int/topic_launch_complete.png');
						});
					
						/* 101223 custom menu complete button status */
						$('.topic_select .select_status').eq(0).show();
						$('.topic_select .topic_duration').eq(0).addClass('topic_duration_complete');
						$('.topic_select .topic_duration').eq(0).html(localiseString('topic_complete'));
						$('.topic_select .progress').eq(0).removeClass('progress_started').addClass('progress_complete')
						$('.topic_select .progress').eq(0).attr('title',localiseString('topic_complete'));
						$('.topic_select .progress').eq(0).attr('alt',localiseString('topic_complete'));
						
						/* for content topics, show topic LAUNCH BUTTON as COMPLETE 062122 */
						$('.select_bottom:eq('+(i+1)+') img').attr('src', 'images/custom_int/topic_launch_complete.png');
						$('.select_bottom:eq('+(i+1)+') img').hover(function(){
							$(this).attr('src' ,'images/custom_int/topic_launch_complete_rollover.png');
						});
						$('.select_bottom:eq('+(i+1)+') img').mouseout(function(){
							$(this).attr('src' ,'images/custom_int/topic_launch_complete.png');
						});
					}else{
						$('.select_bottom:eq('+i+') img').attr('src', 'images/custom_int/topic_launch_complete.png');
						$('.select_bottom:eq('+i+') img').hover(function(){
							$(this).attr('src' ,'images/custom_int/topic_launch_complete_rollover.png');
						});
						$('.select_bottom:eq('+i+') img').mouseout(function(){
							$(this).attr('src' ,'images/custom_int/topic_launch_complete.png');
						});
					}
				}	
			}
		}else{
			/* if the last page of this topic is NOT viewed 062122 */
			/* if there is a splash video or branching 062122 */
			if(document.hasSplashVideo || document.hasBranches){
				endSharedContent();
				/* for the branching topic, show topic LAUNCH BUTTON, DURATION and PROGRESS as COMPLETE 062122 */
				$('.select_bottom:eq(0) img').attr('src', 'images/custom_int/topic_launch_complete.png');
				$('.select_bottom:eq(0) img').hover(function(){
					$(this).attr('src' ,'images/custom_int/topic_launch_complete_rollover.png');
				});
				$('.select_bottom:eq(0) img').mouseout(function(){
					$(this).attr('src' ,'images/custom_int/topic_launch_complete.png');
				});
				
				/* 101223 custom menu complete button status */
				$('.topic_select .select_status').eq(0).show();
				$('.topic_select .topic_duration').eq(0).addClass('topic_duration_complete');
				$('.topic_select .topic_duration').eq(0).html(localiseString('topic_complete'));
				$('.topic_select .progress').eq(0).removeClass('progress_started').addClass('progress_complete')
				$('.topic_select .progress').eq(0).attr('title',localiseString('topic_complete'));
				$('.topic_select .progress').eq(0).attr('alt',localiseString('topic_complete'));
			}
		}
	}
	/* if the first or second branch topic is complete, show post-test topic LAUNCH BUTTON as UNLOCKED 062122 */
	/* ensure to check if course has branches 032223 */
	if (document.hasBranches)
	{
		if (($('.topic_select .progress').eq($('.breaker').length-1).hasClass('progress_complete')) || ($('.topic_select .progress').eq($('.breaker').length-2).hasClass('progress_complete')))
		{
			$('.select_bottom:eq('+$('.breaker').length+') img').attr('src', 'images/custom_int/topic_launch.png');
			$('.topic_select .overlay').eq($('.breaker').length).css('display', 'none');
		}
		/* if the post-test topic is in progress, show post-test topic LAUNCH BUTTON as UNLOCKED 062122 */
		if (($('.topic_select .progress').eq($('.breaker').length).hasClass('progress_started')) || ($('.topic_select .progress').eq($('.breaker').length-2).hasClass('progress_complete')))
		{
			$('.select_bottom:eq('+$('.breaker').length+') img').attr('src', 'images/custom_int/topic_launch.png');
			$('.topic_select .overlay').eq($('.breaker').length).css('display', 'none');
		}
	}
	/* if previous topic to post-test is complete or post-test is in progress, show post-test topic LAUNCH BUTTON as UNLOCKED 032223 */
	else
	{
		if (($('.topic_select .progress').eq($('.breaker').length-1).hasClass('progress_complete')))
		{
			$('.select_bottom:eq('+$('.breaker').length+') img').attr('src', 'images/custom_int/topic_launch.png');
			$('.topic_select .overlay').eq($('.breaker').length).css('display', 'none');
		}
		/* if the post-test topic is in progress, show post-test topic LAUNCH BUTTON as UNLOCKED 062122 */
		if (($('.topic_select .progress').eq($('.breaker').length).hasClass('progress_started')))
		{
			$('.select_bottom:eq('+$('.breaker').length+') img').attr('src', 'images/custom_int/topic_launch.png');
			$('.topic_select .overlay').eq($('.breaker').length).css('display', 'none');
		}
	}
	/* if the post-test has been passed, and the last page of the course is viewed, show the last topic LAUNCH BUTTON as COMPLETE 062122 */
	if ((score >= document.assessPassmark) && (document.trackingArr[document.trackingArr.length-1] == '1'))
	{
		if ((document.pretestPresent == 1) && (tempTPretestOutArr[tempTPretestOutArr.length-1] == 1))
		{			
			$('.select_bottom:eq('+($('.breaker').length)+') img').attr('src', 'images/general_int/topic_testout_launch_complete.png');			
			$('.select_bottom:eq('+($('.breaker').length)+') img').hover(function(){
				$(this).attr('src' ,'images/general_int/topic_testout_launch_complete_rollover.png');
			});
			$('.select_bottom:eq('+($('.breaker').length)+') img').mouseout(function(){
				$(this).attr('src' ,'images/general_int/topic_testout_launch_complete.png');
			});
			$('.topic_select .overlay').eq($('.breaker').length).css('display', 'none');
		}
		else
		{
			$('.select_bottom:eq('+($('.breaker').length)+') img').attr('src', 'images/custom_int/topic_launch_complete.png');
			$('.select_bottom:eq('+($('.breaker').length)+') img').hover(function(){
				$(this).attr('src' ,'images/custom_int/topic_launch_complete_rollover.png');
			});
			$('.select_bottom:eq('+($('.breaker').length)+') img').mouseout(function(){
				$(this).attr('src' ,'images/custom_int/topic_launch_complete.png');
			});
			$('.topic_select .overlay').eq($('.breaker').length).css('display', 'none');
		}
	}
	
	/*if(document.hasBranches){
		if(document.userBranch != 0){
			$(".branch_item").css("display","none");
			$(".branch_item_" + document.userBranch).css("display","block");
		}
		
		var endShared = $(".end_shared").index(".section");
		
		if(Number(document.trackingArr[endShared]) == 1){
			endSharedContent();
		}
		
	}*/
	
}

/* initially for all content topics, show topic LAUNCH BUTTON as LOCKED 062122 */
/* grey out topics */
if(document.menuLockedDown == true || lock_butt === true ){
	$('.topic_select:not(.topic_select:eq(0)) .overlay').css('display', 'block');
	$('.select_bottom:not(.select_bottom:eq(0)) img').attr('src', 'images/general_int/topic_locked.png');	
}

/* initially for all topics, assign rollover states for topic LAUNCH BUTTON as UNLOCKED 062122 */
/* menu visited state functionality 2018 */
$('.select_bottom img').hover(function(){
	$(this).attr('src' ,'images/custom_int/topic_launch_rollover.png')
});
$('.select_bottom img').mouseout(function(){
	$(this).attr('src' ,'images/custom_int/topic_launch.png')
});
	
/* test out: if there is a pre-test in the course and the Menu is not locked down initially lock the summary and post-test topics on the Menu */
if((document.pretestPresent == 1) && (document.menuLockedDown == false)) {
	$('.topic_select:eq('+(document.topicsCount-2)+') .overlay').css('display', 'block');
	$('.select_bottom:eq('+(document.topicsCount-2)+') img').attr('src', 'images/general_int/topic_locked.png');
	$('.topic_select:eq('+(document.topicsCount-1)+') .overlay').css('display', 'block');
	$('.select_bottom:eq('+(document.topicsCount-1)+') img').attr('src', 'images/general_int/topic_locked.png');
}
var lock_butt;
function lockTopics(nextBtnClicked){
	document.topic_complete=[]
	var top_sel = currentSec
	var breaker = ($('.breaker').eq(top_sel).index('.section')-1)
	for(i=breaker; i<($('div.breaker:eq('+currentSec+')').nextUntil($('div.breaker').eq(currentSec+1)).length+1); i++){
		if(document.lockedArr[i]===1){
			lock_butt = true
		}else{
			lock_butt = false
		}
	}
	if(document.audioLocked === true || lock_butt === true){
		if (nextBtnClicked) {
			$('#right_nav').addClass('locked');
		}
	}
}
lockTopics(true)

function unlockTopic(n){
	if(typeof n !== 'undefined'){
		var lesson_status = int_tracking.int_lesson_status;
		/* If error tracking is enabled use their function calls else use standard sco.js */
		var score = actionsLMSGetScore();		
		score = score == "" ? 0 : Number(score);
		var topicOK = true;
		/* test out: if there is a pre-test in the course */
		if (document.pretestPresent == 1)
		{
			/* test out: obtain the status of what topics have been tested out of */
			var tempTPretestOutArr = document.topicsPretestedOut.split('');
			if (tempTPretestOutArr[currentSec] == 1)
			{
				topicOK = false;
			}
		}	
		if((document.trackingArr[($('div.breaker:eq('+(currentSec+1)+')').prev('.section').index('.section'))]==1) && topicOK)
		{			
			/* test out: if there is a pre-test and the menu is not locked do not unlock the summary until all previous topics completed or tested out */
			if ((document.pretestPresent == 1) && (document.menuLockedDown == false) && ((currentSec+1) == (document.topicsCount - 2)))
			{
				// do nothing
			}
			else {
				/* if there is a splash video or branching 062122 */
				if(document.hasSplashVideo || document.hasBranches){
					/* for any topic, show topic LAUNCH BUTTON as COMPLETE 062122 */
					$('.topic_select .overlay').eq(currentSec+2).css('display', 'none')
					$('.select_bottom:eq('+(currentSec+2)+') img').attr('src', 'images/custom_int/topic_launch.png')
					$('.select_bottom:eq('+(currentSec+2)+') img').attr('title', localiseString('topic_start'));
					$('.select_bottom:eq('+(currentSec+2)+') img').attr('alt', localiseString('topic_start'));
				}else{
					$('.topic_select .overlay').eq(currentSec+1).css('display', 'none')
					$('.select_bottom:eq('+(currentSec+1)+') img').attr('src', 'images/custom_int/topic_launch.png')
					$('.select_bottom:eq('+(currentSec+1)+') img').attr('title', localiseString('topic_start'));
					$('.select_bottom:eq('+(currentSec+1)+') img').attr('alt', localiseString('topic_start'));
				}
				if(currentSec < ($('.breaker').length-1)){
					if ((document.pretestPresent == 0) || ((document.pretestPresent == 1) && (document.pretestAttempted == 1) && (document.topicsPretestedOut.indexOf("1") == -1)))	{	
						$('#right_nav').show();
						$('#right_nav').removeClass('locked');
						$('#right_nav').attr('title', localiseString('right_nav'));
						$('#right_nav').attr('alt', localiseString('right_nav'));
					}
					/* for content topics, but not for first branch topic if in second branch, show topic DURATION and PROGRESS as COMPLETE 062122 */
					if ((document.userBranch == 2) && (currentSec == (document.topicsCount - document.numberOfBranches)))
					{
						// do nothing
					}
					else
					{
						$('.breaker').eq(currentSec).data('status', 'complete')
						$('.topic_select .progress').eq(currentSec).removeClass('progress_started').addClass('progress_complete')
						$('.topic_select .progress').eq(currentSec).attr('title',localiseString('topic_complete'));
						$('.topic_select .progress').eq(currentSec).attr('alt',localiseString('topic_complete'));
						launchHover();
					}	
				}
			}	
			/* test out: if there is a pre-test in the course */
			if (document.pretestPresent == 1)
			{
				/* test out: obtain the status of what topics have been tested out of */
				var tempTPretestOutArr = document.topicsPretestedOut.split('');	
				/* test out: show the launch icon for the next topic that has not been tested out of and unlock this topic */		
				if (tempTPretestOutArr[currentSec + 1] == 1)
				{
					for (var i = (currentSec + 2); i < document.topicsCount; i++)
					{
						if (tempTPretestOutArr[i] == 0)
						{							
							$('.topic_select .overlay').eq(i).css('display', 'none');
							$('.select_bottom:eq('+i+') img').attr('src', 'images/custom_int/topic_launch.png');
							$('.select_bottom:eq('+i+') img').attr('title', localiseString('topic_start'));
							$('.select_bottom:eq('+i+') img').attr('alt', localiseString('topic_start'));
							break;
						}
					}			
				}
			}
		}
		else{
			/* if there is a splash video or branching 062122 */
			if(document.hasSplashVideo || document.hasBranches){
				/* show the first content topic LAUNCH BUTTON as UNLOCKED 062122 */
				$('.topic_select .overlay').eq(1).css('display', 'none')
				$('.select_bottom:eq('+(1)+') img').attr('src', 'images/custom_int/topic_launch.png')
				$('.select_bottom:eq('+(1)+') img').attr('title', localiseString('topic_start'));
				$('.select_bottom:eq('+(1)+') img').attr('alt', localiseString('topic_start'));
			}
		}
		/* if the post-test has been passed, and the last page of the course is viewed, show the post-test topic PROGRESS as COMPLETE 062122 */
		if ((score >= document.assessPassmark) && (document.trackingArr[document.trackingArr.length-1] == '1'))
		{		
			$('.topic_select .progress').eq($('.breaker').length).removeClass('progress_started').addClass('progress_complete')
			$('.topic_select .progress').eq($('.breaker').length).attr('title',localiseString('topic_complete'));
			$('.topic_select .progress').eq($('.breaker').length).attr('alt',localiseString('topic_complete'));			
		}
	}
	/* menu visited state functionality 2018 */
	markTopicsVisited();
}

function launchHover(){
	var srcString = $('.select_bottom img').attr('src').toString()	
	/* if topic LAUNCH BUTTON is UNLOCKED then ensure rollover states are also 062122 */
	if(srcString.indexOf('topic_launch.png')>0){
		 $('.select_bottom img').hover(function () {
        	$(this).attr('src' ,'images/custom_int/topic_launch_rollover.png')
    	});
		$(".select_bottom img").mouseout(function(){
    		$(this).attr('src' ,'images/custom_int/topic_launch.png');
		});
	}
	/* test out: if there is a pre-test in the course */
	if (document.pretestPresent == 1)
	{
		/* test out: obtain the status of what topics have been tested out of */
		var tempTPretestOutArr = document.topicsPretestedOut.split('');
	}	
	var compTopics = 0;
	for (var i = 0; i < document.topicsCount; i++)
	{	
		/* test out: if there is a pre-test in the course */
		if (document.pretestPresent == 1)
		{	
			/* test out: show the tested out icon for any topics that have been tested out of and unlock these topics */
			if (tempTPretestOutArr[i] == 1)
			{				
				$('.select_bottom:eq('+i+') img').attr('src', 'images/general_int/topic_testout_launch_complete.png');			
				$('.select_bottom:eq('+i+') img').attr('title', localiseString('topic_start'));
				$('.select_bottom:eq('+i+') img').attr('alt', localiseString('topic_start'));
				$('.select_bottom:eq('+i+') img').hover(function () {
					$(this).attr('src' ,'images/general_int/topic_testout_launch_rollover.png')
				});
				$('.select_bottom:eq('+i+') img').mouseout(function(){
					$(this).attr('src' ,'images/general_int/topic_testout_launch_complete.png');
				});
				$('.topic_select .overlay').eq(i).css('display', 'none');
				compTopics++;
			}
			else {
				if(document.trackingArr[($('div.breaker:eq('+i+')').prev('.section').index('.section'))]==1){					
					if (tempTPretestOutArr[i - 1] == 0)
					{
						compTopics++;
					}	
				}
				if (compTopics == i) {				
					$('.select_bottom:eq('+i+') img').attr('src', 'images/custom_int/topic_launch.png');			
					$('.select_bottom:eq('+i+') img').attr('title', localiseString('topic_start'));
					$('.select_bottom:eq('+i+') img').attr('alt', localiseString('topic_start'));
					$('.select_bottom:eq('+i+') img').hover(function () {
						$(this).attr('src' ,'images/custom_int/topic_launch_rollover.png')
					});
					$('.select_bottom:eq('+i+') img').mouseout(function(){
						$(this).attr('src' ,'images/custom_int/topic_launch.png');
					});
					$('.topic_select .overlay').eq(i).css('display', 'none');
				}
				if(document.trackingArr[($('div.breaker:eq('+(i+1)+')').prev('.section').index('.section'))]==1){				
					/* test out: show the launch icon for the next topic that has not been tested out of and unlock this topic */
					for (var j = (i + 1); j < document.topicsCount; j++)
					{
						if (tempTPretestOutArr[j] == 0)
						{							
							$('.topic_select .overlay').eq(j).css('display', 'none');
							$('.select_bottom:eq('+j+') img').attr('src', 'images/custom_int/topic_launch.png');
							$('.select_bottom:eq('+j+') img').attr('title', localiseString('topic_start'));
							$('.select_bottom:eq('+j+') img').attr('alt', localiseString('topic_start'));
							/* menu visited state functionality 2018 */
							$('.select_bottom:eq('+j+') img').hover(function () {
								$(this).attr('src' ,'images/custom_int/topic_launch_rollover.png')
							});
							$('.select_bottom:eq('+j+') img').mouseout(function(){
								$(this).attr('src' ,'images/custom_int/topic_launch.png');
							});
							break;
						}
					}
				}
			}
		}
		else {
			if(document.trackingArr[($('div.breaker:eq('+i+')').prev('.section').index('.section'))]==1){					
				compTopics++;
			}
			/* if there is a splash video or branching 062122 */
			if(document.hasSplashVideo || document.hasBranches){
				/* if it is the first branch topic, show topic LAUNCH BUTTON as UNLOCKED 062122 */
				if ((document.userBranch == 1) && (i == ($('.breaker').length - 2)) && (compTopics == (i - document.numberOfBranches + 1)))
				{
					$('.select_bottom:eq('+(i+1)+') img').attr('src', 'images/custom_int/topic_launch.png');			
					$('.select_bottom:eq('+(i+1)+') img').attr('title', localiseString('topic_start'));
					$('.select_bottom:eq('+(i+1)+') img').attr('alt', localiseString('topic_start'));
					$('.select_bottom:eq('+(i+1)+') img').hover(function () {
						$(this).attr('src' ,'images/custom_int/topic_launch_rollover.png')
					});
					$('.select_bottom:eq('+(i+1)+') img').mouseout(function(){
						$(this).attr('src' ,'images/custom_int/topic_launch.png');
					});
					$('.topic_select .overlay').eq(i+1).css('display', 'none');					
				}
				/* if it is the second branch topic, show topic LAUNCH BUTTON as UNLOCKED 062122 */
				else if ((document.userBranch == 2) && (i == ($('.breaker').length - 3)) && (compTopics == (i - document.numberOfBranches + 2)))
				{
					$('.select_bottom:eq('+(i+2)+') img').attr('src', 'images/custom_int/topic_launch.png');			
					$('.select_bottom:eq('+(i+2)+') img').attr('title', localiseString('topic_start'));
					$('.select_bottom:eq('+(i+2)+') img').attr('alt', localiseString('topic_start'));
					$('.select_bottom:eq('+(i+2)+') img').hover(function () {
						$(this).attr('src' ,'images/custom_int/topic_launch_rollover.png')
					});
					$('.select_bottom:eq('+(i+2)+') img').mouseout(function(){
						$(this).attr('src' ,'images/custom_int/topic_launch.png');
					});
					$('.topic_select .overlay').eq(i+2).css('display', 'none');
				}
				/* if it is the post-test, and this is the full course so branched topics many not yet be complete, show topic LAUNCH BUTTON as UNLOCKED 062122 */
				else if ((document.userBranch == 3) && (i == ($('.breaker').length - 1)) && (compTopics == (i - document.numberOfBranches)))
				{
					$('.select_bottom:eq('+$('.breaker').length+') img').attr('src', 'images/custom_int/topic_launch.png');			
					$('.select_bottom:eq('+$('.breaker').length+') img').attr('title', localiseString('topic_start'));
					$('.select_bottom:eq('+$('.breaker').length+') img').attr('alt', localiseString('topic_start'));
					$('.select_bottom:eq('+$('.breaker').length+') img').hover(function () {
						$(this).attr('src' ,'images/custom_int/topic_launch_rollover.png')
					});
					$('.select_bottom:eq('+$('.breaker').length+') img').mouseout(function(){
						$(this).attr('src' ,'images/custom_int/topic_launch.png');
					});
					$('.topic_select .overlay').eq($('.breaker').length).css('display', 'none');
				}				
			}	
			if (compTopics == i) {
				/* if previous topics are complete, then show next topic LAUNCH BUTTON as UNLOCKED 062122 */
				/* 112222 for courses without splash video or branches ensure to unlock the next topic only */
				$('.select_bottom:eq('+i+') img').attr('src', 'images/custom_int/topic_launch.png');			
				$('.select_bottom:eq('+i+') img').attr('title', localiseString('topic_start'));
				$('.select_bottom:eq('+i+') img').attr('alt', localiseString('topic_start'));
				$('.select_bottom:eq('+i+') img').hover(function () {
					$(this).attr('src' ,'images/custom_int/topic_launch_rollover.png')
				});
				$('.select_bottom:eq('+i+') img').mouseout(function(){
					$(this).attr('src' ,'images/custom_int/topic_launch.png');
				});
				$('.topic_select .overlay').eq(i).css('display', 'none');
				/* if it is the first branch topic, show post-test topic LAUNCH BUTTON as UNLOCKED 062122 */
				if ((document.userBranch == 1) && (i == (document.topicsCount - document.numberOfBranches)))
				{
					$('.select_bottom:eq('+(i+2)+') img').attr('src', 'images/custom_int/topic_launch.png');			
					$('.select_bottom:eq('+(i+2)+') img').attr('title', localiseString('topic_start'));
					$('.select_bottom:eq('+(i+2)+') img').attr('alt', localiseString('topic_start'));
					$('.select_bottom:eq('+(i+2)+') img').hover(function () {
						$(this).attr('src' ,'images/custom_int/topic_launch_rollover.png')
					});
					$('.select_bottom:eq('+(i+2)+') img').mouseout(function(){
						$(this).attr('src' ,'images/custom_int/topic_launch.png');
					});
					
					$('.topic_select .overlay').eq(i+2).css('display', 'none');
				}	
			}			
		}	
	}
}

function lockNav()
{
	var lastsection = document.trackingArr[(($('.breaker').eq(currentSec)).nextAll('.breaker').prev('.section')).index('.section')]
	if(currentSec >=1)
	{
		/* test out: if there is no pre-test in the course or there is a pre-test and it has been attempted but no topics have been tested out of enable the left nav button */
		if ((document.pretestPresent == 0) || ((document.pretestPresent == 1) && (document.pretestAttempted == 1) && (document.topicsPretestedOut.indexOf("1") == -1)))
		{			
			$('#left_nav').removeClass('locked');
			$('#left_nav').attr('title', localiseString('left_nav'));
			$('#left_nav').attr('alt', localiseString('left_nav'));
			$('#home_nav').removeClass("pretest");
		}
	}else{
		/* test out: if there is a pre-test and it has been attempted and at least one topic has been tested out of hide the left nav button */
		if ((document.pretestPresent == 1) && (document.pretestAttempted == 1) && (document.topicsPretestedOut.indexOf("1") != -1))
		{
			$('#left_nav').hide();
			$('#home_nav').addClass("pretest");
		}
		else {
			$('#left_nav').show();
			$('#left_nav').addClass('locked');
			$('#left_nav').attr('title', localiseString('left_nav_locked'));
			$('#left_nav').attr('alt', localiseString('left_nav_locked'));
			$('#home_nav').removeClass("pretest");
		}	
	}
	if(currentSec == $('.breaker').length -1){
		$('#right_nav').show();
		$('#right_nav').addClass('locked');
		$('#right_nav').attr('title', localiseString('right_nav_locked'));
		$('#right_nav').attr('alt', localiseString('right_nav_locked'));
		$('#home_nav').removeClass("pretest");		
	}
	if(currentSec !== $('.breaker').length -1 && lastsection == 1){
		/* test out: if there is no pre-test in the course or there is a pre-test and it has been attempted but no topics have been tested out of enable the right nav button */
		if ((document.pretestPresent == 0) || ((document.pretestPresent == 1) && (document.pretestAttempted == 1) && (document.topicsPretestedOut.indexOf("1") == -1)))
		{
			$('#right_nav').show();
			$('#right_nav').removeClass('locked');
			$('#right_nav').attr('title', localiseString('right_nav_locked'));
			$('#right_nav').attr('alt', localiseString('right_nav_locked'));
			$('#home_nav').removeClass("pretest");			
		}
	}else{
		/* test out: if there is a pre-test and it has been attempted and at least one topic has been tested out of hide the right nav button */
		if ((document.pretestPresent == 1) && (document.pretestAttempted == 1) && (document.topicsPretestedOut.indexOf("1") != -1))
		{
			$('#right_nav').hide();
			$('#home_nav').addClass("pretest");
		}
		else {
			$('#right_nav').show();
			$('#right_nav').addClass('locked');
			$('#right_nav').attr('title', localiseString('right_nav_locked'));
			$('#right_nav').attr('alt', localiseString('right_nav_locked'));
			$('#home_nav').removeClass("pretest");	
		}	
	}
}

/* load video */
function loadVideo(video_src){
	/*$('#mp4').attr('src',  document.intro_back[currentSec].mp4);
	$(".bg_video video")[0].load()
	$(".bg_video video")[0].play()*/
}

/* set topic title */
function topicTitle(){
	$("#topic_intro .grid_inner h1, .menu_title h3").html(document.courseTitle)
	$('.home, .bar_close, .page, .menu_title').hide()
}

/* functionality to truncate the title */
$(window).resize(function() {
	$('.menu_title_txt').addClass('truncated_title');  
});
 
function addTopicData(){
	for(i=0; i<$('.section').length; i++){
		$('.section').eq(i).data('locked', document.lockedArr[i])
		$('.section').eq(i).data('locked')
	}
}
addTopicData()
	 
function addSuspendData(){
	for(i=0; i<$('.section').length; i++){
		$('.section').eq(i).data('suspend', document.trackingArr[i])
		$('.section').eq(i).data('suspend')
	}
}

function startedTopic(topic){
	var currentsection = $('.breaker').eq(topic).index('.section')
	if(document.lockedArr[currentsection] == 1 && $('.kick_scroll').length == 0){
		if(isWeb){
	$('.sec_rest_wrapper').before('<div class="kick_scroll"></div>')
		}
	}
	setTimeout(function(){
		if(document.lockedArr[currentsection] != 1){
			document.trackingArr[currentsection] = '1'
		}else{
			document.currentSection = currentsection+1
			if(document.audioArr[currentsection] == 0){
				document.audioComplete = true;
				
			}
		}
		
		progress()
		checkCourseCompletion()
		/* 20231018 video and audio accessibility */
		$('.section').find('.video_player').each(function(index, element) {
			$(this).attr('tabindex', -1);
		});
		$('.section').find('.audio_player').each(function(index, element) {
			$(this).attr('tabindex', -1);
		});
		$($('.breaker').eq(topic)).find('.video_player').each(function(index, element) {
			$(this).attr('tabindex', $(this).attr('data-tab'));
		});
		$($('.breaker').eq(topic)).find('.audio_player').each(function(index, element) {
			$(this).attr('tabindex', $(this).attr('data-tab'));
		});
	},1000)
}

var relaunch = false
var topic_book;	 

function populateTracking(){
	if(relaunch == false){
		for(i=0; i<document.lockedArr.length; i++){	
			document.trackingArr.push('0')
		}
		
	}
}
populateTracking()

var topicTracking =[]; 
var lockTopicTracking=[];

function oraginiseLocking(){
	topicTracking = [];
	lockTopicTracking = []
	var breaker = $('.breaker')
	for(i=0; i<breaker.length; i++){
		var currentbreaker = $('div.breaker:eq('+i+')').index('.section')
		var topicEnd = $('div.breaker:eq('+(i+1)+')').index('.section')	
		if(topicEnd == -1){
			topicEnd = $('.section').length
		}
		var arrLock = []
		var arrTrack = []
		for(j=currentbreaker; j<topicEnd; j++){	
			arrLock.push(document.lockedArr[j])
			arrTrack.push(document.trackingArr[j])
		}
		lockTopicTracking.push(arrLock)
		topicTracking.push(arrTrack)
		//console.log(topicTracking)
	}
}
oraginiseLocking()
/* pages to unlock from bookmark */
function unlockPages(){
	var breaker = $('div.breaker:eq('+(currentSec)+')')
	var currentbreaker = $('div.breaker:eq('+currentSec+')').index('.section')
	var currentsection = $('.section')
	var topicEnd = $('div.breaker:eq('+(currentSec+1)+')').index('.section')	
	var currentTopic = topicTracking[currentSec]
	var lock = false
		
	if(breaker.hasClass('testStartSec')){
		/* trickle button functionality 2020 */
		/* show test questions that are completed in this session and the next test question */
		for(i=0; i<(document.assessRandomQuesArr.length-1); i++){
			if ($('#sec_'+document.assessRandomQuesArr[i]).find('.submit_btn').css('display') == 'none')
			{
				$('#sec_'+document.assessRandomQuesArr[i]).show();				
				if (document.assessQuesDownArrowClicked[i] == 1)
				{
					$('#sec_'+document.assessRandomQuesArr[i]).next('.section').show();
				}	
			}			
		}
	}
	var break_loop = false;
		for(i=0; i<currentTopic.length; i++){
			if(currentTopic[i] == 1 && lock == false){
				currentsection.eq(currentbreaker+parseInt(i)).show()
				
			}else if(currentTopic[i] == 0 ){
					lock = true
					currentTopic = lockTopicTracking[currentSec]
				}
			if(lock == true){
					if(!currentsection.eq(currentbreaker+parseInt(i)).hasClass('testQues')){
						currentsection.eq(currentbreaker+parseInt(i)).show()
					}
					if(currentTopic[i] == 1){
						break_loop = true
					}
				if(break_loop == true){
					break
				}
		}
	}
}

function topic_height(){
	var imgHeight = (($('.topic_tile_twelve').width()-48)/3)/2
	if ($(window).width() <751) {
			imgHeight = (($('.topic_tile_twelve').width()-30)/2)/2
		}
	if ($(window).width() <463) {
			imgHeight = (($('.topic_tile_twelve').width())/2)
		}
	$('.topic_tile_twelve').css('height', imgHeight+'px');
	if ($(window).width() >=463) {
		var arr=[]
		for(i=0; i<$('.topic_select').length; i++){
			var tileparent = $('.topic_select').eq(i).parent()
			if(!tileparent.hasClass('twelve')){
				arr.push(parseInt($('.topic_select .top_wrapper').eq(i).css('height').split('px')))
			}

		}
		var height = Math.max.apply(Math, arr)
		for(i=1; i<arr.length; i++){
			if(arr[i] !== arr[0]){
				$('.topic_select .top_wrapper').not('.twelve .topic_select .top_wrapper').css('min-height', height+5+'px');
					return;

			}
		}
	}
	
	
}
topic_height()
	
$(function() {
	/* fix for iPad menu position issue */
    var win
	if(isiPad || isiPhone){  
		if(window.top !== window.self) {
			win = $(parent.parent.document);
		}else{
			win = $(window);
		}
	}else{
		win = $(window);
	}
	resize();  
	win.resize(resize);

    function resize() {
		$('.topic_select .top_wrapper').css('min-height', '0px')
			topic_height()
		
    }
});

function setTopicIntro(sec){
	/* test out: if there is a pre-test in the course */
	if (document.pretestPresent == 1)
	{
		/* test out: if not currently taking the pre-test bookmark the page */
		if (!document.takingPretest) 
		{
			doBookMark(sec);
		}	
	}
	else {
		doBookMark(sec);
	}	
}

function exitPretest() {
/* test-out: upon exit of the pre-test update the Menu icons and reset for the post-test */
	/* test out: obtain the status of what topics have been tested out of */
	var tempTPretestOutArr = document.topicsPretestedOut.split('');
	var compTopics = 0;
	for (var i = 0; i < document.topicsCount; i++)
	{		
		/* test out: show the tested out icon for any topics that have been tested out of and unlock these topics */
		if (tempTPretestOutArr[i] == 1)
		{
			$('.select_bottom:eq('+i+') img').attr('src', 'images/general_int/topic_testout_launch_complete.png');			
			$('.select_bottom:eq('+i+') img').attr('title', localiseString('topic_start'));
			$('.select_bottom:eq('+i+') img').attr('alt', localiseString('topic_start'));
			$('.select_bottom:eq('+i+') img').hover(function () {
				$(this).attr('src' ,'images/general_int/topic_testout_launch_rollover.png')
			});
			$('.select_bottom:eq('+i+') img').mouseout(function(){
				$(this).attr('src' ,'images/general_int/topic_testout_launch_complete.png');
			});
			$('.topic_select .overlay').eq(i).css('display', 'none');
			compTopics++;
		}
		else {
			if(document.trackingArr[($('div.breaker:eq('+i+')').prev('.section').index('.section'))]==1){					
				if (tempTPretestOutArr[i - 1] == 0)
				{
					compTopics++;
				}	
			}
			if (compTopics == i) {
				$('.select_bottom:eq('+i+') img').attr('src', 'images/custom_int/topic_launch.png');			
				$('.select_bottom:eq('+i+') img').attr('title', localiseString('topic_start'));
				$('.select_bottom:eq('+i+') img').attr('alt', localiseString('topic_start'));
				$('.select_bottom:eq('+i+') img').hover(function () {
					$(this).attr('src' ,'images/custom_int/topic_launch_rollover.png')
				});
				$('.select_bottom:eq('+i+') img').mouseout(function(){
					$(this).attr('src' ,'images/custom_int/topic_launch.png');
				});
				$('.topic_select .overlay').eq(i).css('display', 'none');
			}
		}	
	}
	$('.bar_robot .home').css('visibility','visible');
	$('.bar_robot .page').css('visibility','visible');
	$('.bar_robot .menu_title').css('margin-left','38px');
	retakeAssessment();
}	



//20210318 desktop portrait fix
function portraitTestFix(){
	if(isWeb){
		if((!iOSApp) && (navigator.platform == "MacIntel")){ /* iOS13 Fix to ensure down arrow will show on test question pages 061022 */ }
		else {
			if(screen.height > screen.width){
				//console.log("Portrait Monitor");
				setTimeout(function(){
					
					if($("#sec_" + document.testIntroSubsection).css("display") == "block"){
						//console.log("test start visible")
						document.audioComplete = true; document.intComplete = true;
						pageCompleted = document.testIntroSubsection-1;
						isPageComplete(document.testIntroSubsection);
					}
					
					$(window).trigger("scroll");
					
				},1000);
			}
			
			getSliderHeight();
		}	
	}
	$(window).trigger("scroll");  // 20220707 fix to trigger scroll when browser zoom settings are not 100%
}

