/* functions to initiate the course */

$(document).ready(function() {

	BrowserDetect.init();
	/*resizeWindow();*/
	
	if((typeof console)=="undefined"){
		console = new Object();	
		console.log = function(arg){ 
		}
	}
	
	LMSAPI = actionsGetAPI();
	
	courseInit();
	lockNav();
	setupClickableOptions();  
	interfaceStrings();
	setMenuTabIndex();
	setTabIndex(); /* set up the tab index for course */
	
	//setUpAudio(); /* setup audio functionality */	
	//setUpVids();

	/* 20230607 disable inline questions that have already been answered when returning to course */
	disableQuests();
	
	$(".section").attr('data-clicked',0); 
	//$(".section").attr('data-links',0); 
	//$(".section").attr('data-hotwords',0);	
	document.randomizeAssessment();	
	
	
	if(os == "iOS" || os == "Android" || document.useTransitions == false){
		var elementsToShow = document.querySelectorAll('.animation-element');
		elementsToShow.forEach(function (element) {
			element.classList.add('in-view');
		});

	}
	
	
	
})

/* setTabIndex function to assign reset and assign tab index for each section */

var navTabCnt; /* 20180501 Accessibility Update */

function removeMenuTabIndex(){ // remove menu tab funcitonality
	
	/* 2021 Accessibility Update */
	$('.branding_menu .copyright').attr('tabindex', -1);
	/* 2022 Accessibility Update */
	$('.branding_menu .copyright').attr('aria-hidden', true);
	
	$('.topic_index').find('.topic_select').each(function(index, element) {
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
    });
	
	/* remove tabindex to video */

	$('.topic_index').find('.return_vid_link').each(function(index, element) {
		
		$(this).attr('tabindex', -1);
		/* 2021 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
	});	
	
	$('.topic_index').find('.continue_vid_link').each(function(index, element) {
		
		$(this).attr('tabindex', -1);
		/* 2021 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
	});	
	$('.topic_index').find('.transcript_btn').each(function(index, element) {	
	
		$(this).attr('tabindex', -1);
		/* 2021 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
	});	
	/* 2021 Accessibility Update */
	$('.topic_index').find('.transcript_text').each(function(index, element) {	
	
		$(this).attr('tabindex', -1);
		/* 2021 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
	});	
	$('.topic_index').find('.content_video_alt').each(function(index, element) {	
	
		$(this).attr('tabindex', -1);
		/* 2021 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
	});	
	$('.topic_index').find('.video_player').each(function(index, element) {	
	
		$(this).attr('tabindex', -1);
		/* 2021 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
	});

	$('.topic_index').find('.content_text').each(function(index, element) {
		
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
		$(this).find('a').each(function(index, element) {	
			$(this).attr('tabindex', -1);
			/* 2022 Accessibility Update */
			$(this).attr('aria-hidden', true);
		});
		
    });
	
	$('.topic_index').find('.h1_inner').each(function(index, element) {
     
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
    });
	
	$('.topic_index').find('.page').each(function(index, element) {
     
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
    });
	
	$('.bar_robot').find('.home').each(function(index, element) {
     
		$(this).attr('tabindex', 1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
    });
	/* 2021 Accessibility Update */
	$('.bar_robot').find('.menu_title').each(function(index, element) {
     
		$(this).attr('tabindex', 2);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
    });
	
	$('.bar_robot').find('.page').each(function(index, element) {
     
		$(this).attr('tabindex', 3);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
    });
	
	$('.topic_index').find('.branch_btn').each(function(index, element) {
      
		$(this).attr('tabindex', -1);
		
    });
}


/* 20180501 Accessibility Update */
function setMenuTabIndex(){
	
	var tabCnt = 0;

	
	$('.bar_robot').find('.home').each(function(index, element) {
     
		$(this).attr('tabindex', -1);		
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true); /* 20220616 Make home and resource button accessible with keyboard when using JAWS */
		
    });
	/* 2021 Accessibility Update */
	$('.bar_robot').find('.menu_title').each(function(index, element) {
     
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true); /* 20220616 Make home and resource button accessible with keyboard when using JAWS */
		
    });
	$('.bar_robot').find('.page').each(function(index, element) {
     
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true); /* 20220616 Make home and resource button accessible with keyboard when using JAWS */
		
    });
	
	$('.topic_index').find('.page').each(function(index, element) {
     
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
	
	$('.topic_index').find('.h1_inner').each(function(index, element) {
      
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
	
	
	
	$('.topic_index').find('.content_text').each(function(index, element) {
		/* 20231018 video and audio accessibility */
		if (!$(this).hasClass('no_tabindex'))
		{
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 2022 Accessibility Update */
			$(this).attr('aria-hidden', false);

			$(this).find('a').each(function(index, element) {

				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				/* 2022 Accessibility Update */
				$(this).attr('aria-hidden', false);

			});
		}
    });	

	
	/* apply tabindex to video */
			
	$('.topic_index').find('.video_player').each(function(index, element) {	
		tabCnt++;
		/* 20231018 video and audio accessibility */
		$(this).attr('data-tab', tabCnt);
		$(this).attr('tabindex', -1);
		/* 2021 Accessibility Update */
		$(this).attr('aria-hidden', false);
	});
	$('.topic_index').find('.content_video_alt').each(function(index, element) {	
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		/* 2021 Accessibility Update */
		$(this).attr('aria-hidden', false);		
	});
	$('.topic_index').find('.transcript_btn').each(function(index, element) {
		/* 2021 Accessibility Update */
		$(this).attr('role','button');
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		/* 2021 Accessibility Update */
		$(this).attr('aria-hidden', false);
	});
	$('.topic_index').find('.transcript_text').each(function(index, element) {	
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		/* 2021 Accessibility Update */
		$(this).attr('aria-hidden', false);
	});
	$('.topic_index').find('.continue_vid_link').each(function(index, element) {	
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		/* 2021 Accessibility Update */
		$(this).attr('aria-hidden', false);
	});
	$('.topic_index').find('.return_vid_link').each(function(index, element) {	
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		/* 2021 Accessibility Update */
		$(this).attr('aria-hidden', false);
	});

	$('.topic_index').find('.home-copyright').find('.content_text').each(function(index, element) {
      
		$(this).attr('tabindex', -1);
		$(this).attr('aria-hidden', false);
    });
	
	$('.topic_index').find('.branch_btn').each(function(index, element) {
      
		$(this).attr('role','button');
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
	
	$('.topic_index').find('.topic_select').each(function(index, element) {
		/* 2021 Accessibility Update */
		$(this).attr('role','button');
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
	
	/* 2021 Accessibility Update */
	tabCnt++
	$('.branding_menu .copyright').attr('tabindex', tabCnt);
	/* 2022 Accessibility Update */
	$('.branding_menu .copyright').attr('aria-hidden', false);
}


/* 20180501 Accessibility Update */
function setTabIndex(sec){	
		
	$('.home').attr('role','button');
	$('.page').attr('role','button');
	
	
	
		  
	$('.topic_nav').attr('role','button');
	
	$('.box_closer').attr('role', 'button');
	
	/* apply tabindex */
	/* 2021 Accessibility Update */
	var tabCnt = 3;		
		
	$('.sec_rest_wrapper').find('.section').each(function(index, element) {
		
	
		
		$(this).find('.h2_inner').each(function(index, element) { /* 20180501 Accessibility Update */
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
		});
		
		/* ensure there is no tab order on images without alt text 2019 */
		$(this).find('.content_text').each(function(index, element) { /* 20180501 Accessibility Update */
			/* 20231018 video and audio accessibility */
			/* ensure tab order of text content after activity is following activity 2021 */
			if ((!$(this).hasClass('content_text_after_activity')) && (!$(this).hasClass('no_tabindex')))
			{
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				
				/* 2021 Accessibility Update */
				/* ensure one column text and HTML table is accessible */
				if($(this).find('.one_col_icon_text').length > 0)
				{
					$(this).find('tr').each(function(index, element) {
						$(this).find('td').each(function(index, element) {
							if($(this).find('img').length > 0)
							{
								$(this).find('img').each(function(index, element) {
									if ($(this).attr('alt') == '')
									{					
										$(this).parent().attr('tabindex', -1);
									}								
									else
									{
										tabCnt++;
										$(this).parent().attr('tabindex', tabCnt);
									}
								});
							}
							else
							{
								tabCnt++;
								$(this).attr('tabindex', tabCnt);
								$(this).find('a').each(function(index, element) {
									tabCnt++;
									$(this).attr('tabindex', tabCnt);
								});
								/* 2021 Accessibility Update */
								/* ensure empty td are not included in tab order */
								if ($(this).html() == "")
								{
									$(this).attr('tabindex', -1);
								}
							}	
						});
					});				
				}
				else {
					/* 2021 Accessibility Update */
					$(this).find('a').each(function(index, element) {
						tabCnt++;
						$(this).attr('tabindex', tabCnt);
					});
					/* self-certification 2021 */
					$(this).find('.cert_btn').each(function(index, element) {
						/* 2021 Accessibility Update */
						$(this).attr('role','button');
						tabCnt++;
						$(this).attr('tabindex', tabCnt);
					});
					$(this).find('img').each(function(index, element) {
						/* hotword mandatory button visited state functionality 2021 */
						if (!$(this).parent().hasClass('hotword_mandatory_btn'))
						{
							if ($(this).attr('alt') == '')
							{
								$(this).parent().attr('tabindex', -1);
							}
							/* 2021 Accessibility Update */
							else
							{
								tabCnt++;
								$(this).parent().attr('tabindex', tabCnt);
							}
						}
					});
				}	
			}	
		});
		
		/* 20180501 Accessibility Update */
		$(this).find('.expando_btn').each(function(index, element) {
			$(this).attr('role','button'); /* 20180501 Accessibility Update */
			/* 2021 Accessibility Update */
			$(this).attr('aria-expanded',false);
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			
			$(this).next('.expando_reveal').each(function(index, element){
			 
									 
				
				$(this).find('.expando_reveal_heading').each(function(index, element) {
					$(this).attr('role','button'); /* 20180501 Accessibility Update */
					/* 2021 Accessibility Update */
					$(this).attr('aria-expanded',true);
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
				});
				
				$(this).find('.expando_reveal_content').each(function(index, element) {	
					
					tabCnt++;
					$(this).attr('tabindex', tabCnt);

					$(this).find('a').each(function(index, element) {
						tabCnt++;
						$(this).attr('tabindex', tabCnt);
					});

				});

				
			});
			
			
		});	
			
		
		/* apply tabindex to video */
			
		$(this).find('.video_player').each(function(index, element) {	
			tabCnt++;
			/* 20231018 video and audio accessibility */
			$(this).attr('data-tab', tabCnt);
			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', false);
		});
		$(this).find('.audio_player').each(function(index, element) {	
			tabCnt++;
			/* 20231018 video and audio accessibility */
			$(this).attr('data-tab', tabCnt);
			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', false);
		});
		$(this).find('.content_video_alt').each(function(index, element) {	
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
		});
		$(this).find('.transcript_btn').each(function(index, element) {
			/* 2021 Accessibility Update */
			$(this).attr('role','button');
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
		});
		/* 2021 Accessibility Update */
		$(this).find('.transcript_text').each(function(index, element) {	
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
		});	
		/* apply tabindex to questions */	
		$(this).find('.qItemFirst').each(function(index, element) {
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			
			$(this).attr("aria-hidden", false); /* 20220616 JAWS fix to stop item being read when course launches */
		});
		
		$(this).find('.squaredBox').each(function(index, element) {
			
			var labelTxt;
			
			$(this).find('.labelTxt').each(function(index, element) {
				
				labelTxt = $(this).html();
				
			});
			
			$(this).attr('title', labelTxt)
			
		});
				
		$(this).find('.mc_btn').each(function(index, element) {
            $(this).attr('tabindex', -1);
        });
		
		$(this).find('.feedback_text').each(function(index, element) {	
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			
			$(this).find('a').each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
			});
		});	

		/* 20230608 Likert functionality */
		/* 101223 likert accessibility */
		$(this).find(".likert_row").each(function(index, element) {
			$(this).find(".statement").each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
			});	
			$(this).find(".likert_rb").each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
			});
		});

		/* ensure Try Again button is tabbed to 2019 */
		$(this).find('.submit_btn').each(function(index, element) {	
			$(this).attr('role','button'); /* 20180501 Accessibility Update */
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
		});	
		
		$(this).find('.retake_assess_btn').each(function(index, element) {
			/* 2021 Accessibility Update */
			$(this).attr('role','button');
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
		});	
		
		/* 2021 Accessibility Update */
		/* apply tabindex to slider */
		$(this).find('.slider_txt').each(function(index, element) {	
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
		
			$(this).find('a').each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
			});
			
			/* 101223 table in slide accessibility */
			$(this).find('tr').each(function(index, element) {
				$(this).find('td').each(function(index, element) {
					tabCnt++;
					$(this).attr('tabindex', tabCnt);						
					/* 2021 Accessibility Update */
					/* ensure empty td are not included in tab order */
					if ($(this).html() == "")
					{
						$(this).attr('tabindex', -1);
					}
				});
			});
		});
		$(this).find('.slide_left').each(function(index, element) {	
			
			$(this).attr('role','button'); /* 20180501 Accessibility Update */
			
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
		});	
		$(this).find('.slide_right').each(function(index, element) {	
			
			$(this).attr('role','button'); /* 20180501 Accessibility Update */
			
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
		});
		
		/* apply tabindex to hotspot */
		/* 20180501 Accessibility Update */
		$(this).find('.hotspot_btn').each(function(index, element) {	
			
			$(this).attr('role','button'); /* 20180501 Accessibility Update */
			
			var hotTxt = $(this).next('.hotspot_btn_label').html();
			
			$(this).attr('title',hotTxt);
			
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			
			$(this).parent().next('.hotspot_reveal_inner').find('.hotspot_reveal').each(function(index, element) {	
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				
				$(this).find('a').each(function(index, element) {
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
				});
			});
		});	


		/* flip card 2022 */
		$(this).find('.flip_card').each(function(index, element) {			
			
			$(this).find('.flip_card_front').each(function(index, element) {
				$(this).attr('role','button'); 
			});
		  	$(this).find('.flip_card_back').each(function(index, element) {
				if(document.allowFlipBack){ // 20221025 Flipcard link fix
					$(this).attr('role','button');				
				}
			});
			tabCnt++;			
			$(this).find('.flip_card_inner').each(function(index, element) {
				if ($(this).hasClass('flipped'))
				{
					$(this).find('.flip_card_front').each(function(index, element) {
						$(this).attr('tabindex', -1);
					});
					$(this).find('.flip_card_back').each(function(index, element) {
						$(this).attr('tabindex', tabCnt);
						/* Flip Card Scroll Accessibility Fix 2023 -- */
						$(this).find('.flip_content').each(function(index, element) {
							tabCnt++;
							$(this).attr('tabindex', tabCnt);
						});
						/* -- Flip Card Scroll Accessibility Fix 2023 */
						// 20221025 Flipcard link fix
						$(this).find('a').each(function(index, element) {
							tabCnt++;
							$(this).attr('tabindex', tabCnt);
						});
					});
				}
				else
				{
					$(this).find('.flip_card_front').each(function(index, element) {
						$(this).attr('tabindex', tabCnt);
						$(this).attr('data-tab', tabCnt); /* Flip Card Scroll Accessibility Fix 2023 */
					});
					$(this).find('.flip_card_back').each(function(index, element) {
						$(this).attr('tabindex', -1);
						// 20221025 Flipcard link fix
						/* Flip Card Scroll Accessibility Fix 2023 -- */
						$(this).find('.flip_content').each(function(index, element) {
							$(this).attr('tabindex', -1);
							tabCnt++;
							$(this).attr('data-tab', tabCnt);
							$(this).attr("aria-hidden", true);
						});
						/* -- Flip Card Scroll Accessibility Fix 2023 */

						$(this).find('a').each(function(index, element) {
							tabCnt++;
							$(this).attr('data-tab', tabCnt);
							$(this).attr("aria-hidden", true);
						});
					});
				}
			});				
		});


		
		$(this).find('.hotspot_btn_close').each(function(index, element) {	
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
		});
		
		/* ensure tab order of text content after activity is following activity 2021 */
		$(this).find('.content_text_after_activity').each(function(index, element) {			
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			
			$(this).find('a').each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
			});
		});


		

		
		/* 2021 Accessibility Update */
		$(this).find('.complete_arrow').each(function(index, element) {	
			$(this).attr('role','button');
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
		});	
		
    });
	
	$(":input").attr("aria-hidden", false);
	
	navTabCnt = tabCnt; /* 20180501 Accessibility Update */

	document.onmousedown = hideFocusOutline;
	
}

/* 20180501 Accessibility Update */
function setNavTab(){
	
	var tabCnt = navTabCnt;
	tabCnt++
	$('#left_nav').attr('tabindex', tabCnt);
	tabCnt++;
	$('#home_nav').attr('tabindex', tabCnt);
	tabCnt++;
	$('#right_nav').attr('tabindex', tabCnt);	
	/* 2021 Accessibility Update */		
	tabCnt++
	$('.branding .copyright').attr('tabindex', tabCnt);
	
	/* 20220616 JAWS fix to stop item being read when course launches */
	$('#left_nav').attr("aria-hidden", false);
	$('#home_nav').attr("aria-hidden", false);
	$('#right_nav').attr("aria-hidden", false);
	/* 20220616 JAWS fix to stop item being read when course launches */
	
	/* 20220616 Make home and resource button accessible with keyboard when using JAWS */
	$('.bar_robot').find('.home').each(function(index, element) {
		$(this).attr('aria-hidden', false);
    });
	$('.bar_robot').find('.menu_title').each(function(index, element) {
		$(this).attr('aria-hidden', false);
    });
	$('.bar_robot').find('.page').each(function(index, element) {
		$(this).attr('aria-hidden', false);
    });
	/* 20220616 Make home and resource button accessible with keyboard when using JAWS */
	
}
/* 20180501 Accessibility Update */

/* 20180501 Accessibility Update Remove tab functionality from content */
function removeTabIndex(){	
	$('.bar_robot').find('.home').each(function(index, element) {
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
	});
	/* 2021 Accessibility Update */
	$('.bar_robot').find('.menu_title').each(function(index, element) {
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
	});
	$('.bar_robot').find('.page').each(function(index, element) {
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
	});
	
	$('.sec_rest_wrapper').find('.section').each(function(index, element) {
		
		$(this).find('.h2_inner').each(function(index, element) {
			$(this).attr('tabindex', -1);
		});
		
		$(this).find('.content_text').each(function(index, element) {
			$(this).attr('tabindex', -1);
			
			/* 2021 Accessibility Update */
			/* ensure one column text and HTML table is accessible */
			$(this).find('td').each(function(index, element) {
				$(this).attr('tabindex', -1);
			});

			/* 2021 Accessibility Update */
			$(this).find('a').each(function(index, element) {
				$(this).attr('tabindex', -1);
			});
			
			/* self-certification 2021 */
			$(this).find('.cert_btn').each(function(index, element) {	
				$(this).attr('tabindex', -1);
			});
		
			/* 2021 Accessibility Update */
			$(this).find('img').each(function(index, element) {
				$(this).parent().attr('tabindex', -1);
			});
		});		
		
		$(this).find('.expando_btn').each(function(index, element) {
			$(this).attr('tabindex', -1);
			
			$(this).next('.expando_reveal').each(function(index, element){
				$(this).find('.expando_reveal_content').each(function(index, element) {	
					$(this).attr('tabindex', -1);

					$(this).find('a').each(function(index, element) {
						$(this).attr('tabindex', -1);
					});

				});

				$(this).find('.expando_reveal_heading').each(function(index, element) {
					$(this).attr('tabindex', -1);
				});
			});
						
		});	
		/* remove tabindex to video */
		$(this).find('.video_player').each(function(index, element) {
			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
		});
		$(this).find('.audio_player').each(function(index, element) {
			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
		});
		$(this).find('.content_video_alt').each(function(index, element) {	
			$(this).attr('tabindex', -1);
		});
		$(this).find('.transcript_btn').each(function(index, element) {	
			$(this).attr('tabindex', -1);
		});
		/* 2021 Accessibility Update */
		$(this).find('.transcript_text').each(function(index, element) {	
			$(this).attr('tabindex', -1);
		});
		/* remove tabindex to questions 2019 */
		$(this).find('.qItemFirst').each(function(index, element) {
			$(this).attr('tabindex', -1);
			$(this).attr("aria-hidden", true); /* 20220616 JAWS fix to stop item being read when course launches */
		});
		$(this).find('.squaredBox').each(function(index, element) {
			$(this).attr('tabindex', -1);
		});
				
		$(this).find('.mc_btn').each(function(index, element) {
            $(this).attr('tabindex', -1);
        });

		/* 20230608 Likert functionality */
		/* 101223 likert accessibility */
		$(this).find(".likert_row").each(function(index, element) {
			$(this).find(".statement").each(function(index, element) {
				$(this).attr('tabindex', -1);
			});
			$(this).find(".likert_rb").each(function(index, element) {
				$(this).attr('tabindex', -1);
			});
		});
				
		$(this).find('.feedback_text').each(function(index, element) {	
			$(this).attr('tabindex', -1);
			
			$(this).find('a').each(function(index, element) {
				$(this).attr('tabindex', -1);
			});
		});	
		
		/* ensure Try Again button is tabbed to 2019 */		
		$(this).find('.submit_btn').each(function(index, element) {	
			$(this).attr('tabindex', -1);
		});	
		
		$(this).find('.retake_assess_btn').each(function(index, element) {	
			$(this).attr('tabindex', -1);
		});	
		
		/* remove tabindex to slider */		
		$(this).find('.slider_txt').each(function(index, element) {	
			$(this).attr('tabindex', -1);
			
			$(this).find('a').each(function(index, element) {
				$(this).attr('tabindex', -1);
			});
			
			/* 101223 table in slide accessibility */
			$(this).find('td').each(function(index, element) {
				$(this).attr('tabindex', -1);
			});
			
		});	
		$(this).find('.slide_right').each(function(index, element) {	
			$(this).attr('tabindex', -1);
		});
		$(this).find('.slide_left').each(function(index, element) {	
			$(this).attr('tabindex', -1);
		});	
		/* remove tabindex to hotspot */
		$(this).find('.hotspot_btn').each(function(index, element) {	
			$(this).attr('tabindex', -1);
		});	
		$(this).find('.hotspot_reveal').each(function(index, element) {	
			$(this).attr('tabindex', -1);
		});	
		
		$(this).find('.hotspot_reveal').each(function(index, element) {	
			
			$(this).find('a').each(function(index, element) {
				$(this).attr('tabindex', -1);
			});
			
		});	

		$(this).find('.flip_card').each(function(index, element) {
			
			
			$(this).find('.flip_card_front').each(function(index, element) {
			
				$(this).attr('tabindex', -1);
				
			})
												  
		  	$(this).find('.flip_card_back').each(function(index, element) {
		
				$(this).attr('tabindex', -1);
				/* Flip Card Scroll Accessibility Fix 2023 -- */
				// 20230403 Flipcard tab fix
				$(this).find('.flip_content').each(function(index, element) {
					$(this).attr('tabindex', -1);
				});
				/* -- Flip Card Scroll Accessibility Fix 2023 */
				// 20221025 Flipcard link fix
				$(this).find('a').each(function(index, element) {
					$(this).attr('tabindex', -1);
				});
			})
			
		});	
		
		$(this).find('.hotspot_btn_close').each(function(index, element) {	
			$(this).attr('tabindex', -1);
		});
		
		$(this).find('.complete_arrow').each(function(index, element) {	
			$(this).attr('tabindex', -1);
		});	
		
    });
	
	$('#left_nav').attr('tabindex', -1);
	$('#home_nav').attr('tabindex', -1);
	$('#right_nav').attr('tabindex', -1);
	/* 20220616 JAWS fix to stop item being read when course launches */
	$('#left_nav').attr("aria-hidden", true);
	$('#home_nav').attr("aria-hidden", true);
	$('#right_nav').attr("aria-hidden", true);
	/* 20220616 JAWS fix to stop item being read when course launches */
	
	/* 2021 Accessibility Update */
	$('.branding .copyright').attr('tabindex', -1);
	
	$(":input").attr("aria-hidden", true); /* 20220616 JAWS fix to stop item being read when course launches */

}
/* 20180501 Accessibility Update Remove tab functionality from content */

/* close button is always hidden */
/*if(!isWeb){
	$('.topic_index .bar_close').css('display','none');
}else{
	$('.topic_index .bar_close').css('display','block');
}*/

/* apply button text and title attribute to interface buttons */
function interfaceStrings(){
	
	$('.index_banner_logo').attr('title', localiseString('course_logo'));
	$('.index_banner_logo').attr('alt', localiseString('course_logo'));
	
	$('.transcript_btn').html(localiseString('transcript_btn'));
	$('.transcript_btn').attr('title',localiseString('transcript_btn'));
	$('.transcript_btn').attr('alt',localiseString('transcript_btn'));
	
	$('.continue_vid_link').html(localiseString('continue_vid_link'));
	$('.continue_vid_link').attr('title',localiseString('continue_vid_link'));
	$('.continue_vid_link').attr('alt',localiseString('continue_vid_link'));
	
	$('.return_vid_link').html(localiseString('return_vid_link'));
	$('.return_vid_link').attr('title',localiseString('return_vid_link'));
	$('.return_vid_link').attr('alt',localiseString('return_vid_link'));
		
	$('.submit_btn').html(localiseString('submit_btn'));
	$('.submit_btn').attr('title',localiseString('submit_btn_locked'));
	$('.submit_btn').attr('alt',localiseString('submit_btn_locked'));
	
	$('.tryagain_btn').html(localiseString('tryagain_btn'));
	$('.tryagain_btn').attr('title',localiseString('tryagain_btn'));
	$('.tryagain_btn').attr('alt',localiseString('tryagain_btn'));
	
	$('.home').attr('title', localiseString('home_nav'));
	//$('.home').attr('alt', localiseString('home_nav'));
	$('#home_nav').attr('title', localiseString('home_nav'));
	//$('#home_nav').attr('alt', localiseString('home_nav'));
	/* test out: if there is a pre-test and it has been attempted and at least one topic has been tested out of hide the left and right nav buttons */
	if ((document.pretestPresent == 1) && (document.pretestAttempted == 1) && (document.topicsPretestedOut.indexOf("1") != -1))
	{
		$('#left_nav').hide();
		$('#right_nav').hide();
		$('#home_nav').addClass("pretest");
	}
	else {
		$('#right_nav').attr('title', localiseString('right_nav'));
		//$('#right_nav').attr('alt', localiseString('right_nav'));
		$('#left_nav').attr('title', localiseString('left_nav'));
		//$('#left_nav').attr('alt', localiseString('left_nav'));
	}
	$('.page').attr('title', localiseString('resource_btn'));
	//$('.page').attr('alt', localiseString('resource_btn'));
	$('.bar_close').attr('title', localiseString('exit_nav'));
	//$('.bar_close').attr('alt', localiseString('exit_nav'));
	
	$('.box_closer').attr('title', localiseString('close_btn'));
	//$('.box_closer').attr('alt', localiseString('close_btn'));
	
	$('.bookmark_nav_start').html(localiseString('bookmark_nav_start'));
	$('.bookmark_nav_start').attr('title', localiseString('bookmark_nav_start'));
	$('.bookmark_nav_start').attr('alt', localiseString('bookmark_nav_start'));
	$('.bookmark_nav_resume').html(localiseString('bookmark_nav_resume'));
	$('.bookmark_nav_resume').attr('title', localiseString('bookmark_nav_resume'));
	$('.bookmark_nav_resume').attr('alt', localiseString('bookmark_nav_resume'));
	$('#bm_title').html(localiseString('bookmark_title'));
	$('#bm_text').html(localiseString('bookmark_text'));
	
	$('.slide_right').attr('title', localiseString('slide_right'));
	$('.slide_right').attr('alt', localiseString('slide_right'));
	/* 2021 Accessibility Update */
	if(document.sliderLinear == true){
		$('.slide_left').attr('title', localiseString('slide_left_locked'));
		$('.slide_left').attr('alt', localiseString('slide_left_locked'));
	}
	else
	{
		$('.slide_left').attr('title', localiseString('slide_left'));
		$('.slide_left').attr('alt', localiseString('slide_left'));
	}	
	$('.temp_slide_nums').attr('title', localiseString('slide_progress'));
	$('.temp_slide_nums').attr('alt', localiseString('slide_progress'));
	
	$('.complete_arrow').attr('title', localiseString('complete_arrow_locked'));
	$('.complete_arrow').attr('alt', localiseString('complete_arrow_locked'));
		
	$('.start_img').attr('title', localiseString('topic_start'));
	$('.start_img').attr('alt', localiseString('topic_start'));
	
	$('.overlay').attr('title', localiseString('topic_locked'));
	$('.overlay').attr('alt', localiseString('topic_locked'));
	
	$('.select_bottom').find('.start_img').each(function(index, element) {
       if($(this).attr('src') != 'images/general_int/topic_locked.png'){
		   $(this).attr('alt', localiseString('topic_start'));
		   $(this).attr('title', localiseString('topic_start'));		   
	   }else{		   
		   $(this).attr('alt', localiseString('topic_locked'));
		   $(this).attr('title', localiseString('topic_locked'));
	   }
    });
	
	$('.progress').attr('alt', localiseString('topic_not_started'));
	$('.progress').attr('title', localiseString('topic_not_started'));
	
	/* separate title on Menu page 2019 */
	$(".menu_grid h1").html(document.courseTitleMenu);

	$(".retake_assess_btn").html(localiseString('retake_test_button'));
	/* 082223 retake test button accessibility */
	$('.retake_assess_btn').attr('alt', localiseString('retake_test_button'));
	$('.retake_assess_btn').attr('title', localiseString('retake_test_button'));
	
	$(".confirm_attest_btn").html(localiseString('confirm_attest_button'));
	/* 082223 attestation submit button accessibility */
	$('.confirm_attest_btn').attr('alt', localiseString('confirm_attest_button'));
	$('.confirm_attest_btn').attr('title', localiseString('confirm_attest_button'));
	
	$(".select_bottom").find('.topic_duration').each(function(index, element) {	
		
		//var txt = $(this).html();		
		//$(this).attr('data-duration', $(this).html());
	});	
	
	
}

/* 20220616 JAWS fix to stop item being read when course launches */
$(":input").attr("aria-hidden", true);
$('#left_nav').attr("aria-hidden", true);
$('#home_nav').attr("aria-hidden", true);
$('#right_nav').attr("aria-hidden", true);
$('.qItemFirst').attr("aria-hidden", true);
/* 20220616 JAWS fix to stop item being read when course launches */


/* updated to select via specific language */
function localiseString(identifier){
	if(eval("document.langStrings_" + document.selectedLang).hasOwnProperty(identifier)){
		return eval("document.langStrings_" + document.selectedLang)[identifier];
	}else{
		return "Lang string unknown";
	}
}
/* 2021 Accessibility Update */
function hideFocusOutline() {
	$('[tabindex]').focus(function()
	{
		$(this).css('outline', 'none');
	});
	$('[tabindex]').focusout(function()
	{
		$(this).css('outline', 'none');
	});
	$('[tabindex]').keyup(function (event)
	{
		if(event.keyCode == 9)
		{
			$(this).css('outline', '');
		}
	});
}	