/* functions to detect device, browser and app-related details */
/* this is a copy of screen_detection_intro.js in the scripts folder with some changes */
/*
    browser detect functionality to resize window accordingly
    taken from http://www.quirksmode.org/js/detect.html
*/

var BrowserDetect = {	
	init: function () {
		this.browser = this.searchString(this.dataBrowser) || "An unknown browser";
		this.version = this.searchVersion(navigator.userAgent)
			|| this.searchVersion(navigator.appVersion)
			|| "an unknown version";
		this.OS = this.searchString(this.dataOS) || "an unknown OS";
	},
	searchString: function (data) {
		for (var i=0;i<data.length;i++)	{
			var dataString = data[i].string;
			var dataProp = data[i].prop;
			this.versionSearchString = data[i].versionSearch || data[i].identity;
			if (dataString) {
				if (dataString.indexOf(data[i].subString) != -1)
					return data[i].identity;
			}
			else if (dataProp)
				return data[i].identity;
		}
	},
	searchVersion: function (dataString) {
		var index = dataString.indexOf(this.versionSearchString);
		if (index == -1) return;
		return parseFloat(dataString.substring(index+this.versionSearchString.length+1));
	},
	dataBrowser: [
		{
			string: navigator.userAgent,
			subString: "Chrome",
			identity: "Chrome"
		},
		{ 	string: navigator.userAgent,
			subString: "OmniWeb",
			versionSearch: "OmniWeb/",
			identity: "OmniWeb"
		},
		{
			string: navigator.vendor,
			subString: "Apple",
			identity: "Safari",
			versionSearch: "Version"
		},
		{
			prop: window.opera,
			identity: "Opera",
			versionSearch: "Version"
		},
		{
			string: navigator.vendor,
			subString: "iCab",
			identity: "iCab"
		},
		{
			string: navigator.vendor,
			subString: "KDE",
			identity: "Konqueror"
		},
		{
			string: navigator.userAgent,
			subString: "Firefox",
			identity: "Firefox"
		},
		{
			string: navigator.vendor,
			subString: "Camino",
			identity: "Camino"
		},
		{	// for newer Netscapes (6+)
			string: navigator.userAgent,
			subString: "Netscape",
			identity: "Netscape"
		},
		{
			string: navigator.userAgent,
			subString: "MSIE",
			identity: "Explorer",
			versionSearch: "MSIE"
		},
		{
			string: navigator.userAgent,
			subString: "Gecko",
			identity: "Mozilla",
			versionSearch: "rv"
		},
		{	// for older Netscapes (4-)
			string: navigator.userAgent,
			subString: "Mozilla",
			identity: "Netscape",
			versionSearch: "Mozilla"
		}
	],
	dataOS : [
		{
			string: navigator.platform,
			subString: "Win",
			identity: "Windows"
		},
		{
			string: navigator.platform,
			subString: "Mac",
			identity: "Mac"
		},
		{
			string: navigator.userAgent,
			subString: "iPhone",
			identity: "iPhone/iPod"
	    },
		{
			string: navigator.platform,
			subString: "Linux",
			identity: "Linux"
		}
	]
};

detectScreen = function(){
	isWeb = false;
	isWebiPad = false;
	/* store the last landscape screen viewed so that it will be displayed when the orientation reverts to landscape */
	var lastLandscape;
	/* DEVICE DETECTION */
	isAndroidTablet = false;
	isiPhone = false;
	isAndroidPhone = false;
	isStandalone = false;
	isIE8 = false;
	isIE9 = false;
	isFF = false;
	isXP = false;
	isMacChrome = false;
	useAICCRules = false;
	/* commitTimer is initialized in config.js */
	smaller_android = false;
	isuiwebview = false;
	defaultContentHeight = 671;	
	if((navigator.userAgent.match(/iPhone/i)) || (navigator.userAgent.match(/iPod/i))) {
		isiPhone = true;
	}
	if(navigator.userAgent.match(/Firefox/i)) {
		isFF = true;
	}
	if(navigator.userAgent.match(/Windows NT 5.1/i)) {
		isXP = true;
	}
	if (navigator.appName == 'Microsoft Internet Explorer'){
		isIE = true; 
		if(navigator.userAgent.match(/MSIE 8/i)){
			isIE8 = true;
		}
		if(navigator.userAgent.match(/MSIE 9/i)){
			isIE9 = true;
				
		}
		//if(typeof console!="undefined"){ /**/ }
	}
	if(navigator.appVersion.indexOf("Mac")!=-1 && navigator.userAgent.match(/Chrome/i)){
		isMacChrome = true
	}
	if(isFF && isXP){
	}
	isiPad = navigator.userAgent.match(/iPad/i) != null;
	// for use within iPad developer UIWebView
	var ua = navigator.userAgent;
	isiPad = /iPad/i.test(ua) || /iPhone OS 3_1_2/i.test(ua) || /iPhone OS 3_2_2/i.test(ua);
	var agent = navigator.userAgent.toLowerCase();
	var scrWidth = screen.width;
	var scrHeight = screen.height;
	var elemWidth = document.documentElement.clientWidth;
	var elemHeight = document.documentElement.clientHeight;
	var otherBrowser = (agent.indexOf("series60") != -1) || (agent.indexOf("symbian") != -1) || (agent.indexOf("windows ce") != -1) || (agent.indexOf("blackberry") != -1);
	var mobileOS = typeof orientation != 'undefined' ? true : false;
	var touchOS = ('ontouchstart' in document.documentElement) ? true : false;
	var iOS = (navigator.platform.indexOf("iPhone") != -1) ||
			(navigator.platform.indexOf("iPad") != -1) ? true : false;
	iOSVersion = getiOSVersion();

  	function getiOSVersion() {
    	var ua_start = ua.indexOf( 'OS ' );
		if( ( ua.indexOf( 'iPhone' ) > -1 || ua.indexOf( 'iPad' ) > -1 ) && ua_start > -1 ){
			return window.Number( ua.substr( ua_start + 3, 3 ).replace( '_', '.' ) );
		} else {
			return 0;
		}
	}
	//isAndroidTablet = (agent.indexOf("android") != -1) || (!iOS && !otherBrowser && touchOS && mobileOS) ? true : false;
	isAndroidTablet = (agent.indexOf("android") != -1) ? true : false;
	/* detect Android phone */
	if(isAndroidTablet){
		/* ensure to check for mobile surrounded by spaces to avoid picking up on Android table on Saba Cloud which contains sabamobilebrowser */
		isAndroidPhone = agent.indexOf(' mobile ') != -1;
		if(isAndroidPhone){
			isAndroidTablet = false;
		}
	}	
	if(isiPhone){
		//$('.screen_loader').css('display', 'none');
	}			
	if(!isiPad && !isiPhone && !isAndroidTablet && !isAndroidPhone){

		isWeb = true;
		/*$('.screen_loader').css('display', 'none');*/
		/* desktop browser being used so declare and set a default for this mobile only property */
		orientation = 90;
	}
	if(!isiPad && !isiPhone && isAndroidTablet){		
		/*$('.screen_loader').css('display', 'none');*/
	}
	if(isIE){
		isWeb = true;		
		/*include_css('assets/css/web.css');		
		$('.screen_loader').css('display', 'none');*/		
	}
	if (isiPad || isAndroidTablet){
		/*document.addEventListener("touchmove", touchMoveStart, false);*/
	}	
	if (isAndroidTablet) {
		/* check whether the browser is within an Android App */
		if(window.location.href.indexOf('127.0.0.1') !=-1){
			isStandalone = true; /* app */
		}
		else {
			isStandalone = false; /* browser */
		}
	}	
	/* detect if running in Android app */
	if (isAndroidTablet || isAndroidPhone) {
		/* check whether the browser is within an Android App */
		var uaString =  window.navigator.userAgent.toLowerCase();
		if(uaString.indexOf('wv') !=-1){
			androidApp = true;
		}else{
			if(uaString.indexOf('chrome/30') !=-1){
				androidApp = true;
			}
		}
	}	
	var standaloneAB = window.navigator.standalone,
    userAgentAB = window.navigator.userAgent.toLowerCase(),
    safariAB = /safari/.test( userAgentAB ),
    iosAB = /iphone|ipod|ipad/.test( userAgentAB );
	if( iosAB ) {
		if ( !standaloneAB && safariAB ) {
			//alert("browser " + window.navigator.userAgent)
		} else if ( standaloneAB && !safariAB ) {
			//alert("standalone " + window.navigator.userAgent)
		} else if ( !standaloneAB && !safariAB ) {
			//alert("uiwebview " + window.navigator.userAgent)
			isuiwebview = true;
			iOSApp = true; /* running in iOS App */
		};
	} else {
		//alert("not ios")
	};
}

if(window.innerHeight == 640 || window.innerHeight == 727){
	smaller_android = true	
}

resizeScreen = function(){
	if(opener){
		window.resizeTo(1048,872)
	}
}

$(document).ready(function(){
	detectScreen();
	if(isWeb){
		//resizeScreen();
	}
});

function resizeWindow(){
	if(BrowserDetect.browser == "Chrome"){
		setTimeout(resizeAndMove,1000);
	}else if(BrowserDetect.browser == "Safari"){
		setTimeout(resizeAndMove,1000);
	}else{
		resizeAndMove();
	}
}

function resizeAndMove(){
	var windowHeight = screen.availHeight;
	var windowWidth = screen.availWidth;
	
	var innerHeight = document.documentElement.clientHeight;
	var heightDiff = windowHeight - innerHeight;
	var newHeight = windowHeight;
	if(screen.availWidth <=800){		
		if(useAICCRules!=true){
			window.top.moveTo(-4,-4);
		}
	}else if(screen.availWidth <=1024){	
		
		if(useAICCRules!=true){
			window.top.moveTo(0,0);
		}
	}else {		
		if(useAICCRules!=true){
			window.top.moveTo(0,0);
		}
	}	
	if(useAICCRules!=true){
		window.top.resizeTo(windowWidth,newHeight);
	}
}

/* Get the mobile OS */
function getMobileOS(){
  var ua = navigator.userAgent
  if (/android/i.test(ua)) {
    return "Android"
  }
  else if (/iPad|iPhone|iPod/.test(ua)){
    return "iOS"
  }else if (navigator.platform === 'MacIntel' && navigator.maxTouchPoints > 1){
	   return "iOS"
  }
  return "Other"
}

var os = getMobileOS()
