/* variables used for course-specific text */
/* DEV NOTE indicates that the variable should be updated for the course */

$( document ).ready(function() {

	/* DEV NOTE: strings for course title; courseTitleMenu appears on Menu page and courseTitle appears everywhere else it is used */
	document.courseTitle = "FCC Anti-Bribery and Anti-Corruption Training 2024";
	document.courseTitleMenu = "Welcome";

	/* DEV NOTE: strings for topic titles which are used in the pre-test results */
	document.topicTitles = {
		titles:[
			{title:'Introduction'},
			{title:'Our People'},
			{title:'Our Firm'},
			{title:'Our Clients'},
			{title:'Our Communities'},
			{title:'Our Code of Business Conduct and Ethics'},
			{title:'Summary & Attestation'}
		]
	}	
		
	/* DEV NOTE: string for the intro text on the pre-test message that appears asking the learner if they want to take the pre-test; if there is no pre-test make this an empty string */
	document.pretestIntro = "Are you already familiar with the Course Name process? If so, it may be possible for you to skip some or all of this training."
	
	/* DEV NOTE: strings for text that is used on the pre-test and post-test intro pages; if there is no pre-test make the pre-test string an empty string; if there is no post-test make the post-test string an empty string */
	test_intro_dat = {
		pre_test:[{
			generic_msg:'Welcome to the Pre-test.<br><br>As mentioned, those who correctly answer all the questions relating to a specific topic will \'test out\' of that topic and be allowed to skip that part of the training.<br><br>Those who achieve a perfect score across all topics will be required to take only the course summary to complete the course.<br><br>Those who fail to test out of specific topics will be required to take those topics as normal. In the final test, they will receive questions only on those topics. Their score from the Pre-test will be combined with their second set of test scores to give a final grade. Participants must achieve 80% to pass.'
		}],
		post_test:[{
			generic_msg:'Are you ready to take the test on Anti-Bribery and Anti-Corruption?<br><br>You will need to answer 8 out of 10 questions correctly to pass.<br><br>You will be given three attempts.<br><br>If you do not achieve a passing score after the third attempt, you will be asked to review the course again.'
		}]
	}
	
	/* DEV NOTE: strings for text that is used on the pre-test and post-test results page before the score and for the pass and fail messages; if there is no pre-test make the pre-test strings empty strings; if there is no post-test make the post-test strings empty strings */
	test_results_dat = {
		pre_test:[{
			pass_msg:'Congratulations you have successfully completed the Pre-test! Because you earned a perfect score, you may now skip directly to the course summary. Once you have completed that, you have completed the course. Well done!',			
			pass_msg_2:'Congratulations, you have successfully completed the Pre-test! You have tested out of the following topic(s):',
			pass_msg_3:'You may skip the topic(s) marked passed, but you must undergo training on the remaining topics. Please select the Home button to get started.<br><br>Once done, you will have completed the course. Well done!',			
			fail_msg_1:'Thank you for completing the Pre-test. You have tested out of the following topic(s):',
			fail_msg_2:'You may skip the topic(s) marked passed, but you must undergo training on the remaining topics. Please select the Home button to get started.<br><br>Once done, you must take the final Test to complete the course. You will only be presented with questions on the topics you failed to test out on.',
			fail_msg_3:'Thank you for completing the Pre-test. Unfortunately, you failed to test out of any of the topics so you must undergo the entire course. Please select the Home button to get started.'
		}],
		post_test:[{
			generic_msg:'You scored: ',
			pass_msg:'Congratulations!<br><br>You have passed the test for this course.<br><br>In order to receive credit for this course, move on to submit your attestation.',
			fail_msg:'You didn’t pass the Test this time. You need to answer 8 out of 10 questions correctly to complete the course.<br><br>To retake the test, select the Retake Test button.',
			fail_max_msg:'Unfortunately, you didn’t pass the Test. As this was your third attempt, you are required to retake the course. When you retake the course, you will not be required to reselect your answers to questions located throughout the course.<br><br>To retake the course, select the Retake Course button.'
		}]
	}
	
	/* DEV NOTE: strings for text that is used on the attestation page before and after the attesting; if there is no attestation make these empty strings */
	attestation_dat = {		
		attestation:[{
			pre_attesting_msg:'Thank you for completing Goldman Sachs Compliance Learning: Anti-Bribery and Anti-Corruption 2024 Financial Crime Compliance.<br><br>If you do not understand any part of this training, please refer to the relevant policies, and if you are still unsure, you must exit the training now and contact the <a data-lnk-id="lnk_21" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Anti-Bribery Group</a> or your Compliance officer.<br><br>Before you leave, please attest to the following statement by selecting Submit.<br><br><strong>I certify that I have read and understood the contents of this course, Compliance Learning: Financial Crime Compliance – Anti-Bribery and Anti-Corruption, and the <a data-lnk-id="lnk_19" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Firmwide Policy on Anti-Bribery</a> and I will comply with my obligations under it.</strong>',
			attested_msg:'<span class="callout_text">Thank you for your attestation.</span><br><br><span class="callout_text">Congratulations!</span><br><br>You have successfully completed this training. You may now exit this course by closing your web browser.'
		}]
	}
	
	/* DEV NOTE: strings for the transcript titles and content separated by section id; if there are no transcripts make this variable an empty array */
	transcript_dat = {
		
		sec_3:[{
				title:'Transcript',			
				transcript:'<p>Integrity and honesty are at the heart of everything we do.</p><p>We hold ourselves accountable to the highest ethical standards and we must each take personal responsibility for complying with anti-bribery and anti-corruption laws and policies.</p><p>Know the red flags – for example, when is it risky to do business with a third party, such as an intermediary, vendor or business partner? Identifying and escalating the red flags of bribery and corruption will help to protect the firm’s and your personal reputation from the threats.</p><p>Always remain vigilant. While the firm has a robust control framework, one of our best defenses against bribery and corruption remains the vigilance of our people and our collective commitment to doing the right thing.</p><p>Whether you’ve been at the firm for one year or thirty years – everyone needs to take this training annually. Take the time to go through this module and be thoughtful in your responses.</p><p>Know the red flags, stop and escalate.</p><p>Let’s get started!</p>'
		}],		
		sec_40:[{
				title:'Transcript',			
				transcript:'<p>As you’ve seen in this training, operating with integrity is paramount.</p><p>We can see the direct impact bribery and corruption can have on our firm and our people.</p><p>We are fully committed to seeking and retaining business on the basis of merit and complying with all applicable laws and regulations designed to combat bribery and corruption.</p><p>We know that to build on our clients’ trust, we must do all we can to protect the firm’s reputation from the threats posed by bribery and corruption.</p><p>We’re counting on you to remain vigilant to bribery and corruption risks.</p><p>Always escalate any questions or concerns to the Anti-Bribery Group in Financial Crime Compliance or to your Compliance Officer.</p><p>You are our best defense.</p><p>Know the red flags, stop and escalate.</p>'
		}]
	}
	
	/* DEV NOTE: strings for the hotword titles and content separated by hotword id; if there are no hotwords make this variable an empty array */
	hotword_dat = {
		hw_1:[{
				title:'Anything of Value',
				text:'<p>The term ‘anything of value’ is broad and can include:</p><ul><li>Cash or kickbacks;</li><li>Gifts, travel, entertainment or meals;</li><li>Invitations to conferences or events;</li><li>Political contributions or charitable donations;</li><li>Offers of employment or internships; or</li><li>Corrupt payments disguised as legitimate payments for goods or services.</li></ul>'		
		}],
		hw_2:[{
				title:'Public Officials',				
				text:'<p>A \'public official\' is broadly defined to include:</p><ul><li>Any person holding an elected or appointed office, including any candidate for political office;</li><li>Officers or employees of a government entity, including state-owned or state-controlled enterprises;</li><li>Officers or employees of a public international organization or political party; or</li><li>Any person exercising a public function or acting in an official capacity for, or on behalf of, any of the above.</li></ul>'
		}],
		hw_3:[{
				title:'Business Opportunities',
				text:'<p>Business opportunities include:</p><ul><li>Transactions;</li><li>Joint ventures;</li><li>Partnerships; or</li><li>Other business-related opportunities, including client or prospective client relationships</li></ul>'
		}],
		hw_4:[{
				title:'Relationship Candidates',
				text:'<p>\'Relationship candidates\' are individuals referred by, or closely connected to, clients, potential clients or public officials (including regulatory officials).</p>'
		}],
		hw_5:[{
				title:'Restricted Recipients',
				text:'<p>\'Restricted Recipients\' are public officials, employees of exchanges and other self-regulatory organizations, examiners, US union officials, credit rating agencies and National Recognized Statistical Rating Organizations, and ERISA Fiduciaries.</p>'
		}],
		hw_6:[{
				title:'Employment',
				text:'<p>\'Employment\' includes permanent or temporary employment, paid and unpaid internships, certain training or exploratory programs, work shadows, and consulting or contracted working arrangements.</p>'
		}],
		hw_7:[{
				title:'Politically Exposed Person (PEP)',
				text:'<p>\'Politically Exposed Person (PEP)\' is an individual who is or has been entrusted with a prominent public function.<br><br>See the <a data-lnk-id="lnk_2" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Firmwide Policy on Intermediaries/Finders</a> for the full definition.</p>'
		}],
		hw_8:[{
				title:'Government Entity',
				text:'<p>Refers to any office, agency, ministry, instrumentality, sovereign wealth fund, or other part of a national, regional, or local government, public international organization, or royal family.</p>'
		}],
		hw_9:[{
				title:'Indirect Intermediaries',
				text:'<p>Third parties engaged and/or compensated by a client, underwriting syndicate, co-investor, counterparty, acquisition target, or another non-firm party involved in a business opportunity with the firm to provide referral, introductory or advisory services.</p>'
		}],
		hw_10:[{
				title:'State-owned enterprise (SOE)',
				text:'<p>Generally speaking, a state-owned enterprise (SOE) is a legal entity that is owned or controlled by a government in order to partake in commercial activities on the government’s behalf.</p>'
		}]
	}
	
	/* DEV NOTE: strings for the link URLs separated by link id; if there are no links make this variable an empty array */
	link_dat = {
		lnk_1:[{
				url:'https://gsdocs.site.gs.com/document/5e135357718a0111dd1c172b'
		}],
		lnk_2:[{
				url:'https://gsdocs.site.gs.com/document/5dc96091f490823505930993'
		}],
		lnk_4:[{
				url:'https://gsdocs.site.gs.com:8443/document/5e1361ad718a0111dd1c441e'
		}],
		lnk_5:[{
				url:'https://www.goldmansachs.com/investor-relations/corporate-governance/sustainability-reporting/vendor-code-of-conduct-index.html'
		}],
		lnk_6:[{
				url:'https://gsdocs.site.gs.com/document/5e1361f9718a0111dd1c451f'
		}],
		lnk_7:[{
				url:'https://gsdocs.site.gs.com/document/5e1361fd718a0111dd1c4536'
		}],
		lnk_8:[{
				url:'https://gsdocs.site.gs.com/document/5e135af6718a0111dd1c2ec5'
		}],
		lnk_9:[{
				url:'https://gsdocs.site.gs.com:8443/document/5dc960fdf490823505930a0f'
		}],
		lnk_10:[{
				url:'https://www.concursolutions.com/'
		}],
		lnk_11:[{
				url:'https://prod.gne.receipt.fcccore.site.gs.com:10042/site/gen.form.index.html#/'
		}],
		lnk_12:[{
				url:'https://gsdocs.site.gs.com:8443/document/60ec21e0cd65d14a83831588'
		}],
		lnk_13:[{
				url:'https://gsdocs.site.gs.com:8443/document/5dd2d8daf49082517258dde6'
		}],
		lnk_14:[{
				url:'http://pls.web.gs.com/pls/rest/search/export/document/Charitable_Contributions_Policy'
		}],
		lnk_15:[{
				url:'https://app.gsweb.site.gs.com/about-gs/article/389590/'
		}],
		lnk_16:[{
				url:'https://www.goldmansachs.com/investor-relations/corporate-governance/corporate-governance-documents/code-of-business-conduct-and-ethics.pdf'
		}],
		lnk_17:[{
				url:'https://www.goldmansachs.com/investor-relations/corporate-governance/corporate-governance-documents/anti-bribery-program.pdf'
		}],
		lnk_18:[{
				url:'https://gsdocs.site.gs.com:8443/document/5dc96091f490823505930993'
		}],
		lnk_19:[{
				url:'https://gsdocs.site.gs.com:8443/document/5dc96187f490823505930ae9'
		}],
		lnk_20:[{
				url:'https://gsdocs.site.gs.com:8443/document/5e137257718a0111dd1c78ca'
		}],
		lnk_21:[{
				url:'mailto:gs-antibribery-group@internal.email.gs.com'
		}],
		lnk_22:[{
				url:'https://www.concursolutions.com/home.asp'
		}],
		lnk_23:[{
				url:'https://gsdocs.site.gs.com/document/5e136982718a0111dd1c5ba1'
		}],
		lnk_24:[{
				url:'https://app.gsweb.site.gs.com/content/internal/428856/Expense_Management'
		}],
		lnk_25:[{
				url:'https://onegs.iad1.qualtrics.com/jfe/form/SV_0BWZ6scBB4hN42i'
		}]
	}
	
	/* DEV NOTE: strings for the resource popup title and content */
	resource_dat = {
		resources:[{
				title:'Resources',				
				text:'<p>Explore these links for more information:</p><p><a data-lnk-id="lnk_16" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Code of Business Conduct and Ethics</a></p><p><a data-lnk-id="lnk_15" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Business Integrity Program</a></p><p><a data-lnk-id="lnk_17" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Goldman Sachs Anti-Bribery &amp; Anti-Corruption Compliance Statement</a></p><p><a data-lnk-id="lnk_23" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Firmwide Policy on Country Lists</a></p><p><a data-lnk-id="lnk_2" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Firmwide Policy on Intermediaries/Finders</a></p><p><a data-lnk-id="lnk_1" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Due Diligence Form for Intermediaries and Finders</a></p><p><a data-lnk-id="lnk_4" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Firmwide Policy for Significant and Complex Transactions</a></p><p><a data-lnk-id="lnk_6" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Vendor Management Policy</a></p><p><a data-lnk-id="lnk_7" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Vendor Management Standard</a></p><p><a data-lnk-id="lnk_5" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Vendor Code of Conduct</a></p><p><a data-lnk-id="lnk_8" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Firmwide Policy on Relationship Candidates</a></p><p><a data-lnk-id="lnk_9" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Firmwide Policy on Gifts, Travel and Entertainment</a></p><p><a data-lnk-id="lnk_22" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Concur</a></p><p><a data-lnk-id="lnk_11" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Receipt of G&E Tool</a></p><p><a data-lnk-id="lnk_12" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Corporate Credit Card Policy</a></p> <p><a data-lnk-id="lnk_24" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Expense Policies, Procedures and Guidelines</a></p> <p><a data-lnk-id="lnk_13" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Firmwide Policy on Global Political Contributions and Activities</a></p><p><a data-lnk-id="lnk_14" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Firmwide Policy on Charitable Contributions</a></p>'
											
		}]
	}

	/* DEV NOTE: strings for LMS errors */
	lms_error_dat = {
		lms_error_1:[{
				text1:'API cannot be found.',
				text2:'The course may not have been launched from an LMS.'
		}]		
	}
});