/* functions to control display of dialogue boxes used for bookmark, hotwords, transcript and error messages and links */

$('.dialogue_pop').on('click', function() {
	whatPop(this)
});

/* keyboard functionality */
$('.dialogue_pop').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {
		
		$(this).trigger('click');
	}		
});

$('.continue_vid_link').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {
		
		$(this).trigger('click');
	}		
});

$('.return_vid_link').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {
		
		$(this).trigger('click');
	}		
});

$('.hotspot_reveal').on('click', 'a', function() {
	whatPop(this)	
})

/* keyboard functionality */
$('.hotspot_reveal').on('keypress', 'a', function() {
	$(this).trigger('click');
})

$('.hotspot_reveal').on('keypress', '.popup_pop', function() {
	$(this).trigger('click');	
})

var butReturnFocus;

function whatPop(selector){
	
	butReturnFocus = selector;
	
	if($(selector).hasClass('transcript_btn')){
		var section = $(selector).closest('.section').attr('id');
		//var secNum = section.split('_')[1];
		
		// 20200701 splash video functionality.
		var secNum = $(selector).attr("id").split('btn_')[1];
		if(secNum == 1){
			section = "sec_1"
		}
		
		/*var pop_type = 'transcript';
		boxPop(section, pop_type);*/
		$("#transcript_" + secNum + " .transcript_text").html(transcript_dat[section][0].transcript);
		if ($("#transcript_btn_" + secNum).html() == localiseString('transcript_btn'))
		{						
			$("#transcript_" + secNum).show();
			$("#transcript_btn_" + secNum).html(localiseString('transcript_close_btn'));
			/* 2021 Accessibility Update */
			$("#transcript_btn_" + secNum).attr('title',localiseString('transcript_close_btn'));
			$("#transcript_btn_" + secNum).attr('alt',localiseString('transcript_close_btn'));
			/* 2021 Accessibility Update */					
			var btnTabIndex = $(selector).attr('tabindex');
			var txtTabIndex = $("#transcript_" + secNum + " .transcript_text").attr('tabindex');			
			$(selector).attr('tabindex', txtTabIndex);
			$("#transcript_" + secNum + " .transcript_text").attr('tabindex', btnTabIndex);
			$("#transcript_" + secNum + " .transcript_text").focus();
		}
		else
		{
			$("#transcript_" + secNum).hide();
			$("#transcript_btn_" + secNum).html(localiseString('transcript_btn'));
			/* 2021 Accessibility Update */
			$("#transcript_btn_" + secNum).attr('title',localiseString('transcript_btn'));
			$("#transcript_btn_" + secNum).attr('alt',localiseString('transcript_btn'));	
			/* 2021 Accessibility Update */					
			var btnTabIndex = $(selector).attr('tabindex');
			var txtTabIndex = $("#transcript_" + secNum + " .transcript_text").attr('tabindex');			
			$(selector).attr('tabindex', txtTabIndex);
			$("#transcript_" + secNum + " .transcript_text").attr('tabindex', btnTabIndex);			
		}
				
		// 20200701 splash video functionality.
		if(secNum != 1){
			document.intComplete = true; // Unlock video when transcript opened
			isPageComplete(Number(section.split("_")[1])); // Unlock video when transcript opened
		}else{
			showSplashBtn();
		}
		
	}else if($(selector).hasClass('hotword')){			
		var hotword_sec = '#'+$(selector).closest('.section').attr('id');
		//var secNum = hotword_sec.split('_')[1];
		//findHotWordNum(secNum)
		/*if(Number($(selector).attr('data-hotword')) == 0){
			$(selector).attr('data-hotword',1);	
		}	*/		
		//var word = $(selector).text();
		var word = $(selector).attr('data-hw-id');
		var pop_type = 'hot_word';
		boxPop(word, pop_type);			
		//isHotWordDone(hotword_sec);			
		if($(selector).hasClass('hotword_neutral') && !($(selector).hasClass('hotword_neutral_visited'))){
			$(selector).addClass('hotword_neutral_visited');
		}
	}else if($(selector).hasClass('page')){			
		var word = $(selector).text();
		var pop_type = 'resources';
		boxPop('resources', pop_type);
		$(selector).addClass('page_visited');
	/* links functionality 2019 */
	}else if($(selector).hasClass('popup_pop')){		
		var lnkURL = link_dat[$(selector).attr('data-lnk-id')][0].url;
		var winName = 'name_' + $(selector).attr('data-lnk-id');
		var lnkWin = window.open(lnkURL,winName,'resizable=1,scrollbars=1,width=815,height=800');
		lnkWin.focus();
		if($(selector).hasClass('popup_neutral') && !($(selector).hasClass('popup_neutral_visited'))){
			$(selector).addClass('popup_neutral_visited');
		}
	}		
}

$('.popup_pop').click(function() {
	/* links functionality 2019 */
	whatPop(this);
});

/* keyboard functionality */
$('.popup_pop').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {
		$(this).trigger('click');
	}		
});

$('.box_closer').click(function() {
	closeErrorPopupOrCourse();
});

/* keyboard functionality */
$('.box_closer').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {
		
		$(this).trigger('click');
	}		
});

/* 2021 Accessibility Update */
$('.box_closer').on('keydown', function(e) {
	if ((e.which == 9) && (!e.shiftKey)) {
		e.preventDefault();
		$('.box_title').focus();
	}
});

$( window ).resize(function() {
	 $('.box_holder:visible').not('.bookmark').css({
        'position' : 'absolute',
        'top' : '50%',
        'margin-top' : -$('.box_holder:visible').outerHeight()/2
    });
	if($('.box_nav_holder:visible').height() > $(window.parent).height()){
		$('.dialogue_box').not('.bookmark').addClass('box_overflow');
		$('.box_holder').not('.bookmark').addClass('box_static');
	    $('.box_holder:visible').css({'margin-top' : 0})
	}else{
		$('.dialogue_box').not('.bookmark').removeClass('box_overflow');
		$('.box_holder').not('.bookmark').removeClass('box_static');
	}
});

function boxPop(section, pop_type, error_title, error_mess){
	
	/* 20180501 Accessibility remove tab funcitonality */
	popupKeyDown = true; 
	removeMenuTabIndex();
	removeTabIndex();
	/* 20180501 Accessibility remove tab funcitonality */
	
	/* hide the section containing the bookmark buttons */
	$('.box_holder .box_bottom').hide();
	$('.box_section').removeClass('box_section_btns');
	/* only show the error popup if an error is currently being processed */	
	if ((!document.errorMessagePresent && !document.errorNotifyPresent) || (pop_type == 'error'))
	{
		if(isWeb){
			$('html, body').css('overflow-y','hidden');
			/*$("html, body").disableScroll();*/ /* disable scroll bar */
		}else{
			$('html, body').css('overflow-y','hidden');
		}
		$('.box_closer').show(); /* show close button */
		if(pop_type == 'hot_word'){		
			$('.box_holder .box_title').html('<h3>'+hotword_dat[section][0].title+'<\h3>');
			$('.box_holder .box_message').html(hotword_dat[section][0].text);
			/* 20180501 Accessibility Apply tab functionality to popup */
			if(popupKeyDown){
				var tabCnt = 0;
				/* 2021 Accessibility Update */
				tabCnt++;
				$('.box_title').attr('tabindex', tabCnt);
				tabCnt++;
				$('.box_message').attr('tabindex', tabCnt);
				$('.box_message').find('a').each(function(index, element) {	
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					$(this).on('keypress', function() {
						$(this).trigger('click');
					})
				});
				tabCnt++;
				$('.box_closer').attr('tabindex', tabCnt);
				$('.box_title').on('keydown', function(e) {
					if ((e.which == 9) && (e.shiftKey)) {
						e.preventDefault();
						$('.box_closer').focus();
					}
				});
			}
			/* 20180501 Accessibility Apply tab functionality to popup */
		}else if(pop_type == 'resources'){
			/* 2021 Accessibility Update */
			$('.box_holder .box_title').html('<h3>'+resource_dat[section][0].title+'</h3>');
			$('.box_holder .box_message').html(resource_dat[section][0].text);
			/* 20180501 Accessibility Apply tab functionality to popup */
			if(popupKeyDown){
				var tabCnt = 0;
				/* 2021 Accessibility Update */
				tabCnt++;
				$('.box_title').attr('tabindex', tabCnt);
				tabCnt++;
				$('.box_message').attr('tabindex', tabCnt);
				$('.box_message').find('a').each(function(index, element) {	
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					$(this).on('keypress', function() {
						$(this).trigger('click');
					})
				});
				tabCnt++;
				$('.box_closer').attr('tabindex', tabCnt);
				$('.box_title').on('keydown', function(e) {
					if ((e.which == 9) && (e.shiftKey)) {
						e.preventDefault();
						$('.box_closer').focus();
					}
				});
			}
			/* 20180501 Accessibility Apply tab functionality to popup */
		}
		else if(pop_type == 'error'){
			/* 20210422 Android and Edge Fixes: if committing after setting complete or passed lesson status or setting a passing and higher score than LMS score use a more detailed error message */
			/* 20220111: ensure to check for proper error message title for bookmarking fix for Edge Chromium and Android via Saba App */
			var tempErrorTitle = '<h3>'+error_title+'</h3>';
			if ($('.box_holder .box_title').html() != tempErrorTitle)
			{
				$('.box_section').addClass('box_section_btns');
				/* 2021 Accessibility Update */
				$('.box_holder .box_title').html('<h3>'+error_title+'</h3>');
				$('.box_holder .box_message').html(error_mess);
				if (isiPad || isAndroidTablet || isAndroidPhone || isiPhone) {
					$('.box_closer').hide();
				}
				/* 2021 Accessibility Update */
				if(popupKeyDown){
					var tabCnt = 0;				
					tabCnt++;
					$('.box_title').attr('tabindex', tabCnt);
					tabCnt++;
					$('.box_message').attr('tabindex', tabCnt);
					$('.box_message').find('a').each(function(index, element) {
						tabCnt++;
						$(this).attr('tabindex', tabCnt);
					});				
					tabCnt++;
					$('.box_closer').attr('tabindex', tabCnt);
					$('.box_title').on('keydown', function(e) {
						if ((e.which == 9) && (e.shiftKey)) {
							e.preventDefault();
							$('.box_closer').focus();
						}
					});
				}
			}	
		}
		else if(pop_type == 'bookmark'){			
			var bookmarkTitle = "";
			var bookmarkText = "";
			var bookmarkNavStart = "";
			var bookmarkNavResume = "";			
			/* test out: if there is a pre-test in the course */
			if (document.pretestPresent == 1)
			{
				/* test out: show the pre-test bookmark popup if pre-test has not yet been attempted */
				if (document.pretestAttempted == 0) {
					bookmarkTitle = localiseString('pretest_title');
					bookmarkText = document.pretestIntro + "<br><br>" + localiseString('pretest_text');
					bookmarkNavStart = localiseString('pretest_nav_cancel');
					bookmarkNavResume = localiseString('pretest_nav_start');
				}
				else {
					bookmarkTitle = localiseString('bookmark_title');
					bookmarkText = localiseString('bookmark_text');
					bookmarkNavStart = localiseString('bookmark_nav_start');
					bookmarkNavResume = localiseString('bookmark_nav_resume');
				}	
			}
			else {
				bookmarkTitle = localiseString('bookmark_title');
				bookmarkText = localiseString('bookmark_text');
				bookmarkNavStart = localiseString('bookmark_nav_start');
				bookmarkNavResume = localiseString('bookmark_nav_resume');
			}
			$('.box_section').addClass('box_section_btns');
			/* 2021 Accessibility Update */
			$('.box_holder .box_title').html('<h3>'+bookmarkTitle+'</h3>');
			$('.box_holder .box_message').html(bookmarkText);
			$('.box_holder .box_bottom').html('<div class=\'button_holder\'><div class=\'button_container bookmark_button_container\'><div class=\'bookmark_nav_start\' role=\'button\'>'+bookmarkNavStart+'</div><div class=\'bookmark_nav_resume\' role=\'button\'>'+bookmarkNavResume+'</div></div></div>');
			$('.box_holder .box_bottom').show();
			$('.box_closer').hide();			
			/* 2021 Accessibility Update */
			if(popupKeyDown){
				var tabCnt = 0;
				tabCnt++;				
				$('.box_title').attr('tabindex', tabCnt);
				tabCnt++;
				$('.box_message').attr('tabindex', tabCnt);
				tabCnt++;
				$('.bookmark_nav_start').attr('tabindex', tabCnt);
				tabCnt++;
				$('.bookmark_nav_resume').attr('tabindex', tabCnt);
				$('.box_title').on('keydown', function(e) {
					if ((e.which == 9) && (e.shiftKey)) {
						e.preventDefault();
						$('.bookmark_nav_resume').focus();
					}
				});
				$('.bookmark_nav_resume').on('keydown', function(e) {
					if ((e.which == 9) && (!e.shiftKey)) {
						e.preventDefault();
						$('.box_title').focus();
					}
				});
			}
			// eLRT Integration/Testing.
			if (window.parent.document.elrtEnabled)
			{
				if ((typeof document.currentSection == 'undefined') || (document.currentSection < 2))
				{				
					window.parent.elrtSetState(null,null);
				}
				else
				{	
					var modId = $('#sec_' + document.currentSection).attr('data-uid').split('_')[0];
					var pgId = $('#sec_' + document.currentSection).attr('data-uid').split('_')[1];
					window.parent.elrtSetState(modId, pgId);
				}	
			}
		}
		$('.box_nav_holder').height();
		if(isWeb){
			$('.dialogue_box').fadeIn('fast');
		}else{
			$('.dialogue_box').show();
		}
		$('.box_holder:visible').css({
			'position' : 'absolute',
			'top' : $(window.parent).height()/2,
			'margin-top' : -$('.box_holder:visible').outerHeight()/2
		});
		if($('.box_nav_holder:visible').height() > $(window.parent).height()){
			$('.dialogue_box').not('.bookmark').addClass('box_overflow');
			$('.box_holder').not('.bookmark').addClass('box_static');
			$('.box_holder:visible').css({'margin-top' : 0})
		}
		/* remove isiPad to fix blank window appearing in iPad iOS13 on Saba Cloud */
		if(isiPhone){ /* fix for iPhone added */
			$('.sec_rest_wrapper, .topic_index').css({'margin-top': -windowTop, 'position':'fixed'})
		}
	}
	/* 2021 Accessibility Update */
	/* ensure outline does not appear on mobile devices */
	if (isWeb)
	{
		/* 2021 Accessibility Update */
		hideFocusOutline();
		$('.box_title').focus();
	}	
	hideFocusOutline();
}

function boxClose(){
	/* remove isiPad to fix blank window appearing in iPad iOS13 on Saba Cloud */	
	if(isiPhone){
		var top = Math.abs(parseInt($('.sec_rest_wrapper, .topic_index').css('margin-top')))
		$('.sec_rest_wrapper, .topic_index').css({'margin-top': 0, 'position':'absolute'})
	}	
	if(isWeb){
		$('html, body').css('overflow-y','visible');
		/*$("html, body").enableScroll();*/ /* enable scroll bar */
	}else{
		$('html, body').css('overflow-y','visible');
	}	
	if(isWeb){
		$('.dialogue_box').fadeOut('fast');
	}else{
		$('.dialogue_box').hide();
	}
	$('.dialogue_box').removeClass('box_overflow');
	$('.box_holder').addClass('box_reposition');
	$('.box_holder').removeClass('box_static');
	/* remove isiPad to fix blank window appearing in iPad iOS13 on Saba Cloud */
	if(isiPhone){
		$(parent.parent.document).scrollTop(top)
		$('.bar_robot').css('top',($(parent.parent.document).scrollTop())-1+'px'); /* fix for iPhone added */
		$('.bar_robot').removeClass('displayNone').addClass('displayBlock'); /* fix for iPhone added */
	}
	$('.box_holder .box_bottom').hide();
	/* 20180501 Accessibility Reapply tab funcitonality to content */
	/* 2021 Accessibility Update */
	$('.box_title').attr('tabindex', -1);
	$('.box_message').attr('tabindex', -1);
	$('.box_message').find('a').each(function(index, element) {	
		$(this).attr('tabindex', -1);
	});
	$('.box_closer').attr('tabindex', -1);
	if(index === true){
		setMenuTabIndex();
	}else{
		$('.bar_robot').find('.home').each(function(index, element) {
			$(this).attr('tabindex', 1);
		});
		/* 2021 Accessibility Update */
		$('.bar_robot').find('.menu_title').each(function(index, element) {
			$(this).attr('tabindex', 2);
		});
		$('.bar_robot').find('.page').each(function(index, element) {
			$(this).attr('tabindex', 3);
		});
		setNavTab();
	}
	setTabIndex();

	popupKeyDown = false;
	
	$(butReturnFocus).focus(); // Return focus to button or hotword
	
	/* 20180501 Accessibility Reapply tab funcitonality to content */
}

/* disable/enable scroll bar */
$.fn.disableScroll = function() {
    window.oldScrollPos = $(window).scrollTop();
	$(window).bind('mousewheel',function(){ return false; });
    /*$(window).on('scroll.scrolldisabler',function ( event ) {
       $(window).scrollTop( window.oldScrollPos );
       event.preventDefault();
    });*/
};

$.fn.enableScroll = function() {
    //$(window).off('scroll.scrolldisabler');
	$(window).unbind('mousewheel');
};