/* functions to allow navigation between topics */

var currentSec = 0
var nav = false

document.topic_complete=[]
	if(document.topic_intro === "no"){
		$('.sec_1_wrapper').hide()
		$('.sec_rest_wrapper').css('margin-top','0')
	}else{
		$('.bar_robot').hide()
		$('.sec_1_wrapper').show()
		$('.sec_1_wrapper #topic_intro').show()
	}
	
/* hide previous topic and show next */
function gotoTopic(target){
		
	var op;
	var sec_saver = currentSec;
	if(target === 'right_nav' && currentSec < ($('.breaker').length-1)){
		nextSection = 0;
		/* custom branching based on CITI071: Module 6: common topic, a branching topic with branching screentype, two branches, no assessement 2023 */
		/* allow page to go forward to a specific topic */
		if($("#sec_"+document.currentSection).hasClass("custom_nav")){
			currentSec = Number($("#sec_"+document.currentSection).attr("data-gonext"))-1;
		}else{
			currentSec++
		}
		startedTopic(currentSec)
		op = 'left'
		nav = true
		cloneOne(target, sec_saver, nav, op)
	}else if(target === 'left_nav'  && currentSec >=1){
		nextSection = 0;
		/* custom branching based on CITI071: Module 6: common topic, a branching topic with branching screentype, two branches, no assessement 2023 */
		/* allow page to go back to a specific topic */
		if($("#sec_"+document.currentSection).hasClass("custom_nav")){
			currentSec = Number($("#sec_"+document.currentSection).attr("data-goback"))-1;
		}else{
			currentSec--
		}
		startedTopic(currentSec)
		op= 'right'		
		nav = true
		cloneOne(target, sec_saver, nav, op)
	}else if(target === 'topic_select'){
		indexTopic(currentSec)
		isCourseLocked()
	}else if(target === 'burger_select'){ // 20190607 Fix for menu overlaying content when resizing window after using burger menu
		indexTopic(currentSec)
		isCourseLocked()
	}
	topicTitle()
	nav = false
	//clearTopicQs();
	document.currentTopic = (currentSec+1);
	
	//console.log("document.currentTopic = " + document.currentTopic)
	
	getSliderHeight(); // Slider height fix
	pauseAllVideos(); // Pause all videos
	
	updateAccentColors(); // Updated the topic accent color
	checkTopicTest(); // Check if section/topic test has been taken
	rePosHotSpots();
}

/* what screens to unlock */
function isCourseLocked(){ 
	var currentbreaker = $('.breaker').eq(currentSec)
	var nextbreaker = $('.breaker').eq(currentSec + 1)
	var introSec = '#'+$('.breaker').eq(currentSec).attr('id');	
	$('.sec_rest_wrapper').eq(0).children().css('display', 'none')
	$('.breaker').eq(currentSec).css('display','block');
	if(document.courseLockedDown == false && !currentbreaker.hasClass('testStartSec')){
		currentbreaker.nextUntil(nextbreaker).css('display','block')
	}else{
		oraginiseLocking()
		unlockPages()
	}
	downButton()
	lockNav()
	progress()
	resizeCheckBox()
	if(!isWeb){
		rePosBanner(); /* reposition banner when navigating menu */
	}
	setTimeout(function(){
		setTopicIntro(introSec);
	},750)
}

/* set up topic transition */
function cloneOne(direction, sec_saver, nav, op){
	
	$("#topic_loader").show()
	$('.sec_rest_wrapper').css('display', 'none')
	isCourseLocked()
	loading(nav, op)
}

/* load intro image */
function loading(nav, op, margin){
	//console.log("currentSec = " + currentSec)
		
	$("#topic_loader").delay(750).fadeOut(0)
	setTimeout(function(){
		$('.sec_rest_wrapper').css('display', 'block');
		//20190917 desktop portrait fix
		portraitTestFix();
		$(window).trigger('scroll');
		
		//alert(document.currentSection);
		
		$("#sec_" + (document.currentSection+1) + " .page_start").focus();
		window.scrollTo({ top: 0}); // 20221128 fix so window stays at top when moving topics
		
	},750)
}

/* into video or image */
function videoorimage(nav, op){
	if(nav === true){
		if(document.topic_intro === "yes"){	
			if(document.intro_back[currentSec].type === "video"){
				video_src = document.intro_back[currentSec].mp4
				loadVideo(video_src)
				$("#topic_intro .background_stretch").hide()
				$(".bg_video video")[0].onloadeddata = function() {
					topicAnim(nav, op);
					$(".bg_video video")[0].onloadeddata = false}
			}else{
				if(document.intro_back[currentSec].type === "color"){
					$("#topic_intro .background_stretch").css("background-color", document.intro_back[currentSec].color);
				}else{
					$("#topic_intro .background_stretch").css("background-image", document.intro_back[currentSec].path);
				}
			}	
		}
		if(op!==null){
			topicAnim(nav, op)
		}
	}
}

/* start animation */
function topicAnim(nav, op){
	var anim_length = 1000
	if(document.topic_intro === "yes"){	
		$('.sec_rest_wrapper, .clone_wrapper #topic_intro').stop().animate({ 'left' : op}, anim_length, function(){
			$("html, body").animate({scrollTop:0}, 0)
			$('.sec_rest_wrapper').css({ 'left': '0'})
			$('.topic_nav_bar').css('display','none')
		})
	}
	if(document.topic_intro === "no"){
		$('body').css({'overflow-y': 'scroll'})
		$(".sec_rest_wrapper:eq(1)").addClass('loading_timer clone_move_'+op)
		$(".sec_rest_wrapper:eq(0)").addClass('loading_timer body_move_'+op)
			if(isWeb){
				//alert("hi")
				setTimeout(function(){
				$(".sec_rest_wrapper:eq(0), .sec_rest_wrapper:eq(1)").removeClass('loading_timer body_move_'+op+' clone_move_'+op+'')
				isCourseLocked()
				$("html, body").animate({scrollTop:0}, 0)
				$('.topic_nav_bar').css('display','none')
				$('body').find(".clone_wrapper").remove()
				$('.sec_rest_wrapper').css({ 'left': '0'})
				$('body').css({'overflow-y': 'visible'})
					//20190917 desktop portrait fix
					portraitTestFix();
					
					
				},950)
			}else{ /* mobile devices */
				$(".sec_rest_wrapper:eq(0)").removeClass('loading_timer body_move_'+op+'')
				isCourseLocked()
				$("html, body").animate({scrollTop:0}, 0)
				$('.topic_nav_bar').css('display','none')
				$('.sec_rest_wrapper').css({ 'left': '0'})
				setTimeout(function(){
					$('body').find(".clone").remove();
          //20190917 desktop portrait fix
					portraitTestFix();
					
									 },200)
			}
		
	}
}

function indexTopic(currentSec){
	
	if(index===true){
		if(document.topic_intro === "yes"){
			if(document.intro_back[currentSec].type === "video"){
				loadVideo()
				$(".bg_video video")[0].onloadeddata = function(){
					topic_closer()
				}
			}else{
				if(document.intro_back[currentSec].type === "color"){
					$("#topic_intro .background_stretch").css("background-color", document.intro_back[currentSec].color);
				}else{
					$("#topic_intro .background_stretch").css("background-image", document.intro_back[currentSec].path);
				}	
				$("html, body").animate({scrollTop:0}, 0)
				topic_closer()
			}
		}else{
			topic_closer()
		}
	}
}

/* event handlers */
$('#right_nav, #left_nav').click(function(e){
	/* test out: if there is a pre-test in the course and it is being taken */
	if ((document.pretestPresent == 1) && document.takingPretest)
	{
		if($(this).attr('id') == 'right_nav') {
			/* test out: update the Menu icons and reset for the post-test */
			exitPretest();
			/* test out: do not bookmark the pre-test upon leaving it */
			document.pretestDone = true;
			/* test out: go to the Summary topic */
			gotoTopic('left_nav');
		}
	}	
	else {
		if(!$(this).hasClass('locked')){
			gotoTopic(e.target.id);
			
		}else{
			if($(this).attr('id') == 'right_nav') {
				/* custom branching based on CITI071: Module 6: common topic, a branching topic with branching screentype, two branches, no assessement 2023 */
				/* ensure that alert to tell user to complete page does not appear on disabled forward button */
				if((document.currentSection != document.subsectionCount) && (!$("#sec_"+document.currentSection).hasClass("noForward"))) {
					alert(localiseString('right_btn_locked')); // 2019/06/04 Alert to tel user to complete page 
				}
			}
		}
		if($(this).attr('id') == 'right_nav') {
			lockTopics(true);
		}
		else {
			lockTopics(false);
		}
		// reset these variables
		document.skipTopicTest = false;
		document.takeTopicPreTest = false;
	}	
})

/* keyboard functionality */
$('#right_nav, #left_nav').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {
		
		$(this).trigger('click');
	}		
});

$('.topic_select').click(function(e){
	
	/* test out: if there is a pre-test in the course */
	if (document.pretestPresent == 1)
	{
		/* test out: do not bookmark the pre-test upon leaving it */
		document.pretestDone = true;
	}	
	if(!isWeb){
		//deviceAudio();
	}
	document.topic_complete=[]
	
	if($(this).children('.overlay').css('display')==='none'){
		burgerSel = false;
		//currentSec = $('.topic_select').index(this);
		currentSec = $(this).attr("data-gotopic") - 1;
		
		
		//console.log("currentSec = " + currentSec)
		startedTopic(currentSec)
		gotoTopic('topic_select')
		$('.topic_nav_bar').css('display','none')
		$('.topic_closer').css('display','block')
		$('.index_banner_holder').css('display','none');
		removeMenuTabIndex(); // remove menu tab functionality
		setTabIndex(); // 202210
		setNavTab(); /* 20180501 Accessibility Added tab functionality to Navigation Bar */

		$('#left_nav').show();
		$('#right_nav').show();
		
		lockTopics(true);
	}
})

/* keyboard functionality */
$('.topic_select').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {
		
		$(this).trigger('click');
	}		
});



/*$('.topic_select').mouseover(function(e){
	if($(this).children('.overlay').css('display')==='none'){
		var imgStr = "";
		var imgEle;
		$(this).find('.heading_area img').each(function(index, element) {

			imgStr = $(this).attr('src');
			imgEle = $(this);
		});

		if(imgStr != undefined){
			var ext = imgStr.split('.')[1];
			var img = imgStr.split('.')[0];
			imgEle.attr('src',img + '_hover.' + ext);
			
		}
	}
	
})


$('.topic_select').mouseout(function(e){
	if($(this).children('.overlay').css('display')==='none'){
		var imgStr = "";
		var imgEle;
		$(this).find('.heading_area img').each(function(index, element) {

			imgStr = $(this).attr('src');
			imgEle = $(this);
		});
		if(imgStr != undefined){
			var ext = imgStr.split('.')[1];
			var img = imgStr.split('_hover')[0];
			imgEle.attr('src',img + '.' + ext);
		}
	}
})*/


var burgerSel = false; // 20190607 Fix for menu overlaying content when resizing window after using burger menu


$('.burger_select').click(function(e){
	/* test out: if there is a pre-test in the course */
	if (document.pretestPresent == 1)
	{
		/* test out: do not bookmark the pre-test upon leaving it */
		document.pretestDone = true;
	}	
	if(!isWeb){
		//deviceAudio();
	}
	document.topic_complete=[]
	if($(this).children('.overlay').css('display')==='none'){
        
		burgerSel = true;
        // LJ reset assessment when using home button or menu to stop user having to scroll to reset assessment button
        if(document.currentSection == document.testResultsSubsection){
			if(document.testResultsSubsection != null){
				retakeAssessment();
			}
			
        }
        // LJ reset assessment when using home button or menu to stop user having to scroll to reset assessment button
        
		currentSec = $('.burger_select').index(this)
		startedTopic(currentSec)
		gotoTopic('burger_select') // 20190607 Fix for menu overlaying content when resizing window after using burger menu
	
		removeMenuTabIndex(); // remove menu tab functionality
		$(".burger_index").css("display","none")
		//$(".topic_index").css("display","none")
		
		index = false;
		setTabIndex(); /* 20220630 Accessbility fix to reassign tab order */
		setNavTab(); /* 20180501 Accessibility Added tab functionality to Navigation Bar */
        $('#left_nav').show();
        $('#right_nav').show();
		
		if(isWeb){
			//$("html, body").enableScroll(); /* enable scroll bar */
			$('html, body').css('overflow-y','visible');
		}else{
			$('html, body').css('overflow-y','visible');
		}	
		preTestStart();
		
		lockTopics(true);
	}
})

/* keyboard functionality */
$('.burger_select').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {
		
		$(this).trigger('click');
	}		
});


$('.burger_home').click(function(e){
	/* test out: if there is a pre-test in the course */
	if (document.pretestPresent == 1)
	{
		/* test out: do not bookmark the pre-test upon leaving it */
		document.pretestDone = true;
	}	
	if(!isWeb){
		//deviceAudio();
	}
        
	// LJ reset assessment when using home button or menu to stop user having to scroll to reset assessment button
	if(document.currentSection == document.testResultsSubsection){
		if(document.testIntroSubsection != null){
			retakeAssessment();
		}
	}
	
	$(".burger_index").css("display","none");
	index = false;
	$('#home_nav').trigger("click");
	
	if(isWeb){
		//$("html, body").enableScroll(); /* enable scroll bar */
		$('html, body').css('overflow-y','visible');
	}else{
		$('html, body').css('overflow-y','visible');
	}	
	

})

/* keyboard functionality */
$('.burger_home').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {
		
		$(this).trigger('click');
	}		
});



$('#home_nav').click(function(){
	
	/* custom branching based on CITI071: Module 6: common topic, a branching topic with branching screentype, two branches, no assessement 2023 */
	/* ensure that Home button in footer does not work when no branch has been selected in a session */
	if(document.hasBranches){
		if(document.userBranch == 0){
			return false;
		}
	}
	
	if(index===false){
		/* test out: if there is a pre-test in the course */
		if (document.pretestPresent == 1)
		{
			/* test out: if currently taking the pre-test update the Menu icons and reset for the post-test */
			if (document.takingPretest) {			
				exitPretest();
			}
		}		
        
        // LJ reset assessment when using home button or menu to stop user having to scroll to reset assessment button
        if(document.currentSection == document.testResultsSubsection){
            if(document.testIntroSubsection != null){
				retakeAssessment();
			}
        }
        
		
		$("#topic_loader").show()
		$('.sec_rest_wrapper').hide()
		$( "html, body" ).scrollTop( 0 )
		$(".bar_robot").removeClass('displayBlock').addClass('displayNone');
		setTimeout(function(){
			$('.topic_index').css('display', 'block')
			//topic_height()
			$('#topic_nav_bar_menu').show();
			$("#topic_loader").hide()	
			$('.index_banner_holder').css('display','block');
			//$(".home_title").css("display","block");
			topic_height()
			index = true;
		},2000)
			
			
		
		$('.bar_robot').css('display','none');
		$('.bar_bot').css('display','none');
		$(".bar_bot").removeClass('displayBlock').addClass('displayNone');
		$(".bar_robot").removeClass('displayBlock').addClass('displayNone');
		setMenuTabIndex();	// set menu tab functionality
		index = true;
		pauseAllVideos(); // Pause all videos
		
		markTopicQsViewed();
		
		/* custom branching based on CITI071: Module 6: common topic, a branching topic with branching screentype, two branches, no assessement 2023 */
		/* update the home page menu to enable the branch topics when the Home button in the footer is selected and a branch has been selected in a session */
		if(document.hasBranches){
			if(document.userBranch != 0){
				$(".branch_item").css("display","none");
				$(".branch_item_" + document.userBranch).css("display","block");
				$(".branch_item_" + document.userBranch + " .overlay").eq(0).css('display', 'none');
				$('.branch_item_' + document.userBranch + ' .select_bottom:eq(0) img').attr('src', 'images/custom_int/topic_launch.png');			
				$('.branch_item_' + document.userBranch + ' .select_bottom:eq(0) img').attr('title', localiseString('topic_start'));
				$('.branch_item_' + document.userBranch + ' .select_bottom:eq(0) img').attr('alt', localiseString('topic_start'));
			}
		}
	}	
})

/* keyboard functionality */
$('#home_nav').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {
		
		$(this).trigger('click');
	}		
});

$('.home').click(function(){
	
	/* custom branching based on CITI071: Module 6: common topic, a branching topic with branching screentype, two branches, no assessement 2023 */
	/* ensure that Home button in header does not work when no branch has been selected in a session */
	if(document.hasBranches){
		if(document.userBranch == 0){
			return false;
		}
	}
	
	//console.log($(".burger_index").is(":visible"))
	
	if($(".burger_index").is(":visible")){
		/* test out: if there is a pre-test in the course */
        
		 
		
        removerBurgerTabIndex();
		
		$(".burger_index").fadeOut();
        
		if($(".topic_index").is(":visible")){
			index = true;
		}else{
			setNavTab(); /* 20180501 Accessibility Added tab functionality to Navigation Bar */
			index = false;
		}
		
		if(isWeb){
			//$("html, body").enableScroll(); /* enable scroll bar */
			$('html, body').css('overflow-y','visible');
		}else{
			$('html, body').css('overflow-y','visible');
		}	
		
		
		
	}else{ //LJ 20181212
        
		if($(".topic_index").is(":visible")){
			/* custom branching based on CITI071: Module 6: common topic, a branching topic with branching screentype, two branches, no assessement 2023 */
			/* update the burger menu to highlight the current topic when the Home button in the header is selected and the home page is visible */
			$(".burger_select_title").css("font-weight","normal");
			var secNum = "";
			$(".breaker").each(function(index) {
				secNum = Number($(this).attr("id").split("_")[1]);
				if (document.currentSection >= secNum)
				{
					document.currentTopic = index+1;
				}
			});
			if (document.currentTopic != 0)
			{
				$(".burger_select_title").eq(document.currentTopic-1).css("font-weight","bold");
			}	
		}else{
			/* custom branching based on CITI071: Module 6: common topic, a branching topic with branching screentype, two branches, no assessement 2023 */
			/* update the burger menu to highlight the current topic when the Home button in the header is selected and the home page is not visible */
			$(".burger_select_title").css("font-weight","normal");
			var secNum = "";
			$(".breaker").each(function(index) {
				secNum = Number($(this).attr("id").split("_")[1]);
				if (document.currentSection >= secNum)
				{
					document.currentTopic = index+1;
				}
			});
			if (document.currentTopic != 0)
			{
				$(".burger_select_title").eq(document.currentTopic-1).css("font-weight","bold");
			}	
		}
		//if(isWeb){
           //positionBurgerMenu(); /* v4 RESKIN */
        //}
		
		if(isWeb){
			//$("html, body").disableScroll(); /* disable scroll bar */
			$('html, body').css('overflow-y','hidden');
		}else{
			$('html, body').css('overflow-y','hidden');
		}
        
        //$(".burger_index").addClass('displayBlock'); // LJ 20112018
        
        topic_height();
		if (document.pretestPresent == 1)
		{
			/* test out: if currently taking the pre-test update the Menu icons and reset for the post-test */
			if (document.takingPretest) {			
				exitPretest();
			}
		}		
		if(isWeb && !isMacChrome && !isChrome){ // potential fix for android freezing 

			/*$(".burger_index").removeClass("index_book")
			$(".burger_index_overlay").css({"display":"block"})
			$(".burger_index").css({"top":"68px"})
			setTimeout(function(){ 
			$(".burger_index_overlay").css({"display":"none"})		
			$(window).css('overflow','visible');
			$(window.top).css('overflow','visible');
			$(parent.parent.document).css('overflow','visible');
			$("html, body" ).css('overflow','visible');
			$('#topic_nav_bar_menu').show();			
			}, 10);
			$('.burger_index').removeClass('loading');
			$('.burger_index').addClass('loading_timer');
			$(window).css('overflow','visible');
			$(window.top).css('overflow','visible');
			$(parent.parent.document).css('overflow','visible');
			$("html, body" ).css('overflow','visible');*/
		}
		if(isiPad || isiPhone || isAndroidTablet || isAndroidPhone || isMacChrome || isChrome){ // to make menu button work on phone 
            
            //$('.burger_index').css('display', 'block');
            
            //$(".burger_index").css('top',($(parent.parent.document).scrollTop())+64+'px');
            
			
			
		}
		
		$('.burger_index').fadeIn();
		/* 20221021 ensure burger menu window is focused on and cannot be tabbed out of */
		$('.burger_index').find('.burger_scroll').focus();
		
		var wh = window.innerHeight;
		
		/* v4 RESKIN */
		var burgerHeight = wh - 70; /* 20230601 Burger menu fix */
		
		var scrollAreaHeight = burgerHeight - 70; /* 20230601 Burger menu fix */
		
		$(".burger_bg").css("height", burgerHeight + "px");
		$(".burger_scroll").css("height", scrollAreaHeight + "px");
		
		removeTabIndex();
        setBurgerTabIndex();
		index = true
		pauseAllVideos(); // Pause all videos
    }	
	
	markTopicQsViewed();
})

/* pre-test no topics associated with questions support kgs 03/18/22 */
function homeAssess()
{
	$("#home_nav").trigger("click");
}	

function hideBurgerMenu(){
	
	if($(".burger_index").is(":visible")){
		
		$(".burger_index").removeClass('displayBlock');
        $('.burger_index').css('display', 'none');
        removerBurgerTabIndex();
		$(".burger_index").css("display","none")
        
		
		if($(".topic_index").is(":visible")){
			index = true;
			
		}else{
        	index = false;
			setNavTab();
		}
		if(isWeb){
			$('html, body').css('overflow-y','visible');
		}else{
			$('html, body').css('overflow-y','visible');
		}	
	}
}

/* 20230601 Burger Menu fix */
function resizeBurgerMenu(){
	var wh = window.innerHeight;
	var burgerHeight = wh - 70; 
	
	var scrollAreaHeight = burgerHeight - 70
	
	$(".burger_bg").css("height", burgerHeight + "px");
	$(".burger_scroll").css("height", scrollAreaHeight + "px");
}

/* keyboard functionality */
$('.home').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {
		
		$(this).trigger('click');
	}		
});


$('.burger_close').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {
		
		$(this).trigger('click');
	}		
});

$(".burger_close").click(function(e){
	
	$('.burger_index').css('display','none');
    $('.burger_index').removeClass('displayBlock')
    
    
    removerBurgerTabIndex();
   if($(".topic_index").is(":visible")){
	   index = true;
	   setMenuTabIndex(); // 20221018 QA fix for tabbing to buttons when resource/hotword popup visible
   }else{
		setNavTab();
	   index = false;
   }
	if(isWeb){
		//$("html, body").enableScroll(); 
		$('html, body').css('overflow-y','visible');
	}else{
		$('html, body').css('overflow-y','visible');
	}
	
	$('.home').focus(); /* 20221101 return focus to home button when burger menu closed */
	
})


	
function topic_closer(newtime){
	// 20190607 Fix for menu overlaying content when resizing window after using burger menu
	if(burgerSel){
		$(".topic_index").css('top', '0px')
	}else{
		
	}
	var vtop = $('.topic_index').offset().top - $(window).scrollTop();
	var st = $(window).scrollTop();
	var dh = $(document).height();
	var wh = $(window).height();
	var tempDiff = dh - wh;
	if (tempDiff <= 0) { dh = wh + 1; }
	var scrollPercent = (st) / (dh - wh);
	var newtime = Math.round((1000 * scrollPercent) + 1000)
	if(index===true){
		
		
		$("#topic_loader").show()
		$(".sec_rest_wrapper").removeClass('displayBlock')
		$(".sec_rest_wrapper").css('display', 'none')
		$('.topic_index').removeClass('displayBlock')
		$(".topic_index").css('display', 'none')
		setTimeout(function(){
				$('.topic_index').hide()
			},2000)
			setTimeout(function(){
				$( "html, body" ).scrollTop( 0 )
				$(".bar_robot").removeClass('displayNone').addClass('displayBlock');
			},2250)
			setTimeout(function(){
				$(".sec_rest_wrapper").css('display', 'block')
				portraitTestFix();

				$("#topic_loader").hide()
				$(window).trigger('scroll');
				
				//console.log("section " + document.currentSection)
				
				//loop();
				
				resizeCheckBox()
			},2500)
		
	}
	index = false;
	
	
}

$('.switchLang').click(function(){

	parent.returnToLang();
})

/* 20221104 ensure that language switcher button works on keypress of spacebar or enter */
$('.switchLang').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {

		parent.returnToLang();
	}		
});	

$('.bar_close').click(function(){
	window.top.close()
	
})

$('.bar_close').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {

		window.top.close()
	}		
});	

/* progress bar */
function progress(n){
	//console.log("n = " + n)
	var lesson_status = int_tracking.int_lesson_status;
	/* If error tracking is enabled use their function calls else use standard sco.js */
	var score = actionsLMSGetScore();
	score = score == "" ? 0 : Number(score);
		
	for(i=0; i<=$('.breaker').length; i++){
		var currentbreaker = document.trackingArr[$('.breaker').eq(i).index('.section')]
		var nextbreaker = (($('.breaker').eq(i)).nextAll('.breaker').prev('.section')).index('.section')
		if(nextbreaker == -1){
			nextbreaker = document.subsectionCount-1
		}
		var lastsection = document.trackingArr[nextbreaker]
		if(lastsection ==1){			
			if ((i == ($('.breaker').length - 1)) && ((lesson_status != lms_pass_status1) && (lesson_status != lms_pass_status2))) {			
				                
                $('.burger_select .burger_progress').eq(i).addClass('burger_progress_started')
				$('.burger_select .burger_progress').eq(i).attr('title',localiseString('topic_incomplete'));
				$('.burger_select .burger_progress').eq(i).attr('alt',localiseString('topic_incomplete'));
			}
			else {
								
				$('#menuIns_1').css('display','none');
				$('#menuIns_2').css('display','block');
                
                $('.burger_select .burger_progress').eq(i).removeClass('burger_progress_started').addClass('burger_progress_complete')
				$('.burger_select .burger_progress').eq(i).attr('title',localiseString('topic_complete'));
				$('.burger_select .burger_progress').eq(i).attr('alt',localiseString('topic_complete'));
			}	
		}
		else if(currentbreaker ==1){
				            
                $('.burger_select .burger_progress').eq(i).addClass('burger_progress_started')
				$('.burger_select .burger_progress').eq(i).attr('title',localiseString('topic_incomplete'));
				$('.burger_select .burger_progress').eq(i).attr('alt',localiseString('topic_incomplete'));
		}
	}
	if ((score >= document.assessPassmark) && (document.trackingArr[document.trackingArr.length-1] == '1'))
	{
		$('.topic_select .progress').eq($('.breaker').length - 1).removeClass('progress_started').addClass('progress_complete');
		$('.topic_select .top_wrapper').eq($('.breaker').length - 1).removeClass('unlocked').addClass('complete');
		$('.topic_select .progress').eq($('.breaker').length - 1).attr('title',localiseString('topic_complete'));
		$('.topic_select .progress').eq($('.breaker').length - 1).attr('alt',localiseString('topic_complete'));

		$('.topic_select .top_wrapper').eq($('.breaker').length - 1).addClass('complete');
        
        $('.burger_select .burger_progress').eq($('.breaker').length - 1).removeClass('burger_progress_started').addClass('burger_progress_complete')
		$('.burger_select .burger_progress').eq($('.breaker').length - 1).attr('title',localiseString('topic_complete'));
		$('.burger_select .burger_progress').eq($('.breaker').length - 1).attr('alt',localiseString('topic_complete'));
	}

	updateMenu(n);
	
	updateBackground(document.currentTopic);
	
	updateProgressBar(n); /* Progress Indicator 2023 */
	
	/* custom branching based on CITI071: Module 6: common topic, a branching topic with branching screentype, two branches, no assessement 2023 */
	/* update the burger menu to unlock branch topics if a branch has been selected in a session */
	if(document.hasBranches){		
		if(document.userBranch != 0){
		
			var menuArr = document.sectionCompleted.split('');
			
			for(var i = 0; i != menuArr.length; i++){
			 
				if(menuArr[i] == 2){
					var n = Number(i+1)
					
					$(".burger_select .branch_item .branch_item" + document.userBranch + " .overlay").eq(n).css('display', 'none');
					
					if(i == 0){
						$(".burger_select.branch_item_" + document.userBranch + ":eq(0) .overlay").css('display', 'none');

						$('.burger_select.branch_item_' + document.userBranch + ':eq(0) img').attr('src', 'images/custom_int/burger_unlocked.png');
						$('.burger_select.branch_item_' + document.userBranch + ':eq(0) img').attr('title', localiseString('topic_start'));
						$('.burger_select.branch_item_' + document.userBranch + ':eq(0) img').attr('alt', localiseString('topic_start'));
					}
					
				}
			}
		}
	}
}

/* updateBackground function called to update the baground image for each individual topic */
function updateBackground(n){
	
	$(".sec_rest_wrapper").css("background-image","url('images/citi_bg_"+n+".jpg')");
}


/*

	updateMenu function to unlock and mark home page items completed
	using document.sectionCompleted now course uses sections and topics

*/
function updateMenu(n){
	
	
	if(n != undefined){
		var nextNum = (Number(n)+1);
		var nextScreen = $("#sec_"+nextNum);

		var currentScreen = $("#sec_"+(n));
		//console.log("document.sectionCompleted  "+ document.sectionCompleted)
		
		if($(currentScreen).hasClass("preTopicTest")){
			
			var secArr = document.sectionCompleted.split('');
			
			secArr[$(nextScreen).index(".preTopicTest")] = 1;
			
			document.sectionCompleted = secArr.join('')
		}	
		
		if($(currentScreen).hasClass("secStart")){
			
			var secArr = document.sectionCompleted.split('');
			/* custom branching based on CITI071: Module 6: common topic, a branching topic with branching screentype, two branches, no assessement 2023 */
			/* mark this section as started */
			secArr[$(nextScreen).index(".secStart")] = 1;
			document.sectionCompleted = secArr.join('')
		}
		
		
		if(document.summarySection != null){
			
			if(n == document.subsectionCount){
				var secArr = document.sectionCompleted.split('');
				secArr[secArr.length-1] = 2;
				document.sectionCompleted = secArr.join('')
			}
			
			if(nextNum == document.summarySection){
				var secArr = document.sectionCompleted.split('');
				secArr[secArr.length-2] = 2;
				document.sectionCompleted = secArr.join('')
			}
		}

		//console.log($(nextScreen).attr("id"));
		//console.log($(nextScreen).attr("class"));
		if($(nextScreen).hasClass("preTopicTest")){
			
			var secArr = document.sectionCompleted.split('');
			secArr[$(nextScreen).index(".preTopicTest")] = 2;
			document.sectionCompleted = secArr.join('');
			
		}else if($(nextScreen).hasClass("secStart")){
			
			/* pre-test no topics associated with questions support kgs 03/18/22 */
			if (document.noTopicsAssociatedPretest)
			{
				/* completed test message and test lock-out 2023 */
				if ((document.topicsPretestedOut.indexOf('1') == -1) || ((document.topicsPretestedOut.substring(0,(document.topicsPretestedOut.length-2)).indexOf('1') == -1) && document.showAssessCompleteMsg))
				{
					var secArr = document.sectionCompleted.split('');
					/* custom branching based on CITI071: Module 6: common topic, a branching topic with branching screentype, two branches, no assessement 2023 */
					/* mark this section as completed */
					secArr[$(nextScreen).index(".secStart")] = 2;
					document.sectionCompleted = secArr.join('');
				}
			}
			else
			{
				var secArr = document.sectionCompleted.split('');
				/* custom branching based on CITI071: Module 6: common topic, a branching topic with branching screentype, two branches, no assessement 2023 */
				/* mark this section as completed */
				secArr[$(nextScreen).index(".secStart")] = 2;
				document.sectionCompleted = secArr.join('');
			}
		}else{
			/* pre-test no topics associated with questions support kgs 03/18/22 */
			if (document.noTopicsAssociatedPretest)
			{				
				/* completed test message and test lock-out 2023 */
				if ((document.topicsPretestedOut.indexOf('1') == -1) || ((document.topicsPretestedOut.substring(0,(document.topicsPretestedOut.length-2)).indexOf('1') == -1) && document.showAssessCompleteMsg))
				{			
					if(n == document.subsectionCount){
						if (document.subsectionCount == document.testResultsSubsection)
						{
							/* completed test message and test lock-out 2023 */
							var passScoreObtained = false;
							if (document.pretestThisSession)
							{
								if (document.assessPercentageScore >= document.preTestPassmark)
								{
									passScoreObtained = true;
								}
							}
							else
							{
								if (document.assessPercentageScore >= document.assessPassmark)
								{
									passScoreObtained = true;
								}
							}
							if (passScoreObtained)
							{
								//console.log("n = " + n);
								var secArr = document.sectionCompleted.split('');
								secArr[secArr.length-1] = 2;
								//secArr[secArr.length-2] = 2;
								document.sectionCompleted = secArr.join('')
								//console.log("document.sectionCompleted = " + document.sectionCompleted);
							}	
						}
						else					
						{
							//console.log("n = " + n);
							var secArr = document.sectionCompleted.split('');
							secArr[secArr.length-1] = 2;
							//secArr[secArr.length-2] = 2;
							document.sectionCompleted = secArr.join('')
							//console.log("document.sectionCompleted = " + document.sectionCompleted);	
						}
					}
				}	
			}
			else
			{
				/* 20221102 ensure the final topic on the home page menu is not marked complete until the course is completed or passed */
				if(n == document.subsectionCount)
				{
					var lesson_status = int_tracking.int_lesson_status;
					if ((lesson_status == lms_pass_status1) || (lesson_status == lms_pass_status2)) {				
					//console.log("n = " + n);
					var secArr = document.sectionCompleted.split('');
					secArr[secArr.length-1] = 2;
					//secArr[secArr.length-2] = 2;
					document.sectionCompleted = secArr.join('')
					//console.log("document.sectionCompleted = " + document.sectionCompleted);
					}
				}
			}
		}

		/* custom branching based on CITI071: Module 6: common topic, a branching topic with branching screentype, two branches, no assessement 2023 */
		/* mark the the section as completed on the last page in a branch */
		if(document.hasBranches){
			if(document.userBranch != 0){
				if($(currentScreen).hasClass("endBranch")){

					var sec = $(currentScreen).prevAll(".breaker").eq(0).index(".secStart")

					var secArr = document.sectionCompleted.split('');

					secArr[sec - 1] = 2;

					document.sectionCompleted = secArr.join('')
				}
			}
		}

		//console.log("updateMenu document.sectionCompleted " + document.sectionCompleted)
	}
	
	
	var menuArr = document.sectionCompleted.split('');
	
	
	for(var i = 0; i != menuArr.length; i++){
		 
		if(menuArr[i] == 2){
			
			var imgStr = $('.topic_select .heading_area img').eq(i).attr('src')
			if(imgStr != undefined){
				if(imgStr.indexOf('complete') == -1){
					var ext = imgStr.split('.')[1];
					var img = imgStr.split('.')[0];
					//$('.topic_select .heading_area img').eq(i).attr('src',img + '_complete.' + ext);
				}
			}
			
			$('.topic_select .progress').eq(i).removeClass('progress_started').addClass('progress_complete');
			$('.topic_select .top_wrapper').eq(i).removeClass('unlocked').addClass('complete');
			$('.topic_select .progress').eq(i).attr('title',localiseString('topic_complete'));
			$('.topic_select .progress').eq(i).attr('alt',localiseString('topic_complete'));

			/* custom branching based on CITI071: Module 6: common topic, a branching topic with branching screentype, two branches, no assessement 2023 */
			/* update the burger menu to unlock branch topics if a branch has been selected in a session */
			if(document.hasBranches){
				if(document.userBranch != 0){
					if(i == 0){
						$(".burger_select.branch_item_" + document.userBranch + ":eq(0) .overlay").css('display', 'none');
					
						$('.burger_select.branch_item_' + document.userBranch + ':eq(0) img').attr('src', 'images/custom_int/burger_unlocked.png');
						$('.burger_select.branch_item_' + document.userBranch + ':eq(0) img').attr('title', localiseString('topic_start'));
						$('.burger_select.branch_item_' + document.userBranch + ':eq(0) img').attr('alt', localiseString('topic_start'));
					}
				}
			}

			$('.topic_select .replay').eq(i).css('visibility','visible');
			$('.topic_select .start_img').eq(i).css('visibility','hidden');
			
		}
	}
	
	
}



/* grey out topics */
if(document.menuLockedDown == true || lock_butt === true ){
	$('.topic_select:not(.topic_select:eq(0)) .overlay').css('display', 'block');
	$('.select_bottom:not(.select_bottom:eq(0)) img').attr('src', 'images/general_int/topic_locked.png');
    
    $('.burger_select:not(.topic_select:eq(0)) .overlay').css('display', 'block');
	$('.burger_select:not(.select_bottom:eq(0)) img').attr('src', 'images/custom_int/burger_locked.png');
}

var lock_butt;
function lockTopics(nextBtnClicked){
	document.topic_complete=[]
	var top_sel = currentSec
	var breaker = ($('.breaker').eq(top_sel).index('.section')-1)
	for(i=breaker; i<($('div.breaker:eq('+currentSec+')').nextUntil($('div.breaker').eq(currentSec+1)).length+1); i++){
		if(document.lockedArr[i]===1){
			lock_butt = true
		}else{
			lock_butt = false
		}
	}
	if(document.audioLocked === true || lock_butt === true){
		if (nextBtnClicked) {
			$('#right_nav').addClass('locked');
		}
	}
}
lockTopics(true)

function unlockTopic(n){
	console.log("unlockTopic n = " + n)
	if(typeof n !== 'undefined'){
		var lesson_status = int_tracking.int_lesson_status;
		/* If error tracking is enabled use their function calls else use standard sco.js */
		var score = actionsLMSGetScore();		
		score = score == "" ? 0 : Number(score);
		var topicOK = true;
		/* test out: if there is a pre-test in the course */
		if (document.pretestPresent == 1)
		{
			/* test out: obtain the status of what topics have been tested out of */
			var tempTPretestOutArr = document.topicsPretestedOut.split('');
			if (tempTPretestOutArr[currentSec] == 1)
			{
				//topicOK = false;
			}
		}	
		if((document.trackingArr[($('div.breaker:eq('+(currentSec+1)+')').prev('.section').index('.section'))]==1) && topicOK)
		{			
			/* test out: if there is a pre-test and the menu is not locked do not unlock the summary until all previous topics completed or tested out */
			if ((document.pretestPresent == 1) && (document.menuLockedDown == false) && ((currentSec+1) == (document.topicsCount - 1)))
			{
				// do nothing
			}
			else {
				                
                $('.burger_select .overlay').eq(currentSec+1).css('display', 'none')
				$('.burger_select:eq('+(currentSec+1)+') img').attr('src', 'images/custom_int/burger_unlocked.png')
				$('.burger_select:eq('+(currentSec+1)+') img').attr('title', localiseString('topic_start'));
				$('.burger_select:eq('+(currentSec+1)+') img').attr('alt', localiseString('topic_start'));
                
				if(currentSec < ($('.breaker').length-1)){
					if ((document.pretestPresent == 0) || ((document.pretestPresent == 1) && (document.pretestAttempted == 1) && (document.topicsPretestedOut.indexOf("1") == -1)))
					{	
						//console.log("unlock1")
						$('#right_nav').show();
						$('#right_nav').removeClass('locked');
						$('#right_nav').attr('title', localiseString('right_nav'));
						$('#right_nav').attr('alt', localiseString('right_nav'));
						
						if(document.hasBranches){
							if($('#sec_'+ n).hasClass("endBranch")){
								//$('#right_nav').hide();
								$('#right_nav').addClass('locked');
								$('#right_nav').attr('title', localiseString('right_nav_locked'));
								$('#right_nav').attr('alt', localiseString('right_nav_locked'));
								//doBranchCompletion();
							}
							
							if($('#sec_'+ n).hasClass("startBranch")){
								//$('#right_nav').hide();
								$('#left_nav').addClass('locked');
								$('#left_nav').attr('title', localiseString('left_nav_locked'));
								$('#left_nav').attr('alt', localiseString('left_nav_locked'));
							}
						}
						
					}else{
						//console.log("unlock2")
                        $('#right_nav').show();
						$('#right_nav').removeClass('locked');
						$('#right_nav').attr('title', localiseString('right_nav'));
						$('#right_nav').attr('alt', localiseString('right_nav'));
						
						if(document.hasBranches){
							if($('#sec_'+ n).hasClass("endBranch")){
								//$('#right_nav').hide();
								$('#right_nav').addClass('locked');
								$('#right_nav').attr('title', localiseString('right_nav_locked'));
								$('#right_nav').attr('alt', localiseString('right_nav_locked'));
								//doBranchCompletion();
							}
							
							if($('#sec_'+ n).hasClass("startBranch")){
								//$('#right_nav').hide();
								$('#left_nav').addClass('locked');
								$('#left_nav').attr('title', localiseString('left_nav_locked'));
								$('#left_nav').attr('alt', localiseString('left_nav_locked'));
							}
						}
						
                    }
					                    
                    $('.burger_select .burger_progress').eq(currentSec).removeClass('burger_progress_started').addClass('burger_progress_complete')
					$('.burger_select .burger_progress').eq(currentSec).attr('title',localiseString('topic_complete'));
					$('.burger_select .burger_progress').eq(currentSec).attr('alt',localiseString('topic_complete'));
                    
					launchHover();
				}
			}	
			/* test out: if there is a pre-test in the course */
			if (document.pretestPresent == 1)
			{
				/* test out: obtain the status of what topics have been tested out of */
				var tempTPretestOutArr = document.topicsPretestedOut.split('');	
				/* test out: show the launch icon for the next topic that has not been tested out of and unlock this topic */		
				if (tempTPretestOutArr[currentSec + 1] == 1)
				{
					for (var i = (currentSec + 2); i < document.topicsCount; i++)
					{
						if (tempTPretestOutArr[i] == 0)
						{							
							$('.topic_select .overlay').eq(i).css('display', 'none');
							$('.select_bottom:eq('+i+') img').attr('src', 'images/custom_int/topic_launch.png');
							$('.select_bottom:eq('+i+') img').attr('title', localiseString('topic_start'));
							$('.select_bottom:eq('+i+') img').attr('alt', localiseString('topic_start'));

							/* 20230503 New Menu Updates */
							$('.topic_select .top_wrapper').eq(i).addClass('unlocked');
							$('.topic_select .heading_area img').eq(i).attr('src', 'images/menu_topic_'+(i+2)+'.png');
                            
                            $('.burger_select .overlay').eq(i).css('display', 'none');
							$('.burger_select:eq('+i+') img').attr('src', 'images/custom_int/burger_unlocked.png');
							$('.burger_select:eq('+i+') img').attr('title', localiseString('topic_start'));
							$('.burger_select:eq('+i+') img').attr('alt', localiseString('topic_start'));
                            
							break;
						}
					}			
				}
			}
		}
		if ((score >= document.assessPassmark) && (document.trackingArr[document.trackingArr.length-1] == '1'))
		{
			$('.topic_select .progress').eq($('.breaker').length - 1).removeClass('progress_started').addClass('progress_complete');
			$('.topic_select .top_wrapper').eq($('.breaker').length - 1).removeClass('unlocked').addClass('complete');
			$('.topic_select .progress').eq($('.breaker').length - 1).attr('title',localiseString('topic_complete'));
			$('.topic_select .progress').eq($('.breaker').length - 1).attr('alt',localiseString('topic_complete'));

			/* 20230503 New Menu Updates */
			$('.topic_select .top_wrapper').eq($('.breaker').length - 1).addClass('complete');
            
            $('.burger_select .burger_progress').eq($('.breaker').length - 1).removeClass('burger_progress_started').addClass('burger_progress_complete')
			$('.burger_select .burger_progress').eq($('.breaker').length - 1).attr('title',localiseString('topic_complete'));
			$('.burger_select .burger_progress').eq($('.breaker').length - 1).attr('alt',localiseString('topic_complete'));
		}
		
	}
	
	/* custom branching based on CITI071: Module 6: common topic, a branching topic with branching screentype, two branches, no assessement 2023 */
	/* disable the forward arrow and clear instruction when footer navigation is to be hidden for branching */
	/* 
	
		If last page in topic hide navigation buttons
		
	*/
	if(document.hasBranches){
		if($('#sec_'+ n).hasClass("hideNav")){
			$('#right_nav').addClass('locked');
			$('#right_nav').attr('title', localiseString('right_nav_locked'));
			$('#right_nav').attr('alt', localiseString('right_nav_locked'));
			$(".nav_instruction .instruction").html("");
		}
	}
	/* custom branching based on CITI070 */
	/* 
	
		If last page in topic hide navigation buttons
		Call endInterview in braching.js
		
	*/
	/*if(document.hasBranches){
		if($('#sec_'+ n).hasClass("hideNav")){
			
			$('#right_nav').hide();
			$('#left_nav').hide();
			
			endInterview(n);
			
		}
	}*/
}

function launchHover(){
	var srcString = $('.select_bottom img').attr('src').toString()	
	if(srcString.indexOf('topic_launch.png')>0){
		 $('.select_bottom img').hover(function () {
        	$(this).attr('src' ,'images/custom_int/topic_launch_rollover.png')
    	});
		$(".select_bottom img").mouseout(function(){
    		$(this).attr('src' ,'images/custom_int/topic_launch.png');
		});
	}
	/* test out: if there is a pre-test in the course */
	if (document.pretestPresent == 1)
	{
		/* test out: obtain the status of what topics have been tested out of */
		var tempTPretestOutArr = document.topicsPretestedOut.split('');
	}	
	var compTopics = 0;
	for (var i = 0; i < document.topicsCount; i++)
	{	
		/* test out: if there is a pre-test in the course */
		if (document.pretestPresent == 1)
		{	
			/* test out: show the tested out icon for any topics that have been tested out of and unlock these topics */
			if (tempTPretestOutArr[i] == 1)
			{				
				$('.select_bottom:eq('+i+') img').attr('src', 'images/general_int/topic_testout_launch.png');			
				$('.select_bottom:eq('+i+') img').attr('title', localiseString('topic_start'));
				$('.select_bottom:eq('+i+') img').attr('alt', localiseString('topic_start'));
				$('.select_bottom:eq('+i+') img').hover(function () {
					$(this).attr('src' ,'images/general_int/topic_testout_launch_rollover.png')
				});
				$('.select_bottom:eq('+i+') img').mouseout(function(){
					$(this).attr('src' ,'images/general_int/topic_testout_launch.png');
				});
				$('.topic_select .overlay').eq(i).css('display', 'none');
                
				/* 20230503 New Menu Updates */
                $('.topic_select .top_wrapper').eq(i).addClass('unlocked');
				$('.topic_select .heading_area img').eq(i).attr('src', 'images/menu_topic_'+(i+2)+'.png');
                
                $('.burger_select:eq('+i+') img').attr('src', 'images/general_int/topic_testout_launch.png');			
				$('.burger_select:eq('+i+') img').attr('title', localiseString('topic_start'));
				$('.burger_select:eq('+i+') img').attr('alt', localiseString('topic_start'));
				$('.burger_select:eq('+i+') img').hover(function () {
					$(this).attr('src' ,'images/general_int/topic_testout_launch.png')
				});
				$('.burger_select:eq('+i+') img').mouseout(function(){
					$(this).attr('src' ,'images/general_int/topic_testout_launch.png');
				});
				$('.burger_select .overlay').eq(i).css('display', 'none');
                
				compTopics++;
			}
			else {
				if(document.trackingArr[($('div.breaker:eq('+i+')').prev('.section').index('.section'))]==1){					
					if (tempTPretestOutArr[i - 1] == 0)
					{
						compTopics++;
					}	
				}
				if (compTopics == i) {				
					$('.select_bottom:eq('+i+') img').attr('src', 'images/custom_int/topic_launch.png');			
					$('.select_bottom:eq('+i+') img').attr('title', localiseString('topic_start'));
					$('.select_bottom:eq('+i+') img').attr('alt', localiseString('topic_start'));
					$('.select_bottom:eq('+i+') img').hover(function () {
						$(this).attr('src' ,'images/custom_int/topic_launch_rollover.png')
					});
					$('.select_bottom:eq('+i+') img').mouseout(function(){
						$(this).attr('src' ,'images/custom_int/topic_launch.png');
					});
					$('.topic_select .overlay').eq(i).css('display', 'none');

					/* 20230503 New Menu Updates */
					$('.topic_select .top_wrapper').eq(i).addClass('unlocked');
					$('.topic_select .heading_area img').eq(i).attr('src', 'images/menu_topic_'+(i+2)+'.png');
                    
                    $('.burger_select:eq('+i+') img').attr('src', 'images/custom_int/burger_unlocked.png');			
					$('.burger_select:eq('+i+') img').attr('title', localiseString('topic_start'));
					$('.burger_select:eq('+i+') img').attr('alt', localiseString('topic_start'));
					$('.burger_select:eq('+i+') img').hover(function () {
						$(this).attr('src' ,'images/custom_int/burger_unlocked.png')
					});
					$('.burger_select:eq('+i+') img').mouseout(function(){
						$(this).attr('src' ,'images/custom_int/burger_unlocked.png');
					});
					$('.burger_select .overlay').eq(i).css('display', 'none');
				}
				if(document.trackingArr[($('div.breaker:eq('+(i+1)+')').prev('.section').index('.section'))]==1){				
					/* test out: show the launch icon for the next topic that has not been tested out of and unlock this topic */
					for (var j = (i + 1); j < document.topicsCount; j++)
					{
						if (tempTPretestOutArr[j] == 0)
						{							
							$('.topic_select .overlay').eq(j).css('display', 'none');
							$('.select_bottom:eq('+j+') img').attr('src', 'images/custom_int/topic_launch.png');
							$('.select_bottom:eq('+j+') img').attr('title', localiseString('topic_start'));
							$('.select_bottom:eq('+j+') img').attr('alt', localiseString('topic_start'));

							$('.topic_select .top_wrapper').eq(j).addClass('unlocked');
							$('.topic_select .heading_area img').eq(j).attr('src', 'images/menu_topic_'+(i+1)+'.png');
                            
                            $('.burger_select .overlay').eq(j).css('display', 'none');
							$('.burger_select:eq('+j+') img').attr('src', 'images/custom_int/burger_unlocked.png');
							$('.burger_select:eq('+j+') img').attr('title', localiseString('topic_start'));
							$('.burger_select:eq('+j+') img').attr('alt', localiseString('topic_start'));
                            
							break;
						}
					}
				}
			}
		}
		else {
			if(document.trackingArr[($('div.breaker:eq('+i+')').prev('.section').index('.section'))]==1){					
				compTopics++;
			}
			if (compTopics == i) {
				                
                $('.burger_select:eq('+i+') img').attr('src', 'images/custom_int/burger_unlocked.png');			
				$('.burger_select:eq('+i+') img').attr('title', localiseString('topic_start'));
				$('.burger_select:eq('+i+') img').attr('alt', localiseString('topic_start'));
				$('.burger_select:eq('+i+') img').hover(function () {
					$(this).attr('src' ,'images/custom_int/burger_unlocked.png')
				});
				$('.burger_select:eq('+i+') img').mouseout(function(){
					$(this).attr('src' ,'images/custom_int/burger_unlocked.png');
				});
				$('.burger_select .overlay').eq(i).css('display', 'none');
			}
		}	
	}
	
	var menuArr = document.sectionCompleted.split('');
	
	
	for(var i = 0; i != menuArr.length; i++){
		 
		if(menuArr[i] == 2){
			
			/* pre-test no topics associated with questions support kgs 03/18/22 */
			if (document.noTopicsAssociatedPretest)
			{
				if(document.topicsPretestedOut[i+1] != 1)
				{
					$('.select_bottom:eq('+(i+1)+') img').attr('src', 'images/custom_int/topic_launch.png');			
					$('.select_bottom:eq('+(i+1)+') img').attr('title', localiseString('topic_start'));
					$('.select_bottom:eq('+(i+1)+') img').attr('alt', localiseString('topic_start'));
					$('.select_bottom:eq('+(i+1)+') img').hover(function () {
						$(this).attr('src' ,'images/custom_int/topic_launch_rollover.png')
					});
					$('.select_bottom:eq('+(i+1)+') img').mouseout(function(){
						$(this).attr('src' ,'images/custom_int/topic_launch.png');
					});
					$('.topic_select .overlay').eq((i+1)).css('display', 'none');

					$('.topic_select .top_wrapper').eq((i+1)).addClass('unlocked');
					$('.topic_select .heading_area img').eq((i+1)).attr('src', 'images/menu_topic_'+(i+1)+'.png');s
				}
			}
			else
			{
				$('.select_bottom:eq('+(i+1)+') img').attr('src', 'images/custom_int/topic_launch.png');			
				$('.select_bottom:eq('+(i+1)+') img').attr('title', localiseString('topic_start'));
				$('.select_bottom:eq('+(i+1)+') img').attr('alt', localiseString('topic_start'));
				$('.select_bottom:eq('+(i+1)+') img').hover(function () {
					$(this).attr('src' ,'images/custom_int/topic_launch_rollover.png')
				});
				$('.select_bottom:eq('+(i+1)+') img').mouseout(function(){
					$(this).attr('src' ,'images/custom_int/topic_launch.png');
				});
				$('.topic_select .overlay').eq((i+1)).css('display', 'none');

				/* 20230503 New Menu Updates */
				$('.topic_select .top_wrapper').eq((i+1)).addClass('unlocked');
				$('.topic_select .heading_area img').eq((i+1)).attr('src', 'images/menu_topic_'+(i+2)+'.png');
			}	
		}else if(menuArr[i] == 1){
			
			$('.topic_select .overlay').eq((i+1)).css('display', 'block');
			$('.select_bottom:eq('+i+') img').attr('src', 'images/general_int/topic_locked.png');
		}
	}
	
	/* 20230503 Fix do that tested out topics show the complete testout complete icon */
	if (document.pretestPresent == 1)
	{
		/* test out: obtain the status of what topics have been tested out of */
		var tempTPretestOut2Arr = document.topicsPretestedOut.split('');
	}	
	for (var i = 0; i < document.topicsCount; i++)
	{	
		/* test out: if there is a pre-test in the course */
		if (document.pretestPresent == 1)
		{	
			/* test out: show the tested out icon for any topics that have been tested out of and unlock these topics */
			if (tempTPretestOut2Arr[i] == 1)
			{				
				$('.select_bottom:eq('+i+') img').attr('src', 'images/general_int/topic_testout_launch.png');			
				$('.select_bottom:eq('+i+') img').attr('title', localiseString('topic_start'));
				$('.select_bottom:eq('+i+') img').attr('alt', localiseString('topic_start'));
				$('.select_bottom:eq('+i+') img').hover(function () {
					$(this).attr('src' ,'images/general_int/topic_testout_launch_rollover.png')
				});
				$('.select_bottom:eq('+i+') img').mouseout(function(){
					$(this).attr('src' ,'images/general_int/topic_testout_launch.png');
				});
				$('.topic_select .overlay').eq(i).css('display', 'none');
                
                
                
                $('.burger_select:eq('+i+') img').attr('src', 'images/general_int/topic_testout_launch.png');			
				$('.burger_select:eq('+i+') img').attr('title', localiseString('topic_start'));
				$('.burger_select:eq('+i+') img').attr('alt', localiseString('topic_start'));
				$('.burger_select:eq('+i+') img').hover(function () {
					$(this).attr('src' ,'images/general_int/topic_testout_launch.png')
				});
				$('.burger_select:eq('+i+') img').mouseout(function(){
					$(this).attr('src' ,'images/general_int/topic_testout_launch.png');
				});
				$('.burger_select .overlay').eq(i).css('display', 'none');
                
			}
		}
	}	
}

function lockNav()
{
	var lastsection = document.trackingArr[(($('.breaker').eq(currentSec)).nextAll('.breaker').prev('.section')).index('.section')]
	if(currentSec >=1)
	{
		/* test out: if there is no pre-test in the course or there is a pre-test and it has been attempted but no topics have been tested out of enable the left nav button */
		if ((document.pretestPresent == 0) || ((document.pretestPresent == 1) && (document.pretestAttempted == 1) && (document.topicsPretestedOut.indexOf("1") == -1)))
		{			
            //alert('left1')
			$('#left_nav').removeClass('locked');
			$('#left_nav').attr('title', localiseString('left_nav'));
			$('#left_nav').attr('alt', localiseString('left_nav'));
			$('#home_nav').removeClass("pretest");
			
			
		}else{
           // alert('left2')
            $('#left_nav').removeClass('locked');
			$('#left_nav').attr('title', localiseString('left_nav'));
			$('#left_nav').attr('alt', localiseString('left_nav'));
			$('#home_nav').removeClass("pretest");
			
        }
	}else{
		/* test out: if there is a pre-test and it has been attempted and at least one topic has been tested out of hide the left nav button */
		if ((document.pretestPresent == 1) && (document.pretestAttempted == 1) && (document.topicsPretestedOut.indexOf("1") != -1))
		{
			//$('#left_nav').hide();
			//$('#home_nav').addClass("pretest");
            //alert('left3')
            $('#left_nav').show();
			$('#left_nav').addClass('locked');
			$('#left_nav').attr('title', localiseString('left_nav_locked'));
			$('#left_nav').attr('alt', localiseString('left_nav_locked'));
			$('#home_nav').removeClass("pretest");
		}
		else {
           // alert('left4')
			$('#left_nav').show();
			$('#left_nav').addClass('locked');
			$('#left_nav').attr('title', localiseString('left_nav_locked'));
			$('#left_nav').attr('alt', localiseString('left_nav_locked'));
			$('#home_nav').removeClass("pretest");
		}	
	}
	if(currentSec == $('.breaker').length -1){
        //alert('right1')
		$('#right_nav').show();
		$('#right_nav').addClass('locked');
		$('#right_nav').attr('title', localiseString('right_nav_locked'));
		$('#right_nav').attr('alt', localiseString('right_nav_locked'));
		$('#home_nav').removeClass("pretest");		
	}
	if(currentSec !== $('.breaker').length -1 && lastsection == 1){
		/* test out: if there is no pre-test in the course or there is a pre-test and it has been attempted but no topics have been tested out of enable the right nav button */
		if ((document.pretestPresent == 0) || ((document.pretestPresent == 1) && (document.pretestAttempted == 1) && (document.topicsPretestedOut.indexOf("1") == -1)))
		{
            //alert('right2')
			$('#right_nav').show();
			$('#right_nav').removeClass('locked');
			$('#right_nav').attr('title', localiseString('right_nav_locked'));
			$('#right_nav').attr('alt', localiseString('right_nav_locked'));
			$('#home_nav').removeClass("pretest");			
		}else{
            //alert('right3')
            $('#right_nav').show();
			$('#right_nav').removeClass('locked');
			$('#right_nav').attr('title', localiseString('right_nav_locked'));
			$('#right_nav').attr('alt', localiseString('right_nav_locked'));
			$('#home_nav').removeClass("pretest");	
        }
	}else{
		/* test out: if there is a pre-test and it has been attempted and at least one topic has been tested out of hide the right nav button */
		if ((document.pretestPresent == 1) && (document.pretestAttempted == 1) && (document.topicsPretestedOut.indexOf("1") != -1))
		{
			//$('#right_nav').hide();
			//$('#home_nav').addClass("pretest");
           // alert('right4')
            $('#right_nav').show();
			//$('#right_nav').addClass('locked');
			$('#right_nav').attr('title', localiseString('right_nav_locked'));
			$('#right_nav').attr('alt', localiseString('right_nav_locked'));
			$('#home_nav').removeClass("pretest");	
		}
		else {
            //alert('right5')
			$('#right_nav').show();
			//$('#right_nav').addClass('locked');
			$('#right_nav').attr('title', localiseString('right_nav_locked'));
			$('#right_nav').attr('alt', localiseString('right_nav_locked'));
			$('#home_nav').removeClass("pretest");	
		}	
	}
	
	if(document.hasBranches){
		console.log("currentSec = " + currentSec)
	}
	
	if(document.hasBranches){
		
		var tempArr = []
		$(".topic_select").each(function(index,element){
			if($(this).css("display") === "block"){
				tempArr.push(index);
			}
		})
		
		if(tempArr[0] == currentSec){
			$('#left_nav').addClass('locked');
			$('#left_nav').attr('title', localiseString('left_nav_locked'));
			$('#left_nav').attr('alt', localiseString('left_nav_locked'));
		}
	}

	/* 20230427 hide nav when pre-test has been taken */
	if ((document.pretestPresent == 1) && (document.pretestAttempted == 1) && (document.topicsPretestedOut.indexOf("1") != -1)){
			$('#right_nav').hide();
			$('#left_nav').hide();
			$('#home_nav').addClass("pretest");
			$('.nav_instruction .instruction').html(test_intro_dat['pre_test_nav'][0].home_only);
	}
}

/* load video */
function loadVideo(video_src){
	/*$('#mp4').attr('src',  document.intro_back[currentSec].mp4);
	$(".bg_video video")[0].load()
	$(".bg_video video")[0].play()*/
}

/* set topic title */
function topicTitle(){
	$("#topic_intro .grid_inner h1, .menu_title h1").html(document.courseTitle)
	
	$('.home, .bar_close, .page, .menu_title').hide()
}

/* functionality to truncate the title */
$(window).resize(function() {
	$('.menu_title_txt').addClass('truncated_title');  
    
    if(isWeb){
        //positionBurgerMenu();
    }
	//hideBurgerMenu(); /* 20230601 Fix to stop hiding burger menu on rotation of device */
	resizeBurgerMenu(); /* 20230601 Burger menu fix */
	getSliderHeight();
});
 
function addTopicData(){
	for(i=0; i<$('.section').length; i++){
		$('.section').eq(i).data('locked', document.lockedArr[i])
		$('.section').eq(i).data('locked')
	}
}
addTopicData()
	 
function addSuspendData(){
	for(i=0; i<$('.section').length; i++){
		$('.section').eq(i).data('suspend', document.trackingArr[i])
		$('.section').eq(i).data('suspend')
	}
}

function startedTopic(topic){
	//console.log("startedTopic = " + topic)
	var currentsection = $('.breaker').eq(topic).index('.section')
	//console.log("currentsection = " + currentsection)
	if(document.lockedArr[currentsection] == 1 && $('.kick_scroll').length == 0){
		if(isWeb){
			$('.sec_rest_wrapper').before('<div class="kick_scroll"></div>')
		}
	}
	setTimeout(function(){
		if(document.lockedArr[currentsection] != 1){
			document.trackingArr[currentsection] = '1'	
		}else{
			document.currentSection = currentsection+1
			if(document.audioArr[currentsection] == 0){
				document.audioComplete = true;
				
			}
		}
		
		progress()
		checkCourseCompletion()
	},1000)
}

var relaunch = false
var topic_book;	 

function populateTracking(){
	if(relaunch == false){
		for(i=0; i<document.lockedArr.length; i++){	
			document.trackingArr.push('0')
		}
		
	}
}
populateTracking()

var topicTracking =[]; 
var lockTopicTracking=[];

function oraginiseLocking(){
	topicTracking = [];
	lockTopicTracking = []
	var breaker = $('.breaker')
	for(i=0; i<breaker.length; i++){
		var currentbreaker = $('div.breaker:eq('+i+')').index('.section')
		var topicEnd = $('div.breaker:eq('+(i+1)+')').index('.section')	
		if(topicEnd == -1){
			topicEnd = $('.section').length
		}
		var arrLock = []
		var arrTrack = []
		for(j=currentbreaker; j<topicEnd; j++){	
			arrLock.push(document.lockedArr[j])
			arrTrack.push(document.trackingArr[j])
		}
		//console.log("arrLock  t"+i+" = " + arrLock)
		//console.log("arrTrack t"+i+" = " + arrTrack)
		lockTopicTracking.push(arrLock)
		topicTracking.push(arrTrack)
		//console.log(topicTracking)
	}
}
oraginiseLocking()
/* pages to unlock from bookmark */
function unlockPages(){
	var breaker = $('div.breaker:eq('+(currentSec)+')')
	var currentbreaker = $('div.breaker:eq('+currentSec+')').index('.section')
	var currentsection = $('.section')
	var topicEnd = $('div.breaker:eq('+(currentSec+1)+')').index('.section')	
	var currentTopic = topicTracking[currentSec]
	var lock = false
		
	if(breaker.hasClass('testStartSec')){
		for(i=0; i<currentTopic.length; i++){
			if(currentsection.eq(currentbreaker+parseInt(i)).find('.submit_btn').css('display') == 'none'){
				currentsection.eq(currentbreaker+parseInt(i)).show()
				var id = currentsection.eq(currentbreaker+parseInt(i)).attr('id')
			}
			
		}
		$('#'+id).next('.section').show()
		/*$('.testStart').next('.section').show()*/
	}
	var break_loop = false;
		for(i=0; i<currentTopic.length; i++){
			if(currentTopic[i] == 1 && lock == false){
				currentsection.eq(currentbreaker+parseInt(i)).show()
				
			}else if(currentTopic[i] == 0 ){
					lock = true
					currentTopic = lockTopicTracking[currentSec]
				}
			if(lock == true){
					if(!currentsection.eq(currentbreaker+parseInt(i)).hasClass('testQues')){
						currentsection.eq(currentbreaker+parseInt(i)).show()
					}
					if(currentTopic[i] == 1){
						break_loop = true
					}
				if(break_loop == true){
					break
				}
		}
	}
	
		
	clearTopicQs();
}

function topic_height(){
	var imgHeight = (($('.topic_tile_twelve').width()-48)/3)/2
	if ($(window).width() <751) {
			imgHeight = (($('.topic_tile_twelve').width()-30)/2)/2
		}
	if ($(window).width() <463) {
			imgHeight = (($('.topic_tile_twelve').width())/2)
		}
	$('.topic_tile_twelve').css('height', imgHeight+'px');
	if ($(window).width() >=463) {
		var arr=[]
		for(i=0; i<$('.topic_select').length; i++){
			var tileparent = $('.topic_select').eq(i).parent()
			if(!tileparent.hasClass('twelve')){
				arr.push(parseInt($('.topic_select .top_wrapper').eq(i).css('height').split('px')))
			}

		}
		var height = Math.max.apply(Math, arr)
		for(i=1; i<arr.length; i++){
			if(arr[i] !== arr[0]){
				$('.topic_select .top_wrapper').not('.twelve .topic_select .top_wrapper').css('min-height', height+5+'px');
					return;

			}
		}
	}
	//console.log("isWeb = " + isWeb)
	if(isWeb){
		var windowH = $(window).innerHeight();
		var menuContent = $(".menu_grid").height();
		menuContent = Number(menuContent)+100;
		//console.log("menuContent = " + menuContent + "   windowH = " + windowH);
		
		if(windowH > menuContent){
			$("#topic_nav_bar_menu").css("position","fixed");
		}else if(menuContent > windowH){
			$("#topic_nav_bar_menu").css("position","relative");
		}
	}
	
	
	if(document.hasBranches && document.userBranch!=0){
	
		$(".branch_item").css("display","none");
		$(".branch_item_" + document.userBranch).css("display","block");
	}
	
}
topic_height()
	
$(function() {
	/* fix for iPad menu position issue */
    var win
	if(isiPad || isiPhone){  
		if(window.top !== window.self) {
			win = $(parent.parent.document);
		}else{
			win = $(window);
		}
	}else{
		win = $(window);
	}
	resize();  
	win.resize(resize);

    function resize() {
		$('.topic_select .top_wrapper').css('min-height', '0px')
			topic_height()
		
    }
});

function setTopicIntro(sec){
	/* test out: if there is a pre-test in the course */
	if (document.pretestPresent == 1)
	{
		/* test out: if not currently taking the pre-test bookmark the page */
		if (!document.takingPretest) 
		{
			doBookMark(sec);
		}	
	}
	else {
		doBookMark(sec);
	}	
}

function exitPretest() {
/* test-out: upon exit of the pre-test update the Menu icons and reset for the post-test */
	/* test out: obtain the status of what topics have been tested out of */
	var tempTPretestOutArr = document.topicsPretestedOut.split('');
	var compTopics = 0;
	for (var i = 0; i < document.topicsCount; i++)
	{		
		/* test out: show the tested out icon for any topics that have been tested out of and unlock these topics */
		if (tempTPretestOutArr[i] == 1)
		{
			$('.select_bottom:eq('+i+') img').attr('src', 'images/general_int/topic_testout_launch.png');			
			$('.select_bottom:eq('+i+') img').attr('title', localiseString('topic_start'));
			$('.select_bottom:eq('+i+') img').attr('alt', localiseString('topic_start'));
			$('.select_bottom:eq('+i+') img').hover(function () {
				$(this).attr('src' ,'images/general_int/topic_testout_launch_rollover.png')
			});
			$('.select_bottom:eq('+i+') img').mouseout(function(){
				$(this).attr('src' ,'images/general_int/topic_testout_launch.png');
			});
			$('.topic_select .overlay').eq(i).css('display', 'none');

			/* 20230503 New Menu Updates */
			$('.topic_select .top_wrapper').eq(i).addClass('unlocked');
			$('.topic_select .heading_area img').eq(i).attr('src', 'images/menu_topic_'+(i+2)+'.png');
            
            $('.burger_select:eq('+i+') img').attr('src', 'images/general_int/topic_testout_launch.png');			
			$('.burger_select:eq('+i+') img').attr('title', localiseString('topic_start'));
			$('.burger_select:eq('+i+') img').attr('alt', localiseString('topic_start'));
			$('.burger_select:eq('+i+') img').hover(function () {
				$(this).attr('src' ,'images/general_int/topic_testout_launch.png')
			});
			$('.burger_select:eq('+i+') img').mouseout(function(){
				$(this).attr('src' ,'images/general_int/topic_testout_launch.png');
			});
			$('.burger_select .overlay').eq(i).css('display', 'none');
			compTopics++;
		}
		else {
			if(document.trackingArr[($('div.breaker:eq('+i+')').prev('.section').index('.section'))]==1){					
				if (tempTPretestOutArr[i - 1] == 0)
				{
					compTopics++;
				}	
			}
			if (compTopics == i) {
				$('.select_bottom:eq('+i+') img').attr('src', 'images/custom_int/topic_launch.png');			
				$('.select_bottom:eq('+i+') img').attr('title', localiseString('topic_start'));
				$('.select_bottom:eq('+i+') img').attr('alt', localiseString('topic_start'));
				$('.select_bottom:eq('+i+') img').hover(function () {
					$(this).attr('src' ,'images/custom_int/topic_launch_rollover.png')
				});
				$('.select_bottom:eq('+i+') img').mouseout(function(){
					$(this).attr('src' ,'images/custom_int/topic_launch.png');
				});
				$('.topic_select .overlay').eq(i).css('display', 'none');

				/* 20230503 New Menu Updates */
				$('.topic_select .top_wrapper').eq(i).addClass('unlocked');
				$('.topic_select .heading_area img').eq(i).attr('src', 'images/menu_topic_'+(i+2)+'.png');
                
                $('.burger_select:eq('+i+') img').attr('src', 'images/custom_int/burger_unlocked.png');			
				$('.burger_select:eq('+i+') img').attr('title', localiseString('topic_start'));
				$('.burger_select:eq('+i+') img').attr('alt', localiseString('topic_start'));
				$('.burger_select:eq('+i+') img').hover(function () {
					$(this).attr('src' ,'images/custom_int/burger_unlocked.png')
				});
				$('.burger_select:eq('+i+') img').mouseout(function(){
					$(this).attr('src' ,'images/custom_int/burger_unlocked.png');
				});
				$('.burger_select .overlay').eq(i).css('display', 'none');
			}
		}	
	}
	$('.bar_robot .home').css('visibility','visible');
    if(document.showResourcesButton){
	   $('.bar_robot .page').css('visibility','visible');
    }
	$('.bar_robot .menu_title').css('margin-left','38px');
	//$('#home_title').css('margin-left','34px');
	
	/* 20230427 show language switcher button if required on exit of pre-test */
	if(document.isMultiSco){
		$('.bar_robot .switchLang').css('visibility','visible');
	}
	
	if(document.testIntroSubsection != null){
		retakeAssessment();
	}
}		

function positionBurgerMenu(){
	//$(".burger_index").css({"top":"64px"})
    /*$(".burger_bg").css('margin-left','-360px');*/
    var eLeft = $('.home').offset().left; 
    //console.log('eLeft = ' + eLeft); 
    
    if(eLeft <= 12){
        //eLeft = 12;
    }
    
    //$(".burger_bg").css('margin-left',eLeft+'px')
	
	/*$(".burger_bg").animate({
		marginLeft: eLeft+'px'
	}, 500);*/
	
	$(".burger_bg").css('margin','0px auto')
}
//20190917 desktop portrait fix
function portraitTestFix(){
	//alert('isWeb = ' + isWeb)
	if(isWeb){
	
		if(screen.height > screen.width){
			//console.log("Portrait Monitor");
			setTimeout(function(){
				
				//console.log("display = " + $("#sec_" + document.testIntroSubsection).css("display"))
				
				if($("#sec_" + document.testIntroSubsection).css("display") == "block"){
					//console.log("test start visible")
					document.audioComplete = true; document.intComplete = true;
					pageCompleted = document.testIntroSubsection-1;
					isPageComplete(document.testIntroSubsection);
				}
				
				$(window).trigger("scroll");
				
				//console.log("document.currentSection = " + document.currentSection);
				
			},1000);
			
			
		}
	getSliderHeight();
	
	}
	rePosHotSpots();
}

function preTestStart(){
	if($("#sec_" + document.testIntroSubsection).css("display") == "block"){
		//console.log("test start visible")
		document.audioComplete = true; document.intComplete = true;
		pageCompleted = document.testIntroSubsection-1;
		isPageComplete(document.testIntroSubsection);
	}
	
}

/*

	20200610
	Funciton to check if topic pretest has been attempted when returing to topic

*/

function checkTopicTest(){
	
	document.takeTopicPreTest = false;
	
	var tempTestAttemptArr = document.topicTestAttempted.split('');
	if(tempTestAttemptArr[document.currentTopic-1] == 1){
		
		document.skipTopicTest = true;
		
		var startQuesArr = topic_pre_ques_dat['test_dat'][0].pre_start_sec_num.split(',');
		
		var topicStart = Number(startQuesArr[document.currentTopic-1]) - 1;
		//console.log("attemped " + topicStart)
		document.audioComplete = true; document.intComplete = true;
		pageCompleted = topicStart -1;
		isPageComplete(topicStart);
	}
	
}

/*

	20200609
	Funciton to update accent colours for topic

*/
function updateAccentColors(){
	
	/*for(var i = 1; i <= document.topicsCount; i++){
		
		$(".menu_bar").removeClass("topic_"+i+"_banner")
		
	}
	
	$(".menu_bar").addClass("topic_"+document.currentTopic+"_banner")
	*/
}

/* Progress Indicator 2023 -- */
function updateProgressBar(n){
	console.log("updateProgressBar = " + n)
	var tempTrackArr = document.trackingArr;

	var lastPage = 0;

	var pCnt = 0;

	var pViewed = 0;

	if(document.testIntroSubsection != null){

		var numQs = Number(post_test_ques_dat['test_dat'][0].select_ques) + 1;
		lastPage = document.testIntroSubsection + numQs;

	}else{
		lastPage = document.subsectionCount;
	}

	for(var i = 1; i!= lastPage; i++){

		if(Number(tempTrackArr[i]== 1)){
			if(document.testIntroSubsection != null){
				if((i != (document.testIntroSubsection - 1)) && (i != lastPage -1)){
					pCnt++;
				}

			}else{
				pCnt++;
			}
		}
	}

	pViewed = Math.round(pCnt/lastPage * 100);
	
	var status = int_tracking.int_lesson_status;

	if(document.testIntroSubsection != null){

		if(tempTrackArr[document.testResultsSubsection-1]== 1){
			if(status == lms_pass_status1 || status == lms_pass_status2){
				pViewed = 100;
			}
		}
	}

	if(pViewed == 100){
		if(document.textDirection == "ltr"){
			$(".course_progress").animate({ width:98.5+"%" }); 
		}else{
			$(".course_progress").animate({ width:97+"%" }); 
		}
	}else{
		$(".course_progress").animate({ width:pViewed+"%" }); 
	}
	/*if(pViewed >= 10){
		if(document.textDirection == "ltr"){
			$(".progress_pct").html(pViewed+"%");
		}else{
			$(".progress_pct").html("%"+pViewed)
		}
	}else{
		$(".progress_pct").html("");
	}*/
	if(document.textDirection == "ltr"){
		$(".progress_pct").html("%"+pViewed);
	}else{
		$(".progress_pct").html("%"+pViewed)
	}
	if(pViewed >= 10){
		$(".progress_pct").css("visibility","visible");
	}else{
		$(".progress_pct").css("visibility","hidden");
	}

	//$(".course_progress").attr("title",pViewed+"% "+ localiseString("topic_complete"));
	// 20220418 Hide progress bar from JAWs when updating to prevent it from stealing focuse
	if(index === true){

		$(".index_progress").attr("aria-hidden",true);

	}else{
		$(".course_progress").attr("aria-hidden",true);
	}
	// 20220418 Hide progress bar from JAWs when updating to prevent it from stealing focuse

	$(".course_progress").attr("aria-valuenow",pViewed);

	$(".course_progress").css("visibility","visible");

	// 20220418 Hide progress bar from JAWs when updating to prevent it from stealing focuse
	setTimeout(function(){

		if(index === true){

			$(".index_progress").attr("aria-hidden",false);
	
		}else{
			$(".course_progress").attr("aria-hidden",false);
		}

	},1000);
	// 20220418 Hide progress bar from JAWs when updating to prevent it from stealing focuse

}
/* -- Progress Indicator 2023 */