/* variables used for localized interface text */
/* languages included: English en, German de, French fr, Italian it, Brazilian Portuguese pt */

/* English en */
document.langStrings_en = {
	
	"transcript_btn" : "Transcript",
	"submit_btn" : "Submit",
	"submit_btn_locked" : "Submit not available",
	"tryagain_btn" : "Try Again",
	"conf_btn" : "Confident",
	"notconf_btn" : "Not Confident",
	
	"close_btn" : "Close",
	"print_btn" : "Print",
	"resource_btn" : "View Resources",
	"glossary_btn" : "View Glossary",
	"lang_btn" : "Switch Language",
	
	"exit_nav" : "Exit Course",
	"left_nav" : "Previous",
	"left_nav_locked" : "Previous not available",
	"right_nav" : "Next",
	"right_nav_locked" : "Next not available",
	"right_btn_locked" : "Before you can continue, please complete all interactivities onscreen.",
	"home_nav" : "Home Page",
    "menu_nav" : "Menu",
	
	"nav_topic_txt" : "Select the Next button to continue to the next topic within this section.",
	"nav_section_txt" : "Select the Next button to continue to the next topic or select the Home button to return to the home page.",
	"nav_prebranch_txt" : "Select the Next button to continue to the next topic.",
	"nav_branch_txt" : "Select the Home button to return to the home page.",
	"nav_exit_txt" : "",
	
	"pretest_title" : "Welcome",
	"pretest_text" : "If so, we have designed a challenge for you. If you prove that you are knowledgeable, you can take an accelerated path through the course.",
	"pretest_nav_cancel" : "Start the Course",
	"pretest_nav_start" : "Take the Challenge",
	
	"bookmark_title" : "Resume",
	"bookmark_text" : "Would you like to resume where you left off?",
	"bookmark_nav_start" : "No",
	"bookmark_nav_resume" : "Yes",
		
	"slide_right" : "Next Slide",
	"slide_left" : "Previous Slide",
	"slide_progress" : "Slide progress bar",
	
	"complete_arrow" : "Continue",
	"complete_arrow_locked" : "Before you can continue, please complete all interactivities onscreen.",
	
	"topic_start" : "Launch Section",
	"topic_locked" : "Topic Locked",
	
	"topic_not_started" : "Not Started",
	"topic_incomplete" : "Incomplete",
	"topic_complete" : "Complete",	
	
	"test_question" : "Question",
	"test_of" : "of",
	
	"course_logo" : "Citi Logo",
	"retake_test_button" : "Retake Assessment",
	"home_assess_button" : "Home",
	"confirm_attest_button" : "Complete the Course",
    
    "hotspot_close" : "Close Hotspot Reveal"
}

/* German de */
document.langStrings_de = {
	
	"transcript_btn" : "Transkription",
	"submit_btn" : "Absenden",
	"submit_btn_locked" : "„Absenden“ nicht verfügbar",
	"tryagain_btn" : "Erneut versuchen",
	"conf_btn" : "Vertraulich",
	"notconf_btn" : "Nicht vertraulich",
	
	"close_btn" : "Schließen",
	"print_btn" : "Drucken",
	"resource_btn" : "Ressourcen anzeigen",
	"glossary_btn" : "Glossar anzeigen",
	"lang_btn" : "Sprache wechseln",
	
	"exit_nav" : "Kurs beenden",
	"left_nav" : "Zurück",
	"left_nav_locked" : "„Zurück“ nicht verfügbar",
	"right_nav" : "Weiter",
	"right_nav_locked" : "„Weiter“ nicht verfügbar",
	"right_btn_locked" : "Bitte schließen Sie alle Aktivitäten auf dem Bildschirm ab, bevor Sie fortfahren können.",
	"home_nav" : "Home",
    "menu_nav" : "Menü",
	
	"nav_topic_txt" : "Klicken Sie auf die „Weiter“-Taste, um mit dem nächsten Thema in diesem Abschnitt fortzufahren.",
	"nav_section_txt" : "Klicken Sie auf die „Weiter“-Taste, um mit dem nächsten Thema fortzufahren, oder klicken Sie auf die „Home“-Taste, um zur Startseite zurückzukehren.",
	"nav_prebranch_txt" : "Select the Next button to continue to the next topic.",
	"nav_branch_txt" : "Select the Home button to return to the home page.",
	"nav_exit_txt" : "",
	
	"pretest_title" : "Willkommen",
	"pretest_text" : "Wenn das so ist, haben wir eine Herausforderung für Sie. Wenn Sie Ihr Wissen unter Beweis stellen, können Sie den Kurs schneller absolvieren.",
	"pretest_nav_cancel" : "Kurs starten",
	"pretest_nav_start" : "Herausforderung annehmen",
	
	"bookmark_title" : "Fortsetzen",
	"bookmark_text" : "Möchten Sie fortfahren, wo Sie aufgehört haben?",
	"bookmark_nav_start" : "Nein",
	"bookmark_nav_resume" : "Ja",
		
	"slide_right" : "Nächste Folie",
	"slide_left" : "Vorherige Folie",
	"slide_progress" : "Fortschrittsbalken der Folie",
	
	"complete_arrow" : "Fortfahren",
	"complete_arrow_locked" : "Bitte schließen Sie alle Aktivitäten auf dem Bildschirm ab, bevor Sie fortfahren können.",
	
	"topic_start" : "Abschnitt öffnen",
	"topic_locked" : "Thema gesperrt",
	
	"topic_not_started" : "Nicht gestartet",
	"topic_incomplete" : "Nicht abgeschlossen",
	"topic_complete" : "Abgeschlossen",	
	
	"test_question" : "Frage",
	"test_of" : "von",
	
	"course_logo" : "Citi Logo",
	"retake_test_button" : "Test wiederholen",
	"home_assess_button" : "Home",
	"confirm_attest_button" : "Den Kurs abschließen",
    
    "hotspot_close" : "Hotspot Aufdecken schließen"
}

/* French fr */
document.langStrings_fr = {
	
	"transcript_btn" : "Transcription",
	"submit_btn" : "Envoyer",
	"submit_btn_locked" : "Envoyer non disponible",
	"tryagain_btn" : "Réessayer",
	"conf_btn" : "Confiant",
	"notconf_btn" : "Pas confiant",
	
	"close_btn" : "Fermer",
	"print_btn" : "Imprimer",
	"resource_btn" : "Afficher les ressources",
	"glossary_btn" : "Afficher le glossaire",
	"lang_btn" : "Changer de langue",
	
	"exit_nav" : "Quitter le cours",
	"left_nav" : "Précédent",
	"left_nav_locked" : "Précédent non disponible",
	"right_nav" : "Suivant",
	"right_nav_locked" : "Suivant non disponible",
	"right_btn_locked" : "Avant de pouvoir continuer, vous devez terminer toutes les activités à l’écran.",
	"home_nav" : "Page d’accueil",
    "menu_nav" : "Menu",
	
	"nav_topic_txt" : "Cliquez sur le bouton Suivant pour passer au sujet suivant de cette section.",
	"nav_section_txt" : "Cliquez sur le bouton Suivant pour passer au sujet suivant ou sur le bouton Page d’accueil pour retourner à la page d’accueil.",
	"nav_prebranch_txt" : "Select the Next button to continue to the next topic.",
	"nav_branch_txt" : "Select the Home button to return to the home page.",
	"nav_exit_txt" : "",
	
	"pretest_title" : "Bienvenue",
	"pretest_text" : "Nous avons un défi pour vous. Si vous prouvez que vous possédez déjà des connaissances, vous pourrez prendre des raccourcis dans le cours.",
	"pretest_nav_cancel" : "Commencer le cours",
	"pretest_nav_start" : "Relever le défi",
	
	"bookmark_title" : "Reprendre",
	"bookmark_text" : "Voulez-vous reprendre là où vous vous êtes arrêté ?",
	"bookmark_nav_start" : "Non",
	"bookmark_nav_resume" : "Oui",
		
	"slide_right" : "Diapositive suivante ",
	"slide_left" : "Diapositive précédente",
	"slide_progress" : "Barre de progression dans le diaporama",
	
	"complete_arrow" : "Continuer",
	"complete_arrow_locked" : "Avant de pouvoir continuer, vous devez terminer toutes les activités à l’écran.",
	
	"topic_start" : "Lancer la section",
	"topic_locked" : "Sujet verrouillé",
	
	"topic_not_started" : "Non démarré",
	"topic_incomplete" : "Inachevé",
	"topic_complete" : "Terminé",	
	
	"test_question" : "Question",
	"test_of" : "sur",
	
	"course_logo" : "Logo Citi",
	"retake_test_button" : "Repasser le test",
	"home_assess_button" : "Accueil",
	"confirm_attest_button" : "Terminer le cours",
    
    "hotspot_close" : "Fermer l’affichage Hotspot"
}

/* Italian it */
document.langStrings_it = {
	
	"transcript_btn" : "Trascrizione",
	"submit_btn" : "Invia",
	"submit_btn_locked" : "Invia non è disponibile",
	"tryagain_btn" : "Riprova",
	"conf_btn" : "Chiudi",
	"notconf_btn" : "Incerto",
	
	"close_btn" : "Chiudi",
	"print_btn" : "Stampa",
	"resource_btn" : "Visualizza le risorse",
	"glossary_btn" : "Visualizza il glossario",
	"lang_btn" : "Cambia lingua",
	
	"exit_nav" : "Chiudi il corso",
	"left_nav" : "Indietro",
	"left_nav_locked" : "Indietro non è disponibile",
	"right_nav" : "Avanti",
	"right_nav_locked" : "Avanti non è disponible",
	"right_btn_locked" : "Prima di continuare, completa tutte le attività interattive visualizzate.",
	"home_nav" : "Home",
    "menu_nav" : "Menu",
	
	"nav_topic_txt" : "Seleziona il pulsante Avanti per passare all’argomento successivo di questa sezione.",
	"nav_section_txt" : "Seleziona il pulsante Avanti per passare all’argomento successivo o il pulsante Home per tornare alla Home Page.",
	"nav_prebranch_txt" : "Select the Next button to continue to the next topic.",
	"nav_branch_txt" : "Select the Home button to return to the home page.",
	"nav_exit_txt" : "",
	
	"pretest_title" : "Benvenuto",
	"pretest_text" : "In tal caso, vogliamo metterti alla prova. Se dimostrerai di essere informato in materia, potrai intraprendere un percorso accelerato per completare il corso.",
	"pretest_nav_cancel" : "Inizia il corso",
	"pretest_nav_start" : "Accetta la sfida",
	
	"bookmark_title" : "Riprendi",
	"bookmark_text" : "Vuoi riprendere da dove hai interrotto?",
	"bookmark_nav_start" : "No",
	"bookmark_nav_resume" : "Sì",
		
	"slide_right" : "Slide successiva",
	"slide_left" : "Slide precedente",
	"slide_progress" : "Barra di avanzamento delle slide",
	
	"complete_arrow" : "Continua",
	"complete_arrow_locked" : "Prima di continuare, completa tutte le attività interattive visualizzate.",
	
	"topic_start" : "Sezione di partenza",
	"topic_locked" : "Argomento bloccato",
	
	"topic_not_started" : "Non iniziato",
	"topic_incomplete" : "Incompleto",
	"topic_complete" : "Completo",	
	
	"test_question" : "Domanda",
	"test_of" : "di",
	
	"course_logo" : "Citi Logo",
	"retake_test_button" : "Ripeti il test",
	"home_assess_button" : "Home",
	"confirm_attest_button" : "Completa il corso",
    
    "hotspot_close" : "Chiudi Rivela hotspot"
}

/* Spanish es */
document.langStrings_es = {
	
	"transcript_btn" : "Transcripción",
	"submit_btn" : "Enviar",
	"submit_btn_locked" : "Enviar no disponible",
	"tryagain_btn" : "Intentar nuevamente",
	"conf_btn" : "Con confianza",
	"notconf_btn" : "Sin confianza",
	
	"close_btn" : "Cerrar",
	"print_btn" : "Imprimir",
	"resource_btn" : "Ver recursos",
	"glossary_btn" : "Ver glosario",
	"lang_btn" : "Cambiar idioma",
	
	"exit_nav" : "Salir del curso",
	"left_nav" : "Anterior",
	"left_nav_locked" : "Anterior no disponible",
	"right_nav" : "Siguiente",
	"right_nav_locked" : "Siguiente no disponible",
	"right_btn_locked" : "Antes de continuar, complete todas las interactividades en pantalla.",
	"home_nav" : "Inicio",
    "menu_nav" : "Menú",
	
	"nav_topic_txt" : "Seleccione el botón Siguiente para continuar con el tema siguiente dentro de esta sección.",
	"nav_section_txt" : "Seleccione el botón Siguiente para continuar con el tema siguiente o seleccione el botón Inicio para volver a la página de inicio.",
	"nav_prebranch_txt" : "Select the Next button to continue to the next topic.",
	"nav_branch_txt" : "Select the Home button to return to the home page.",
	"nav_exit_txt" : "",
	
	"pretest_title" : "Bienvenido",
	"pretest_text" : "Si es así, hemos diseñado un desafío para usted. Si demuestra que posee los conocimientos, puede tomar un camino acelerado del curso.",
	"pretest_nav_cancel" : "Iniciar el curso",
	"pretest_nav_start" : "Aceptar el desafío",
	
	"bookmark_title" : "Reanudar",
	"bookmark_text" : "¿Desea reanudar el curso donde quedó?",
	"bookmark_nav_start" : "No",
	"bookmark_nav_resume" : "Sí",
		
	"slide_right" : "Siguiente diapositiva",
	"slide_left" : "Diapositiva anterior",
	"slide_progress" : "Barra de progreso de diapositiva",
	
	"complete_arrow" : "Continuar",
	"complete_arrow_locked" : "Antes de continuar, complete todas las interactividades en pantalla.",
	
	"topic_start" : "Comenzar una sección",
	"topic_locked" : "Tema bloqueado",
	
	"topic_not_started" : "No iniciado",
	"topic_incomplete" : "No completado",
	"topic_complete" : "Completar",	
	
	"test_question" : "Pregunta",
	"test_of" : "de",
	
	"course_logo" : "Logotipo de Citi",
	"retake_test_button" : "Volver a realizar la prueba",
	"home_assess_button" : "Inicio",
	"confirm_attest_button" : "Completar el curso",
    
    "hotspot_close" : "Cerrar Mostrar zona de conexión"
}

/* Portugese pt */
document.langStrings_pt = {
	
	"transcript_btn" : "Transcrição",
	"submit_btn" : "Enviar",
	"submit_btn_locked" : "Não é possível enviar",
	"tryagain_btn" : "Tentar novamente",
	"conf_btn" : "Confiante",
	"notconf_btn" : "Sem confiança",
	
	"close_btn" : "Fechar",
	"print_btn" : "Imprimir",
	"resource_btn" : "Visualizar recursos",
	"glossary_btn" : "Visualizar o glossário",
	"lang_btn" : "Alternar idioma",
	
	"exit_nav" : "Sair do curso",
	"left_nav" : "Retornar",
	"left_nav_locked" : "Não é possível retornar",
	"right_nav" : "Avançar",
	"right_nav_locked" : "Não é possível avançar",
	"right_btn_locked" : "Antes de continuar, complete todas as interações da tela.",
	"home_nav" : "Página inicial",
    "menu_nav" : "Menu",
	
	"nav_topic_txt" : "Selecione o botão Avançar para continuar até o próximo tópico desta sessão.",
	"nav_section_txt" : "Selecione o botão Avançar para continuar até o próximo tópico ou selecione o botão Início para voltar à página inicial.",
	"nav_prebranch_txt" : "Select the Next button to continue to the next topic.",
	"nav_branch_txt" : "Select the Home button to return to the home page.",
	"nav_exit_txt" : "",
	
	"pretest_title" : "Bem-vindo(a)",
	"pretest_text" : "Nesse caso, criamos um desafio para você. Se demonstrar que conhece o assunto, você poderá avançar mais rapidamente pelo curso.",
	"pretest_nav_cancel" : "Iniciar o curso",
	"pretest_nav_start" : "Aceitar o desafio",
	
	"bookmark_title" : "Retomar",
	"bookmark_text" : "Gostaria de retomar de onde parou?",
	"bookmark_nav_start" : "Não",
	"bookmark_nav_resume" : "Sim",
		
	"slide_right" : "Próximo slide",
	"slide_left" : "Slide anterior",
	"slide_progress" : "Deslize a barra de progresso",
	
	"complete_arrow" : "Continuar",
	"complete_arrow_locked" : "Antes de continuar, complete todas as interações da tela.",
	
	"topic_start" : "Iniciar a sessão",
	"topic_locked" : "O tópico está bloqueado",
	
	"topic_not_started" : "Não iniciado",
	"topic_incomplete" : "Incompleto",
	"topic_complete" : "Concluir",	
	
	"test_question" : "Pergunta",
	"test_of" : "de",
	
	"course_logo" : "Citi Logo",
	"retake_test_button" : "Refazer o teste",
	"home_assess_button" : "Home",
	"confirm_attest_button" : "Concluir o curso",
    
    "hotspot_close" : "Fechar a visualização do Hotspot"
}

/* Arabic ar */
document.langStrings_ar = {
	
	"transcript_btn" : "نسخة",
	"submit_btn" : "إرسال",
	"submit_btn_locked" : "الإرسال غير متاح",
	"tryagain_btn" : "المحاولة مرة أخرى",
	"conf_btn" : "واثق",
	"notconf_btn" : "غير واثق",
	
	"close_btn" : "إغلاق",
	"print_btn" : "طباعة",
	"resource_btn" : "عرض الموارد",
	"glossary_btn" : "عرض المسرد",
	"lang_btn" : "تبديل اللغة",
	
	"exit_nav" : "الخروج من الدورة التدريبية",
	"left_nav" : "السابق",
	"left_nav_locked" : "السابق غير متاح",
	"right_nav" : "التالي",
	"right_nav_locked" : "التالي غير متاح",
	"right_btn_locked" : "قبل أن تتمكن من المتابعة، يُرجى إكمال جميع العناصر التفاعلية التي تظهر على الشاشة.",
	"home_nav" : "الصفحة الرئيسية",
    "menu_nav" : "القائمة",
	
	"nav_topic_txt" : "حدد زر &quot;التالي&quot; للمتابعة إلى الموضوع التالي في هذا القسم.",
	"nav_section_txt" : "حدد زر &quot;التالي&quot; للمتابعة إلى الموضوع التالي أو حدد زر &quot;الصفحة الرئيسية&quot; للعودة إلى الصفحة الرئيسية.",
	"nav_prebranch_txt" : "Select the Next button to continue to the next topic.",
	"nav_branch_txt" : "Select the Home button to return to the home page.",
	"nav_exit_txt" : "",
	
	"pretest_title" : "مرحبً",
	"pretest_text" : "إذا كان الأمر كذلك، فقد صممنا لك تحديًا. إذا أثبتت أنك حسن الاطلاع، فيمكنك أن تأخذ مسارًا سريعًا خلال الدورة.",
	"pretest_nav_cancel" : "بدء الدورة التدريبية",
	"pretest_nav_start" : "بدء التحدي",
	
	"bookmark_title" : "استئناف",
	"bookmark_text" : "هل ترغب في الاستئناف من حيث توقفت؟",
	"bookmark_nav_resume" : "نعم",
	"bookmark_nav_start" : "لا",
	
		
	"slide_right" : "الشريحة التالية",
	"slide_left" : "الشريحة السابقة",
	"slide_progress" : "شريط التقدم الخاص بالشرائح",
	
	"complete_arrow" : "متابعة",
	"complete_arrow_locked" : "قبل أن تتمكن من المتابعة، يُرجى إكمال جميع العناصر التفاعلية التي تظهر على الشاشة.",
	
	"topic_start" : "تشغيل القسم",
	"topic_locked" : "تم قفل الموضوع",
	
	"topic_not_started" : "لم يتم البدء",
	"topic_incomplete" : "غير مكتمل",
	"topic_complete" : "مكتمل",	
	
	"test_question" : "السؤال",
	"test_of" : "من",
	
	"course_logo" : "شعار Citi",
	"retake_test_button" : "إعادة الاختبار",
	"home_assess_button" : "الصفحة الرئيسية",
	"confirm_attest_button" : "استكمال الدورة التدريبية",
    
    "hotspot_close" : "إغلاق كشف نقطة الاتصال"
}

/* Bahasa Indonesian id */
document.langStrings_id = {
	
	"transcript_btn" : "Transkrip",
	"submit_btn" : "Kirim",
	"submit_btn_locked" : "Kirim tidak tersedia",
	"tryagain_btn" : "Coba Lagi",
	"conf_btn" : "Yakin",
	"notconf_btn" : "Tidak Yakin",
	
	"close_btn" : "Tutup",
	"print_btn" : "Cetak",
	"resource_btn" : "Lihat Sumber Daya",
	"glossary_btn" : "Lihat Glosarium",
	"lang_btn" : "Ganti bahasa",
	
	"exit_nav" : "Keluar dari Kursus",
	"left_nav" : "Sebelumnya",
	"left_nav_locked" : "Halaman sebelumnya tidak tersedia",
	"right_nav" : "Selanjutnya",
	"right_nav_locked" : "Halaman berikutnya tidak tersedia",
	"right_btn_locked" : "Sebelum Anda dapat melanjutkan, selesaikanlah semua interaktivitas pada layar.",
	"home_nav" : "Laman Beranda",
    "menu_nav" : "Menu",
	
	"nav_topic_txt" : "Pilih tombol Selanjutnya untuk melanjutkan ke topik berikutnya dalam bagian ini.",
	"nav_section_txt" : "Pilih tombol Selanjutnya untuk melanjutkan ke topik berikutnya atau pilih tombol Beranda untuk kembali ke laman beranda.",
	"nav_prebranch_txt" : "Select the Next button to continue to the next topic.",
	"nav_branch_txt" : "Select the Home button to return to the home page.",
	"nav_exit_txt" : "",
	
	"pretest_title" : "Selamat Datang",
	"pretest_text" : "Apabila demikian, kami telah menyusun tantangan untuk Anda. Apabila Anda membuktikan kecerdasan Anda, Anda dapat menempuh jalur akselerasi selama kursus.",
	"pretest_nav_cancel" : "Mulai Kursus",
	"pretest_nav_start" : "Ikuti Tantangan",
	
	"bookmark_title" : "Melanjutkan",
	"bookmark_text" : "Apakah Anda ingin melanjutkan dari bagian terakhir yang Anda tinggalkan?",
	"bookmark_nav_start" : "Tidak",
	"bookmark_nav_resume" : "Ya",
		
	"slide_right" : "Slide Berikutnya",
	"slide_left" : "Slide Sebelumnya",
	"slide_progress" : "Geser bilah kemajuan",
	
	"complete_arrow" : "Lanjutkan",
	"complete_arrow_locked" : "Sebelum Anda dapat melanjutkan, selesaikanlah semua interaktivitas pada layar.",
	
	"topic_start" : "Luncurkan Bagian",
	"topic_locked" : "Topik Dikunci",
	
	"topic_not_started" : "Belum Dimulai",
	"topic_incomplete" : "Belum Selesai",
	"topic_complete" : "Selesai",	
	
	"test_question" : "Pertanyaan",
	"test_of" : "of",
	
	"course_logo" : "Logo Citi",
	"retake_test_button" : "Ulang Tes",
	"home_assess_button" : "Beranda",
	"confirm_attest_button" : "Selesaikan Kursus",
    
    "hotspot_close" : "Tutup Pengungkapan Hotspot"
}

/* French Canadian frca */
document.langStrings_frca = {
	
	"transcript_btn" : "Transcription",
	"submit_btn" : "Soumettre",
	"submit_btn_locked" : "Soumettre non disponible",
	"tryagain_btn" : "Réessayer",
	"conf_btn" : "Confiant",
	"notconf_btn" : "Non confiant",
	
	"close_btn" : "Fermer",
	"print_btn" : "Imprimer",
	"resource_btn" : "Voir les ressources",
	"glossary_btn" : "Voir le glossaire",
	"lang_btn" : "Changer de langue",
	
	"exit_nav" : "Quitter le cours",
	"left_nav" : "Précédente",
	"left_nav_locked" : "Précédent non disponible",
	"right_nav" : "Suivant",
	"right_nav_locked" : "Suivant non disponible",
	"right_btn_locked" : "Avant de pouvoir continuer, veuillez compléter toutes les interactivités à l’écran.",
	"home_nav" : "Page d’accueil",
    "menu_nav" : "Menu",
	
	"nav_topic_txt" : "SSélectionnez le bouton Suivant pour passer à la rubrique suivante de cette section.",
	"nav_section_txt" : "Sélectionnez le bouton Suivant pour passer à la rubrique suivante ou sélectionnez le bouton Page d’accueil pour revenir à la page d’accueil.",
	"nav_prebranch_txt" : "Select the Next button to continue to the next topic.",
	"nav_branch_txt" : "Select the Home button to return to the home page.",
	"nav_exit_txt" : "",
	
	"pretest_title" : "Bienvenue",
	"pretest_text" : "Si c’est le cas, nous avons conçu un défi pour vous. Si vous prouvez que vous avez les connaissances nécessaires, vous pouvez suivre un parcours accéléré dans le cours.",
	"pretest_nav_cancel" : "Commencer le cours",
	"pretest_nav_start" : "Relever le défi",
	
	"bookmark_title" : "Reprendre",
	"bookmark_text" : "Aimeriez-vous reprendre là où vous avez arrêté?",
	"bookmark_nav_start" : "Non",
	"bookmark_nav_resume" : "Oui",
		
	"slide_right" : "Diapositive suivante",
	"slide_left" : "Diapositive précédente",
	"slide_progress" : "Barre de progression des diapositives",
	
	"complete_arrow" : "Continuer",
	"complete_arrow_locked" : "Avant de pouvoir continuer, veuillez compléter toutes les interactivités à l’écran.",
	
	"topic_start" : "Section de lancement",
	"topic_locked" : "Sujet verrouillé",
	
	"topic_not_started" : "Non commencé",
	"topic_incomplete" : "Non terminé",
	"topic_complete" : "Terminé",	
	
	"test_question" : "Question",
	"test_of" : "sur",
	
	"course_logo" : "Logo Citi",
	"retake_test_button" : "Retenter le test",
	"home_assess_button" : "Accueil",
	"confirm_attest_button" : "Terminer le cours",
    
    "hotspot_close" : "Fermer la révélation des points focaux"
}

/* Simplified Chinese */
document.langStrings_zhhans = {
	
	"transcript_btn" : "成绩单",
	"submit_btn" : "提交",
	"submit_btn_locked" : "无法提交",
	"tryagain_btn" : "重试",
	"conf_btn" : "自信",
	"notconf_btn" : "不自信",
	
	"close_btn" : "关闭",
	"print_btn" : "打印",
	"resource_btn" : "查看资源",
	"glossary_btn" : "查看术语表",
	"lang_btn" : "更改语言",
	
	"exit_nav" : "退出课程",
	"left_nav" : "上一页",
	"left_nav_locked" : "无前页",
	"right_nav" : "下一步",
	"right_nav_locked" : "无后页",
	"right_btn_locked" : "继续之前，请完成屏幕上的所有互动。",
	"home_nav" : "主页",
    "menu_nav" : "菜单",
	
	"nav_topic_txt" : "选择“下一步”按钮，继续本节中的下一个主题。",
	"nav_section_txt" : "选择“下一步”按钮，继续下一个主题，或选择“主页”按钮返回主页。",
	"nav_prebranch_txt" : "Select the Next button to continue to the next topic.",
	"nav_branch_txt" : "Select the Home button to return to the home page.",
	"nav_exit_txt" : "",
	
	"pretest_title" : "欢迎您",
	"pretest_text" : "如果是这样，我们为您设计了一个挑战。如果您能证明自己已经有所了解，就能通过捷径完成这门课程。",
	"pretest_nav_cancel" : "开始课程",
	"pretest_nav_start" : "接受这个挑战",
	
	"bookmark_title" : "继续",
	"bookmark_text" : "您希望从您离开的地方继续吗？",
	"bookmark_nav_start" : "否",
	"bookmark_nav_resume" : "是",
		
	"slide_right" : "下一张幻灯片",
	"slide_left" : "上一张幻灯片",
	"slide_progress" : "幻灯片进度条",
	
	"complete_arrow" : "继续",
	"complete_arrow_locked" : "继续之前，请完成屏幕上的所有互动。",
	
	"topic_start" : "启动部分",
	"topic_locked" : "锁定的主题",
	
	"topic_not_started" : "未开始",
	"topic_incomplete" : "未完成",
	"topic_complete" : "完成",	
	
	"test_question" : "问题",
	"test_of" : "/",
	
	"course_logo" : "Citi Logo",
	"retake_test_button" : "重新参加测试",
	"home_assess_button" : "Home",
	"confirm_attest_button" : "完成课程",
    
    "hotspot_close" : "关闭热点披露"
}

/* Tradistional Chinese zhhant */
document.langStrings_zhhant = {
	
	"transcript_btn" : "轉錄本",
	"submit_btn" : "提交",
	"submit_btn_locked" : "無法提交",
	"tryagain_btn" : "再試一次",
	"conf_btn" : "有信心",
	"notconf_btn" : "沒信心",
	
	"close_btn" : "關閉",
	"print_btn" : "列印",
	"resource_btn" : "檢視資源",
	"glossary_btn" : "檢視專有名詞",
	"lang_btn" : "切換語言",
	
	"exit_nav" : "離開課程",
	"left_nav" : "上一個",
	"left_nav_locked" : "無前頁",
	"right_nav" : "下一步",
	"right_nav_locked" : "無後頁",
	"right_btn_locked" : "在繼續之前，請您完成畫面上所有的互動項目。",
	"home_nav" : "首頁",
    "menu_nav" : "功能表",
	
	"nav_topic_txt" : "點選「下一步」繼續前往本章節的下個主題。",
	"nav_section_txt" : "點選「下一步」繼續前往下個主題，或點選「首頁」返回。",
	"nav_prebranch_txt" : "Select the Next button to continue to the next topic.",
	"nav_branch_txt" : "Select the Home button to return to the home page.",
	"nav_exit_txt" : "",
	
	"pretest_title" : "歡迎",
	"pretest_text" : "那麼，我們為您設計了一項挑戰。彈指之間完成課程，證明您的博學多聞。",
	"pretest_nav_cancel" : "開始課程",
	"pretest_nav_start" : "接受挑戰",
	
	"bookmark_title" : "恢復",
	"bookmark_text" : "您是否想恢復您離開的頁面嗎？",
	"bookmark_nav_start" : "否",
	"bookmark_nav_resume" : "是",
		
	"slide_right" : "下一頁",
	"slide_left" : "前一頁",
	"slide_progress" : "投影片進度列",
	
	"complete_arrow" : "繼續",
	"complete_arrow_locked" : "在繼續之前，請您完成畫面上所有的互動項目。",
	
	"topic_start" : "啟動章節",
	"topic_locked" : "鎖定主題",
	
	"topic_not_started" : "尚未開始",
	"topic_incomplete" : "未完成",
	"topic_complete" : "完成",	
	
	"test_question" : "問題",
	"test_of" : "/",
	
	"course_logo" : "Citi Logo",
	"retake_test_button" : "重新測驗",
	"home_assess_button" : "Home",
	"confirm_attest_button" : "完成課程",
    
    "hotspot_close" : "關閉熱點顯示"
}

/* Czech cs */
document.langStrings_cs = {
	
	"transcript_btn" : "Přepis",
	"submit_btn" : "Odeslat",
	"submit_btn_locked" : "Tlačítko Odeslat není k dispozici",
	"tryagain_btn" : "Zkusit znovu",
	"conf_btn" : "Jisté",
	"notconf_btn" : "Nejisté",
	
	"close_btn" : "Zavřít",
	"print_btn" : "Vytisknout",
	"resource_btn" : "Zobrazit zdroje",
	"glossary_btn" : "Zobrazit glosář",
	"lang_btn" : "Přepnout jazyk",	
	
	"exit_nav" : "Odejít z kurzu",
	"left_nav" : "Předchozí",
	"left_nav_locked" : "Tlačítko Předchozí není k dispozici",
	"right_nav" : "Další",
	"right_nav_locked" : "Tlačítko Další není k dispozici",
	"right_btn_locked" : "Předtím než budete pokračovat, prosím dokončete všechny interaktivní úlohy na obrazovce.",
	"home_nav" : "Domovská stránka",
    "menu_nav" : "Nabídka",
	
	"nav_topic_txt" : "Pro pokračování k dalšímu tématu tohoto oddílu klikněte na tlačítko Další.",
	"nav_section_txt" : "Pro pokračování k dalšímu tématu klikněte na tlačítko Další nebo se vraťte na domovskou stránku kliknutím na tlačítko Domovská stránka.",
	"nav_prebranch_txt" : "Select the Next button to continue to the next topic.",
	"nav_branch_txt" : "Select the Home button to return to the home page.",
	"nav_exit_txt" : "",
	
	"pretest_title" : "Vítejte",
	"pretest_text" : "V takovém případě pro vás máme nachystaný úkol. Pokud prokážete své znalosti, můžete kurz absolvovat ve zrychleném režimu.",
	"pretest_nav_cancel" : "Spustit kurz",
	"pretest_nav_start" : "Splnit úkol",
	
	"bookmark_title" : "Pokračovat",
	"bookmark_text" : "Přejete si pokračovat tam, kde jste skončil/a?",
	"bookmark_nav_start" : "Ne",
	"bookmark_nav_resume" : "Ano",
		
	"slide_right" : "Další snímek",
	"slide_left" : "Předchozí snímek",
	"slide_progress" : "Posuvný ukazatel průběhu",
	
	"complete_arrow" : "Pokračovat",
	"complete_arrow_locked" : "Předtím než budete pokračovat, prosím dokončete všechny interaktivní úlohy na obrazovce.",
	
	"topic_start" : "Spustit oddíl",
	"topic_locked" : "Téma uzamčeno",
	
	"topic_not_started" : "Nezahájeno",
	"topic_incomplete" : "Nedokončené",
	"topic_complete" : "Dokončené",	
	
	"test_question" : "Otázka",
	"test_of" : "z",
	
	"course_logo" : "Citi Logo",
	"retake_test_button" : "Zopakovat test",
	"home_assess_button" : "Home",
	"confirm_attest_button" : "Dokončit kurz",
    
    "hotspot_close" : "Zavřít Zobrazení hotspotu"
}

/* Hungarian hu */
document.langStrings_hu = {
	
	"transcript_btn" : "Átirat",
	"submit_btn" : "Küldés",
	"submit_btn_locked" : "Küldés nem elérhető",
	"tryagain_btn" : "Próbálja újra",
	"conf_btn" : "Biztos benne",
	"notconf_btn" : "Nem biztos benne",
	
	"close_btn" : "Bezárás",
	"print_btn" : "Nyomtatás",
	"resource_btn" : "Források megtekintése",
	"glossary_btn" : "Szójegyzék megtekintése",
	"lang_btn" : "Nyelv váltása",	
	
	"exit_nav" : "Kilépés a tanfolyamból",
	"left_nav" : "Előző",
	"left_nav_locked" : "Az előző nem elérhető",
	"right_nav" : "Következő",
	"right_nav_locked" : "A következő nem elérhető",
	"right_btn_locked" : "Mielőtt folytatná, kérjük, töltse ki az összes interaktív feladatot a képernyőn.",
	"home_nav" : "Kezdőlap",
    "menu_nav" : "Menü",
	
	"nav_topic_txt" : "Válassza a Következő gombot a következő témakörrel való folytatáshoz ebben a szakaszban.",
	"nav_section_txt" : "Válassza a Következő gombot a következő témához való továbblépéshez, vagy kattintson a Kezdőlap gombra a kezdőlapra való visszatéréshez.",
	"nav_prebranch_txt" : "Select the Next button to continue to the next topic.",
	"nav_branch_txt" : "Select the Home button to return to the home page.",
	"nav_exit_txt" : "",
	
	"pretest_title" : "Üdvözöljük!",
	"pretest_text" : "Ha igen, akkor van egy kihívásunk az Ön számára. Ha bebizonyítja, hogy rendelkezik a megfelelő tudással, egy rövidebb úton is végighaladhat a tanfolyami anyagon.",
	"pretest_nav_cancel" : "Tanfolyam kezdése",
	"pretest_nav_start" : "Fogadja el a kihívást",
	
	"bookmark_title" : "Folytatás",
	"bookmark_text" : "Szeretné onnan folytatni, ahol abbahagyta?",
	"bookmark_nav_start" : "Nem",
	"bookmark_nav_resume" : "Igen",
		
	"slide_right" : "Következő dia",
	"slide_left" : "Előző dia",
	"slide_progress" : "Dia előrehaladási sáv",
	
	"complete_arrow" : "Folytatás",
	"complete_arrow_locked" : "Mielőtt folytatná, kérjük, töltse ki az összes interaktív feladatot a képernyőn.",
	
	"topic_start" : "Indítási szakasz",
	"topic_locked" : "Témakör zárolva",
	
	"topic_not_started" : "Nem indult el",
	"topic_incomplete" : "Nincs befejezve",
	"topic_complete" : "Befejezve",	
	
	"test_question" : "Kérdés",
	"test_of" : "/",
	
	"course_logo" : "Citi Logo",
	"retake_test_button" : "Teszt megismétlése",
	"home_assess_button" : "Home",
	"confirm_attest_button" : "A tanfolyam teljesítése",
    
    "hotspot_close" : "Hotspot Reveal bezárása"
}

/* Japanses jp */
document.langStrings_jp = {
	
	"transcript_btn" : "原稿",
	"submit_btn" : "送信",
	"submit_btn_locked" : "送信できません",
	"tryagain_btn" : "やり直す",
	"conf_btn" : "自信あり",
	"notconf_btn" : "自信なし",
	
	"close_btn" : "閉じる",
	"print_btn" : "印刷",
	"resource_btn" : "リソースの表示",
	"glossary_btn" : "用語集の表示",
	"lang_btn" : "言語の切り替え",
	
	"exit_nav" : "コースを退出",
	"left_nav" : "前へ",
	"left_nav_locked" : "前に戻れません",
	"right_nav" : "次へ",
	"right_nav_locked" : "先に進めません",
	"right_btn_locked" : "継続する前に、画面上のインタラクティブな部分をすべてを終了してください。",
	"home_nav" : "ホームページ",
    "menu_nav" : "メニュー",
	
	"nav_topic_txt" : "引き続きこのセクション内の次のトピックを実施する場合は「次へ」ボタンを選択してください。",
	"nav_section_txt" : "「次へ」ボタンを選択して引き続き次のトピックを実施するか、「ホーム」ボタンを選択してホームページに戻ります。",
	"nav_prebranch_txt" : "Select the Next button to continue to the next topic.",
	"nav_branch_txt" : "Select the Home button to return to the home page.",
	"nav_exit_txt" : "",
	
	"pretest_title" : "ようこそ",
	"pretest_text" : "もしそうであれば、あなたのために課題を作成します。理解していることを証明したい場合は、コース全体を加速過程で進めることができます。",
	"pretest_nav_cancel" : "コースを開始する",
	"pretest_nav_start" : "挑戦する",
	
	"bookmark_title" : "再開",
	"bookmark_text" : "中断したところから再開しますか？",
	"bookmark_nav_start" : "いいえ",
	"bookmark_nav_resume" : "はい",
		
	"slide_right" : "次のスライド",
	"slide_left" : "前のスライド",
	"slide_progress" : "スライド進行状況バー",
	
	"complete_arrow" : "続ける",
	"complete_arrow_locked" : "継続する前に、画面上のインタラクティブな部分をすべてを終了してください。",
	
	"topic_start" : "起動セクション",
	"topic_locked" : "トピックはロックされています",
	
	"topic_not_started" : "まだ開始していません",
	"topic_incomplete" : "完了していません",
	"topic_complete" : "完了",	
	
	"test_question" : "質問",
	"test_of" : "/",
	
	"course_logo" : "Citi Logo",
	"retake_test_button" : "再テストを受ける",
	"home_assess_button" : "Home",
	"confirm_attest_button" : "コースを完了する",
    
    "hotspot_close" : "ホットスポット表示を閉じる"
}

/* Korean ko */
document.langStrings_ko = {
	
	"transcript_btn" : "대본",
	"submit_btn" : "제출",
	"submit_btn_locked" : "제출 버튼을 사용할 수 없음",
	"tryagain_btn" : "다시 시도",
	"conf_btn" : "자신감 있음",
	"notconf_btn" : "자신감 없음",
	
	"close_btn" : "닫기",
	"print_btn" : "인쇄",
	"resource_btn" : "자료 보기",
	"glossary_btn" : "용어집 보기",
	"lang_btn" : "언어 전환",
	
	"exit_nav" : "과정 종료",
	"left_nav" : "이전",
	"left_nav_locked" : "이전 버튼을 사용할 수 없음",
	"right_nav" : "다음",
	"right_nav_locked" : "다음 버튼을 사용할 수 없음",
	"right_btn_locked" : "계속하기 전에 화면의 상호 작용 요소를 전부 완료하십시오.",
	"home_nav" : "홈페이지",
    "menu_nav" : "메뉴",
	
	"nav_topic_txt" : "이 섹션의 다음 주제로 진행하려면 ‘다음’ 버튼을 선택하십시오.",
	"nav_section_txt" : "다음 주제로 진행하려면 ‘다음’ 버튼을 선택하고 홈페이지로 돌아가려면 ‘홈페이지’ 버튼을 선택하십시오.",
	"nav_prebranch_txt" : "Select the Next button to continue to the next topic.",
	"nav_branch_txt" : "Select the Home button to return to the home page.",
	"nav_exit_txt" : "",
	
	"pretest_title" : "환영합니다.",
	"pretest_text" : "그렇다면 귀하를 위한 도전을 준비했습니다. 지식이 있음을 증명하면 과정을 빠르게 진행할 수 있습니다.",
	"pretest_nav_cancel" : "과정 시작하기",
	"pretest_nav_start" : "도전 시작하기",
	
	"bookmark_title" : "이어서 하기",
	"bookmark_text" : "중단했던 곳부터 이어서 하시겠습니까?",
	"bookmark_nav_start" : "아니요",
	"bookmark_nav_resume" : "예",
		
	"slide_right" : "다음 슬라이드",
	"slide_left" : "이전 슬라이드",
	"slide_progress" : "슬라이드 진행률 막대",
	
	"complete_arrow" : "계속",
	"complete_arrow_locked" : "계속하기 전에 화면의 상호 작용 요소를 전부 완료하십시오.",
	
	"topic_start" : "섹션 실행하기",
	"topic_locked" : "잠겨있는 주제",
	
	"topic_not_started" : "시작하지 않았음",
	"topic_incomplete" : "미완료",
	"topic_complete" : "완료",	
	
	"test_question" : "문제",
	"test_of" : "/",
	
	"course_logo" : "Citi Logo",
	"retake_test_button" : "테스트 다시 받기",
	"home_assess_button" : "Home",
	"confirm_attest_button" : "과정 완료하기",
    
    "hotspot_close" : "핫스팟 공개 닫기"
}

/* Russian ru */
document.langStrings_ru = {
	
	"transcript_btn" : "Transcript",
	"submit_btn" : "Отправить",
	"submit_btn_locked" : "Кнопка «Отправить» не доступна",
	"tryagain_btn" : "Попробуйте<br>еще раз",
	"conf_btn" : "Уверен (-а)",
	"notconf_btn" : "Не уверен (-а)",
	
	"close_btn" : "Закрыть",
	"print_btn" : "Печать",
	"resource_btn" : "Просмотреть справочные материалы",
	"glossary_btn" : "Просмотреть глоссарий",
	"lang_btn" : "Выбрать другой язык",
	
	"exit_nav" : "Выйти из курса",
	"left_nav" : "Назад",
	"left_nav_locked" : "Кнопка «Назад» не доступна",
	"right_nav" : "Далее",
	"right_nav_locked" : "Кнопка «Далее» не доступна",
	"right_btn_locked" : "Выполните все действия на экране прежде, чем продолжить.",
	"home_nav" : "Домашняя страница",
    "menu_nav" : "Меню",
	
	"nav_topic_txt" : "Нажмите на кнопку «Далее», чтобы перейти к следующей теме раздела.",
	"nav_section_txt" : "Нажмите на кнопку «Далее», чтобы перейти к следующей теме, или нажмите на значок «домашней» страницы, чтобы вернуться на главную страницу.",
	"nav_prebranch_txt" : "Select the Next button to continue to the next topic.",
	"nav_branch_txt" : "Select the Home button to return to the home page.",
	"nav_exit_txt" : "",
	
	"pretest_title" : "Добро пожаловать",
	"pretest_text" : "В этом случае мы разработали задание для вас. Если вы продемонстрируете, что владеете темой, вы сможете пройти ускоренный курс.",
	"pretest_nav_cancel" : "Начать курс",
	"pretest_nav_start" : "Пройти задание",
	
	"bookmark_title" : "Продолжить",
	"bookmark_text" : "Хотите продолжить с того места, где остановились?",
	"bookmark_nav_start" : "Нет",
	"bookmark_nav_resume" : "Да",
		
	"slide_right" : "Следующий слайд",
	"slide_left" : "Предыдущий слайд",
	"slide_progress" : "Шкала прогресса выполнения",
	
	"complete_arrow" : "Продолжить",
	"complete_arrow_locked" : "Выполните все действия на экране прежде, чем продолжить.",
	
	"topic_start" : "Приступить к разделу",
	"topic_locked" : "Тема заблокирована",
	
	"topic_not_started" : "Не начато",
	"topic_incomplete" : "Не завершено",
	"topic_complete" : "Завершено",	
	
	"test_question" : "Вопрос",
	"test_of" : "из",
	
	"course_logo" : "Логотип Citi",
	"retake_test_button" : "Повторить тест",
	"home_assess_button" : "Домашняя страница",	
	"confirm_attest_button" : "Завершить курс",
    
    "hotspot_close" : "Закрыть отображение точки доступа"
}

/* Slovak sk */
document.langStrings_sk = {
	
	"transcript_btn" : "Prepis",
	"submit_btn" : "Odoslať",
	"submit_btn_locked" : "Tlačidlo Odoslať nie je k dispozícii",
	"tryagain_btn" : "Skúsiť znovu",
	"conf_btn" : "Som si istý/-á",
	"notconf_btn" : "Nie som si istý/-á",
	
	"close_btn" : "Zatvoriť",
	"print_btn" : "Vytlačiť",
	"resource_btn" : "Zobraziť zdroje",
	"glossary_btn" : "Zobraziť slovník",
	"lang_btn" : "Prepnúť jazyk",
	
	"exit_nav" : "Ukončiť kurz",
	"left_nav" : "Späť",
	"left_nav_locked" : "Tlačidlo Späť nie je k dispozícii",
	"right_nav" : "Ďalej",
	"right_nav_locked" : "Tlačidlo Ďalej nie je k dispozícii",
	"right_btn_locked" : "Skôr ako budete môcť pokračovať, dokončite všetky aktivity na obrazovke.",
	"home_nav" : "Domov",
    "menu_nav" : "Ponuka",
	
	"nav_topic_txt" : "Ak chcete prejsť na ďalšiu tému v rámci tejto časti, stlačte tlačidlo Ďalej.",
	"nav_section_txt" : "Stlačením tlačidla Ďalej môžete prejsť na ďalšiu tému alebo sa môžete vrátiť na úvodnú stránku stlačením tlačidla Domov.",
	"nav_prebranch_txt" : "Select the Next button to continue to the next topic.",
	"nav_branch_txt" : "Select the Home button to return to the home page.",
	"nav_exit_txt" : "",
	
	"pretest_title" : "Vitajte",
	"pretest_text" : "Ak áno, pripravili sme pre vás výzvu. Ak preukážete, že máte dostatočné znalosti, môžete kurz absolvovať zrýchlene.",
	"pretest_nav_cancel" : "Spustiť kurz",
	"pretest_nav_start" : "Prijať výzvu",
	
	"bookmark_title" : "Pokračovať",
	"bookmark_text" : "Chcete pokračovať tam, kde ste skončili?",
	"bookmark_nav_start" : "Nie",
	"bookmark_nav_resume" : "Áno",
		
	"slide_right" : "Nasledujúca snímka",
	"slide_left" : "Predchádzajúca snímka",
	"slide_progress" : "Panel priebehu snímky",
	
	"complete_arrow" : "Pokračovať",
	"complete_arrow_locked" : "Skôr ako budete môcť pokračovať, dokončite všetky aktivity na obrazovke.",
	
	"topic_start" : "Spustiť časť",
	"topic_locked" : "Téma je uzamknutá",
	
	"topic_not_started" : "Nezačaté",
	"topic_incomplete" : "Nedokončené",
	"topic_complete" : "Dokončené",	
	
	"test_question" : "Otázka",
	"test_of" : "z",
	
	"course_logo" : "Citi Logo",
	"retake_test_button" : "Opakovať test",
	"home_assess_button" : "Home",
	"confirm_attest_button" : "Dokončiť kurz",
    
    "hotspot_close" : "Zavrieť Odhalenie hotspotu"
}

/* Thai th */
document.langStrings_th = {
	
	"transcript_btn" : "บทบรรยาย",
	"submit_btn" : "ส่ง",
	"submit_btn_locked" : "ไม่มีการส่ง",
	"tryagain_btn" : "ลองอีกครั้ง",
	"conf_btn" : "เชื่อมั่น",
	"notconf_btn" : "ไม่เชื่อมั่น",
	
	"close_btn" : "ปิด",
	"print_btn" : "พิมพ์",
	"resource_btn" : "ดูแหล่งข้อมูล",
	"glossary_btn" : "ดูอภิธานศัพท์",
	"lang_btn" : "เปลี่ยนภาษา",
	
	"exit_nav" : "ออกจากหลักสูตร",
	"left_nav" : "ก่อนหน้า",
	"left_nav_locked" : "ไม่มีหน้าก่อนหน้า",
	"right_nav" : "ถัดไป",
	"right_nav_locked" : "ไม่มีหน้าถัดไป",
	"right_btn_locked" : "ก่อนที่คุณจะสามารถดำเนินการต่อได้ โปรดทำการโต้ตอบทั้งหมดในหน้าจอ",
	"home_nav" : "หน้าแรก",
    "menu_nav" : "เมนู",
	
	"nav_topic_txt" : "เลือกปุ่มถัดไป เพื่อไปยังหัวข้อถัดไปภายในส่วนนี้",
	"nav_section_txt" : "เลือกปุ่มถัดไป เพื่อไปยังหัวข้อถัดไป หรือเลือกปุ่มหน้าแรก เพื่อกลับไปยังโฮมเพจ",
	"nav_prebranch_txt" : "Select the Next button to continue to the next topic.",
	"nav_branch_txt" : "Select the Home button to return to the home page.",
	"nav_exit_txt" : "",
	
	"pretest_title" : "ยินดีต้อนรับ",
	"pretest_text" : "ถ้าใช่ เราได้ออกแบบความท้าทายสำหรับคุณ หากคุณพิสูจน์ว่าคุณมีความรู้ คุณสามารถใช้เส้นทางเร่งรัดเพื่อผ่านหลักสูตรได้",
	"pretest_nav_cancel" : "เริ่มหลักสูตร",
	"pretest_nav_start" : "รับความท้าทาย",
	
	"bookmark_title" : "ทำต่อจากที่ค้างไว้",
	"bookmark_text" : "คุณต้องการกลับไปยังหน้าที่คุณทำค้างไว้หรือไม่",
	"bookmark_nav_start" : "ไม่ใช่",
	"bookmark_nav_resume" : "ใช่",
		
	"slide_right" : "สไลด์ถัดไป",
	"slide_left" : "สไลด์ก่อนหน้า",
	"slide_progress" : "แถบความคืบหน้าของสไลด์",
	
	"complete_arrow" : "ดำเนินการต่อ",
	"complete_arrow_locked" : "ก่อนที่คุณจะสามารถดำเนินการต่อได้ โปรดทำการโต้ตอบทั้งหมดในหน้าจอ",
	
	"topic_start" : "เปิดส่วน",
	"topic_locked" : "หัวข้อถูกล็อก",
	
	"topic_not_started" : "ยังไม่เริ่ม",
	"topic_incomplete" : "ไม่สมบูรณ์",
	"topic_complete" : "เสร็จสิ้น",	
	
	"test_question" : "คำถาม",
	"test_of" : "จาก",
		
	"course_logo" : "Citi Logo",
	"retake_test_button" : "ทดสอบอีกครั้ง",
	"home_assess_button" : "Home",
	"confirm_attest_button" : "เสร็จสิ้นการศึกษาหลักสูตร",
    
    "hotspot_close" : "ปิด แสดงฮอตสปอต"
}

/* Turkish tr */
document.langStrings_tr = {
	
	"transcript_btn" : "Transkript",
	"submit_btn" : "Gönder",
	"submit_btn_locked" : "Gönder mevcut değil",
	"tryagain_btn" : "Yeniden Dene",
	"conf_btn" : "Kendinden Emin",
	"notconf_btn" : "Kendinden Emin Değil",
	
	"close_btn" : "Kapat",
	"print_btn" : "Yazdır",
	"resource_btn" : "Kaynakları Görüntüle",
	"glossary_btn" : "Sözlüğü Görüntüle",
	"lang_btn" : "Dili değiştir",
	
	"exit_nav" : "Kurstan Çık",
	"left_nav" : "Geri",
	"left_nav_locked" : "Geri mevcut değil",
	"right_nav" : "İleri",
	"right_nav_locked" : "İleri mevcut değil",
	"right_btn_locked" : "Devam etmeden önce lütfen ekrandaki tüm etkileşimleri tamamlayın.",
	"home_nav" : "Ana Sayfa",
    "menu_nav" : "Menü",
	
	"nav_topic_txt" : "Bu bölümdeki bir sonraki konuya devam etmek için İleri düğmesini seçin.",
	"nav_section_txt" : "Sonraki konuya devam etmek için İleri düğmesini seçin veya ana sayfaya dönmek için Ana Sayfa düğmesini seçin.",
	"nav_prebranch_txt" : "Select the Next button to continue to the next topic.",
	"nav_branch_txt" : "Select the Home button to return to the home page.",
	"nav_exit_txt" : "",
	
	"pretest_title" : "Hoş Geldiniz",
	"pretest_text" : "O zaman sizin için bir meydan okuma hazırladık. Bilgili olduğunuzu kanıtlarsanız kurs boyunca hızlandırılmış yolu seçebilirsiniz.",
	"pretest_nav_cancel" : "Kursu Başlat",
	"pretest_nav_start" : "Meydan Okumayı Kabul Et",
	
	"bookmark_title" : "Devam Et",
	"bookmark_text" : "Kaldığınız yerden devam etmek ister misiniz?",
	"bookmark_nav_start" : "Hayır",
	"bookmark_nav_resume" : "Evet",
		
	"slide_right" : "Sonraki Slayt",
	"slide_left" : "Önceki Slayt",
	"slide_progress" : "Slayt ilerletme çubuğu",
	
	"complete_arrow" : "Devam",
	"complete_arrow_locked" : "Devam etmeden önce lütfen ekrandaki tüm etkileşimleri tamamlayın.",
	
	"topic_start" : "Başlatma Bölümü",
	"topic_locked" : "Konu Kilitli",
	
	"topic_not_started" : "Başlatılmadı",
	"topic_incomplete" : "Tamamlanmadı",
	"topic_complete" : "Tamamlandı",	
	
	"test_question" : "Soru",
	"test_of" : " / ",
	
	"course_logo" : "Citi Logo",
	"retake_test_button" : "Testi Tekrar Et",
	"home_assess_button" : "Home",
	"confirm_attest_button" : "Kursu Tamamla",
    
    "hotspot_close" : "Bağlantı Noktası Gösterimini Kapat"
}

/* Vietnamese vi */
document.langStrings_vi = {
	
	"transcript_btn" : "Bản ghi",
	"submit_btn" : "Gửi",
	"submit_btn_locked" : "Gửi không có sẵn",
	"tryagain_btn" : "Thử lại",
	"conf_btn" : "Chắc chắn",
	"notconf_btn" : "Không Chắc chắn",
	
	"close_btn" : "Đóng",
	"print_btn" : "In",
	"resource_btn" : "Xem Nguồn tài liệu",
	"glossary_btn" : "Xem Bảng thuật ngữ",
	"lang_btn" : "Thay đổi ngôn ngữ",
	
	"exit_nav" : "Thoát khỏi Khóa học",
	"left_nav" : "Trước",
	"left_nav_locked" : "Trước không có sẵn",
	"right_nav" : "Tiếp theo",
	"right_nav_locked" : "Tiếp theo không có sẵn",
	"right_btn_locked" : "Trước khi bạn có thể tiếp tục, vui lòng hoàn thành tất cả các thao tác tương tác trên màn hình.",
	"home_nav" : "Trang chủ",
    "menu_nav" : "Menu",
	
	"nav_topic_txt" : "SChọn nút Tiếp theo để tiếp tục đến với chủ đề tiếp theo trong phần này.",
	"nav_section_txt" : "Chọn nút Tiếp theo để tiếp tục đến với chủ đề tiếp theo hoặc chọn nút Trang chủ để quay lại trang chủ.",
	"nav_prebranch_txt" : "Select the Next button to continue to the next topic.",
	"nav_branch_txt" : "Select the Home button to return to the home page.",
	"nav_exit_txt" : "",
	
	"pretest_title" : "Chào mừng bạn",
	"pretest_text" : "Nếu vậy, chúng tôi đã tạo ra một thử thách cho bạn. Nếu bạn cho chúng tôi thấy bạn có kiến thức, bạn có thể rút ngắn khóa học.",
	"pretest_nav_cancel" : "Bắt đầu Khóa học",
	"pretest_nav_start" : "Tham gia Thử thách",
	
	"bookmark_title" : "Tiếp tục",
	"bookmark_text" : "Bạn có muốn tiếp tục từ phần bạn đã dừng lại không?",
	"bookmark_nav_start" : "Không",
	"bookmark_nav_resume" : "Có",
		
	"slide_right" : "Bản trình chiếu Tiếp theo",
	"slide_left" : "Bản trình chiếu Trước",
	"slide_progress" : "Thanh tiến trình",
	
	"complete_arrow" : "Tiếp tục",
	"complete_arrow_locked" : "Trước khi bạn có thể tiếp tục, vui lòng hoàn thành tất cả các thao tác tương tác trên màn hình.",
	
	"topic_start" : "Phần Khởi chạy",
	"topic_locked" : "Chủ đề Bị khóa",
	
	"topic_not_started" : "Chưa Bắt đầu",
	"topic_incomplete" : "Chưa hoàn thành",
	"topic_complete" : "Hoàn thành",	
	
	"test_question" : "Câu&nbsp;hỏi",
	"test_of" : "/",
	
	"course_logo" : "Citi Logo",
	"retake_test_button" : "Làm lại Bài<br>kiểm tra",
	"home_assess_button" : "Home",
	"confirm_attest_button" : "Hoàn thành Khóa học",
    
    "hotspot_close" : "Đóng Tiết lộ Điểm truy cập"
}