/* variables used for course-specific text */
/* DEV NOTE indicates that the variable should be updated for the course */

$( document ).ready(function() {

	/* DEV NOTE: string for course title */
	document.courseTitle = "Operasyonel Risk Yönetimi Çerçevesi (Operational Risk Management Framework) - Genel Bakış";

	/* DEV NOTE: strings for topic titles which are used in the pre-test results */
	document.topicTitles = {
		titles:[
			{title:"Hoş Geldiniz"},
			{title:"Operasyonel Riski Anlamak"},
			{title:"Operasyonel Risk Yönetimi"},
			{title:"Operasyonel Risk Yönetimi Yaşam Döngüsü"},
			{title:"Sonuç"},
			{title:"Değerlendirme"}
		]
	}	
		
	/* DEV NOTE: string for the intro text on the pre-test message that appears asking the learner if they want to take the pre-test; if there is no pre-test make this an empty string */
	document.pretestIntro = "<strong>Global AML, Yaptırımlar ve Rüşvetle Mücadele</strong> konularını zaten biliyor musunuz?"
	
	/* DEV NOTE: strings for text that is used on the pre-test and post-test intro pages; if there is no pre-test make the pre-test strings empty strings; if there is no post-test make the post-test strings empty strings */
	test_intro_dat = {
		pre_test:[{
			generic_msg:'Teste hoş geldiniz.<br><br>Her soru için bir deneme hakkınız var ve testi tek seferde tamamlamanız gerekmektedir. Testi bırakırsanız kaldığınız yerden devam edemezsiniz ve başarısız sayılırsınız.<br><br>Bir konuyla ilgili tüm soruları doğru cevapladığınızda o konunun \'testinden geçmiş\' olacaksınız ve eğitimin o bölümünü atlamanıza izin verilecek.<br><br>Tüm konularda tam puan alırsanız kursu tamamlamış sayılırsınız.<br><br>Bir konunun \'testinden geçemezseniz\' o içeriği normal şekilde almaya yönlendirilirsiniz. Son testte karşınıza sadece bu konularla ilgili sorular çıkacak.',
			/* DEV NOTE: string below can be used instead when there is a pre-test and there are no topics associated with test questions; otherwise delete */
			/*
			generic_msg:'Teste hoş geldiniz.<br><br>Her soru için bir deneme hakkınız var ve testi tek seferde tamamlamanız gerekmektedir. Bir soruya yanlış cevap vermeniz durumunda kurs içeriğine yönlendirilecek ve teste giremeyeceksiniz. Testten ayrılırsanız kaldığınız yerden devam edemezsiniz ve teste giremezsiniz.<br><br>Tüm konularda tam puan alırsanız kursu tamamlamış sayılırsınız.<br><br>\'Testten geçemezseniz\' kurs içeriğini standart akışında tamamlamaya yönlendirileceksiniz. Son testte tüm konularla ilgili sorular göreceksiniz.<br><br><p class="instruction">Devam etmek için aşağı kaydırın.</p>',
			*/
			title:'Test',
			subtitle:'Test Talimatları'
			
		}],
		post_test:[{
			generic_msg:'<p>Aşağıdaki beş soru size öğrendiklerinizi ne kadar iyi hatırladığınızı gösterme fırsatı verecektir.</p><p>Değerlendirmeyi geçmek için %80 veya daha yüksek puan almanız gerekir.</p><p>Değerlendirmeye başladıktan sonra, puanınızın hesaplanması için tüm soruları tamamlamanız gerekir. Bunu, son sorudan sonraki sonuçlar sayfasında görebilirsiniz.</p>',
			/* DEV NOTE: string below can be used instead when there is a pre-test and there are no topics associated with test questions; otherwise delete */
			/*
			generic_msg:'<p>Aşağıdaki sorular size öğrendiklerinizi ne kadar iyi hatırladığınızı gösterme fırsatı verir.</p><p>Toplam 11 soruyu tamamlamanız gerekecek. Testi geçmek ve bu kursu tamamlamak için en az <strong>%80</strong> almanız gerekir. Teste başladıktan sonra, puan elde etmek için tüm soruları tamamlamanız gerekir. Bunu, son sorudan sonraki sonuçlar sayfasında görebilirsiniz. Testi tamamlamadan çıkarsanız değerlendirmeyi yeniden başlatmanız gerekir.</p><p class="instruction">Devam etmek için aşağı kaydırın.</p>',
			*/
			title:'Değerlendirme Talimatları',
			subtitle:'Değerlendirme Talimatları',
			/* DEV NOTE: strings below can be used instead when there is a pre-test and there are no topics associated with test questions; otherwise delete */
			/*
			title:'Test Talimatları',
			subtitle:''
			*/
			test_complete_title:'Eğitim Tamamlandı',
			test_complete_msg:'<p>Bu eğitim için zaten bir tamamlama onayı aldığınız için nihai değerlendirme gerekli değildir ve sunulmayacaktır. Teşekkürler!</p><p>Çıkış yapmak için ekranın sağ üst köşesindeki X ögesini seçin.</p>'
		}],
		pre_test_nav:[{
			home_only:'Ana sayfaya dönmek için Ana Sayfa düğmesini seçin.'
		}]
	}
	
	/* DEV NOTE: strings for text that is used on the pre-test and post-test results page before the score and for the pass and fail messages; if there is no pre-test make the pre-test strings empty strings; if there is no post-test make the post-test strings empty strings; when there is no limit to the post-test tries, make fail_max_msg an empty string for the post-test section; when there is a pre-test and there are no topics associated with test questions make all strings excluding pass_msg, fail_msg_3 and result_title empty strings for the pre-test section; when there is no requirement to review incorrect questions for a passed post-test, make pass_review_msg, result_review_msg_1, result_review_msg_2 and result_review_msg_3 empty strings for the post_test section. */
	test_results_dat = {
		pre_test:[{
			pass_msg:'Tebrikler Testi başarıyla tamamladınız!',
			/* DEV NOTE: string below can be used instead when there is a pre-test and there are no topics associated with test questions; otherwise delete */
			/*
			pass_msg:'Bravo! Tebrikler. Testi başarıyla tamamladınız! Borç Menkulleri CBNA alım satım kavramlarını iyi kavradığınız anlaşılıyor!<br><br>Eğitim öncesi değerlendirme sorularını geçtiğiniz için eğitimi otomatik olarak atlayacaksınız.<br><br>İçeriği gözden geçirmek isterseniz Ana Sayfa düğmesini seçin. Çıkmak isterseniz eğitimi tamamladığınızı kaydetmek ve kurstan çıkmak için ekranın sağ üst köşesindeki X’i seçin.<br><br>Kaynaklar düğmesini seçerek istediğiniz zaman faydalı bağlantılar listesine ulaşabilirsiniz. Kursa doğrudan internet üzerinden kişisel bir cihazdan (Citi ağının dışında) erişiyorsanız Citi ağı dahilindeki içeriğe yönlendiren bazı bağlantılar çalışmayabilir.',
			*/
			pass_msg_2:'Tebrikler, Testi başarıyla tamamladınız! Aşağıdaki konu testlerinden geçtiniz:',
			pass_msg_3:'Geçti olarak işaretlenen konuyu/konuları atlayabilirsiniz, ancak kalan konuların eğitimini almanız gerekir. Başlamak için lütfen Ana Sayfa düğmesini seçin.<br><br>Bitirdiğinizde kursu tamamlamış olacaksınız. Harika!',	
			pass_msg_4:'Kurs tamamlandı olarak işaretlendi ancak başarılı olarak işaretlenmeyen konuları gözden geçirmek isteyebilirsiniz.',	
			fail_msg_1:'Testi tamamladığınız için teşekkür ederiz. Aşağıdaki işaretlenmiş konu(lar)dan geçtiniz:',
			fail_msg_2:'Global AML, Yaptırımlar ve Rüşvetle Mücadelenin temelleri konularını incelemek için lütfen Ana Sayfa düğmesini seçin. İşaretlenen konuları atlayabilirsiniz ancak işaretlenmemiş konuyu/konuları tamamlamanız gerekir.<br><br>Bitirdiğinizde, kursu tamamlamak için işaretlenmemiş konu(lar)dan sorular içeren Testi geçmelisiniz.',
			fail_msg_3:'Testi tamamladığınız için teşekkür ederiz. Ne yazık ki, herhangi bir konu testinden geçemediniz. Başlamak için lütfen Ana Sayfa düğmesini seçin.',
			/* DEV NOTE: string below can be used instead when there is a pre-test and there are no topics associated with test questions; otherwise delete */
			/*
			fail_msg_3:'Teste girdiğiniz için teşekkür ederiz. Ne yazık ki, testi geçemediniz. Değerlendirmeyi geçmek ve kurs kredisi almak için gereken minimum puanı alamadınız.<br><br>Başlamak için lütfen Ana Sayfa düğmesini seçin.',
			*/
			result_title:'Test Sonuçları'
		}],
		post_test:[{
			generic_msg:'Puanınız: ',
			pass_msg:'Tebrikler!<br><br>Değerlendirmeyi başarıyla geçtiniz.<br><br> Eğitimi tamamladığınızı kaydetmek ve kurstan çıkmak için ekranın sağ üst köşesindeki X’i seçin.',
			/* DEV NOTE: string below can be used instead when there is a pre-test and there are no topics associated with test questions; otherwise delete */
			/*
			pass_msg:'Tebrikler!<br><br>Testi başarıyla geçtiniz.<br><br>Eğitimi tamamladığınızı kaydetmek ve kurstan çıkmak için ekranın sağ üst köşesindeki X’i seçin.',
			*/
			pass_review_msg:'Yanlış yanıt verdiğiniz sorunun doğru yanıtını görmek için aşağı kaydırabilirsiniz.',
			fail_msg:'Ne yazık ki değerlendirmeyi geçemediniz. <br><br>Tekrar denemek için Değerlendirmeyi Tekrar Et düğmesini seçin veya değerlendirmeyi tekrar denemeden önce içeriği gözden geçirmek için Ana Sayfa düğmesini seçin.',
            fail_max_msg:'Ne yazık ki testten üç kez başarısız oldunuz.<br><br>Görünüşe göre kurs içeriğini tekrar gözden geçirmeniz gerekiyor.<br><br>Devam etmek için Kursu Tekrar Et’i seçin.',
			result_title:'Değerlendirme Sonuçları!',
			/* DEV NOTE: string below can be used instead when there is a pre-test and there are no topics associated with test questions; otherwise delete */
			/*
			result_title:'Test Sonuçları'
			*/
			result_review_msg_1:'Soru:',
			result_review_msg_2:'Seçenekler:',
			result_review_msg_3:'Geri bildirim:'
		}]
	}
	
	/* DEV NOTE: strings for text that is used on the attestation page before and after the attesting; if there is no attestation make these empty strings */
	attestation_dat = {		
		attestation:[{
			pre_attesting_msg:'Lütfen onaylayın:<br><br>İsviçre CID Eskalasyon Sürecini okuduğumu ve tamamen anladığımı ve buna her zaman kesinlikle bağlı kalacağımı onaylıyorum.',
			attested_msg:'Onayınız için teşekkürler.<br><br>Tebrikler! Bu eğitimi başarıyla tamamladınız. Artık çıkabilirsiniz. Katılımınız için teşekkürler!'
		}]
	}
	
	/* DEV NOTE: strings for the transcript titles and content separated by section id; if there are no transcripts make this variable an empty array */
	transcript_dat = {
		sec_3:[{
				title:'Alt yazı - Video 1',			
				transcript:'<p></p>'
		}]
	}
	
	/* DEV NOTE: strings for the hotword titles and content separated by hotword id; if there are no hotwords make this variable an empty array */
	hotword_dat = {
		
		hw_1:[{
				title:'Örnek Tetikleyici Kelime',				
				text:'<div class="align_left"><p>Bölüm 23A’daki Karşılığı Olan İşlem tanımı, bir bankanın bir iştirake ve bir bankaya verdiği gerek borcu gerek kredinin uzatılmasını içerir ve bir bankanın bir iştirakin düzenlediği menkul kıymetleri satın almasını veya bu menkul kıymetlere yatırım yapmasını içerir.</p></div>'
		}]
	}
	
	/* DEV NOTE: strings for the link URLs separated by link id; if there are no links make this variable an empty array */
	link_dat = {
		lnk_1:[{
				url:'https://policydirectory.citi.net/cpd/_layouts/15/DocIdRedir.aspx?ID=CPDPROD-13-11999'
		}],
		lnk_2:[{
				url:'https://citi.sharepoint.com/sites/operational-risk-management/SitePages/orm-policy-documents.aspx'
		}],
		lnk_3:[{
				url:'https://policydirectory.citi.net/cpd/_layouts/15/DocIdRedir.aspx?ID=CPDPROD-13-7992&PgId=srch'
		}],
		lnk_4:[{
				url:'https://policydirectory.citi.net/cpd/_layouts/15/DocIdRedir.aspx?ID=CPDPROD-13-6072&PgId=srch'
		}],
		lnk_5:[{
				url:'https://policydirectory.citi.net/cpd/_layouts/15/DocIdRedir.aspx?ID=CPDPROD-13-11723&PgId=srch'
		}],
		lnk_6:[{
				url:'https://citi.sharepoint.com/sites/operational-risk-management/Shared%20Documents/RISK%20Taxonomy.xlsx?web=1'
		}],
		lnk_7:[{
				url:'https://policydirectory.citi.net/cpd/_layouts/15/DocIdRedir.aspx?ID=CPDPROD-13-10875&PgId=srch'
		}]
		
	}
	
	/* DEV NOTE: strings for the resource popup title and content */
	resource_dat = {
		resources:[{
				title:'Kaynaklar',				
				text:'<div class="align_left"><p><a data-lnk-id="lnk_4" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Operational Risk Management Policy</a></p><p><a data-lnk-id="lnk_2" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Operasyonel Risk Yönetimi web sitesi</a></p><p><a data-lnk-id="lnk_1" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Enterprise Risk Management Framework (ERMF)</a></p><p><a data-lnk-id="lnk_3" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Global Issue Management Policy</a></p><p><a data-lnk-id="lnk_6" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Risk Sınıflandırması</a></p><p><a data-lnk-id="lnk_5" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Internal Loss Capture Reporting Central Procedure</a></p><p><a data-lnk-id="lnk_7" class="popup_pop popup_neutral" target="popup" onclick="linkClicked(this,false,false);">Global Lessons Learned Policy</a></p></div>'
		}]
	}

	/* DEV NOTE: strings for LMS errors */
	lms_error_dat = {
		lms_error_1:[{
				text1:'API bulunamadı.',
				text2:'Bağlantı koptu. Lütfen bu eğitim kursunu kapatın ve daha sonra yeniden başlatın.<br>İlerlemeniz veya bitirişiniz izlenmeyeceğinden devam etmeyin.<br>Son kaydedilen noktadan yeniden başlatabileceksiniz.'
        }]		
	}
});