/* variables used for configuration and storing of course data */
/* DEV NOTE indicates that the variable should be updated for the course */

var isiPad;
var isiPhone;
var isWeb;
var isIE;
var isAndroidTablet;
var isAndroidPhone;
var androidApp = false;
var iOSApp = false;
var isIE8 = false;
var	isMob = false;
var isMac = false;
var orient;
var desktop_testing;
var video_location;
var video_data;
var index = true;
var bookmarkInterval = "";

var useAICCRules = false; /* AICC rules - no reference to window.top for cross platform compatibility; no interface close button as it uses window.top.close; minimal commits to LMS */
var startTime = 0; /* integer for the time when the timer was started and if set to 0 means not currently tracking time */
var sessionTime = 0; /* string for the cumulative session time in seconds i.e. the time the course is open. */
var commitTimer = true; /* boolean used for interval set at the beginning of lock.js */

document.lesson_location_retrieved = false; /* boolean has the lesson_location been retrieved */
document.bookmarkNavDone = false; /* boolean has the check for bookmark completed */
document.intComplete = false; /* boolean have the interactions been completed */
document.audioComplete = false; /* boolean has the audio completed */
document.trackingArr = []; /* array to be populated with suspend data from LMS */
document.currentSection; /* integer for current section the user is viewing */
document.attestationAttempted = false; /* boolean for if the attestation has been attempted */
document.pretestAttempted = 0; /* integer where the pre-test has been attempted = 1, the pre-test not attempted = 0 */
document.takingPretest = false; /* boolean for if currently in the pre-test */
document.pretestDone = true; /* boolean for if we are done with the pre-test used to ensure it does not bookmark upon leaving it */
document.pretestThisSession = false; /* boolean for if the pre-test was taken this session to ensure we understand if the score was obtained during it */
document.test_score = 0; /* integer for the score obtained in the pre-test/post-test in points */
document.assessPercentageScore = 0;  /* integer for the score obtained in the pre-test/post-test in percentage */
document.assessAttempted = false; /* boolean has the post-test been attempted */
document.assessRandomQuesArr = []; /* array of section id numbers for the questions in the pre-test/post-test from the first question to the results page */
document.assessStartQuesArr = []; /* array of section id numbers for the first question available for the pre-test/post-test in each bank */
document.assessEndQuesArr = [];	/* array of section id numbers for the last question available for the pre-test/post-test in each bank */
document.assessSelectQuesArr = []; /* array of number of questions to select for the pre-test/post-test from each bank */
document.assessTopicHasQBank = []; /* array of indicators if if a topic has a question bank where topic has a bank = 1, topic does not have a bank = 0 */
document.assessTotalQues = 0; /* integer for the total questions required in the pre-test/post-test */
document.currentAssessQues = 0;	/* integer for the current question in the pre-test/post-test */
document.inlineNumOfAttempts = 0; /* integer which is incremented when trying question again */

/* DEV NOTE: Text Direction to display content. By default set to ltr (LEFT TO RIGHT) for Arabaic, Hebrew and other RTL languages set to rtl (RIGHT TO LEFT) */
document.textDirection = "ltr"

/* DEV NOTE: Is this part of a multisco. Set to true if part of multisco and false if not */
document.isMultiSco = false;

/* DEV NOTE: Does the course contian branches. Set to true if there are, false if not */
document.hasBranches = false;

/* DEV NOTE: Number of braches the course contains */
document.numberOfBranches = 0;

/* DEV NOTE: Number to indicate which branch user selected if branches are present. Set to 0, updated on braching screen */
document.userBranch = 0;

/* DEV NOTE: integer where there is an attestation in the course = 1, there is no attestation = 0 */
document.attestationPresent = 0;

/* DEV NOTE: integer where there is a pre-test in the course = 1, there is no pre-test = 0; set to 0 if there is no post-test or attestation */
document.pretestPresent = 0;

/* DEV NOTE: integer where the pre-test present has no topics associated with questions = 1, otherwise = 0; set to 0 if there is no post-test or attestation */
document.noTopicsAssociatedPretest = 0;

/* DEV NOTE: Does the course contain a pre and post-test with different question banks */
document.diffPrePostTest = true;

/* DEV NOTE: boolean where user has to take the pre-test. User must take pre-test = true, user can skip pre-test = false; set to false if the pre-test with no topics associated with questions or there is no post-test */
document.forcePretest = true;

/* DEV NOTE: integer for total number of topics in the course including pre-test/post-test topic at the end */
document.topicsCount = 6;

/* DEV NOTE: integer for total number of screens from the first Topic Intro to the pre-test/post-test Test Results or last section id of the course inclusive */
document.subsectionCount = 43;

/* DEV NOTE: integer for section id number of the pre-test/post-test Test Intro screen; set to null if there is no post-test */
document.testIntroSubsection = 35;

/* DEV NOTE: section id number of the pre-test/post-test Test Results screen; set to null if there is no post-test */
document.testResultsSubsection = 43;

/* DEV NOTE: string where a topic has been tested out of = 1, a topic has not been tested out of = 0, initially all 0s; set this even if there is no pre-test */
document.topicsPretestedOut = "000000";

/* DEV NOTE: array of count of how many questions were answered correctly for a topic during the pre-test, initially all comma-separated 0s; set this even if there is no pre-test */
document.topicsPretestQuesCorArr = [0,0,0,0,0,0];

/* DEV NOTE: boolean where content pages are locked down = true, content pages are unlocked = false */
document.courseLockedDown = true;

/* DEV NOTE: boolean where the menu is locked down = true, menu is unlocked = false; if there is a pre-test then this must be set to true */
document.menuLockedDown = true;


/* DEV NOTE: boolean where slider is locked on first and last slides, slider locked = true, slider can loop = false */
document.sliderLinear = true;

/* DEV NOTE: boolean where audio locked down = true, audio unlocked = false */
document.audioLocked = true;

/* DEV NOTE: boolean where video locked down = true, video unlocked = false */
document.videoLocked = false;

/* DEV NOTE: boolean to enable or disable transitions within the course, these should not be enabled if the course is to support tablet and/or phone as this support has not yet been tested */
/* Current transitions:
Topics fade in one at a time
Question display text fades in when question is submitted
Expando display grows down on click of expando item
Expando display grows up on click of another expando item
Topic images scale up/down on rollover/out
Hotspot images scale up/down on rollover/out
*/
document.useTransitions = false;

/* DEV NOTE: boolean to enable or disable flipping back of all flip cards, should be set to false if a flip card in the course contains a hotword or link so that it is clickable */
document.allowFlipBack = false;

/* DEV NOTE: boolean to check all pages are viewed as part of the course completion criteria, check pages viewed = true, do not check pages viewed = false, if there is an attestation or pre-test, or when there is no attestation, no pre-test and no post-test this must be set to true */
document.trackPagesViewed = true;

/* DEV NOTE: array where screen locked = 1, screen unlocked = 0; the Menu counts as the first screen */
document.lockedArr = [0, //Menu
					  0,0,0,0,
					  0,0,1,1,1,1,0,0,0,0,
					  0,1,0,0,
					  0,1,1,1,1,0,1,0,1,1,1,0,
					  0,1,0,
					  0,1,1,1,1,1,1,1,0];


/* DEV NOTE: array where screen contains a video, slider, hotspots, hotwords, expando or question = 1, screen is static = 0; the Menu counts as the first screen */
document.intArr = [0, //Menu
				   0,0,0,0,
				   0,0,1,1,1,1,0,0,0,0,
				   0,1,0,0,
				   0,1,1,1,1,0,1,0,1,1,1,0,
				   0,1,0,
				   0,1,1,1,1,1,1,1,0];
				  

/* DEV NOTE: array for number of clickable items in page including hotwords and links for page completion. Slider screens use string "number of click, number of hotwords, number of links" */
/* document.clickArr = [0, //Menu
					0,0,0,
					0,0,0,0,0,0,0,1,1,1,
					0,4,4,4,4,5,"3,0,0",6,
					0,1,1,1,1,1,1,1,1,1,1,0]; */

document.clickArr = [0, //Menu
					 0,0,0,0,
				     0,0,3,4,4,4,0,0,0,0,
				     0,3,0,0,
				     0,2,2,3,3,0,3,0,1,3,3,0,
				     0,3,0,
					 0,1,1,1,1,1,1,1,0];

/* DEV NOTE: array for audio file to play on this screen excluding .mp3 */
document.audioSrcArr = ['',
						'','','','',
						'','','','','','','','','','',
						'','','','',
						'','','','','','','','','','','','',
						'','','',
					    '','','','','','','','',''];
					    

/* DEV NOTE: array where screen contains audio = 1, screen does not contain audio = 0; the Menu counts as the first screen */
document.audioArr = [0, //Menu
					 0,0,0,0,
					 0,0,0,0,0,0,0,0,0,0,
					 0,0,0,0,
					 0,0,0,0,0,0,0,0,0,0,0,0,
					 0,0,0,
					 0,0,0,0,0,0,0,0,0];
					 
/* DEV NOTE: array for number of full screen background image screens in each topic */
document.bgImageArr = [0,0,0,0,0,0];

/* DEV NOTE: array for number of reflection screens in each topic */
document.reflectionsArr = [0,0,0,0,0,0];

/* DEV NOTE: array for number of slider screens in each topic */
document.sliderBGArr = [0,1,0,1,0,0];

/* DEV NOTE: array to indicate which topics have wide menu tiles on the home screen where wide tile = 1, no wide title = 0; only the first topic is supported at this time */
document.wideTileArr = [0,0,0,0,0,0];

/* DEV NOTE: array for number of slider screens with full screen bg image in each topic */
//document.sliderBgImgArr = [0,0,0,0,0,0,0,0,0,0,0];

/* DEV NOTE: boolean for if inline questions should be answered correctly before unlocking the page, i.e. try again is enabled */
document.inlineQuesTryAgain = false;

/* DEV NOTE: integer for maximum number of attempts a user has to answer an inline question before page is unlocked; document.inlineQuesTryAgain must be set to true;  */
document.inlineQuesMaxAttempts = 0;

/* DEV NOTE: integer for post-test passing mark required only i.e. 80; set to 0 if there is an attestation */
document.assessPassmark = 80;

/* DEV NOTE: integer for pre-test passing mark required only i.e. 80; pre-test should always uses 100;  set to 0 if there is an attestation */
document.preTestPassmark = 0;

/* DEV NOTE: randomize the pre-test/post-test questions = true and do not randomize them = false; if a selection of questions from bank(s) is to be made then this must be true */
document.assessRandomize = true;

/* DEV NOTE: randomize the pre-test/post-test question options = true and do not randomize them = false */
document.assessOptRandomize = false;

/* DEV NOTE: show partially correct for inline questions = true and do not show it = false */
document.partial_feedback_inline = true;

/* DEV NOTE: show partially correct for post-test questions = true and do not show it = false; this cannot be used when there is a pre-test and must then be set to false */
document.partial_scoring_assess = false;

/* DEV NOTE: show ticks on correct answers in post-test = true and hide them = false */
document.showAssessTicks = false;

/* DEV NOTE: show feedback on questions in post-test = true and hide it = false; same feedback shown in review on the passed post-test results if enabled; if true then document.showImmediateAssessFeedback should be false */
document.showAssessFeedback = false;

/* DEV NOTE: show immediate feedback on questions in post-test such as That is correct / That is incorrect = true and hide it = false; if true then document.showAssessFeedback should be false */
document.showImmediateAssessFeedback = true;

/* DEV NOTE: show incorrect questions for review on the passed post-test results = true and hide it = false */
document.showAssessResultsReview = true;

/* DEV NOTE: show message on the post-test intro page and do not show the test questions or results if the pre-test or post-test has been passed or the course is "passed" or "completed" in the LMS = true and allow the post-test to be taken unlimitedly; only tested with document.maxAssessAttempts set to 0 = false */
document.showAssessCompleteMsg = true;

/* DEV NOTE: Used to calculate it if the user has reached the maximum number of attempts. Always set to 0 */
document.assessAttempts = 0;

/* DEV NOTE: Maximum number of attempts user has at the post test */
document.maxAssessAttempts = 0;

/* DEV NOTE: boolean where the menu is visible on launch of course = true, content visible on launch = false  */
document.showMenuOnLaunch = true;

/* DEV NOTE: boolean where the scrore is set on the LMS client specific request. default to true  */
document.setScoreToLMS = false;

/* DEV NOTE: boolen to show the footer nav. true = visible, false = hidden. Default = true, set to false for single topic scos*/
document.showFooterNav = true;

/* DEV NOTE: boolen to show the resources button in the header. true = visible, false = hidden. */
document.showResourcesButton = true;




/* inline question data */
inline_ques_dat = {
	
	sec_28:[{ 					/* DEV NOTE: section id for the screen containing the inline question */
			question:'1',		/* DEV NOTE: string for question Number with topic */
			type:'msca', 		/* DEV NOTE: string for type of inline question, either mcsa or mcma */
			ans:'0,1', 			/* DEV NOTE: string where option is correct = 1, option is not correct = 0 */
			user_ans:'0,0', 	/* DEV NOTE: string always of 0s to match the length of the ans */
			topic_num:'4' 		/* DEV NOTE: string for topic containing this inline question */
	}]
	
}

/* pre-test/post-test question data */
post_test_ques_dat = {
	/* DEV NOTE: pre-test/post-test questions MUST be in order of banks, i.e. topic_num 1 questions first, then topic_num 2 questions, etc. */
	sec_36:[{					/* DEV NOTE: section id for the screen containing the pre-test/post-test question */
			question:'1',		/* DEV NOTE: string for number of question in the pre-test/post-test in order */
			type:'mcma', 		/* DEV NOTE: string for type of inline question, either mcsa or mcma */
			ans:'0,1,0,1', 		/* DEV NOTE: string where option is correct = 1, option is not correct = 0 */
			user_ans:'0,0,0,0', 	/* DEV NOTE: string always of 0s to match the length of the ans */
			correct: '0',		/* DEV NOTE: indicates if answered correctly for results page, leave as 0 */
			answered: '0',		/* DEV NOTE: indicates if answered in assessment for results page, leave as 0 */
			topic_num:'6'		/* DEV NOTE: string for topic bank containing this pre-test/post-test question; if there is a pre-test and there are no topics associated with questions then = 1 */
	}],
	sec_37:[{					/* DEV NOTE: section id for the screen containing the pre-test/post-test question */
			question:'2',		/* DEV NOTE: string for number of question in the pre-test/post-test in order */
			type:'mcma', 		/* DEV NOTE: string for type of inline question, either mcsa or mcma */
			ans:'1,0,1,0', 		/* DEV NOTE: string where option is correct = 1, option is not correct = 0 */
			user_ans:'0,0,0,0', 	/* DEV NOTE: string always of 0s to match the length of the ans */
			correct: '0',		/* DEV NOTE: indicates if answered correctly for results page, leave as 0 */
			answered: '0',		/* DEV NOTE: indicates if answered in assessment for results page, leave as 0 */
			topic_num:'6'		/* DEV NOTE: string for topic bank containing this pre-test/post-test question; if there is a pre-test and there are no topics associated with questions then = 1 */
	}],
    sec_38:[{					/* DEV NOTE: section id for the screen containing the pre-test/post-test question */
			question:'3',		/* DEV NOTE: string for number of question in the pre-test/post-test in order */
			type:'mcsa', 		/* DEV NOTE: string for type of inline question, either mcsa or mcma */
			ans:'0,0,1,0', 		/* DEV NOTE: string where option is correct = 1, option is not correct = 0 */
			user_ans:'0,0,0,0', 	/* DEV NOTE: string always of 0s to match the length of the ans */
			correct: '0',		/* DEV NOTE: indicates if answered correctly for results page, leave as 0 */
			answered: '0',		/* DEV NOTE: indicates if answered in assessment for results page, leave as 0 */
			topic_num:'6'		/* DEV NOTE: string for topic bank containing this pre-test/post-test question; if there is a pre-test and there are no topics associated with questions then = 1 */
	}],
    sec_39:[{					/* DEV NOTE: section id for the screen containing the pre-test/post-test question */
			question:'4',		/* DEV NOTE: string for number of question in the pre-test/post-test in order */
			type:'mcma', 		/* DEV NOTE: string for type of inline question, either mcsa or mcma */
			ans:'1,0,1,1,0,1', 		/* DEV NOTE: string where option is correct = 1, option is not correct = 0 */
			user_ans:'0,0,0,0,0,0', 	/* DEV NOTE: string always of 0s to match the length of the ans */
			correct: '0',		/* DEV NOTE: indicates if answered correctly for results page, leave as 0 */
			answered: '0',		/* DEV NOTE: indicates if answered in assessment for results page, leave as 0 */
			topic_num:'6'    	/* DEV NOTE: string for topic bank containing this pre-test/post-test question; if there is a pre-test and there are no topics associated with questions then = 1 */
	}],
    sec_40:[{					/* DEV NOTE: section id for the screen containing the pre-test/post-test question */
			question:'5',		/* DEV NOTE: string for number of question in the pre-test/post-test in order */
			type:'mcma', 		/* DEV NOTE: string for type of inline question, either mcsa or mcma */
			ans:'1,1,0,1,0,1,0', 		/* DEV NOTE: string where option is correct = 1, option is not correct = 0 */
			user_ans:'0,0,0,0,0,0,0', 	/* DEV NOTE: string always of 0s to match the length of the ans */
			correct: '0',		/* DEV NOTE: indicates if answered correctly for results page, leave as 0 */
			answered: '0',		/* DEV NOTE: indicates if answered in assessment for results page, leave as 0 */
			topic_num:'6'		/* DEV NOTE: string for topic bank containing this pre-test/post-test question; if there is a pre-test and there are no topics associated with questions then = 1 */
	}], 
	
    sec_41:[{					/* DEV NOTE: section id for the screen containing the pre-test/post-test question */
			question:'6',		/* DEV NOTE: string for number of question in the pre-test/post-test in order */
			type:'mcma', 		/* DEV NOTE: string for type of inline question, either mcsa or mcma */
			ans:'0,0,0,1,0', 		/* DEV NOTE: string where option is correct = 1, option is not correct = 0 */
			user_ans:'0,0,0,0,0', 	/* DEV NOTE: string always of 0s to match the length of the ans */
			correct: '0',		/* DEV NOTE: indicates if answered correctly for results page, leave as 0 */
			answered: '0',		/* DEV NOTE: indicates if answered in assessment for results page, leave as 0 */
			topic_num:'6'		/* DEV NOTE: string for topic bank containing this pre-test/post-test question; if there is a pre-test and there are no topics associated with questions then = 1 */
	}],
	
    sec_42:[{					/* DEV NOTE: section id for the screen containing the pre-test/post-test question */
			question:'7',		/* DEV NOTE: string for number of question in the pre-test/post-test in order */
			type:'mcma', 		/* DEV NOTE: string for type of inline question, either mcsa or mcma */
			ans:'0,1,1,0,0,1', 		/* DEV NOTE: string where option is correct = 1, option is not correct = 0 */
			user_ans:'0,0,0,0,0,0', 	/* DEV NOTE: string always of 0s to match the length of the ans */
			correct: '0',		/* DEV NOTE: indicates if answered correctly for results page, leave as 0 */
			answered: '0',		/* DEV NOTE: indicates if answered in assessment for results page, leave as 0 */
			topic_num:'6'		/* DEV NOTE: string for topic bank containing this pre-test/post-test question; if there is a pre-test and there are no topics associated with questions then = 1 */
	}],
	test_dat:[{
			/* DEV NOTE: string for first pre-test/post-test question section id number for each bank; use 0 if there is no question bank for a topic including the test topic; if there is no pre-test, there can be only one bank if needed and the string can contain only the first question section id number; if there is a pre-test and no topics are associated with questions, the first topic has the first pre-test/post-test question section id number for the one bank and the the rest of the topics are = 0 */
			start_section_num:'36', // all questions
			//start_section_num:'24,28,30,32', // random draw
			/* DEV NOTE: string for last pre-test/post-test question section id number for each bank; use 0 if there is no question bank for a topic including the test topic; if there is no pre-test, there can be only one bank if needed and the string can contain only the last question section id number; if there is a pre-test and no topics are associated with questions, the first topic has the last pre-test/post-test question section id number for the one bank and the the rest of the topics are = 0 */
			end_section_num:'42', // all questions
			//end_section_num:'27,29,31,33', // random draw
			/* DEV NOTE: string for number of questions to select for the pre-test/post-test from each bank; use 0 if there is no question bank for a topic including the test topic; if there is no pre-test, there can be only one bank if needed and the string can contain the selection of questions for that bank; if there is a pre-test and no topics are associated with questions, the first topic has the number of questions to select for the pre-test/post-test for the one bank and the the rest of the topics are = 0; */
			select_ques:'5', // all questions
			//select_ques:'2,1,1,1', // random draw
			/* DEV NOTE: string for if a topic has a question bank where topic has a bank = 1, topic does not have a bank and is not required to be viewed = 0, topic does not have a bank but is required to be viewed = 2, topic does not have a bank but is required to be viewed only if learner does not pre-test out = 3, test topic is always = 0; if there is no pre-test, there can be only one bank if needed and the string can contain just 1; if there is a pre-test and no topics are associated with questions, only the first topic is = 1 and the the rest of the topics are = 0 */
			topic_has_qbank:'1',
			user_score:'0',	/* string for user score obtained during the pre-test/post-test */

			/* DEV NOTE: if no topic-level or course-level pre-test or there is a course-level pre-test but it uses the same banks as the post-test then use this first option */
			pre_start_sec_num: '',
			pre_end_sec_num: '',
			topic_pre_qbank: '',
			pre_sel_ques: ''
			
			/* DEV NOTE: if there is a course-level pre-test but it uses different banks than the post-test then use this second option */			
			/* DEV NOTE: string for first pre-test/post-test question section id number for each bank; use 0 if there is no question bank for a topic including the test topic; if there is no pre-test, there can be only one bank if needed and the string can contain only the first question section id number; if there is a pre-test and no topics are associated with questions, the first topic has the first pre-test/post-test question section id number for the one bank and the the rest of the topics are = 0 */
			//pre_start_sec_num: '0,0,49,0,58,0,0',
			/* DEV NOTE: string for last pre-test/post-test question section id number for each bank; use 0 if there is no question bank for a topic including the test topic; if there is no pre-test, there can be only one bank if needed and the string can contain only the last question section id number; if there is a pre-test and no topics are associated with questions, the first topic has the last pre-test/post-test question section id number for the one bank and the the rest of the topics are = 0 */
			//pre_end_sec_num: '0,0,53,0,65,0,0',
			/* DEV NOTE: string for if a topic has a question bank where topic has a bank = 1, topic does not have a bank and is not required to be viewed = 0, topic does not have a bank but is required to be viewed = 2, topic does not have a bank but is required to be viewed only if learner does not pre-test out = 3, test topic is always = 0; if there is no pre-test, there can be only one bank if needed and the string can contain just 1; if there is a pre-test and no topics are associated with questions, only the first topic is = 1 and the the rest of the topics are = 0 */
			//topic_pre_qbank: '2,2,1,2,1,2,0',
			/* DEV NOTE: string for number of questions to select for the pre-test/post-test from each bank; use 0 if there is no question bank for a topic including the test topic; if there is no pre-test, there can be only one bank if needed and the string can contain the selection of questions for that bank; if there is a pre-test and no topics are associated with questions, the first topic has the number of questions to select for the pre-test/post-test for the one bank and the the rest of the topics are = 0; */
			//pre_sel_ques: '0,0,5,0,8,0,0'
	}]
}


/* topic test out question data */
/* DEV NOTE: if not using the topic-level pre-test then these should be reduced to placeholders and test_dat values should be assigned to '0' */
topic_pre_ques_dat = {
	sec_6:[{ 					/* DEV NOTE: section id for the screen containing the inline question */
			question:'1',
			type:'mcsa', 		/* DEV NOTE: string for type of inline question, either mcsa or mcma */
			ans:'1,0', 		/* DEV NOTE: string where option is correct = 1, option is not correct = 0 */
			user_ans:'0,0', 	/* DEV NOTE: string always of 0s to match the length of the ans */
			topic_num:'2' 		/* DEV NOTE: string for topic containing this inline question */
	}],
	test_dat:[{
			// DEV NOTE: string for first pre-test/post-test question section id number for each bank; use 0 if there is no question bank for a topic including the test topic; if there is no pre-test, there can be only one bank if needed and the string can contain only the first question section id number	DO NOT INCLUDE Summary section/topic	
			pre_start_sec_num: '0', 
			// DEV NOTE: string for last pre-test/post-test question section id number for each bank; use 0 if there is no question bank for a topic including the test topic; if there is no pre-test, there can be only one bank if needed and the string can contain only the last question section id number DO NOT INCLUDE Summary section/topic	
			pre_end_sec_num: '0', 
			// DEV NOTE: string for if a topic has a question bank where topic has a bank = 1, topic does not have a bank and is not required to be viewed = 0 DO NOT INCLUDE Summary section/topic
			topic_pre_qbank: '0', 
			// DEV NOTE: string for number of questions to select for the pre-test/post-test from each bank; use 0 if there is no question bank for a topic including the test topic; if there is no pre-test, there can be only one bank if needed and the string can contain the selection of questions for that bank  DO NOT INCLUDE Summary section/topic
			pre_sel_ques: '0',
			// DEV NOTE: number of questions user required to get correct to pass topic test. document.topicPrePassMark must be set to null to use this feature. DO NOT INCLUDE Summary section/topic
			num_corr_ques: '0'
	}]
}


document.topicPreTest = false; // DEV NOTE: Does the course contain test-outs at the topic/section level

document.randomizeTopicPreTest =  false; // DEV NOTE: Radomoise the topic test-out questions

document.currentTopic = 0; // DEV NOTE: The current topic the user is viewing. Set to 0 by default

document.takeTopicPreTest = false; // DEV NOTE: Boolean to indicate is user is taking topic test-out. Set to false as default

document.skipTopicTest = false; // DEV NOTE: Boolean to indicate is user has skipped topic test-out. Set to false as default

document.currentPreQues = 0; // DEV NOTE: The current topic test-out question the user is viewing. Set to 0 as default

document.lastPreQues = false; // DEV NOTE: Boolean to indicate is user is on the last question in topic test-out. Set to false as default

document.topicPrePassMark = 100; // DEV NOTE: The pass score for all topic test-outs. If using individual number of questions for each topic set to null.

//document.topicPreScores = [];

document.topic_test_score = 0; // DEV NOTE: topic test-out score incremented when answering a question. Set to default 0.

document.topicTestAttempted = "000000"; // DEV NOTE: sting containg 0 for each topic in the course, used to indicate whether user has taken or skipped topic test-out; update even if the topic-level pre-test is not used */

document.answeredCorrect = false; // DEV NOTE: Boolean to flag if user answers question correctly set to false.

document.sendInteractions = false; // DEV NOTE: Boolean on whether cmi.interactions should be sent to record question data

document.optionsArr = []; // DEV NOTE: Empty array populated with question options for sending to the cmi.interactions

document.questStem = ""; // DEV NOTE: Empty sting populated with question stem for sending to the cmi.interactions

document.nextSection = 0; // DEV NOTE: Variable which is used to animated to next section. Set to 0 as default

document.autoFailTopicTest = true; // DEV NOTE: Boolean to flag if the user fails the test-out when answering 1 question wrong. 

document.sectionCompleted = "000000"; // DEV NOTE: sting containg 0 for each section in the course, used to indicate whether user has completed sections; update even if the topic-level pre-test is not used */

document.trackSections = true; // DEV NOTE: track sections for menu

document.summarySection = null; // DEV NOTE: number to indicate the start of the summarySection

//document.nextScreen = 0;

//document.endOfSection = 0; // DEV NOTE: 

/* javascript files to be loaded for the course */
defaultFileArray = new Array(
	['js/screen_detection.js','true']
);
requiredFileArray = new Array(
	['js/jquery.mobile.custom.js','!isWeb'],
	['js/jquery-ui.js','true'],
	['js/lock.js','true'],
	['js/course_strings.js','true'],
	['js/lang_strings.js','true'],
	['js/index_vid_full.js','true'],
	['js/mobile.js','true'],
	['js/video.js','true'],
	//['js/audio.js','true'],
	['js/topic_nav.js','true'],
	['js/scroll_activity.js','true'],
	['js/sliders.js','true'],
	['js/icon.js','true'],
	['js/image_cd.js','true'],
	['js/image_hotspot_v1.js','true'],
	['js/image_hotspot_v2.js','true'],
	['js/image_4_cd.js','true'],
	['js/tab_cd.js','true'],
	['js/flip_card.js','true'],
	['js/box.js','true'],
	['js/hotword.js','true'],
	['js/expando.js','true'],
	['js/question.js','true'],
	['js/imported.js','true'],
	['js/tracking_settings.js','true'],
	['js/tracking.js','true'],
	['js/lms/scorm_1_2.js','true'],	
	//['js/lms/scorm_2004.js','true'],	
	['js/transitions.js','true'],
	['js/topic_pre_test.js','true'],
	['js/branching.js','true'],
	['js/start.js','true']
);
