/* functions to initiate the course */

$(document).ready(function() {

	BrowserDetect.init();
	/*resizeWindow();*/
	
	if((typeof console)=="undefined"){
		console = new Object();	
		console.log = function(arg){ 
		}
	}
	
	/* 20221130 Update to language selection and bookmark functionality */
	//LMSAPI = parent.document.scormAPI; //actionsGetAPI();
	
	courseInit();
	lockNav();
	setupClickableOptions();  
	interfaceStrings();
	setMenuTabIndex();
	setTabIndex(); /* set up the tab index for course */
	
	//setUpAudio(); /* setup audio functionality */	
	//setUpVids();
	
	$(".section").attr('data-clicked',0); 
	$(".section").attr('data-animated',0);
	
	
	$(".slider_container").attr('data-height',0); 
	//$(".section").attr('data-links',0); 
	//$(".section").attr('data-hotwords',0);	
	document.randomizeAssessment();	
	
	//if(document.topicPreTest){
		
	document.randomizePreQuestions();
	//}
	
	
	/*if(isiPhone || isAndroidPhone || isAndroidTablet){
		var elementsToShow = document.querySelectorAll('.animation-element');
		elementsToShow.forEach(function (element) {
			element.classList.add('in-view');
		});
	}*/
	
	if(os == "iOS" || os == "Android"){
		var elementsToShow = document.querySelectorAll('.animation-element');
		elementsToShow.forEach(function (element) {
			element.classList.add('in-view');
		});
		
		$('.video_poster').css('display','none');
		
		$(".section").removeClass("decal_left");
	}
	if(isMac){
		$('.video_poster').css('display','none');
	}
	
	//rePosHotSpots();
	
	setRTL();
})

/* setTabIndex function to assign reset and assign tab index for each section */

var navTabCnt; /* 20180501 Accessibility Update */
var tempNavCnt;
function removeMenuTabIndex(){ // remove menu tab funcitonality
	
	/* 20240130 accessibility 2024 */
	$('.menu_btn_title').attr('tabindex', -1);
	$('.menu_btn_title').attr('aria-hidden', true);

	$('.topic_index').find('.topic_select').each(function(index, element) {
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
    });
	
	$('.topic_index').find('.content_text').each(function(index, element) {
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
    	// 202210 QA Tabbing fix
    	$(this).find('a').each(function(index, element) {
  			$(this).attr('tabindex', -1);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', true);
  		});
   
    
    });
	
	$('.topic_index').find('.h1_inner').each(function(index, element) {
     
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
    });
	
	$('.topic_index').find('.home').each(function(index, element) {
     
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
    });
	
	// 20221018 QA fix for tabbing to buttons when resource/hotword popup visible
	$('.topic_index').find('.switchLang').each(function(index, element) {
     
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
    });
	
	$('.topic_index').find('.page').each(function(index, element) {
     
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
    });
    
    $('.topic_index').find('.bar_close').each(function(index, element) {
     
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
    });
	/* Progress Indicator 2023 -- */
	$(".index_progress").attr('tabindex', -1);
	$(".index_progress").attr('aria-hidden', true);
	/* -- Progress Indicator 2023 */
    
    tempNavCnt = 0;
	
	/* client learning design specs 2025 v4.3 */
	$('.bar_robot').find('.index_course_title').each(function(index, element) {
		$(this).attr('tabindex', 1);
		$(this).attr('aria-hidden', false);		
    });
	
	$('.bar_robot').find('.home').each(function(index, element) {
     
        //tempNavCnt++;
		$(this).attr('tabindex', 2); /* client learning design specs 2025 v4.3 */
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
	
	$('.bar_robot').find('.switchLang').each(function(index, element) {
     
        //tempNavCnt++;
		$(this).attr('tabindex', 3); /* client learning design specs 2025 v4.3 */
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
    
	$('.bar_robot').find('.page').each(function(index, element) {
     
        //tempNavCnt++;
		$(this).attr('tabindex', 4); /* client learning design specs 2025 v4.3 */
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
    $('.bar_robot').find('.bar_close').each(function(index, element) {
     
        //tempNavCnt++;
		$(this).attr('tabindex', 5); /* client learning design specs 2025 v4.3 */
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
    
	/* Progress Indicator 2023 -- */
    $(".course_progress").attr('tabindex', 6); /* client learning design specs 2025 v4.3 */
	$(".course_progress").attr('aria-hidden', false);
	$(".index_progress").attr('tabindex', -1);
	$(".index_progress").attr('aria-hidden', true);
	/* -- Progress Indicator 2023 */

	/* 20240130 accessibility 2024 */
	$('.courseTitle').attr('tabindex', -1);
	$('.courseTitle').attr('aria-hidden', true);
}


/* 20180501 Accessibility Update */
function setMenuTabIndex(){
	
	var tabCnt = 0;
	
	/* client learning design specs 2025 v4.3 */
	$('.bar_robot').find('.index_course_title').each(function(index, element) {     
        $(this).attr('tabindex', -1);
		$(this).attr('aria-hidden', true);		
    });
	
	$('.bar_robot').find('.home').each(function(index, element) {
     
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
    });
	
	$('.bar_robot').find('.switchLang').each(function(index, element) {
     
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
    });
    
	/* 20221021 ensure burger menu window is focused on and cannot be tabbed out of */	
	
	/* 120723 arrow up/down issue: using these keys will pick up on the divider line on Win 10 Chrome */
	$('.burger_index').find('.burger_line').attr('tabindex', -1);
    $('.burger_index').find('.burger_line').attr('aria-hidden', true);

	/* 20240130 accessibility 2024 */
	$('.burger_index').find('.burger_close').attr('tabindex', -1);
	$('.burger_index').find('.burger_close').attr('aria-hidden', true);
	
	$('.burger_index').find('.burger_home').attr('tabindex', -1);
    $('.burger_index').find('.burger_home').attr('aria-hidden', true);
	
    $('.burger_index').find('.burger_select').each(function(index, element) {             
		$(this).attr('tabindex', -1);
		$(this).attr('aria-hidden', true);
    });
	
	/* 20240130 accessibility 2024 */
	$('.burger_index').find('.bur_sec_title').attr('tabindex', -1);
	$('.burger_index').find('.bur_sec_title').attr('aria-hidden', true);
	
	$('.burger_index').find('.burger_top_btn').attr('tabindex', -1);
	$('.burger_index').find('.burger_top_btn').attr('aria-hidden', true);

	$('.bar_robot').find('.page').each(function(index, element) {
     
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
    });
    
    $('.bar_robot').find('.bar_close').each(function(index, element) {
     
		$(this).attr('tabindex', -1);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', true);
		
    });
	/* Progress Indicator 2023 -- */
	$(".course_progress").attr('tabindex', -1);
	$(".course_progress").attr('aria-hidden', true);
	/* -- Progress Indicator 2023 */	
	
	$('.topic_index').find('.home').each(function(index, element) {
     
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
	$('.topic_index').find('.switchLang').each(function(index, element) {
     
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
	
	$('.topic_index').find('.page').each(function(index, element) {
     
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
    
    $('.topic_index').find('.bar_close').each(function(index, element) {
     
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
	/* Progress Indicator 2023 -- */
	tabCnt++;
	$(".index_progress").attr('tabindex', tabCnt);
	$(".index_progress").attr('aria-hidden', false);
	/* -- Progress Indicator 2023 */
	
	/* 20240130 accessibility 2024 */
	tabCnt++;
	$('.courseTitle').attr('tabindex', tabCnt++);
	$('.courseTitle').attr('aria-hidden', false);

	$('.topic_index').find('.h1_inner').each(function(index, element) {
      
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
	
	$('.topic_index').find('.content_text').each(function(index, element) {
      
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		// 202210 QA Tabbing fix
  		$(this).find('a').each(function(index, element) {
  			tabCnt++;
  			$(this).attr('tabindex', tabCnt);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', false);
  		});
		
    });

	$('.topic_index').find('.home-copyright').find('.content_text').each(function(index, element) {
      
		$(this).attr('tabindex', -1);
		/* 20240130 accessibility 2024 */
		$(this).attr('aria-hidden', true);
		
    });

	/* 20240130 accessibility 2024 */
	tabCnt++;
	$('.menu_btn_title').attr('tabindex', tabCnt);
	$('.menu_btn_title').attr('aria-hidden', false);

	$('.topic_index').find('.topic_select').each(function(index, element) {
      
		tabCnt++;
		$(this).attr('tabindex', tabCnt);
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });

}

function setBurgerTabIndex(){
    
	// 20221018 QA fix for tabbing to buttons when resource/hotword popup visible
	if($(".topic_index").is(":visible")){
		removeMenuTabIndex();
		$('.topic_index').find('.home').each(function(index, element) {
     
			$(this).attr('tabindex', -1);
			/* 2022 Accessibility Update */
			$(this).attr('aria-hidden', true);

		});

		// 20221018 QA fix for tabbing to buttons when resource/hotword popup visible
		$('.topic_index').find('.switchLang').each(function(index, element) {

			$(this).attr('tabindex', -1);
			/* 2022 Accessibility Update */
			$(this).attr('aria-hidden', true);

		});

		$('.topic_index').find('.page').each(function(index, element) {

			$(this).attr('tabindex', -1);
			/* 2022 Accessibility Update */
			$(this).attr('aria-hidden', true);

		});

		$('.topic_index').find('.bar_close').each(function(index, element) {

			$(this).attr('tabindex', -1);
			/* 2022 Accessibility Update */
			$(this).attr('aria-hidden', true);

		});
		
		/* client learning design specs 2025 v4.3 */
		$('.bar_robot').find('.index_course_title').each(function(index, element) {     
			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);		
		});
		
		$('.bar_robot').find('.home').each(function(index, element) {

			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
		});
		$('.bar_robot').find('.switchLang').each(function(index, element) {

			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
		});
		$('.bar_robot').find('.page').each(function(index, element) {

			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
		});
		$('.bar_robot').find('.bar_close').each(function(index, element) {

			$(this).attr('tabindex', -1);	
			$(this).attr('aria-hidden', true);
		});
		/* Progress Indicator 2023 -- */
		$(".course_progress").attr('tabindex', -1);
		$(".course_progress").attr('aria-hidden', true);
		/* -- Progress Indicator 2023 */
		
	}else{	
			
		/* client learning design specs 2025 v4.3 */
		$('.bar_robot').find('.index_course_title').each(function(index, element) {     
			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);		
		});
		
		$('.bar_robot').find('.home').each(function(index, element) {

			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
		});
		$('.bar_robot').find('.switchLang').each(function(index, element) {

			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
		});
		$('.bar_robot').find('.page').each(function(index, element) {

			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
		});
		$('.bar_robot').find('.bar_close').each(function(index, element) {

			$(this).attr('tabindex', -1);	
			$(this).attr('aria-hidden', true);
		});
		
		/* Progress Indicator 2023 -- */
		$(".course_progress").attr('tabindex', -1);
		$(".course_progress").attr('aria-hidden', true);
		/* -- Progress Indicator 2023 */	
	}
	// 20221018 QA fix for tabbing to buttons when resource/hotword popup visible

    tempNavCnt = 0;
	
	/*$('.bar_robot').find('.home').each(function(index, element) {
     
        tempNavCnt++;
		$(this).attr('tabindex', tempNavCnt);
		// 2022 Accessibility Update 
		$(this).attr('aria-hidden', false);
		
    });*/
	
	/* 20221021 ensure burger menu window is focused on and cannot be tabbed out of */
	
	/* 20240130 accessibility 2024 */
	tempNavCnt++;
	$('.burger_index').find('.burger_close').attr('tabindex', tempNavCnt);
	$('.burger_index').find('.burger_close').attr('aria-hidden', false);
	
	tempNavCnt++;
    $('.burger_index').find('.burger_home').attr('tabindex', tempNavCnt);
    $('.burger_index').find('.burger_home').attr('aria-hidden', false);

	/* 20240130 accessibility 2024 */
	tempNavCnt++;
	$('.burger_index').find('.bur_sec_title').attr('tabindex', tempNavCnt);
	$('.burger_index').find('.bur_sec_title').attr('aria-hidden', false);
	
    $('.burger_index').find('.burger_select').each(function(index, element) {
        tempNavCnt++;
		$(this).attr('tabindex', tempNavCnt);
		$(this).attr('aria-hidden', false);
    });

	/* 20240130 accessibility 2024 */
	tempNavCnt++;
	$('.burger_index').find('.burger_top_btn').attr('tabindex', tempNavCnt);
	$('.burger_index').find('.burger_top_btn').attr('aria-hidden', false);


	/*$('.bar_robot').find('.page').each(function(index, element) {
     
        tempNavCnt++;
		$(this).attr('tabindex', tempNavCnt);
		
    });
    $('.bar_robot').find('.bar_close').each(function(index, element) {
     
        tempNavCnt++;
		$(this).attr('tabindex', tempNavCnt);
		
    });*/
    
}

function removerBurgerTabIndex(){
    
    /* 20221021 ensure burger menu window is focused on and cannot be tabbed out of */	
	
	/* 20240130 accessibility 2024 */
	$('.burger_index').find('.burger_close').attr('tabindex', -1);
	$('.burger_index').find('.burger_close').attr('aria-hidden', true);
	
	$('.burger_index').find('.burger_home').attr('tabindex', -1);
    $('.burger_index').find('.burger_home').attr('aria-hidden', true);
	
	/* 20240130 accessibility 2024 */
	$('.burger_index').find('.bur_sec_title').attr('tabindex', -1);
	$('.burger_index').find('.bur_sec_title').attr('aria-hidden', true);
	
	/* 20240130 accessibility 2024 */
	$('.burger_index').find('.burger_top_btn').attr('tabindex', -1);
	$('.burger_index').find('.burger_top_btn').attr('aria-hidden', true);
	
    $('.burger_index').find('.burger_select').each(function(index, element) {             
		$(this).attr('tabindex', -1);
		$(this).attr('aria-hidden', true);
    });
	
	/* client learning design specs 2025 v4.3 */
	$('.bar_robot').find('.index_course_title').each(function(index, element) {
		$(this).attr('tabindex', 1);
		$(this).attr('aria-hidden', false);		
    });

    $('.bar_robot').find('.home').each(function(index, element) {
        
		$(this).attr('tabindex', 2); /* client learning design specs 2025 v4.3 */
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
    });
    $('.bar_robot').find('.switchLang').each(function(index, element) {
     
		$(this).attr('tabindex', 3); /* client learning design specs 2025 v4.3 */
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
    $('.bar_robot').find('.page').each(function(index, element) {
     
		$(this).attr('tabindex', 4); /* client learning design specs 2025 v4.3 */
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });
    $('.bar_robot').find('.bar_close').each(function(index, element) {

		$(this).attr('tabindex', 5); /* client learning design specs 2025 v4.3 */
		/* 2022 Accessibility Update */
		$(this).attr('aria-hidden', false);
		
    });

	/* Progress Indicator 2023 -- */
	$(".course_progress").attr('tabindex', 6); /* client learning design specs 2025 v4.3 */
	$(".course_progress").attr('aria-hidden', false);
	/* -- Progress Indicator 2023 */

    setTabIndex();
}


/* 20180501 Accessibility Update */
function setTabIndex(sec){	
		
	$('.home').attr('role','button');
	$('.switchLang').attr('role','button');
	$('.page').attr('role','button');
	$('.bar_close').attr('role','button');
		  
	$('.topic_nav').attr('role','button');
	
	$('.box_closer').attr('role', 'button');
	
	/* 20221021 ensure burger menu window is focused on and cannot be tabbed out of */
	$('.burger_close').attr('role', 'button');
	
	/* apply tabindex */
	/* Progress Indicator 2023 */
	var tabCnt = 5;		// 20221018 QA fix for tabbing to buttons when resource/hotword popup visible
	

	
	$('.sec_rest_wrapper').find('.section').each(function(index, element) {
		
	
		
		$(this).find('.h2_inner').each(function(index, element) { /* 20180501 Accessibility Update */
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', false);
		});
		
		$(this).find('.content_text').each(function(index, element) { /* 20180501 Accessibility Update */
			/* 20221020 ensure tab order of text content after activity is following activity */
			if (!$(this).hasClass('content_text_after_activity'))
			{
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				/* 20240130 accessibility 2024 */
				$(this).attr('aria-hidden', false);
				/* 20221021 ensure links within main content are tabbed to after the content */
				$(this).find('a').each(function(index, element) {
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					/* 20240130 accessibility 2024 */
					$(this).attr('aria-hidden', false);
				});
				
				/* 20221107 Accessibility fix to apply tab order if image only has alt text */
				$(this).find('img').each(function(index, element) {
					if ($(this).attr('alt') != ''){
						tabCnt++;
						$(this).attr('tabindex', tabCnt);
						/* 20240130 accessibility 2024 */
						$(this).attr('aria-hidden', false);
					}
					if ($(this).parent().hasClass('adaptive_img'))
					{
//						$(this).parent().parent().attr('tabindex', -1);
						//20221213 fix for adpative image to be table and div containg image content read out
						tabCnt++;
						$(this).parent().parent().attr('tabindex', tabCnt);
						/* 20240130 accessibility 2024 */
						$(this).parent().parent().attr('aria-hidden', false);
					}
				});
			}
		});

		/* 20221107 Accessibility fix to apply tab order if image only has alt text */
		$(this).find('img').each(function(index, element) {
			if (!$(this).parent().hasClass('adaptive_img'))
			{
				if ($(this).attr('alt') != ''){
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					/* 20240130 accessibility 2024 */
					$(this).attr('aria-hidden', false);
				}
			}
		});

		/* client learning design specs 2025 v4.3 */
		/* 20240319 pre-test that appears after first topic */
		$(this).find('.pretest_nav_start').each(function(index, element) {
			$(this).attr('role','button');
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			$(this).attr('aria-hidden', false);
		});

		/* client learning design specs 2025 v4.3 */
		/* 20240319 pre-test that appears after first topic */
		$(this).find('.pretest_nav_cancel').each(function(index, element) {
			$(this).attr('role','button');
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			$(this).attr('aria-hidden', false);
		});

		/* 20180501 Accessibility Update */
		$(this).find('.expando_btn').each(function(index, element) {
			$(this).attr('role','button'); /* 20180501 Accessibility Update */
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', false);
			
			$(this).next('.expando_reveal').each(function(index, element){
			 
									 
				
				$(this).find('.expando_reveal_heading').each(function(index, element) {
					$(this).attr('role','button'); /* 20180501 Accessibility Update */
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					/* 20240130 accessibility 2024 */
					$(this).attr('aria-hidden', false);
				});
				
				$(this).find('.expando_reveal_content').each(function(index, element) {	
					
					/* 20240130 accessibility 2024 */
					tabCnt++;
					$(this).find('.exp_start').attr('tabindex', tabCnt);
					$(this).find('.exp_start').attr('aria-hidden', false);
					
					/* 20240130 accessibility 2024 */
					tabCnt++;
					$(this).find('.exp_rest').attr('tabindex', tabCnt);
					$(this).find('.exp_rest').attr('aria-hidden', false);

					$(this).find('a').each(function(index, element) {
						tabCnt++;
						$(this).attr('tabindex', tabCnt);
						/* 20240130 accessibility 2024 */
						$(this).attr('aria-hidden', false);
					});
					
					/* 20220630 Accessibility fix to apply tan order if image only has atl text */
					$(this).find('img').each(function(index, element) {
						if ($(this).attr('alt') != ''){
							tabCnt++;
							$(this).attr('tabindex', tabCnt);
							/* 20240130 accessibility 2024 */
							$(this).attr('aria-hidden', false);
						}
					});

				});

				
			});
			
			
		});	
			
		
		/* apply tabindex to video */

		/* 20240130 accessibility 2024 */
		$(this).find('.intro_video_vid').each(function(index, element) {
			$(this).attr('aria-hidden', true);
		});

		$(this).find('.video_poster').each(function(index, element) {
			$(this).attr('role','button');
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', false);
		});	
			
		$(this).find('.video_player').each(function(index, element) {	
			tabCnt++;			
			/* 20231030 video accessibility */
			$(this).attr('data-tab', tabCnt);
			$(this).attr('tabindex', tabCnt);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', false);
		});	
		$(this).find('.transcript_btn').each(function(index, element) {	
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', false);
		});	
		/* apply tabindex to questions */	
        $(this).find('.qItemFirst').each(function(index, element) {
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			$(this).attr("aria-hidden", false);
			/* 20220628 JAWS fix to stop item being read when course launches */
		});
        
		$(this).find('.squaredBox').each(function(index, element) {
			
			
			var labelTxt;
			
			$(this).find('.labelTxt').each(function(index, element) {
				
				labelTxt = $(this).html();
				
			});
			
			$(this).attr('title', labelTxt)
			
		});
				
		$(this).find('.mc_btn').each(function(index, element) {
            $(this).attr('tabindex', -1);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', true);
        });
		
		$(this).find('.dropDown').each(function(index, element) {
			$(this).find('label').each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				/* 20240130 accessibility 2024 */
				$(this).attr('aria-hidden', false);
			});
			$(this).find('select').each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				/* 20240130 accessibility 2024 */
				$(this).attr('aria-hidden', false);
			});
        });
		
		
		
		$(this).find('.submit_btn').each(function(index, element) {	
			$(this).attr('role','button'); /* 20180501 Accessibility Update */
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', false);
		});	
		
		/* 20240130 accessibility 2024 */
		$(this).find('.feedback_start').each(function(index, element) {
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			$(this).attr('aria-hidden', false);
			
			$(this).find('a').each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				$(this).attr('aria-hidden', false);
			});
		});

		/* 20240130 accessibility 2024 */
		$(this).find('.feedback_rest').each(function(index, element) {
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			$(this).attr('aria-hidden', false);
			
			$(this).find('a').each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				$(this).attr('aria-hidden', false);
			});
		});
		
		// 20221013 JAWS fix
		$(this).find('.results_review_text').each(function(index, element) {
			
			//20221025 JAWS fix to stop duplicate read out when assess results review is not present
			if(document.showAssessResultsReview){
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				/* 20240130 accessibility 2024 */
				$(this).attr('aria-hidden', false);
			}
		});
		
		$(this).find('.retake_assess_btn').each(function(index, element) {	
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', false);
		});
		
		/* client learning design specs 2025 v4.3 */
		/* 20240130 accessibility 2024 */
		/*if (document.noTopicsAssociatedPretest)
		{*/
			/* client learning design specs 2025 v4.3 */
			$(this).find('.continue_pretest_btn').each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				$(this).attr('aria-hidden', false);
			});

			/* client learning design specs 2025 v4.3 */
			$(this).find('.home_assess_btn').each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				$(this).attr('aria-hidden', false);
			});
		/*}*/
		
		/* client learning design specs 2025 v5.2 */
		$(this).find('.review_assess_btn').each(function(index, element) {
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			$(this).attr('aria-hidden', false);
		});

		/* 20240130 accessibility 2024 */
		$(this).find('.slide_left').each(function(index, element) {
			
			$(this).attr('role','button'); /* 20180501 Accessibility Update */
			
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', false);
		});

		/* apply tabindex to slider */
		$(this).find('.slider_txt').each(function(index, element) {	
			/* ensure first display is tabbed to first */
			//if (index == 0)
			//{	
			/* 20240130 accessibility 2024 */
			tabCnt++;
			$(this).find('.slider_start').attr('tabindex', tabCnt);
			$(this).find('.slider_start').attr('data-tab', tabCnt); // 20221018 JAWs Slider Fix
			$(this).find('.slider_start').attr('aria-hidden', false);

			/* 20240130 accessibility 2024 */
			tabCnt++;
			$(this).find('.slider_rest').attr('tabindex', tabCnt);
			$(this).find('.slider_rest').attr('data-tab', tabCnt); // 20221018 JAWs Slider Fix
			$(this).find('.slider_rest').attr('aria-hidden', false);

			$(this).find('a').each(function(index, element) {
				tabCnt++;
				$(this).attr('data-tab', tabCnt);
				$(this).attr('tabindex', tabCnt);
				/* 20240130 accessibility 2024 */
				$(this).attr('aria-hidden', false);
			});
			
			/* 20240130 accessibility 2024 */
			$(this).find('.slide_end').attr('aria-hidden', true);
			//}
		});
		/* 20240130 accessibility 2024 */
		$(this).find('.slider_col_right_img').each(function(index, element) {
			/* 20220630 Accessibility fix to apply tan order if image only has atl text */
			$(this).find('img').each(function(index, element) {
				if ($(this).attr('alt') != ''){
					tabCnt++;
					$(this).attr('data-tab', tabCnt); // 20221025 JAWs Slider Fix
					$(this).attr('tabindex', tabCnt);
					$(this).attr('aria-hidden', false);
				}
			});
		});
		$(this).find('.slide_right').each(function(index, element) {	
			
			$(this).attr('role','button'); /* 20180501 Accessibility Update */
			
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', false);
		});
		
		/*$(this).find('.slider_txt').each(function(index, element) {	
			if (index != 0)
			{	
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
			
				$(this).find('a').each(function(index, element) {
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
				});
			}			
		});*/

		/* apply tabindex to hotspot */
		/* 20180501 Accessibility Update */
		
		$(this).find('.hotspot_btn').each(function(index, element) {	
			
			$(this).attr('role','button'); /* 20180501 Accessibility Update */
			
			var hotTxt = $(this).next('.hotspot_btn_label').text();
						
			$(this).attr('title',hotTxt);
			
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', false);
			
			$(this).parent().next('.hotspot_reveal_inner').find('.hotspot_reveal').each(function(index, element) {	
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				/* 20240130 accessibility 2024 */
				$(this).attr('aria-hidden', false);
				
				$(this).find('a').each(function(index, element) {
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					/* 20240130 accessibility 2024 */
					$(this).attr('aria-hidden', false);
				});
                // 20190206 hotspot close functionality
                $(this).find('.hotspot_close').each(function(index, element) {
                    $(this).attr('role','button');
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					/* 20240130 accessibility 2024 */
					$(this).attr('aria-hidden', false);
				});
			});
		});	
		
		$(this).find('.hotspot_btn_close').each(function(index, element) {	
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', false);
		});
		
		
		$(this).find('.image_btn').each(function(index, element) {
			$(this).attr('role','button'); 
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', false);
			
			/* 20221020 ensure tabbing works properly in image click and displays */
			/* 20240130 accessibility 2024 */
			tabCnt++;
			$(this).parent().parent().find('.image_start').eq(index).attr('tabindex', tabCnt);
			$(this).parent().parent().find('.image_start').eq(index).attr('aria-hidden', false);
			/* 20240130 accessibility 2024 */
			tabCnt++;
			$(this).parent().parent().find('.image_rest').eq(index).attr('tabindex', tabCnt);
			$(this).parent().parent().find('.image_rest').eq(index).attr('aria-hidden', false);
			
			// 20221026 Fix for links not accessible
			$(this).parent().parent().find('.image_reveal').eq(index).find('a').each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				/* 20240130 accessibility 2024 */
				$(this).attr('aria-hidden', false);
			});
			
		});	
		
		// 202210 QA Tabbing fix
		/* 20240130 accessibility 2024 */
		$(this).find('.icon_element').each(function(index, element) {
			$(this).find('.icon_btn').each(function(index, element) {
				$(this).attr('role','button'); 
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				$(this).attr('aria-hidden', false);

				/* 20240130 accessibility 2024 */
				tabCnt++;
				$(this).parent().find('.icon_start').attr('tabindex', tabCnt);
				$(this).parent().find('.icon_start').attr('aria-hidden', false);

				/* 20240130 accessibility 2024 */
				tabCnt++;
				$(this).parent().find('.icon_rest').attr('tabindex', tabCnt);
				$(this).parent().find('.icon_rest').attr('aria-hidden', false);
			
				/* 20240130 accessibility 2024 */
				$(this).parent().find('.icon_content').find('a').each(function(index, element) {
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					$(this).attr('aria-hidden', false);
				});
			});
		});
		
			
		$(this).find('.image_hotspot_holder').each(function(index, element) {
			
			$(this).find('.image_hsp').each(function(index, element) {
				$(this).attr('role','button'); 
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				/* 20240130 accessibility 2024 */
				$(this).attr('aria-hidden', false);

				/* 20240130 accessibility 2024 */
				tabCnt++;
				$(this).parent().parent().prev().find('.image_hotspot_start').eq(index).attr('tabindex', tabCnt);
				$(this).parent().parent().prev().find('.image_hotspot_start').eq(index).attr('aria-hidden', false);
				
				/* 20240130 accessibility 2024 */
				tabCnt++;
				$(this).parent().parent().prev().find('.image_hotspot_rest').eq(index).attr('tabindex', tabCnt);
				$(this).parent().parent().prev().find('.image_hotspot_rest').eq(index).attr('aria-hidden', false);

				// 20221026 Fix for links not accessible
				/* 20240130 accessibility 2024 */
				$(this).parent().parent().prev().find('.image_reveal').eq(index).find('a').each(function(index, element) {
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					$(this).attr('aria-hidden', false);
				});
			});	
			
		});
		
		
		$(this).find('.v1hspimg_btn_holder').each(function(index, element) {
			
			$(this).find('.v1hspimg_btn').each(function(index, element) {
				$(this).attr('role','button'); 
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				/* 20240130 accessibility 2024 */
				$(this).attr('aria-hidden', false);

				tabCnt++;
				
				$(this).parent().prev().find('.v1hspimg_reveal').eq(index).attr('tabindex', tabCnt);
				/* 20240130 accessibility 2024 */
				$(this).parent().prev().find('.v1hspimg_reveal').eq(index).attr('aria-hidden', false);

			});	
			
		});
		
		
		
		$(this).find('.four_image_btn').each(function(index, element) {
			$(this).attr('role','button'); 
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', false);
			
			/* 20240130 accessibility 2024 */
			tabCnt++;
			$('.four_image_start').eq(index).attr('tabindex', tabCnt);
			$('.four_image_start').eq(index).attr('aria-hidden', false);
			
			/* 20240130 accessibility 2024 */
			tabCnt++;
			$('.four_image_rest').eq(index).attr('tabindex', tabCnt);
			$('.four_image_rest').eq(index).attr('aria-hidden', false);
			
			/* 20240130 accessibility 2024 */
			$('.four_image_reveal_content').eq(index).find('a').each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				$(this).attr('aria-hidden', false);
			});
			
			/* 20220630 Accessibility fix to apply tan order if image only has atl text */
			/* 20240130 accessibility 2024 */
			$('.four_image_reveal_content').eq(index).find('img').each(function(index, element) {
				if ($(this).attr('alt') != ''){
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					$(this).attr('aria-hidden', false);
				}
			});
			
			tabCnt++;
			$('.popup_close').eq(index).attr('role','button');
			$('.popup_close').eq(index).attr('tabindex', tabCnt);
			/* 20240130 accessibility 2024 */
			$('.popup_close').eq(index).attr('aria-hidden', false);
			
		});	
		
		// 202210 QA Tabbing fix
		$(this).find('.tab_btn').each(function(index, element) {
			$(this).attr('role','button'); 
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', false);
			
			/* 20240130 accessibility 2024 */
			tabCnt++;
			$(this).parent().parent().find(".tab_start").eq(index).attr('tabindex', tabCnt);
			$(this).parent().parent().find(".tab_start").eq(index).attr('aria-hidden', false);
			
			/* 20240130 accessibility 2024 */
			tabCnt++;
			$(this).parent().parent().find(".tab_rest").eq(index).attr('tabindex', tabCnt);
			$(this).parent().parent().find(".tab_rest").eq(index).attr('aria-hidden', false);
			
			/* 20221019 include links in the tab order in a tabbed reveal */
			$(this).parent().parent().find(".tab_reveal").eq(index).find('a').each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				/* 20240130 accessibility 2024 */
				$(this).attr('aria-hidden', false);
			});
				
			/* 20220630 Accessibility fix to apply tan order if image only has atl text */
			$(this).parent().parent().find(".tab_reveal").eq(index).find('img').each(function(index, element) {					
				if ($(this).attr('alt') != ''){
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					/* 20240130 accessibility 2024 */
					$(this).attr('aria-hidden', false);
				}
			});
			
		});	
		
		/* flip card 2022 */
		$(this).find('.flip_card').each(function(index, element) {			
			
			$(this).find('.flip_card_front').each(function(index, element) {
				$(this).attr('role','button'); 
			});
		  	$(this).find('.flip_card_back').each(function(index, element) {
				if(document.allowFlipBack){ // 20221025 Flipcard link fix
					$(this).attr('role','button');				
				}
			});
			tabCnt++;			
			$(this).find('.flip_card_inner').each(function(index, element) {
				if ($(this).hasClass('flipped'))
				{
					$(this).find('.flip_card_front').each(function(index, element) {
						$(this).attr('tabindex', -1);
						/* 20240130 accessibility 2024 */
						$(this).attr('aria-hidden', true);
					});
					$(this).find('.flip_card_back').each(function(index, element) {
						$(this).attr('tabindex', tabCnt);
						/* 20240130 accessibility 2024 */
						$(this).attr('aria-hidden', false);
						/* Flip Card Scroll Accessibility Fix 2023 -- */
						/* 20240130 accessibility 2024 */
						$(this).find('.flip_start').each(function(index, element) {
							tabCnt++;
							$(this).attr('tabindex', tabCnt);
							$(this).attr('aria-hidden', false);
						});
						/* 20240130 accessibility 2024 */
						$(this).find('.flip_rest').each(function(index, element) {
							tabCnt++;
							$(this).attr('tabindex', tabCnt);
							$(this).attr('aria-hidden', false);
						});
						/* -- Flip Card Scroll Accessibility Fix 2023 */
						// 20221025 Flipcard link fix
						$(this).find('a').each(function(index, element) {
							tabCnt++;
							$(this).attr('tabindex', tabCnt);
							/* 20240130 accessibility 2024 */
							$(this).attr('aria-hidden', false);
						});
					});
				}
				else
				{
					$(this).find('.flip_card_front').each(function(index, element) {
						$(this).attr('tabindex', tabCnt);
						$(this).attr('data-tab', tabCnt); /* Flip Card Scroll Accessibility Fix 2023 */
						/* 20240130 accessibility 2024 */
						$(this).attr('aria-hidden', false);
					});
					$(this).find('.flip_card_back').each(function(index, element) {
						$(this).attr('tabindex', -1);
						/* 20240130 accessibility 2024 */
						$(this).attr('aria-hidden', true);
						// 20221025 Flipcard link fix
						/* Flip Card Scroll Accessibility Fix 2023 -- */
						/* 20240130 accessibility 2024 */
						$(this).find('.flip_start').each(function(index, element) {
							$(this).attr('tabindex', -1);
							tabCnt++;
							$(this).attr('data-tab', tabCnt);
							$(this).attr("aria-hidden", true);
						});
						/* 20240130 accessibility 2024 */
						$(this).find('.flip_rest').each(function(index, element) {
							$(this).attr('tabindex', -1);
							tabCnt++;
							$(this).attr('data-tab', tabCnt);
							$(this).attr("aria-hidden", true);
						});
						/* -- Flip Card Scroll Accessibility Fix 2023 */

						$(this).find('a').each(function(index, element) {
							tabCnt++;
							$(this).attr('data-tab', tabCnt);
							$(this).attr("aria-hidden", true);
						});
					});
				}
			});				
		});

		/* Timeline/Sequence Accessibility Fix 2023 -- */
		$(this).find('.timeline_content').each(function(index, element) {

			$(this).find('.timeline_item').each(function(index, element) {

				$(this).find('.tItem_left_content').each(function(index, element) {
					tabCnt++;
					$(this).attr('tabindex', tabCnt);
					/* 20240130 accessibility 2024 */
					$(this).attr('aria-hidden', false);
				});

			});
		});
		/* -- Timeline/Sequence Accessibility Fix 2023 */
		
		/* 20221020 ensure tab order of text content after activity is following activity */
		$(this).find('.content_text_after_activity').each(function(index, element) {
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', false);
			/* 20221101 ensure links within text content after activity are tabbed to after the content */
			$(this).find('a').each(function(index, element) {
				tabCnt++;
				$(this).attr('tabindex', tabCnt);
				/* 20240130 accessibility 2024 */
				$(this).attr('aria-hidden', false);
			});
		});
        
        $(this).find('.complete_arrow').each(function(index, element) { /* 20180501 Accessibility Update */
            $(this).attr('role','button');
			tabCnt++;
			$(this).attr('tabindex', tabCnt);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', false);
		});


		/* 20240130 accessibility 2024 */
		$(this).find('.tab_next_btn').each(function(index, element) {				
			$(this).attr('aria-hidden', false);
		});	
		$(this).find('.image_next_btn').each(function(index, element) {				
			$(this).attr('aria-hidden', false);
		});	
		$(this).find('.image_hotspot_next_btn').each(function(index, element) {				
			$(this).attr('aria-hidden', false);
		});	
		$(this).find('.image_hotspot_this_btn').each(function(index, element) {				
			$(this).attr('aria-hidden', false);
		});	
		
		/* 20240130 accessibility 2024 */
		$(".topic_nav_bar .branding_holder .branding .copyright").attr('aria-hidden', true);
		
    });
	
	$(":input").attr("aria-hidden", false); /* 20220628 JAWS fix to stop item being read when course launches */
	
	navTabCnt = tabCnt; /* 20180501 Accessibility Update */

	document.onmousedown = hideFocusOutline;

    function hideFocusOutline() {
	    $('[tabindex]').focus(function()
		{
			$(this).css('outline', 'none');
		});
		$('[tabindex]').focusout(function()
		{
			$(this).css('outline', 'none');
		});
		$('[tabindex]').keyup(function (event)
		{
			if(event.keyCode == 9)
			{
				$(this).css('outline', '');
			}
		});
    }	
	
}

/* 20180501 Accessibility Update */
function setNavTab(){
	
	var tabCnt = navTabCnt;
	tabCnt++
	$(".nav_instruction .instruction").attr('tabindex', tabCnt); // 202210 QA Tabbing fix
	tabCnt++
	$('#left_nav').attr('tabindex', tabCnt);
	tabCnt++;
	$('#home_nav').attr('tabindex', tabCnt);
	tabCnt++;
	$('#right_nav').attr('tabindex', tabCnt);
	
	/* 20220628 JAWS fix to stop item being read when course launches */
	$('#left_nav').attr("aria-hidden", false);
	$('#home_nav').attr("aria-hidden", false);
	$('#right_nav').attr("aria-hidden", false);
	$('.burger_top_btn').attr("aria-hidden", false);
	/* 20220628 JAWS fix to stop item being read when course launches */
}
/* 20180501 Accessibility Update */

/* 20180501 Accessibility Update Remove tab functionality from content */
function removeTabIndex(){	
	/* client learning design specs 2025 v4.3 */
	$('.bar_robot').find('.index_course_title').each(function(index, element) {     
        $(this).attr('tabindex', -1);
		$(this).attr('aria-hidden', true);		
    });
	// 20221018 QA fix for tabbing to buttons when resource/hotword popup visible	
	$('.bar_robot').find('.home').each(function(index, element) { 
		$(this).attr('tabindex', -1);
		/* 20240130 accessibility 2024 */
		$(this).attr('aria-hidden', true);
	});
	// 20221018 QA fix for tabbing to buttons when resource/hotword popup visible
	$('.bar_robot').find('.switchLang').each(function(index, element) { 
		$(this).attr('tabindex', -1);
		/* 20240130 accessibility 2024 */
		$(this).attr('aria-hidden', true);
	});
	
	$('.bar_robot').find('.bar_close').each(function(index, element) {
		$(this).attr('tabindex', -1);
		/* 20240130 accessibility 2024 */
		$(this).attr('aria-hidden', true);
	});
	$('.bar_robot').find('.page').each(function(index, element) {
		$(this).attr('tabindex', -1);
		/* 20240130 accessibility 2024 */
		$(this).attr('aria-hidden', true);
	});

	/* Progress Indicator 2023 -- */
	$(".course_progress").attr('tabindex', -1);
	$(".course_progress").attr('aria-hidden', true);
	/* -- Progress Indicator 2023 */
	
	$('.sec_rest_wrapper').find('.section').each(function(index, element) {
		
		$(this).find('.h2_inner').each(function(index, element) {
			$(this).attr('tabindex', -1);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', true);
		});
		
		$(this).find('.content_text').each(function(index, element) {
			$(this).attr('tabindex', -1);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', true);
			/* 20221021 ensure links within main content are tabbed to after the content */
			$(this).find('a').each(function(index, element) {
				$(this).attr('tabindex', -1);
				/* 20240130 accessibility 2024 */
				$(this).attr('aria-hidden', true);
			});
		});
				
		/* 20221107 Accessibility fix to apply tab order if image only has alt text */
		$(this).find('img').each(function(index, element) {
			$(this).attr('tabindex', -1);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', true);
		});
		
		/* client learning design specs 2025 v4.3 */
		/* 20240319 pre-test that appears after first topic */
		$(this).find('.pretest_nav_start').each(function(index, element) {
			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
		});

		/* client learning design specs 2025 v4.3 */
		/* 20240319 pre-test that appears after first topic */
		$(this).find('.pretest_nav_cancel').each(function(index, element) {
			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
		});
		
		$(this).find('.expando_btn').each(function(index, element) {
			$(this).attr('tabindex', -1);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', true);
			
			$(this).next('.expando_reveal').each(function(index, element){
				$(this).find('.expando_reveal_content').each(function(index, element) {	
					/* 20240130 accessibility 2024 */
					$(this).find('.exp_start').attr('tabindex', -1);
					$(this).find('.exp_start').attr('aria-hidden', true);
					
					$(this).find('.exp_rest').attr('tabindex', -1);
					$(this).find('.exp_rest').attr('aria-hidden', true);

					$(this).find('a').each(function(index, element) {
						$(this).attr('tabindex', -1);
						/* 20240130 accessibility 2024 */
						$(this).attr('aria-hidden', true);
					});
					
					/* 20221107 Accessibility fix to apply tab order if image only has alt text */
					$(this).find('img').each(function(index, element) {
						$(this).attr('tabindex', -1);
						/* 20240130 accessibility 2024 */
						$(this).attr('aria-hidden', true);
					});

				});

				$(this).find('.expando_reveal_heading').each(function(index, element) {
					$(this).attr('tabindex', -1);
					/* 20240130 accessibility 2024 */
					$(this).attr('aria-hidden', true);
				});
			});
						
		});
		
		/* 20240130 accessibility 2024 */
		$(this).find('.video_poster').each(function(index, element) {
			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
		});	
		
		/* remove tabindex to video */
		$(this).find('.video_player').each(function(index, element) {
			$(this).attr('tabindex', -1);
			/* 20231030 video accessibility */
			$(this).attr('aria-hidden', true);
		});	
		$(this).find('.transcript_btn').each(function(index, element) {	
			$(this).attr('tabindex', -1);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', true);
		});	
		/* remove tabindex to questions */	
        $(this).find('.qItemFirst').each(function(index, element) {
			$(this).attr('tabindex', -1);
			$(this).attr("aria-hidden", true);
			/* 20220628 JAWS fix to stop item being read when course launches */
		});
		$(this).find('.squaredBox').each(function(index, element) {
			$(this).attr('tabindex', -1);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', true);
		});
				
		$(this).find('.mc_btn').each(function(index, element) {
            $(this).attr('tabindex', -1);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', true);
        });
		$(this).find('.submit_btn').each(function(index, element) {	
			$(this).attr('tabindex', -1);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', true);
		});	
		
		/* 20240130 accessibility 2024 */
		$(this).find('.feedback_rest').each(function(index, element) {
			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
			
			$(this).find('a').each(function(index, element) {
				$(this).attr('tabindex', -1);
				$(this).attr('aria-hidden', true);
			});
		});
		
		/* 20240130 accessibility 2024 */
		$(this).find('.feedback_start').each(function(index, element) {	
			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
			
			$(this).find('a').each(function(index, element) {
				$(this).attr('tabindex', -1);
				$(this).attr('aria-hidden', true);
			});
		});	
		
		/* client learning design specs 2025 v5.2 */
		$(this).find('.review_assess_btn').each(function(index, element) {
			$(this).attr('tabindex', -1);
			$(this).attr('aria-hidden', true);
		});

		/* client learning design specs 2025 v4.3 */
		/* 20240130 accessibility 2024 */
		/*if (document.noTopicsAssociatedPretest)
		{*/
			$(this).find('.home_assess_btn').each(function(index, element) {
				$(this).attr('tabindex', -1);
				$(this).attr('aria-hidden', true);
			});
			$(this).find('.continue_pretest_btn').each(function(index, element) {
				$(this).attr('tabindex', -1);
				$(this).attr('aria-hidden', true);
			});
		/*}*/
		
		$(this).find('.retake_assess_btn').each(function(index, element) {	
			$(this).attr('tabindex', -1);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', true);
		});	
		
		// 20221013 JAWS fix
		$(this).find('.results_review_text').each(function(index, element) {
			$(this).attr('tabindex', -1);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', true);
		});	
		
		/* 20240130 accessibility 2024 */
		$(this).find('.slide_left').each(function(index, element) {	
			$(this).attr('tabindex', -1);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', true);
		});
		/* remove tabindex to slider */
		$(this).find('.slider_txt').each(function(index, element) {
			/* 20240130 accessibility 2024 */
			$(this).find('.slider_start').attr('tabindex', -1);
			$(this).find('.slider_start').attr('aria-hidden', true);
			
			/* 20240130 accessibility 2024 */
			$(this).find('.slider_rest').attr('tabindex', -1);
			$(this).find('.slider_rest').attr('aria-hidden', true);
			
			$(this).find('a').each(function(index, element) {
				$(this).attr('tabindex', -1);
				/* 20240130 accessibility 2024 */
				$(this).attr('aria-hidden', true);
			});
		});
		/* 20240130 accessibility 2024 */
		$(this).find('.slider_col_right_img').each(function(index, element) {
			/* 20220630 Accessibility fix to apply tan order if image only has atl text */
			$(this).find('img').each(function(index, element) {
				$(this).attr('tabindex', -1);
				$(this).attr('aria-hidden', true);
			});
		});
		
		$(this).find('.slide_right').each(function(index, element) {
			$(this).attr('tabindex', -1);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', true);
		});
		/* remove tabindex to hotspot */
		$(this).find('.hotspot_btn').each(function(index, element) {	
			$(this).attr('tabindex', -1);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', true);
		});	
		$(this).find('.hotspot_reveal').each(function(index, element) {	
			$(this).attr('tabindex', -1);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', true);
		});	
		
		$(this).find('.hotspot_reveal').each(function(index, element) {	
			
			$(this).find('a').each(function(index, element) {
				$(this).attr('tabindex', -1);
				/* 20240130 accessibility 2024 */
				$(this).attr('aria-hidden', true);
			});
            
            $(this).find('.hotspot_close').each(function(index, element) {
                $(this).attr('tabindex', -1);
				/* 20240130 accessibility 2024 */
				$(this).attr('aria-hidden', true);
            });
			
		});	
		
		$(this).find('.hotspot_btn_close').each(function(index, element) {	
			$(this).attr('tabindex', -1);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', true);
		});
		
		
		
		$(this).find('.image_btn').each(function(index, element) {
	
			$(this).attr('tabindex', -1);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', true);
			/* 20240130 accessibility 2024 */
			$(this).parent().parent().find('.image_start').eq(index).attr('tabindex', -1);
			$(this).parent().parent().find('.image_start').eq(index).attr('aria-hidden', true);
			/* 20240130 accessibility 2024 */
			$(this).parent().parent().find('.image_rest').eq(index).attr('tabindex', -1);
			$(this).parent().parent().find('.image_rest').eq(index).attr('aria-hidden', true);
			
			// 20221026 Fix for links not accessible
			/* 20240130 accessibility 2024 */
			$(this).parent().parent().find('.image_reveal').eq(index).find('a').each(function(index, element) {
				$(this).attr('tabindex', -1);
				$(this).attr('aria-hidden', true);
			});
			
		});	
		
		$(this).find('.icon_element').each(function(index, element) {
			$(this).find('.icon_btn').each(function(index, element) {

				$(this).attr('tabindex', -1);
				/* 20240130 accessibility 2024 */
				$(this).attr('aria-hidden', true);
				
				/* 20240130 accessibility 2024 */
				$(this).parent().find('.icon_start').eq(index).attr('tabindex', -1);
				$(this).parent().find('.icon_start').eq(index).attr('aria-hidden', true);
			
				/* 20240130 accessibility 2024 */
				$(this).parent().find('.icon_rest').eq(index).attr('tabindex', -1);
				$(this).parent().find('.icon_rest').eq(index).attr('aria-hidden', true);
				
				/* 20240130 accessibility 2024 */
				$(this).parent().find('.icon_content').eq(index).find('a').each(function(index, element) {
					$(this).attr('tabindex', -1);
					$(this).attr('aria-hidden', true);
				});
			});	
		});
		
		$(this).find('.image_hotspot_holder').each(function(index, element) {
			
			$(this).find('.image_hsp').each(function(index, element) {
				$(this).attr('tabindex', -1);
				/* 20240130 accessibility 2024 */
				$(this).attr('aria-hidden', true);
				
				/* 20240130 accessibility 2024 */
				$(this).parent().parent().prev().find('.image_hotspot_start').eq(index).attr('tabindex', -1);
				$(this).parent().parent().prev().find('.image_hotspot_rest').eq(index).attr('aria-hidden', true);
				
				/* 20240130 accessibility 2024 */
				$(this).parent().parent().prev().find('.image_hotspot_rest').eq(index).attr('tabindex', -1);
				$(this).parent().parent().prev().find('.image_hotspot_start').eq(index).attr('aria-hidden', true);

				// 20221026 Fix for links not accessible
				/* 20240130 accessibility 2024 */
				$(this).parent().parent().prev().find('.image_reveal').eq(index).find('a').each(function(index, element) {
					tabCnt++;
					$(this).attr('tabindex', -1);
					$(this).attr('aria-hidden', true);
				});
			});
		});
		
		$(this).find('.v1hspimg_btn_holder').each(function(index, element) {
			
			$(this).find('.v1hspimg_btn').each(function(index, element) {
				$(this).attr('tabindex', -1);
				/* 20240130 accessibility 2024 */
				$(this).attr('aria-hidden', true);
				$(this).parent().prev().find('.v1hspimg_reveal').eq(index).attr('tabindex', -1);
				/* 20240130 accessibility 2024 */
				$(this).parent().prev().find('.v1hspimg_reveal').eq(index).attr('aria-hidden', true);

			});	
			
		});
		
		$(this).find('.four_image_btn').each(function(index, element) {
			$(this).attr('tabindex', -1);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', true);
			
			/* 20240130 accessibility 2024 */
			$(this).parent().parent().find('.four_image_start').eq(index).attr('tabindex', -1);
			$(this).parent().parent().find('.four_image_start').eq(index).attr('aria-hidden', true);
			
			/* 20240130 accessibility 2024 */
			$(this).parent().parent().find('.four_image_rest').eq(index).attr('tabindex', -1);
			$(this).parent().parent().find('.four_image_rest').eq(index).attr('aria-hidden', true);
			
			/* 20240130 accessibility 2024 */
			$(this).parent().parent().find('.four_image_reveal_content').eq(index).find('a').each(function(index, element) {
				$(this).attr('tabindex', -1);
				$(this).attr('aria-hidden', true);
			});
			
			/* 20240130 accessibility 2024 */
			$(this).parent().parent().find('.four_image_reveal_content').eq(index).find('img').each(function(index, element) {
				$(this).attr('tabindex', -1);
				$(this).attr('aria-hidden', true);
			});
			
			$('.popup_close').eq(index).attr('tabindex', -1);
			/* 20240130 accessibility 2024 */
			$('.popup_close').eq(index).attr('aria-hidden', true);
			
		});	
		
		$(this).find('.tab_btn').each(function(index, element) {
			
			$(this).attr('tabindex', -1);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', true);
			
			/* 20240130 accessibility 2024 */
			$(".tab_start").eq(index).attr('tabindex', -1);
			$(".tab_start").eq(index).attr('aria-hidden', true);
			
			/* 20240130 accessibility 2024 */
			$(".tab_rest").eq(index).attr('tabindex', -1);
			$(".tab_rest").eq(index).attr('aria-hidden', true);
			
			/* 20221019 include links in the tab order in a tabbed reveal */
			$(".tab_reveal").eq(index).find('a').each(function(index, element) {	
				$(this).attr('tabindex', -1);
				/* 20240130 accessibility 2024 */
				$(this).attr('aria-hidden', true);
			});

			/* 20220630 Accessibility fix to apply tan order if image only has atl text */
			/* 20240130 accessibility 2024 */
			$(".tab_reveal").eq(index).find('img').each(function(index, element) {
				$(this).attr('tabindex', -1);
				$(this).attr('aria-hidden', true);
			});
			
		});	
		
		$(this).find('.flip_card').each(function(index, element) {
			
			
			$(this).find('.flip_card_front').each(function(index, element) {
			
				$(this).attr('tabindex', -1);
				/* 20240130 accessibility 2024 */
				$(this).attr('aria-hidden', true);
				
			})
												  
		  	$(this).find('.flip_card_back').each(function(index, element) {
		
				$(this).attr('tabindex', -1);
				/* 20240130 accessibility 2024 */
				$(this).attr('aria-hidden', true);
				/* Flip Card Scroll Accessibility Fix 2023 -- */
				// 20230403 Flipcard tab fix
				/* 20240130 accessibility 2024 */
				$(this).find('.flip_start').each(function(index, element) {
					$(this).attr('tabindex', -1);
					$(this).attr('aria-hidden', true);
				});
				/* 20240130 accessibility 2024 */
				$(this).find('.flip_rest').each(function(index, element) {
					$(this).attr('tabindex', -1);
					$(this).attr('aria-hidden', true);
				});
				/* -- Flip Card Scroll Accessibility Fix 2023 */
				// 20221025 Flipcard link fix
				$(this).find('a').each(function(index, element) {
					$(this).attr('tabindex', -1);
					/* 20240130 accessibility 2024 */
					$(this).attr('aria-hidden', true);
				});
			})
			
		});	

		/* 20240130 accessibility 2024 */
		$(this).find('.tab_next_btn').each(function(index, element) {				
			$(this).attr('aria-hidden', true);
		});	
		$(this).find('.image_next_btn').each(function(index, element) {				
			$(this).attr('aria-hidden', true);
		});	
		$(this).find('.image_hotspot_next_btn').each(function(index, element) {				
			$(this).attr('aria-hidden', true);
		});	
		$(this).find('.image_hotspot_this_btn').each(function(index, element) {				
			$(this).attr('aria-hidden', true);
		});	


		// $('.burger_top_btn').attr("aria-hidden", true);

		/* Timeline/Sequence Accessibility Fix 2023 -- */
		$(this).find('.timeline_content').each(function(index, element) {

			$(this).find('.timeline_item').each(function(index, element) {				

				$(this).find('.tItem_left_content').each(function(index, element) {
					$(this).attr('tabindex', -1);
					/* 20240130 accessibility 2024 */
					$(this).attr('aria-hidden', true);
				});
			});
		});
		/* -- Timeline/Sequence Accessibility Fix 2023 */

        
        $(this).find('.complete_arrow').each(function(index, element) { /* 20180501 Accessibility Update */
			$(this).attr('tabindex', -1);
			/* 20240130 accessibility 2024 */
			$(this).attr('aria-hidden', true);
		});
		
    });
	
	$(".nav_instruction .instruction").attr('tabindex', -1); // 202210 QA Tabbing fix
	/* 20240130 accessibility 2024 */
	$(".nav_instruction .instruction").attr('aria-hidden', true);
	$('#left_nav').attr('tabindex', -1);
	$('#home_nav').attr('tabindex', -1);
	$('#right_nav').attr('tabindex', -1);
	
	/* 20220628 JAWS fix to stop item being read when course launches */
	$('#left_nav').attr("aria-hidden", true);
	$('#home_nav').attr("aria-hidden", true);
	$('#right_nav').attr("aria-hidden", true);
	/* 20220628 JAWS fix to stop item being read when course launches */
	
	$(":input").attr("aria-hidden", true); /* 20220628 JAWS fix to stop item being read when course launches */

}
/* 20180501 Accessibility Update Remove tab functionality from content */

/* close button is always hidden */
/*if(!isWeb){
	$('.topic_index .bar_close').css('display','none');
}else{
	$('.topic_index .bar_close').css('display','block');
}*/

/* apply button text and title attribute to interface buttons */
function interfaceStrings(){
	
	$('.index_banner_logo').attr('title', localiseString('course_logo'));
	$('.index_banner_logo').attr('alt', localiseString('course_logo'));
	
	$('.transcript_btn').html(localiseString('transcript_btn'));
	$('.transcript_btn').attr('title',localiseString('transcript_btn'));
	$('.transcript_btn').attr('alt',localiseString('transcript_btn'));
	
	$('.submit_btn').html(localiseString('submit_btn'));
	$('.submit_btn').attr('title',localiseString('submit_btn_locked'));
	$('.submit_btn').attr('alt',localiseString('submit_btn_locked'));
	
	$('.conf_btn').html(localiseString('conf_btn'));
	$('.conf_btn').attr('title',localiseString('conf_btn'));
	$('.conf_btn').attr('alt',localiseString('conf_btn'));
	
	$('.notconf_btn').html(localiseString('notconf_btn'));
	$('.notconf_btn').attr('title',localiseString('notconf_btn'));
	$('.notconf_btn').attr('alt',localiseString('notconf_btn'));
	
	$('.tryagain_btn').html(localiseString('tryagain_btn'));
	$('.tryagain_btn').attr('title',localiseString('tryagain_btn'));
	$('.tryagain_btn').attr('alt',localiseString('tryagain_btn'));
	
	$('.home').attr('title', localiseString('menu_nav'));
	$('.switchLang').attr('title', localiseString('lang_btn'));
	//$('.home').attr('alt', localiseString('menu_nav'));
	$('#home_nav').attr('title', localiseString('home_nav'));
	//$('#home_nav').attr('alt', localiseString('home_nav'));
	$('.page').attr('title', localiseString('resource_btn'));
	//$('.page').attr('alt', localiseString('resource_btn'));
	$('.bar_close').attr('title', localiseString('exit_nav'));
	//$('.bar_close').attr('alt', localiseString('exit_nav'));
	
	$('.box_closer').attr('title', localiseString('close_btn'));
	//$('.box_closer').attr('alt', localiseString('close_btn'));
	
	$('.bookmark_nav_start').html(localiseString('bookmark_nav_start'));
	$('.bookmark_nav_start').attr('title', localiseString('bookmark_nav_start'));
	$('.bookmark_nav_start').attr('alt', localiseString('bookmark_nav_start'));
	$('.bookmark_nav_resume').html(localiseString('bookmark_nav_resume'));
	$('.bookmark_nav_resume').attr('title', localiseString('bookmark_nav_resume'));
	$('.bookmark_nav_resume').attr('alt', localiseString('bookmark_nav_resume'));
	/* 20231019 switch language button on pre-test selection screen */
	$('.bookmark_nav_switchlang').html(localiseString('lang_btn'));
	$('.bookmark_nav_switchlang').attr('title', localiseString('lang_btn'));
	$('.bookmark_nav_switchlang').attr('alt', localiseString('lang_btn'));
	$('#bm_title').html(localiseString('bookmark_title'));
	$('#bm_text').html(localiseString('bookmark_text'));
	
	$('.slide_right').attr('title', localiseString('slide_right'));
	$('.slide_right').attr('alt', localiseString('slide_right'));
	$('.slide_left').attr('title', localiseString('slide_left'));
	$('.slide_left').attr('alt', localiseString('slide_left'));
	/* 20221102 ensure leftmost slide button has unavailable title and alt text initially if linear sliders */
	if (document.sliderLinear)
	{	
		$('.slide_left').attr('title', localiseString('left_nav_locked'));
		$('.slide_left').attr('alt', localiseString('left_nav_locked'));
	}
	$('.temp_slide_nums').attr('title', localiseString('slide_progress'));
	$('.temp_slide_nums').attr('alt', localiseString('slide_progress'));
	
	$('.complete_arrow').attr('title', localiseString('complete_arrow'));
	$('.complete_arrow').attr('alt', localiseString('complete_arrow'));
	//$('.complete_arrow').html(localiseString('complete_arrow'));
		
	$('.start_img').attr('title', localiseString('topic_start'));
	$('.start_img').attr('alt', localiseString('topic_start'));

	/* 20240130 accessibility 2024 */
	/* 20240130 handling of src possibly returning full url from some browsers in LMS */
	
	$('.topic_select').each(function(index, element) {
		var tempTopicSelectTxt = '';
		if($(this).find('.select_bottom .start_img').attr('src').indexOf('images/general_int/section_locked.png') == -1) {
			tempTopicSelectTxt = localiseString('topic_incomplete') + " " + localiseString('topic_start');
		}
		else {
			tempTopicSelectTxt = localiseString('topic_incomplete') + " " + localiseString('topic_locked');
		}
		$(this).attr('title',($(this).find('.select_title h3').html() + " " + tempTopicSelectTxt)); 
		$(this).attr('alt',tempTopicSelectTxt);
		$(this).find('.select_bottom .progress').attr('title','');
		$(this).find('.select_bottom .progress').attr('alt','');
		$(this).find('.select_bottom .start_img').attr('title',($(this).find('.select_title h3').html() + " " + tempTopicSelectTxt)); 
		$(this).find('.select_bottom .start_img').attr('alt',tempTopicSelectTxt);
	});

	/* 20240130 handling of src possibly returning full url from some browsers in LMS */
	$('.burger_select').each(function(index, element) {
		var tempTopicSelectTxt = '';
		// if($(this).find('.burger_start_img').attr('src') != 'images/custom_int/burger_locked.png'){
		if($(this).find('.burger_start_img').attr('src').indexOf('images/custom_int/burger_locked.png') == -1) {
			tempTopicSelectTxt = localiseString('topic_incomplete') + " " + localiseString('topic_start');
		}
		else {
			tempTopicSelectTxt = localiseString('topic_incomplete') + " " + localiseString('topic_locked');
		}		
		$(this).find('.burger_select_title').attr('title',($(this).find('.burger_select_title').html() + " " + tempTopicSelectTxt));
		$(this).attr('title',($(this).find('.burger_select_title').html() + " " + tempTopicSelectTxt));
		$(this).attr('alt',tempTopicSelectTxt);
		$(this).find('.burger_start_img').attr('title',($(this).find('.burger_select_title').html() + " " + tempTopicSelectTxt));
		$(this).find('.burger_start_img').attr('alt',tempTopicSelectTxt);
	});
	
	$(".menu_grid h1").html(document.courseTitle);
	//$(".home_title h1").html(document.courseTitle);
	//$(".home_title").css("display","block");

	$(".retake_assess_btn").html(localiseString('retake_test_button'));
	/* client testing requirements 2024 v2.3: */
	/* if the learner answers enough questions incorrectly that they can no longer pass the test-out, they must be informed that they have failed the test-out and be given the option to finish the test-out or proceed to the content */
	$(".continue_pretest_btn").html(localiseString('continue_pretest_button'));
	/* pre-test no topics associated with questions support kgs 03/18/22 */
	/* client testing requirements 2024: */
	/* Review Content button at the end of the passed and failed course-level (no topics assoicated) pre-test and post-test that will take the learner to the Home page menu */
	/* if (document.noTopicsAssociatedPretest)
	{ */
		$(".home_assess_btn").html(localiseString('home_assess_button'));
	/* } */
	$(".confirm_attest_btn").html(localiseString('confirm_attest_button'));
    
	/* client testing requirements 2025 v5.2: */
	$(".review_assess_btn").html(localiseString('review_assess_button'));

    $(".hotspot_close").attr('title',localiseString('hotspot_close'));
    
    if(!document.showFooterNav){
        $(".topic_nav_button").css("display","none");
        $(".topic_nav_bar").css("height","100px");
        $(".topic_nav_bar .branding").css("top","50px");
    }
    
    if(!document.showResourcesButton){
		/* when there is no resource button and no multi-sco reduce the width of the banner mjb/kgs 03/17/22 */
		$('.bar_robot .page').attr('style', 'display: none !important');
		$('.index_banner .page').attr('style', 'display: none !important');
		$('.bar_robot .page').css('visibility','hidden');
		$('.index_banner .page').css('visibility','hidden');
		if (!document.isMultiSco)
		{
			$(".index_banner").css("width", "220px");
			$(".menu_flex").css("width", "220px");
		}	
    }

	/* hide resources button on homepage menu when the first page of the first topic containing a disclaimer has not yet been accessed 090324 */
	if (document.hideResourcesButtonDisclaimer && (document.trackingArr[1] == 0)) {
		$('.index_banner .page').css('visibility','hidden');
	}

	/* hide the animated GIF with topic numbers in the pre-test 082324 */
	if (document.pretestPresent == 1) {
		if (document.pretestAttempted == 1) {
			$('.test_intro_img').css('display','block');
			/* client testing requirements 2025 v5.2: */
			/* hide text and buttons in the Completion Criteria / Test-Out Overview page */
			$('.compCriteria').find('.test_out_overview').hide();
		}
		else {
			$('.test_intro_img').css('display','none');
		}
	}		
}


/* 20220628 JAWS fix to stop item being read when course launches */
$(":input").attr("aria-hidden", true);
$('#left_nav').attr("aria-hidden", true);
$('#home_nav').attr("aria-hidden", true);
$('#right_nav').attr("aria-hidden", true);
$('.qItemFirst').attr("aria-hidden", true);
/* 20220628 JAWS fix to stop item being read when course launches */



/* updated to select via specific language */
function localiseString(identifier){
	if(eval("document.langStrings_" + document.selectedLang).hasOwnProperty(identifier)){
		return eval("document.langStrings_" + document.selectedLang)[identifier];
	}else{
		return "Lang string unknown";
	}
}


/*var courseTimer = setTimeout(function(){
	
	alert("close course")
	window.top.close();
	
},10000)*/


function setRTL(){
	
	if(document.textDirection == "rtl"){
	
		/* client learning design specs 2025 v4.3 */
		$(".pretest_nav_cancel").addClass("pretest_nav_cancel_RTL");
		$(".pretest_nav_start").addClass("pretest_nav_start_RTL");
		$(".index_course_title").addClass("index_course_title_RTL");
		
		$(".menu_flex").addClass("menu_flex_RTL");

		$(".index_banner").addClass("menu_flex_RTL");
		
		$(".menu_header_content").addClass("menu_header_content_RTL");
		
		$(".menu_header_image").addClass("menu_header_image_RTL");
		
		$(".menu_btn_title").addClass("menu_btn_title_RTL");
		$(".menu_container").addClass("menu_container_RTL");
		$(".menu_btns_holder").addClass("menu_btns_holder_RTL");
		/* REMOVE 2023 $(".menu_header_dec").addClass("menu_header_dec_RTL");*/
		
		$(".topic_select").addClass("topic_select_RTL");
		
		$(".progress").addClass("progress_RTL");
		
		/* 20240130 accessibility 2024 */
		$("ul").addClass("ul_RTL");
		$("ul.white").addClass("ul_white_RTL");
		$(".grid_inner ul").addClass("grid_inner_ul_RTL");
		$(".textColor2 ul").addClass("textColor2_ul_RTL");
		$(".box_message ul").addClass("box_message_ul_RTL");
		$(".hotspot_reveal ul").addClass("hotspot_reveal_ul_RTL");
		$(".grid_inner ul ul").addClass("grid_inner_ul_ul_RTL");
		$(".grid_inner ol ul").addClass("grid_inner_ol_ul_RTL");
		$(".expando_reveal_content ul ul").addClass("expando_reveal_content_ul_ul_RTL");
		$(".expando_reveal_content ol ul").addClass("expando_reveal_content_ol_ul_RTL");
		$(".box_message ul ul").addClass("box_message_ul_ul_RTL");
		$(".box_message ol ul").addClass("box_message_ol_ul_RTL");
		$(".textColor2 ul ul").addClass("textColor2_ul_ul_RTL");
		$(".textColor2 ol ul").addClass("textColor2_ol_ul_RTL");
		$(".hotspot_reveal ul ul").addClass("hotspot_reveal_ul_ul_RTL");
		$(".hotspot_reveal ol ul").addClass("hotspot_reveal_ol_ul_RTL");
		$(".feedback_text ul").addClass("feedback_text_ul_RTL");
		$(".results_review_text").addClass("results_review_text_RTL");
		$(".blue_on_white ul").addClass("blue_on_white_ul_RTL");
		$(".blue_on_white ul ul").addClass("blue_on_white_ul_ul_RTL");
		$(".white_on_blue ul").addClass("white_on_blue_ul_RTL");
		$(".white_on_blue ul ul").addClass("white_on_blue_ul_ul_RTL");		
		
		$(".burger_progress").addClass("burger_progress_RTL");
		$(".burger_start_img").addClass("burger_start_img_RTL");
		$(".burger_close").addClass("burger_close_RTL");
		$(".burger_sec").addClass("burger_sec_RTL");
		$(".burger_select_title").addClass("burger_select_title_RTL");
		$(".burger_bg").addClass("burger_bg_RTL");
		
		
		
		$(".section_title").addClass("section_title_RTL");
		
		$(".icon_leadin").addClass("icon_leadin_RTL");
		$(".icon_holder").addClass("icon_holder_RTL");
		
		$(".icon_content").addClass("icon_content_RTL");
		$(".icon_content").css("text-align", "right");
		
		/* 092223 support for two buttons in icon click and display */
		$(".icon_holder_two").addClass("icon_holder_two_RTL");
		
		$(".text_image_text").addClass("text_image_text_RTL");
		
		$(".text_image_left").addClass("text_image_left_RTL");
		
		$(".text_image_right").addClass("text_image_right_RTL");
		
		/* text and image on left 2025 */
		$(".text_image_right_img_left").addClass("text_image_right_img_left_RTL");
		$(".text_image_left_img_left").addClass("text_image_left_img_left_RTL");
		
		/* 011924 two-column text */
		$(".text_col_left").addClass("text_col_left_RTL");
		$(".text_col_right").addClass("text_col_right_RTL");
		
		/* 013024 icon click and display rtl */
		$(".icon_interaction").addClass("icon_interaction_RTL");
		$(".icon_leadin").addClass("icon_leadin_RTL");
				
		$(".question_container").addClass("question_container_RTL");
		$(".qItemFirst").addClass("qItemFirst_RTL");
		
		$(".optionHolder").addClass("optionHolder_RTL");
		
		$(".question_leadin").addClass("question_leadin_RTL");
		$(".submit_holder").addClass("submit_holder_RTL");
		$(".feedback_text").addClass("feedback_text_RTL");
		$(".mc_btn").addClass("mc_btn_RTL");
		
		
		$(".expando_btn").addClass("expando_btn_RTL");
		$(".expando_reveal_heading").addClass("expando_reveal_heading_RTL");
		$(".expando_decal").addClass("expando_decal_RTL");
		
		$(".slide_left").addClass("slide_left_RTL");
		$(".slide_right").addClass("slide_right_RTL");
		$(".slider_container").addClass("slider_container_RTL");
		
		/* REMOVE 2023
		$(".decal_left").addClass("decal_left_RTL");*/
		
		$(".image_leadin").addClass("image_leadin_RTL");
		$(".image_ind").addClass("image_ind_RTL");
		
		
		$(".tItem_left_content").addClass("tItem_left_content_RTL");
		$(".tItem_right").addClass("tItem_right_RTL");
		$(".tLineVert").addClass("tLineVert_RTL");
		$(".tLineVertSingle").addClass("tLineVertSingle_RTL");
		$(".tLineHoriz").addClass("tLineHoriz_RTL");
		$(".timeline_item").addClass("timeline_item_RTL");
		
		$(".image_hotspot_reveal_holder").addClass("image_hotspot_reveal_holder_RTL");
		$(".image_hotspot_leadin").addClass("image_hotspot_leadin_RTL");
		$(".hsp_img").addClass("hsp_img_RTL");
		
		$(".hotspot_image").addClass("hotspot_image_RTL");
		
		$('.pageMenu .active:after').css(
			{
				'border-top-width': '22px',
				'border-left-width': '22px',
				'border-right-width': '22px'
			}
		)
		
		$(".four_image_btn").addClass("four_image_btn_RTL");
		$(".popup_close").addClass("popup_close_RTL");
		$(".four_image_reveal_text").addClass("four_image_reveal_text_RTL");
		
		
		$(".flip_card_back").addClass("flip_card_back_RTL");
		
		$(".flip_card").addClass("flip_card_RTL");
		$(".flip_card_inner").addClass("flip_card_inner_RTL");
		
		$('#right_nav').addClass('locked');
		
		$(".box_closer").addClass("box_closer_RTL")
		
		//$(".topic_nav_bar .branding .logo_img").addClass("logo_img_RTL")
		
		/* REMOVE 2023
		$('.topic_nav_bar .branding .logo_img').css(
			{
				'float': 'none',
				'float': 'left'
			}
		)*/
		
		
		$(".tab_reveal_img").addClass("tab_reveal_img_RTL");
		
		$(".topic_nav_button").addClass("topic_nav_button_RTL")
		
		
		
		$(".text_only_content").addClass("text_only_content_RTL");
		
		$(".tItem_left").addClass("tItem_left_RTL");
		
		$(".align_left").addClass("align_left_RTL");
		
		$(".video_holder").addClass("video_holder_RTL");
		
		$(".diff_fb").addClass("diff_fb_RTL");
		
		$(".flip_card_int_holder").addClass("flip_card_int_holder_RTL");
		
		$(".slider_bg").addClass("slider_bg_RTL");
		
		$(".select_bottom").addClass("select_bottom_RTL");
		
		
		$(".submit_btn").addClass("submit_btn_RTL");
		
		$(".tab_int").addClass("tab_int_RTL");
		$(".tab_btn").addClass("tab_btn_RTL");
		
		
		$(".content_text_holder_rt_img").addClass("content_text_holder_rt_img_RTL");
		$(".topic_intro_content").addClass("topic_intro_content_RTL");
		
		$(".topic_intro_hero").addClass("topic_intro_hero_RTL");
		
		/* Progress Indicator 2023 -- */
		$(".progress_holder").addClass("progress_holder_RTL");
		$(".course_progress").addClass("course_progress_RTL");
		/* -- Progress Indicator 2023 */
		
		/* 20240501 bugfixing for rtl layouts */
		$(".two_col_table_content").addClass("two_col_table_content_RTL");
		
		/* two column one row flex table 2025 */
		$(".two_col_one_row_flex_table_left").addClass("two_col_one_row_flex_table_left_RTL");
		$(".two_col_one_row_flex_table_right").addClass("two_col_one_row_flex_table_right_RTL");
		/* two column one row flex table small images 2025 */
		$(".two_col_one_row_flex_table_left_small_img").addClass("two_col_one_row_flex_table_left_small_img_RTL");
		
	}else{
		$(".index_banner").css("right", "0");
		$(".menu_flex").css("right", "0");
	}
	
	if(!document.isMultiSco){
		$(".switchLang").css("display","none");
	}
	
	/* custom branching based on CITI071: Module 6: common topic, a branching topic with branching screentype, two branches, no assessement 2023 */
	/* hide home page menu if no branch was selected in a session */
	if(document.hasBranches){
		if(document.userBranch == 0){
			$(".menu_grid").css("display","none");
		}
	}
	
	if(document.altMenu){ // MJB insert add/remove classes to alter look and feel of menu
		//alert("alt style of menu use");
		//$(".heading_area").hide();
		$(".menu_btns").addClass("menu_btns_alt");
		$(".top_wrapper").addClass("top_wrapper_alt");
		$(".top_wrapper.complete").addClass("top_wrapper_alt.complete");
		$(".topic_select").addClass("topic_select_alt");
		$(".topic_index").addClass("textColor3");
		$(".topic_index").removeClass("textColor1");
		var numOfTopics = $(".select_title h3").length;
		for (i=0; i<numOfTopics; i++){
			var iMod = i+1;
			/* ensure that alternative menu shows double digit topics without a 0 at beginning 101024 */
			var attributeText = $(".topic_select_alt").eq(i).attr("title")
			if (iMod > 9) {
				$(".select_title h3").eq(i).prepend("<span class=\"alt_menu_num\">"+iMod+"<br></span>");
				$(".topic_select_alt").eq(i).attr("title", +iMod + " "+attributeText);
			}
			else {
				$(".select_title h3").eq(i).prepend("<span class=\"alt_menu_num\">"+0+iMod+"<br></span>");
				$(".topic_select_alt").eq(i).attr("title", "0"+iMod + " "+attributeText);
			}
		}
		$(".select_title").addClass("select_title_alt");
		//$(".alt_menu_num").css("display","block");
		$(".heading_area").children("img").hide();
		$(".heading_area").addClass("heading_area_alt");
		$(".progress").addClass("progress_alt");
		$(".select_bottom").addClass("select_bottom_alt");
		$(".select_bottom_alt").children(".start_img").each(function(){
			if ($(this).attr("src")=="images/general_int/section_locked.png"){
				$(this).attr("src","images/custom_int/menu_tick_locked.png");
			}
		});
		$(".menu_btns_header").addClass("menu_btns_header_alt");
		$(".topic_select").children(".overlay").addClass("overlay_alt");
		if(document.textDirection=="rtl") {
			$(".topic_select").addClass("topic_select_alt_rtl");
			$(".heading_area").addClass("heading_area_alt_rtl");
			$(".progress").addClass("progress_alt_rtl");
			$(".select_bottom").addClass("select_bottom_alt_rtl");
		}	 
	}
	
	/* custom branching based on CITI070 */
	/*if(document.hasBranches){
		
		if(document.userBranch == 0){
		
			$(".menu_grid").css("display","none");
			$(".branch_grid").css("display","none");
			$(".recap_grid").css("display","block");
		}else{
			$(".branch_grid").css("display","none");
			$(".recap_grid").css("display","none");
		}
	}else{
		/*$(".menu_grid").css("display","block");*/
		/*$(".branch_grid").css("display","none");
		$(".recap_grid").css("display","none");
	}*/
}

/* 20221021 ensure burger menu window is focused on and cannot be tabbed out of */
$('.burger_index').find('.burger_close').on('keydown', function(e) {
	if ((e.which == 9) && (!e.shiftKey)) {
		e.preventDefault();		
		/* client learning design specs 2025 v4.3 */
		/* 20240130 accessibility 2024 */
		/* $('.burger_index').find('.burger_home').focus(); */
		$('.burger_index').find('.burger_select').eq(0).focus(); 
	}
});

/* 20221021 ensure burger menu window is focused on and cannot be tabbed out of */
$('.burger_index').find('.burger_close').on('keydown', function(e) {
	if ((e.which == 9) && (e.shiftKey)) {
		e.preventDefault();
		/* 20240130 accessibility 2024 */
		$('.burger_index').find('.burger_select').eq($('.burger_index').find('.burger_select').length-1).focus();
	}
});

/* 20221021 ensure burger menu window is focused on and cannot be tabbed out of */
/* 20240130 accessibility 2024 */
$('.burger_index').find('.burger_home').on('keydown', function(e) {
	if ((e.which == 9) && (e.shiftKey)) {
		e.preventDefault();
		$('.burger_index').find('.burger_close').focus();
	}	
});

/* 20240130 accessibility 2024 */
$('.burger_index').find('.burger_select').eq($('.burger_index').find('.burger_select').length-1).on('keydown', function(e) {
	if ((e.which == 9) && (!e.shiftKey)) {
		e.preventDefault();
		$('.burger_index').find('.burger_close').focus();
	}
});

/* 20240130 accessibility 2024 */
$('.burger_index').find('.burger_top_btn').click(function(e){
	$('.burger_index').find('.burger_close').focus();
});

/* 20240130 accessibility 2024 */
$('.burger_index').find('.burger_top_btn').keypress(function (e) {
	if (e.keyCode == 13 || e.keyCode == 32) {
		$(this).trigger('click');
	}
});

/* 240424 Added to close hotword popups when clicking on area outside of popup */
$('.dialogue_box').click(function(e){
	if(((e.target === this) && (!$(this).hasClass('preTestBG')))||($(e.target).attr('class')=='row')&& (!$(this).hasClass('preTestBG'))){
		//console.log("background clicked");
		closeErrorPopupOrCourse();
	  }
	else {
		//console.log("background not clicked");
	}
});