interfaceOffset = 60;  		//The height of the top part of the interface so that the auto scrolling isn't off.
interfaceBottomOffset = 33;
phone_interfaceBottomOffset = 40;

function init_interface_buttons(){
	setTimeout("introAnimation()",500); // Give it time for all the elements to load
	
	//If the course is on android we need to change the style of the buttons slightly.
	if(isAndroid == true){
		$(".circle_button").addClass("androidBtn")
	}
	
	$(".pMenuBtn").bind("click touch",function(e) {
		togglePhoneMenu();
		return false;
	});
	
	$(".phoneMenu div.closeButton").bind("click touch",function(e) {
		closePhoneMenu(true);
		return false;
	});
	
	$(".pFeedback").bind("click touch",function(e) {
		if($(this).hasClass("disabled")) return false;
		toggleMobileFeedback()
		return false;
	});
	
	
	$(".pBackBtn, .backBtn > .circle_button").click(function() {
		if($(this).hasClass("disable_cb") || $(this).hasClass("disabled")) return
		if ($("#audioOverlay").is(":visible")) return false;
		goBack();
		return false;
	});
	
	$(".pNextBtn, .nextBtn > .circle_button").click(function() {
		if($(this).hasClass("disable_cb") || $(this).hasClass("disabled")) return
		if ($("#audioOverlay").is(":visible")) return false;
		goNext();
		return false;
	})
	
/*	$(".menuBtn > .menu").click(function() {
		if(!$(this).hasClass("disable_cb")) {
			loadToolsPopup('menu',$(this).parent());
		}
	})*/

	$(".menuBtn > .menu").click(function() {
		loadToolsPopup('menu',$(this).parent());
	})

	$('.topBtn , .topBtnWide, .pmenuBtn').bind("click touch",function(e) {
		if(audioAsked==0) return;
		
		if($(".phoneMenu").hasClass("menuOpen")){
			closePhoneMenu(false);
		}
		
		switch($(this).attr("id").toLowerCase()){
			case "resources":
				loadToolsPopup("resources",$(this));
			break;
			case "glossary":
				loadToolsPopup("glossary",$(this));
			break;
			case "transcript":
				loadToolsPopup("transcript",$(this));
			break;
			case "menu":
				loadToolsPopup("menu",$(this));
			break;
			case "help":
				loadToolsPopup("help",$(this));
			break;
			case "p_menu":
				togglePhoneMenu()
			break;
			default:
				showWarning("Unknown button: "+$(this).attr("id").toLowerCase()+"\n\nOR\n\nNo button type defined.", "error")
			break;
		}
  });
  
	$(".audioBtn > .audio").click(function() {
		if ($(".audioBtn").hasClass("component_paused")) return false;

		if($(this).parent().hasClass("paused")){
			$(this).parent().removeClass("paused");
			$(".pAudioBtn").removeClass("paused");
			toggleAudio(false)
		}else{
			$(this).parent().addClass("paused")
			$(".pAudioBtn").addClass("paused");
			toggleAudio(true)
		}
		return false;
	});
  
	$(".pAudioBtn").click(function() {
		if ($(".audioBtn").hasClass("component_paused")) return false;

		if($(this).hasClass("paused")){
			$(this).removeClass("paused");
			$(".audioBtn").removeClass("paused");
			toggleAudio(false)
		}else{
			$(this).addClass("paused");
			$(".audioBtn").addClass("paused");
			toggleAudio(true)
		}
		return false;
	});
	
	$(".pReplayBtn, .replayBtn > .replay").click(function() {
		goReplay()									  
		return;
		if ($(this).is(".disabled")) return false;
		$(".audioBtn").removeClass("finished");
		if ($("#player").html()=="") {
			loadAudio(audioFile);	
		} else {
			audio = $('audio').get(0);
			try {
				audio.currentTime=0;
			} catch (e) {
				
			}
			audio.play();
		}
		return false;
	})
	
	$('#updateTracking').click(function(){
		updateTrackingSettings();
	});

	$("#closeMobileFeedback_btn").bind("click touch",function(e) {
		close_feedback_overlay(false);
	});
	$(".pm_feedback").bind("click touch", toggleMobileFeedback);
	
}


function introAnimation() {
	$('.text_i, .circle_button, #page_numbers').show();
	
	var tl = new TimelineMax();
	tl.staggerFrom($('.text_i'), 1, {opacity:0}, 0.2, "stagger");
	tl.staggerFrom($('.circle_button'), 1, {rotation:90, scale:0}, 0.2, "stagger");
}

function disableInterfaceBtn(obj){
	
	if(obj.hasClass("backBtn") && onPhoneCourse==true){
		$(".pBackBtn").addClass("disabled")
	}else if(obj.hasClass("nextBtn") && onPhoneCourse==true){
		$(".pNextBtn").addClass("disabled")
	}
	
	obj.find(".circle_button").addClass("disable_cb")
	obj.addClass("disabled")
}

function enableInterfaceBtn(obj){
	
	if(obj.hasClass("backBtn") && onPhoneCourse==true){
		$(".pBackBtn").removeClass("disabled")
	}else if(obj.hasClass("nextBtn") && onPhoneCourse==true){
		$(".pNextBtn").removeClass("disabled")
	}
	
	obj.find(".circle_button").removeClass("disable_cb")
	obj.removeClass("disabled")
}

function sim_audioBtnPressed(){
	if($(".audioBtn").hasClass("paused")){
		return false
	}else if($(".audioBtn").hasClass("component_paused")){
		$(".audioBtn").removeClass("component_paused")
		$(".pAudioBtn").removeClass("component_paused")
		toggleAudio(false)
	}else{
		$(".audioBtn").addClass("component_paused")
		$(".pAudioBtn").addClass("component_paused")
		toggleAudio(true)
	}
}

//++++++++++++++++++++++++++++++ togglePhoneMenu ++++++++++++++++++++++++++++++++++++++
// Turn on/off the phone menu
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function togglePhoneMenu(){
	var targetMenu = $(".phoneMenu")
	if(targetMenu.hasClass("menuOpen")){
		closePhoneMenu(true);
	}else{
		sim_audioBtnPressed();
		targetMenu.addClass("menuOpen")
		$(".pMenuBtn").addClass("selected")
		addBlackOut("all");
		TweenMax.to(targetMenu, 0.5, {left:"50%", startAt:{left:"-50px", display:'block'}, ease:Back.easeOut});
	}
}

function closePhoneMenu(closeAll){
	sim_audioBtnPressed();
	var targetMenu = $(".phoneMenu")
	targetMenu.removeClass("menuOpen")
	$(".pMenuBtn").removeClass("selected")
	TweenMax.to(targetMenu, 0.5, {left:"-200px", display:'none', startAt:{display:'block'}, ease:Back.easeOut});
	if(closeAll)removeBlackOut();
}

