var profile;

// base profile types
var userIsManager = false;
var userIsSales = false;
var userIsInternational = false;
var userIsContractor = false;

// evaluates and sets the profile after the user has submitted their selections
function evaluateProfile() {
	$("#grid tbody td:not(:first-child)").each(function(index) {
		var id = $(this).attr('q_id');
		if(id == 0  && $(this).hasClass('selected')) {
			userIsManager = true;
		} else if (id == 2  && $(this).hasClass('selected')) {
			userIsSales = true;
		} else if (id == 4  && $(this).hasClass('selected')) {
			userIsInternational = true;
		} else if (id == 6   && $(this).hasClass('selected')) {
			userIsContractor = true;
		}
	});

	//set up the profiles
	if(userIsManager && userIsSales && userIsInternational && userIsContractor) {
		profile = "9";
	} else if(userIsContractor) {
		if(userIsInternational) {
			// contractor but is international
			profile = "7";
		} else {
			// contractor
			profile = "1";
		}
	} else if(userIsInternational && userIsManager && userIsSales) {
		// international/manager/sales
		profile = "2";
	} else if(userIsInternational && userIsManager) {
		// international/manager
		profile = "3";
	} else if(userIsInternational && userIsSales) {
		// international/sales
		profile = "4";
	} else if(userIsManager && userIsSales) {
		// manager/sales
		profile = "5";
	} else if(userIsInternational) {
		// international
		profile = "6";
	} else if(userIsSales) {
		// sales
		profile = "7";
	} else if(userIsManager) {
		// manager
		profile = "8";
	} else {
		// has said no to everything (general employee)
		profile = "9";
	}
	rebuildCourseUsingProfile(profile);
	lmsVariables.profilerCompleted = "true";
	goNext();
}