/*
Copyright  Interactive Services 2013 - 2015 All Rights Reserved.  
No part of this code may be used, with or without modification, without prior consent from Interactive Services. 
Version 2.1, 01 March 2015
*/

function run_gs_animation(obj, animation, params){
	if (isIE8) return;
	var delayNum = (obj.data('delay')==undefined) ? 0 : obj.data('delay')
	var durationNum = (obj.data('duration')==undefined) ? 1 : obj.data('duration')
	var completion_param = (params==undefined) ? null : params
	
	
	if(obj.hasClass("gs_top") || animation =="gs_top"){
		TweenMax.from(obj, durationNum, {opacity:0, y:"-300px", ease:Back.easeOut, delay:delayNum, onComplete:completeHandler, onCompleteParams:[completion_param]});
	}
	
	if(obj.hasClass("gs_top_out") || animation =="gs_top_out"){
		TweenMax.to(obj, durationNum, {opacity:0, y:"-100px", ease:Back.easeOut, delay:delayNum, onComplete:completeHandler, onCompleteParams:[completion_param]});
	}
	
	if(obj.hasClass("gs_bottom") || animation =="gs_bottom"){
		TweenMax.from(obj, durationNum, {opacity:0, y:"300px", ease:Back.easeOut, delay:delayNum, onComplete:completeHandler, onCompleteParams:[completion_param]});
	}
	
	if(obj.hasClass("gs_left") || animation =="gs_left"){
		TweenMax.from(obj, durationNum, {opacity:0, x:"-300px", ease:Back.easeOut, delay:delayNum, onComplete:completeHandler, onCompleteParams:[completion_param]});
	}

	if(obj.hasClass("gs_left_bounceOff") || animation =="gs_left_bounceOff"){
		TweenMax.from(obj, durationNum, {opacity:0, x:"-300px", delay:delayNum, onComplete:completeHandler, onCompleteParams:[completion_param]});
	}

	if(obj.hasClass("gs_leftSpin") || animation =="gs_leftSpin"){
		TweenMax.from(obj, durationNum, {opacity:0, rotationY:180, x:"-300px", delay:delayNum, onComplete:completeHandler, onCompleteParams:[completion_param]});
	}
	
	if(obj.hasClass("gs_right") || animation =="gs_right"){
		TweenMax.from(obj, durationNum, {opacity:0, x:"300px", ease:Back.easeOut, delay:delayNum, onComplete:completeHandler, onCompleteParams:[completion_param]});
	}

	if(obj.hasClass("gs_right_bounceOff") || animation =="gs_right_bounceOff"){
		TweenMax.from(obj, durationNum, {opacity:0, x:"300px", delay:delayNum, onComplete:completeHandler, onCompleteParams:[completion_param]});
	}
	
	if(obj.hasClass("gs_pop") || animation =="gs_pop"){
		TweenMax.from(obj, durationNum, {opacity:0, scale:0.5, ease:Back.easeOut, delay:delayNum, onComplete:completeHandler, onCompleteParams:[completion_param]});
	}
	
	if(obj.hasClass("gs_pinch") || animation =="gs_pinch"){
		TweenMax.from(obj, durationNum, {opacity:0, scale:2.5, ease:Back.easeOut, delay:delayNum, onComplete:completeHandler, onCompleteParams:[completion_param]});
	}
	
	if(obj.hasClass("gs_option") || animation =="gs_option"){
		TweenMax.from(obj, durationNum, {css:{rotationY:180, scale:2, alpha:0}, ease:Back.easeOut, delay:delayNum, onComplete:completeHandler, onCompleteParams:[completion_param]});
	}
	
	if(obj.hasClass("gs_hide") || animation =="gs_hide"){
		TweenMax.to(obj, 0.5, {opacity:0, scale:0.5, ease:Back.easeOut, delay:delayNum, onComplete:completeHandler, onCompleteParams:[completion_param]});
	}
	
	if(obj.hasClass("gs_restore") || animation =="gs_restore"){
		TweenMax.to(obj, 0.1, {opacity:1, scale:1, ease:Back.easeOut, delay:delayNum, onComplete:completeHandler, onCompleteParams:[completion_param]});
	}

	if(obj.hasClass("gs_fadeout") || animation =="gs_fadeout"){
		TweenMax.to(obj, durationNum, {opacity:0, ease:Back.easeOut, delay:delayNum, onComplete:completeHandler, onCompleteParams:[completion_param]});
	}

	if(obj.hasClass("gs_fadeout_revert") || animation =="gs_fadeout_revert"){
		TweenMax.to(obj, durationNum, {opacity:1, delay:delayNum, onComplete:completeHandler, onCompleteParams:[completion_param]});
	}

	if(obj.hasClass("gs_slideInBottom") || animation =="gs_slideInBottom"){
		TweenMax.from(obj, durationNum, {autoAlpha:0, scale:0.2, y: 150, delay:delayNum, onComplete:completeHandler, onCompleteParams:[completion_param]});
	}

	if(obj.hasClass("gs_slideInTop") || animation =="gs_slideInTop"){
		TweenMax.from(obj, durationNum, {autoAlpha:0, scale:0.2, y: -150, delay:delayNum, onComplete:completeHandler, onCompleteParams:[completion_param]});
	}

	if(obj.hasClass("gs_slideInRight") || animation =="gs_slideInRight"){
		TweenMax.from(obj, durationNum, {autoAlpha:0, scale:0.2, x: 150, ease:Back.easeOut, delay:delayNum, onComplete:completeHandler, onCompleteParams:[completion_param]});
	}

	if(obj.hasClass("gs_slideInLeft") || animation =="gs_slideInLeft"){
		TweenMax.from(obj, durationNum, {autoAlpha:0, scale:0.2, x: -150, ease:Back.easeOut, delay:delayNum, onComplete:completeHandler, onCompleteParams:[completion_param]});
	}

	if(obj.hasClass("gs_rotate") || animation =="gs_rotate"){
		TweenMax.to(obj, durationNum, {rotation:360, delay:delayNum, onComplete:completeHandler, onCompleteParams:[completion_param]});
	}

	if(obj.hasClass("gs_rotate_revert") || animation =="gs_rotate_revert"){
		TweenMax.to(obj, durationNum, {rotation:-360, delay:delayNum, onComplete:completeHandler, onCompleteParams:[completion_param]});
	}

	if(obj.hasClass("gs_rollInLeft") || animation =="gs_rollInLeft"){
		TweenMax.from(obj, 3, {rotation:-920, delay:delayNum, left: 0, autoAlpha:0,  clearProps:"transform", ease:Bounce.easeOut});
	}

	if(obj.hasClass("gs_rollInRight") || animation =="gs_rollInRight"){
		TweenMax.from(obj, 3, {rotation: 920, delay:delayNum, x: "400px", autoAlpha:0,  clearProps:"transform", ease:Bounce.easeOut});
	}

	if(obj.hasClass("gs_glowLight") || animation =="gs_glowLight"){
		TweenMax.to(obj, 1, {delay:delayNum, boxShadow:"0px 0px 36px -10px rgb(255, 255, 255)"});
	}

	if(obj.hasClass("gs_glowDark") || animation =="gs_glowDark"){
		TweenMax.to(obj, 1, {delay:delayNum, boxShadow:"1px 1px 25px 2px rgb(0, 0, 0)"});
	}

	if(obj.hasClass("gs_bounceInLeft") || animation =="gs_bounceInLeft"){
		var tl = new TimelineMax();
		tl.add(TweenMax.from(obj, 2, {top:-100,   delay:delayNum, ease:Bounce.easeOut}), 'slidingIn');
		tl.add(TweenMax.from(obj, 3, {rotation:-920, left: 0, autoAlpha:0,  clearProps:"transform",  delay:delayNum, ease:Bounce.easeOut}), 'slidingIn');
	}

	if(obj.hasClass("gs_bounceInRight") || animation =="gs_bounceInRight"){
		var tl = new TimelineMax();
		tl.add(TweenMax.from(obj, 2, {top:-100,   delay:delayNum, ease:Bounce.easeOut}), 'slidingIn');
		tl.add(TweenMax.from(obj, 3, {rotation: 920, x: "400px", autoAlpha:0,  clearProps:"transform",  delay:delayNum, ease:Bounce.easeOut}), 'slidingIn');
	}

	if(obj.hasClass("gs_star") || animation =="gs_star"){
		var tl = new TimelineMax();
		tl.from(obj, 0.6, {scaleX:0.01, ease: Circ.easeOut, delay:delayNum});
		tl.from(obj, 0.9, {scaleY:0.01, ease: Bounce.easeOut});
	}

	if(obj.hasClass("gs_star2") || animation =="gs_star2"){
		var tl = new TimelineMax();
		tl.from(obj, 0.6, {scaleY:0.01, ease: Circ.easeOut, delay:delayNum});
		tl.from(obj, 0.9, {scaleX:0.01, ease: Bounce.easeOut});
	}

	if(obj.hasClass("gs_text1") || animation =="gs_text1"){
		var mySplitText = new SplitText(obj, {type:"words"}),
    tl = new TimelineLite({onComplete:resetTxt, onCompleteParams: [mySplitText]}),
    numChars = mySplitText.words.length;
    	
		for(var i = 0; i < numChars; i++){
		  tl.from(mySplitText.words[i], 2, {opacity:0, delay:delayNum}, Math.random() * 2);
		}
	}

	if(obj.hasClass("gs_text2") || animation =="gs_text2"){
		var mySplitText = new SplitText(obj, {type:"lines,words"}),
    tl = new TimelineLite({onComplete:resetTxt, onCompleteParams: [mySplitText]});
   	tl.staggerFrom(mySplitText.lines, 0.5, {delay:delayNum, opacity:0, rotationX:-180, force3D:true, transformOrigin:"top center -50"}, 0.2);
	}

	if(obj.hasClass("gs_text3") || animation =="gs_text3"){
		var mySplitText = new SplitText(obj, {type:"chars,words"}),
    tl = new TimelineLite({onComplete:resetTxt, onCompleteParams: [mySplitText]});
   	tl.staggerFrom(mySplitText.chars, 0.6, {scale:4, autoAlpha:0,  rotationX:-180,  transformOrigin:"100% 50%", ease:Back.easeOut}, 0.02);		
	}

	if(obj.hasClass("gs_text4") || animation =="gs_text4"){
		var mySplitText = new SplitText(obj, {type:"words"}),
    tl = new TimelineLite({onComplete:resetTxt, onCompleteParams: [mySplitText]});
   
	  $(mySplitText.words).each(function(index,el){
	    tl.from($(el), 1, {opacity:0, force3D:true}, index * 0.01);
	    tl.from($(el), 1, {scale:index % 2 == 0  ? 0 : 2, ease:Back.easeOut}, index * 0.01); 
	  });
	}
	
	if((obj.hasClass("gs_multiQFeedbacj") || animation =="gs_multiQFeedbacj") && $("#wrapper").hasClass("mq_complete")){
		var goFeedback_tl = new TimelineMax();
		goFeedback_tl.to($(".centreContentContainer"), 0.5, {scrollTop:$(".centreContentContainer")[0].scrollHeight, delay:delayNum, ease:Linear.easeNone});
		goFeedback_tl.from(obj, durationNum, {opacity:0, x:"-300px", ease:Back.easeOut, onComplete:completeHandler, onCompleteParams:[completion_param]});
	}
}
//++++++++++++++++++++ resetTxt() ++++++++++++++++++++
// Function to revert the text string back to before 
// it was split up.
//++++++++++++++++++++++++++++++++++++++++++++++++++++
function resetTxt(txtObj){
	txtObj.revert();
}

function completeHandler(vars){
	resizeWindowCheck();
	if(vars == null) return;
	
	switch(vars){
		case "vid_close":
			run_gs_animation($("#videoOverlay"), "gs_restore")
			$("#videoBlackout").hide();
			$("#videoOverlay").addClass("hidden");
		break;
		case "tool_close":
			run_gs_animation($("#menu_Panel > #menuGroup"), "gs_restore")
			$("#menu_Panel").hide();
		break;
	}
}

function run_screen_animation(animation, duration, params) {
	if (isIE8 || currentPage.number === 0 || screenAnimation[1] === false|| isMobile()) {
		$('.previous_content').remove();
		
		return false;
	}
	var durationNum = (duration===undefined) ? 1 : duration;
	var completion_param = (params==undefined) ? null : params;

	//clear DOM from previous screen
	if($($('.container')[1]))
		$($('.container')[1]).remove();

	//clone current screen
	var clone = $('#centreContent').clone();
	$('.centreContentContainer').append(clone);
	$($('.container')[1]).addClass('previous_content').empty();

	switch (animation) {
	    case "gs_s_leftRight":
			TweenMax.from('.container', durationNum, {css:{right:0}, ease:Linear.easeNone});
			TweenMax.to('.previous_content', durationNum, {css:{right:-$('#centreContent').width()}, ease:Linear.easeNone, onComplete:screenAnimEnd, clearProps:'all'});
	        return true;
	    case "gs_s_rightLeft":
			TweenMax.from('.container', durationNum, {css:{right:0}, ease:Linear.easeNone});
			TweenMax.to('.previous_content', durationNum, {css:{right:$('#centreContent').width()}, ease:Linear.easeNone, onComplete:screenAnimEnd, clearProps:'all'});
	        return true;
	    case "gs_s_topBottom":
			TweenMax.from('.container', durationNum, {css:{top:0}, ease:Linear.easeNone});
			TweenMax.to('.previous_content', durationNum, {css:{top:$(window).height()}, ease:Linear.easeNone, onComplete:screenAnimEnd});
	        return true;
	    case "gs_s_bottomTop":
			TweenMax.from('.container', durationNum, {css:{top:0}, ease:Linear.easeNone});
			TweenMax.to('.previous_content', durationNum, {css:{top:-$(window).height()}, ease:Linear.easeNone, onComplete:screenAnimEnd});
		    return true;
	}

	return false;
}
//callback when run_screen_animation finishes
function screenAnimEnd() {
	$('.previous_content').addClass('completed_anim');
	return true;
}




