/*
Copyright  Interactive Services 2013 - 2015 All Rights Reserved.  
No part of this code may be used, with or without modification, without prior consent from Interactive Services. 
Version 2.1, 01 March 2015
*/

function initMenu(){
	$('#menuarea').empty();
	drawSubNodes(course)
	updateMenuProgressIndicators()
	assignMenuFunctionality()
}

function drawSubNodes(obj){
	for (var i = 0; i<obj.subNodes.length; i++) {
		if(obj.subNodes[i].depth == 0){
			var rowClass = "menuItem_tier1 menu_notStarted menu_txt_1"
		}else if(obj.subNodes[i].depth == 1){
			var rowClass = "menuItem_tier2 menu_notStarted menu_txt_2"
		}else if(obj.subNodes[i].depth == 2){
			var rowClass = "menuItem_tier3 menu_notStarted menu_txt_3"
		}  
		
		if(obj.subNodes[i].profiling_screen != "true") $('#menuarea').append("<div class='"+rowClass+"' data-screentype='"+obj.subNodes[i].type+"' id='"+obj.subNodes[i].id+"'>"+obj.subNodes[i].title+"</div>");

		if (obj.subNodes[i].subNodes != undefined && obj.subNodes[i].subNodes.length > 0){
				drawSubNodes(obj.subNodes[i]);
		}
	}
}

function updateMenuProgressIndicators(){
	$(".menuItem_tier1, .menuItem_tier2, .menuItem_tier3").each(function(){
		var nodeProgress = checkNodeProgress(findObjectById(course, $(this).attr("id")));
		if(nodeProgress >= 2){
			$(this).removeClass("disabledMenuItem").removeClass("menu_notStarted").removeClass("menu_inprogress").addClass("menu_completed")
		}else if(nodeProgress == 1){
			$(this).removeClass("disabledMenuItem").removeClass("menu_notStarted").removeClass("menu_completed").addClass("menu_inprogress")
		}else{
			$(this).removeClass("disabledMenuItem").removeClass("menu_inprogress").removeClass("menu_completed").addClass("menu_notStarted")
			
			if ((menu_lock==true) || ((islCompletion.post_exam_disabled=="on") && ($(this).data('screentype')=="post_exam")) ) {
				$(this).addClass("disabledMenuItem");
			}
		}
	});
}

function assignMenuFunctionality(){
	$(".menuItem_tier1, .menuItem_tier2, .menuItem_tier3").bind("click touch",function(e) {
		if($(this).hasClass("disabledMenuItem"))return false;
		var objId = $(this).attr("id");
		loadPage(getFirstPageOfGroup(findObjectById(course , objId)));
		sim_audioBtnPressed();
		$("#menu_Panel").hide();
		removeBlackOut();
		loadAudio('blank.mp3');
		e.stopPropagation();
		e.preventDefault();
	});
}

function closeMenu(){
	sim_audioBtnPressed();
	toggleVideo("unpause");
	if(videoPlaying && videoPaused){
		resumeVideo();
	}
	
	if(isIE8){
		$("#menu_Panel").hide();
	}else{
		var closeMenuTL = new TimelineMax();
		closeMenuTL.to($("#menu_Panel"), 0.5, {left:"-550px", ease:Back.easeOut});
		closeMenuTL.to($("#menu_Panel"), 0.1, {display:"none"});
	}
	removeBlackOut();
}


function resizeMenu(){
	if(onPhoneCourse){
		$("#menu_Panel").addClass("compPhoneMenu")
		var extraSpace = 10;
	}else{
		$("#menu_Panel").removeClass("compPhoneMenu")
		var extraSpace = -20;
	}
	
	var panelOffest = $("#menu_Panel").offset();
	var closeBtnHeight = $("#menu_Panel div.closeButton").height();
	var menuHeaderHeight = $(".menu_header").height();
	
	var targetHeight = definedHeight-(closeBtnHeight + menuHeaderHeight+panelOffest.top+extraSpace)
	$(".menu_content").css("max-height", targetHeight+"px");
}





