generateSpriteSheet = function(spriteContainer, spriteSheetURL ,animationJSONURL, tlArguments)
{
	var tl = new TimelineMax(tlArguments);
	var spriteContainer = document.getElementById(spriteContainer);

	$.getJSON( animationJSONURL, function( data ) {
		spriteContainer.style.width = data.frames[0].sourceSize.w + "px";
		spriteContainer.style.height = data.frames[0].sourceSize.h + "px";
		spriteContainer.style.background = "url("+spriteSheetURL+")";

		$.each( data, function( key, val ) {
		    for(var i = 0, k=0; i < val.length; i++, k+=0.05){
		    	tl.to(spriteContainer, 0.0,{css:{backgroundPosition:(val[i].frame.x*-1 + "px " + val[i].frame.y*-1 + "px")}}, k);
			}
	  	});
	});
	return tl;
}; 