/************************************************************************************/
/***************************** SETUP QUESTIONS **************************************/
/************************************************************************************/
/* Global arrays for remembering original order of question options */
var qOrig = new Array();
var triesAllowed = -1;
var question_type = null;
var displayFeedback = "on";
var questionColor = "";
var q_indicators = "";
var q_randomisation = "";
var q_toggle = "";
var q_tracking = ""
var cs_question = "";
var sortAble = null;
var timeout1 = null;
var goFeedback_tl = null;
var goQuestion_tl = null;

//++++++++++++++++++++++ setupQuestionParameters +++++++++++++++++++++++++++++
// Set up the paramaters for a question
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function setupQuestionParameters(){
	if(currentPage.parent.type.indexOf("_exam") != -1){
		triesAllowed = islQuestions.assessment_attempts;
	}else{
		triesAllowed = ($("#questionPanel").attr("attempts") !=undefined) ? parseInt($("#questionPanel").attr("attempts")) : islQuestions.attempts
	}
	question_type = ($("#questionPanel").attr("q_type") !=undefined) ? $("#questionPanel").attr("q_type") : "SAMC"
	displayFeedback = ($("#questionPanel").attr("feedback") !=undefined) ? $("#questionPanel").attr("feedback") : islQuestions.feedback
	cs_question = ((currentPage.parent.type !=undefined) && (currentPage.parent.type.toLowerCase()=="case_study")) ? "on" : islQuestions.case_study
	questionColor = ($("#questionPanel").attr("qstyle") !=undefined) ? $("#questionPanel").attr("qstyle") : "#ffffff"
	q_indicators = ($("#questionPanel").attr("indicators") !=undefined) ? $("#questionPanel").attr("indicators") : islQuestions.indicators
	q_randomisation =  ($("#questionPanel").attr("randomisation") !=undefined) ? $("#questionPanel").attr("randomisation") : islQuestions.randomisation
	q_toggle =  ($("#questionPanel").attr("toggle") !=undefined) ? $("#questionPanel").attr("toggle") : islQuestions.toggle
	q_tracking =  ($("#questionPanel").attr("questionLevelTracking") !=undefined) ? $("#questionPanel").attr("questionLevelTracking") : islQuestions.questionLevelTracking
	
	$("#questionPanel").attr('numAttempts', 0);
	
	if(q_tracking == "on" && delivery.toLowerCase()=="scorm"){
		var startTime = new Date().getTime();
		$("#questionPanel").attr('startTime', startTime);
	}
	
	if((question_type=="MAMC") || (question_type=="MCG") || (question_type=="SAMC")|| (question_type=="SEQ")){
		$(".qOpt").each(function(index) {
			$(this).attr('q_id', index);
		});
	}else if(question_type=="GRID" || question_type=="GRID_MULTI"){
		$("#grid tbody td:not(:first-child)").each(function(index) {
			$(this).attr('q_id', index);
		});
	} else if(question_type=="SAMC_HS" || question_type=="MAMC_HS") {
    $(".hs").each(function(index){
			$(this).attr('q_id', index);
		});
  }
	if(question_type!="SEQ"){
		$("#qSubmit").addClass("disabled"); //Make sure the submit button is disabled
	}else{
		$("#qSubmit").removeClass("disabled");
	}
	$("#qSubmit").attr("btn_func", "submit");
	
	if(answerindicator) turnOnIndicator();
	//ADD IN THE NUMBER COUNT TO THE OPTION IF ITS A TAP SCREEN.
	if(("#tapAreas").length){
		$("#tapAreas li").each(function(idx) {
				$(this).append("<span id=\"hs_num\" class=\"hotspot_num\">"+(idx+1)+"</span>");
		});
	}
}
//++++++++++++++++++++++ setupQuestionControls +++++++++++++++++++++++++++++++
// Set up the button functionality for the various question types.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function setupQuestionControls() {
	$(".qOpt").addClass(question_type); 
	if (question_type == "SEQ") {	  
	  sortAble=$("#sortable .options_container").sortable({		  
	  	axis:"y",
	  	containment: "parent",
	    sort: function(){ //THIS CODE IS TO KEEP THE NUMBERS IN ORDER WHEN THEY ARE MOVED AROUND.
	      keepNumbersInSequence($(this)) 
		  }
		});
	  $("#sortable div").disableSelection(); 
	  match_dragdrop_sizes();
	  fix_sortable_height();
	}else if (question_type.toLowerCase() == "grid" || question_type.toLowerCase() == "grid_multi") {
		$("#grid tbody td:not(:first-child)").bind("click", grid_functionality);
	} else if ((question_type.toLowerCase() == "samc")||(question_type.toLowerCase() == "mcg")||(question_type.toLowerCase() == "mamc")) {
			$(".qOpt").bind("click", mc_functionality);
	} else if (question_type.toLowerCase() == "samc_hs" || question_type.toLowerCase() == "mamc_hs") {
      $(".hs").bind("click", mc_functionality);
      if($('#hs_q_map').length){
				$('.map').maphilight({neverOn:false});
			}
  }
}

//+++++++++++++++++++++ mc_functionality() ++++++++++++++++++++++++++++++++++
// Functionality of the options when they are pressed. Be tapped or tapped and 
// evaluate the answer.
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function mc_functionality(event){
	if(courseAudio && audioAsked==1){
		if($(this).attr("audioFile")!=undefined){
			loadAudio($(this).attr("audioFile"));
		}
		
		if($(this).attr("sfxFile")!=undefined){
			playSfxAudio($(this).attr("sfxFile"));
		}
	}
	
	if ((question_type == "SAMC") || (question_type=="MCG") || (question_type == "SAMC_HS")) {
		if($(this).hasClass("tappedOpt")){
			$(this).removeClass("tappedOpt");
		}else{
			$(".tappedOpt").removeClass("tappedOpt");
			$(this).addClass("tappedOpt");
		}

		if($('#hs_q_map').length){
			var data = $(this).mouseout().data('maphilight') || {};
			resetHotspotQOptions();   
			data.alwaysOn = true;
			$(this).data('maphilight', data).trigger('alwaysOn.maphilight');
		}
		
		if ($("#qSubmit").length) {
			if($(".tappedOpt").length>0){
				$("#qSubmit").removeClass("disabled");
			}else{
				$("#qSubmit").addClass("disabled");
			}
		} 
		else {
			btnAction("submit");
		}
	}
	else if (question_type == "MAMC" || question_type == "MAMC_HS") {
		$(this).toggleClass("tappedOpt");
		
		//HOTSPOT FUNCTIONALITY
		if($('#hs_q_map').length){
			var data = $(this).mouseout().data('maphilight') || {};
			data.alwaysOn = !data.alwaysOn;
			$(this).data('maphilight', data).trigger('alwaysOn.maphilight');
		}
		if($(".tappedOpt").length>0){
			$("#qSubmit").removeClass("disabled");
		}else{
			$("#qSubmit").addClass("disabled");
		}
	}
	event.preventDefault();
	event.stopPropagation();
}

//+++++++++++++++++++++ grid_functionality() ++++++++++++++++++++++++++++++++++++
// Functionality of the grid options when they are pressed.
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function grid_functionality(event){
	if(courseAudio && audioAsked==1 && $(this).attr("sfxFile")!=undefined){
		playSfxAudio($(this).attr("sfxFile"));
	}
	if(question_type.toLowerCase().indexOf("grid_multi") == -1) {
		$(this).parent().find("td").removeClass("selected");	
		$(this).addClass("selected");	
	} else {
		$(this).toggleClass("selected");
	}
	checkGridSubmitBtn()
	event.preventDefault();
	event.stopPropagation();	
}

//++++++++++++++++++++++ checkGridSubmitBtn ++++++++++++++++++++++++++++++++++
// Check if the Submit button on a grid question can be enabled.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function checkGridSubmitBtn(){
	var rowCount = $('#grid tbody tr').length;

	if(question_type.toLowerCase().indexOf("grid_multi") == -1) {
		var numItems = $('.selected').length;
	} else {
		var numItems = 0;
		$('#grid tbody tr').each(function() {
			if($(this).find(".selected").length > 0) numItems++;
		});
	}

	var submitButton;

	//alert($('#wrapper').attr('profilescreen'));
	if($('#wrapper').attr('profilescreen') == "true") {
		submitButton =$("#qProfileSubmit");
	} else {
		submitButton =$("#qSubmit");
	}
	
	if(numItems == rowCount){
		submitButton.removeClass("disabled")
	}else{
		submitButton.addClass("disabled")
	}
}

//+++++++++++++++++++++ keepNumbersInSequence() +++++++++++++++++++++++++++++++++
// This function keeps the numbering of the sequencing question in the correct
// order when the options are moved around or reset.
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function keepNumbersInSequence(obj){
	var $lis = obj.children('li');
	$lis.each(function(){
		var $li = $(this);
		var hindex = $lis.filter('.ui-sortable-helper').index();
		if(hindex == -1){//when the options are being reset
			$li.val($li.index()+1);
		}else if( !$li.is('.ui-sortable-helper') ){ //when the options are being moved
			var index = $li.index();
			index = index < hindex ? index + 1 : index;
			$li.val(index);
			if( $li.is('.ui-sortable-placeholder') ){
				$lis.filter('.ui-sortable-helper').val(index);
			}
		}
	});
}

//+++++++++++++++++++++ randomise_Options() ++++++++++++++++++++++++++++++++++++
// Randomise (or shuffle) the options so that the correct answer moves around.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function randomise_Options() {
	if (question_type=="GRID"){
		var $container = $("#grid tbody.options_container");	
		$container.html(shuffle($container.children().get()));
	} else if ((question_type=="MAMC") || (question_type=="SAMC") || (question_type=="MCG")|| (question_type=="SEQ")) {
		var $container = $(".optBox .options_container");
		$container.html(shuffle($container.children().get()));
		
		if(question_type=="SEQ"){
			$('.qOpt').each(function(index){
				$(this).attr('orig_pos', index)
    	});
		}
	}
}

//+++++++++++++++++++++++++++++++ shuffle() ++++++++++++++++++++++++++++++++++++
// Move around the options in a random fashion so they are randomised.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function shuffle(o){
	for(var j, x, i = o.length; i; j = parseInt(Math.random() * i), x = o[--i], o[i] = o[j], o[j] = x);
	return o;
};

//++++++++++++++++++++++ match_dragdrop_sizes ++++++++++++++++++++++++++++++++
// Resize the drag-drop questions and answers to match the highest
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function match_dragdrop_sizes(){
	var ar = [];
	var $elements = $("#sortable.drag-drop .qOpt, #sortable.drag-drop .qAns");
	if (!$elements.length) return;
	$elements.each(function() {
	  $(this).height('auto');	
	  ar.push($(this).outerHeight());		  
	});	
	var maxHeight = Math.max.apply( Math, ar );	
	$elements.each(function() {
		$(this).css("min-height", maxHeight+"px");		  
	});	
}

function fix_sortable_height(){
	var $options_container = $("#sortable .options_container");
	if ($options_container.length) {
		$options_container.css("min-height", $options_container.outerHeight());
	}
}

/************************************************************************************/
/***************************** POST OK FUNCTIONS ************************************/
/************************************************************************************/

//++++++++++++++++++++++ evalAnswer ++++++++++++++++++++++++++++++++++++++++++
// Evaluate the users answer and give feedback as required.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function evalAnswer(){
	disableOptions();
	$("#qSubmit").addClass("disabled");
	if(question_type.toLowerCase().indexOf("grid_multi") == -1) {
		var answer_style = applyColor(questionColor).split("");
	} else {
		var answer_style = eval(questionColor.substr(1));
	}
	
	var numCorrect = 0;
	var numIncorrect = 0;
	var numCorrectOpts= 0
	var attempts = parseInt($("#questionPanel").attr('numAttempts'))+1;
	$("#questionPanel").attr('numAttempts', attempts);
	//FIND NUMBER OF CORRECT ANSWERS
	for(var i=0;i<answer_style.length; i++){
		numCorrectOpts += parseInt(answer_style[i])
	}
	
	islDebug("---- ATTEMPT #"+parseInt($("#questionPanel").attr('numAttempts'))+" ---")
	if(question_type.toLowerCase()=="samc" || question_type.toLowerCase()=="mamc" || question_type.toLowerCase()=="mcg"){
		
		$(".qOpt").each(function(index) {
			if(answer_style[parseInt($(this).attr('q_id'))] == 1 && $(this).hasClass('tappedOpt')){
				numCorrect++;
			}else if(answer_style[parseInt($(this).attr('q_id'))] != 1 && $(this).hasClass('tappedOpt')){
				numIncorrect++;
			}
		});  
  }else if(question_type.toLowerCase()=="samc_hs" || question_type.toLowerCase()=="mamc_hs"){
  	$(".hs").each(function(index) {
			if(answer_style[parseInt($(this).attr('q_id'))] == 1 && $(this).hasClass('tappedOpt')){
				numCorrect++;
			}else if(answer_style[parseInt($(this).attr('q_id'))] != 1 && $(this).hasClass('tappedOpt')){
				numIncorrect++;
			}
		});   
	}else if(question_type.toLowerCase()=="grid"){
		$("#grid tbody td:not(:first-child)").each(function(index) {
			if(answer_style[parseInt($(this).attr('q_id'))] == 1 && $(this).hasClass('selected')){
				numCorrect++;
			}else if(answer_style[parseInt($(this).attr('q_id'))] != 1 && $(this).hasClass('selected')){
				numIncorrect++;
			}
		});
	}else if(question_type.toLowerCase()=="grid_multi") {
		$("#grid tbody td:not(:first-child)").each(function(index) {
			if(answer_style[parseInt($(this).attr('q_id'))] == 1 && $(this).hasClass('selected')){				
				numCorrect++;
			}else if((answer_style[parseInt($(this).attr('q_id'))] == 1 && !$(this).hasClass('selected')) || (answer_style[parseInt($(this).attr('q_id'))] != 1 && $(this).hasClass('selected'))){
				numIncorrect++;
			} 
		});
	}else if(question_type.toLowerCase()=="seq"){
		seqArray =  applyColor(questionColor).match(/.{4}|.{1,2}/g);
		numCorrectOpts = seqArray.length; 
		$(".qOpt").each(function(index) {
			if(parseInt(seqArray[$(this).attr('q_id')].split("")[index])==1){
				numCorrect++;
			}else{
				numIncorrect++;
			}
		});
	}
	
	currentPage.scoreProgress = (numIncorrect == 0) ? 1 : 0

	if((q_toggle == "on")&& (numIncorrect != 0 && parseInt($("#questionPanel").attr('numAttempts')) == triesAllowed)){
		var btn_text = (question_type.toLowerCase()=="grid" || question_type.toLowerCase()=="grid_multi"|| question_type.toLowerCase()=="seq") ? txt_label_toggleon : txt_label_toggleoff
		var btn_function = "toggleon";
		
		if($("#qSubmit").find(".pillBtn_middle").length >0){
			$("#qSubmit").find(".txtHolder").html(btn_text);
		}else{
			$("#qSubmit").html(btn_text);
			resizeQuestionSlides();
		}
		$("#qSubmit").attr("btn_func", btn_function);
		$("#qSubmit").addClass("wideBtn");
		$("#qSubmit").removeClass("disabled");
	}
	
	if(displayFeedback == "on"){
		showFeedback(numCorrect, numIncorrect, numCorrectOpts)
	}else if(displayFeedback == "slide"){
		showSlideFeedback(numCorrect, numIncorrect, numCorrectOpts)
	}
	
	if((numIncorrect == 0 && numCorrect == numCorrectOpts) || parseInt($("#questionPanel").attr('numAttempts')) == triesAllowed){
		if(q_indicators == "ticks"){ 
			showTicks()
		}
	}
	
	//Enable the next button so that the user can move on.
	if((numIncorrect == 0 && numCorrect == numCorrectOpts) || parseInt($("#questionPanel").attr('numAttempts')) == triesAllowed){
		if(q_tracking == "on" && (delivery.toLowerCase()=="scorm" || delivery.toLowerCase()=="scorm2004")){
			var question_isCorrect = (numIncorrect == 0 && numCorrect == numCorrectOpts)
			updateQuestionLevelTracking(question_isCorrect)
		}
		updateCurrentPageProgress(2);
		updateGUI();
		if(onPhoneCourse){
			$("#guiFeedback").find("#closeMobileFeedback_btn").removeClass("invisible")
			$(".pFeedback").removeClass("disabled");
		}
	}
	
}
//+++++++++++++++++++++ enableOptions() ++++++++++++++++++++++++++++++++++++++++
// Re-enable the options once the feedback has been read and dismissed.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function enableOptions(){
	islDebug("[[enableOptions]] (1)", "orange")
	if(question_type.toLowerCase()=="samc" || question_type.toLowerCase()=="mamc" || question_type.toLowerCase()=="mcg"){
		$(".qOpt").each(function(index) {
				$(this).on('click', mc_functionality);
		});
		//$('.opt_style1').removeClass("opt_style1_down");
		//$('.indicator').removeClass("indicator_over");
	}else if(question_type.toLowerCase()=="grid" || question_type.toLowerCase()=="grid_multi"){
		$("#grid tbody td:not(:first-child)").each(function(index) {
				$(this).on('click', grid_functionality);
			
		});
	}else if(question_type.toLowerCase()=="seq"){
		sortAble.sortable( "option", "disabled", false );
	} else if(question_type == "SAMC_HS" || question_type == "MAMC_HS") {
    resetHotspotQOptions();
    if($('#hs_q_map').length){
			$('.map').maphilight({neverOn:false});
		}
    $(".hs").each(function(index) {
				$(this).on('click', mc_functionality);
		});
    if ($(".res").length) {
		$(".visitedSpot").removeClass("visitedSpot");
		hsQRes();
	}
  }
}
//+++++++++++++++++++++ disableOptions() ++++++++++++++++++++++++++++++++++++++++
// Disable the options while the feedback is on screen.
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function disableOptions(){
	if(question_type.toLowerCase()=="samc" || question_type.toLowerCase()=="mamc" || question_type.toLowerCase()=="mcg"){
		$(".qOpt").each(function(index) {
			$(this).off('click');
			$(this).off('mouseover');
		});
	}else if(question_type.toLowerCase()=="grid" || question_type.toLowerCase()=="grid_multi"){
		$("#grid tbody td:not(:first-child)").each(function(index) {
			$(this).off('click');
		});
	}else if(question_type.toLowerCase()=="seq"){
		sortAble.sortable( "option", "disabled", true );
	}else if(question_type.toLowerCase()=="mamc_hs" || question_type.toLowerCase()=="samc_hs"){
		if($('#hs_q_map').length){
			$('.map').maphilight({neverOn:true});
		}
		$(".hs").each(function(index) {
			$(this).off('click');
			$(this).off('mouseover');
		});
	}
}

function resetHotspotQOptions() {
	$(".hs").each(function(index) {
	    var data = $(this).mouseout().data('maphilight') || {};
	    data.alwaysOn = false;
	    $(this).data('maphilight', data).trigger('alwaysOn.maphilight');
	});
}


//+++++++++++++++++++++ showFeedback() ++++++++++++++++++++++++++++++++++++++++
// Show the feedback based on the number of correct|incorrect responses.
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function showFeedback(correct, incorrect, correctOpts){
	$("#guiFeedback").find(".guiRetryBtn").addClass("invisible");
	moreIndicatorViewed = true;
	onPhoneCourse = ($('.phonePanel').css("display").toLowerCase()=="table") ? true : false
	var feedbackTarget = (onPhoneCourse) ? "#guiFeedback" : "#onScreenFeedback"
	$(feedbackTarget).removeClass("correct").removeClass("partial").removeClass("incorrect");
	$("#closeMobileFeedback_btn").removeClass("invisible");
	$(".fb_img_1").attr("src", $(".fb_img_1").attr("incorrect_img"))

	if(incorrect == 0 && correct==correctOpts){
		$(".fb_img_1").attr("src", $(".fb_img_1").attr("correct_img"))
		$(feedbackTarget).addClass("correct");
		
		$(feedbackTarget+" > #feedbackTxt").empty();
		$(feedbackTarget+" > #feedbackTxt").html($("[feedback_type='correct']").html());
	}else if((parseInt($("#questionPanel").attr('numAttempts')) < triesAllowed) && correct>0){
		$(feedbackTarget).addClass("incorrect");
		
		$(feedbackTarget+" > #feedbackTxt").empty();		
		$(feedbackTarget+" > #feedbackTxt").html($("[feedback_type='partically_retry']").html());
		
		setRetryBtn();
		
		$("#closeMobileFeedback_btn").addClass("invisible");
		
	}else if((parseInt($("#questionPanel").attr('numAttempts')) < triesAllowed) && (incorrect>0 || correct>0) ){
		$(feedbackTarget).addClass("incorrect");
		
		$(feedbackTarget+" > #feedbackTxt").empty();		
		$(feedbackTarget+" > #feedbackTxt").html($("[feedback_type='retry']").html());
		
		setRetryBtn();
		
		$("#closeMobileFeedback_btn").addClass("invisible");
		
	}else if((parseInt($("#questionPanel").attr('numAttempts')) == triesAllowed) && correct>0 ){
		$(feedbackTarget).addClass("incorrect");
		
		$(feedbackTarget+" > #feedbackTxt").empty();
		$(feedbackTarget+" > #feedbackTxt").html($("[feedback_type='partically']").html());
		
	}else if((parseInt($("#questionPanel").attr('numAttempts')) == triesAllowed) && incorrect>0 ){
		$(feedbackTarget).addClass("incorrect");
		
		$(feedbackTarget+" > #feedbackTxt").empty();
		$(feedbackTarget+" > #feedbackTxt").html($("[feedback_type='incorrect']").html());
	}
	
	if(onPhoneCourse){
		open_feedback_overlay(false)
	}else if(feedbackOverlay != undefined && feedbackOverlay == true && $("#questionPanel").attr('feedback_overlay') != undefined && $("#questionPanel").attr('feedback_overlay').toLowerCase() == "on") {		
		$(feedbackTarget).appendTo($("#feedbackPanel .feedback_holder"));
		$("#feedbackPanel").removeClass("hidden");	
		$("#feedbackPanel .feedback_holder #onScreenFeedback").show(0);
		run_gs_animation($("#feedbackPanel .feedback_holder #onScreenFeedback"), "gs_pop");
	} else {
		$(feedbackTarget).show(0);
		run_gs_animation($(feedbackTarget), "gs_pop");
	}
}

//+++++++++++++++++++++ showSlideFeedback() ++++++++++++++++++++++++++++++++++++++++
// Shlide the feedback into view.
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function showSlideFeedback(correct, incorrect, correctOpts){
	goFeedback_tl = null;
	goQuestion_tl = null;
	var graphicalFbString = null;
	var questionSlide = $("#slide_question");
	var feedbackSlide = $("#slide_feedback");
	var feedbackTarget = $("#slide_feedback").find(".screenfeedback")
	feedbackTarget.removeClass("correct").addClass("incorrect");
	feedbackTarget.find(".feedbackTxt").empty();
	
	if(incorrect == 0 && correct==correctOpts){
		feedbackTarget.removeClass("incorrect").addClass("correct");
		feedbackTarget.find(".feedbackTxt").html($("p[feedback_type='correct']").html());
		graphicalFbString = $("p[feedback_type='correct']").data("action")
	}else if((parseInt($("#questionPanel").attr('numAttempts')) < triesAllowed) && correct>0){
		feedbackTarget.find(".feedbackTxt").html($("p[feedback_type='partically_retry']").html());
		graphicalFbString = $("p[feedback_type='partically_retry']").data("action")
		setRetryBtn();
	}else if((parseInt($("#questionPanel").attr('numAttempts')) < triesAllowed) && (incorrect>0 || correct>0) ){	
		feedbackTarget.find(".feedbackTxt").html($("p[feedback_type='retry']").html());
		graphicalFbString = $("p[feedback_type='retry']").data("action")
		setRetryBtn();
	}else if((parseInt($("#questionPanel").attr('numAttempts')) == triesAllowed) && correct>0 ){
		feedbackTarget.find(".feedbackTxt").html($("p[feedback_type='partically']").html());
		graphicalFbString = $("p[feedback_type='partically']").data("action")
	}else if((parseInt($("#questionPanel").attr('numAttempts')) == triesAllowed) && incorrect>0 ){
		feedbackTarget.find(".feedbackTxt").html($("p[feedback_type='incorrect']").html());
		graphicalFbString = $("p[feedback_type='incorrect']").data("action")
	}
	
	//SET FEEDBACK AUDIO
	if(feedbackTarget.hasClass("correct") && feedbackSlide.data("correctaudio") !=undefined){
		feedbackSlide.data("audio", feedbackSlide.data("correctaudio"));
	}else if(feedbackTarget.hasClass("incorrect") && feedbackSlide.data("incorrectaudio") !=undefined){
		feedbackSlide.data("audio", feedbackSlide.data("incorrectaudio"));
	}

	//SLIDE TO FEEDBACK
	goFeedback();
	
	//SET UP THE GRAPHICAL FEEDBACK
	var iconString = graphicalFbString.split(",")
	for(var i=0; i<iconString.length; i++){
		$("."+iconString[i]).addClass("active");	
	}
	
	//CHANGE BACKGROUND
	if(feedbackSlide.data('bgimage') != undefined){
		$("#centreContent").css("background-image", "url("+feedbackSlide.data('bgimage')+")")
	} 
}


function goFeedback(){
	if(goQuestion_tl != null) goQuestion_tl.pause();
	
	//SET UP THE NEXT SLIDES INITIAL & END POSITIONS
	var questionSlide = $("#slide_question");
	var feedbackSlide = $("#slide_feedback");
	var targetPos = 0- parseInt(questionSlide.height())
	var startPos = parseInt(questionSlide.height())
	
	
	goFeedback_tl = new TimelineMax();
	goFeedback_tl.set($(".centreContentContainer"), {scrollTop:0});
	goFeedback_tl.addLabel("twoSlidesMove")
	goFeedback_tl.to(questionSlide, 1, {top:targetPos+"px", ease:Linear.easeNone},"twoSlidesMove");
	goFeedback_tl.to(feedbackSlide, 1, {top:"0px", startAt:{top:startPos+"px", zIndex:7, display:"block"}, ease:Linear.easeNone}, "twoSlidesMove");
	
	//SHINE ANIMATION
	goFeedback_tl.set($(".animationPath"), {display:"block"});
	goFeedback_tl.addLabel("graphicandsound")
	goFeedback_tl.to($(".animationPath"), 1, {rotation:360, startAt:{rotation:0}}, "graphicandsound");
	goFeedback_tl.set(questionSlide, {display: "none", onComplete:checkForSettings, onCompleteParams:[feedbackSlide]}, "graphicandsound");
	goFeedback_tl.set($(".animationPath"), {display:"none"});
	goFeedback_tl.set(questionSlide, {display: "none", onComplete:resizeQuestionSlides}); //NEED TO CHECK THE SIZE WHEN EVERYTHING HAS FINISHED.
	
}


function goQuestion(){
	if(goFeedback_tl != null) goFeedback_tl.pause();
	
	//SET UP THE NEXT SLIDES INITIAL & END POSITIONS
	var questionSlide = $("#slide_question");
	var feedbackSlide = $("#slide_feedback");
	var targetPos = parseInt(questionSlide.height())
	var startPos = 0- parseInt(questionSlide.height())
	
	goQuestion_tl = new TimelineMax();
	goQuestion_tl.set($(".centreContentContainer"), {scrollTop:0});
	goQuestion_tl.set($("#goToFeedback"), {display: "block"});
	goQuestion_tl.addLabel("twoSlidesMove")
	goQuestion_tl.to(feedbackSlide, 1, {top:targetPos+"px", ease:Linear.easeNone}, "twoSlidesMove");
	goQuestion_tl.to(questionSlide, 1, {top:"0px", startAt:{top:startPos+"px", zIndex:7, display:"block"}, ease:Linear.easeNone}, "twoSlidesMove");
	goQuestion_tl.set(feedbackSlide, {display: "none", onComplete:checkForSettings, onCompleteParams:[questionSlide]});
	goQuestion_tl.set(feedbackSlide, {display: "none", onComplete:resizeQuestionSlides}); //NEED TO CHECK THE SIZE WHEN EVERYTHING HAS FINISHED.
}


function resizeQuestionSlides(){
	var questionSlide = $("#slide_question");
	var feedbackSlide = $("#slide_feedback");
	
	if(questionSlide.css("display") == "block"){
		$('.qSlideHolder').css("min-height","0px")
		var newHeight = ($("#centreContent").height() > questionSlide.height()) ? $("#centreContent").height() : questionSlide.height()
		$('.qSlideHolder').css("min-height", newHeight+"px")
	}else if(feedbackSlide.css("display") == "block"){
		$('.qSlideHolder').css("min-height","0px")
		var newHeight = ($("#centreContent").height() > feedbackSlide.height()) ? $("#centreContent").height() : feedbackSlide.height()
		$('.qSlideHolder').css("min-height", newHeight+"px")
	}
}



//+++++++++++++++++++++ add_feedback_btn() ++++++++++++++++++++++++++++++++++++
// Add retry|continue button to the question feedback.
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function setRetryBtn(){
	if(onPhoneCourse && displayFeedback != "slide"){
		$("#guiFeedback").find(".guiRetryBtn").removeClass("questionbank");
		$("#guiFeedback").find(".guiRetryBtn").html(txt_label_retry);
		$("#guiFeedback").find(".guiRetryBtn").removeClass("invisible");
		$("#guiFeedback").find(".guiRetryBtn").unbind("click touch")
		$("#guiFeedback").find(".guiRetryBtn").bind("click touch",function() {
			btnAction("retry")
		});	
	}else if ($("#qSubmit").length) {
		if($("#qSubmit").find(".pillBtn_middle").length >0){
			$("#qSubmit").find(".txtHolder").html(txt_label_retry);
		}else{
			$("#qSubmit").html(txt_label_retry);
		}
		$("#qSubmit").attr("btn_func", "retry");
		$("#qSubmit").removeClass("disabled");
	}
}

//++++++++++++++++++++++ getQuizFeedback +++++++++++++++++++++++++++++++++++++
// Get the feedback for the user based on how they scored in the Quiz.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function getQuizFeedback() {
	var numCorrect = 0
	var numQuestions = 0
	var numNotAnswered = 0
	for(i = 0; i<currentPage.parent.pageNodes.length;i++){
		if(currentPage.parent.pageNodes[i].type == "question"){
			numQuestions++;
			numCorrect = (currentPage.parent.pageNodes[i].scoreProgress != undefined && currentPage.parent.pageNodes[i].scoreProgress == 1) ? numCorrect+1 : numCorrect
			numNotAnswered = (currentPage.parent.pageNodes[i].scoreProgress == undefined) ? numNotAnswered+1 : numNotAnswered
			islDebug(currentPage.parent.pageNodes[i].src+"  "+currentPage.parent.pageNodes[i].scoreProgress)
		}
	}
	islDebug("currentPage.parent.pageNodes.length: "+currentPage.parent.pageNodes.length+" numNotAnswered: "+numNotAnswered,"green");
	
	if(numNotAnswered != 0 && currentPage.parent.examscore!=-1){
		var percentage = parseInt(currentPage.parent.examscore);
		var numCorrect = (percentage*numQuestions)/100;
	}else{
		var percentage = Math.round(numCorrect/numQuestions * 100);
	}
	
	currentPage.parent.examscore = (percentage >currentPage.parent.examscore) ? percentage : currentPage.parent.examscore 
	var txt = (percentage >= islCompletion.post_exam_passmark) ? $("p[feedback_type='positive']").html() : $("p[feedback_type='negative']").html()
	txt = txt.split("xxx").join(numCorrect);
	txt = txt.split("yyy").join(numQuestions);
	txt = txt.split("zzz").join(percentage);
	$(".final_text").html(txt);	
	
	var promptTxt = (percentage >= islCompletion.post_exam_passmark) ? $("p[prompt_type='positive']").html() : $("p[prompt_type='negative']").html() 
	$(".instruction").html(promptTxt)
	
	if(percentage >= islCompletion.post_exam_passmark){
		$("#printcert").removeClass("invisible")
		$("#retryQuiz").addClass("invisible")
		
		$("#passImage").removeClass("invisible")
		$("#failImage").addClass("invisible")
	}else{
		$("#printcert").addClass("invisible")
		$("#retryQuiz").removeClass("invisible")
		
		$("#passImage").addClass("invisible")
		$("#failImage").removeClass("invisible")
	}
}

//++++++++++++++++++++++ showTicks +++++++++++++++++++++++++++++++++++++++++++
// Show the correct|incorrect tick indicators on each option
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function showTicks() {
	islDebug("[showTicks] called: "+ question_type, "#0000ff" )	
	
	/* SORTABLE */
	if (question_type=="SEQ"){
		seqArray = applyColor(questionColor).match(/.{4}|.{1,2}/g); 
		$(".qOpt").each(function(index) {
			if(parseInt(seqArray[$(this).attr('q_id')].split("")[index])==1){
				$(this).addClass("correctOption")
			}else{
				$(this).addClass("incorrectOption")
			}
		});
	}

	/* GRID */
	if (question_type=="GRID" || question_type=="GRID_MULTI"){
		if(question_type == "GRID") {
			var answer_style = applyColor(questionColor).split("");
		} else {
			var answer_style = eval(questionColor.substr(1));
		}
		$("#grid tbody td:not(:first-child)").each(function(index){
			if(answer_style[parseInt($(this).attr('q_id'))] == 1){
				$(this).addClass("correctOption");
			}else if(answer_style[parseInt($(this).attr('q_id'))] == 0){
				$(this).addClass("incorrectOption");
			}
		})
	}
	
	/* MC */
	if ((question_type=="MAMC") || (question_type=="MCG") || (question_type=="SAMC")) {
		var answer_style = applyColor(questionColor).split("");
		$(".optBox .qOpt").each(function(idx) {
			if(answer_style[parseInt($(this).attr('q_id'))] == 1){
				$(this).addClass("correctOption");
			}else if(answer_style[parseInt($(this).attr('q_id'))] == 0){
				$(this).addClass("incorrectOption");
			}
		})
	}
  /* Hotspot */
  if(question_type=="SAMC_HS" || question_type=="MAMC_HS") {
  	var answer_style = applyColor(questionColor).split("");
    $(".hs").each(function(idx) {
	    var indicator = $("#indicator_" + (idx + 1));
			if(answer_style[parseInt($(this).attr('q_id'))] == 0){
				var incorrectTick = indicator.attr("incorrect_tick");
				indicator.attr("src", incorrectTick);
			}
	    indicator.removeClass("invisible");
    });
  }
        
}
//++++++++++++++++++++++ btnAction +++++++++++++++++++++++++++++++++++++++++++
// Shared function to assign functionality to different input buttons.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function btnAction(btnRef, val) {
	islDebug("btnAction("+btnRef+")", "#343456")
	if (typeof(btnRef)=="undefined") return;
	
	switch (btnRef.toLowerCase()) {
		case "zoom" :
			loadZoomImage(val);
			break;
		case "retry" : 
			enableOptions();
			$(".correctOption").removeClass("correctOption");
			$(".incorrectOption").removeClass("incorrectOption");
			$(".selected").removeClass("selected");
			$(".tappedOpt").removeClass("tappedOpt")
			$(".hotspot_num_selected").removeClass("hotspot_num_selected")
			
			close_feedback_overlay(true);
			$("#onScreenFeedback").hide();
			
			if($("#qSubmit").find(".pillBtn_middle").length >0){
				$("#qSubmit").find(".txtHolder").html(txt_label_submit);
			}else{
				$("#qSubmit").html(txt_label_submit);
			}
			
			$("#goToFeedback").css("display", "none");
			
			$("#qSubmit").attr("btn_func", "submit");
			$("#qSubmit").addClass("disabled")
			if(question_type.toLowerCase()=="seq"){
				$("#qSubmit").removeClass("disabled")
				$(".optBox .options_container").html(sortMyAnswer());
				keepNumbersInSequence($("#sortable div"))
			}
			//scrollToFeedback("question");
			break;
		case "Show Answers" : 
			showActualAnswers();
			break;
		case "submit" : 
			if(cs_question == "on"){
				cs_evalAnswer();
			}else{
				evalAnswer();
			}
			break;
		case "continue" : 
			goNext();
			break;
		case "toggleon" :
			if(question_type.toLowerCase()=="seq"){
				$(".optBox .options_container").html(sortCorrect());
				keepNumbersInSequence($("#sortable div"))
			}
			$(".correctOption").removeClass("correctOption");
			$(".incorrectOption").removeClass("incorrectOption");
			var btn_text = (question_type.toLowerCase()=="grid" || question_type.toLowerCase()=="grid_multi"|| question_type.toLowerCase()=="seq") ? txt_label_toggleoff : txt_label_toggleon
			var btn_function = "toggleoff";
			
			
			if($("#qSubmit").find(".pillBtn_middle").length >0){
				$("#qSubmit").find(".txtHolder").html(btn_text);
			}else{
				$("#qSubmit").html(btn_text);
			}

			$("#qSubmit").attr("btn_func", btn_function);
			break;
		case "toggleoff" :
			if(question_type.toLowerCase()=="seq"){
				$(".optBox .options_container").html(sortMyAnswer());
				keepNumbersInSequence($("#sortable div"))
			}
			showTicks();
			var btn_text = (question_type.toLowerCase()=="grid" || question_type.toLowerCase()=="grid_multi"|| question_type.toLowerCase()=="seq") ? txt_label_toggleon : txt_label_toggleoff
			var btn_function = "toggleon";
			if($("#qSubmit").find(".pillBtn_middle").length >0){
				$("#qSubmit").find(".txtHolder").html(btn_text);
			}else{
				$("#qSubmit").html(btn_text);
			}
			$("#qSubmit").attr("btn_func", btn_function);
			break;
	}
}	

//++++++++++++++++++++++ resetQuiz +++++++++++++++++++++++++++++++++++++++++++
// Function to reset the quiz back to its default state. No answers stored
// for any question.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function resetQuiz(){
	console.log("resetting")
	for(i = 0; i<currentPage.parent.pageNodes.length;i++){
		if(currentPage.parent.pageNodes[i].type == "question"){
			currentPage.parent.pageNodes[i].scoreProgress = 0;
		}
	}
}

//+++++++++++++++++++++++++++ sortCorrect() ++++++++++++++++++++++++++++++++++++
// Reorder the options into the correct sequence.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function sortCorrect(){
		tempArray = new Array($(".qOpt").length);
		if(question_type.toLowerCase().indexOf("grid_multi") != -1) {
			var numSecOptions = $(".options_container > tr td").length - 1;
		} else {
			var numSecOptions = $(".options_container .qOpt").length;
		}	
		if(numSecOptions > 6 || question_type.toLowerCase() == "grid_multi") {
			var secColor = eval(questionColor.substr(1));
			seqArray =  secColor.match(new RegExp('.{1,'+numSecOptions+'}', 'g'));
		} else {
			seqArray =  applyColor(questionColor).match(/.{4}|.{1,2}/g); 
		}			

		//LEAVE THE CORRECT OPTIONS IN THEIR CURRENT POSITIONS
		$('.qOpt').each(function(index){
			$(this).attr('orig_pos', index)
			if($(this).hasClass("correctOption")){
				tempArray[$(this).attr('orig_pos')] = $(this)
			}
		});
		//MOVE THE INCORRECT OPTIONS TO CORRECT POSITIONS
		$('.qOpt').each(function(index){
			if($(this).hasClass("incorrectOption")){
				var corPos = seqArray[$(this).attr('q_id')].split("");
        for(var i = 0; i<corPos.length;i++){
        	if(corPos[i] == 1 && tempArray[i]==undefined){
        		tempArray[i] = $(this)
        		break;
        	}
        }
			}
		});
   	return tempArray;
};

//+++++++++++++++++++++++++++ sortMyAnswer() +++++++++++++++++++++++++++++++++++
// Reorder the options into the first correct sequence you come across.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function sortMyAnswer(){
		tempArray = new Array($(".qOpt").length);
		seqArray = applyColor(questionColor).match(/.{4}|.{1,2}/g); 

		$('.qOpt').each(function(index){
			tempArray[$(this).attr('orig_pos')] = $(this)
    });
   	return tempArray;
}

//+++++++++++++++++++++++++++ turnOnIndicator() +++++++++++++++++++++++++++++++++
// Debugging function to turn on the correct answer indicator for testing.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function turnOnIndicator(){
	if ((question_type=="MAMC") || (question_type=="MCG") || (question_type=="SAMC")) {
		var answer_style = applyColor(questionColor).split("");
		$(".optBox .qOpt").each(function(idx) {
			islDebug("parseInt($(this).attr('q_id')) "+parseInt($(this).attr('q_id')))
			answersStyle($(this));
		})
	}
    
    if ((question_type=="MAMC_HS") || (question_type=="SAMC_HS")) {
	    var answer_style = applyColor(questionColor).split("");
		$(".hs").each(function(idx) {
			answersStyle($(this));
		});
    }
	
	if (question_type=="GRID"){
		var answer_style = applyColor(questionColor).split("");
		$("#grid tbody td:not(:first-child)").each(function(index){
			answersStyle($(this));
		})
	}

	if (question_type=="GRID_MULTI"){
		 var answer_style = eval($("#questionPanel").attr("qstyle").split("#")[1]);
		$("#grid tbody td:not(:first-child)").each(function(index){
			answersStyle($(this));
		})
	}
	
	if (question_type=="SEQ"){
		seqArray = applyColor(questionColor).match(/.{4}|.{1,2}/g); 
		$(".qOpt").each(function(index) {
			var textString = seqArray[$(this).attr('q_id')];
			var indicator_string = "";
			for(var i=0; i<textString.length; i++){
				indicator_string = (parseInt(textString[i])==1)? indicator_string+(i+1)+" " : indicator_string
			}
			$(this).append("<div class=\"seq_indicator\">"+indicator_string+"</div>")
		});
	}
	
	function answersStyle(obj) {
		if(answer_style[parseInt(obj.attr('q_id'))] == 1){
			obj.addClass("mc_correct");
		}else if(answer_style[parseInt(obj.attr('q_id'))] == 0){
			obj.addClass("mc_incorrect");
		}
	}
}

/************************************************************************************/
/************************** ADDITIONAL FUNCTIONS ************************************/
/************************************************************************************/
function checkBin(n){return/^[01]{1,64}$/.test(n)}
function checkHex(n){return/^[0-9A-Fa-f]{1,64}$/.test(n)}
function Bin2Hex(n){if(!checkBin(n))return 0;return parseInt(n,2).toString(16)}
function Hex2Bin(n){if(!checkHex(n))return 0;return parseInt(n,16).toString(2)}

function getFiller(num){
	var numElements = 6-(num+1);
	var letters = '0123456789abcdef'.split('');
	var str = '';
  for (var i = 0; i < numElements; i++ ) {
      str += letters[Math.round(Math.random() * 15)];
  }
  return str;
}

function applyColor(color){
	var str = Hex2Bin(color.slice(1,color.lastIndexOf("g")))
	return str.slice(1, str.lastIndexOf(colorbuffer));
}

/************************************************************************************/
/************************* QUESTION LEVEL TRACKING **********************************/
/************************************************************************************/
function updateQuestionLevelTracking(qState){
	var numInteractions = doLMSGetValue("cmi.interactions._count");
	
	//cmi.interactions.0.id
	var qID = currentPage.src.split(".htm")[0];
	
	//cmi.interactions.0.type
	switch(question_type.toLowerCase()){
		case "samc":
		var qType = "choice";
		break;
		case "samc_if":
		var qType = "choice";
		break;
		case "mamc":
		var qType = "choice";
		break;
		case "mcg":
		var qType = "choice";
		break;
		case "samc_hs":
		var qType = "choice";
		break;
		case "mamc_hs":
		var qType = "choice";
		break;
		case "grid":
		var qType = "choice";
		break;
		case "seq":
		var qType = "choice";
		break;
	}
	
	//cmi.interactions.0.objectives.0.id
	//Not needed in Falcon
	
	//cmi.interactions.0.timestamp
	var today = new Date();
	var seconds = today.getSeconds();
	var minutes = today.getMinutes();
	var hours = today.getHours();
	var date = today.getDate();
	var month = today.getMonth()+1;
	var year = today.getFullYear();
	
	month  = (month < 10)? "0"+ month: month;
	date  = (date < 10)? "0"+ date: date;
	hours  = (hours < 10)? "0"+ hours: hours;
	minutes = (minutes < 10)? "0"+ minutes: minutes;
	seconds = (seconds < 10)? "0"+ seconds: seconds;
	
	//ISO 8601 EXAMPLE: 2007-01-18T22:10:35.84Z (http://www.timestampgenerator.com)
	var ISO8601_timestamp = year+"-"+month+"-"+date+"T"+hours+":"+minutes+":"+seconds+".84Z"
	var qTimeStamp = (delivery.toLowerCase() == "scorm2004")  ? ISO8601_timestamp : hours+":"+minutes+":"+seconds;
	
	//cmi.interactions.0.correct_responses.0.pattern
	if(question_type.toLowerCase() == "samc" || question_type.toLowerCase()=="samc_if" ||question_type.toLowerCase()=="mamc" ||question_type.toLowerCase()=="mcg"){
		var qCorrResp = applyColor(questionColor).split("");
	}else if(question_type.toLowerCase() == "samc_hs" || question_type.toLowerCase()=="mamc_hs"){
		var qCorrResp = applyColor(questionColor).split("");
	}else if(question_type.toLowerCase()=="grid"){
		var qCorrResp = applyColor(questionColor).split("");
	}else if(question_type.toLowerCase()=="seq"){
		var qCorrResp = applyColor(questionColor).split("");
	}else{
		var qCorrResp = applyColor(questionColor).split("");
	}
	
	//cmi.interactions.0.weighing
	//Not needed in Chameleon
	
	//cmi.interactions.0.learner_response
	if(question_type.toLowerCase() == "samc" || question_type.toLowerCase()=="samc_if" ||question_type.toLowerCase()=="mamc" ||question_type.toLowerCase()=="mcg"){
		qAnsArray = new Array($(".qOpt").length)
		$(".qOpt").each(function(index) {
				qAnsArray[parseInt($(this).attr('q_id'))] = ($(this).hasClass('tappedOpt')) ? 1 : 0
		});  
		var qLearnResp = qAnsArray.toString();
	}else if(question_type.toLowerCase() == "samc_hs" || question_type.toLowerCase()=="mamc_hs"){
		qAnsArray = new Array($(".hs").length)
		$(".hs").each(function(index) {
				qAnsArray[parseInt($(this).attr('q_id'))] = ($(this).hasClass('tappedOpt')) ? 1 : 0
		});  
		var qLearnResp = qAnsArray.toString();
	}else if(question_type.toLowerCase()=="grid"){
		qAnsArray = new Array($("#grid tbody td:not(:first-child)").length)
		$("#grid tbody td:not(:first-child)").each(function(index) {
			qAnsArray[parseInt($(this).attr('q_id'))] = ($(this).hasClass('selected')) ? 1 : 0
		});
		var qLearnResp = qAnsArray.toString();
	}else if(question_type.toLowerCase()=="seq"){
		qAnsArray = new Array($(".qOpt").length)
		seqArray =  applyColor(questionColor).match(/.{4}|.{1,2}/g);
		$(".qOpt").each(function(index) {
			qAnsArray[parseInt($(this).attr('q_id'))] = (parseInt(seqArray[$(this).attr('q_id')].split("")[index])==1) ? 1 : 0
		});
		var qLearnResp = qAnsArray.toString();
	}
	
	//cmi.interactions.0.result
	var qResult = (qState) ? "correct" : "wrong"
	
	//cmi.interactions.0.latency
	var elapsedTime = new Date().getTime() - parseInt($("#questionPanel").attr('startTime'));
	var qLatency = convertSecondsToHHMMSS(Math.round(elapsedTime/1000))
	
	//cmi.interactions.0.description
	//var qDesc = localContentLevel.question_text_1; //description isn't supported in SCORM 1.2

	islDebug("updateQuestionLevelTracking - intNo: "+numInteractions,"#00ff00");
	islDebug("updateQuestionLevelTracking - qID: "+qID,"#00ff00");
	islDebug("updateQuestionLevelTracking - qTimeStamp: "+qTimeStamp,"#00ff00");
	islDebug("updateQuestionLevelTracking - qType:"+qType,"#00ff00");
	islDebug("updateQuestionLevelTracking - qCorrResp:"+qCorrResp,"#00ff00");
	islDebug("updateQuestionLevelTracking - qLearnResp:"+qLearnResp,"#00ff00");
	islDebug("updateQuestionLevelTracking - qResult:"+qResult,"#00ff00");
	islDebug("updateQuestionLevelTracking - qLatency:"+qLatency,"#00ff00");
	
	scorm_interactionsData(numInteractions, qID, qTimeStamp, qType, qCorrResp, qLearnResp, qResult, qLatency);	
}

function convertSecondsToHHMMSS(intSecondsToConvert) {
	var minutes = getRemainingMinutes(intSecondsToConvert);
	minutes = (minutes == 60) ? "00" : minutes;
	minutes = (minutes < 10)? "0"+ minutes: minutes;
	var seconds = getRemainingSeconds(intSecondsToConvert);
	seconds = (seconds < 10)? "0"+ seconds: seconds;
	if(delivery.toLowerCase() == "scorm2004"){
		return "PT"+minutes+"M"+seconds+"S";
	}else{
		return "00:"+minutes+":"+seconds;  //are we always assuming 0 hours?
	}
}

function convertMinutes(intSeconds) {
	return Math.floor(intSeconds/60);
}

function getRemainingSeconds(intTotalSeconds) {
	return (intTotalSeconds%60);
}

function getRemainingMinutes(intSeconds) {
	var intTotalMinutes = convertMinutes(intSeconds);
	return (intTotalMinutes%60);
}
