/*
Copyright  Interactive Services 2013 - 2015 All Rights Reserved.  
No part of this code may be used, with or without modification, without prior consent from Interactive Services. 
Version 2.1, 01 March 2015
*/

var profilerUsed = false

//++++++++++++++++++++++++++++ rebuildCourseUsingProfile +++++++++++++++++++++++++
// This function is called by the profile button - it takes in the defined rebuildCourseUsingProfile
// and recreates the structure file with the new profile. It removes screens/nodes
// that have different profiles.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function rebuildCourseUsingProfile(profile) {
	if(lmsVariables.userProfile==undefined || islProfile.useProfile == false){
		showWarning("Please ensure that the profiler is turned on:<br/><br/><i>islProfile.useProfile = true</i><br/><br/>The profiler cannot work without an lmsVariable called userProfile. Please add this to the lmsVariable object in settings.js<br/><br/> <i>lmsVariables.userProfile=\"\"\;</i><br/><br/>","warning");
	}
	
	lmsVariables.userProfile = profile;
	if(currentPage !=""){
		var currentPageSRC = currentPage.src
	}
	//islDebug("[[ REBUILDING COURSE USING PROFILE KEY: "+profile+"]]","#FF00FF");
	if(profilerUsed){ //not needed the first time as the structure is in its default state.
		delete course.subNodes
		if (structure.groupnode != undefined && structure.groupnode.length > 0){
			for (var i=0; i < structure.groupnode.length; i++){
				parseGroupNode(structure.groupnode[i], course, 0);
			}
		}else if(structure.groupnode != undefined){
			parseGroupNode(structure.groupnode, course, 0);
		}
	}

	scanForProfile(course, profile);

	menu_string = "";
	initMenu();
	pageNumber = 0 //For the buildPageCount function to start from the start.
	if(profilerUsed) {
		buildExamNodes();
	}else{
		buildPageCount(course);
	}

	profilerUsed = true;
	return;
}

//++++++++++++++++++++++++++++ scanForProfile ++++++++++++++++++++++++++++++++++++
// Recursive function to scan through the pages and nodes in a course and match
// them against a profile. If the profile is found then use that profile.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function scanForProfile(obj, the_profile){
	var tempProfile = the_profile.split(",");
	
	//CHECK THE NODES OF THE COURSE FOR THE PROFILE TAG AND THEN VERIFY IF THE PROFILE NEEDS THIS NODE
	if(obj.profile != undefined){
		var curProfile = obj.profile.split(",")
		var isProfile = false
		for(var j=0; j <tempProfile.length; j++){
			for(var e = 0; e<curProfile.length; e++){
				if(tempProfile[j] == curProfile[e]){
					isProfile = true;
					break;
				}
			}
		}	

		if(!isProfile){
			removeNode(obj);
		}
	}
	
	//CHECK THE PAGES OF THE NODE FOR THE PROFILE TAG AND THEN VERIFY IF THE PROFILE NEEDS THIS PAGE
	if (obj.pageNodes != undefined && obj.pageNodes.length > 0){
		for (var i=0; i < obj.pageNodes.length; i++){
			if(obj.pageNodes[i].profile != undefined){
				var curProfile = obj.pageNodes[i].profile.split(",")
				var isProfile = false
				for(var j=0; j <tempProfile.length; j++){
					for(var e = 0; e<curProfile.length; e++){
						if(tempProfile[j] == curProfile[e]){
							isProfile = true;
							break;
						}
					}
				}
				if(!isProfile){
					removePageNode(obj.pageNodes[i])
				}
			}
		}	
	}
	
	//COMPLETE THE RECURSIVE SCAN
	if (obj.subNodes != undefined && obj.subNodes.length > 0){
		obj.tempNode = new Array();
		for (var k=0; k < obj.subNodes.length; k++){
			islDebug("=========== "+obj.subNodes[k].id)
			obj.tempNode.push(obj.subNodes[k].id)
		}
		
		for (var k=0; k < obj.tempNode.length; k++){
			islDebug("++++++++++++ "+obj.tempNode[k])
			scanForProfile(findObjectById(obj, obj.tempNode[k]), the_profile); 
		}
	}  
}


//++++++++++++++++++++++++++++ removePageNode ++++++++++++++++++++++++++++++++++++
// Function to remove specific pages from a node.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function removePageNode(pageObj) {
	//islDebug("[[ATTEMPTING TO REMOVE PAGE: "+pageObj.src+"]]")
	var nodeLength = pageObj.parent.pageNodes.length;
	if (nodeLength == 1) {
		removeNode(pageObj.parent);
	} else {
		//islDebug("REMOVING: "+pageObj.src,"#ff00ff");
		//Take all the existing pages and remove them from the Node and store them in a temp array
		var temp_array = new Array();
		for (var j = 0; j<nodeLength; j++) {
			temp_array.push(pageObj.parent.pageNodes.pop());
		}
		//reverse the array so they are in the correct order.
		temp_array.reverse();
		//Scan through the temp array and add the required pages back into the node
		for (var i = 0; i<temp_array.length; i++) {
			if(temp_array[i]!=pageObj){
				pageObj.parent.pageNodes.push(temp_array[i]);
			}
		}
		//Index the pages correctly again.
		for (var i = 0; i<pageObj.parent.pageNodes.length; i++) {
			pageObj.parent.pageNodes[i].index = (i+1);
		}
	}
}

//++++++++++++++++++++++++++++ removeNode ++++++++++++++++++++++++++++++++++++++++
// Function to remove specific groupNodes from the course structure.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function removeNode(obj) {
	//islDebug("[[ATTEMPTING TO REMOVE NODE: "+obj.id+"]]")
	var nodeLength = obj.parent.subNodes.length;
	if (nodeLength == 1) {
		removeNode(obj.parent);
	} else {
		//islDebug("REMOVING: "+obj.id,"#ff00ff");
		var temp_array = new Array();
		//Take all the existing Nodes and remove them from the course and store them in a temp array		
		for (var j = 0; j<nodeLength; j++) {
			temp_array.push(obj.parent.subNodes.pop());
		}
		temp_array.reverse();
		
		//Scan through the temp array and add the required nodes back into the course
		for (var i = 0; i<temp_array.length; i++) {
			if(temp_array[i]!=obj){
				obj.parent.subNodes.push(temp_array[i]);
			}
		}
		//Index the pages correctly again.
		for (var i = 0; i<obj.parent.subNodes.length; i++) {
			obj.parent.subNodes[i].index = (i+1);
		}
	}
}
