/*
Copyright © Interactive Services 2013 - 2015 All Rights Reserved.  
No part of this code may be used, with or without modification, without prior consent from Interactive Services. 
Version 2.1, 01 March 2015
*/

var definedHeight = null;
var tEvent="click";
var interfaceOffset;
var interfaceBottomOffset;
var phone_interfaceBottomOffset;

//++++++++++++++++++++++++++++++++++ ANDROID DETECTION ++++++++++++++++++++++++++++++++++
var webkitVer = parseInt((/WebKit\/([0-9]+)/.exec(navigator.appVersion) || 0)[1],10) || void 0; // also match AppleWebKit
var isAndroid = (webkitVer>=537 || webkitVer==undefined) ? false : true

function loadToolsPopup(resourceToLoad,btn) {
	if(audioAsked==0) return;
	//if(videoPlaying) pauseVideo();
	
	switch(resourceToLoad.toLowerCase()){
		case "menu":
			closeOpenComponent()
			updateMenuProgressIndicators();
			addBlackOut("all");
			$("#menu_Panel").show();
			resizeMenu();
			
			if(onPhoneCourse){
				TweenMax.to($("#menu_Panel"), 0.5, {left:"50%", startAt:{left:"-50px"}, ease:Back.easeOut});
			}else if(!isIE8){
				TweenMax.to($("#menu_Panel"), 0.5, {left:"50%", startAt:{left:"-550px"}, ease:Back.easeOut});
			}
			sim_audioBtnPressed();
			toggleVideo("pause");
		break;
		case "resources":
			if(btn.hasClass("currentPU")){
				btn.removeClass("currentPU")
				TweenMax.to($("#resources_Panel"), 0.5, {left:"-2500px", ease:Back.easeOut});
				sim_audioBtnPressed();
				removeBlackOut();
			}else{
				closeOpenComponent()
				btn.addClass("currentPU")
				if(onPhoneCourse){
					$("#resources_Panel").addClass("compPhone")
					$("#resources_Panel").draggable('disable');
				}
				$("#resources_Panel").show();
				if(onPhoneCourse){
					addBlackOut("all");
					TweenMax.to($("#resources_Panel"), 0.5, {left:"50%", startAt:{left:"-50px", display:'block'}, ease:Back.easeOut});
				}else{
					var offestPosLeft = $(".topBtns").offset().left + $(".topBtns").width()
					var offestPosTop = $(".topBtns").offset().top + $(".topBtns").height()
					TweenMax.to($("#resources_Panel"), 0.5, {left:offestPosLeft+"px", top:offestPosTop+"px", startAt:{left:"-50px", top:offestPosTop+"px"}, ease:Back.easeOut});
				}
				if(!$(".audioBtn").hasClass("component_paused"))sim_audioBtnPressed();
			}
		break;
		case "glossary" :
			if(btn.hasClass("currentPU")){
				btn.removeClass("currentPU")
				TweenMax.to($("#glossary_Panel"), 0.5, {left:"-2500px", ease:Back.easeOut});
				sim_audioBtnPressed();
			}else{
				closeOpenComponent()
				$(".topBtns > #glossary").addClass("currentPU")
				if(onPhoneCourse){
					$("#glossary_Panel").addClass("compPhone")
					$("#glossary_Panel").draggable('disable');
				}
				$("#glossary_Panel").show();
				if(onPhoneCourse){
					addBlackOut("all");
					TweenMax.to($("#glossary_Panel"), 0.5, {left:"50%", startAt:{left:"-50px", display:'block'}, ease:Back.easeOut});
				}else{
					var offestPosLeft = $(".topBtns").offset().left + $(".topBtns").width();
					var offestPosTop = $(".topBtns").offset().top + $(".topBtns").height();
					TweenMax.to($("#glossary_Panel"), 0.5, {left:offestPosLeft+"px", top:offestPosTop+"px", startAt:{left:"-50px", top:offestPosTop+"px"}, ease:Back.easeOut});
				}
				if(!$(".audioBtn").hasClass("component_paused"))sim_audioBtnPressed();
			} 
		break;
		case "transcript" :
			if(btn.hasClass("openTranscript")){
				$("#centreContent").removeClass("trans_open");
				btn.removeClass("openTranscript")
				TweenMax.to($("#transcript_Panel"), 0.5, {left:"-2500px", ease:Back.easeOut});
			}else{
				$("#centreContent").addClass("trans_open")
				if(onPhoneCourse){
					$("#transcript_Panel").draggable('disable');
				}
				
				btn.addClass("openTranscript")
				removeBlackOut();
				$("#transcript_Panel").show();
				if(onPhoneCourse){
					TweenMax.to($("#transcript_Panel"), 0.5, {left:"0%", startAt:{left:"-150px", display:'block'}, ease:Back.easeOut});
				}else{
					var offestPosLeft = $(".topBtns").offset().left + $(".topBtns").width();
					var offestPosTop = $(".topBtns").offset().top + $(".topBtns").height();
					TweenMax.to($("#transcript_Panel"), 0.5, {left:offestPosLeft+"px", top:offestPosTop+"px", startAt:{left:"0px", top:offestPosTop+"px", display:'block'}, ease:Back.easeOut});
				}
			} 
		break;
		default:
		break;
	}
}

function closeOpenComponent(){
	if($(".compPhone").length){
		$(".compPhone").removeClass("compPhone")
	}
	
	$(".currentPU").each(function(){
		$(this).removeClass("currentPU")
		TweenMax.to($("#"+$(this).attr("id")+"_Panel"), 0.5, {left:"-2500px", ease:Back.easeOut});
	});
	if($("#menu_Panel").css("display")!="block"){
		removeBlackOut();
	}
	if($(".audioBtn").hasClass("component_paused"))sim_audioBtnPressed();
}

// Disable caching of AJAX responses
$.ajaxSetup ({
    cache: false
});


function resetPauseBtn(){
	$(".audioBtn").removeClass("paused");
}

//+++++++++++++++++++++++++++++++ resizeWindowCheck() ++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Resize the center content container and the wrapper to fit the max height of the content.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function resizeWindowCheck(){
	if($('.phonePanel')!=undefined){
		onPhoneCourse = ($('.phonePanel').css("display")=="table") ? true : false
	}

	var topHeight = (onPhoneCourse) ? 0 : interfaceOffset
	var bottomHeight = (onPhoneCourse) ? phone_interfaceBottomOffset : interfaceBottomOffset
	
	//RESIZE INDIVIDUAL ELEMENTS OF TEMPLATES
	if($("#wrapper").data('screen_type')!= undefined && $("#wrapper").data('screen_type')== "timeline"){
		checkContainerSize()
	}else if($("#wrapper").data('screen_type')!= undefined && $("#wrapper").data('screen_type')== "slideshow"){
		updateSlideshowHeights()
	} else if($("#wrapper").data('screen_type')!= undefined && $("#wrapper").data('screen_type')== "multi_question"){
		updateMultiquestionHeight();
	} else if($("#wrapper").data('screen_type')!= undefined && $("#wrapper").data('screen_type')== "scenario"){
		update_scenarioHolder_height();
	} else if($("#wrapper").data('screen_type')!= undefined && $("#wrapper").data('screen_type')== "dragdrop") {
		match_dragdrop_sizes();
	} else if($(".cb_elements").length > 0){
		upDateConversationHeight();
	} else if($(".qSlideHolder").length > 0){
		resizeQuestionSlides();
	}
	getDeviceInfo();

	//RESIZE THE VIEWING WINDOW
	$("#wrapper").css("min-height", "0px");
	definedHeight = $('body').height() - topHeight - bottomHeight;
	
	var definedMaxHeight = ($(".centreContentContainer").css("max-height")!= undefined && $(".centreContentContainer").css("max-height")!="none") ? parseInt($(".centreContentContainer").css("max-height").split("px")[0]): 0;
	definedHeight = (definedMaxHeight < definedHeight && definedMaxHeight!=0) ? definedMaxHeight : definedHeight

	
	if (jscd.os == "iOS" && jscd.browserVersion.substring(0, jscd.browserVersion.indexOf('.')) >= 8) {
		$("body").addClass("iOS8").scrollTop(-1)
	} else {
		$(".centreContentContainer").css("height", definedHeight+"px");
	}
	
	var wrapperHeight = ($("#wrapper").height() < $('.centreContentContainer').height() && $("#wrapper").height() !=0) ? $("#wrapper").height() : $('.centreContentContainer').height()
	$("#wrapper").css("min-height", wrapperHeight+"px");
	
	//RESIZE THE MENU
	if($("#menu_Panel").css("display")=="block"){
		resizeMenu();
	}
	
	//CONTROL THE TRANSCRIPT
	if($("#transcript_Panel").css("display")=="block"){
		positionTranscript();
	}
	
	if($(".currentPU").length > 0 && !onPhoneCourse){
		$("#"+$(".currentPU").attr("id")+"_Panel").css('left', "100%");
	}
}


function is_touch_device() {
	return ("ontouchstart" in document.documentElement);
}


$(document).ready(function() {
	$(window).bind("orientationchange resize", resizeWindowCheck);
	resizeWindowCheck();
	
	//CODE TO DISABLE A RIGHT CLICK ON AN IMAGE TO STOP PEOPLE TAKING A COPY OF THE IMAGE
	$('body').on('contextmenu', 'img', function(e){
		if(disableImages) return false; 
	}); 
	
	if (is_touch_device()) {
		$('body').addClass("touchdevice");
	}
	
	//Load the resources - TEMP NEED TO MOVE TO PROPER LOCATION
	$("#resources_Panel").empty().load("tools/resources.html",function() {
		dragItems();
		closeToolsBtn($("#resources_Panel").find(".closeTools"));
	});
	
	$("#glossary_Panel").empty().load("tools/glossary.html",function() {
		dragItems();
		closeToolsBtn($("#glossary_Panel").find(".closeTools"));
		$("div.glossary_item").bind("click touch",function(e) {
			openGlossaryItem($(this))
			e.stopPropagation();
			e.preventDefault();
		});
		$("div.glossary_item:first").click();
		setupMobileGlossary();
	});
	
	$("#menu_Panel").empty().load("tools/menu.html",function() {
		$(".closeButton").bind("click touch", closeMenu);	
	});
	
	//Add the functionality to the Transcript component:
	$(".closeTranscript").bind("click touch",function(e) {
		closeTranscript();
		e.stopPropagation();
		e.preventDefault();
	});
	
	
	//setupZoom()
	

/* Hide popup panel and revert to load state when "Next" button clicked 

	$("#popupPanel > input").bind("mouseup",function(e) {
		hidePopupPanel();												 
	});
	
	$("#popupPanel > img").bind("mouseup",function(e) {
		if(cs_question == "off"){
			$(".tappedOpt").removeClass("tappedOpt");
			var func = $("#questionPanel").attr("btn_func");
			hidePopupPanel();
			if(func == "retry"){
				//hidePopupPanel();
			}else if(func == "complete"){
				goNext();
			}
			e.preventDefault();
			e.stopPropagation();
		}else{
			$(".tappedOpt").removeClass("tappedOpt");
			fbColour=$(this).attr("src");
			$(".tapped").removeClass("tapped");
			if ($("#sortable").length==0) {
				$("input[type=submit]").attr("disabled","disabled");
			}
			e.preventDefault();
			e.stopPropagation();
			if (fbColour.indexOf("_red")===-1) {
				//p=getNextPage();
				var jumpToPage = $("#popupPanel").attr("targetpage");
				var pageObj = findPageBySrc(course , jumpToPage);
				loadPage(pageObj);
			}
			hidePopupPanel();
		}
  });
  
	$("#zoomButtons li").bind(tEvent,function() {
		t=$(this).index();
		if (t==3) {
			$("#resetZoom").trigger(tEvent);
			$("#zoomButtons").addClass("hidden");
			$("#panImage").addClass("hidden");
			$("#panImage img").css({width:"100%"});
			$("#panImage img").attr("src","");
			$("#outZoom").addClass("disabled")
			$("#resetZoom").addClass("disabled")
		} else {
			z=1;
			if (t==0) z+=0.5;
			else if (t==1) z-=0.5;
			else if (t==2) z=0;
			setTimeout("scaleImage("+z+")",500);
		}
	});*/
	

/* Hide pan image panel & closeX when "closeX" clicked 
	$("#closeX").bind(tEvent,function(e) {
		$('#vid_overlay').removeAttr('vidRef');
		closeVideo();
		e.stopPropagation();
		e.preventDefault();
	});
	
	$("#navButtons a.img").hover(function() {
		if ($(this).is(".disabled")) return;
		o=$(this).find("img");
		s=o.attr("src");
		s=s.replace(".png","_over.png");
		o.attr("src",s);
		$(this).addClass("hovered");
	},function() {
		if ($(this).is(".disabled")) return;
		o=$(this).find("img");
		s=o.attr("src");
		s=s.replace("_over.png",".png");				   
		o.attr("src",s);
		$(this).removeClass("hovered");
	});*/
	
	
});




function isMobile() {
	islDebug("navigator.userAgent.: "+navigator.userAgent)
	mobile = ['iphone','ipad','android','blackberry','nokia','opera mini','windows mobile','windows phone','iemobile']; 
	var tempIsMobile = false
	
	for(var i=0; i<mobile.length; i++){
		if (navigator.userAgent.toLowerCase().indexOf(mobile[i].toLowerCase()) > 0){
			tempIsMobile = true;
		}
	}
	
	return tempIsMobile;
}

//+++++++++++++++++++++++++++++++++++++ showAnswers ++++++++++++++++++++++++++++++++++++++++++
// Debugger function to turn on|off the correct answer indicators on the questions.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function showAnswers(){
	answerindicator = (answerindicator==true) ? false : true
	goReplay();
}

//+++++++++++++++++++++++++++++++++++++ showTracking +++++++++++++++++++++++++++++++++++++++++
// Debugger function to turn on|off the tracking panel in the debugger.  When the panel is
// in view it updates the values with the variables from the settings.xml file so the developer
// can see what delivery settings are in place.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function showTracking(){
	if ($("#trackingBtn").hasClass("active")) {
		$("#trackingBtn").removeClass("active");
	} else {
		$("#trackingBtn").addClass("active");
		if ($("#tracersBtn").hasClass("active")) {
			$("#tracersBtn").removeClass("active")
		}
	}
	if($('#tracers').is(":visible")){
		$('#tracers').toggle('fast');
	}
	$('#tracking').toggle('fast', function (){
		displayTrackingSettings();
	});
	return false;
}

//+++++++++++++++++++++++++++++++ updateTrackingSettings +++++++++++++++++++++++++++++++++++++
// Debugger function to update the tracking settings with the ones that the developer has 
// defined here.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function updateTrackingSettings(){
	islCompletion.manual_complete = $('input:radio[name=man_complete]:checked').val();
	islCompletion.pre_assessment = $('input:radio[name=pre_ass_rad]:checked').val();
	islCompletion.post_assessment = $('input:radio[name=post_ass_rad]:checked').val();
	
	islCompletion.page_views = 	parseInt($('#page_views').val());
	islCompletion.pre_exam_passmark	= parseInt($('#pre_ass_setting').val());
	islCompletion.post_exam_passmark = parseInt($('#post_ass_setting').val());
	
	$('#tracking').toggle('fast', function (){
		$('#tracking').toggle('fast', function(){
			displayTrackingSettings();
		});
	});
	
}

function displayTrackingSettings(){
		
		var radioGrp1 = $('input:radio[name=man_complete]');
		var radioGrp2 = $('input:radio[name=pre_ass_rad]');
		var radioGrp3 = $('input:radio[name=post_ass_rad]');
		
		$('#man_complete_setting').val(islCompletion.manual_complete);
		if(islCompletion.manual_complete.toLowerCase()=="off"){
			radioGrp1.filter('[value=off]').prop('checked', true);
			$("#manCompleteRow").css("background-color", "transparent");
		}else if(islCompletion.manual_complete.toLowerCase()=="on"){
			radioGrp1.filter('[value=on]').prop('checked', true);
			$("#manCompleteRow").css("background-color", "#E0B362");
		}
		
		$('#page_views').val(islCompletion.page_views);
		if(islCompletion.page_views >0){
			$("#pageViewsRow").css("background-color", "#E0B362");
		}else{
			$("#pageViewsRow").css("background-color", "transparent");
		}
		
		$('#pre_ass_setting').val(islCompletion.pre_exam_passmark);
		if(islCompletion.pre_assessment.toLowerCase()=="off"){
			radioGrp2.filter('[value=off]').prop('checked', true);
			$("#preAssessmentRow").css("background-color", "transparent");
		}else if(islCompletion.pre_assessment.toLowerCase()=="on"){
			radioGrp2.filter('[value=on]').prop('checked', true);
			$("#preAssessmentRow").css("background-color", "#E0B362");
		}
		
		$('#post_ass_setting').val(islCompletion.post_exam_passmark);
		if(islCompletion.post_assessment.toLowerCase()=="off"){
			radioGrp3.filter('[value=off]').prop('checked', true);
			$("#postAssessmentRow").css("background-color", "transparent");
		}else if(islCompletion.post_assessment.toLowerCase()=="on"){
			radioGrp3.filter('[value=on]').prop('checked', true);
			$("#postAssessmentRow").css("background-color", "#E0B362");
		}
}


function showTracers(){
	if ($("#tracersBtn").hasClass("active")) {
		$("#tracersBtn").removeClass("active");
	} else {
		$("#tracersBtn").addClass("active");
		if ($("#trackingBtn").hasClass("active")) {
			$("#trackingBtn").removeClass("active")
		}
	}
	if($('#tracking').is(":visible")){
		$('#tracking').toggle('fast');
	}
	$('#tracers').toggle('fast');
	return false;
}

function isortBrowser() {
	if(jQuery("#b_info")) { 
		jQuery("#b_info").val(jscd.browser + ' ' + jscd.browserVersion + ' OS. ' + jscd.os + ' ' + jscd.osVersion + ' Screen: ' + jscd.screen); return true; 
	} else {
		return false; 
	}
}

function browserNotSupported(){
	getDeviceInfo();
	for (var i = 0; i < browsers.length; i++) {
		var browserVer = jscd.browserVersion.substring(0, jscd.browserVersion.indexOf('.'));
		function displayMessage(version) {
			if (jscd.browser == "Microsoft Internet Explorer" && document.documentMode != browserVer){
				$("#errorOverlay").removeClass("invisible").load("tools/compatibility_warning.html");
				$("#error_msg").html(errorBrowser2 + " " + browsers[i][0] + " " + version + ".<br/><br/>" + errorBrowser3 + " " + browsers[i][0] + " " + browsers[i][1] + " or above. " + errorBrowser4 + "<br/><br/>" + errorBrowser5);
			}
			else {
				$("#error_msg").html(browsers[i][0] + " " + version + " detected!<br/><br/>" + errorBrowser1 + browsers[i][0] + " " + browsers[i][1]);
			}
			$("#displayError").removeClass("invisible");
			$("#error_header").html(txt_label_warning);
		}

		if (jscd.browser == browsers[i][0]){
			if (browsers[i][0] == "Microsoft Internet Explorer" && document.documentMode != browserVer) {
				if (parseInt(browserVer) < parseInt(browsers[i][1])) {

					if (document.documentMode < browserVer) {
						displayMessage(document.documentMode);
					}
					else {
						displayMessage(browserVer);
					}
					return;
				}
				else if (document.documentMode < parseInt(browsers[i][1])) {
					displayMessage(document.documentMode);
					return;
				}
			}
		 	else if (parseInt(browserVer) < parseInt(browsers[i][1])) {
		 		displayMessage(browserVer);
		 	}
		}
	}
	browser_notification = false;
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//++++++++++++++++++++++++++++++++ close_feedback_overlay() +++++++++++++++++++++++++++++++++++++++++++++++
// This is for the question feedback overlay that is used in the phone sized deployment
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function close_feedback_overlay(guiBtnView){
	//if(!onPhoneCourse) return false
	guiBtnView = (guiBtnView==undefined) ? false : guiBtnView
	
	if(guiBtnView==true){
		$("#closeMobileFeedback_btn").addClass("invisible")
		$(".pFeedback").addClass("disabled");
	}
	
	var close_guiFeedback = new TimelineMax();
	close_guiFeedback.to($("#guiFeedback"), 0.5, {opacity:0, top:"50px", startAt:{opacity:1, top:"-12px"}, ease:Elastic.easeInOut});
	if(guiBtnView)close_guiFeedback.to($(".pFeedback"), 0.1, {opacity:0, startAt:{opacity:1}, ease:Elastic.easeInOut});
	close_guiFeedback.to($("#guiFeedback"), 0.1, {display:"none"});
	if(guiBtnView)close_guiFeedback.to($(".pFeedback"), 0.1, {display:"none"});
	
}

function open_feedback_overlay(alreadyOpen){
	$("#guiFeedbackHolder").css("display","block")
	$(".pFeedback").css("display","block")
	$("#guiFeedback").css("display","block")
	
	var open_guiFeedback = new TimelineMax();
	if(!alreadyOpen)open_guiFeedback.to($(".pFeedback"), 0.1, {opacity:1, startAt:{opacity:0}, ease:Elastic.easeInOut});
	open_guiFeedback.to($("#guiFeedback"), 1.0, {opacity:1, top:"-12px", startAt:{opacity:0, top:"50px"}, ease:Elastic.easeInOut});
}



function toggleMobileFeedback(){
	if(!onPhoneCourse) return false
	var feedbackOnScreen = ($('#guiFeedback').css("display").toLowerCase()=="block") ? true : false
	
	if(feedbackOnScreen){
		close_feedback_overlay(false);
	}else{
		open_feedback_overlay(true);
	}
}


/********************************************************************************************/
/*************************************  GLOSSARY  *******************************************/
/********************************************************************************************/
function openGlossaryItem(obj){
	$(".glossary_selected").removeClass("glossary_selected");
	obj.addClass("glossary_selected");
	$('#definition_area').scrollTop(0);
	$('#definition_area').empty().html(obj.attr("definition"));
}

function openGlossaryLink(targetItem){
	$(".glossary_item").each(function(){
		if($(this).html().toLowerCase() == targetItem.toLowerCase()){
			if($(".topBtns > #glossary").hasClass("currentPU")){
				openGlossaryItem($(this))
			}else{
				closeOpenComponent()
				$(".topBtns > #glossary").addClass("currentPU")
				if(onPhoneCourse){
					$("#glossary_Panel").addClass("compPhone")
					$("#glossary_Panel").draggable('disable');
				}
				$("#glossary_Panel").show();
				
				if(onPhoneCourse){
					addBlackOut();
					TweenMax.to($("#glossary_Panel"), 0.5, {left:"50%", startAt:{left:"-50px", display:'block'}, ease:Back.easeOut});
				}else{
					var offestPosLeft = $(".topBtns").offset().left + $(".topBtns").width();
					var offestPosTop = $(".topBtns").offset().top + $(".topBtns").height();
					TweenMax.to($("#glossary_Panel"), 0.5, {left:offestPosLeft+"px", top:offestPosTop+"px", startAt:{left:"-50px", top:offestPosTop+"px"}, ease:Back.easeOut});
				}
				openGlossaryItem($(this))
				if(!$(".audioBtn").hasClass("component_paused"))sim_audioBtnPressed();	
			}
		}
	});
}

function setupMobileGlossary(){
	var txtString="";
	$(".glossary_item_holder > div").each(function() {
		txtString+='<option>'+$(this).html()+'</option>';
	});
	$("#glossary_mobile_list").html(txtString);
	$("#glossary_mobile_list").bind("change",function() {
		openGlossaryLink($(this).val()) 
	});
}


function closeToolsBtn(btn){
	btn.bind("click touch",function(e) {
		if($(".compPhone").length){
			$(".compPhone").removeClass("compPhone")
			removeBlackOut();
		}
		sim_audioBtnPressed();
		closeOpenComponent();
		e.stopPropagation();
		e.preventDefault();
	});
}

function closeTranscript(){
	$("#centreContent").removeClass("trans_open");
	$(".openTranscript").removeClass("openTranscript")
	var close_transcript = new TimelineMax();
	close_transcript.to($("#transcript_Panel"), 0.5, {left:"-1000px", ease:Back.easeOut});
	close_transcript.set($("#transcript_Panel"), {display:"none"});
}

function positionTranscript(){
	if(onPhoneCourse){
		$("#transcript_Panel").draggable('disable');
		$('#transcript_Panel').attr('style', "");
		$('#transcript_Panel').css('display', "block");
	}else{
		$("#transcript_Panel").draggable('enable');
		$('#transcript_Panel').css('left',offestPosLeft+"px");
	}
}



function addBlackOut(blackOutType){
	if($(".centreContentContainer").find(".compBlackOut").length == 0){
		$(".centreContentContainer").append("<div class='compBlackOut'></div>")
		$(".centreContentContainer").addClass("blackOutOpen")
		
		if(blackOutType != undefined && blackOutType.toLowerCase()=="all"){
			$(".centreContentContainer").addClass("menuBlackOut");
		}
	}
}

function removeBlackOut(){
	if($(".centreContentContainer").find(".compBlackOut").length == 1){
		$(".centreContentContainer").find(".compBlackOut").remove();
		$(".centreContentContainer").removeClass("blackOutOpen").removeClass("menuBlackOut");
	}
}