/*
Copyright � Interactive Services 2013 - 2015 All Rights Reserved.  
No part of this code may be used, with or without modification, without prior consent from Interactive Services. 
Version 2.1, 01 March 2015
*/
$(document).ready(function() {
	setupCommonButtons();
});


function setupCommonButtons(){

	// click trigger for the enabled submit button on the profile screen
	$('#qProfileSubmit').bind( "click", function(event) {
		if(!$('#qProfileSubmit').hasClass('disabled')) {
			evaluateProfile();
		}
	});

	$('#btn_confirm').bind( "click", function(event) {
		manual_finish();
		$("#final_message").removeClass("invisible");
	});
	
	$('.commonBtn').unbind("click");
	$('.commonBtn').bind( "click", function(event) {
		
		launchControlledNavBtn($(this))
		if(courseAudio && audioAsked==1 && $(this).attr("audioFile")!=undefined){
			loadAudio($(this).attr("audioFile"));
		}else if(courseAudio && audioAsked==1 && $(this).attr("sfxFile")!=undefined){
			playSfxAudio($(this).attr("sfxFile"));
		}
		
		
		switch($(this).attr("id").toLowerCase()){
			case "t_branch_btn":
				var branchTarget = $(this).attr("targetBranch")
				if(branchTarget.indexOf(".html")==-1){
					var page =  getFirstPageOfGroup(findObjectById(course, branchTarget));
				}else{
					var page =  findPageBySrc(course, branchTarget);
				}
				loadPage(page);
			break;
			case "vid":
				if($(this).attr("videoTarget")=="overlay"){
					playVideo($(this).attr("targetvideo"), $(this).attr("videoTarget"))
				}else{
					playVideo($(this).attr("targetvideo"), $("#"+$(this).attr("videoTarget")))
				}
			break;
			case "doc":
				window.open($(this).attr("targetdoc"), "myDocumentName");
			break;
			case "bmark_yes":
				$("#bookmark_prompt").remove();
				removeBlackOut();
				var pageToLoad = findPageBySrc(course, jLessonLocation);
				loadPage(pageToLoad);
			break;
			case "bmark_no":
				$("#bookmark_prompt").remove();
				removeBlackOut();
				var pageToLoad = getFirstPageOfGroup(course);
				loadPage(pageToLoad);
			break;
			case "exit_yes":
				top.window.opener = top;
				top.window.open('','_self','');
				top.window.close();
			break;
			case "exit_no":
				$("#exitOverlay").addClass("invisible");
			break;
			case "audio_yes":
				$("#audioOverlay").remove();
				$("#audioPopupOverlay").remove();
				initAudio(true);
				loadfirstPage();
			break;
			case "audio_no":
				$("#audioOverlay").remove();
				$("#audioPopupOverlay").remove();
				initAudio(false);
				loadfirstPage();
			break;
			case "video_yes":
				$("#mediaLock").addClass("invisible");
				initAudio(true);
				goReplay();
			break;
			case "video_no":
				$("#mediaLock").addClass("invisible");
			break;
			case "closeerror":
				$("#displayError").addClass("invisible");
				$("#error_header").html("");
		 		$("#error_msg").html("");
			break;
			case "profile":
				//rebuildCourseUsingProfile($(this).attr("targetProfile"));
				showWarning(txt_label_noProfile,"message")
			break;
			case "printcert":
				printCert();
			break;
			case "popupbtn":
				//launchPopup($(this), "gs_pop");
				hsPopup($(this), $(this).attr("popupTarget"))
				break;
			case "popupconvers":
				popupConversation($(this));
				break;				
			case "popupclose":
				if($(this).hasClass("hs_exit")){
					hsClose();
				}else{
					closePopupOverlay();
				}
				break;
			case "submitstudentname":
				if ($("#studentName").val() == "") {
					$("#nameAlert").html("").html(txt_label_NameError).fadeIn("slow");
				}else {
					student_name = $("#studentName").val();
					window.open("tools/cert.html", "_blank");
					$("#certificatePrompt").addClass("invisible");
				}		
				break;
			case "cancelstudentname":
					$("#certificatePrompt").addClass("invisible");
				break;
			case "retryquiz":
				var page = getFirstPageOfGroup(currentPage.parent);
				loadPage(page);
				break;
			case "scormerrorbtn":
				errorOn = false;
				$("#scormError").addClass("invisible")
				break;
			case "revealbtn":
				$(this).hide();
				$("."+$(this).data("target")).css("visibility", "visible");
				TweenMax.from($("."+$(this).data("target")), 0.5, {opacity:0, x:"300px", ease:Back.easeOut});
			    resizeWindowCheck();
				break;
			case "gonext":
				goNext();
				break;
			case "gotoquestion":
				goQuestion();
				break;
			case "gotofeedback":
				goFeedback();
				break;
			default:
				showWarning("Unknown button: "+$(this).attr("id"),"error")
			break;
		}
		return
		event.preventDefault();
		event.stopPropagation();
  });
}

function checkRestrictedNav(){
	var btnCount = $(".controlnav").length
	if(btnCount == 1){
		updateCurrentPageProgress(2);
		updateGUI();
	}
}

function launchControlledNavBtn(obj){
	if($("#wrapper").hasClass("controlnav") && currentPage.progress!=2){
		obj.removeClass("controlnav")
		checkRestrictedNav();
	}
}

function closePopupOverlay() {
	$(".popupTarget.visible").removeClass("visible");
	
	$("#popupWindow").addClass("hidden");
	$("#popupWindow .popup_holder").html("");

	var defaultImage = $('.currentPopup').find("img.btnArrow").attr("default");
	$('.currentPopup').find("img.btnArrow").attr("src", defaultImage);
	$('.currentPopup').removeClass("currentPopup");
}

function hsPopup(obj, target){
	//Check if we are viewing the course on a phone
	onPhoneCourse = ($('.phonePanel').css("display").toLowerCase()=="table") ? true : false
	
	if ($("#wrapper").data("screen_type") != undefined && $("#wrapper").data("screen_type") == "hotspot") {
		obj.addClass("visitedSpot");
		$(".visitedSpot").css("border-color", obj.parent().data("spot_color"));
	}
	$('.currentPopup').removeClass("currentPopup");
	obj.addClass("tappedTick");
	obj.addClass("currentPopup");
	$('.currentPopup img.btnTick').css({visibility: "visible"});
	
	if($("#tempHolder").is(':empty')){
		$("#tempHolder").html($("#popupHolder").html());
	}
	
	var tarObj = $(target+" > div.popupTarget")
	launchControlledNavBtn(tarObj)
	
	if(!onPhoneCourse || ($("#wrapper").data("screen_type") != undefined && $("#wrapper").data("screen_type") == "hotspot") ){
		$(".inline_popup").each(function(index) {
			$(this).slideUp("slow", function() {
		    $(this).remove();
		  });
		});
		
		
		$("#popupHolder").empty();
		$("#popupHolder").html($(target).html())
		$("#popupHolder > div.popupTarget").css("display", "block");
		$("#popupHolder").addClass("popPad")
	
		run_gs_animation($("#popupHolder > div.popupTarget"), "gs_pop");
		setupCommonButtons();
		
		$("#popupHolder").find(".glossary_link").bind("click touch",function(e) {
			openGlossaryLink($(this).attr("glossary_target"))
			e.stopPropagation();
			e.preventDefault();
		});
		
		
	}else{
		$("#popupHolder").empty();
		$("#popupHolder").removeClass("popPad")
		$("#popupHolder").html($("#tempHolder").html());
		$('.currentPopup').removeClass("currentPopup");
		
		if(closeOpenPopups == true){
			$(".inline_popup").each(function(index) {
				$(this).slideUp("slow", function() {
			    $(this).remove();
			    $(".closepopoverlay").remove();
			  });
			});
		}
		
		if(obj.find(".inline_popup").length == 0){
			obj.unbind("click");
			obj.append("<div class='closepopoverlay'></div>")
			obj.find('.closepopoverlay').bind( "click touch", function(event) {
				obj.find(".inline_popup").slideUp( "slow", function() {
			    obj.find(".inline_popup").remove();
			    obj.find(".closepopoverlay").remove();
					obj.css("cursor", "pointer");
			    obj.bind( "click touch", function(event) {
						hsPopup($(this), $(this).attr("popupTarget"))
					}); 
			  });
			});
			obj.css("cursor", "default")
			obj.append("<div class='inline_popup'>"+$(target).html()+"</div>")
			obj.find(".inline_popup").css("width", obj.innerWidth())
			obj.find(".popupTarget").css("width", obj.innerWidth())
			obj.find(".inline_popup").slideDown("slow");
			
			obj.find(".glossary_link").bind("click touch",function(e) {
				openGlossaryLink($(this).attr("glossary_target"))
				e.stopPropagation();
				e.preventDefault();
			});
			
		}
	}
	return false;
}

function hsClose(){
	$("#popupHolder").empty();
	$("#popupHolder").removeClass("popPad")
	$("#popupHolder").html($("#tempHolder").html());
	$('.currentPopup').removeClass("currentPopup");
	setupCommonButtons();
}

function printCert(){
		the_date = certificateDate();
		if(student_name != "") {
			window.open("tools/cert.html", "_blank");
		}else {
			$("#certificatePrompt").removeClass("invisible");
		}	
}
function certificateDate(){
	currentDate = new Date();
    with(currentDate){  
      switch(getDay()){
        case 1:
        var the_day = "Monday"
        break;
        case 2:
        var the_day = "Tuesday"
        break;
        case 3:
        var the_day = "Wednesday"
        break;
        case 4:
        var the_day = "Thursday"
        break;
        case 5:
        var the_day = "Friday"
        break;
        case 6:
        var the_day = "Saturday"
        break;
        case 7:
        var the_day = "Sunday"
        break;
          }

      switch(getMonth()){
        case 0:
        var the_month = "January"
        break;
        case 1:
        var the_month = "February"
        break;
        case 2:
        var the_month = "March"
        break;
        case 3:
        var the_month = "April"
        break;
        case 4:
        var the_month = "May"
        break;
        case 5:
        var the_month = "June"
        break;
        case 6:
        var the_month = "July"
        break;
        case 7:
        var the_month = "August"
        break;
        case 8:
        var the_month = "September"
        break;
        case 9:
        var the_month = "October"
        break;
        case 10:
        var the_month = "November"
        break;
        case 11:
        var the_month = "December"
        break;
      }
          var the_date = the_day+", "+the_month+" "+ getDate()+", "+getFullYear();
    }
    return the_date;
}